# Code of Conduct

Hello, and welcome! 👋 

The Zig community is decentralized. Anyone is free to start and maintain their
own space for people to gather, and edit
[the Community wiki page](https://github.com/ziglang/zig/wiki/Community) to add
a link. There is no concept of "official" or "unofficial", however, each
gathering place has its own moderators and rules.

This is Andrew Kelley speaking. At least for now, I'm the moderator of the
ziglang organization GitHub repositories and the #zig IRC channel on Libera.chat.
**This document contains the rules that govern these two spaces only**.

The rules here are strict. This space is for focused, on topic, technical work
on the Zig project only. It is everyone's responsibility to maintain a positive
environment, especially when disagreements occur.

## Our Standards

Examples of behavior that contribute to creating a positive environment include:

 * Using welcoming and inclusive language.
 * Being respectful of differing viewpoints and experiences.
 * Gracefully accepting constructive criticism.
 * Helping another person accomplish their own goals.
 * Showing empathy towards others.
 * Showing appreciation for others' work.
 * Validating someone else's experience, skills, insight, and use cases.

Examples of unacceptable behavior by participants include:

 * Unwelcome sexual attention or advances, or use of sexualized language or
   imagery that causes discomfort.
 * Trolling, insulting/derogatory comments, and personal attacks. Anything
   antagonistic towards someone else.
 * Off-topic discussion of any kind - especially offensive or sensitive issues.
 * Publishing others' private information, such as a physical or electronic
   address, without explicit permission.
 * Discussing this Code of Conduct or publicly accusing someone of violating it.
 * Making someone else feel like an outsider or implying a lack of technical
   abilities.
 * Destructive behavior. Anything that harms Zig or another open-source project.

## Enforcement

If you need to report an issue you can contact me or Loris Cro, who are both
paid by the Zig Software Foundation, and so moderation of this space is part of
our job. We will swiftly remove anyone who is antagonizing others or being
generally destructive.

This includes Private Harassment. If person A is directly harassed or
antagonized by person B, person B will be blocked from participating in this
space even if the harassment didn't take place on one of the mediums directly
under rule of this Code of Conduct.

As noted, discussing this Code of Conduct should not take place on GitHub or IRC
because these spaces are for directly working on code, not for meta-discussion.
If you have any issues with it, you can contact me directly, or you can join one
of the community spaces that has different rules.

 * Andrew Kelley <andrew@ziglang.org>
 * Loris Cro <loris@ziglang.org>

## Conclusion

Thanks for reading the rules. Together, we can make this space welcoming and
inclusive for everyone, regardless of age, body size, disability, ethnicity,
sex characteristics, gender identity and expression, level of experience,
education, socio-economic status, nationality, personal appearance, race,
religion, or sexual identity and orientation.

Sincerely,

Andrew ✌️ 
