// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_ext_autogen.cpp:
//   Capture functions for the OpenGL ES extension entry points.

#include "libANGLE/capture_gles_ext_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/FrameCapture.h"
#include "libANGLE/gl_enum_utils_autogen.h"
#include "libANGLE/validationESEXT.h"

using namespace angle;

namespace gl
{

CallCapture CaptureDrawArraysInstancedBaseInstanceANGLE(const Context *context,
                                                        bool isCallValid,
                                                        PrimitiveMode modePacked,
                                                        GLint first,
                                                        GLsizei count,
                                                        GLsizei instanceCount,
                                                        GLuint baseInstance)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("instanceCount", ParamType::TGLsizei, instanceCount);
    paramBuffer.addValueParam("baseInstance", ParamType::TGLuint, baseInstance);

    return CallCapture(gl::EntryPoint::DrawArraysInstancedBaseInstanceANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedBaseVertexBaseInstanceANGLE(const Context *context,
                                                                    bool isCallValid,
                                                                    PrimitiveMode modePacked,
                                                                    GLsizei count,
                                                                    DrawElementsType typePacked,
                                                                    const GLvoid *indices,
                                                                    GLsizei instanceCounts,
                                                                    GLint baseVertex,
                                                                    GLuint baseInstance)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointer);
    InitParamValue(ParamType::TGLvoidConstPointer, indices, &indicesParam.value);
    CaptureDrawElementsInstancedBaseVertexBaseInstanceANGLE_indices(
        context, isCallValid, modePacked, count, typePacked, indices, instanceCounts, baseVertex,
        baseInstance, &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("instanceCounts", ParamType::TGLsizei, instanceCounts);
    paramBuffer.addValueParam("baseVertex", ParamType::TGLint, baseVertex);
    paramBuffer.addValueParam("baseInstance", ParamType::TGLuint, baseInstance);

    return CallCapture(gl::EntryPoint::DrawElementsInstancedBaseVertexBaseInstanceANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysInstancedBaseInstanceANGLE(const Context *context,
                                                             bool isCallValid,
                                                             PrimitiveMode modePacked,
                                                             GLsizei drawcount,
                                                             const GLsizei *counts,
                                                             const GLsizei *instanceCounts,
                                                             const GLint *firsts,
                                                             const GLuint *baseInstances)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
    CaptureMultiDrawArraysInstancedBaseInstanceANGLE_counts(context, isCallValid, modePacked,
                                                            drawcount, counts, instanceCounts,
                                                            firsts, baseInstances, &countsParam);
    paramBuffer.addParam(std::move(countsParam));

    ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
    CaptureMultiDrawArraysInstancedBaseInstanceANGLE_instanceCounts(
        context, isCallValid, modePacked, drawcount, counts, instanceCounts, firsts, baseInstances,
        &instanceCountsParam);
    paramBuffer.addParam(std::move(instanceCountsParam));

    ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, firsts, &firstsParam.value);
    CaptureMultiDrawArraysInstancedBaseInstanceANGLE_firsts(context, isCallValid, modePacked,
                                                            drawcount, counts, instanceCounts,
                                                            firsts, baseInstances, &firstsParam);
    paramBuffer.addParam(std::move(firstsParam));

    ParamCapture baseInstancesParam("baseInstances", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, baseInstances, &baseInstancesParam.value);
    CaptureMultiDrawArraysInstancedBaseInstanceANGLE_baseInstances(
        context, isCallValid, modePacked, drawcount, counts, instanceCounts, firsts, baseInstances,
        &baseInstancesParam);
    paramBuffer.addParam(std::move(baseInstancesParam));

    return CallCapture(gl::EntryPoint::MultiDrawArraysInstancedBaseInstanceANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE(
    const Context *context,
    bool isCallValid,
    PrimitiveMode modePacked,
    DrawElementsType typePacked,
    GLsizei drawcount,
    const GLsizei *counts,
    const GLsizei *instanceCounts,
    const GLvoid *const *indices,
    const GLint *baseVertices,
    const GLuint *baseInstances)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);
    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
    CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_counts(
        context, isCallValid, modePacked, typePacked, drawcount, counts, instanceCounts, indices,
        baseVertices, baseInstances, &countsParam);
    paramBuffer.addParam(std::move(countsParam));

    ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
    CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_instanceCounts(
        context, isCallValid, modePacked, typePacked, drawcount, counts, instanceCounts, indices,
        baseVertices, baseInstances, &instanceCountsParam);
    paramBuffer.addParam(std::move(instanceCountsParam));

    ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointerPointer);
    InitParamValue(ParamType::TGLvoidConstPointerPointer, indices, &indicesParam.value);
    CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_indices(
        context, isCallValid, modePacked, typePacked, drawcount, counts, instanceCounts, indices,
        baseVertices, baseInstances, &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    ParamCapture baseVerticesParam("baseVertices", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, baseVertices, &baseVerticesParam.value);
    CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_baseVertices(
        context, isCallValid, modePacked, typePacked, drawcount, counts, instanceCounts, indices,
        baseVertices, baseInstances, &baseVerticesParam);
    paramBuffer.addParam(std::move(baseVerticesParam));

    ParamCapture baseInstancesParam("baseInstances", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, baseInstances, &baseInstancesParam.value);
    CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_baseInstances(
        context, isCallValid, modePacked, typePacked, drawcount, counts, instanceCounts, indices,
        baseVertices, baseInstances, &baseInstancesParam);
    paramBuffer.addParam(std::move(baseInstancesParam));

    return CallCapture(gl::EntryPoint::MultiDrawElementsInstancedBaseVertexBaseInstanceANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureCopyTexture3DANGLE(const Context *context,
                                      bool isCallValid,
                                      TextureID sourceIdPacked,
                                      GLint sourceLevel,
                                      TextureTarget destTargetPacked,
                                      TextureID destIdPacked,
                                      GLint destLevel,
                                      GLint internalFormat,
                                      GLenum destType,
                                      GLboolean unpackFlipY,
                                      GLboolean unpackPremultiplyAlpha,
                                      GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("internalFormat", ParamType::TGLint, internalFormat);
    paramBuffer.addEnumParam("destType", GLenumGroup::DefaultGroup, ParamType::TGLenum, destType);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture(gl::EntryPoint::CopyTexture3DANGLE, std::move(paramBuffer));
}

CallCapture CaptureCopySubTexture3DANGLE(const Context *context,
                                         bool isCallValid,
                                         TextureID sourceIdPacked,
                                         GLint sourceLevel,
                                         TextureTarget destTargetPacked,
                                         TextureID destIdPacked,
                                         GLint destLevel,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint zoffset,
                                         GLint x,
                                         GLint y,
                                         GLint z,
                                         GLint width,
                                         GLint height,
                                         GLint depth,
                                         GLboolean unpackFlipY,
                                         GLboolean unpackPremultiplyAlpha,
                                         GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);
    paramBuffer.addValueParam("width", ParamType::TGLint, width);
    paramBuffer.addValueParam("height", ParamType::TGLint, height);
    paramBuffer.addValueParam("depth", ParamType::TGLint, depth);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture(gl::EntryPoint::CopySubTexture3DANGLE, std::move(paramBuffer));
}

CallCapture CaptureBlitFramebufferANGLE(const Context *context,
                                        bool isCallValid,
                                        GLint srcX0,
                                        GLint srcY0,
                                        GLint srcX1,
                                        GLint srcY1,
                                        GLint dstX0,
                                        GLint dstY0,
                                        GLint dstX1,
                                        GLint dstY1,
                                        GLbitfield mask,
                                        GLenum filter)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("srcX0", ParamType::TGLint, srcX0);
    paramBuffer.addValueParam("srcY0", ParamType::TGLint, srcY0);
    paramBuffer.addValueParam("srcX1", ParamType::TGLint, srcX1);
    paramBuffer.addValueParam("srcY1", ParamType::TGLint, srcY1);
    paramBuffer.addValueParam("dstX0", ParamType::TGLint, dstX0);
    paramBuffer.addValueParam("dstY0", ParamType::TGLint, dstY0);
    paramBuffer.addValueParam("dstX1", ParamType::TGLint, dstX1);
    paramBuffer.addValueParam("dstY1", ParamType::TGLint, dstY1);
    paramBuffer.addEnumParam("mask", GLenumGroup::ClearBufferMask, ParamType::TGLbitfield, mask);
    paramBuffer.addEnumParam("filter", GLenumGroup::BlitFramebufferFilter, ParamType::TGLenum,
                             filter);

    return CallCapture(gl::EntryPoint::BlitFramebufferANGLE, std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorageMultisampleANGLE(const Context *context,
                                                       bool isCallValid,
                                                       GLenum target,
                                                       GLsizei samples,
                                                       GLenum internalformat,
                                                       GLsizei width,
                                                       GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::RenderbufferStorageMultisampleANGLE, std::move(paramBuffer));
}

CallCapture CaptureDrawArraysInstancedANGLE(const Context *context,
                                            bool isCallValid,
                                            PrimitiveMode modePacked,
                                            GLint first,
                                            GLsizei count,
                                            GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(gl::EntryPoint::DrawArraysInstancedANGLE, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedANGLE(const Context *context,
                                              bool isCallValid,
                                              PrimitiveMode modePacked,
                                              GLsizei count,
                                              DrawElementsType typePacked,
                                              const void *indices,
                                              GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
    CaptureDrawElementsInstancedANGLE_indices(context, isCallValid, modePacked, count, typePacked,
                                              indices, primcount, &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(gl::EntryPoint::DrawElementsInstancedANGLE, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribDivisorANGLE(const Context *context,
                                            bool isCallValid,
                                            GLuint index,
                                            GLuint divisor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("divisor", ParamType::TGLuint, divisor);

    return CallCapture(gl::EntryPoint::VertexAttribDivisorANGLE, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysANGLE(const Context *context,
                                        bool isCallValid,
                                        PrimitiveMode modePacked,
                                        const GLint *firsts,
                                        const GLsizei *counts,
                                        GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, firsts, &firstsParam.value);
    CaptureMultiDrawArraysANGLE_firsts(context, isCallValid, modePacked, firsts, counts, drawcount,
                                       &firstsParam);
    paramBuffer.addParam(std::move(firstsParam));

    ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
    CaptureMultiDrawArraysANGLE_counts(context, isCallValid, modePacked, firsts, counts, drawcount,
                                       &countsParam);
    paramBuffer.addParam(std::move(countsParam));

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(gl::EntryPoint::MultiDrawArraysANGLE, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysInstancedANGLE(const Context *context,
                                                 bool isCallValid,
                                                 PrimitiveMode modePacked,
                                                 const GLint *firsts,
                                                 const GLsizei *counts,
                                                 const GLsizei *instanceCounts,
                                                 GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, firsts, &firstsParam.value);
    CaptureMultiDrawArraysInstancedANGLE_firsts(context, isCallValid, modePacked, firsts, counts,
                                                instanceCounts, drawcount, &firstsParam);
    paramBuffer.addParam(std::move(firstsParam));

    ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
    CaptureMultiDrawArraysInstancedANGLE_counts(context, isCallValid, modePacked, firsts, counts,
                                                instanceCounts, drawcount, &countsParam);
    paramBuffer.addParam(std::move(countsParam));

    ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
    CaptureMultiDrawArraysInstancedANGLE_instanceCounts(context, isCallValid, modePacked, firsts,
                                                        counts, instanceCounts, drawcount,
                                                        &instanceCountsParam);
    paramBuffer.addParam(std::move(instanceCountsParam));

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(gl::EntryPoint::MultiDrawArraysInstancedANGLE, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsANGLE(const Context *context,
                                          bool isCallValid,
                                          PrimitiveMode modePacked,
                                          const GLsizei *counts,
                                          DrawElementsType typePacked,
                                          const GLvoid *const *indices,
                                          GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
    CaptureMultiDrawElementsANGLE_counts(context, isCallValid, modePacked, counts, typePacked,
                                         indices, drawcount, &countsParam);
    paramBuffer.addParam(std::move(countsParam));

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointerPointer);
    InitParamValue(ParamType::TGLvoidConstPointerPointer, indices, &indicesParam.value);
    CaptureMultiDrawElementsANGLE_indices(context, isCallValid, modePacked, counts, typePacked,
                                          indices, drawcount, &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(gl::EntryPoint::MultiDrawElementsANGLE, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsInstancedANGLE(const Context *context,
                                                   bool isCallValid,
                                                   PrimitiveMode modePacked,
                                                   const GLsizei *counts,
                                                   DrawElementsType typePacked,
                                                   const GLvoid *const *indices,
                                                   const GLsizei *instanceCounts,
                                                   GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
    CaptureMultiDrawElementsInstancedANGLE_counts(context, isCallValid, modePacked, counts,
                                                  typePacked, indices, instanceCounts, drawcount,
                                                  &countsParam);
    paramBuffer.addParam(std::move(countsParam));

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointerPointer);
    InitParamValue(ParamType::TGLvoidConstPointerPointer, indices, &indicesParam.value);
    CaptureMultiDrawElementsInstancedANGLE_indices(context, isCallValid, modePacked, counts,
                                                   typePacked, indices, instanceCounts, drawcount,
                                                   &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
    InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
    CaptureMultiDrawElementsInstancedANGLE_instanceCounts(context, isCallValid, modePacked, counts,
                                                          typePacked, indices, instanceCounts,
                                                          drawcount, &instanceCountsParam);
    paramBuffer.addParam(std::move(instanceCountsParam));

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(gl::EntryPoint::MultiDrawElementsInstancedANGLE, std::move(paramBuffer));
}

CallCapture CaptureProvokingVertexANGLE(const Context *context,
                                        bool isCallValid,
                                        ProvokingVertexConvention modePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TProvokingVertexConvention, modePacked);

    return CallCapture(gl::EntryPoint::ProvokingVertexANGLE, std::move(paramBuffer));
}

CallCapture CaptureRequestExtensionANGLE(const Context *context,
                                         bool isCallValid,
                                         const GLchar *name)
{
    ParamBuffer paramBuffer;

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureRequestExtensionANGLE_name(context, isCallValid, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture(gl::EntryPoint::RequestExtensionANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBooleanvRobustANGLE(const Context *context,
                                          bool isCallValid,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLboolean *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetBooleanvRobustANGLE_length(context, isCallValid, pname, bufSize, length, params,
                                         &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLbooleanPointer);
    InitParamValue(ParamType::TGLbooleanPointer, params, &paramsParam.value);
    CaptureGetBooleanvRobustANGLE_params(context, isCallValid, pname, bufSize, length, params,
                                         &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetBooleanvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBufferParameterivRobustANGLE(const Context *context,
                                                   bool isCallValid,
                                                   BufferBinding targetPacked,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetBufferParameterivRobustANGLE_length(context, isCallValid, targetPacked, pname,
                                                  bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetBufferParameterivRobustANGLE_params(context, isCallValid, targetPacked, pname,
                                                  bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetBufferParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetFloatvRobustANGLE(const Context *context,
                                        bool isCallValid,
                                        GLenum pname,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetFloatvRobustANGLE_length(context, isCallValid, pname, bufSize, length, params,
                                       &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetFloatvRobustANGLE_params(context, isCallValid, pname, bufSize, length, params,
                                       &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetFloatvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferAttachmentParameterivRobustANGLE(const Context *context,
                                                                  bool isCallValid,
                                                                  GLenum target,
                                                                  GLenum attachment,
                                                                  GLenum pname,
                                                                  GLsizei bufSize,
                                                                  GLsizei *length,
                                                                  GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetFramebufferAttachmentParameterivRobustANGLE_length(
        context, isCallValid, target, attachment, pname, bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetFramebufferAttachmentParameterivRobustANGLE_params(
        context, isCallValid, target, attachment, pname, bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetFramebufferAttachmentParameterivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetIntegervRobustANGLE(const Context *context,
                                          bool isCallValid,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetIntegervRobustANGLE_length(context, isCallValid, pname, bufSize, length, data,
                                         &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture dataParam("data", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, data, &dataParam.value);
    CaptureGetIntegervRobustANGLE_data(context, isCallValid, pname, bufSize, length, data,
                                       &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::GetIntegervRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetProgramivRobustANGLE(const Context *context,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetProgramivRobustANGLE_length(context, isCallValid, programPacked, pname, bufSize,
                                          length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetProgramivRobustANGLE_params(context, isCallValid, programPacked, pname, bufSize,
                                          length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetProgramivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetRenderbufferParameterivRobustANGLE(const Context *context,
                                                         bool isCallValid,
                                                         GLenum target,
                                                         GLenum pname,
                                                         GLsizei bufSize,
                                                         GLsizei *length,
                                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetRenderbufferParameterivRobustANGLE_length(context, isCallValid, target, pname,
                                                        bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetRenderbufferParameterivRobustANGLE_params(context, isCallValid, target, pname,
                                                        bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetRenderbufferParameterivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetShaderivRobustANGLE(const Context *context,
                                          bool isCallValid,
                                          ShaderProgramID shaderPacked,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetShaderivRobustANGLE_length(context, isCallValid, shaderPacked, pname, bufSize, length,
                                         params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetShaderivRobustANGLE_params(context, isCallValid, shaderPacked, pname, bufSize, length,
                                         params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetShaderivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterfvRobustANGLE(const Context *context,
                                                bool isCallValid,
                                                TextureType targetPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTexParameterfvRobustANGLE_length(context, isCallValid, targetPacked, pname, bufSize,
                                               length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetTexParameterfvRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                               length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexParameterfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterivRobustANGLE(const Context *context,
                                                bool isCallValid,
                                                TextureType targetPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTexParameterivRobustANGLE_length(context, isCallValid, targetPacked, pname, bufSize,
                                               length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexParameterivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                               length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetUniformfvRobustANGLE(const Context *context,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLint location,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetUniformfvRobustANGLE_length(context, isCallValid, programPacked, location, bufSize,
                                          length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetUniformfvRobustANGLE_params(context, isCallValid, programPacked, location, bufSize,
                                          length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetUniformfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetUniformivRobustANGLE(const Context *context,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLint location,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetUniformivRobustANGLE_length(context, isCallValid, programPacked, location, bufSize,
                                          length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetUniformivRobustANGLE_params(context, isCallValid, programPacked, location, bufSize,
                                          length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetUniformivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribfvRobustANGLE(const Context *context,
                                                bool isCallValid,
                                                GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetVertexAttribfvRobustANGLE_length(context, isCallValid, index, pname, bufSize, length,
                                               params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetVertexAttribfvRobustANGLE_params(context, isCallValid, index, pname, bufSize, length,
                                               params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetVertexAttribfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribivRobustANGLE(const Context *context,
                                                bool isCallValid,
                                                GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetVertexAttribivRobustANGLE_length(context, isCallValid, index, pname, bufSize, length,
                                               params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetVertexAttribivRobustANGLE_params(context, isCallValid, index, pname, bufSize, length,
                                               params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetVertexAttribivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribPointervRobustANGLE(const Context *context,
                                                      bool isCallValid,
                                                      GLuint index,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      void **pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetVertexAttribPointervRobustANGLE_length(context, isCallValid, index, pname, bufSize,
                                                     length, pointer, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture pointerParam("pointer", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, pointer, &pointerParam.value);
    CaptureGetVertexAttribPointervRobustANGLE_pointer(context, isCallValid, index, pname, bufSize,
                                                      length, pointer, &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture(gl::EntryPoint::GetVertexAttribPointervRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureReadPixelsRobustANGLE(const Context *context,
                                         bool isCallValid,
                                         GLint x,
                                         GLint y,
                                         GLsizei width,
                                         GLsizei height,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLsizei *columns,
                                         GLsizei *rows,
                                         void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureReadPixelsRobustANGLE_length(context, isCallValid, x, y, width, height, format, type,
                                        bufSize, length, columns, rows, pixels, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture columnsParam("columns", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, columns, &columnsParam.value);
    CaptureReadPixelsRobustANGLE_columns(context, isCallValid, x, y, width, height, format, type,
                                         bufSize, length, columns, rows, pixels, &columnsParam);
    paramBuffer.addParam(std::move(columnsParam));

    ParamCapture rowsParam("rows", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, rows, &rowsParam.value);
    CaptureReadPixelsRobustANGLE_rows(context, isCallValid, x, y, width, height, format, type,
                                      bufSize, length, columns, rows, pixels, &rowsParam);
    paramBuffer.addParam(std::move(rowsParam));

    ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
    CaptureReadPixelsRobustANGLE_pixels(context, isCallValid, x, y, width, height, format, type,
                                        bufSize, length, columns, rows, pixels, &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(gl::EntryPoint::ReadPixelsRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexImage2DRobustANGLE(const Context *context,
                                         bool isCallValid,
                                         TextureTarget targetPacked,
                                         GLint level,
                                         GLint internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLint border,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexImage2DRobustANGLE_pixels(context, isCallValid, targetPacked, level, internalformat,
                                        width, height, border, format, type, bufSize, pixels,
                                        &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(gl::EntryPoint::TexImage2DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexParameterfvRobustANGLE(const Context *context,
                                             bool isCallValid,
                                             TextureType targetPacked,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
    CaptureTexParameterfvRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                            params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexParameterfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexParameterivRobustANGLE(const Context *context,
                                             bool isCallValid,
                                             TextureType targetPacked,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureTexParameterivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                            params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexSubImage2DRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            TextureTarget targetPacked,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLenum format,
                                            GLenum type,
                                            GLsizei bufSize,
                                            const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexSubImage2DRobustANGLE_pixels(context, isCallValid, targetPacked, level, xoffset,
                                           yoffset, width, height, format, type, bufSize, pixels,
                                           &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(gl::EntryPoint::TexSubImage2DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexImage3DRobustANGLE(const Context *context,
                                         bool isCallValid,
                                         TextureTarget targetPacked,
                                         GLint level,
                                         GLint internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth,
                                         GLint border,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexImage3DRobustANGLE_pixels(context, isCallValid, targetPacked, level, internalformat,
                                        width, height, depth, border, format, type, bufSize, pixels,
                                        &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(gl::EntryPoint::TexImage3DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexSubImage3DRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            TextureTarget targetPacked,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLint zoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLsizei depth,
                                            GLenum format,
                                            GLenum type,
                                            GLsizei bufSize,
                                            const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexSubImage3DRobustANGLE_pixels(context, isCallValid, targetPacked, level, xoffset,
                                           yoffset, zoffset, width, height, depth, format, type,
                                           bufSize, pixels, &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(gl::EntryPoint::TexSubImage3DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage2DRobustANGLE(const Context *context,
                                                   bool isCallValid,
                                                   TextureTarget targetPacked,
                                                   GLint level,
                                                   GLenum internalformat,
                                                   GLsizei width,
                                                   GLsizei height,
                                                   GLint border,
                                                   GLsizei imageSize,
                                                   GLsizei dataSize,
                                                   const GLvoid *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
    InitParamValue(ParamType::TGLvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexImage2DRobustANGLE_data(context, isCallValid, targetPacked, level,
                                                internalformat, width, height, border, imageSize,
                                                dataSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::CompressedTexImage2DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage2DRobustANGLE(const Context *context,
                                                      bool isCallValid,
                                                      TextureTarget targetPacked,
                                                      GLint level,
                                                      GLsizei xoffset,
                                                      GLsizei yoffset,
                                                      GLsizei width,
                                                      GLsizei height,
                                                      GLenum format,
                                                      GLsizei imageSize,
                                                      GLsizei dataSize,
                                                      const GLvoid *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLsizei, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLsizei, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
    InitParamValue(ParamType::TGLvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexSubImage2DRobustANGLE_data(context, isCallValid, targetPacked, level,
                                                   xoffset, yoffset, width, height, format,
                                                   imageSize, dataSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::CompressedTexSubImage2DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage3DRobustANGLE(const Context *context,
                                                   bool isCallValid,
                                                   TextureTarget targetPacked,
                                                   GLint level,
                                                   GLenum internalformat,
                                                   GLsizei width,
                                                   GLsizei height,
                                                   GLsizei depth,
                                                   GLint border,
                                                   GLsizei imageSize,
                                                   GLsizei dataSize,
                                                   const GLvoid *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
    InitParamValue(ParamType::TGLvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexImage3DRobustANGLE_data(context, isCallValid, targetPacked, level,
                                                internalformat, width, height, depth, border,
                                                imageSize, dataSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::CompressedTexImage3DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage3DRobustANGLE(const Context *context,
                                                      bool isCallValid,
                                                      TextureTarget targetPacked,
                                                      GLint level,
                                                      GLint xoffset,
                                                      GLint yoffset,
                                                      GLint zoffset,
                                                      GLsizei width,
                                                      GLsizei height,
                                                      GLsizei depth,
                                                      GLenum format,
                                                      GLsizei imageSize,
                                                      GLsizei dataSize,
                                                      const GLvoid *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
    InitParamValue(ParamType::TGLvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexSubImage3DRobustANGLE_data(context, isCallValid, targetPacked, level,
                                                   xoffset, yoffset, zoffset, width, height, depth,
                                                   format, imageSize, dataSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::CompressedTexSubImage3DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetQueryivRobustANGLE(const Context *context,
                                         bool isCallValid,
                                         QueryType targetPacked,
                                         GLenum pname,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetQueryivRobustANGLE_length(context, isCallValid, targetPacked, pname, bufSize, length,
                                        params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetQueryivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize, length,
                                        params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetQueryivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectuivRobustANGLE(const Context *context,
                                                bool isCallValid,
                                                QueryID idPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetQueryObjectuivRobustANGLE_length(context, isCallValid, idPacked, pname, bufSize,
                                               length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetQueryObjectuivRobustANGLE_params(context, isCallValid, idPacked, pname, bufSize,
                                               length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetQueryObjectuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBufferPointervRobustANGLE(const Context *context,
                                                bool isCallValid,
                                                BufferBinding targetPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetBufferPointervRobustANGLE_length(context, isCallValid, targetPacked, pname, bufSize,
                                               length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
    CaptureGetBufferPointervRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                               length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetBufferPointervRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetIntegeri_vRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            GLenum target,
                                            GLuint index,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetIntegeri_vRobustANGLE_length(context, isCallValid, target, index, bufSize, length,
                                           data, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture dataParam("data", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, data, &dataParam.value);
    CaptureGetIntegeri_vRobustANGLE_data(context, isCallValid, target, index, bufSize, length, data,
                                         &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::GetIntegeri_vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetInternalformativRobustANGLE(const Context *context,
                                                  bool isCallValid,
                                                  GLenum target,
                                                  GLenum internalformat,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetInternalformativRobustANGLE_length(context, isCallValid, target, internalformat,
                                                 pname, bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetInternalformativRobustANGLE_params(context, isCallValid, target, internalformat,
                                                 pname, bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetInternalformativRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribIivRobustANGLE(const Context *context,
                                                 bool isCallValid,
                                                 GLuint index,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetVertexAttribIivRobustANGLE_length(context, isCallValid, index, pname, bufSize, length,
                                                params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetVertexAttribIivRobustANGLE_params(context, isCallValid, index, pname, bufSize, length,
                                                params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetVertexAttribIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribIuivRobustANGLE(const Context *context,
                                                  bool isCallValid,
                                                  GLuint index,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetVertexAttribIuivRobustANGLE_length(context, isCallValid, index, pname, bufSize,
                                                 length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetVertexAttribIuivRobustANGLE_params(context, isCallValid, index, pname, bufSize,
                                                 length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetVertexAttribIuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetUniformuivRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            ShaderProgramID programPacked,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetUniformuivRobustANGLE_length(context, isCallValid, programPacked, location, bufSize,
                                           length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetUniformuivRobustANGLE_params(context, isCallValid, programPacked, location, bufSize,
                                           length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetUniformuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetActiveUniformBlockivRobustANGLE(const Context *context,
                                                      bool isCallValid,
                                                      ShaderProgramID programPacked,
                                                      GLuint uniformBlockIndex,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("uniformBlockIndex", ParamType::TGLuint, uniformBlockIndex);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetActiveUniformBlockivRobustANGLE_length(context, isCallValid, programPacked,
                                                     uniformBlockIndex, pname, bufSize, length,
                                                     params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetActiveUniformBlockivRobustANGLE_params(context, isCallValid, programPacked,
                                                     uniformBlockIndex, pname, bufSize, length,
                                                     params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetActiveUniformBlockivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetInteger64vRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetInteger64vRobustANGLE_length(context, isCallValid, pname, bufSize, length, data,
                                           &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture dataParam("data", ParamType::TGLint64Pointer);
    InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
    CaptureGetInteger64vRobustANGLE_data(context, isCallValid, pname, bufSize, length, data,
                                         &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::GetInteger64vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetInteger64i_vRobustANGLE(const Context *context,
                                              bool isCallValid,
                                              GLenum target,
                                              GLuint index,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetInteger64i_vRobustANGLE_length(context, isCallValid, target, index, bufSize, length,
                                             data, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture dataParam("data", ParamType::TGLint64Pointer);
    InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
    CaptureGetInteger64i_vRobustANGLE_data(context, isCallValid, target, index, bufSize, length,
                                           data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::GetInteger64i_vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBufferParameteri64vRobustANGLE(const Context *context,
                                                     bool isCallValid,
                                                     BufferBinding targetPacked,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetBufferParameteri64vRobustANGLE_length(context, isCallValid, targetPacked, pname,
                                                    bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
    InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
    CaptureGetBufferParameteri64vRobustANGLE_params(context, isCallValid, targetPacked, pname,
                                                    bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetBufferParameteri64vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterivRobustANGLE(const Context *context,
                                                 bool isCallValid,
                                                 SamplerID samplerPacked,
                                                 GLuint pname,
                                                 GLsizei bufSize,
                                                 const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLuint, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramParam("param", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
    CaptureSamplerParameterivRobustANGLE_param(context, isCallValid, samplerPacked, pname, bufSize,
                                               param, &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(gl::EntryPoint::SamplerParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterfvRobustANGLE(const Context *context,
                                                 bool isCallValid,
                                                 SamplerID samplerPacked,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 const GLfloat *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramParam("param", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, param, &paramParam.value);
    CaptureSamplerParameterfvRobustANGLE_param(context, isCallValid, samplerPacked, pname, bufSize,
                                               param, &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(gl::EntryPoint::SamplerParameterfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterivRobustANGLE(const Context *context,
                                                    bool isCallValid,
                                                    SamplerID samplerPacked,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetSamplerParameterivRobustANGLE_length(context, isCallValid, samplerPacked, pname,
                                                   bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterivRobustANGLE_params(context, isCallValid, samplerPacked, pname,
                                                   bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetSamplerParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterfvRobustANGLE(const Context *context,
                                                    bool isCallValid,
                                                    SamplerID samplerPacked,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetSamplerParameterfvRobustANGLE_length(context, isCallValid, samplerPacked, pname,
                                                   bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterfvRobustANGLE_params(context, isCallValid, samplerPacked, pname,
                                                   bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetSamplerParameterfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferParameterivRobustANGLE(const Context *context,
                                                        bool isCallValid,
                                                        GLenum target,
                                                        GLenum pname,
                                                        GLsizei bufSize,
                                                        GLsizei *length,
                                                        GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetFramebufferParameterivRobustANGLE_length(context, isCallValid, target, pname, bufSize,
                                                       length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetFramebufferParameterivRobustANGLE_params(context, isCallValid, target, pname, bufSize,
                                                       length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetFramebufferParameterivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetProgramInterfaceivRobustANGLE(const Context *context,
                                                    bool isCallValid,
                                                    ShaderProgramID programPacked,
                                                    GLenum programInterface,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             programInterface);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetProgramInterfaceivRobustANGLE_length(context, isCallValid, programPacked,
                                                   programInterface, pname, bufSize, length, params,
                                                   &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetProgramInterfaceivRobustANGLE_params(context, isCallValid, programPacked,
                                                   programInterface, pname, bufSize, length, params,
                                                   &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetProgramInterfaceivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBooleani_vRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            GLenum target,
                                            GLuint index,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLboolean *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetBooleani_vRobustANGLE_length(context, isCallValid, target, index, bufSize, length,
                                           data, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture dataParam("data", ParamType::TGLbooleanPointer);
    InitParamValue(ParamType::TGLbooleanPointer, data, &dataParam.value);
    CaptureGetBooleani_vRobustANGLE_data(context, isCallValid, target, index, bufSize, length, data,
                                         &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::GetBooleani_vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetMultisamplefvRobustANGLE(const Context *context,
                                               bool isCallValid,
                                               GLenum pname,
                                               GLuint index,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLfloat *val)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetMultisamplefvRobustANGLE_length(context, isCallValid, pname, index, bufSize, length,
                                              val, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture valParam("val", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, val, &valParam.value);
    CaptureGetMultisamplefvRobustANGLE_val(context, isCallValid, pname, index, bufSize, length, val,
                                           &valParam);
    paramBuffer.addParam(std::move(valParam));

    return CallCapture(gl::EntryPoint::GetMultisamplefvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterivRobustANGLE(const Context *context,
                                                     bool isCallValid,
                                                     TextureTarget targetPacked,
                                                     GLint level,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTexLevelParameterivRobustANGLE_length(context, isCallValid, targetPacked, level,
                                                    pname, bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexLevelParameterivRobustANGLE_params(context, isCallValid, targetPacked, level,
                                                    pname, bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexLevelParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterfvRobustANGLE(const Context *context,
                                                     bool isCallValid,
                                                     TextureTarget targetPacked,
                                                     GLint level,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTexLevelParameterfvRobustANGLE_length(context, isCallValid, targetPacked, level,
                                                    pname, bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetTexLevelParameterfvRobustANGLE_params(context, isCallValid, targetPacked, level,
                                                    pname, bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexLevelParameterfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetPointervRobustANGLERobustANGLE(const Context *context,
                                                     bool isCallValid,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetPointervRobustANGLERobustANGLE_length(context, isCallValid, pname, bufSize, length,
                                                    params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
    CaptureGetPointervRobustANGLERobustANGLE_params(context, isCallValid, pname, bufSize, length,
                                                    params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetPointervRobustANGLERobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureReadnPixelsRobustANGLE(const Context *context,
                                          bool isCallValid,
                                          GLint x,
                                          GLint y,
                                          GLsizei width,
                                          GLsizei height,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLsizei *columns,
                                          GLsizei *rows,
                                          void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureReadnPixelsRobustANGLE_length(context, isCallValid, x, y, width, height, format, type,
                                         bufSize, length, columns, rows, data, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture columnsParam("columns", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, columns, &columnsParam.value);
    CaptureReadnPixelsRobustANGLE_columns(context, isCallValid, x, y, width, height, format, type,
                                          bufSize, length, columns, rows, data, &columnsParam);
    paramBuffer.addParam(std::move(columnsParam));

    ParamCapture rowsParam("rows", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, rows, &rowsParam.value);
    CaptureReadnPixelsRobustANGLE_rows(context, isCallValid, x, y, width, height, format, type,
                                       bufSize, length, columns, rows, data, &rowsParam);
    paramBuffer.addParam(std::move(rowsParam));

    ParamCapture dataParam("data", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
    CaptureReadnPixelsRobustANGLE_data(context, isCallValid, x, y, width, height, format, type,
                                       bufSize, length, columns, rows, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::ReadnPixelsRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformfvRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            ShaderProgramID programPacked,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetnUniformfvRobustANGLE_length(context, isCallValid, programPacked, location, bufSize,
                                           length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetnUniformfvRobustANGLE_params(context, isCallValid, programPacked, location, bufSize,
                                           length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetnUniformfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformivRobustANGLE(const Context *context,
                                            bool isCallValid,
                                            ShaderProgramID programPacked,
                                            GLint location,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetnUniformivRobustANGLE_length(context, isCallValid, programPacked, location, bufSize,
                                           length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetnUniformivRobustANGLE_params(context, isCallValid, programPacked, location, bufSize,
                                           length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetnUniformivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformuivRobustANGLE(const Context *context,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             GLint location,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetnUniformuivRobustANGLE_length(context, isCallValid, programPacked, location, bufSize,
                                            length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetnUniformuivRobustANGLE_params(context, isCallValid, programPacked, location, bufSize,
                                            length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetnUniformuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIivRobustANGLE(const Context *context,
                                              bool isCallValid,
                                              TextureType targetPacked,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureTexParameterIivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                             params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexParameterIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIuivRobustANGLE(const Context *context,
                                               bool isCallValid,
                                               TextureType targetPacked,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, params, &paramsParam.value);
    CaptureTexParameterIuivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                              params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexParameterIuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIivRobustANGLE(const Context *context,
                                                 bool isCallValid,
                                                 TextureType targetPacked,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTexParameterIivRobustANGLE_length(context, isCallValid, targetPacked, pname, bufSize,
                                                length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexParameterIivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                                length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexParameterIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIuivRobustANGLE(const Context *context,
                                                  bool isCallValid,
                                                  TextureType targetPacked,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTexParameterIuivRobustANGLE_length(context, isCallValid, targetPacked, pname, bufSize,
                                                 length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetTexParameterIuivRobustANGLE_params(context, isCallValid, targetPacked, pname, bufSize,
                                                 length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexParameterIuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIivRobustANGLE(const Context *context,
                                                  bool isCallValid,
                                                  SamplerID samplerPacked,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramParam("param", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
    CaptureSamplerParameterIivRobustANGLE_param(context, isCallValid, samplerPacked, pname, bufSize,
                                                param, &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(gl::EntryPoint::SamplerParameterIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIuivRobustANGLE(const Context *context,
                                                   bool isCallValid,
                                                   SamplerID samplerPacked,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   const GLuint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, param, &paramParam.value);
    CaptureSamplerParameterIuivRobustANGLE_param(context, isCallValid, samplerPacked, pname,
                                                 bufSize, param, &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(gl::EntryPoint::SamplerParameterIuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIivRobustANGLE(const Context *context,
                                                     bool isCallValid,
                                                     SamplerID samplerPacked,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetSamplerParameterIivRobustANGLE_length(context, isCallValid, samplerPacked, pname,
                                                    bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterIivRobustANGLE_params(context, isCallValid, samplerPacked, pname,
                                                    bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetSamplerParameterIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIuivRobustANGLE(const Context *context,
                                                      bool isCallValid,
                                                      SamplerID samplerPacked,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetSamplerParameterIuivRobustANGLE_length(context, isCallValid, samplerPacked, pname,
                                                     bufSize, length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterIuivRobustANGLE_params(context, isCallValid, samplerPacked, pname,
                                                     bufSize, length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetSamplerParameterIuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectivRobustANGLE(const Context *context,
                                               bool isCallValid,
                                               QueryID idPacked,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetQueryObjectivRobustANGLE_length(context, isCallValid, idPacked, pname, bufSize,
                                              length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetQueryObjectivRobustANGLE_params(context, isCallValid, idPacked, pname, bufSize,
                                              length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetQueryObjectivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjecti64vRobustANGLE(const Context *context,
                                                 bool isCallValid,
                                                 QueryID idPacked,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetQueryObjecti64vRobustANGLE_length(context, isCallValid, idPacked, pname, bufSize,
                                                length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
    InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
    CaptureGetQueryObjecti64vRobustANGLE_params(context, isCallValid, idPacked, pname, bufSize,
                                                length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetQueryObjecti64vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectui64vRobustANGLE(const Context *context,
                                                  bool isCallValid,
                                                  QueryID idPacked,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetQueryObjectui64vRobustANGLE_length(context, isCallValid, idPacked, pname, bufSize,
                                                 length, params, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
    InitParamValue(ParamType::TGLuint64Pointer, params, &paramsParam.value);
    CaptureGetQueryObjectui64vRobustANGLE_params(context, isCallValid, idPacked, pname, bufSize,
                                                 length, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetQueryObjectui64vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexImage2DExternalANGLE(const Context *context,
                                           bool isCallValid,
                                           TextureTarget targetPacked,
                                           GLint level,
                                           GLint internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLint border,
                                           GLenum format,
                                           GLenum type)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);

    return CallCapture(gl::EntryPoint::TexImage2DExternalANGLE, std::move(paramBuffer));
}

CallCapture CaptureInvalidateTextureANGLE(const Context *context,
                                          bool isCallValid,
                                          TextureType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);

    return CallCapture(gl::EntryPoint::InvalidateTextureANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexStorage2DMultisampleANGLE(const Context *context,
                                                bool isCallValid,
                                                TextureType targetPacked,
                                                GLsizei samples,
                                                GLenum internalformat,
                                                GLsizei width,
                                                GLsizei height,
                                                GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(gl::EntryPoint::TexStorage2DMultisampleANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterivANGLE(const Context *context,
                                               bool isCallValid,
                                               TextureTarget targetPacked,
                                               GLint level,
                                               GLenum pname,
                                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexLevelParameterivANGLE_params(context, isCallValid, targetPacked, level, pname,
                                              params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexLevelParameterivANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterfvANGLE(const Context *context,
                                               bool isCallValid,
                                               TextureTarget targetPacked,
                                               GLint level,
                                               GLenum pname,
                                               GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetTexLevelParameterfvANGLE_params(context, isCallValid, targetPacked, level, pname,
                                              params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexLevelParameterfvANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetMultisamplefvANGLE(const Context *context,
                                         bool isCallValid,
                                         GLenum pname,
                                         GLuint index,
                                         GLfloat *val)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture valParam("val", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, val, &valParam.value);
    CaptureGetMultisamplefvANGLE_val(context, isCallValid, pname, index, val, &valParam);
    paramBuffer.addParam(std::move(valParam));

    return CallCapture(gl::EntryPoint::GetMultisamplefvANGLE, std::move(paramBuffer));
}

CallCapture CaptureSampleMaskiANGLE(const Context *context,
                                    bool isCallValid,
                                    GLuint maskNumber,
                                    GLbitfield mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("maskNumber", ParamType::TGLuint, maskNumber);
    paramBuffer.addEnumParam("mask", GLenumGroup::DefaultGroup, ParamType::TGLbitfield, mask);

    return CallCapture(gl::EntryPoint::SampleMaskiANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTranslatedShaderSourceANGLE(const Context *context,
                                                  bool isCallValid,
                                                  ShaderProgramID shaderPacked,
                                                  GLsizei bufsize,
                                                  GLsizei *length,
                                                  GLchar *source)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addValueParam("bufsize", ParamType::TGLsizei, bufsize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetTranslatedShaderSourceANGLE_length(context, isCallValid, shaderPacked, bufsize,
                                                 length, source, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture sourceParam("source", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, source, &sourceParam.value);
    CaptureGetTranslatedShaderSourceANGLE_source(context, isCallValid, shaderPacked, bufsize,
                                                 length, source, &sourceParam);
    paramBuffer.addParam(std::move(sourceParam));

    return CallCapture(gl::EntryPoint::GetTranslatedShaderSourceANGLE, std::move(paramBuffer));
}

CallCapture CaptureBindUniformLocationCHROMIUM(const Context *context,
                                               bool isCallValid,
                                               ShaderProgramID programPacked,
                                               GLint location,
                                               const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureBindUniformLocationCHROMIUM_name(context, isCallValid, programPacked, location, name,
                                            &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture(gl::EntryPoint::BindUniformLocationCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCompressedCopyTextureCHROMIUM(const Context *context,
                                                 bool isCallValid,
                                                 TextureID sourceIdPacked,
                                                 TextureID destIdPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);

    return CallCapture(gl::EntryPoint::CompressedCopyTextureCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCopyTextureCHROMIUM(const Context *context,
                                       bool isCallValid,
                                       TextureID sourceIdPacked,
                                       GLint sourceLevel,
                                       TextureTarget destTargetPacked,
                                       TextureID destIdPacked,
                                       GLint destLevel,
                                       GLint internalFormat,
                                       GLenum destType,
                                       GLboolean unpackFlipY,
                                       GLboolean unpackPremultiplyAlpha,
                                       GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("internalFormat", ParamType::TGLint, internalFormat);
    paramBuffer.addEnumParam("destType", GLenumGroup::DefaultGroup, ParamType::TGLenum, destType);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture(gl::EntryPoint::CopyTextureCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCopySubTextureCHROMIUM(const Context *context,
                                          bool isCallValid,
                                          TextureID sourceIdPacked,
                                          GLint sourceLevel,
                                          TextureTarget destTargetPacked,
                                          TextureID destIdPacked,
                                          GLint destLevel,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLint x,
                                          GLint y,
                                          GLint width,
                                          GLint height,
                                          GLboolean unpackFlipY,
                                          GLboolean unpackPremultiplyAlpha,
                                          GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLint, width);
    paramBuffer.addValueParam("height", ParamType::TGLint, height);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture(gl::EntryPoint::CopySubTextureCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCoverageModulationCHROMIUM(const Context *context,
                                              bool isCallValid,
                                              GLenum components)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("components", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             components);

    return CallCapture(gl::EntryPoint::CoverageModulationCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureMatrixLoadfCHROMIUM(const Context *context,
                                       bool isCallValid,
                                       GLenum matrixMode,
                                       const GLfloat *matrix)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("matrixMode", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             matrixMode);

    ParamCapture matrixParam("matrix", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, matrix, &matrixParam.value);
    CaptureMatrixLoadfCHROMIUM_matrix(context, isCallValid, matrixMode, matrix, &matrixParam);
    paramBuffer.addParam(std::move(matrixParam));

    return CallCapture(gl::EntryPoint::MatrixLoadfCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureMatrixLoadIdentityCHROMIUM(const Context *context,
                                              bool isCallValid,
                                              GLenum matrixMode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("matrixMode", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             matrixMode);

    return CallCapture(gl::EntryPoint::MatrixLoadIdentityCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureLoseContextCHROMIUM(const Context *context,
                                       bool isCallValid,
                                       GraphicsResetStatus currentPacked,
                                       GraphicsResetStatus otherPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("currentPacked", ParamType::TGraphicsResetStatus, currentPacked);
    paramBuffer.addValueParam("otherPacked", ParamType::TGraphicsResetStatus, otherPacked);

    return CallCapture(gl::EntryPoint::LoseContextCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureGenPathsCHROMIUM(const Context *context,
                                    bool isCallValid,
                                    GLsizei range,
                                    GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("range", ParamType::TGLsizei, range);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GenPathsCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureDeletePathsCHROMIUM(const Context *context,
                                       bool isCallValid,
                                       PathID firstPacked,
                                       GLsizei range)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("firstPacked", ParamType::TPathID, firstPacked);
    paramBuffer.addValueParam("range", ParamType::TGLsizei, range);

    return CallCapture(gl::EntryPoint::DeletePathsCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureIsPathCHROMIUM(const Context *context,
                                  bool isCallValid,
                                  PathID pathPacked,
                                  GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pathPacked", ParamType::TPathID, pathPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsPathCHROMIUM, std::move(paramBuffer));
}

CallCapture CapturePathCommandsCHROMIUM(const Context *context,
                                        bool isCallValid,
                                        PathID pathPacked,
                                        GLsizei numCommands,
                                        const GLubyte *commands,
                                        GLsizei numCoords,
                                        GLenum coordType,
                                        const void *coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pathPacked", ParamType::TPathID, pathPacked);
    paramBuffer.addValueParam("numCommands", ParamType::TGLsizei, numCommands);

    ParamCapture commandsParam("commands", ParamType::TGLubyteConstPointer);
    InitParamValue(ParamType::TGLubyteConstPointer, commands, &commandsParam.value);
    CapturePathCommandsCHROMIUM_commands(context, isCallValid, pathPacked, numCommands, commands,
                                         numCoords, coordType, coords, &commandsParam);
    paramBuffer.addParam(std::move(commandsParam));

    paramBuffer.addValueParam("numCoords", ParamType::TGLsizei, numCoords);
    paramBuffer.addEnumParam("coordType", GLenumGroup::DefaultGroup, ParamType::TGLenum, coordType);

    ParamCapture coordsParam("coords", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, coords, &coordsParam.value);
    CapturePathCommandsCHROMIUM_coords(context, isCallValid, pathPacked, numCommands, commands,
                                       numCoords, coordType, coords, &coordsParam);
    paramBuffer.addParam(std::move(coordsParam));

    return CallCapture(gl::EntryPoint::PathCommandsCHROMIUM, std::move(paramBuffer));
}

CallCapture CapturePathParameterfCHROMIUM(const Context *context,
                                          bool isCallValid,
                                          PathID pathPacked,
                                          GLenum pname,
                                          GLfloat value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pathPacked", ParamType::TPathID, pathPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("value", ParamType::TGLfloat, value);

    return CallCapture(gl::EntryPoint::PathParameterfCHROMIUM, std::move(paramBuffer));
}

CallCapture CapturePathParameteriCHROMIUM(const Context *context,
                                          bool isCallValid,
                                          PathID pathPacked,
                                          GLenum pname,
                                          GLint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pathPacked", ParamType::TPathID, pathPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("value", ParamType::TGLint, value);

    return CallCapture(gl::EntryPoint::PathParameteriCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureGetPathParameterfvCHROMIUM(const Context *context,
                                              bool isCallValid,
                                              PathID pathPacked,
                                              GLenum pname,
                                              GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pathPacked", ParamType::TPathID, pathPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    ParamCapture valueParam("value", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, value, &valueParam.value);
    CaptureGetPathParameterfvCHROMIUM_value(context, isCallValid, pathPacked, pname, value,
                                            &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::GetPathParameterfvCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureGetPathParameterivCHROMIUM(const Context *context,
                                              bool isCallValid,
                                              PathID pathPacked,
                                              GLenum pname,
                                              GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pathPacked", ParamType::TPathID, pathPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    ParamCapture valueParam("value", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, value, &valueParam.value);
    CaptureGetPathParameterivCHROMIUM_value(context, isCallValid, pathPacked, pname, value,
                                            &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::GetPathParameterivCHROMIUM, std::move(paramBuffer));
}

CallCapture CapturePathStencilFuncCHROMIUM(const Context *context,
                                           bool isCallValid,
                                           GLenum func,
                                           GLint ref,
                                           GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("func", GLenumGroup::DefaultGroup, ParamType::TGLenum, func);
    paramBuffer.addValueParam("ref", ParamType::TGLint, ref);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture(gl::EntryPoint::PathStencilFuncCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureStencilFillPathCHROMIUM(const Context *context,
                                           bool isCallValid,
                                           PathID pathPacked,
                                           GLenum fillMode,
                                           GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pathPacked", ParamType::TPathID, pathPacked);
    paramBuffer.addEnumParam("fillMode", GLenumGroup::DefaultGroup, ParamType::TGLenum, fillMode);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture(gl::EntryPoint::StencilFillPathCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureStencilStrokePathCHROMIUM(const Context *context,
                                             bool isCallValid,
                                             PathID pathPacked,
                                             GLint reference,
                                             GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pathPacked", ParamType::TPathID, pathPacked);
    paramBuffer.addValueParam("reference", ParamType::TGLint, reference);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture(gl::EntryPoint::StencilStrokePathCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCoverFillPathCHROMIUM(const Context *context,
                                         bool isCallValid,
                                         PathID pathPacked,
                                         GLenum coverMode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pathPacked", ParamType::TPathID, pathPacked);
    paramBuffer.addEnumParam("coverMode", GLenumGroup::DefaultGroup, ParamType::TGLenum, coverMode);

    return CallCapture(gl::EntryPoint::CoverFillPathCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCoverStrokePathCHROMIUM(const Context *context,
                                           bool isCallValid,
                                           PathID pathPacked,
                                           GLenum coverMode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pathPacked", ParamType::TPathID, pathPacked);
    paramBuffer.addEnumParam("coverMode", GLenumGroup::DefaultGroup, ParamType::TGLenum, coverMode);

    return CallCapture(gl::EntryPoint::CoverStrokePathCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureStencilThenCoverFillPathCHROMIUM(const Context *context,
                                                    bool isCallValid,
                                                    PathID pathPacked,
                                                    GLenum fillMode,
                                                    GLuint mask,
                                                    GLenum coverMode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pathPacked", ParamType::TPathID, pathPacked);
    paramBuffer.addEnumParam("fillMode", GLenumGroup::DefaultGroup, ParamType::TGLenum, fillMode);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);
    paramBuffer.addEnumParam("coverMode", GLenumGroup::DefaultGroup, ParamType::TGLenum, coverMode);

    return CallCapture(gl::EntryPoint::StencilThenCoverFillPathCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureStencilThenCoverStrokePathCHROMIUM(const Context *context,
                                                      bool isCallValid,
                                                      PathID pathPacked,
                                                      GLint reference,
                                                      GLuint mask,
                                                      GLenum coverMode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pathPacked", ParamType::TPathID, pathPacked);
    paramBuffer.addValueParam("reference", ParamType::TGLint, reference);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);
    paramBuffer.addEnumParam("coverMode", GLenumGroup::DefaultGroup, ParamType::TGLenum, coverMode);

    return CallCapture(gl::EntryPoint::StencilThenCoverStrokePathCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCoverFillPathInstancedCHROMIUM(const Context *context,
                                                  bool isCallValid,
                                                  GLsizei numPath,
                                                  GLenum pathNameType,
                                                  const void *paths,
                                                  PathID pathBasePacked,
                                                  GLenum coverMode,
                                                  GLenum transformType,
                                                  const GLfloat *transformValues)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numPath", ParamType::TGLsizei, numPath);
    paramBuffer.addEnumParam("pathNameType", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             pathNameType);

    ParamCapture pathsParam("paths", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, paths, &pathsParam.value);
    CaptureCoverFillPathInstancedCHROMIUM_paths(context, isCallValid, numPath, pathNameType, paths,
                                                pathBasePacked, coverMode, transformType,
                                                transformValues, &pathsParam);
    paramBuffer.addParam(std::move(pathsParam));

    paramBuffer.addValueParam("pathBasePacked", ParamType::TPathID, pathBasePacked);
    paramBuffer.addEnumParam("coverMode", GLenumGroup::DefaultGroup, ParamType::TGLenum, coverMode);
    paramBuffer.addEnumParam("transformType", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             transformType);

    ParamCapture transformValuesParam("transformValues", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, transformValues, &transformValuesParam.value);
    CaptureCoverFillPathInstancedCHROMIUM_transformValues(
        context, isCallValid, numPath, pathNameType, paths, pathBasePacked, coverMode,
        transformType, transformValues, &transformValuesParam);
    paramBuffer.addParam(std::move(transformValuesParam));

    return CallCapture(gl::EntryPoint::CoverFillPathInstancedCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCoverStrokePathInstancedCHROMIUM(const Context *context,
                                                    bool isCallValid,
                                                    GLsizei numPath,
                                                    GLenum pathNameType,
                                                    const void *paths,
                                                    PathID pathBasePacked,
                                                    GLenum coverMode,
                                                    GLenum transformType,
                                                    const GLfloat *transformValues)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numPath", ParamType::TGLsizei, numPath);
    paramBuffer.addEnumParam("pathNameType", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             pathNameType);

    ParamCapture pathsParam("paths", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, paths, &pathsParam.value);
    CaptureCoverStrokePathInstancedCHROMIUM_paths(context, isCallValid, numPath, pathNameType,
                                                  paths, pathBasePacked, coverMode, transformType,
                                                  transformValues, &pathsParam);
    paramBuffer.addParam(std::move(pathsParam));

    paramBuffer.addValueParam("pathBasePacked", ParamType::TPathID, pathBasePacked);
    paramBuffer.addEnumParam("coverMode", GLenumGroup::DefaultGroup, ParamType::TGLenum, coverMode);
    paramBuffer.addEnumParam("transformType", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             transformType);

    ParamCapture transformValuesParam("transformValues", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, transformValues, &transformValuesParam.value);
    CaptureCoverStrokePathInstancedCHROMIUM_transformValues(
        context, isCallValid, numPath, pathNameType, paths, pathBasePacked, coverMode,
        transformType, transformValues, &transformValuesParam);
    paramBuffer.addParam(std::move(transformValuesParam));

    return CallCapture(gl::EntryPoint::CoverStrokePathInstancedCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureStencilStrokePathInstancedCHROMIUM(const Context *context,
                                                      bool isCallValid,
                                                      GLsizei numPath,
                                                      GLenum pathNameType,
                                                      const void *paths,
                                                      PathID pathBasePacked,
                                                      GLint reference,
                                                      GLuint mask,
                                                      GLenum transformType,
                                                      const GLfloat *transformValues)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numPath", ParamType::TGLsizei, numPath);
    paramBuffer.addEnumParam("pathNameType", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             pathNameType);

    ParamCapture pathsParam("paths", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, paths, &pathsParam.value);
    CaptureStencilStrokePathInstancedCHROMIUM_paths(context, isCallValid, numPath, pathNameType,
                                                    paths, pathBasePacked, reference, mask,
                                                    transformType, transformValues, &pathsParam);
    paramBuffer.addParam(std::move(pathsParam));

    paramBuffer.addValueParam("pathBasePacked", ParamType::TPathID, pathBasePacked);
    paramBuffer.addValueParam("reference", ParamType::TGLint, reference);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);
    paramBuffer.addEnumParam("transformType", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             transformType);

    ParamCapture transformValuesParam("transformValues", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, transformValues, &transformValuesParam.value);
    CaptureStencilStrokePathInstancedCHROMIUM_transformValues(
        context, isCallValid, numPath, pathNameType, paths, pathBasePacked, reference, mask,
        transformType, transformValues, &transformValuesParam);
    paramBuffer.addParam(std::move(transformValuesParam));

    return CallCapture(gl::EntryPoint::StencilStrokePathInstancedCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureStencilFillPathInstancedCHROMIUM(const Context *context,
                                                    bool isCallValid,
                                                    GLsizei numPaths,
                                                    GLenum pathNameType,
                                                    const void *paths,
                                                    PathID pathBasePacked,
                                                    GLenum fillMode,
                                                    GLuint mask,
                                                    GLenum transformType,
                                                    const GLfloat *transformValues)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numPaths", ParamType::TGLsizei, numPaths);
    paramBuffer.addEnumParam("pathNameType", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             pathNameType);

    ParamCapture pathsParam("paths", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, paths, &pathsParam.value);
    CaptureStencilFillPathInstancedCHROMIUM_paths(context, isCallValid, numPaths, pathNameType,
                                                  paths, pathBasePacked, fillMode, mask,
                                                  transformType, transformValues, &pathsParam);
    paramBuffer.addParam(std::move(pathsParam));

    paramBuffer.addValueParam("pathBasePacked", ParamType::TPathID, pathBasePacked);
    paramBuffer.addEnumParam("fillMode", GLenumGroup::DefaultGroup, ParamType::TGLenum, fillMode);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);
    paramBuffer.addEnumParam("transformType", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             transformType);

    ParamCapture transformValuesParam("transformValues", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, transformValues, &transformValuesParam.value);
    CaptureStencilFillPathInstancedCHROMIUM_transformValues(
        context, isCallValid, numPaths, pathNameType, paths, pathBasePacked, fillMode, mask,
        transformType, transformValues, &transformValuesParam);
    paramBuffer.addParam(std::move(transformValuesParam));

    return CallCapture(gl::EntryPoint::StencilFillPathInstancedCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureStencilThenCoverFillPathInstancedCHROMIUM(const Context *context,
                                                             bool isCallValid,
                                                             GLsizei numPaths,
                                                             GLenum pathNameType,
                                                             const void *paths,
                                                             PathID pathBasePacked,
                                                             GLenum fillMode,
                                                             GLuint mask,
                                                             GLenum coverMode,
                                                             GLenum transformType,
                                                             const GLfloat *transformValues)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numPaths", ParamType::TGLsizei, numPaths);
    paramBuffer.addEnumParam("pathNameType", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             pathNameType);

    ParamCapture pathsParam("paths", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, paths, &pathsParam.value);
    CaptureStencilThenCoverFillPathInstancedCHROMIUM_paths(
        context, isCallValid, numPaths, pathNameType, paths, pathBasePacked, fillMode, mask,
        coverMode, transformType, transformValues, &pathsParam);
    paramBuffer.addParam(std::move(pathsParam));

    paramBuffer.addValueParam("pathBasePacked", ParamType::TPathID, pathBasePacked);
    paramBuffer.addEnumParam("fillMode", GLenumGroup::DefaultGroup, ParamType::TGLenum, fillMode);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);
    paramBuffer.addEnumParam("coverMode", GLenumGroup::DefaultGroup, ParamType::TGLenum, coverMode);
    paramBuffer.addEnumParam("transformType", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             transformType);

    ParamCapture transformValuesParam("transformValues", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, transformValues, &transformValuesParam.value);
    CaptureStencilThenCoverFillPathInstancedCHROMIUM_transformValues(
        context, isCallValid, numPaths, pathNameType, paths, pathBasePacked, fillMode, mask,
        coverMode, transformType, transformValues, &transformValuesParam);
    paramBuffer.addParam(std::move(transformValuesParam));

    return CallCapture(gl::EntryPoint::StencilThenCoverFillPathInstancedCHROMIUM,
                       std::move(paramBuffer));
}

CallCapture CaptureStencilThenCoverStrokePathInstancedCHROMIUM(const Context *context,
                                                               bool isCallValid,
                                                               GLsizei numPaths,
                                                               GLenum pathNameType,
                                                               const void *paths,
                                                               PathID pathBasePacked,
                                                               GLint reference,
                                                               GLuint mask,
                                                               GLenum coverMode,
                                                               GLenum transformType,
                                                               const GLfloat *transformValues)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("numPaths", ParamType::TGLsizei, numPaths);
    paramBuffer.addEnumParam("pathNameType", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             pathNameType);

    ParamCapture pathsParam("paths", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, paths, &pathsParam.value);
    CaptureStencilThenCoverStrokePathInstancedCHROMIUM_paths(
        context, isCallValid, numPaths, pathNameType, paths, pathBasePacked, reference, mask,
        coverMode, transformType, transformValues, &pathsParam);
    paramBuffer.addParam(std::move(pathsParam));

    paramBuffer.addValueParam("pathBasePacked", ParamType::TPathID, pathBasePacked);
    paramBuffer.addValueParam("reference", ParamType::TGLint, reference);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);
    paramBuffer.addEnumParam("coverMode", GLenumGroup::DefaultGroup, ParamType::TGLenum, coverMode);
    paramBuffer.addEnumParam("transformType", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             transformType);

    ParamCapture transformValuesParam("transformValues", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, transformValues, &transformValuesParam.value);
    CaptureStencilThenCoverStrokePathInstancedCHROMIUM_transformValues(
        context, isCallValid, numPaths, pathNameType, paths, pathBasePacked, reference, mask,
        coverMode, transformType, transformValues, &transformValuesParam);
    paramBuffer.addParam(std::move(transformValuesParam));

    return CallCapture(gl::EntryPoint::StencilThenCoverStrokePathInstancedCHROMIUM,
                       std::move(paramBuffer));
}

CallCapture CaptureBindFragmentInputLocationCHROMIUM(const Context *context,
                                                     bool isCallValid,
                                                     ShaderProgramID programsPacked,
                                                     GLint location,
                                                     const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programsPacked", ParamType::TShaderProgramID, programsPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureBindFragmentInputLocationCHROMIUM_name(context, isCallValid, programsPacked, location,
                                                  name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture(gl::EntryPoint::BindFragmentInputLocationCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureProgramPathFragmentInputGenCHROMIUM(const Context *context,
                                                       bool isCallValid,
                                                       ShaderProgramID programPacked,
                                                       GLint location,
                                                       GLenum genMode,
                                                       GLint components,
                                                       const GLfloat *coeffs)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addEnumParam("genMode", GLenumGroup::DefaultGroup, ParamType::TGLenum, genMode);
    paramBuffer.addValueParam("components", ParamType::TGLint, components);

    ParamCapture coeffsParam("coeffs", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, coeffs, &coeffsParam.value);
    CaptureProgramPathFragmentInputGenCHROMIUM_coeffs(context, isCallValid, programPacked, location,
                                                      genMode, components, coeffs, &coeffsParam);
    paramBuffer.addParam(std::move(coeffsParam));

    return CallCapture(gl::EntryPoint::ProgramPathFragmentInputGenCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureBindFragDataLocationEXT(const Context *context,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLuint color,
                                           const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("color", ParamType::TGLuint, color);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureBindFragDataLocationEXT_name(context, isCallValid, programPacked, color, name,
                                        &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture(gl::EntryPoint::BindFragDataLocationEXT, std::move(paramBuffer));
}

CallCapture CaptureBindFragDataLocationIndexedEXT(const Context *context,
                                                  bool isCallValid,
                                                  ShaderProgramID programPacked,
                                                  GLuint colorNumber,
                                                  GLuint index,
                                                  const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("colorNumber", ParamType::TGLuint, colorNumber);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureBindFragDataLocationIndexedEXT_name(context, isCallValid, programPacked, colorNumber,
                                               index, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture(gl::EntryPoint::BindFragDataLocationIndexedEXT, std::move(paramBuffer));
}

CallCapture CaptureGetFragDataIndexEXT(const Context *context,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       const GLchar *name,
                                       GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureGetFragDataIndexEXT_name(context, isCallValid, programPacked, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetFragDataIndexEXT, std::move(paramBuffer));
}

CallCapture CaptureGetProgramResourceLocationIndexEXT(const Context *context,
                                                      bool isCallValid,
                                                      ShaderProgramID programPacked,
                                                      GLenum programInterface,
                                                      const GLchar *name,
                                                      GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::ProgramInterface, ParamType::TGLenum,
                             programInterface);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureGetProgramResourceLocationIndexEXT_name(context, isCallValid, programPacked,
                                                   programInterface, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetProgramResourceLocationIndexEXT, std::move(paramBuffer));
}

CallCapture CaptureInsertEventMarkerEXT(const Context *context,
                                        bool isCallValid,
                                        GLsizei length,
                                        const GLchar *marker)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture markerParam("marker", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, marker, &markerParam.value);
    CaptureInsertEventMarkerEXT_marker(context, isCallValid, length, marker, &markerParam);
    paramBuffer.addParam(std::move(markerParam));

    return CallCapture(gl::EntryPoint::InsertEventMarkerEXT, std::move(paramBuffer));
}

CallCapture CapturePopGroupMarkerEXT(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::PopGroupMarkerEXT, std::move(paramBuffer));
}

CallCapture CapturePushGroupMarkerEXT(const Context *context,
                                      bool isCallValid,
                                      GLsizei length,
                                      const GLchar *marker)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture markerParam("marker", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, marker, &markerParam.value);
    CapturePushGroupMarkerEXT_marker(context, isCallValid, length, marker, &markerParam);
    paramBuffer.addParam(std::move(markerParam));

    return CallCapture(gl::EntryPoint::PushGroupMarkerEXT, std::move(paramBuffer));
}

CallCapture CaptureDiscardFramebufferEXT(const Context *context,
                                         bool isCallValid,
                                         GLenum target,
                                         GLsizei numAttachments,
                                         const GLenum *attachments)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addValueParam("numAttachments", ParamType::TGLsizei, numAttachments);

    ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
    InitParamValue(ParamType::TGLenumConstPointer, attachments, &attachmentsParam.value);
    CaptureDiscardFramebufferEXT_attachments(context, isCallValid, target, numAttachments,
                                             attachments, &attachmentsParam);
    paramBuffer.addParam(std::move(attachmentsParam));

    return CallCapture(gl::EntryPoint::DiscardFramebufferEXT, std::move(paramBuffer));
}

CallCapture CaptureBeginQueryEXT(const Context *context,
                                 bool isCallValid,
                                 QueryType targetPacked,
                                 QueryID idPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);

    return CallCapture(gl::EntryPoint::BeginQueryEXT, std::move(paramBuffer));
}

CallCapture CaptureDeleteQueriesEXT(const Context *context,
                                    bool isCallValid,
                                    GLsizei n,
                                    const QueryID *idsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture idsPackedParam("idsPacked", ParamType::TQueryIDConstPointer);
    InitParamValue(ParamType::TQueryIDConstPointer, idsPacked, &idsPackedParam.value);
    CaptureDeleteQueriesEXT_idsPacked(context, isCallValid, n, idsPacked, &idsPackedParam);
    paramBuffer.addParam(std::move(idsPackedParam));

    return CallCapture(gl::EntryPoint::DeleteQueriesEXT, std::move(paramBuffer));
}

CallCapture CaptureEndQueryEXT(const Context *context, bool isCallValid, QueryType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);

    return CallCapture(gl::EntryPoint::EndQueryEXT, std::move(paramBuffer));
}

CallCapture CaptureGenQueriesEXT(const Context *context,
                                 bool isCallValid,
                                 GLsizei n,
                                 QueryID *idsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture idsPackedParam("idsPacked", ParamType::TQueryIDPointer);
    InitParamValue(ParamType::TQueryIDPointer, idsPacked, &idsPackedParam.value);
    CaptureGenQueriesEXT_idsPacked(context, isCallValid, n, idsPacked, &idsPackedParam);
    paramBuffer.addParam(std::move(idsPackedParam));

    return CallCapture(gl::EntryPoint::GenQueriesEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjecti64vEXT(const Context *context,
                                         bool isCallValid,
                                         QueryID idPacked,
                                         GLenum pname,
                                         GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
    InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
    CaptureGetQueryObjecti64vEXT_params(context, isCallValid, idPacked, pname, params,
                                        &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetQueryObjecti64vEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectivEXT(const Context *context,
                                       bool isCallValid,
                                       QueryID idPacked,
                                       GLenum pname,
                                       GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetQueryObjectivEXT_params(context, isCallValid, idPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetQueryObjectivEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectui64vEXT(const Context *context,
                                          bool isCallValid,
                                          QueryID idPacked,
                                          GLenum pname,
                                          GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
    InitParamValue(ParamType::TGLuint64Pointer, params, &paramsParam.value);
    CaptureGetQueryObjectui64vEXT_params(context, isCallValid, idPacked, pname, params,
                                         &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetQueryObjectui64vEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectuivEXT(const Context *context,
                                        bool isCallValid,
                                        QueryID idPacked,
                                        GLenum pname,
                                        GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetQueryObjectuivEXT_params(context, isCallValid, idPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetQueryObjectuivEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryivEXT(const Context *context,
                                 bool isCallValid,
                                 QueryType targetPacked,
                                 GLenum pname,
                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::QueryParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetQueryivEXT_params(context, isCallValid, targetPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetQueryivEXT, std::move(paramBuffer));
}

CallCapture CaptureIsQueryEXT(const Context *context,
                              bool isCallValid,
                              QueryID idPacked,
                              GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsQueryEXT, std::move(paramBuffer));
}

CallCapture CaptureQueryCounterEXT(const Context *context,
                                   bool isCallValid,
                                   QueryID idPacked,
                                   QueryType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);

    return CallCapture(gl::EntryPoint::QueryCounterEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawBuffersEXT(const Context *context,
                                  bool isCallValid,
                                  GLsizei n,
                                  const GLenum *bufs)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture bufsParam("bufs", ParamType::TGLenumConstPointer);
    InitParamValue(ParamType::TGLenumConstPointer, bufs, &bufsParam.value);
    CaptureDrawBuffersEXT_bufs(context, isCallValid, n, bufs, &bufsParam);
    paramBuffer.addParam(std::move(bufsParam));

    return CallCapture(gl::EntryPoint::DrawBuffersEXT, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTextureEXT(const Context *context,
                                         bool isCallValid,
                                         GLenum target,
                                         GLenum attachment,
                                         TextureID texturePacked,
                                         GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(gl::EntryPoint::FramebufferTextureEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawArraysInstancedEXT(const Context *context,
                                          bool isCallValid,
                                          PrimitiveMode modePacked,
                                          GLint start,
                                          GLsizei count,
                                          GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("start", ParamType::TGLint, start);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(gl::EntryPoint::DrawArraysInstancedEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedEXT(const Context *context,
                                            bool isCallValid,
                                            PrimitiveMode modePacked,
                                            GLsizei count,
                                            DrawElementsType typePacked,
                                            const void *indices,
                                            GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
    CaptureDrawElementsInstancedEXT_indices(context, isCallValid, modePacked, count, typePacked,
                                            indices, primcount, &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(gl::EntryPoint::DrawElementsInstancedEXT, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribDivisorEXT(const Context *context,
                                          bool isCallValid,
                                          GLuint index,
                                          GLuint divisor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("divisor", ParamType::TGLuint, divisor);

    return CallCapture(gl::EntryPoint::VertexAttribDivisorEXT, std::move(paramBuffer));
}

CallCapture CaptureFlushMappedBufferRangeEXT(const Context *context,
                                             bool isCallValid,
                                             BufferBinding targetPacked,
                                             GLintptr offset,
                                             GLsizeiptr length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);

    return CallCapture(gl::EntryPoint::FlushMappedBufferRangeEXT, std::move(paramBuffer));
}

CallCapture CaptureMapBufferRangeEXT(const Context *context,
                                     bool isCallValid,
                                     BufferBinding targetPacked,
                                     GLintptr offset,
                                     GLsizeiptr length,
                                     GLbitfield access,
                                     void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);
    paramBuffer.addEnumParam("access", GLenumGroup::BufferAccessMask, ParamType::TGLbitfield,
                             access);

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::MapBufferRangeEXT, std::move(paramBuffer));
}

CallCapture CaptureBufferStorageMemEXT(const Context *context,
                                       bool isCallValid,
                                       TextureType targetPacked,
                                       GLsizeiptr size,
                                       MemoryObjectID memoryPacked,
                                       GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(gl::EntryPoint::BufferStorageMemEXT, std::move(paramBuffer));
}

CallCapture CaptureCreateMemoryObjectsEXT(const Context *context,
                                          bool isCallValid,
                                          GLsizei n,
                                          MemoryObjectID *memoryObjectsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture memoryObjectsPackedParam("memoryObjectsPacked", ParamType::TMemoryObjectIDPointer);
    InitParamValue(ParamType::TMemoryObjectIDPointer, memoryObjectsPacked,
                   &memoryObjectsPackedParam.value);
    CaptureCreateMemoryObjectsEXT_memoryObjectsPacked(context, isCallValid, n, memoryObjectsPacked,
                                                      &memoryObjectsPackedParam);
    paramBuffer.addParam(std::move(memoryObjectsPackedParam));

    return CallCapture(gl::EntryPoint::CreateMemoryObjectsEXT, std::move(paramBuffer));
}

CallCapture CaptureDeleteMemoryObjectsEXT(const Context *context,
                                          bool isCallValid,
                                          GLsizei n,
                                          const MemoryObjectID *memoryObjectsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture memoryObjectsPackedParam("memoryObjectsPacked",
                                          ParamType::TMemoryObjectIDConstPointer);
    InitParamValue(ParamType::TMemoryObjectIDConstPointer, memoryObjectsPacked,
                   &memoryObjectsPackedParam.value);
    CaptureDeleteMemoryObjectsEXT_memoryObjectsPacked(context, isCallValid, n, memoryObjectsPacked,
                                                      &memoryObjectsPackedParam);
    paramBuffer.addParam(std::move(memoryObjectsPackedParam));

    return CallCapture(gl::EntryPoint::DeleteMemoryObjectsEXT, std::move(paramBuffer));
}

CallCapture CaptureGetMemoryObjectParameterivEXT(const Context *context,
                                                 bool isCallValid,
                                                 MemoryObjectID memoryObjectPacked,
                                                 GLenum pname,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryObjectPacked", ParamType::TMemoryObjectID, memoryObjectPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::MemoryObjectParameterName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetMemoryObjectParameterivEXT_params(context, isCallValid, memoryObjectPacked, pname,
                                                params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetMemoryObjectParameterivEXT, std::move(paramBuffer));
}

CallCapture CaptureGetUnsignedBytevEXT(const Context *context,
                                       bool isCallValid,
                                       GLenum pname,
                                       GLubyte *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::GetPName, ParamType::TGLenum, pname);

    ParamCapture dataParam("data", ParamType::TGLubytePointer);
    InitParamValue(ParamType::TGLubytePointer, data, &dataParam.value);
    CaptureGetUnsignedBytevEXT_data(context, isCallValid, pname, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::GetUnsignedBytevEXT, std::move(paramBuffer));
}

CallCapture CaptureGetUnsignedBytei_vEXT(const Context *context,
                                         bool isCallValid,
                                         GLenum target,
                                         GLuint index,
                                         GLubyte *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture dataParam("data", ParamType::TGLubytePointer);
    InitParamValue(ParamType::TGLubytePointer, data, &dataParam.value);
    CaptureGetUnsignedBytei_vEXT_data(context, isCallValid, target, index, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::GetUnsignedBytei_vEXT, std::move(paramBuffer));
}

CallCapture CaptureIsMemoryObjectEXT(const Context *context,
                                     bool isCallValid,
                                     MemoryObjectID memoryObjectPacked,
                                     GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryObjectPacked", ParamType::TMemoryObjectID, memoryObjectPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsMemoryObjectEXT, std::move(paramBuffer));
}

CallCapture CaptureMemoryObjectParameterivEXT(const Context *context,
                                              bool isCallValid,
                                              MemoryObjectID memoryObjectPacked,
                                              GLenum pname,
                                              const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryObjectPacked", ParamType::TMemoryObjectID, memoryObjectPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::MemoryObjectParameterName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureMemoryObjectParameterivEXT_params(context, isCallValid, memoryObjectPacked, pname,
                                             params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::MemoryObjectParameterivEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem2DEXT(const Context *context,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLsizei levels,
                                      GLenum internalFormat,
                                      GLsizei width,
                                      GLsizei height,
                                      MemoryObjectID memoryPacked,
                                      GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(gl::EntryPoint::TexStorageMem2DEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem2DMultisampleEXT(const Context *context,
                                                 bool isCallValid,
                                                 TextureType targetPacked,
                                                 GLsizei samples,
                                                 GLenum internalFormat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLboolean fixedSampleLocations,
                                                 MemoryObjectID memoryPacked,
                                                 GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedSampleLocations", ParamType::TGLboolean, fixedSampleLocations);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(gl::EntryPoint::TexStorageMem2DMultisampleEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem3DEXT(const Context *context,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLsizei levels,
                                      GLenum internalFormat,
                                      GLsizei width,
                                      GLsizei height,
                                      GLsizei depth,
                                      MemoryObjectID memoryPacked,
                                      GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(gl::EntryPoint::TexStorageMem3DEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem3DMultisampleEXT(const Context *context,
                                                 bool isCallValid,
                                                 TextureType targetPacked,
                                                 GLsizei samples,
                                                 GLenum internalFormat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLsizei depth,
                                                 GLboolean fixedSampleLocations,
                                                 MemoryObjectID memoryPacked,
                                                 GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedSampleLocations", ParamType::TGLboolean, fixedSampleLocations);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(gl::EntryPoint::TexStorageMem3DMultisampleEXT, std::move(paramBuffer));
}

CallCapture CaptureImportMemoryFdEXT(const Context *context,
                                     bool isCallValid,
                                     MemoryObjectID memoryPacked,
                                     GLuint64 size,
                                     HandleType handleTypePacked,
                                     GLint fd)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("size", ParamType::TGLuint64, size);
    paramBuffer.addValueParam("handleTypePacked", ParamType::THandleType, handleTypePacked);
    paramBuffer.addValueParam("fd", ParamType::TGLint, fd);

    return CallCapture(gl::EntryPoint::ImportMemoryFdEXT, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture2DMultisampleEXT(const Context *context,
                                                      bool isCallValid,
                                                      GLenum target,
                                                      GLenum attachment,
                                                      GLenum textarget,
                                                      GLuint texture,
                                                      GLint level,
                                                      GLsizei samples)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("textarget", GLenumGroup::TextureTarget, ParamType::TGLenum,
                             textarget);
    paramBuffer.addValueParam("texture", ParamType::TGLuint, texture);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);

    return CallCapture(gl::EntryPoint::FramebufferTexture2DMultisampleEXT, std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorageMultisampleEXT(const Context *context,
                                                     bool isCallValid,
                                                     GLenum target,
                                                     GLsizei samples,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::RenderbufferStorageMultisampleEXT, std::move(paramBuffer));
}

CallCapture CaptureGetGraphicsResetStatusEXT(const Context *context,
                                             bool isCallValid,
                                             GLenum returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetGraphicsResetStatusEXT, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformfvEXT(const Context *context,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLint location,
                                    GLsizei bufSize,
                                    GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetnUniformfvEXT_params(context, isCallValid, programPacked, location, bufSize, params,
                                   &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetnUniformfvEXT, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformivEXT(const Context *context,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLint location,
                                    GLsizei bufSize,
                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetnUniformivEXT_params(context, isCallValid, programPacked, location, bufSize, params,
                                   &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetnUniformivEXT, std::move(paramBuffer));
}

CallCapture CaptureReadnPixelsEXT(const Context *context,
                                  bool isCallValid,
                                  GLint x,
                                  GLint y,
                                  GLsizei width,
                                  GLsizei height,
                                  GLenum format,
                                  GLenum type,
                                  GLsizei bufSize,
                                  void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture dataParam("data", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
    CaptureReadnPixelsEXT_data(context, isCallValid, x, y, width, height, format, type, bufSize,
                               data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::ReadnPixelsEXT, std::move(paramBuffer));
}

CallCapture CaptureDeleteSemaphoresEXT(const Context *context,
                                       bool isCallValid,
                                       GLsizei n,
                                       const SemaphoreID *semaphoresPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture semaphoresPackedParam("semaphoresPacked", ParamType::TSemaphoreIDConstPointer);
    InitParamValue(ParamType::TSemaphoreIDConstPointer, semaphoresPacked,
                   &semaphoresPackedParam.value);
    CaptureDeleteSemaphoresEXT_semaphoresPacked(context, isCallValid, n, semaphoresPacked,
                                                &semaphoresPackedParam);
    paramBuffer.addParam(std::move(semaphoresPackedParam));

    return CallCapture(gl::EntryPoint::DeleteSemaphoresEXT, std::move(paramBuffer));
}

CallCapture CaptureGenSemaphoresEXT(const Context *context,
                                    bool isCallValid,
                                    GLsizei n,
                                    SemaphoreID *semaphoresPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture semaphoresPackedParam("semaphoresPacked", ParamType::TSemaphoreIDPointer);
    InitParamValue(ParamType::TSemaphoreIDPointer, semaphoresPacked, &semaphoresPackedParam.value);
    CaptureGenSemaphoresEXT_semaphoresPacked(context, isCallValid, n, semaphoresPacked,
                                             &semaphoresPackedParam);
    paramBuffer.addParam(std::move(semaphoresPackedParam));

    return CallCapture(gl::EntryPoint::GenSemaphoresEXT, std::move(paramBuffer));
}

CallCapture CaptureGetSemaphoreParameterui64vEXT(const Context *context,
                                                 bool isCallValid,
                                                 SemaphoreID semaphorePacked,
                                                 GLenum pname,
                                                 GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SemaphoreParameterName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
    InitParamValue(ParamType::TGLuint64Pointer, params, &paramsParam.value);
    CaptureGetSemaphoreParameterui64vEXT_params(context, isCallValid, semaphorePacked, pname,
                                                params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetSemaphoreParameterui64vEXT, std::move(paramBuffer));
}

CallCapture CaptureIsSemaphoreEXT(const Context *context,
                                  bool isCallValid,
                                  SemaphoreID semaphorePacked,
                                  GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsSemaphoreEXT, std::move(paramBuffer));
}

CallCapture CaptureSemaphoreParameterui64vEXT(const Context *context,
                                              bool isCallValid,
                                              SemaphoreID semaphorePacked,
                                              GLenum pname,
                                              const GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SemaphoreParameterName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLuint64ConstPointer);
    InitParamValue(ParamType::TGLuint64ConstPointer, params, &paramsParam.value);
    CaptureSemaphoreParameterui64vEXT_params(context, isCallValid, semaphorePacked, pname, params,
                                             &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::SemaphoreParameterui64vEXT, std::move(paramBuffer));
}

CallCapture CaptureSignalSemaphoreEXT(const Context *context,
                                      bool isCallValid,
                                      SemaphoreID semaphorePacked,
                                      GLuint numBufferBarriers,
                                      const BufferID *buffersPacked,
                                      GLuint numTextureBarriers,
                                      const TextureID *texturesPacked,
                                      const GLenum *dstLayouts)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addValueParam("numBufferBarriers", ParamType::TGLuint, numBufferBarriers);

    ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
    InitParamValue(ParamType::TBufferIDConstPointer, buffersPacked, &buffersPackedParam.value);
    CaptureSignalSemaphoreEXT_buffersPacked(context, isCallValid, semaphorePacked,
                                            numBufferBarriers, buffersPacked, numTextureBarriers,
                                            texturesPacked, dstLayouts, &buffersPackedParam);
    paramBuffer.addParam(std::move(buffersPackedParam));

    paramBuffer.addValueParam("numTextureBarriers", ParamType::TGLuint, numTextureBarriers);

    ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
    InitParamValue(ParamType::TTextureIDConstPointer, texturesPacked, &texturesPackedParam.value);
    CaptureSignalSemaphoreEXT_texturesPacked(context, isCallValid, semaphorePacked,
                                             numBufferBarriers, buffersPacked, numTextureBarriers,
                                             texturesPacked, dstLayouts, &texturesPackedParam);
    paramBuffer.addParam(std::move(texturesPackedParam));

    ParamCapture dstLayoutsParam("dstLayouts", ParamType::TGLenumConstPointer);
    InitParamValue(ParamType::TGLenumConstPointer, dstLayouts, &dstLayoutsParam.value);
    CaptureSignalSemaphoreEXT_dstLayouts(context, isCallValid, semaphorePacked, numBufferBarriers,
                                         buffersPacked, numTextureBarriers, texturesPacked,
                                         dstLayouts, &dstLayoutsParam);
    paramBuffer.addParam(std::move(dstLayoutsParam));

    return CallCapture(gl::EntryPoint::SignalSemaphoreEXT, std::move(paramBuffer));
}

CallCapture CaptureWaitSemaphoreEXT(const Context *context,
                                    bool isCallValid,
                                    SemaphoreID semaphorePacked,
                                    GLuint numBufferBarriers,
                                    const BufferID *buffersPacked,
                                    GLuint numTextureBarriers,
                                    const TextureID *texturesPacked,
                                    const GLenum *srcLayouts)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addValueParam("numBufferBarriers", ParamType::TGLuint, numBufferBarriers);

    ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
    InitParamValue(ParamType::TBufferIDConstPointer, buffersPacked, &buffersPackedParam.value);
    CaptureWaitSemaphoreEXT_buffersPacked(context, isCallValid, semaphorePacked, numBufferBarriers,
                                          buffersPacked, numTextureBarriers, texturesPacked,
                                          srcLayouts, &buffersPackedParam);
    paramBuffer.addParam(std::move(buffersPackedParam));

    paramBuffer.addValueParam("numTextureBarriers", ParamType::TGLuint, numTextureBarriers);

    ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
    InitParamValue(ParamType::TTextureIDConstPointer, texturesPacked, &texturesPackedParam.value);
    CaptureWaitSemaphoreEXT_texturesPacked(context, isCallValid, semaphorePacked, numBufferBarriers,
                                           buffersPacked, numTextureBarriers, texturesPacked,
                                           srcLayouts, &texturesPackedParam);
    paramBuffer.addParam(std::move(texturesPackedParam));

    ParamCapture srcLayoutsParam("srcLayouts", ParamType::TGLenumConstPointer);
    InitParamValue(ParamType::TGLenumConstPointer, srcLayouts, &srcLayoutsParam.value);
    CaptureWaitSemaphoreEXT_srcLayouts(context, isCallValid, semaphorePacked, numBufferBarriers,
                                       buffersPacked, numTextureBarriers, texturesPacked,
                                       srcLayouts, &srcLayoutsParam);
    paramBuffer.addParam(std::move(srcLayoutsParam));

    return CallCapture(gl::EntryPoint::WaitSemaphoreEXT, std::move(paramBuffer));
}

CallCapture CaptureImportSemaphoreFdEXT(const Context *context,
                                        bool isCallValid,
                                        SemaphoreID semaphorePacked,
                                        HandleType handleTypePacked,
                                        GLint fd)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addValueParam("handleTypePacked", ParamType::THandleType, handleTypePacked);
    paramBuffer.addValueParam("fd", ParamType::TGLint, fd);

    return CallCapture(gl::EntryPoint::ImportSemaphoreFdEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorage1DEXT(const Context *context,
                                   bool isCallValid,
                                   GLenum target,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);

    return CallCapture(gl::EntryPoint::TexStorage1DEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorage2DEXT(const Context *context,
                                   bool isCallValid,
                                   TextureType targetPacked,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width,
                                   GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::TexStorage2DEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorage3DEXT(const Context *context,
                                   bool isCallValid,
                                   TextureType targetPacked,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width,
                                   GLsizei height,
                                   GLsizei depth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);

    return CallCapture(gl::EntryPoint::TexStorage3DEXT, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageCallbackKHR(const Context *context,
                                           bool isCallValid,
                                           GLDEBUGPROCKHR callback,
                                           const void *userParam)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("callback", ParamType::TGLDEBUGPROCKHR, callback);

    ParamCapture userParamParam("userParam", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, userParam, &userParamParam.value);
    CaptureDebugMessageCallbackKHR_userParam(context, isCallValid, callback, userParam,
                                             &userParamParam);
    paramBuffer.addParam(std::move(userParamParam));

    return CallCapture(gl::EntryPoint::DebugMessageCallbackKHR, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageControlKHR(const Context *context,
                                          bool isCallValid,
                                          GLenum source,
                                          GLenum type,
                                          GLenum severity,
                                          GLsizei count,
                                          const GLuint *ids,
                                          GLboolean enabled)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLenumGroup::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addEnumParam("type", GLenumGroup::DebugType, ParamType::TGLenum, type);
    paramBuffer.addEnumParam("severity", GLenumGroup::DebugSeverity, ParamType::TGLenum, severity);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture idsParam("ids", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, ids, &idsParam.value);
    CaptureDebugMessageControlKHR_ids(context, isCallValid, source, type, severity, count, ids,
                                      enabled, &idsParam);
    paramBuffer.addParam(std::move(idsParam));

    paramBuffer.addValueParam("enabled", ParamType::TGLboolean, enabled);

    return CallCapture(gl::EntryPoint::DebugMessageControlKHR, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageInsertKHR(const Context *context,
                                         bool isCallValid,
                                         GLenum source,
                                         GLenum type,
                                         GLuint id,
                                         GLenum severity,
                                         GLsizei length,
                                         const GLchar *buf)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLenumGroup::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addEnumParam("type", GLenumGroup::DebugType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addEnumParam("severity", GLenumGroup::DebugSeverity, ParamType::TGLenum, severity);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture bufParam("buf", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, buf, &bufParam.value);
    CaptureDebugMessageInsertKHR_buf(context, isCallValid, source, type, id, severity, length, buf,
                                     &bufParam);
    paramBuffer.addParam(std::move(bufParam));

    return CallCapture(gl::EntryPoint::DebugMessageInsertKHR, std::move(paramBuffer));
}

CallCapture CaptureGetDebugMessageLogKHR(const Context *context,
                                         bool isCallValid,
                                         GLuint count,
                                         GLsizei bufSize,
                                         GLenum *sources,
                                         GLenum *types,
                                         GLuint *ids,
                                         GLenum *severities,
                                         GLsizei *lengths,
                                         GLchar *messageLog,
                                         GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLuint, count);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture sourcesParam("sources", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, sources, &sourcesParam.value);
    CaptureGetDebugMessageLogKHR_sources(context, isCallValid, count, bufSize, sources, types, ids,
                                         severities, lengths, messageLog, &sourcesParam);
    paramBuffer.addParam(std::move(sourcesParam));

    ParamCapture typesParam("types", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, types, &typesParam.value);
    CaptureGetDebugMessageLogKHR_types(context, isCallValid, count, bufSize, sources, types, ids,
                                       severities, lengths, messageLog, &typesParam);
    paramBuffer.addParam(std::move(typesParam));

    ParamCapture idsParam("ids", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, ids, &idsParam.value);
    CaptureGetDebugMessageLogKHR_ids(context, isCallValid, count, bufSize, sources, types, ids,
                                     severities, lengths, messageLog, &idsParam);
    paramBuffer.addParam(std::move(idsParam));

    ParamCapture severitiesParam("severities", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, severities, &severitiesParam.value);
    CaptureGetDebugMessageLogKHR_severities(context, isCallValid, count, bufSize, sources, types,
                                            ids, severities, lengths, messageLog, &severitiesParam);
    paramBuffer.addParam(std::move(severitiesParam));

    ParamCapture lengthsParam("lengths", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, lengths, &lengthsParam.value);
    CaptureGetDebugMessageLogKHR_lengths(context, isCallValid, count, bufSize, sources, types, ids,
                                         severities, lengths, messageLog, &lengthsParam);
    paramBuffer.addParam(std::move(lengthsParam));

    ParamCapture messageLogParam("messageLog", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, messageLog, &messageLogParam.value);
    CaptureGetDebugMessageLogKHR_messageLog(context, isCallValid, count, bufSize, sources, types,
                                            ids, severities, lengths, messageLog, &messageLogParam);
    paramBuffer.addParam(std::move(messageLogParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetDebugMessageLogKHR, std::move(paramBuffer));
}

CallCapture CaptureGetObjectLabelKHR(const Context *context,
                                     bool isCallValid,
                                     GLenum identifier,
                                     GLuint name,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("identifier", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             identifier);
    paramBuffer.addValueParam("name", ParamType::TGLuint, name);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetObjectLabelKHR_length(context, isCallValid, identifier, name, bufSize, length, label,
                                    &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture labelParam("label", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, label, &labelParam.value);
    CaptureGetObjectLabelKHR_label(context, isCallValid, identifier, name, bufSize, length, label,
                                   &labelParam);
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture(gl::EntryPoint::GetObjectLabelKHR, std::move(paramBuffer));
}

CallCapture CaptureGetObjectPtrLabelKHR(const Context *context,
                                        bool isCallValid,
                                        const void *ptr,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLchar *label)
{
    ParamBuffer paramBuffer;

    ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
    CaptureGetObjectPtrLabelKHR_ptr(context, isCallValid, ptr, bufSize, length, label, &ptrParam);
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetObjectPtrLabelKHR_length(context, isCallValid, ptr, bufSize, length, label,
                                       &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture labelParam("label", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, label, &labelParam.value);
    CaptureGetObjectPtrLabelKHR_label(context, isCallValid, ptr, bufSize, length, label,
                                      &labelParam);
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture(gl::EntryPoint::GetObjectPtrLabelKHR, std::move(paramBuffer));
}

CallCapture CaptureGetPointervKHR(const Context *context,
                                  bool isCallValid,
                                  GLenum pname,
                                  void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
    CaptureGetPointervKHR_params(context, isCallValid, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetPointervKHR, std::move(paramBuffer));
}

CallCapture CaptureObjectLabelKHR(const Context *context,
                                  bool isCallValid,
                                  GLenum identifier,
                                  GLuint name,
                                  GLsizei length,
                                  const GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("identifier", GLenumGroup::ObjectIdentifier, ParamType::TGLenum,
                             identifier);
    paramBuffer.addValueParam("name", ParamType::TGLuint, name);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, label, &labelParam.value);
    CaptureObjectLabelKHR_label(context, isCallValid, identifier, name, length, label, &labelParam);
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture(gl::EntryPoint::ObjectLabelKHR, std::move(paramBuffer));
}

CallCapture CaptureObjectPtrLabelKHR(const Context *context,
                                     bool isCallValid,
                                     const void *ptr,
                                     GLsizei length,
                                     const GLchar *label)
{
    ParamBuffer paramBuffer;

    ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
    CaptureObjectPtrLabelKHR_ptr(context, isCallValid, ptr, length, label, &ptrParam);
    paramBuffer.addParam(std::move(ptrParam));

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, label, &labelParam.value);
    CaptureObjectPtrLabelKHR_label(context, isCallValid, ptr, length, label, &labelParam);
    paramBuffer.addParam(std::move(labelParam));

    return CallCapture(gl::EntryPoint::ObjectPtrLabelKHR, std::move(paramBuffer));
}

CallCapture CapturePopDebugGroupKHR(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::PopDebugGroupKHR, std::move(paramBuffer));
}

CallCapture CapturePushDebugGroupKHR(const Context *context,
                                     bool isCallValid,
                                     GLenum source,
                                     GLuint id,
                                     GLsizei length,
                                     const GLchar *message)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLenumGroup::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    ParamCapture messageParam("message", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, message, &messageParam.value);
    CapturePushDebugGroupKHR_message(context, isCallValid, source, id, length, message,
                                     &messageParam);
    paramBuffer.addParam(std::move(messageParam));

    return CallCapture(gl::EntryPoint::PushDebugGroupKHR, std::move(paramBuffer));
}

CallCapture CaptureMaxShaderCompilerThreadsKHR(const Context *context,
                                               bool isCallValid,
                                               GLuint count)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLuint, count);

    return CallCapture(gl::EntryPoint::MaxShaderCompilerThreadsKHR, std::move(paramBuffer));
}

CallCapture CaptureDeleteFencesNV(const Context *context,
                                  bool isCallValid,
                                  GLsizei n,
                                  const FenceNVID *fencesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture fencesPackedParam("fencesPacked", ParamType::TFenceNVIDConstPointer);
    InitParamValue(ParamType::TFenceNVIDConstPointer, fencesPacked, &fencesPackedParam.value);
    CaptureDeleteFencesNV_fencesPacked(context, isCallValid, n, fencesPacked, &fencesPackedParam);
    paramBuffer.addParam(std::move(fencesPackedParam));

    return CallCapture(gl::EntryPoint::DeleteFencesNV, std::move(paramBuffer));
}

CallCapture CaptureFinishFenceNV(const Context *context, bool isCallValid, FenceNVID fencePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);

    return CallCapture(gl::EntryPoint::FinishFenceNV, std::move(paramBuffer));
}

CallCapture CaptureGenFencesNV(const Context *context,
                               bool isCallValid,
                               GLsizei n,
                               FenceNVID *fencesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture fencesPackedParam("fencesPacked", ParamType::TFenceNVIDPointer);
    InitParamValue(ParamType::TFenceNVIDPointer, fencesPacked, &fencesPackedParam.value);
    CaptureGenFencesNV_fencesPacked(context, isCallValid, n, fencesPacked, &fencesPackedParam);
    paramBuffer.addParam(std::move(fencesPackedParam));

    return CallCapture(gl::EntryPoint::GenFencesNV, std::move(paramBuffer));
}

CallCapture CaptureGetFenceivNV(const Context *context,
                                bool isCallValid,
                                FenceNVID fencePacked,
                                GLenum pname,
                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetFenceivNV_params(context, isCallValid, fencePacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetFenceivNV, std::move(paramBuffer));
}

CallCapture CaptureIsFenceNV(const Context *context,
                             bool isCallValid,
                             FenceNVID fencePacked,
                             GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsFenceNV, std::move(paramBuffer));
}

CallCapture CaptureSetFenceNV(const Context *context,
                              bool isCallValid,
                              FenceNVID fencePacked,
                              GLenum condition)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);
    paramBuffer.addEnumParam("condition", GLenumGroup::DefaultGroup, ParamType::TGLenum, condition);

    return CallCapture(gl::EntryPoint::SetFenceNV, std::move(paramBuffer));
}

CallCapture CaptureTestFenceNV(const Context *context,
                               bool isCallValid,
                               FenceNVID fencePacked,
                               GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::TestFenceNV, std::move(paramBuffer));
}

CallCapture CaptureEGLImageTargetRenderbufferStorageOES(const Context *context,
                                                        bool isCallValid,
                                                        GLenum target,
                                                        GLeglImageOES image)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addValueParam("image", ParamType::TGLeglImageOES, image);

    return CallCapture(gl::EntryPoint::EGLImageTargetRenderbufferStorageOES,
                       std::move(paramBuffer));
}

CallCapture CaptureEGLImageTargetTexture2DOES(const Context *context,
                                              bool isCallValid,
                                              TextureType targetPacked,
                                              GLeglImageOES image)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("image", ParamType::TGLeglImageOES, image);

    return CallCapture(gl::EntryPoint::EGLImageTargetTexture2DOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexfOES(const Context *context,
                               bool isCallValid,
                               GLfloat x,
                               GLfloat y,
                               GLfloat z,
                               GLfloat width,
                               GLfloat height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);
    paramBuffer.addValueParam("width", ParamType::TGLfloat, width);
    paramBuffer.addValueParam("height", ParamType::TGLfloat, height);

    return CallCapture(gl::EntryPoint::DrawTexfOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexfvOES(const Context *context, bool isCallValid, const GLfloat *coords)
{
    ParamBuffer paramBuffer;

    ParamCapture coordsParam("coords", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, coords, &coordsParam.value);
    CaptureDrawTexfvOES_coords(context, isCallValid, coords, &coordsParam);
    paramBuffer.addParam(std::move(coordsParam));

    return CallCapture(gl::EntryPoint::DrawTexfvOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexiOES(const Context *context,
                               bool isCallValid,
                               GLint x,
                               GLint y,
                               GLint z,
                               GLint width,
                               GLint height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);
    paramBuffer.addValueParam("width", ParamType::TGLint, width);
    paramBuffer.addValueParam("height", ParamType::TGLint, height);

    return CallCapture(gl::EntryPoint::DrawTexiOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexivOES(const Context *context, bool isCallValid, const GLint *coords)
{
    ParamBuffer paramBuffer;

    ParamCapture coordsParam("coords", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, coords, &coordsParam.value);
    CaptureDrawTexivOES_coords(context, isCallValid, coords, &coordsParam);
    paramBuffer.addParam(std::move(coordsParam));

    return CallCapture(gl::EntryPoint::DrawTexivOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexsOES(const Context *context,
                               bool isCallValid,
                               GLshort x,
                               GLshort y,
                               GLshort z,
                               GLshort width,
                               GLshort height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLshort, x);
    paramBuffer.addValueParam("y", ParamType::TGLshort, y);
    paramBuffer.addValueParam("z", ParamType::TGLshort, z);
    paramBuffer.addValueParam("width", ParamType::TGLshort, width);
    paramBuffer.addValueParam("height", ParamType::TGLshort, height);

    return CallCapture(gl::EntryPoint::DrawTexsOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexsvOES(const Context *context, bool isCallValid, const GLshort *coords)
{
    ParamBuffer paramBuffer;

    ParamCapture coordsParam("coords", ParamType::TGLshortConstPointer);
    InitParamValue(ParamType::TGLshortConstPointer, coords, &coordsParam.value);
    CaptureDrawTexsvOES_coords(context, isCallValid, coords, &coordsParam);
    paramBuffer.addParam(std::move(coordsParam));

    return CallCapture(gl::EntryPoint::DrawTexsvOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexxOES(const Context *context,
                               bool isCallValid,
                               GLfixed x,
                               GLfixed y,
                               GLfixed z,
                               GLfixed width,
                               GLfixed height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfixed, x);
    paramBuffer.addValueParam("y", ParamType::TGLfixed, y);
    paramBuffer.addValueParam("z", ParamType::TGLfixed, z);
    paramBuffer.addValueParam("width", ParamType::TGLfixed, width);
    paramBuffer.addValueParam("height", ParamType::TGLfixed, height);

    return CallCapture(gl::EntryPoint::DrawTexxOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexxvOES(const Context *context, bool isCallValid, const GLfixed *coords)
{
    ParamBuffer paramBuffer;

    ParamCapture coordsParam("coords", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, coords, &coordsParam.value);
    CaptureDrawTexxvOES_coords(context, isCallValid, coords, &coordsParam);
    paramBuffer.addParam(std::move(coordsParam));

    return CallCapture(gl::EntryPoint::DrawTexxvOES, std::move(paramBuffer));
}

CallCapture CaptureBindFramebufferOES(const Context *context,
                                      bool isCallValid,
                                      GLenum target,
                                      FramebufferID framebufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);

    return CallCapture(gl::EntryPoint::BindFramebufferOES, std::move(paramBuffer));
}

CallCapture CaptureBindRenderbufferOES(const Context *context,
                                       bool isCallValid,
                                       GLenum target,
                                       RenderbufferID renderbufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    return CallCapture(gl::EntryPoint::BindRenderbufferOES, std::move(paramBuffer));
}

CallCapture CaptureCheckFramebufferStatusOES(const Context *context,
                                             bool isCallValid,
                                             GLenum target,
                                             GLenum returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::CheckFramebufferStatusOES, std::move(paramBuffer));
}

CallCapture CaptureDeleteFramebuffersOES(const Context *context,
                                         bool isCallValid,
                                         GLsizei n,
                                         const FramebufferID *framebuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture framebuffersPackedParam("framebuffersPacked",
                                         ParamType::TFramebufferIDConstPointer);
    InitParamValue(ParamType::TFramebufferIDConstPointer, framebuffersPacked,
                   &framebuffersPackedParam.value);
    CaptureDeleteFramebuffersOES_framebuffersPacked(context, isCallValid, n, framebuffersPacked,
                                                    &framebuffersPackedParam);
    paramBuffer.addParam(std::move(framebuffersPackedParam));

    return CallCapture(gl::EntryPoint::DeleteFramebuffersOES, std::move(paramBuffer));
}

CallCapture CaptureDeleteRenderbuffersOES(const Context *context,
                                          bool isCallValid,
                                          GLsizei n,
                                          const RenderbufferID *renderbuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture renderbuffersPackedParam("renderbuffersPacked",
                                          ParamType::TRenderbufferIDConstPointer);
    InitParamValue(ParamType::TRenderbufferIDConstPointer, renderbuffersPacked,
                   &renderbuffersPackedParam.value);
    CaptureDeleteRenderbuffersOES_renderbuffersPacked(context, isCallValid, n, renderbuffersPacked,
                                                      &renderbuffersPackedParam);
    paramBuffer.addParam(std::move(renderbuffersPackedParam));

    return CallCapture(gl::EntryPoint::DeleteRenderbuffersOES, std::move(paramBuffer));
}

CallCapture CaptureFramebufferRenderbufferOES(const Context *context,
                                              bool isCallValid,
                                              GLenum target,
                                              GLenum attachment,
                                              GLenum renderbuffertarget,
                                              RenderbufferID renderbufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("renderbuffertarget", GLenumGroup::RenderbufferTarget,
                             ParamType::TGLenum, renderbuffertarget);
    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    return CallCapture(gl::EntryPoint::FramebufferRenderbufferOES, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture2DOES(const Context *context,
                                           bool isCallValid,
                                           GLenum target,
                                           GLenum attachment,
                                           TextureTarget textargetPacked,
                                           TextureID texturePacked,
                                           GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(gl::EntryPoint::FramebufferTexture2DOES, std::move(paramBuffer));
}

CallCapture CaptureGenFramebuffersOES(const Context *context,
                                      bool isCallValid,
                                      GLsizei n,
                                      FramebufferID *framebuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture framebuffersPackedParam("framebuffersPacked", ParamType::TFramebufferIDPointer);
    InitParamValue(ParamType::TFramebufferIDPointer, framebuffersPacked,
                   &framebuffersPackedParam.value);
    CaptureGenFramebuffersOES_framebuffersPacked(context, isCallValid, n, framebuffersPacked,
                                                 &framebuffersPackedParam);
    paramBuffer.addParam(std::move(framebuffersPackedParam));

    return CallCapture(gl::EntryPoint::GenFramebuffersOES, std::move(paramBuffer));
}

CallCapture CaptureGenRenderbuffersOES(const Context *context,
                                       bool isCallValid,
                                       GLsizei n,
                                       RenderbufferID *renderbuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture renderbuffersPackedParam("renderbuffersPacked", ParamType::TRenderbufferIDPointer);
    InitParamValue(ParamType::TRenderbufferIDPointer, renderbuffersPacked,
                   &renderbuffersPackedParam.value);
    CaptureGenRenderbuffersOES_renderbuffersPacked(context, isCallValid, n, renderbuffersPacked,
                                                   &renderbuffersPackedParam);
    paramBuffer.addParam(std::move(renderbuffersPackedParam));

    return CallCapture(gl::EntryPoint::GenRenderbuffersOES, std::move(paramBuffer));
}

CallCapture CaptureGenerateMipmapOES(const Context *context,
                                     bool isCallValid,
                                     TextureType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);

    return CallCapture(gl::EntryPoint::GenerateMipmapOES, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferAttachmentParameterivOES(const Context *context,
                                                          bool isCallValid,
                                                          GLenum target,
                                                          GLenum attachment,
                                                          GLenum pname,
                                                          GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("pname", GLenumGroup::FramebufferAttachmentParameterName,
                             ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetFramebufferAttachmentParameterivOES_params(context, isCallValid, target, attachment,
                                                         pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetFramebufferAttachmentParameterivOES,
                       std::move(paramBuffer));
}

CallCapture CaptureGetRenderbufferParameterivOES(const Context *context,
                                                 bool isCallValid,
                                                 GLenum target,
                                                 GLenum pname,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLenumGroup::RenderbufferParameterName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetRenderbufferParameterivOES_params(context, isCallValid, target, pname, params,
                                                &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetRenderbufferParameterivOES, std::move(paramBuffer));
}

CallCapture CaptureIsFramebufferOES(const Context *context,
                                    bool isCallValid,
                                    FramebufferID framebufferPacked,
                                    GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsFramebufferOES, std::move(paramBuffer));
}

CallCapture CaptureIsRenderbufferOES(const Context *context,
                                     bool isCallValid,
                                     RenderbufferID renderbufferPacked,
                                     GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsRenderbufferOES, std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorageOES(const Context *context,
                                          bool isCallValid,
                                          GLenum target,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::RenderbufferStorageOES, std::move(paramBuffer));
}

CallCapture CaptureGetProgramBinaryOES(const Context *context,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       GLsizei bufSize,
                                       GLsizei *length,
                                       GLenum *binaryFormat,
                                       void *binary)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetProgramBinaryOES_length(context, isCallValid, programPacked, bufSize, length,
                                      binaryFormat, binary, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture binaryFormatParam("binaryFormat", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, binaryFormat, &binaryFormatParam.value);
    CaptureGetProgramBinaryOES_binaryFormat(context, isCallValid, programPacked, bufSize, length,
                                            binaryFormat, binary, &binaryFormatParam);
    paramBuffer.addParam(std::move(binaryFormatParam));

    ParamCapture binaryParam("binary", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, binary, &binaryParam.value);
    CaptureGetProgramBinaryOES_binary(context, isCallValid, programPacked, bufSize, length,
                                      binaryFormat, binary, &binaryParam);
    paramBuffer.addParam(std::move(binaryParam));

    return CallCapture(gl::EntryPoint::GetProgramBinaryOES, std::move(paramBuffer));
}

CallCapture CaptureProgramBinaryOES(const Context *context,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLenum binaryFormat,
                                    const void *binary,
                                    GLint length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("binaryFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             binaryFormat);

    ParamCapture binaryParam("binary", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, binary, &binaryParam.value);
    CaptureProgramBinaryOES_binary(context, isCallValid, programPacked, binaryFormat, binary,
                                   length, &binaryParam);
    paramBuffer.addParam(std::move(binaryParam));

    paramBuffer.addValueParam("length", ParamType::TGLint, length);

    return CallCapture(gl::EntryPoint::ProgramBinaryOES, std::move(paramBuffer));
}

CallCapture CaptureGetBufferPointervOES(const Context *context,
                                        bool isCallValid,
                                        BufferBinding targetPacked,
                                        GLenum pname,
                                        void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
    CaptureGetBufferPointervOES_params(context, isCallValid, targetPacked, pname, params,
                                       &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetBufferPointervOES, std::move(paramBuffer));
}

CallCapture CaptureMapBufferOES(const Context *context,
                                bool isCallValid,
                                BufferBinding targetPacked,
                                GLenum access,
                                void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("access", GLenumGroup::BufferAccessARB, ParamType::TGLenum, access);

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::MapBufferOES, std::move(paramBuffer));
}

CallCapture CaptureUnmapBufferOES(const Context *context,
                                  bool isCallValid,
                                  BufferBinding targetPacked,
                                  GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::UnmapBufferOES, std::move(paramBuffer));
}

CallCapture CaptureCurrentPaletteMatrixOES(const Context *context,
                                           bool isCallValid,
                                           GLuint matrixpaletteindex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("matrixpaletteindex", ParamType::TGLuint, matrixpaletteindex);

    return CallCapture(gl::EntryPoint::CurrentPaletteMatrixOES, std::move(paramBuffer));
}

CallCapture CaptureLoadPaletteFromModelViewMatrixOES(const Context *context, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::LoadPaletteFromModelViewMatrixOES, std::move(paramBuffer));
}

CallCapture CaptureMatrixIndexPointerOES(const Context *context,
                                         bool isCallValid,
                                         GLint size,
                                         GLenum type,
                                         GLsizei stride,
                                         const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
    CaptureMatrixIndexPointerOES_pointer(context, isCallValid, size, type, stride, pointer,
                                         &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture(gl::EntryPoint::MatrixIndexPointerOES, std::move(paramBuffer));
}

CallCapture CaptureWeightPointerOES(const Context *context,
                                    bool isCallValid,
                                    GLint size,
                                    GLenum type,
                                    GLsizei stride,
                                    const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
    CaptureWeightPointerOES_pointer(context, isCallValid, size, type, stride, pointer,
                                    &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture(gl::EntryPoint::WeightPointerOES, std::move(paramBuffer));
}

CallCapture CapturePointSizePointerOES(const Context *context,
                                       bool isCallValid,
                                       VertexAttribType typePacked,
                                       GLsizei stride,
                                       const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
    CapturePointSizePointerOES_pointer(context, isCallValid, typePacked, stride, pointer,
                                       &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture(gl::EntryPoint::PointSizePointerOES, std::move(paramBuffer));
}

CallCapture CaptureQueryMatrixxOES(const Context *context,
                                   bool isCallValid,
                                   GLfixed *mantissa,
                                   GLint *exponent,
                                   GLbitfield returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture mantissaParam("mantissa", ParamType::TGLfixedPointer);
    InitParamValue(ParamType::TGLfixedPointer, mantissa, &mantissaParam.value);
    CaptureQueryMatrixxOES_mantissa(context, isCallValid, mantissa, exponent, &mantissaParam);
    paramBuffer.addParam(std::move(mantissaParam));

    ParamCapture exponentParam("exponent", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, exponent, &exponentParam.value);
    CaptureQueryMatrixxOES_exponent(context, isCallValid, mantissa, exponent, &exponentParam);
    paramBuffer.addParam(std::move(exponentParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLbitfield);
    InitParamValue(ParamType::TGLbitfield, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::QueryMatrixxOES, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage3DOES(const Context *context,
                                           bool isCallValid,
                                           TextureTarget targetPacked,
                                           GLint level,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLint border,
                                           GLsizei imageSize,
                                           const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexImage3DOES_data(context, isCallValid, targetPacked, level, internalformat,
                                        width, height, depth, border, imageSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::CompressedTexImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage3DOES(const Context *context,
                                              bool isCallValid,
                                              TextureTarget targetPacked,
                                              GLint level,
                                              GLint xoffset,
                                              GLint yoffset,
                                              GLint zoffset,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLenum format,
                                              GLsizei imageSize,
                                              const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexSubImage3DOES_data(context, isCallValid, targetPacked, level, xoffset,
                                           yoffset, zoffset, width, height, depth, format,
                                           imageSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::CompressedTexSubImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureCopyTexSubImage3DOES(const Context *context,
                                        bool isCallValid,
                                        TextureTarget targetPacked,
                                        GLint level,
                                        GLint xoffset,
                                        GLint yoffset,
                                        GLint zoffset,
                                        GLint x,
                                        GLint y,
                                        GLsizei width,
                                        GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::CopyTexSubImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture3DOES(const Context *context,
                                           bool isCallValid,
                                           GLenum target,
                                           GLenum attachment,
                                           TextureTarget textargetPacked,
                                           TextureID texturePacked,
                                           GLint level,
                                           GLint zoffset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);

    return CallCapture(gl::EntryPoint::FramebufferTexture3DOES, std::move(paramBuffer));
}

CallCapture CaptureTexImage3DOES(const Context *context,
                                 bool isCallValid,
                                 TextureTarget targetPacked,
                                 GLint level,
                                 GLenum internalformat,
                                 GLsizei width,
                                 GLsizei height,
                                 GLsizei depth,
                                 GLint border,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexImage3DOES_pixels(context, isCallValid, targetPacked, level, internalformat, width,
                                height, depth, border, format, type, pixels, &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(gl::EntryPoint::TexImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureTexSubImage3DOES(const Context *context,
                                    bool isCallValid,
                                    TextureTarget targetPacked,
                                    GLint level,
                                    GLint xoffset,
                                    GLint yoffset,
                                    GLint zoffset,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth,
                                    GLenum format,
                                    GLenum type,
                                    const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexSubImage3DOES_pixels(context, isCallValid, targetPacked, level, xoffset, yoffset,
                                   zoffset, width, height, depth, format, type, pixels,
                                   &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(gl::EntryPoint::TexSubImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIivOES(const Context *context,
                                             bool isCallValid,
                                             SamplerID samplerPacked,
                                             GLenum pname,
                                             GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SamplerParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterIivOES_params(context, isCallValid, samplerPacked, pname, params,
                                            &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetSamplerParameterIivOES, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIuivOES(const Context *context,
                                              bool isCallValid,
                                              SamplerID samplerPacked,
                                              GLenum pname,
                                              GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SamplerParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetSamplerParameterIuivOES_params(context, isCallValid, samplerPacked, pname, params,
                                             &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetSamplerParameterIuivOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIivOES(const Context *context,
                                         bool isCallValid,
                                         TextureType targetPacked,
                                         GLenum pname,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexParameterIivOES_params(context, isCallValid, targetPacked, pname, params,
                                        &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexParameterIivOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIuivOES(const Context *context,
                                          bool isCallValid,
                                          TextureType targetPacked,
                                          GLenum pname,
                                          GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
    CaptureGetTexParameterIuivOES_params(context, isCallValid, targetPacked, pname, params,
                                         &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexParameterIuivOES, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIivOES(const Context *context,
                                          bool isCallValid,
                                          SamplerID samplerPacked,
                                          GLenum pname,
                                          const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SamplerParameterName, ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
    CaptureSamplerParameterIivOES_param(context, isCallValid, samplerPacked, pname, param,
                                        &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(gl::EntryPoint::SamplerParameterIivOES, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIuivOES(const Context *context,
                                           bool isCallValid,
                                           SamplerID samplerPacked,
                                           GLenum pname,
                                           const GLuint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SamplerParameterName, ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, param, &paramParam.value);
    CaptureSamplerParameterIuivOES_param(context, isCallValid, samplerPacked, pname, param,
                                         &paramParam);
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(gl::EntryPoint::SamplerParameterIuivOES, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIivOES(const Context *context,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLenum pname,
                                      const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureTexParameterIivOES_params(context, isCallValid, targetPacked, pname, params,
                                     &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexParameterIivOES, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIuivOES(const Context *context,
                                       bool isCallValid,
                                       TextureType targetPacked,
                                       GLenum pname,
                                       const GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
    InitParamValue(ParamType::TGLuintConstPointer, params, &paramsParam.value);
    CaptureTexParameterIuivOES_params(context, isCallValid, targetPacked, pname, params,
                                      &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexParameterIuivOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexGenfvOES(const Context *context,
                                  bool isCallValid,
                                  GLenum coord,
                                  GLenum pname,
                                  GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetTexGenfvOES_params(context, isCallValid, coord, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexGenfvOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexGenivOES(const Context *context,
                                  bool isCallValid,
                                  GLenum coord,
                                  GLenum pname,
                                  GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexGenivOES_params(context, isCallValid, coord, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexGenivOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexGenxvOES(const Context *context,
                                  bool isCallValid,
                                  GLenum coord,
                                  GLenum pname,
                                  GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
    InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
    CaptureGetTexGenxvOES_params(context, isCallValid, coord, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexGenxvOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenfOES(const Context *context,
                              bool isCallValid,
                              GLenum coord,
                              GLenum pname,
                              GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(gl::EntryPoint::TexGenfOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenfvOES(const Context *context,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
    CaptureTexGenfvOES_params(context, isCallValid, coord, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexGenfvOES, std::move(paramBuffer));
}

CallCapture CaptureTexGeniOES(const Context *context,
                              bool isCallValid,
                              GLenum coord,
                              GLenum pname,
                              GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(gl::EntryPoint::TexGeniOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenivOES(const Context *context,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureTexGenivOES_params(context, isCallValid, coord, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexGenivOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenxOES(const Context *context,
                              bool isCallValid,
                              GLenum coord,
                              GLenum pname,
                              GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(gl::EntryPoint::TexGenxOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenxvOES(const Context *context,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               const GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
    InitParamValue(ParamType::TGLfixedConstPointer, params, &paramsParam.value);
    CaptureTexGenxvOES_params(context, isCallValid, coord, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexGenxvOES, std::move(paramBuffer));
}

CallCapture CaptureTexStorage3DMultisampleOES(const Context *context,
                                              bool isCallValid,
                                              TextureType targetPacked,
                                              GLsizei samples,
                                              GLenum internalformat,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(gl::EntryPoint::TexStorage3DMultisampleOES, std::move(paramBuffer));
}

CallCapture CaptureBindVertexArrayOES(const Context *context,
                                      bool isCallValid,
                                      VertexArrayID arrayPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("arrayPacked", ParamType::TVertexArrayID, arrayPacked);

    return CallCapture(gl::EntryPoint::BindVertexArrayOES, std::move(paramBuffer));
}

CallCapture CaptureDeleteVertexArraysOES(const Context *context,
                                         bool isCallValid,
                                         GLsizei n,
                                         const VertexArrayID *arraysPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDConstPointer);
    InitParamValue(ParamType::TVertexArrayIDConstPointer, arraysPacked, &arraysPackedParam.value);
    CaptureDeleteVertexArraysOES_arraysPacked(context, isCallValid, n, arraysPacked,
                                              &arraysPackedParam);
    paramBuffer.addParam(std::move(arraysPackedParam));

    return CallCapture(gl::EntryPoint::DeleteVertexArraysOES, std::move(paramBuffer));
}

CallCapture CaptureGenVertexArraysOES(const Context *context,
                                      bool isCallValid,
                                      GLsizei n,
                                      VertexArrayID *arraysPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDPointer);
    InitParamValue(ParamType::TVertexArrayIDPointer, arraysPacked, &arraysPackedParam.value);
    CaptureGenVertexArraysOES_arraysPacked(context, isCallValid, n, arraysPacked,
                                           &arraysPackedParam);
    paramBuffer.addParam(std::move(arraysPackedParam));

    return CallCapture(gl::EntryPoint::GenVertexArraysOES, std::move(paramBuffer));
}

CallCapture CaptureIsVertexArrayOES(const Context *context,
                                    bool isCallValid,
                                    VertexArrayID arrayPacked,
                                    GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("arrayPacked", ParamType::TVertexArrayID, arrayPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsVertexArrayOES, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTextureMultiviewOVR(const Context *context,
                                                  bool isCallValid,
                                                  GLenum target,
                                                  GLenum attachment,
                                                  TextureID texturePacked,
                                                  GLint level,
                                                  GLint baseViewIndex,
                                                  GLsizei numViews)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("baseViewIndex", ParamType::TGLint, baseViewIndex);
    paramBuffer.addValueParam("numViews", ParamType::TGLsizei, numViews);

    return CallCapture(gl::EntryPoint::FramebufferTextureMultiviewOVR, std::move(paramBuffer));
}

}  // namespace gl
