// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_variables.json and
// builtin_function_declarations.txt.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_autogen.cpp: Wrapper for static or pool allocated char arrays, that are
// guaranteed to be valid and unchanged for the duration of the compilation. Implements
// mangledNameHash using perfect hash function from gen_builtin_symbols.py

#include "compiler/translator/ImmutableString.h"

std::ostream &operator<<(std::ostream &os, const sh::ImmutableString &str)
{
    return os.write(str.data(), str.length());
}

#if defined(_MSC_VER)
#    pragma warning(disable : 4309)  // truncation of constant value
#endif

namespace
{

constexpr int mangledkT1[] = {28,   3719, 1474, 371,  50,   3459, 1681, 2356, 3956, 3756,
                              2530, 2939, 2585, 1684, 466,  831,  1197, 860,  3743, 823,
                              945,  743,  1300, 3884, 1188, 1811, 3860, 247,  3587, 3445,
                              1378, 196,  1986, 2574, 1763, 270,  375};
constexpr int mangledkT2[] = {2796, 3900, 2561, 1177, 3275, 628,  2607, 1985, 3021, 1952,
                              2496, 12,   3389, 2911, 793,  3802, 3976, 2524, 3358, 3976,
                              1225, 3419, 713,  1823, 1060, 1685, 1757, 3007, 2148, 2610,
                              1187, 1753, 1371, 2631, 1828, 448,  2727};
constexpr int mangledkG[]  = {
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    3490, 0,    815,  0,    0,    0,    0,    0,    0,    0,    0,    851,
    0,    0,    0,    0,    367,  0,    0,    2143, 0,    0,    0,    0,    0,    755,  0,    0,
    0,    480,  0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    3688, 0,    0,    0,    0,    0,    374,  0,    0,    0,    0,    0,    1174, 0,    0,    0,
    0,    0,    0,    3822, 2622, 0,    0,    0,    0,    0,    0,    203,  615,  1725, 0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    1221, 0,    1263, 0,    0,    0,    0,
    0,    1306, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    2851, 0,
    0,    2886, 0,    0,    0,    0,    1046, 0,    0,    0,    0,    2765, 1204, 0,    3101, 0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    3059, 0,    0,    0,    2321, 3452, 0,
    0,    674,  0,    0,    1653, 0,    4009, 1635, 0,    0,    0,    0,    1940, 0,    0,    0,
    0,    0,    0,    0,    0,    1287, 4000, 0,    0,    1757, 2079, 0,    0,    0,    0,    0,
    2909, 0,    472,  0,    0,    0,    0,    1399, 0,    0,    0,    367,  0,    0,    0,    0,
    0,    201,  0,    0,    0,    0,    0,    0,    720,  0,    0,    0,    0,    318,  0,    0,
    0,    2981, 0,    0,    640,  0,    0,    0,    0,    875,  0,    467,  0,    0,    0,    1387,
    0,    0,    0,    468,  0,    3438, 428,  0,    0,    970,  0,    0,    0,    0,    1898, 0,
    2621, 727,  1889, 0,    0,    144,  0,    649,  0,    0,    0,    0,    0,    816,  3127, 73,
    0,    0,    0,    2194, 0,    0,    0,    0,    2623, 0,    0,    0,    1887, 3126, 0,    0,
    0,    0,    0,    0,    0,    3112, 0,    0,    0,    0,    0,    0,    3080, 0,    0,    3523,
    0,    2651, 0,    0,    0,    2927, 0,    237,  0,    0,    0,    1720, 1511, 0,    1036, 0,
    592,  0,    0,    3123, 0,    0,    0,    0,    0,    241,  0,    0,    1919, 0,    753,  0,
    35,   537,  0,    0,    0,    0,    0,    1744, 0,    2854, 1643, 229,  0,    1554, 0,    0,
    2594, 1801, 3855, 0,    183,  1341, 3695, 2786, 0,    3079, 0,    0,    512,  0,    0,    0,
    0,    0,    2443, 0,    0,    3887, 0,    1643, 0,    0,    0,    0,    0,    0,    0,    0,
    1192, 3358, 409,  0,    0,    0,    2952, 0,    0,    0,    1349, 3404, 0,    0,    0,    0,
    0,    0,    1944, 226,  0,    0,    550,  0,    0,    0,    0,    0,    0,    0,    64,   74,
    0,    0,    0,    0,    0,    2521, 0,    0,    0,    0,    0,    0,    3661, 0,    579,  0,
    0,    0,    1538, 0,    3518, 0,    0,    1971, 0,    436,  0,    0,    0,    0,    3604, 0,
    0,    891,  0,    0,    0,    322,  3350, 0,    1733, 375,  3927, 0,    0,    0,    0,    0,
    3869, 0,    4014, 0,    0,    3675, 3215, 0,    0,    2058, 518,  0,    0,    1216, 0,    0,
    0,    3158, 0,    83,   0,    0,    0,    0,    0,    0,    728,  0,    0,    0,    0,    866,
    871,  0,    811,  2250, 456,  0,    459,  0,    0,    0,    0,    0,    0,    1151, 570,  0,
    0,    0,    3435, 1967, 537,  0,    797,  0,    0,    0,    2250, 0,    747,  0,    2901, 0,
    0,    0,    0,    0,    2328, 0,    0,    0,    87,   1404, 0,    3030, 3064, 0,    0,    0,
    0,    0,    1341, 457,  0,    0,    0,    0,    0,    627,  3937, 333,  0,    0,    0,    0,
    846,  0,    0,    0,    0,    3172, 0,    2231, 0,    0,    4007, 0,    0,    1646, 0,    0,
    3589, 724,  0,    3808, 0,    3087, 0,    1776, 0,    0,    0,    0,    1775, 0,    0,    0,
    0,    0,    104,  0,    1220, 1535, 0,    0,    798,  0,    0,    0,    3887, 0,    1647, 0,
    1709, 0,    940,  0,    0,    1403, 0,    0,    0,    0,    2480, 0,    2929, 945,  0,    0,
    2634, 0,    0,    0,    0,    0,    0,    3003, 0,    379,  0,    1982, 0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    3560, 192,  831,  0,    0,    0,    2221, 1243, 0,
    3437, 661,  1177, 0,    0,    0,    867,  0,    0,    2555, 426,  53,   0,    0,    0,    0,
    0,    266,  0,    0,    0,    2054, 1579, 0,    3326, 0,    324,  461,  0,    1083, 0,    0,
    0,    0,    2305, 440,  0,    0,    500,  0,    0,    1593, 1608, 0,    2781, 0,    0,    0,
    117,  0,    0,    2483, 81,   0,    0,    1099, 0,    0,    0,    1735, 0,    0,    77,   3630,
    442,  0,    953,  0,    0,    0,    1008, 0,    0,    2157, 2435, 0,    0,    0,    0,    3383,
    0,    0,    1831, 0,    1706, 0,    0,    1138, 0,    0,    986,  0,    0,    0,    0,    0,
    0,    0,    122,  0,    3583, 0,    0,    1614, 0,    0,    0,    0,    0,    0,    1310, 0,
    2951, 701,  0,    0,    0,    0,    0,    0,    0,    0,    0,    395,  393,  62,   2225, 3234,
    0,    0,    0,    2073, 1818, 1528, 0,    0,    2075, 0,    0,    0,    108,  0,    0,    0,
    163,  577,  2191, 0,    1584, 0,    1427, 0,    88,   0,    0,    0,    2008, 3483, 0,    0,
    2028, 0,    8,    0,    0,    0,    0,    0,    0,    3881, 0,    916,  271,  0,    1985, 0,
    718,  0,    1323, 0,    0,    843,  1330, 0,    1598, 0,    0,    436,  1640, 0,    2879, 0,
    0,    0,    0,    2539, 0,    0,    1303, 0,    0,    0,    0,    0,    0,    510,  1777, 0,
    0,    439,  0,    526,  798,  0,    0,    0,    2622, 704,  1281, 0,    1991, 0,    3807, 0,
    1327, 0,    1169, 0,    0,    3665, 0,    0,    400,  0,    0,    1485, 22,   0,    0,    0,
    1297, 0,    874,  2629, 1821, 645,  0,    3633, 0,    0,    1199, 1455, 0,    457,  0,    1063,
    0,    135,  0,    0,    0,    3464, 183,  0,    0,    831,  0,    0,    1328, 0,    2017, 0,
    917,  0,    0,    0,    0,    0,    0,    3300, 636,  0,    0,    563,  0,    0,    1870, 0,
    0,    0,    0,    0,    468,  0,    3172, 1375, 411,  1915, 0,    0,    1869, 975,  0,    832,
    0,    1913, 0,    40,   828,  3518, 673,  0,    0,    320,  3873, 0,    1759, 0,    0,    2955,
    0,    1679, 846,  638,  3956, 0,    146,  0,    565,  1115, 0,    3755, 0,    0,    725,  0,
    0,    299,  577,  1562, 0,    397,  0,    0,    1801, 0,    858,  708,  250,  0,    0,    0,
    0,    2025, 2732, 2038, 0,    135,  1577, 1731, 0,    3293, 3528, 1489, 0,    2074, 0,    628,
    0,    3719, 1984, 0,    2011, 0,    0,    2174, 0,    1276, 73,   952,  311,  0,    0,    0,
    1978, 0,    918,  0,    1593, 1981, 0,    0,    0,    0,    0,    1768, 167,  0,    0,    0,
    0,    1145, 1689, 0,    0,    0,    4003, 0,    1748, 0,    0,    1297, 1154, 0,    0,    0,
    34,   2186, 471,  0,    23,   0,    2464, 614,  0,    0,    2880, 0,    0,    0,    4011, 2185,
    3618, 0,    2564, 0,    0,    401,  473,  580,  0,    0,    408,  3521, 2063, 0,    0,    0,
    1738, 0,    0,    2053, 0,    0,    0,    0,    3303, 3852, 0,    0,    3896, 0,    3130, 1211,
    0,    0,    0,    0,    765,  0,    1454, 0,    0,    523,  0,    0,    3299, 0,    1819, 0,
    0,    1844, 0,    1807, 0,    0,    2410, 974,  0,    1122, 0,    22,   0,    1948, 414,  3435,
    244,  0,    0,    937,  2873, 2280, 1086, 0,    0,    0,    0,    0,    0,    1737, 0,    0,
    2367, 1934, 1205, 471,  0,    0,    0,    3863, 92,   1108, 0,    0,    0,    0,    1244, 0,
    0,    0,    3835, 0,    771,  0,    0,    0,    0,    0,    0,    0,    3518, 0,    1066, 0,
    2535, 185,  3967, 0,    0,    295,  0,    0,    96,   0,    0,    766,  1074, 4002, 0,    0,
    0,    0,    0,    0,    49,   1003, 1683, 765,  1230, 1124, 976,  804,  0,    0,    0,    0,
    0,    353,  2296, 0,    0,    0,    239,  1917, 1906, 3120, 0,    0,    0,    0,    210,  3830,
    2028, 0,    3922, 0,    3363, 0,    0,    2551, 1711, 0,    0,    149,  573,  2074, 1396, 3481,
    757,  2010, 0,    0,    0,    1049, 0,    1513, 352,  0,    2614, 1771, 885,  2590, 0,    1626,
    0,    3670, 3623, 2320, 1991, 1802, 809,  0,    0,    0,    0,    310,  1350, 2291, 0,    0,
    3621, 0,    0,    0,    0,    713,  0,    694,  0,    1999, 0,    0,    0,    0,    0,    0,
    820,  0,    2773, 3874, 0,    0,    0,    257,  0,    0,    1604, 0,    0,    0,    1751, 843,
    0,    0,    0,    1786, 0,    483,  0,    0,    0,    0,    241,  0,    0,    1168, 101,  0,
    686,  1667, 0,    0,    0,    0,    493,  0,    0,    1499, 2548, 559,  0,    0,    3378, 2655,
    1973, 3047, 0,    304,  0,    0,    0,    3335, 0,    2260, 0,    0,    0,    1957, 0,    0,
    1953, 2106, 2611, 0,    2961, 0,    0,    2818, 0,    0,    258,  0,    0,    737,  0,    252,
    0,    0,    3490, 0,    1853, 938,  301,  3488, 2081, 0,    239,  0,    0,    1813, 0,    0,
    0,    541,  0,    0,    0,    3204, 3613, 39,   0,    1294, 912,  369,  0,    0,    24,   2133,
    1682, 2892, 0,    0,    2515, 2076, 427,  3406, 0,    0,    2249, 0,    2941, 2844, 0,    2891,
    1205, 1546, 0,    3408, 486,  2000, 0,    526,  0,    0,    0,    2047, 0,    48,   0,    0,
    3376, 1837, 0,    0,    1626, 3773, 0,    1227, 1810, 0,    0,    2189, 2711, 302,  0,    3350,
    129,  0,    204,  0,    1798, 2661, 274,  0,    94,   2292, 2404, 2805, 790,  0,    2999, 0,
    3313, 1143, 1858, 0,    260,  2917, 0,    3517, 0,    0,    0,    144,  0,    3635, 920,  0,
    0,    0,    0,    487,  797,  5,    742,  2936, 0,    0,    0,    404,  117,  1599, 1897, 0,
    2911, 0,    0,    3850, 55,   0,    0,    752,  0,    110,  3103, 1950, 0,    2286, 1229, 0,
    2257, 0,    0,    329,  1727, 0,    2979, 1140, 135,  130,  0,    3069, 0,    0,    387,  2066,
    185,  0,    0,    0,    918,  904,  0,    3095, 2768, 261,  2434, 0,    0,    456,  0,    0,
    1617, 0,    2343, 3526, 1341, 0,    1239, 170,  362,  0,    0,    0,    0,    3442, 0,    0,
    811,  376,  0,    0,    0,    343,  0,    879,  0,    3040, 0,    333,  0,    1255, 0,    0,
    0,    0,    1275, 0,    0,    0,    1308, 0,    601,  0,    3781, 238,  0,    348,  3162, 786,
    0,    0,    1666, 0,    0,    351,  0,    691,  798,  1910, 0,    57,   964,  725,  0,    0,
    4014, 1928, 1262, 0,    0,    3287, 0,    85,   0,    484,  1376, 1308, 1643, 0,    0,    0,
    0,    0,    0,    215,  1482, 0,    308,  0,    654,  555,  1010, 0,    0,    0,    3677, 0,
    0,    0,    0,    1380, 888,  0,    904,  7,    0,    187,  1689, 1954, 0,    3683, 3131, 0,
    0,    1810, 0,    1697, 2262, 0,    0,    0,    0,    0,    118,  0,    1803, 2320, 627,  1418,
    436,  717,  0,    133,  0,    0,    0,    1034, 2480, 26,   2212, 3246, 1408, 0,    0,    2338,
    2784, 0,    2923, 0,    0,    0,    1517, 0,    1290, 367,  0,    1380, 434,  3618, 0,    1306,
    693,  1618, 1559, 3407, 0,    0,    1675, 0,    1765, 145,  3617, 0,    449,  141,  1906, 3857,
    0,    0,    0,    0,    1018, 1192, 3586, 374,  3946, 2509, 0,    265,  39,   1654, 980,  1432,
    0,    2438, 513,  140,  0,    0,    2837, 1011, 3957, 0,    0,    1199, 0,    0,    0,    0,
    0,    2555, 3704, 2750, 293,  1051, 0,    0,    3565, 596,  0,    0,    700,  0,    0,    0,
    0,    0,    1587, 831,  0,    0,    3267, 2053, 54,   2136, 0,    0,    3244, 1227, 0,    836,
    0,    1493, 0,    1457, 384,  1565, 0,    0,    3248, 164,  0,    0,    203,  0,    0,    1923,
    0,    0,    0,    204,  1514, 3366, 3037, 0,    2535, 0,    0,    2700, 1354, 3540, 0,    3980,
    1806, 0,    234,  4000, 1912, 0,    0,    1662, 613,  764,  1831, 260,  3568, 2130, 1575, 1201,
    1495, 0,    2040, 869,  0,    184,  0,    0,    0,    3975, 2065, 377,  626,  1069, 0,    0,
    311,  0,    604,  0,    2674, 1422, 350,  2045, 0,    1804, 346,  0,    0,    0,    1685, 694,
    0,    0,    1723, 1476, 3971, 868,  1219, 0,    0,    2641, 0,    802,  2865, 1867, 320,  0,
    3219, 1067, 0,    0,    0,    20,   0,    4010, 3573, 0,    0,    2422, 762,  0,    1847, 0,
    440,  0,    0,    1169, 0,    0,    82,   0,    0,    0,    971,  3020, 3673, 2620, 1883, 73,
    0,    543,  1790, 634,  478,  861,  0,    2464, 0,    0,    1564, 1929, 1773, 3584, 0,    71,
    0,    848,  1673, 1381, 317,  3866, 101,  0,    469,  0,    0,    0,    498,  463,  3719, 1592,
    0,    0,    0,    1317, 603,  0,    2198, 791,  1968, 3849, 2474, 241,  17,   3513, 0,    849,
    168,  0,    502,  0,    839,  0,    0,    1415, 0,    73,   1763, 0,    0,    0,    3639, 1161,
    713,  470,  0,    0,    0,    3706, 1738, 1791, 0,    3482, 0,    137,  2122, 0,    58,   1105,
    1526, 441,  2774, 0,    1826, 1279, 0,    0,    3798, 1528, 2307, 0,    0,    3048, 0,    3261,
    0,    1615, 821,  1539, 0,    0,    590,  0,    3483, 0,    0,    0,    1589, 0,    0,    0,
    740,  1158, 3256, 1332, 0,    0,    0,    2791, 863,  0,    1453, 0,    128,  0,    0,    0,
    0,    0,    1208, 1876, 0,    3308, 861,  1277, 856,  0,    0,    1066, 0,    0,    680,  0,
    2315, 481,  3805, 1823, 3491, 746,  0,    3342, 3260, 1561, 0,    712,  2715, 3390, 0,    0,
    0,    227,  0,    1197, 0,    3353, 899,  0,    649,  0,    0,    0,    0,    3180, 1566, 2808,
    2968, 378,  0,    0,    354,  1184, 1530, 0,    0,    2487, 2817, 0,    0,    3049, 1383, 2965,
    2072, 1093, 0,    102,  3190, 0,    103,  0,    0,    923,  27,   935,  852,  1742, 0,    1039,
    993,  3329, 0,    1355, 0,    2356, 0,    769,  543,  2817, 991,  3408, 159,  1745, 0,    1520,
    0,    56,   0,    0,    0,    0,    2086, 2808, 2361, 2721, 0,    1206, 2877, 2603, 0,    0,
    0,    2995, 3614, 2812, 3401, 2773, 0,    1996, 2748, 0,    0,    0,    0,    0,    0,    524,
    642,  1548, 0,    1731, 2972, 0,    4003, 0,    892,  3770, 0,    1524, 0,    0,    446,  0,
    3611, 1190, 3711, 3711, 2827, 1257, 44,   2957, 0,    1945, 3877, 625,  0,    0,    0,    0,
    0,    108,  0,    1622, 0,    0,    2604, 3567, 0,    1015, 1246, 572,  938,  3808, 1985, 267,
    0,    2184, 0,    0,    1657, 226,  0,    2482, 1883, 0,    3220, 1822, 0,    239,  0,    80,
    1258, 0,    0,    0,    750,  2117, 2768, 0,    0,    799,  3610, 329,  0,    1341, 2145, 120,
    1345, 3772, 0,    402,  0,    0,    781,  0,    1163, 902,  1267, 3578, 0,    700,  179,  3471,
    3531, 581,  3388, 2819, 3887, 0,    1056, 1783, 0,    1787, 0,    1699, 0,    1374, 2477, 0,
    1565, 0,    0,    1366, 328,  3453, 2823, 0,    1389, 1934, 1600, 0,    0,    1981, 0,    1753,
    2722, 6,    1395, 0,    878,  2653, 0,    1021, 0,    958,  1569, 0,    3495, 0,    943,  1280,
    1894, 915,  1760, 1187, 0,    0,    2001, 3558, 1203, 0,    3818, 1852, 19,   3980, 482,  0,
    2861, 1501, 0,    0,    646,  0,    0,    0,    0,    85,   1009, 1886, 3771, 0,    189,  1742,
    0,    0,    2145, 2965, 0,    1594, 1896, 2656, 445,  3776, 0,    0,    0,    0,    51,   3461,
    1007, 980,  1695, 0,    1764, 747,  1634, 0,    0,    856,  0,    0,    1990, 0,    0,    0,
    0,    626,  0,    0,    0,    0,    193,  1038, 3887, 2089, 3385, 0,    1104, 3879, 1277, 0,
    1949, 1928, 730,  111,  723,  0,    1793, 1862, 0,    943,  2184, 0,    303,  1069, 2834, 2385,
    1779, 1038, 0,    0,    135,  3114, 1497, 1682, 0,    117,  0,    1261, 0,    0,    1184, 3025,
    0,    0,    1690, 489,  0,    0,    0,    0,    2979, 0,    0,    1039, 0,    3872, 857,  2869,
    2513, 0,    2323, 1110, 3304, 0,    0,    1170, 0,    329,  16,   0,    0,    699,  1414, 2975,
    994,  0,    531,  0,    1808, 0,    0,    447,  1685, 3792, 1719, 1989, 3659, 3503, 3904, 1951,
    3780, 505,  2839, 1179, 2024, 3292, 1114, 1678, 3469, 0,    0,    2092, 0,    0,    0,    2204,
    0,    3330, 0,    461,  2763, 190,  0,    3636, 1969, 3,    2863, 0,    1079, 281,  0,    0,
    0,    1946, 0,    0,    1062, 450,  0,    0,    880,  0,    2990, 0,    75,   0,    3774, 71,
    0,    3748, 1127, 0,    0,    3951, 399,  0,    1288, 37,   0,    3439, 2714, 0,    2479, 3482,
    192,  1377, 0,    738,  0,    1632, 293,  2081, 0,    931,  2848, 0,    3845, 1328, 3929, 0,
    1369, 197,  149,  2756, 0,    7,    3461, 0,    1920, 1237, 549,  135,  1748, 0,    0,    2006,
    591,  1390, 729,  3868, 587,  0,    1482, 641,  591,  1074, 0,    932,  0,    0,    2535, 0,
    0,    182,  171,  0,    0,    667,  984,  1529, 0,    2937, 0,    0,    2193, 0,    0,    3610,
    1997, 0,    126,  2103, 1165, 2082, 0,    3114, 0,    0,    0,    0,    924,  411,  0,    66,
    0,    0,    605,  2243, 1055, 1704, 0,    0,    0,    539,  3756, 395,  952,  218,  0,    720,
    3824, 0,    0,    1447, 0,    916,  486,  1758, 3985, 517,  649,  1784, 0,    0,    3121, 3241,
    105,  0,    0,    3442, 1273, 0,    0,    1390, 0,    0,    1347, 98,   289,  3713, 1388, 1657,
    1122, 209,  430,  0,    43,   0,    1525, 3879, 0,    0,    0,    300,  3466, 0,    2368, 0,
    2032, 3813, 0,    2105, 1522, 0,    0,    1268, 1144, 2115, 0,    921,  3337, 0,    441,  0,
    1964, 0,    0,    0,    0,    0,    3160, 2383, 0,    0,    1507, 1631, 0,    3796, 0,    0,
    0,    920,  2449, 1541, 877,  3629, 123,  706,  927,  2830, 1958, 0,    0,    0,    913,  1488,
    2872, 730,  2512, 175,  2669, 3788, 0,    123,  3538, 0,    0,    1761, 0,    228,  0,    492,
    19,   1641, 1308, 1391, 2326, 1061, 1453, 0,    0,    1580, 3202, 3039, 3829, 3087, 0,    994,
    0,    2557, 0,    2499, 0,    0,    932,  0,    1018, 1171, 2046, 1425, 0,    0,    2898, 63,
    2696, 3946, 1900, 3497, 0,    0,    1824, 3810, 0,    436,  1116, 1464, 482,  0,    168,  1959,
    283,  3642, 1890, 0,    3413, 3389, 0,    0,    1795, 1699, 1916, 3783, 0,    1483, 0,    1848,
    2150, 0,    1768, 2505, 0,    418,  3129, 3710, 2125, 1785, 0,    137,  972,  0,    0,    3423,
    0,    1586, 0,    1651, 0,    1178, 0,    3140, 0,    91,   0,    3408, 356,  194,  1034, 2976,
    1337, 388,  407,  0,    1574, 1368, 0,    1529, 684,  1714, 1559, 0,    202,  0,    819,  598,
    209,  0,    814,  0,    0,    0,    143,  2330, 3583, 652,  2986, 0,    0,    0,    0,    3834,
    0,    3274, 1351, 3961, 2230, 0,    1749, 0,    1359, 1820, 2595, 1099, 338,  1033, 0,    2964,
    0,    1860, 0,    2354, 1813, 3878, 0,    14,   1386, 1151, 967,  0,    0,    0,    2041, 2536,
    0,    0,    201,  1224, 730,  0,    216,  0,    3298, 0,    12,   515,  573,  1895, 630,  0,
    0,    1230, 0,    113,  0,    518,  1829, 0,    0,    678,  387,  0,    0,    853,  0,    2519,
    86,   3526, 1363, 482,  0,    3485, 709,  0,    644,  726,  0,    3566, 0,    2987, 293,  3215,
    997,  609,  714,  3818, 0,    0,    681,  1010, 0,    2450, 1460, 71,   0,    3185, 1365, 1076,
    0,    0,    1383, 2208, 983,  0,    0,    0,    0,    3157, 0,    2357, 0,    1310, 0,    453,
    0,    1252, 894,  0,    1147, 1833, 0,    3424, 0,    2923, 1833, 1103, 0,    307,  1349, 0,
    1939, 0,    316,  0,    2651, 0,    0,    0,    1387, 0,    1355, 141,  1781, 179,  121,  0,
    4011, 3545, 3495, 0,    2090, 0,    0,    0,    3242, 528,  0,    0,    0,    3197, 3588, 0,
    2888, 3628, 0,    0,    0,    0,    2474, 394,  531,  2483, 1041, 0,    957,  0,    204,  0,
    1372, 0,    1230, 1166, 0,    1218, 0,    674,  0,    0,    1538, 1224, 1097, 3426, 0,    746,
    816,  0,    2887, 81,   906,  1671, 1204, 85,   0,    3246, 0,    964,  1346, 0,    2184, 0,
    1246, 231,  3811, 0,    571,  767,  0,    0,    2649, 2850, 0,    2876, 0,    0,    1933, 1821,
    0,    778,  530,  0,    0,    0,    347,  450,  0,    0,    2184, 1273, 3785, 0,    0,    3823,
    1080, 3675, 600,  1301, 3542, 1510, 0,    1859, 3339, 1933, 1835, 0,    3612, 0,    0,    2001,
    0,    1191, 1648, 3939, 0,    731,  2381, 1033, 1770, 0,    0,    935,  703,  926,  1141, 1831,
    0,    2422, 3907, 3258, 625,  0,    4002, 406,  1995, 936,  0,    787,  0,    2809, 119,  2571,
    1240, 826,  0,    1410, 0,    0,    0,    1726, 523,  0,    1371, 0,    0,    0,    669,  434,
    0,    3740, 0,    0,    3572, 0,    1437, 293,  3039, 3846, 0,    0,    0,    1515, 0,    2745,
    292,  3467, 286,  3993, 0,    789,  0,    0,    1397, 2153, 0,    100,  1445, 3911, 0,    1489,
    3853, 2766, 909,  74,   727,  1173, 1174, 502,  0,    0,    1254, 334,  3475, 133,  1006, 1595,
    1971, 1110, 1140, 0,    1951, 2126, 0,    3200, 1673, 3061, 3269, 1421, 0,    0,    0,    0,
    0,    0,    62,   0,    3760, 3928, 0,    1752, 169,  0,    1041, 0,    255,  1880, 2086, 328,
    0,    0,    0,    1630, 3286, 397,  0,    538,  0,    914,  0,    1115, 2932, 566,  1326, 0,
    1658, 0,    9,    0,    0,    1478, 753,  3695, 2653, 0,    1892, 548,  1370, 1187, 0,    0,
    0,    0,    0,    197,  0,    1257, 0,    943,  897,  1252, 143,  1310, 707,  3077, 183,  233,
    1544, 0,    520,  0,    1993, 0,    2946, 2533, 3364, 0,    0,    3167, 0,    1312, 2248, 0,
    0,    0,    0,    0,    1522, 3031, 0,    0,    0,    0,    1070, 0,    0,    0,    2440, 0,
    253,  1201, 937,  2587, 726,  340,  238,  1338, 274,  3576, 126,  1474, 2995, 539,  1806, 3670,
    0,    416,  0,    0,    3993, 3234, 396,  2,    1280, 321,  1233, 1987, 633,  0,    1936, 1671,
    2788, 0,    2977, 0,    0,    0,    1002, 552,  0,    3893, 3725, 762,  0,    0,    696,  0,
    235,  846,  2927, 673,  1431, 3779, 3356, 0,    660,  0,    0,    3442, 1208, 0,    3680, 1010,
    234,  1235, 2108, 3534, 463,  778,  1667, 1583, 1466, 1118, 341,  0,    2310, 3413, 1023, 3648,
    0,    0,    0,    0,    2403, 0,    570,  0,    0,    0,    1486, 0,    0,    0,    3864, 0,
    0,    3781, 784,  1589, 0,    3155, 0,    3384, 1969, 0,    614,  989,  0,    2279, 2682, 459,
    0,    1938, 1328, 390,  1865, 1624, 0,    0,    1800, 0,    3837, 0,    2257, 2114, 0,    422,
    1611, 0,    0,    2235, 0,    578,  1827, 0,    1168, 1057, 0,    1301, 1998, 0,    990,  3723,
    0,    1199, 1022, 1216, 3953, 0,    0,    303,  1149, 0,    0,    0,    3278, 1129, 279,  1445,
    3519, 2649, 0,    969,  0,    0,    1794, 0,    0,    1975, 0,    3704, 0,    3292, 3615, 158,
    3754, 0,    2003, 1655, 2233, 2476, 606,  551,  3966, 2831, 676,  0,    0,    167,  2837, 1048,
    0,    901,  1428, 445,  0,    0,    249,  1705, 270,  0,    0,    19,   1162, 2888, 0,    725,
    0,    0,    443,  0,    864,  2049, 1507, 2112, 3439, 1153, 3197, 0,    0,    3385, 3047, 0,
    2229, 0,    0,    0,    150,  1913, 2050, 0,    0,    0,    0,    931,  0,    1301, 0,    0,
    1467, 2872, 2784, 0,    535,  0,    0,    0,    1495, 928,  1537, 1157, 3415, 1053, 960,  108,
    3677, 311,  0,    0,    2167, 1905, 2802, 307,  2126, 3824, 2072, 2998, 0,    400,  556,  2654,
    514,  1567, 722,  0,    3740, 34,   0,    3194, 2063, 0,    0,    266,  0,    0,    348,  623,
    0,    3181, 1497, 0,    0,    625,  0,    0,    1307, 557,  355,  3059, 2576, 0,    494,  0,
    1947, 0,    1930, 41,   294,  0,    0,    3927, 1844, 588,  1718, 3088, 2722, 898,  0,    1500,
    0,    2946, 1124, 99,   0,    0,    0,    0,    0,    919,  1449, 1186, 707,  2345, 1587, 3988,
    0,    2087, 433,  3985, 1423, 57,   0,    0,    2753, 544,  225,  3931, 1319, 221,  270,  0,
    1219, 1966, 0,    0,    2091, 973,  1379, 851,  3134, 727,  0,    3339, 0,    3893, 3297, 2189,
    0,    0,    0,    0,    0,    1382, 0,    2457, 0,    3962, 1012, 1422, 1379, 1024, 0,    0,
    0,    0,    1711, 269,  1872, 977,  820,  2609, 2767, 0,    834,  402,  0,    0,    3044, 0,
    0,    0,    2960, 2162, 0,    1816, 1072, 0,    0,    2115, 0,    0,    0,    2120, 0,    3646,
    2988, 330,  1202, 1330, 3973, 0,    1373, 20,   637,  2403, 0,    0,    1871, 0,    1551, 2093,
    596,  1590, 0,    0,    0,    1924, 638,  0,    0,    0,    289,  2206, 0,    769,  0,    1013,
    1805, 0,    0,    0,    1620, 1535, 0,    288,  0,    0,    0,    35,   842,  632,  0,    0,
    3648, 3429, 1884, 0,    862,  91,   2492, 898,  0,    2974, 98,   0,    0,    271,  3934, 0,
    0,    0,    1527, 2096, 1859, 0,    3871, 0,    0,    177,  0,    0,    2963, 0,    0,    481,
    1010, 38,   447,  0,    1264, 877,  188,  0,    1413, 525,  0,    703,  835,  0,    0,    1545,
    369,  1097, 467,  0,    338,  1564, 1698, 2083, 3099, 119,  0,    3452, 1862, 0,    0,    0,
    1539, 0,    2084, 1785, 379,  3416, 0,    1762, 155,  1776, 0,    1730, 3670, 1738, 0,    1385,
    1697, 185,  2200, 0,    3910, 1074, 0,    0,    314,  0,    3103, 1541, 0,    1614, 0,    762,
    0,    0,    2127, 0,    0,    0,    0,    1040, 2692, 1583, 827,  0,    61,   0,    1402, 0,
    0,    0,    3677, 1373, 0,    1593, 0,    160,  1682, 1205, 3839, 3572, 323,  606,  0,    1869,
    284,  1721, 1938, 1878, 0,    0,    0,    153,  922,  0,    3428, 489,  1927, 3671, 635,  1367,
    3251, 0,    382,  2592, 2863, 0,    0,    421,  292,  0,    1483, 0,    658,  627,  970,  0,
    0,    3781, 2490, 2175, 417,  1193, 965,  0,    253,  0,    2064, 2004, 11,   0,    67,   2133,
    2989, 169,  3163, 98,   314,  691,  77,   1672, 383,  0,    3952, 0,    165,  876,  1311, 430,
    1482, 228};

int MangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 4018;
    }
    return mangledkG[sum];
}

int MangledPerfectHash(const char *key)
{
    if (strlen(key) > 37)
        return 0;

    return (MangledHashG(key, mangledkT1) + MangledHashG(key, mangledkT2)) % 4018;
}

constexpr int unmangledkT1[] = {295, 37,  180, 113, 207, 292, 48,  111, 255, 82, 94,  168, 261,
                                240, 159, 89,  141, 64,  237, 137, 113, 265, 97, 239, 3,   42};
constexpr int unmangledkT2[] = {1,   83, 258, 205, 211, 68,  233, 316, 8,  149, 134, 322, 221,
                                224, 26, 115, 27,  229, 285, 163, 104, 44, 281, 182, 107, 199};
constexpr int unmangledkG[]  = {
    0,   0,   0,   0,   0,   0,   195, 0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  59,  0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   118, 180, 0,   31,  0,   223, 174, 0,   18,  154,
    11,  0,   0,   170, 325, 0,   70,  0,   120, 0,   232, 0,   330, 0,   240, 57,  0,   0,   1,
    0,   147, 140, 296, 143, 3,   242, 44,  0,   204, 214, 0,   128, 0,   0,   0,   296, 208, 0,
    0,   196, 152, 0,   0,   64,  249, 0,   0,   236, 140, 0,   7,   50,  0,   0,   0,   0,   186,
    250, 88,  146, 60,  321, 0,   0,   193, 206, 210, 247, 84,  0,   0,   258, 0,   100, 0,   0,
    45,  0,   0,   125, 175, 119, 0,   316, 81,  229, 0,   0,   0,   329, 319, 137, 73,  190, 0,
    152, 191, 174, 89,  149, 133, 279, 173, 0,   0,   0,   314, 279, 9,   209, 0,   262, 274, 249,
    0,   30,  25,  166, 52,  0,   0,   209, 0,   323, 0,   183, 105, 53,  0,   0,   20,  105, 87,
    87,  266, 25,  113, 156, 147, 152, 0,   88,  245, 239, 172, 280, 0,   0,   32,  135, 270, 0,
    42,  165, 75,  248, 0,   145, 0,   0,   0,   163, 231, 194, 0,   257, 0,   296, 283, 24,  0,
    0,   217, 248, 0,   0,   43,  76,  62,  115, 0,   249, 0,   165, 6,   228, 15,  0,   86,  0,
    220, 96,  100, 0,   196, 0,   51,  0,   0,   0,   164, 327, 124, 0,   55,  194, 183, 122, 313,
    0,   0,   0,   40,  70,  321, 271, 25,  273, 272, 229, 8,   48,  0,   231, 135, 279, 0,   151,
    0,   0,   191, 0,   316, 0,   328, 293, 130, 0,   154, 191, 199, 114, 11,  74,  0,   7,   69,
    303, 208, 307, 45,  0,   281, 147, 203, 0,   133, 182, 0,   10,  0,   128, 139, 169, 0,   16,
    204, 289, 0,   16,  0,   14,  74,  81,  65,  227, 319, 176, 109, 164, 58,  0,   0,   304, 187,
    191, 204, 324, 0,   0,   61,  132, 287};

int UnmangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 331;
    }
    return unmangledkG[sum];
}

int UnmangledPerfectHash(const char *key)
{
    if (strlen(key) > 26)
        return 0;

    return (UnmangledHashG(key, unmangledkT1) + UnmangledHashG(key, unmangledkT2)) % 331;
}

}  // namespace

namespace sh
{

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvPrime = 16777619u;

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvOffsetBasis = 0x811c9dc5u;

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvPrime =
    static_cast<size_t>(1099511628211ull);

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvOffsetBasis =
    static_cast<size_t>(0xcbf29ce484222325ull);

uint32_t ImmutableString::mangledNameHash() const
{
    return MangledPerfectHash(data());
}

uint32_t ImmutableString::unmangledNameHash() const
{
    return UnmangledPerfectHash(data());
}

}  // namespace sh
