// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See command_validation_generator.py for modifications

/***************************************************************************
*
* Copyright (c) 2021-2023 Valve Corporation
* Copyright (c) 2021-2023 LunarG, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
****************************************************************************/

// NOLINTBEGIN

#include "error_message/logging.h"
#include "core_checks/core_validation.h"
static const std::array<const char *, CMD_RANGE_SIZE> kGeneratedMustBeRecordingList = {{
    kVUIDUndefined,
    "VUID-vkCmdBindPipeline-commandBuffer-recording",
    "VUID-vkCmdSetViewport-commandBuffer-recording",
    "VUID-vkCmdSetScissor-commandBuffer-recording",
    "VUID-vkCmdSetLineWidth-commandBuffer-recording",
    "VUID-vkCmdSetDepthBias-commandBuffer-recording",
    "VUID-vkCmdSetBlendConstants-commandBuffer-recording",
    "VUID-vkCmdSetDepthBounds-commandBuffer-recording",
    "VUID-vkCmdSetStencilCompareMask-commandBuffer-recording",
    "VUID-vkCmdSetStencilWriteMask-commandBuffer-recording",
    "VUID-vkCmdSetStencilReference-commandBuffer-recording",
    "VUID-vkCmdBindDescriptorSets-commandBuffer-recording",
    "VUID-vkCmdBindIndexBuffer-commandBuffer-recording",
    "VUID-vkCmdBindVertexBuffers-commandBuffer-recording",
    "VUID-vkCmdDraw-commandBuffer-recording",
    "VUID-vkCmdDrawIndexed-commandBuffer-recording",
    "VUID-vkCmdDrawIndirect-commandBuffer-recording",
    "VUID-vkCmdDrawIndexedIndirect-commandBuffer-recording",
    "VUID-vkCmdDispatch-commandBuffer-recording",
    "VUID-vkCmdDispatchIndirect-commandBuffer-recording",
    "VUID-vkCmdCopyBuffer-commandBuffer-recording",
    "VUID-vkCmdCopyImage-commandBuffer-recording",
    "VUID-vkCmdBlitImage-commandBuffer-recording",
    "VUID-vkCmdCopyBufferToImage-commandBuffer-recording",
    "VUID-vkCmdCopyImageToBuffer-commandBuffer-recording",
    "VUID-vkCmdUpdateBuffer-commandBuffer-recording",
    "VUID-vkCmdFillBuffer-commandBuffer-recording",
    "VUID-vkCmdClearColorImage-commandBuffer-recording",
    "VUID-vkCmdClearDepthStencilImage-commandBuffer-recording",
    "VUID-vkCmdClearAttachments-commandBuffer-recording",
    "VUID-vkCmdResolveImage-commandBuffer-recording",
    "VUID-vkCmdSetEvent-commandBuffer-recording",
    "VUID-vkCmdResetEvent-commandBuffer-recording",
    "VUID-vkCmdWaitEvents-commandBuffer-recording",
    "VUID-vkCmdPipelineBarrier-commandBuffer-recording",
    "VUID-vkCmdBeginQuery-commandBuffer-recording",
    "VUID-vkCmdEndQuery-commandBuffer-recording",
    "VUID-vkCmdResetQueryPool-commandBuffer-recording",
    "VUID-vkCmdWriteTimestamp-commandBuffer-recording",
    "VUID-vkCmdCopyQueryPoolResults-commandBuffer-recording",
    "VUID-vkCmdPushConstants-commandBuffer-recording",
    "VUID-vkCmdBeginRenderPass-commandBuffer-recording",
    "VUID-vkCmdNextSubpass-commandBuffer-recording",
    "VUID-vkCmdEndRenderPass-commandBuffer-recording",
    "VUID-vkCmdExecuteCommands-commandBuffer-recording",
    "VUID-vkCmdSetDeviceMask-commandBuffer-recording",
    "VUID-vkCmdDispatchBase-commandBuffer-recording",
    "VUID-vkCmdDrawIndirectCount-commandBuffer-recording",
    "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-recording",
    "VUID-vkCmdBeginRenderPass2-commandBuffer-recording",
    "VUID-vkCmdNextSubpass2-commandBuffer-recording",
    "VUID-vkCmdEndRenderPass2-commandBuffer-recording",
    "VUID-vkCmdSetEvent2-commandBuffer-recording",
    "VUID-vkCmdResetEvent2-commandBuffer-recording",
    "VUID-vkCmdWaitEvents2-commandBuffer-recording",
    "VUID-vkCmdPipelineBarrier2-commandBuffer-recording",
    "VUID-vkCmdWriteTimestamp2-commandBuffer-recording",
    "VUID-vkCmdCopyBuffer2-commandBuffer-recording",
    "VUID-vkCmdCopyImage2-commandBuffer-recording",
    "VUID-vkCmdCopyBufferToImage2-commandBuffer-recording",
    "VUID-vkCmdCopyImageToBuffer2-commandBuffer-recording",
    "VUID-vkCmdBlitImage2-commandBuffer-recording",
    "VUID-vkCmdResolveImage2-commandBuffer-recording",
    "VUID-vkCmdBeginRendering-commandBuffer-recording",
    "VUID-vkCmdEndRendering-commandBuffer-recording",
    "VUID-vkCmdSetCullMode-commandBuffer-recording",
    "VUID-vkCmdSetFrontFace-commandBuffer-recording",
    "VUID-vkCmdSetPrimitiveTopology-commandBuffer-recording",
    "VUID-vkCmdSetViewportWithCount-commandBuffer-recording",
    "VUID-vkCmdSetScissorWithCount-commandBuffer-recording",
    "VUID-vkCmdBindVertexBuffers2-commandBuffer-recording",
    "VUID-vkCmdSetDepthTestEnable-commandBuffer-recording",
    "VUID-vkCmdSetDepthWriteEnable-commandBuffer-recording",
    "VUID-vkCmdSetDepthCompareOp-commandBuffer-recording",
    "VUID-vkCmdSetDepthBoundsTestEnable-commandBuffer-recording",
    "VUID-vkCmdSetStencilTestEnable-commandBuffer-recording",
    "VUID-vkCmdSetStencilOp-commandBuffer-recording",
    "VUID-vkCmdSetRasterizerDiscardEnable-commandBuffer-recording",
    "VUID-vkCmdSetDepthBiasEnable-commandBuffer-recording",
    "VUID-vkCmdSetPrimitiveRestartEnable-commandBuffer-recording",
    "VUID-vkCmdBeginVideoCodingKHR-commandBuffer-recording",
    "VUID-vkCmdEndVideoCodingKHR-commandBuffer-recording",
    "VUID-vkCmdControlVideoCodingKHR-commandBuffer-recording",
    "VUID-vkCmdDecodeVideoKHR-commandBuffer-recording",
    "VUID-vkCmdBeginRendering-commandBuffer-recording",
    "VUID-vkCmdEndRendering-commandBuffer-recording",
    "VUID-vkCmdSetDeviceMask-commandBuffer-recording",
    "VUID-vkCmdDispatchBase-commandBuffer-recording",
    "VUID-vkCmdPushDescriptorSetKHR-commandBuffer-recording",
    "VUID-vkCmdPushDescriptorSetWithTemplateKHR-commandBuffer-recording",
    "VUID-vkCmdBeginRenderPass2-commandBuffer-recording",
    "VUID-vkCmdNextSubpass2-commandBuffer-recording",
    "VUID-vkCmdEndRenderPass2-commandBuffer-recording",
    "VUID-vkCmdDrawIndirectCount-commandBuffer-recording",
    "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-recording",
    "VUID-vkCmdSetFragmentShadingRateKHR-commandBuffer-recording",
    "VUID-vkCmdEncodeVideoKHR-commandBuffer-recording",
    "VUID-vkCmdSetEvent2-commandBuffer-recording",
    "VUID-vkCmdResetEvent2-commandBuffer-recording",
    "VUID-vkCmdWaitEvents2-commandBuffer-recording",
    "VUID-vkCmdPipelineBarrier2-commandBuffer-recording",
    "VUID-vkCmdWriteTimestamp2-commandBuffer-recording",
    "VUID-vkCmdWriteBufferMarker2AMD-commandBuffer-recording",
    "VUID-vkCmdCopyBuffer2-commandBuffer-recording",
    "VUID-vkCmdCopyImage2-commandBuffer-recording",
    "VUID-vkCmdCopyBufferToImage2-commandBuffer-recording",
    "VUID-vkCmdCopyImageToBuffer2-commandBuffer-recording",
    "VUID-vkCmdBlitImage2-commandBuffer-recording",
    "VUID-vkCmdResolveImage2-commandBuffer-recording",
    "VUID-vkCmdTraceRaysIndirect2KHR-commandBuffer-recording",
    "VUID-vkCmdBindIndexBuffer2KHR-commandBuffer-recording",
    "VUID-vkCmdDebugMarkerBeginEXT-commandBuffer-recording",
    "VUID-vkCmdDebugMarkerEndEXT-commandBuffer-recording",
    "VUID-vkCmdDebugMarkerInsertEXT-commandBuffer-recording",
    "VUID-vkCmdBindTransformFeedbackBuffersEXT-commandBuffer-recording",
    "VUID-vkCmdBeginTransformFeedbackEXT-commandBuffer-recording",
    "VUID-vkCmdEndTransformFeedbackEXT-commandBuffer-recording",
    "VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-recording",
    "VUID-vkCmdEndQueryIndexedEXT-commandBuffer-recording",
    "VUID-vkCmdDrawIndirectByteCountEXT-commandBuffer-recording",
    "VUID-vkCmdCuLaunchKernelNVX-commandBuffer-recording",
    "VUID-vkCmdDrawIndirectCount-commandBuffer-recording",
    "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-recording",
    "VUID-vkCmdBeginConditionalRenderingEXT-commandBuffer-recording",
    "VUID-vkCmdEndConditionalRenderingEXT-commandBuffer-recording",
    "VUID-vkCmdSetViewportWScalingNV-commandBuffer-recording",
    "VUID-vkCmdSetDiscardRectangleEXT-commandBuffer-recording",
    "VUID-vkCmdSetDiscardRectangleEnableEXT-commandBuffer-recording",
    "VUID-vkCmdSetDiscardRectangleModeEXT-commandBuffer-recording",
    "VUID-vkCmdBeginDebugUtilsLabelEXT-commandBuffer-recording",
    "VUID-vkCmdEndDebugUtilsLabelEXT-commandBuffer-recording",
    "VUID-vkCmdInsertDebugUtilsLabelEXT-commandBuffer-recording",
    "VUID-vkCmdInitializeGraphScratchMemoryAMDX-commandBuffer-recording",
    "VUID-vkCmdDispatchGraphAMDX-commandBuffer-recording",
    "VUID-vkCmdDispatchGraphIndirectAMDX-commandBuffer-recording",
    "VUID-vkCmdDispatchGraphIndirectCountAMDX-commandBuffer-recording",
    "VUID-vkCmdSetSampleLocationsEXT-commandBuffer-recording",
    "VUID-vkCmdBindShadingRateImageNV-commandBuffer-recording",
    "VUID-vkCmdSetViewportShadingRatePaletteNV-commandBuffer-recording",
    "VUID-vkCmdSetCoarseSampleOrderNV-commandBuffer-recording",
    "VUID-vkCmdBuildAccelerationStructureNV-commandBuffer-recording",
    "VUID-vkCmdCopyAccelerationStructureNV-commandBuffer-recording",
    "VUID-vkCmdTraceRaysNV-commandBuffer-recording",
    "VUID-vkCmdWriteAccelerationStructuresPropertiesNV-commandBuffer-recording",
    "VUID-vkCmdWriteBufferMarkerAMD-commandBuffer-recording",
    "VUID-vkCmdDrawMeshTasksNV-commandBuffer-recording",
    "VUID-vkCmdDrawMeshTasksIndirectNV-commandBuffer-recording",
    "VUID-vkCmdDrawMeshTasksIndirectCountNV-commandBuffer-recording",
    "VUID-vkCmdSetExclusiveScissorEnableNV-commandBuffer-recording",
    "VUID-vkCmdSetExclusiveScissorNV-commandBuffer-recording",
    "VUID-vkCmdSetCheckpointNV-commandBuffer-recording",
    "VUID-vkCmdSetPerformanceMarkerINTEL-commandBuffer-recording",
    "VUID-vkCmdSetPerformanceStreamMarkerINTEL-commandBuffer-recording",
    "VUID-vkCmdSetPerformanceOverrideINTEL-commandBuffer-recording",
    "VUID-vkCmdSetLineStippleEXT-commandBuffer-recording",
    "VUID-vkCmdSetCullMode-commandBuffer-recording",
    "VUID-vkCmdSetFrontFace-commandBuffer-recording",
    "VUID-vkCmdSetPrimitiveTopology-commandBuffer-recording",
    "VUID-vkCmdSetViewportWithCount-commandBuffer-recording",
    "VUID-vkCmdSetScissorWithCount-commandBuffer-recording",
    "VUID-vkCmdBindVertexBuffers2-commandBuffer-recording",
    "VUID-vkCmdSetDepthTestEnable-commandBuffer-recording",
    "VUID-vkCmdSetDepthWriteEnable-commandBuffer-recording",
    "VUID-vkCmdSetDepthCompareOp-commandBuffer-recording",
    "VUID-vkCmdSetDepthBoundsTestEnable-commandBuffer-recording",
    "VUID-vkCmdSetStencilTestEnable-commandBuffer-recording",
    "VUID-vkCmdSetStencilOp-commandBuffer-recording",
    "VUID-vkCmdPreprocessGeneratedCommandsNV-commandBuffer-recording",
    "VUID-vkCmdExecuteGeneratedCommandsNV-commandBuffer-recording",
    "VUID-vkCmdBindPipelineShaderGroupNV-commandBuffer-recording",
    "VUID-vkCmdSetDepthBias2EXT-commandBuffer-recording",
    "VUID-vkCmdBindDescriptorBuffersEXT-commandBuffer-recording",
    "VUID-vkCmdSetDescriptorBufferOffsetsEXT-commandBuffer-recording",
    "VUID-vkCmdBindDescriptorBufferEmbeddedSamplersEXT-commandBuffer-recording",
    "VUID-vkCmdSetFragmentShadingRateEnumNV-commandBuffer-recording",
    "VUID-vkCmdSetVertexInputEXT-commandBuffer-recording",
    "VUID-vkCmdSubpassShadingHUAWEI-commandBuffer-recording",
    "VUID-vkCmdBindInvocationMaskHUAWEI-commandBuffer-recording",
    "VUID-vkCmdSetPatchControlPointsEXT-commandBuffer-recording",
    "VUID-vkCmdSetRasterizerDiscardEnable-commandBuffer-recording",
    "VUID-vkCmdSetDepthBiasEnable-commandBuffer-recording",
    "VUID-vkCmdSetLogicOpEXT-commandBuffer-recording",
    "VUID-vkCmdSetPrimitiveRestartEnable-commandBuffer-recording",
    "VUID-vkCmdSetColorWriteEnableEXT-commandBuffer-recording",
    "VUID-vkCmdDrawMultiEXT-commandBuffer-recording",
    "VUID-vkCmdDrawMultiIndexedEXT-commandBuffer-recording",
    "VUID-vkCmdBuildMicromapsEXT-commandBuffer-recording",
    "VUID-vkCmdCopyMicromapEXT-commandBuffer-recording",
    "VUID-vkCmdCopyMicromapToMemoryEXT-commandBuffer-recording",
    "VUID-vkCmdCopyMemoryToMicromapEXT-commandBuffer-recording",
    "VUID-vkCmdWriteMicromapsPropertiesEXT-commandBuffer-recording",
    "VUID-vkCmdDrawClusterHUAWEI-commandBuffer-recording",
    "VUID-vkCmdDrawClusterIndirectHUAWEI-commandBuffer-recording",
    "VUID-vkCmdCopyMemoryIndirectNV-commandBuffer-recording",
    "VUID-vkCmdCopyMemoryToImageIndirectNV-commandBuffer-recording",
    "VUID-vkCmdDecompressMemoryNV-commandBuffer-recording",
    "VUID-vkCmdDecompressMemoryIndirectCountNV-commandBuffer-recording",
    "VUID-vkCmdUpdatePipelineIndirectBufferNV-commandBuffer-recording",
    "VUID-vkCmdSetTessellationDomainOriginEXT-commandBuffer-recording",
    "VUID-vkCmdSetDepthClampEnableEXT-commandBuffer-recording",
    "VUID-vkCmdSetPolygonModeEXT-commandBuffer-recording",
    "VUID-vkCmdSetRasterizationSamplesEXT-commandBuffer-recording",
    "VUID-vkCmdSetSampleMaskEXT-commandBuffer-recording",
    "VUID-vkCmdSetAlphaToCoverageEnableEXT-commandBuffer-recording",
    "VUID-vkCmdSetAlphaToOneEnableEXT-commandBuffer-recording",
    "VUID-vkCmdSetLogicOpEnableEXT-commandBuffer-recording",
    "VUID-vkCmdSetColorBlendEnableEXT-commandBuffer-recording",
    "VUID-vkCmdSetColorBlendEquationEXT-commandBuffer-recording",
    "VUID-vkCmdSetColorWriteMaskEXT-commandBuffer-recording",
    "VUID-vkCmdSetRasterizationStreamEXT-commandBuffer-recording",
    "VUID-vkCmdSetConservativeRasterizationModeEXT-commandBuffer-recording",
    "VUID-vkCmdSetExtraPrimitiveOverestimationSizeEXT-commandBuffer-recording",
    "VUID-vkCmdSetDepthClipEnableEXT-commandBuffer-recording",
    "VUID-vkCmdSetSampleLocationsEnableEXT-commandBuffer-recording",
    "VUID-vkCmdSetColorBlendAdvancedEXT-commandBuffer-recording",
    "VUID-vkCmdSetProvokingVertexModeEXT-commandBuffer-recording",
    "VUID-vkCmdSetLineRasterizationModeEXT-commandBuffer-recording",
    "VUID-vkCmdSetLineStippleEnableEXT-commandBuffer-recording",
    "VUID-vkCmdSetDepthClipNegativeOneToOneEXT-commandBuffer-recording",
    "VUID-vkCmdSetViewportWScalingEnableNV-commandBuffer-recording",
    "VUID-vkCmdSetViewportSwizzleNV-commandBuffer-recording",
    "VUID-vkCmdSetCoverageToColorEnableNV-commandBuffer-recording",
    "VUID-vkCmdSetCoverageToColorLocationNV-commandBuffer-recording",
    "VUID-vkCmdSetCoverageModulationModeNV-commandBuffer-recording",
    "VUID-vkCmdSetCoverageModulationTableEnableNV-commandBuffer-recording",
    "VUID-vkCmdSetCoverageModulationTableNV-commandBuffer-recording",
    "VUID-vkCmdSetShadingRateImageEnableNV-commandBuffer-recording",
    "VUID-vkCmdSetRepresentativeFragmentTestEnableNV-commandBuffer-recording",
    "VUID-vkCmdSetCoverageReductionModeNV-commandBuffer-recording",
    "VUID-vkCmdOpticalFlowExecuteNV-commandBuffer-recording",
    "VUID-vkCmdBindShadersEXT-commandBuffer-recording",
    "VUID-vkCmdSetAttachmentFeedbackLoopEnableEXT-commandBuffer-recording",
    "VUID-vkCmdBuildAccelerationStructuresKHR-commandBuffer-recording",
    "VUID-vkCmdBuildAccelerationStructuresIndirectKHR-commandBuffer-recording",
    "VUID-vkCmdCopyAccelerationStructureKHR-commandBuffer-recording",
    "VUID-vkCmdCopyAccelerationStructureToMemoryKHR-commandBuffer-recording",
    "VUID-vkCmdCopyMemoryToAccelerationStructureKHR-commandBuffer-recording",
    "VUID-vkCmdWriteAccelerationStructuresPropertiesKHR-commandBuffer-recording",
    "VUID-vkCmdTraceRaysKHR-commandBuffer-recording",
    "VUID-vkCmdTraceRaysIndirectKHR-commandBuffer-recording",
    "VUID-vkCmdSetRayTracingPipelineStackSizeKHR-commandBuffer-recording",
    "VUID-vkCmdDrawMeshTasksEXT-commandBuffer-recording",
    "VUID-vkCmdDrawMeshTasksIndirectEXT-commandBuffer-recording",
    "VUID-vkCmdDrawMeshTasksIndirectCountEXT-commandBuffer-recording",
}};

struct CommandSupportedQueueType {
    VkQueueFlags flags;
    const char* vuid;
};
static const std::array<CommandSupportedQueueType, CMD_RANGE_SIZE> kGeneratedQueueTypeList = {{
    {VK_QUEUE_FLAG_BITS_MAX_ENUM, kVUIDUndefined},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindPipeline-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewport-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetScissor-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineWidth-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBias-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetBlendConstants-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBounds-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilCompareMask-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilWriteMask-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilReference-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindDescriptorSets-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindIndexBuffer-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindVertexBuffers-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDraw-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexed-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirect-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexedIndirect-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatch-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchIndirect-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyBuffer-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyImage-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBlitImage-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyBufferToImage-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyImageToBuffer-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdUpdateBuffer-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdFillBuffer-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdClearColorImage-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdClearDepthStencilImage-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdClearAttachments-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdResolveImage-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdSetEvent-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdResetEvent-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWaitEvents-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdPipelineBarrier-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdBeginQuery-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdEndQuery-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR | VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdResetQueryPool-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR | VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdWriteTimestamp-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyQueryPoolResults-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushConstants-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRenderPass-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdNextSubpass-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRenderPass-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdExecuteCommands-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetDeviceMask-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchBase-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirectCount-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRenderPass2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdNextSubpass2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRenderPass2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdSetEvent2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdResetEvent2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWaitEvents2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdPipelineBarrier2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWriteTimestamp2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyBuffer2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyImage2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyBufferToImage2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyImageToBuffer2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBlitImage2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdResolveImage2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRendering-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRendering-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCullMode-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetFrontFace-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPrimitiveTopology-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportWithCount-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetScissorWithCount-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindVertexBuffers2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthTestEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthWriteEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthCompareOp-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBoundsTestEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilTestEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilOp-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRasterizerDiscardEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBiasEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPrimitiveRestartEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdBeginVideoCodingKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdEndVideoCodingKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdControlVideoCodingKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_VIDEO_DECODE_BIT_KHR, "VUID-vkCmdDecodeVideoKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRendering-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRendering-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetDeviceMask-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchBase-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSetKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSetWithTemplateKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRenderPass2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdNextSubpass2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRenderPass2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirectCount-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetFragmentShadingRateKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdEncodeVideoKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdSetEvent2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdResetEvent2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWaitEvents2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdPipelineBarrier2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWriteTimestamp2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdWriteBufferMarker2AMD-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyBuffer2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyImage2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyBufferToImage2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyImageToBuffer2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBlitImage2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdResolveImage2-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdTraceRaysIndirect2KHR-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindIndexBuffer2KHR-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDebugMarkerBeginEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDebugMarkerEndEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDebugMarkerInsertEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindTransformFeedbackBuffersEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginTransformFeedbackEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndTransformFeedbackEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdEndQueryIndexedEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirectByteCountEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCuLaunchKernelNVX-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirectCount-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBeginConditionalRenderingEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdEndConditionalRenderingEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportWScalingNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDiscardRectangleEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDiscardRectangleEnableEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDiscardRectangleModeEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBeginDebugUtilsLabelEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdEndDebugUtilsLabelEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdInsertDebugUtilsLabelEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdInitializeGraphScratchMemoryAMDX-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchGraphAMDX-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchGraphIndirectAMDX-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchGraphIndirectCountAMDX-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetSampleLocationsEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindShadingRateImageNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportShadingRatePaletteNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoarseSampleOrderNV-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildAccelerationStructureNV-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyAccelerationStructureNV-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdTraceRaysNV-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdWriteAccelerationStructuresPropertiesNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdWriteBufferMarkerAMD-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksIndirectNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksIndirectCountNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetExclusiveScissorEnableNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetExclusiveScissorNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetCheckpointNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetPerformanceMarkerINTEL-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetPerformanceStreamMarkerINTEL-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetPerformanceOverrideINTEL-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineStippleEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCullMode-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetFrontFace-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPrimitiveTopology-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportWithCount-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetScissorWithCount-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindVertexBuffers2-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthTestEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthWriteEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthCompareOp-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBoundsTestEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilTestEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilOp-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPreprocessGeneratedCommandsNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdExecuteGeneratedCommandsNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindPipelineShaderGroupNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBias2EXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindDescriptorBuffersEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdSetDescriptorBufferOffsetsEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindDescriptorBufferEmbeddedSamplersEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetFragmentShadingRateEnumNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetVertexInputEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSubpassShadingHUAWEI-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindInvocationMaskHUAWEI-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPatchControlPointsEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRasterizerDiscardEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBiasEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLogicOpEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPrimitiveRestartEnable-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorWriteEnableEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMultiEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMultiIndexedEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildMicromapsEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMicromapEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMicromapToMemoryEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMemoryToMicromapEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdWriteMicromapsPropertiesEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawClusterHUAWEI-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawClusterIndirectHUAWEI-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyMemoryIndirectNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyMemoryToImageIndirectNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDecompressMemoryNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDecompressMemoryIndirectCountNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdUpdatePipelineIndirectBufferNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetTessellationDomainOriginEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthClampEnableEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPolygonModeEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRasterizationSamplesEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetSampleMaskEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetAlphaToCoverageEnableEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetAlphaToOneEnableEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLogicOpEnableEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorBlendEnableEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorBlendEquationEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorWriteMaskEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRasterizationStreamEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetConservativeRasterizationModeEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetExtraPrimitiveOverestimationSizeEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthClipEnableEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetSampleLocationsEnableEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorBlendAdvancedEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetProvokingVertexModeEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineRasterizationModeEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineStippleEnableEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthClipNegativeOneToOneEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportWScalingEnableNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportSwizzleNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageToColorEnableNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageToColorLocationNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageModulationModeNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageModulationTableEnableNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageModulationTableNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetShadingRateImageEnableNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRepresentativeFragmentTestEnableNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageReductionModeNV-commandBuffer-cmdpool"},
    {VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdOpticalFlowExecuteNV-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindShadersEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetAttachmentFeedbackLoopEnableEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildAccelerationStructuresKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildAccelerationStructuresIndirectKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyAccelerationStructureKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyAccelerationStructureToMemoryKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMemoryToAccelerationStructureKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdWriteAccelerationStructuresPropertiesKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdTraceRaysKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdTraceRaysIndirectKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdSetRayTracingPipelineStackSizeKHR-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksIndirectEXT-commandBuffer-cmdpool"},
    {VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksIndirectCountEXT-commandBuffer-cmdpool"},
}};

enum CMD_SCOPE_TYPE {
    CMD_SCOPE_INSIDE,
    CMD_SCOPE_OUTSIDE,
    CMD_SCOPE_BOTH
};

struct CommandSupportedRenderPass {
    CMD_SCOPE_TYPE renderPass;
    const char* vuid;
};
static const std::array<CommandSupportedRenderPass, CMD_RANGE_SIZE> kGeneratedRenderPassList = {{
    {CMD_SCOPE_BOTH, kVUIDUndefined}, // CMD_NONE
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDraw-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndexed-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndirect-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndexedIndirect-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatch-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchIndirect-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBuffer-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImage-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBlitImage-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBufferToImage-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImageToBuffer-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdUpdateBuffer-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdFillBuffer-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdClearColorImage-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdClearDepthStencilImage-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdClearAttachments-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdResolveImage-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetEvent-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdResetEvent-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdResetQueryPool-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyQueryPoolResults-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRenderPass-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdNextSubpass-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdEndRenderPass-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchBase-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndirectCount-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndexedIndirectCount-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRenderPass2-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdNextSubpass2-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdEndRenderPass2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetEvent2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdResetEvent2-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBuffer2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImage2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBufferToImage2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImageToBuffer2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBlitImage2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdResolveImage2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRendering-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdEndRendering-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginVideoCodingKHR-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndVideoCodingKHR-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdControlVideoCodingKHR-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDecodeVideoKHR-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRendering-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdEndRendering-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchBase-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRenderPass2-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdNextSubpass2-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdEndRenderPass2-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndirectCount-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndexedIndirectCount-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdEncodeVideoKHR-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetEvent2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdResetEvent2-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBuffer2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImage2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBufferToImage2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImageToBuffer2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBlitImage2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdResolveImage2-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysIndirect2KHR-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdBeginTransformFeedbackEXT-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdEndTransformFeedbackEXT-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndirectByteCountEXT-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndirectCount-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndexedIndirectCount-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdInitializeGraphScratchMemoryAMDX-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchGraphAMDX-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchGraphIndirectAMDX-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchGraphIndirectCountAMDX-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildAccelerationStructureNV-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyAccelerationStructureNV-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysNV-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteAccelerationStructuresPropertiesNV-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMeshTasksNV-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMeshTasksIndirectNV-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMeshTasksIndirectCountNV-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdPreprocessGeneratedCommandsNV-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdExecuteGeneratedCommandsNV-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdSubpassShadingHUAWEI-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindInvocationMaskHUAWEI-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMultiEXT-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMultiIndexedEXT-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildMicromapsEXT-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMicromapEXT-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMicromapToMemoryEXT-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryToMicromapEXT-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteMicromapsPropertiesEXT-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawClusterHUAWEI-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawClusterIndirectHUAWEI-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryIndirectNV-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryToImageIndirectNV-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDecompressMemoryNV-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDecompressMemoryIndirectCountNV-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdUpdatePipelineIndirectBufferNV-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdOpticalFlowExecuteNV-renderpass"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildAccelerationStructuresKHR-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildAccelerationStructuresIndirectKHR-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyAccelerationStructureKHR-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyAccelerationStructureToMemoryKHR-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryToAccelerationStructureKHR-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteAccelerationStructuresPropertiesKHR-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysKHR-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysIndirectKHR-renderpass"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRayTracingPipelineStackSizeKHR-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMeshTasksEXT-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMeshTasksIndirectEXT-renderpass"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMeshTasksIndirectCountEXT-renderpass"},
}};

struct CommandSupportedVideoCoding {
    CMD_SCOPE_TYPE videoCoding;
    const char* vuid;
};
static const std::array<CommandSupportedVideoCoding, CMD_RANGE_SIZE> kGeneratedVideoCodingList = {{
    {CMD_SCOPE_BOTH, kVUIDUndefined}, // CMD_NONE
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindPipeline-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewport-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetScissor-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetLineWidth-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBias-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetBlendConstants-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBounds-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilCompareMask-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilWriteMask-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilReference-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindDescriptorSets-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindIndexBuffer-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindVertexBuffers-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDraw-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndexed-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndirect-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndexedIndirect-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatch-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchIndirect-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBuffer-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImage-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBlitImage-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBufferToImage-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImageToBuffer-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdUpdateBuffer-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdFillBuffer-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdClearColorImage-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdClearDepthStencilImage-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdClearAttachments-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdResolveImage-videocoding"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdResetQueryPool-videocoding"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyQueryPoolResults-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdPushConstants-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRenderPass-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdNextSubpass-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndRenderPass-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdExecuteCommands-videocoding"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchBase-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndirectCount-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndexedIndirectCount-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRenderPass2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdNextSubpass2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndRenderPass2-videocoding"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBuffer2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImage2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBufferToImage2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImageToBuffer2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBlitImage2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdResolveImage2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRendering-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndRendering-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCullMode-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetFrontFace-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPrimitiveTopology-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewportWithCount-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetScissorWithCount-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindVertexBuffers2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthTestEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthWriteEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthCompareOp-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBoundsTestEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilTestEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilOp-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRasterizerDiscardEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBiasEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPrimitiveRestartEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginVideoCodingKHR-videocoding"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdEndVideoCodingKHR-videocoding"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdControlVideoCodingKHR-videocoding"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdDecodeVideoKHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRendering-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndRendering-videocoding"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchBase-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdPushDescriptorSetKHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdPushDescriptorSetWithTemplateKHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRenderPass2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdNextSubpass2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndRenderPass2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndirectCount-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndexedIndirectCount-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetFragmentShadingRateKHR-videocoding"},
    {CMD_SCOPE_INSIDE, "VUID-vkCmdEncodeVideoKHR-videocoding"},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_BOTH, kVUIDUndefined},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteBufferMarker2AMD-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBuffer2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImage2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBufferToImage2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImageToBuffer2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBlitImage2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdResolveImage2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysIndirect2KHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindIndexBuffer2KHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDebugMarkerBeginEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDebugMarkerEndEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDebugMarkerInsertEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindTransformFeedbackBuffersEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginTransformFeedbackEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndTransformFeedbackEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginQueryIndexedEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndQueryIndexedEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndirectByteCountEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCuLaunchKernelNVX-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndirectCount-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndexedIndirectCount-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginConditionalRenderingEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndConditionalRenderingEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewportWScalingNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDiscardRectangleEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDiscardRectangleEnableEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDiscardRectangleModeEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginDebugUtilsLabelEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndDebugUtilsLabelEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdInsertDebugUtilsLabelEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdInitializeGraphScratchMemoryAMDX-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchGraphAMDX-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchGraphIndirectAMDX-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchGraphIndirectCountAMDX-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetSampleLocationsEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindShadingRateImageNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewportShadingRatePaletteNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoarseSampleOrderNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildAccelerationStructureNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyAccelerationStructureNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteAccelerationStructuresPropertiesNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteBufferMarkerAMD-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMeshTasksNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMeshTasksIndirectNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMeshTasksIndirectCountNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetExclusiveScissorEnableNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetExclusiveScissorNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCheckpointNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPerformanceMarkerINTEL-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPerformanceStreamMarkerINTEL-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPerformanceOverrideINTEL-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetLineStippleEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCullMode-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetFrontFace-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPrimitiveTopology-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewportWithCount-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetScissorWithCount-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindVertexBuffers2-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthTestEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthWriteEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthCompareOp-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBoundsTestEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilTestEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilOp-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdPreprocessGeneratedCommandsNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdExecuteGeneratedCommandsNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindPipelineShaderGroupNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBias2EXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindDescriptorBuffersEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDescriptorBufferOffsetsEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindDescriptorBufferEmbeddedSamplersEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetFragmentShadingRateEnumNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetVertexInputEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSubpassShadingHUAWEI-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindInvocationMaskHUAWEI-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPatchControlPointsEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRasterizerDiscardEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBiasEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetLogicOpEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPrimitiveRestartEnable-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetColorWriteEnableEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMultiEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMultiIndexedEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildMicromapsEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMicromapEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMicromapToMemoryEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryToMicromapEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteMicromapsPropertiesEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawClusterHUAWEI-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawClusterIndirectHUAWEI-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryIndirectNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryToImageIndirectNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDecompressMemoryNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDecompressMemoryIndirectCountNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdUpdatePipelineIndirectBufferNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetTessellationDomainOriginEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthClampEnableEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPolygonModeEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRasterizationSamplesEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetSampleMaskEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetAlphaToCoverageEnableEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetAlphaToOneEnableEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetLogicOpEnableEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetColorBlendEnableEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetColorBlendEquationEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetColorWriteMaskEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRasterizationStreamEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetConservativeRasterizationModeEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetExtraPrimitiveOverestimationSizeEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthClipEnableEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetSampleLocationsEnableEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetColorBlendAdvancedEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetProvokingVertexModeEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetLineRasterizationModeEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetLineStippleEnableEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthClipNegativeOneToOneEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewportWScalingEnableNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewportSwizzleNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoverageToColorEnableNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoverageToColorLocationNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoverageModulationModeNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoverageModulationTableEnableNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoverageModulationTableNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetShadingRateImageEnableNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRepresentativeFragmentTestEnableNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoverageReductionModeNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdOpticalFlowExecuteNV-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindShadersEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetAttachmentFeedbackLoopEnableEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildAccelerationStructuresKHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildAccelerationStructuresIndirectKHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyAccelerationStructureKHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyAccelerationStructureToMemoryKHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryToAccelerationStructureKHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteAccelerationStructuresPropertiesKHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysKHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysIndirectKHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRayTracingPipelineStackSizeKHR-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMeshTasksEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMeshTasksIndirectEXT-videocoding"},
    {CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMeshTasksIndirectCountEXT-videocoding"},
}};
static const std::array<const char *, CMD_RANGE_SIZE> kGeneratedBufferLevelList = {{
    kVUIDUndefined, // CMD_NONE
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    "VUID-vkCmdBeginRenderPass-bufferlevel",
    "VUID-vkCmdNextSubpass-bufferlevel",
    "VUID-vkCmdEndRenderPass-bufferlevel",
    "VUID-vkCmdExecuteCommands-bufferlevel",
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    "VUID-vkCmdBeginRenderPass2-bufferlevel",
    "VUID-vkCmdNextSubpass2-bufferlevel",
    "VUID-vkCmdEndRenderPass2-bufferlevel",
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    "VUID-vkCmdBeginVideoCodingKHR-bufferlevel",
    "VUID-vkCmdEndVideoCodingKHR-bufferlevel",
    "VUID-vkCmdControlVideoCodingKHR-bufferlevel",
    "VUID-vkCmdDecodeVideoKHR-bufferlevel",
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    "VUID-vkCmdBeginRenderPass2-bufferlevel",
    "VUID-vkCmdNextSubpass2-bufferlevel",
    "VUID-vkCmdEndRenderPass2-bufferlevel",
    nullptr,
    nullptr,
    nullptr,
    "VUID-vkCmdEncodeVideoKHR-bufferlevel",
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    "VUID-vkCmdInitializeGraphScratchMemoryAMDX-bufferlevel",
    "VUID-vkCmdDispatchGraphAMDX-bufferlevel",
    "VUID-vkCmdDispatchGraphIndirectAMDX-bufferlevel",
    "VUID-vkCmdDispatchGraphIndirectCountAMDX-bufferlevel",
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
}};

// Ran on all vkCmd* commands
// Because it validate the implicit VUs that stateless can't, if this fails, it is likely
// the input is very bad and other checks will crash dereferencing null pointers
bool CoreChecks::ValidateCmd(const CMD_BUFFER_STATE &cb_state, const CMD_TYPE cmd) const {
    bool skip = false;
    const char *caller_name = CommandTypeString(cmd);

    // Validate the given command being added to the specified cmd buffer,
    // flagging errors if CB is not in the recording state or if there's an issue with the Cmd ordering
    switch (cb_state.state) {
        case CbState::Recording:
            skip |= ValidateCmdSubpassState(cb_state, cmd);
            break;

        case CbState::InvalidComplete:
        case CbState::InvalidIncomplete:
            skip |= ReportInvalidCommandBuffer(cb_state, caller_name);
            break;

        default:
            assert(cmd != CMD_NONE);
            const auto error = kGeneratedMustBeRecordingList[cmd];
            skip |= LogError(cb_state.commandBuffer(), error, "You must call vkBeginCommandBuffer() before this call to %s.",
                            caller_name);
    }

    // Validate the command pool from which the command buffer is from that the command is allowed for queue type
    const auto supportedQueueType = kGeneratedQueueTypeList[cmd];
    skip |= ValidateCmdQueueFlags(cb_state, caller_name, supportedQueueType.flags, supportedQueueType.vuid);

    // Validate if command is inside or outside a render pass if applicable
    const auto supportedRenderPass = kGeneratedRenderPassList[cmd];
    if (supportedRenderPass.renderPass == CMD_SCOPE_INSIDE) {
        skip |= OutsideRenderPass(cb_state, caller_name, supportedRenderPass.vuid);
    } else if (supportedRenderPass.renderPass == CMD_SCOPE_OUTSIDE) {
        skip |= InsideRenderPass(cb_state, caller_name, supportedRenderPass.vuid);
    }

    // Validate if command is inside or outside a video coding scope if applicable
    const auto supportedVideoCoding = kGeneratedVideoCodingList[cmd];
    if (supportedVideoCoding.videoCoding == CMD_SCOPE_INSIDE) {
        skip |= OutsideVideoCodingScope(cb_state, caller_name, supportedVideoCoding.vuid);
    } else if (supportedVideoCoding.videoCoding == CMD_SCOPE_OUTSIDE) {
        skip |= InsideVideoCodingScope(cb_state, caller_name, supportedVideoCoding.vuid);
    }

    // Validate if command has to be recorded in a primary command buffer
    const auto supportedBufferLevel = kGeneratedBufferLevelList[cmd];
    if (supportedBufferLevel != nullptr) {
        skip |= ValidatePrimaryCommandBuffer(cb_state, caller_name, supportedBufferLevel);
    }

    return skip;
}
// NOLINTEND
