/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.transport;

import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;
import org.apache.http.NoHttpResponseException;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.resource.transport.http.HttpErrorStatusCodeException;

public class NetworkingIssueVerifier {
    private static final int SC_TOO_MANY_REQUESTS = 429;

    public static <E extends Throwable> boolean isLikelyTransientNetworkingIssue(E failure) {
        if (failure instanceof SocketException || failure instanceof SocketTimeoutException || failure instanceof NoHttpResponseException) {
            return true;
        }
        if (failure instanceof DefaultMultiCauseException) {
            List causes = ((DefaultMultiCauseException)failure).getCauses();
            for (Throwable cause : causes) {
                if (!NetworkingIssueVerifier.isLikelyTransientNetworkingIssue(cause)) continue;
                return true;
            }
        }
        if (failure instanceof HttpErrorStatusCodeException) {
            HttpErrorStatusCodeException httpError = (HttpErrorStatusCodeException)failure;
            return httpError.isServerError() || NetworkingIssueVerifier.isTransientClientError(httpError.getStatusCode());
        }
        Throwable cause = failure.getCause();
        if (cause != null && cause != failure) {
            return NetworkingIssueVerifier.isLikelyTransientNetworkingIssue(cause);
        }
        return false;
    }

    private static boolean isTransientClientError(int statusCode) {
        return statusCode == 408 || statusCode == 429;
    }

    public static <E extends Throwable> boolean isLikelyPermanentNetworkIssue(E failure) {
        if (failure instanceof HttpErrorStatusCodeException) {
            return NetworkingIssueVerifier.isClientAuthenticationError(((HttpErrorStatusCodeException)failure).getStatusCode());
        }
        if (failure instanceof DefaultMultiCauseException) {
            List causes = ((DefaultMultiCauseException)failure).getCauses();
            for (Throwable cause : causes) {
                if (!NetworkingIssueVerifier.isLikelyPermanentNetworkIssue(cause)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isClientAuthenticationError(int statusCode) {
        return statusCode == 401 || statusCode == 403;
    }
}

