#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 255
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 125
#define ALIAS_COUNT 0
#define TOKEN_COUNT 65
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 20
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 56

enum {
  sym_identifier = 1,
  sym_shebang = 2,
  anon_sym_return = 3,
  anon_sym_local = 4,
  anon_sym_function = 5,
  anon_sym_for = 6,
  anon_sym_in = 7,
  anon_sym_do = 8,
  anon_sym_end = 9,
  anon_sym_COMMA = 10,
  anon_sym_EQ = 11,
  anon_sym_if = 12,
  anon_sym_then = 13,
  anon_sym_elseif = 14,
  anon_sym_else = 15,
  anon_sym_repeat = 16,
  anon_sym_until = 17,
  anon_sym_while = 18,
  sym_break_statement = 19,
  anon_sym_goto = 20,
  anon_sym_COLON_COLON = 21,
  anon_sym_LT = 22,
  anon_sym_GT = 23,
  anon_sym_SEMI = 24,
  anon_sym_or = 25,
  anon_sym_and = 26,
  anon_sym_EQ_EQ = 27,
  anon_sym_TILDE_EQ = 28,
  anon_sym_LT_EQ = 29,
  anon_sym_GT_EQ = 30,
  anon_sym_PIPE = 31,
  anon_sym_TILDE = 32,
  anon_sym_AMP = 33,
  anon_sym_LT_LT = 34,
  anon_sym_GT_GT = 35,
  anon_sym_PLUS = 36,
  anon_sym_DASH = 37,
  anon_sym_STAR = 38,
  anon_sym_SLASH = 39,
  anon_sym_SLASH_SLASH = 40,
  anon_sym_PERCENT = 41,
  anon_sym_DOT_DOT = 42,
  anon_sym_CARET = 43,
  anon_sym_not = 44,
  anon_sym_POUND = 45,
  anon_sym_LBRACE = 46,
  anon_sym_RBRACE = 47,
  anon_sym_LBRACK = 48,
  anon_sym_RBRACK = 49,
  anon_sym_LPAREN = 50,
  anon_sym_RPAREN = 51,
  anon_sym_COLON = 52,
  anon_sym_DOT = 53,
  sym_vararg_expression = 54,
  sym_number = 55,
  sym_true = 56,
  sym_false = 57,
  sym_nil = 58,
  sym__comment_start = 59,
  sym__comment_content = 60,
  sym__comment_end = 61,
  sym__string_start = 62,
  sym__string_content = 63,
  sym__string_end = 64,
  sym_chunk = 65,
  sym_block = 66,
  sym__block = 67,
  sym_return_statement = 68,
  sym_statement = 69,
  sym_local_function_definition_statement = 70,
  sym_function_definition_statement = 71,
  sym__table_function_variable = 72,
  sym__table_identifier = 73,
  sym__table_field_variable = 74,
  sym_for_generic_statement = 75,
  sym__name_list = 76,
  sym__value_list = 77,
  sym_for_numeric_statement = 78,
  sym_if_statement = 79,
  sym_elseif_clause = 80,
  sym_else_clause = 81,
  sym_repeat_statement = 82,
  sym_while_statement = 83,
  sym_do_statement = 84,
  sym_goto_statement = 85,
  sym_label_statement = 86,
  sym_local_variable_declaration = 87,
  sym__local_variable_list = 88,
  sym__local_variable = 89,
  sym_attribute = 90,
  sym_variable_assignment = 91,
  sym_variable_list = 92,
  sym_empty_statement = 93,
  sym_expression = 94,
  sym_binary_expression = 95,
  sym_unary_expression = 96,
  sym_table = 97,
  sym_field_list = 98,
  sym_field = 99,
  sym_prefix_expression = 100,
  sym__prefix_expression = 101,
  sym_parenthesized_expression = 102,
  sym_call = 103,
  sym__table_method_variable = 104,
  sym__method_identifier = 105,
  sym_argument_list = 106,
  sym_expression_list = 107,
  sym_variable = 108,
  sym__table_variable = 109,
  sym__named_field_identifier = 110,
  sym__indexed_field_identifier = 111,
  sym_function_definition = 112,
  sym__function_body = 113,
  sym_parameter_list = 114,
  sym_string = 115,
  sym_comment = 116,
  aux_sym__block_repeat1 = 117,
  aux_sym__name_list_repeat1 = 118,
  aux_sym__value_list_repeat1 = 119,
  aux_sym_if_statement_repeat1 = 120,
  aux_sym__local_variable_list_repeat1 = 121,
  aux_sym_variable_list_repeat1 = 122,
  aux_sym_field_list_repeat1 = 123,
  aux_sym_expression_list_repeat1 = 124,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_shebang] = "shebang",
  [anon_sym_return] = "return",
  [anon_sym_local] = "local",
  [anon_sym_function] = "function",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_do] = "do",
  [anon_sym_end] = "end",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_repeat] = "repeat",
  [anon_sym_until] = "until",
  [anon_sym_while] = "while",
  [sym_break_statement] = "break_statement",
  [anon_sym_goto] = "goto",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SEMI] = ";",
  [anon_sym_or] = "or",
  [anon_sym_and] = "and",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_TILDE_EQ] = "~=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_PIPE] = "|",
  [anon_sym_TILDE] = "~",
  [anon_sym_AMP] = "&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_CARET] = "^",
  [anon_sym_not] = "not",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COLON] = ":",
  [anon_sym_DOT] = ".",
  [sym_vararg_expression] = "vararg_expression",
  [sym_number] = "number",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_nil] = "nil",
  [sym__comment_start] = "_comment_start",
  [sym__comment_content] = "_comment_content",
  [sym__comment_end] = "_comment_end",
  [sym__string_start] = "_string_start",
  [sym__string_content] = "_string_content",
  [sym__string_end] = "_string_end",
  [sym_chunk] = "chunk",
  [sym_block] = "block",
  [sym__block] = "_block",
  [sym_return_statement] = "return_statement",
  [sym_statement] = "statement",
  [sym_local_function_definition_statement] = "local_function_definition_statement",
  [sym_function_definition_statement] = "function_definition_statement",
  [sym__table_function_variable] = "variable",
  [sym__table_identifier] = "_table_identifier",
  [sym__table_field_variable] = "variable",
  [sym_for_generic_statement] = "for_generic_statement",
  [sym__name_list] = "variable_list",
  [sym__value_list] = "expression_list",
  [sym_for_numeric_statement] = "for_numeric_statement",
  [sym_if_statement] = "if_statement",
  [sym_elseif_clause] = "elseif_clause",
  [sym_else_clause] = "else_clause",
  [sym_repeat_statement] = "repeat_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_label_statement] = "label_statement",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym__local_variable_list] = "variable_list",
  [sym__local_variable] = "variable",
  [sym_attribute] = "attribute",
  [sym_variable_assignment] = "variable_assignment",
  [sym_variable_list] = "variable_list",
  [sym_empty_statement] = "empty_statement",
  [sym_expression] = "expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_table] = "table",
  [sym_field_list] = "field_list",
  [sym_field] = "field",
  [sym_prefix_expression] = "prefix_expression",
  [sym__prefix_expression] = "_prefix_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_call] = "call",
  [sym__table_method_variable] = "variable",
  [sym__method_identifier] = "_method_identifier",
  [sym_argument_list] = "argument_list",
  [sym_expression_list] = "expression_list",
  [sym_variable] = "variable",
  [sym__table_variable] = "_table_variable",
  [sym__named_field_identifier] = "_named_field_identifier",
  [sym__indexed_field_identifier] = "_indexed_field_identifier",
  [sym_function_definition] = "function_definition",
  [sym__function_body] = "_function_body",
  [sym_parameter_list] = "parameter_list",
  [sym_string] = "string",
  [sym_comment] = "comment",
  [aux_sym__block_repeat1] = "_block_repeat1",
  [aux_sym__name_list_repeat1] = "_name_list_repeat1",
  [aux_sym__value_list_repeat1] = "_value_list_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym__local_variable_list_repeat1] = "_local_variable_list_repeat1",
  [aux_sym_variable_list_repeat1] = "variable_list_repeat1",
  [aux_sym_field_list_repeat1] = "field_list_repeat1",
  [aux_sym_expression_list_repeat1] = "expression_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_shebang] = sym_shebang,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_while] = anon_sym_while,
  [sym_break_statement] = sym_break_statement,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_TILDE_EQ] = anon_sym_TILDE_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_vararg_expression] = sym_vararg_expression,
  [sym_number] = sym_number,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_nil] = sym_nil,
  [sym__comment_start] = sym__comment_start,
  [sym__comment_content] = sym__comment_content,
  [sym__comment_end] = sym__comment_end,
  [sym__string_start] = sym__string_start,
  [sym__string_content] = sym__string_content,
  [sym__string_end] = sym__string_end,
  [sym_chunk] = sym_chunk,
  [sym_block] = sym_block,
  [sym__block] = sym__block,
  [sym_return_statement] = sym_return_statement,
  [sym_statement] = sym_statement,
  [sym_local_function_definition_statement] = sym_local_function_definition_statement,
  [sym_function_definition_statement] = sym_function_definition_statement,
  [sym__table_function_variable] = sym_variable,
  [sym__table_identifier] = sym__table_identifier,
  [sym__table_field_variable] = sym_variable,
  [sym_for_generic_statement] = sym_for_generic_statement,
  [sym__name_list] = sym_variable_list,
  [sym__value_list] = sym_expression_list,
  [sym_for_numeric_statement] = sym_for_numeric_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif_clause] = sym_elseif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_label_statement] = sym_label_statement,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym__local_variable_list] = sym_variable_list,
  [sym__local_variable] = sym_variable,
  [sym_attribute] = sym_attribute,
  [sym_variable_assignment] = sym_variable_assignment,
  [sym_variable_list] = sym_variable_list,
  [sym_empty_statement] = sym_empty_statement,
  [sym_expression] = sym_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_table] = sym_table,
  [sym_field_list] = sym_field_list,
  [sym_field] = sym_field,
  [sym_prefix_expression] = sym_prefix_expression,
  [sym__prefix_expression] = sym__prefix_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_call] = sym_call,
  [sym__table_method_variable] = sym_variable,
  [sym__method_identifier] = sym__method_identifier,
  [sym_argument_list] = sym_argument_list,
  [sym_expression_list] = sym_expression_list,
  [sym_variable] = sym_variable,
  [sym__table_variable] = sym__table_variable,
  [sym__named_field_identifier] = sym__named_field_identifier,
  [sym__indexed_field_identifier] = sym__indexed_field_identifier,
  [sym_function_definition] = sym_function_definition,
  [sym__function_body] = sym__function_body,
  [sym_parameter_list] = sym_parameter_list,
  [sym_string] = sym_string,
  [sym_comment] = sym_comment,
  [aux_sym__block_repeat1] = aux_sym__block_repeat1,
  [aux_sym__name_list_repeat1] = aux_sym__name_list_repeat1,
  [aux_sym__value_list_repeat1] = aux_sym__value_list_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym__local_variable_list_repeat1] = aux_sym__local_variable_list_repeat1,
  [aux_sym_variable_list_repeat1] = aux_sym_variable_list_repeat1,
  [aux_sym_field_list_repeat1] = aux_sym_field_list_repeat1,
  [aux_sym_expression_list_repeat1] = aux_sym_expression_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_shebang] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_vararg_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_start] = {
    .visible = false,
    .named = true,
  },
  [sym__comment_content] = {
    .visible = false,
    .named = true,
  },
  [sym__comment_end] = {
    .visible = false,
    .named = true,
  },
  [sym__string_start] = {
    .visible = false,
    .named = true,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__string_end] = {
    .visible = false,
    .named = true,
  },
  [sym_chunk] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__block] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_local_function_definition_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__table_function_variable] = {
    .visible = true,
    .named = true,
  },
  [sym__table_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__table_field_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_for_generic_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__name_list] = {
    .visible = true,
    .named = true,
  },
  [sym__value_list] = {
    .visible = true,
    .named = true,
  },
  [sym_for_numeric_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_label_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_variable_list] = {
    .visible = true,
    .named = true,
  },
  [sym__local_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_list] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_table] = {
    .visible = true,
    .named = true,
  },
  [sym_field_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__prefix_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym__table_method_variable] = {
    .visible = true,
    .named = true,
  },
  [sym__method_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym__table_variable] = {
    .visible = false,
    .named = true,
  },
  [sym__named_field_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__indexed_field_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__function_body] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__name_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__value_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__local_variable_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_body = 4,
  field_condition = 5,
  field_consequence = 6,
  field_end = 7,
  field_field = 8,
  field_function = 9,
  field_key = 10,
  field_left = 11,
  field_method = 12,
  field_name = 13,
  field_operator = 14,
  field_parameters = 15,
  field_right = 16,
  field_start = 17,
  field_step = 18,
  field_table = 19,
  field_value = 20,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_end] = "end",
  [field_field] = "field",
  [field_function] = "function",
  [field_key] = "key",
  [field_left] = "left",
  [field_method] = "method",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_start] = "start",
  [field_step] = "step",
  [field_table] = "table",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 3},
  [6] = {.index = 8, .length = 1},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 2},
  [9] = {.index = 13, .length = 2},
  [10] = {.index = 15, .length = 4},
  [11] = {.index = 19, .length = 4},
  [12] = {.index = 23, .length = 2},
  [13] = {.index = 25, .length = 2},
  [14] = {.index = 27, .length = 1},
  [15] = {.index = 28, .length = 3},
  [16] = {.index = 31, .length = 6},
  [17] = {.index = 37, .length = 2},
  [18] = {.index = 39, .length = 2},
  [19] = {.index = 41, .length = 2},
  [20] = {.index = 43, .length = 1},
  [21] = {.index = 44, .length = 1},
  [22] = {.index = 45, .length = 1},
  [23] = {.index = 46, .length = 1},
  [24] = {.index = 47, .length = 1},
  [25] = {.index = 48, .length = 3},
  [26] = {.index = 51, .length = 3},
  [27] = {.index = 54, .length = 1},
  [28] = {.index = 55, .length = 1},
  [29] = {.index = 56, .length = 2},
  [30] = {.index = 58, .length = 1},
  [31] = {.index = 59, .length = 1},
  [32] = {.index = 60, .length = 2},
  [33] = {.index = 62, .length = 2},
  [34] = {.index = 64, .length = 2},
  [35] = {.index = 66, .length = 2},
  [36] = {.index = 68, .length = 2},
  [37] = {.index = 70, .length = 2},
  [38] = {.index = 72, .length = 2},
  [39] = {.index = 74, .length = 2},
  [40] = {.index = 76, .length = 1},
  [41] = {.index = 77, .length = 2},
  [42] = {.index = 79, .length = 1},
  [43] = {.index = 80, .length = 1},
  [44] = {.index = 81, .length = 4},
  [45] = {.index = 85, .length = 3},
  [46] = {.index = 88, .length = 3},
  [47] = {.index = 91, .length = 3},
  [48] = {.index = 94, .length = 2},
  [49] = {.index = 96, .length = 2},
  [50] = {.index = 98, .length = 5},
  [51] = {.index = 103, .length = 4},
  [52] = {.index = 107, .length = 3},
  [53] = {.index = 110, .length = 4},
  [54] = {.index = 114, .length = 4},
  [55] = {.index = 118, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_field, 0, .inherited = true},
    {field_table, 0, .inherited = true},
  [3] =
    {field_name, 0, .inherited = true},
  [4] =
    {field_table, 0},
  [5] =
    {field_field, 0, .inherited = true},
    {field_table, 0},
    {field_table, 0, .inherited = true},
  [8] =
    {field_name, 1},
  [9] =
    {field_field, 1, .inherited = true},
    {field_table, 0},
  [11] =
    {field_method, 1, .inherited = true},
    {field_table, 0},
  [13] =
    {field_arguments, 1},
    {field_function, 0},
  [15] =
    {field_arguments, 1},
    {field_function, 0},
    {field_method, 0, .inherited = true},
    {field_table, 0, .inherited = true},
  [19] =
    {field_field, 0, .inherited = true},
    {field_field, 1, .inherited = true},
    {field_table, 0},
    {field_table, 0, .inherited = true},
  [23] =
    {field_body, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
  [25] =
    {field_argument, 1},
    {field_operator, 0},
  [27] =
    {field_value, 0},
  [28] =
    {field_body, 2, .inherited = true},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
  [31] =
    {field_body, 2, .inherited = true},
    {field_field, 1, .inherited = true},
    {field_method, 1, .inherited = true},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_table, 1, .inherited = true},
  [37] =
    {field_method, 1, .inherited = true},
    {field_table, 0, .inherited = true},
  [39] =
    {field_field, 1, .inherited = true},
    {field_table, 0, .inherited = true},
  [41] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [43] =
    {field_body, 1},
  [44] =
    {field_condition, 2},
  [45] =
    {field_field, 1},
  [46] =
    {field_value, 2, .inherited = true},
  [47] =
    {field_method, 1},
  [48] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [51] =
    {field_body, 3, .inherited = true},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
  [54] =
    {field_value, 3, .inherited = true},
  [55] =
    {field_name, 1, .inherited = true},
  [56] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [58] =
    {field_condition, 1},
  [59] =
    {field_alternative, 0},
  [60] =
    {field_body, 1},
    {field_condition, 3},
  [62] =
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [64] =
    {field_key, 0},
    {field_value, 2},
  [66] =
    {field_condition, 1},
    {field_consequence, 3},
  [68] =
    {field_alternative, 3},
    {field_condition, 1},
  [70] =
    {field_alternative, 3, .inherited = true},
    {field_condition, 1},
  [72] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [74] =
    {field_body, 3},
    {field_condition, 1},
  [76] =
    {field_value, 1},
  [77] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [79] =
    {field_body, 2},
  [80] =
    {field_parameters, 1},
  [81] =
    {field_left, 1},
    {field_name, 1, .inherited = true},
    {field_right, 3},
    {field_value, 3, .inherited = true},
  [85] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [88] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [91] =
    {field_alternative, 3, .inherited = true},
    {field_alternative, 4},
    {field_condition, 1},
  [94] =
    {field_body, 3},
    {field_parameters, 1},
  [96] =
    {field_key, 1},
    {field_value, 4},
  [98] =
    {field_body, 5},
    {field_left, 1},
    {field_name, 1, .inherited = true},
    {field_right, 3},
    {field_value, 3, .inherited = true},
  [103] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [107] =
    {field_end, 5},
    {field_name, 1},
    {field_start, 3},
  [110] =
    {field_body, 7},
    {field_end, 5},
    {field_name, 1},
    {field_start, 3},
  [114] =
    {field_end, 5},
    {field_name, 1},
    {field_start, 3},
    {field_step, 7},
  [118] =
    {field_body, 9},
    {field_end, 5},
    {field_name, 1},
    {field_start, 3},
    {field_step, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [11] = {
    [0] = sym_variable,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__table_variable, 2,
    sym__table_variable,
    sym_variable,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(11);
      if (lookahead == '#') ADVANCE(40);
      if (lookahead == '%') ADVANCE(36);
      if (lookahead == '&') ADVANCE(27);
      if (lookahead == '(') ADVANCE(45);
      if (lookahead == ')') ADVANCE(46);
      if (lookahead == '*') ADVANCE(33);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == ',') ADVANCE(13);
      if (lookahead == '-') ADVANCE(32);
      if (lookahead == '.') ADVANCE(49);
      if (lookahead == '/') ADVANCE(34);
      if (lookahead == '0') ADVANCE(51);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == ';') ADVANCE(19);
      if (lookahead == '<') ADVANCE(16);
      if (lookahead == '=') ADVANCE(14);
      if (lookahead == '>') ADVANCE(18);
      if (lookahead == '[') ADVANCE(43);
      if (lookahead == ']') ADVANCE(44);
      if (lookahead == '^') ADVANCE(38);
      if (lookahead == '{') ADVANCE(41);
      if (lookahead == '|') ADVANCE(24);
      if (lookahead == '}') ADVANCE(42);
      if (lookahead == '~') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(52);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(57);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(12);
      END_STATE();
    case 2:
      if (lookahead == '.') ADVANCE(8);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 3:
      if (lookahead == '.') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(54);
      END_STATE();
    case 4:
      if (lookahead == '.') ADVANCE(50);
      END_STATE();
    case 5:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(7);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(56);
      END_STATE();
    case 6:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(54);
      END_STATE();
    case 7:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(56);
      END_STATE();
    case 8:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 9:
      if (eof) ADVANCE(11);
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '%') ADVANCE(36);
      if (lookahead == '&') ADVANCE(27);
      if (lookahead == '(') ADVANCE(45);
      if (lookahead == ')') ADVANCE(46);
      if (lookahead == '*') ADVANCE(33);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == ',') ADVANCE(13);
      if (lookahead == '-') ADVANCE(31);
      if (lookahead == '.') ADVANCE(48);
      if (lookahead == '/') ADVANCE(34);
      if (lookahead == ':') ADVANCE(47);
      if (lookahead == ';') ADVANCE(19);
      if (lookahead == '<') ADVANCE(16);
      if (lookahead == '=') ADVANCE(14);
      if (lookahead == '>') ADVANCE(18);
      if (lookahead == '[') ADVANCE(43);
      if (lookahead == ']') ADVANCE(44);
      if (lookahead == '^') ADVANCE(38);
      if (lookahead == '{') ADVANCE(41);
      if (lookahead == '|') ADVANCE(24);
      if (lookahead == '}') ADVANCE(42);
      if (lookahead == '~') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(57);
      END_STATE();
    case 10:
      if (eof) ADVANCE(11);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '(') ADVANCE(45);
      if (lookahead == ')') ADVANCE(46);
      if (lookahead == '-') ADVANCE(32);
      if (lookahead == '.') ADVANCE(3);
      if (lookahead == '0') ADVANCE(51);
      if (lookahead == ';') ADVANCE(19);
      if (lookahead == '>') ADVANCE(17);
      if (lookahead == '[') ADVANCE(43);
      if (lookahead == '{') ADVANCE(41);
      if (lookahead == '}') ADVANCE(42);
      if (lookahead == '~') ADVANCE(25);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(52);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(57);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(sym_shebang);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(12);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(20);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(28);
      if (lookahead == '=') ADVANCE(22);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(23);
      if (lookahead == '>') ADVANCE(29);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '=') ADVANCE(21);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(6);
      if (lookahead == '0') ADVANCE(51);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(52);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(35);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(12);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(15);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(37);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(54);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_vararg_expression);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(5);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(52);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(52);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(54);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(56);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(57);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'd') ADVANCE(3);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead == 'f') ADVANCE(5);
      if (lookahead == 'g') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'n') ADVANCE(9);
      if (lookahead == 'o') ADVANCE(10);
      if (lookahead == 'r') ADVANCE(11);
      if (lookahead == 't') ADVANCE(12);
      if (lookahead == 'u') ADVANCE(13);
      if (lookahead == 'w') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(15);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'l') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(19);
      END_STATE();
    case 5:
      if (lookahead == 'a') ADVANCE(20);
      if (lookahead == 'o') ADVANCE(21);
      if (lookahead == 'u') ADVANCE(22);
      END_STATE();
    case 6:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(24);
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 9:
      if (lookahead == 'i') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      END_STATE();
    case 13:
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(34);
      END_STATE();
    case 15:
      if (lookahead == 'd') ADVANCE(35);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(37);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(38);
      END_STATE();
    case 20:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 21:
      if (lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 22:
      if (lookahead == 'n') ADVANCE(41);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(43);
      END_STATE();
    case 27:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(45);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 30:
      if (lookahead == 'p') ADVANCE(46);
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 32:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 33:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(51);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 36:
      if (lookahead == 'a') ADVANCE(52);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 39:
      if (lookahead == 's') ADVANCE(54);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 41:
      if (lookahead == 'c') ADVANCE(55);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(57);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(58);
      END_STATE();
    case 47:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 48:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 51:
      if (lookahead == 'l') ADVANCE(63);
      END_STATE();
    case 52:
      if (lookahead == 'k') ADVANCE(64);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 62:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 65:
      if (lookahead == 'f') ADVANCE(73);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(74);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 74:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(78);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 9, .external_lex_state = 2},
  [2] = {.lex_state = 9, .external_lex_state = 3},
  [3] = {.lex_state = 9, .external_lex_state = 3},
  [4] = {.lex_state = 9, .external_lex_state = 3},
  [5] = {.lex_state = 9, .external_lex_state = 3},
  [6] = {.lex_state = 9, .external_lex_state = 3},
  [7] = {.lex_state = 9, .external_lex_state = 3},
  [8] = {.lex_state = 9, .external_lex_state = 3},
  [9] = {.lex_state = 9, .external_lex_state = 3},
  [10] = {.lex_state = 9, .external_lex_state = 3},
  [11] = {.lex_state = 9, .external_lex_state = 3},
  [12] = {.lex_state = 9, .external_lex_state = 3},
  [13] = {.lex_state = 9, .external_lex_state = 3},
  [14] = {.lex_state = 9, .external_lex_state = 3},
  [15] = {.lex_state = 9, .external_lex_state = 3},
  [16] = {.lex_state = 9, .external_lex_state = 3},
  [17] = {.lex_state = 9, .external_lex_state = 3},
  [18] = {.lex_state = 9, .external_lex_state = 3},
  [19] = {.lex_state = 9, .external_lex_state = 3},
  [20] = {.lex_state = 9, .external_lex_state = 3},
  [21] = {.lex_state = 9, .external_lex_state = 3},
  [22] = {.lex_state = 9, .external_lex_state = 3},
  [23] = {.lex_state = 9, .external_lex_state = 3},
  [24] = {.lex_state = 9, .external_lex_state = 2},
  [25] = {.lex_state = 0, .external_lex_state = 2},
  [26] = {.lex_state = 9, .external_lex_state = 2},
  [27] = {.lex_state = 9, .external_lex_state = 2},
  [28] = {.lex_state = 9, .external_lex_state = 2},
  [29] = {.lex_state = 9, .external_lex_state = 2},
  [30] = {.lex_state = 9, .external_lex_state = 2},
  [31] = {.lex_state = 9, .external_lex_state = 2},
  [32] = {.lex_state = 9, .external_lex_state = 2},
  [33] = {.lex_state = 9, .external_lex_state = 2},
  [34] = {.lex_state = 9, .external_lex_state = 2},
  [35] = {.lex_state = 9, .external_lex_state = 2},
  [36] = {.lex_state = 9, .external_lex_state = 2},
  [37] = {.lex_state = 9, .external_lex_state = 2},
  [38] = {.lex_state = 9, .external_lex_state = 2},
  [39] = {.lex_state = 9, .external_lex_state = 2},
  [40] = {.lex_state = 9, .external_lex_state = 2},
  [41] = {.lex_state = 9, .external_lex_state = 2},
  [42] = {.lex_state = 9, .external_lex_state = 2},
  [43] = {.lex_state = 9, .external_lex_state = 2},
  [44] = {.lex_state = 9, .external_lex_state = 2},
  [45] = {.lex_state = 9, .external_lex_state = 2},
  [46] = {.lex_state = 9, .external_lex_state = 2},
  [47] = {.lex_state = 9, .external_lex_state = 2},
  [48] = {.lex_state = 0, .external_lex_state = 2},
  [49] = {.lex_state = 0, .external_lex_state = 2},
  [50] = {.lex_state = 9, .external_lex_state = 2},
  [51] = {.lex_state = 0, .external_lex_state = 2},
  [52] = {.lex_state = 0, .external_lex_state = 2},
  [53] = {.lex_state = 0, .external_lex_state = 2},
  [54] = {.lex_state = 0, .external_lex_state = 2},
  [55] = {.lex_state = 0, .external_lex_state = 2},
  [56] = {.lex_state = 0, .external_lex_state = 2},
  [57] = {.lex_state = 0, .external_lex_state = 2},
  [58] = {.lex_state = 0, .external_lex_state = 2},
  [59] = {.lex_state = 0, .external_lex_state = 2},
  [60] = {.lex_state = 0, .external_lex_state = 2},
  [61] = {.lex_state = 9, .external_lex_state = 2},
  [62] = {.lex_state = 9, .external_lex_state = 2},
  [63] = {.lex_state = 0, .external_lex_state = 2},
  [64] = {.lex_state = 9, .external_lex_state = 2},
  [65] = {.lex_state = 10, .external_lex_state = 3},
  [66] = {.lex_state = 9, .external_lex_state = 3},
  [67] = {.lex_state = 10, .external_lex_state = 3},
  [68] = {.lex_state = 10, .external_lex_state = 3},
  [69] = {.lex_state = 9, .external_lex_state = 2},
  [70] = {.lex_state = 10, .external_lex_state = 3},
  [71] = {.lex_state = 10, .external_lex_state = 3},
  [72] = {.lex_state = 9, .external_lex_state = 2},
  [73] = {.lex_state = 10, .external_lex_state = 3},
  [74] = {.lex_state = 10, .external_lex_state = 3},
  [75] = {.lex_state = 10, .external_lex_state = 3},
  [76] = {.lex_state = 10, .external_lex_state = 3},
  [77] = {.lex_state = 10, .external_lex_state = 3},
  [78] = {.lex_state = 10, .external_lex_state = 3},
  [79] = {.lex_state = 10, .external_lex_state = 3},
  [80] = {.lex_state = 10, .external_lex_state = 3},
  [81] = {.lex_state = 10, .external_lex_state = 3},
  [82] = {.lex_state = 10, .external_lex_state = 3},
  [83] = {.lex_state = 10, .external_lex_state = 3},
  [84] = {.lex_state = 10, .external_lex_state = 3},
  [85] = {.lex_state = 10, .external_lex_state = 3},
  [86] = {.lex_state = 10, .external_lex_state = 3},
  [87] = {.lex_state = 10, .external_lex_state = 3},
  [88] = {.lex_state = 10, .external_lex_state = 3},
  [89] = {.lex_state = 10, .external_lex_state = 3},
  [90] = {.lex_state = 10, .external_lex_state = 3},
  [91] = {.lex_state = 10, .external_lex_state = 3},
  [92] = {.lex_state = 10, .external_lex_state = 3},
  [93] = {.lex_state = 10, .external_lex_state = 3},
  [94] = {.lex_state = 10, .external_lex_state = 3},
  [95] = {.lex_state = 10, .external_lex_state = 3},
  [96] = {.lex_state = 10, .external_lex_state = 3},
  [97] = {.lex_state = 10, .external_lex_state = 3},
  [98] = {.lex_state = 10, .external_lex_state = 3},
  [99] = {.lex_state = 10, .external_lex_state = 3},
  [100] = {.lex_state = 10, .external_lex_state = 3},
  [101] = {.lex_state = 10, .external_lex_state = 3},
  [102] = {.lex_state = 10, .external_lex_state = 3},
  [103] = {.lex_state = 10, .external_lex_state = 3},
  [104] = {.lex_state = 10, .external_lex_state = 3},
  [105] = {.lex_state = 9, .external_lex_state = 3},
  [106] = {.lex_state = 9, .external_lex_state = 2},
  [107] = {.lex_state = 9, .external_lex_state = 2},
  [108] = {.lex_state = 9, .external_lex_state = 2},
  [109] = {.lex_state = 0, .external_lex_state = 2},
  [110] = {.lex_state = 9, .external_lex_state = 2},
  [111] = {.lex_state = 9, .external_lex_state = 2},
  [112] = {.lex_state = 9, .external_lex_state = 2},
  [113] = {.lex_state = 9, .external_lex_state = 2},
  [114] = {.lex_state = 9, .external_lex_state = 2},
  [115] = {.lex_state = 9, .external_lex_state = 2},
  [116] = {.lex_state = 0, .external_lex_state = 2},
  [117] = {.lex_state = 0, .external_lex_state = 2},
  [118] = {.lex_state = 9, .external_lex_state = 2},
  [119] = {.lex_state = 9, .external_lex_state = 2},
  [120] = {.lex_state = 0, .external_lex_state = 2},
  [121] = {.lex_state = 9, .external_lex_state = 2},
  [122] = {.lex_state = 0, .external_lex_state = 2},
  [123] = {.lex_state = 0, .external_lex_state = 2},
  [124] = {.lex_state = 0, .external_lex_state = 2},
  [125] = {.lex_state = 0, .external_lex_state = 2},
  [126] = {.lex_state = 0, .external_lex_state = 2},
  [127] = {.lex_state = 0, .external_lex_state = 2},
  [128] = {.lex_state = 0, .external_lex_state = 2},
  [129] = {.lex_state = 0, .external_lex_state = 2},
  [130] = {.lex_state = 0, .external_lex_state = 2},
  [131] = {.lex_state = 0, .external_lex_state = 2},
  [132] = {.lex_state = 0, .external_lex_state = 2},
  [133] = {.lex_state = 0, .external_lex_state = 2},
  [134] = {.lex_state = 0, .external_lex_state = 2},
  [135] = {.lex_state = 0, .external_lex_state = 2},
  [136] = {.lex_state = 0, .external_lex_state = 2},
  [137] = {.lex_state = 0, .external_lex_state = 2},
  [138] = {.lex_state = 0, .external_lex_state = 2},
  [139] = {.lex_state = 0, .external_lex_state = 2},
  [140] = {.lex_state = 0, .external_lex_state = 2},
  [141] = {.lex_state = 0, .external_lex_state = 2},
  [142] = {.lex_state = 0, .external_lex_state = 2},
  [143] = {.lex_state = 0, .external_lex_state = 2},
  [144] = {.lex_state = 0, .external_lex_state = 2},
  [145] = {.lex_state = 0, .external_lex_state = 2},
  [146] = {.lex_state = 0, .external_lex_state = 2},
  [147] = {.lex_state = 0, .external_lex_state = 2},
  [148] = {.lex_state = 0, .external_lex_state = 2},
  [149] = {.lex_state = 0, .external_lex_state = 2},
  [150] = {.lex_state = 0, .external_lex_state = 2},
  [151] = {.lex_state = 0, .external_lex_state = 2},
  [152] = {.lex_state = 0, .external_lex_state = 2},
  [153] = {.lex_state = 0, .external_lex_state = 2},
  [154] = {.lex_state = 0, .external_lex_state = 2},
  [155] = {.lex_state = 0, .external_lex_state = 2},
  [156] = {.lex_state = 0, .external_lex_state = 2},
  [157] = {.lex_state = 0, .external_lex_state = 2},
  [158] = {.lex_state = 0, .external_lex_state = 2},
  [159] = {.lex_state = 9, .external_lex_state = 3},
  [160] = {.lex_state = 9, .external_lex_state = 3},
  [161] = {.lex_state = 0, .external_lex_state = 3},
  [162] = {.lex_state = 0, .external_lex_state = 2},
  [163] = {.lex_state = 0, .external_lex_state = 2},
  [164] = {.lex_state = 0, .external_lex_state = 3},
  [165] = {.lex_state = 0, .external_lex_state = 2},
  [166] = {.lex_state = 0, .external_lex_state = 2},
  [167] = {.lex_state = 0, .external_lex_state = 3},
  [168] = {.lex_state = 0, .external_lex_state = 3},
  [169] = {.lex_state = 0, .external_lex_state = 2},
  [170] = {.lex_state = 0, .external_lex_state = 2},
  [171] = {.lex_state = 0, .external_lex_state = 2},
  [172] = {.lex_state = 0, .external_lex_state = 2},
  [173] = {.lex_state = 0, .external_lex_state = 2},
  [174] = {.lex_state = 0, .external_lex_state = 2},
  [175] = {.lex_state = 9, .external_lex_state = 2},
  [176] = {.lex_state = 0, .external_lex_state = 2},
  [177] = {.lex_state = 10, .external_lex_state = 2},
  [178] = {.lex_state = 0, .external_lex_state = 2},
  [179] = {.lex_state = 0, .external_lex_state = 2},
  [180] = {.lex_state = 9, .external_lex_state = 2},
  [181] = {.lex_state = 0, .external_lex_state = 2},
  [182] = {.lex_state = 0, .external_lex_state = 2},
  [183] = {.lex_state = 0, .external_lex_state = 2},
  [184] = {.lex_state = 0, .external_lex_state = 2},
  [185] = {.lex_state = 0, .external_lex_state = 2},
  [186] = {.lex_state = 0, .external_lex_state = 2},
  [187] = {.lex_state = 0, .external_lex_state = 3},
  [188] = {.lex_state = 0, .external_lex_state = 2},
  [189] = {.lex_state = 0, .external_lex_state = 2},
  [190] = {.lex_state = 0, .external_lex_state = 2},
  [191] = {.lex_state = 0, .external_lex_state = 2},
  [192] = {.lex_state = 0, .external_lex_state = 3},
  [193] = {.lex_state = 9, .external_lex_state = 2},
  [194] = {.lex_state = 0, .external_lex_state = 2},
  [195] = {.lex_state = 0, .external_lex_state = 2},
  [196] = {.lex_state = 0, .external_lex_state = 2},
  [197] = {.lex_state = 9, .external_lex_state = 2},
  [198] = {.lex_state = 0, .external_lex_state = 4},
  [199] = {.lex_state = 0, .external_lex_state = 2},
  [200] = {.lex_state = 0, .external_lex_state = 2},
  [201] = {.lex_state = 0, .external_lex_state = 2},
  [202] = {.lex_state = 0, .external_lex_state = 5},
  [203] = {.lex_state = 10, .external_lex_state = 2},
  [204] = {.lex_state = 0, .external_lex_state = 2},
  [205] = {.lex_state = 9, .external_lex_state = 2},
  [206] = {.lex_state = 0, .external_lex_state = 2},
  [207] = {.lex_state = 10, .external_lex_state = 2},
  [208] = {.lex_state = 0, .external_lex_state = 5},
  [209] = {.lex_state = 0, .external_lex_state = 2},
  [210] = {.lex_state = 0, .external_lex_state = 2},
  [211] = {.lex_state = 0, .external_lex_state = 2},
  [212] = {.lex_state = 0, .external_lex_state = 2},
  [213] = {.lex_state = 0, .external_lex_state = 2},
  [214] = {.lex_state = 0, .external_lex_state = 6},
  [215] = {.lex_state = 0, .external_lex_state = 2},
  [216] = {.lex_state = 0, .external_lex_state = 2},
  [217] = {.lex_state = 0, .external_lex_state = 2},
  [218] = {.lex_state = 0, .external_lex_state = 2},
  [219] = {.lex_state = 0, .external_lex_state = 2},
  [220] = {.lex_state = 0, .external_lex_state = 2},
  [221] = {.lex_state = 0, .external_lex_state = 2},
  [222] = {.lex_state = 0, .external_lex_state = 7},
  [223] = {.lex_state = 0, .external_lex_state = 7},
  [224] = {.lex_state = 0, .external_lex_state = 2},
  [225] = {.lex_state = 0, .external_lex_state = 2},
  [226] = {.lex_state = 0, .external_lex_state = 2},
  [227] = {.lex_state = 0, .external_lex_state = 2},
  [228] = {.lex_state = 0, .external_lex_state = 2},
  [229] = {.lex_state = 0, .external_lex_state = 2},
  [230] = {.lex_state = 0, .external_lex_state = 2},
  [231] = {.lex_state = 0, .external_lex_state = 2},
  [232] = {.lex_state = 0, .external_lex_state = 2},
  [233] = {.lex_state = 0, .external_lex_state = 2},
  [234] = {.lex_state = 0, .external_lex_state = 2},
  [235] = {.lex_state = 0, .external_lex_state = 2},
  [236] = {.lex_state = 0, .external_lex_state = 2},
  [237] = {.lex_state = 0, .external_lex_state = 2},
  [238] = {.lex_state = 0, .external_lex_state = 2},
  [239] = {.lex_state = 0, .external_lex_state = 2},
  [240] = {.lex_state = 0, .external_lex_state = 2},
  [241] = {.lex_state = 0, .external_lex_state = 2},
  [242] = {.lex_state = 0, .external_lex_state = 2},
  [243] = {.lex_state = 0, .external_lex_state = 2},
  [244] = {.lex_state = 0, .external_lex_state = 2},
  [245] = {.lex_state = 10, .external_lex_state = 2},
  [246] = {.lex_state = 0, .external_lex_state = 2},
  [247] = {.lex_state = 0, .external_lex_state = 2},
  [248] = {.lex_state = 0, .external_lex_state = 2},
  [249] = {.lex_state = 0, .external_lex_state = 2},
  [250] = {.lex_state = 0, .external_lex_state = 2},
  [251] = {.lex_state = 0, .external_lex_state = 2},
  [252] = {.lex_state = 0, .external_lex_state = 2},
  [253] = {(TSStateId)(-1)},
  [254] = {(TSStateId)(-1)},
};

enum {
  ts_external_token__comment_start = 0,
  ts_external_token__comment_content = 1,
  ts_external_token__comment_end = 2,
  ts_external_token__string_start = 3,
  ts_external_token__string_content = 4,
  ts_external_token__string_end = 5,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__comment_start] = sym__comment_start,
  [ts_external_token__comment_content] = sym__comment_content,
  [ts_external_token__comment_end] = sym__comment_end,
  [ts_external_token__string_start] = sym__string_start,
  [ts_external_token__string_content] = sym__string_content,
  [ts_external_token__string_end] = sym__string_end,
};

static const bool ts_external_scanner_states[8][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__comment_start] = true,
    [ts_external_token__comment_content] = true,
    [ts_external_token__comment_end] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
  [2] = {
    [ts_external_token__comment_start] = true,
  },
  [3] = {
    [ts_external_token__comment_start] = true,
    [ts_external_token__string_start] = true,
  },
  [4] = {
    [ts_external_token__comment_start] = true,
    [ts_external_token__comment_content] = true,
    [ts_external_token__comment_end] = true,
  },
  [5] = {
    [ts_external_token__comment_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
  [6] = {
    [ts_external_token__comment_start] = true,
    [ts_external_token__comment_end] = true,
  },
  [7] = {
    [ts_external_token__comment_start] = true,
    [ts_external_token__string_end] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_shebang] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym__comment_start] = ACTIONS(3),
    [sym__comment_content] = ACTIONS(1),
    [sym__comment_end] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_chunk] = STATE(230),
    [sym__block] = STATE(229),
    [sym_return_statement] = STATE(171),
    [sym_statement] = STATE(132),
    [sym_local_function_definition_statement] = STATE(135),
    [sym_function_definition_statement] = STATE(135),
    [sym_for_generic_statement] = STATE(135),
    [sym_for_numeric_statement] = STATE(135),
    [sym_if_statement] = STATE(135),
    [sym_repeat_statement] = STATE(135),
    [sym_while_statement] = STATE(135),
    [sym_do_statement] = STATE(135),
    [sym_goto_statement] = STATE(135),
    [sym_label_statement] = STATE(135),
    [sym_local_variable_declaration] = STATE(135),
    [sym_variable_assignment] = STATE(135),
    [sym_variable_list] = STATE(219),
    [sym_empty_statement] = STATE(135),
    [sym_prefix_expression] = STATE(199),
    [sym__prefix_expression] = STATE(168),
    [sym_parenthesized_expression] = STATE(4),
    [sym_call] = STATE(105),
    [sym__table_method_variable] = STATE(167),
    [sym_variable] = STATE(161),
    [sym__table_variable] = STATE(2),
    [sym_comment] = STATE(1),
    [aux_sym__block_repeat1] = STATE(49),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_shebang] = ACTIONS(9),
    [anon_sym_return] = ACTIONS(11),
    [anon_sym_local] = ACTIONS(13),
    [anon_sym_function] = ACTIONS(15),
    [anon_sym_for] = ACTIONS(17),
    [anon_sym_do] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_repeat] = ACTIONS(23),
    [anon_sym_while] = ACTIONS(25),
    [sym_break_statement] = ACTIONS(27),
    [anon_sym_goto] = ACTIONS(29),
    [anon_sym_COLON_COLON] = ACTIONS(31),
    [anon_sym_SEMI] = ACTIONS(33),
    [anon_sym_LPAREN] = ACTIONS(35),
    [sym__comment_start] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 8,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(41), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_DOT,
    STATE(2), 1,
      sym_comment,
    STATE(9), 1,
      sym__indexed_field_identifier,
    STATE(10), 1,
      sym__named_field_identifier,
    ACTIONS(39), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      sym_identifier,
    ACTIONS(37), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [72] = 8,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(41), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_DOT,
    STATE(3), 1,
      sym_comment,
    STATE(8), 1,
      sym__named_field_identifier,
    STATE(11), 1,
      sym__indexed_field_identifier,
    ACTIONS(47), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      sym_identifier,
    ACTIONS(45), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [144] = 9,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(41), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_DOT,
    STATE(4), 1,
      sym_comment,
    STATE(5), 1,
      sym__indexed_field_identifier,
    STATE(12), 1,
      sym__named_field_identifier,
    ACTIONS(53), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(49), 22,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
    ACTIONS(51), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      sym_identifier,
  [217] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(5), 1,
      sym_comment,
    ACTIONS(57), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(55), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [279] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(6), 1,
      sym_comment,
    ACTIONS(61), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(59), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [341] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(7), 1,
      sym_comment,
    ACTIONS(65), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(63), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [403] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(8), 1,
      sym_comment,
    ACTIONS(57), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(55), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [465] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(9), 1,
      sym_comment,
    ACTIONS(69), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(67), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [527] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(10), 1,
      sym_comment,
    ACTIONS(69), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(67), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [589] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(11), 1,
      sym_comment,
    ACTIONS(57), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(55), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [651] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(12), 1,
      sym_comment,
    ACTIONS(57), 25,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_EQ,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(55), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [713] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(13), 1,
      sym_comment,
    ACTIONS(73), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(71), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [774] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(14), 1,
      sym_comment,
    ACTIONS(77), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(75), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [835] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(15), 1,
      sym_comment,
    ACTIONS(81), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(79), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [896] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(16), 1,
      sym_comment,
    ACTIONS(85), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(83), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [957] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(17), 1,
      sym_comment,
    ACTIONS(89), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(87), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1018] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(18), 1,
      sym_comment,
    ACTIONS(93), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(91), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1079] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(19), 1,
      sym_comment,
    ACTIONS(97), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(95), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1140] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(20), 1,
      sym_comment,
    ACTIONS(101), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(99), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1201] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(21), 1,
      sym_comment,
    ACTIONS(105), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(103), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1262] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(22), 1,
      sym_comment,
    ACTIONS(109), 24,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_DOT,
      sym_identifier,
    ACTIONS(107), 26,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1323] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(23), 1,
      sym_comment,
    ACTIONS(53), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(49), 22,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
    ACTIONS(51), 23,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      anon_sym_COLON,
      sym_identifier,
  [1384] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(115), 1,
      anon_sym_COLON,
    STATE(24), 1,
      sym_comment,
    STATE(192), 1,
      sym__method_identifier,
    ACTIONS(113), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(111), 23,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1446] = 36,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_local,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_for,
    ACTIONS(19), 1,
      anon_sym_do,
    ACTIONS(21), 1,
      anon_sym_if,
    ACTIONS(23), 1,
      anon_sym_repeat,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      sym_break_statement,
    ACTIONS(29), 1,
      anon_sym_goto,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(117), 1,
      anon_sym_end,
    ACTIONS(119), 1,
      anon_sym_elseif,
    ACTIONS(121), 1,
      anon_sym_else,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(25), 1,
      sym_comment,
    STATE(49), 1,
      aux_sym__block_repeat1,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(163), 1,
      aux_sym_if_statement_repeat1,
    STATE(165), 1,
      sym_block,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(171), 1,
      sym_return_statement,
    STATE(181), 1,
      sym__block,
    STATE(186), 1,
      sym_elseif_clause,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(219), 1,
      sym_variable_list,
    STATE(240), 1,
      sym_else_clause,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [1567] = 9,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    STATE(26), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 16,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(125), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      sym_identifier,
  [1633] = 9,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    STATE(27), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 16,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(125), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      sym_identifier,
  [1699] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(28), 1,
      sym_comment,
    ACTIONS(97), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(95), 23,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1755] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(135), 1,
      anon_sym_CARET,
    STATE(29), 1,
      sym_comment,
    ACTIONS(137), 22,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(139), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
  [1813] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(30), 1,
      sym_comment,
    ACTIONS(143), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(141), 23,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1869] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(31), 1,
      sym_comment,
    ACTIONS(147), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(145), 23,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1925] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(32), 1,
      sym_comment,
    ACTIONS(151), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(149), 23,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1981] = 13,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    STATE(33), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 12,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(125), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      sym_identifier,
  [2055] = 16,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(163), 1,
      anon_sym_and,
    STATE(34), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(123), 8,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(125), 17,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_or,
      sym_identifier,
  [2135] = 15,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    STATE(35), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(123), 8,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(125), 18,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_or,
      anon_sym_and,
      sym_identifier,
  [2213] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(36), 1,
      sym_comment,
    ACTIONS(85), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(83), 23,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [2269] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(37), 1,
      sym_comment,
    ACTIONS(169), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(167), 23,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [2325] = 12,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    STATE(38), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(125), 20,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      sym_identifier,
  [2397] = 11,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(157), 1,
      anon_sym_AMP,
    STATE(39), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 13,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(125), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      sym_identifier,
  [2467] = 10,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    STATE(40), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 14,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(125), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      sym_identifier,
  [2535] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(41), 1,
      sym_comment,
    ACTIONS(101), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(99), 23,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [2591] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(42), 1,
      sym_comment,
    ACTIONS(113), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(111), 23,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [2647] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(43), 1,
      sym_comment,
    ACTIONS(173), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(171), 23,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [2703] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(135), 1,
      anon_sym_CARET,
    STATE(44), 1,
      sym_comment,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(123), 19,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(125), 21,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      sym_identifier,
  [2765] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(135), 1,
      anon_sym_CARET,
    STATE(45), 1,
      sym_comment,
    ACTIONS(123), 22,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(125), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
  [2823] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(46), 1,
      sym_comment,
    ACTIONS(73), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
    ACTIONS(71), 23,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [2879] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(135), 1,
      anon_sym_CARET,
    STATE(47), 1,
      sym_comment,
    ACTIONS(123), 22,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(125), 22,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_or,
      anon_sym_and,
      anon_sym_TILDE,
      anon_sym_SLASH,
      sym_identifier,
  [2937] = 31,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_local,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_for,
    ACTIONS(19), 1,
      anon_sym_do,
    ACTIONS(21), 1,
      anon_sym_if,
    ACTIONS(23), 1,
      anon_sym_repeat,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      sym_break_statement,
    ACTIONS(29), 1,
      anon_sym_goto,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(48), 1,
      sym_comment,
    STATE(49), 1,
      aux_sym__block_repeat1,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(171), 1,
      sym_return_statement,
    STATE(181), 1,
      sym__block,
    STATE(191), 1,
      sym_block,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(219), 1,
      sym_variable_list,
    ACTIONS(175), 3,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [3045] = 30,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_local,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_for,
    ACTIONS(19), 1,
      anon_sym_do,
    ACTIONS(21), 1,
      anon_sym_if,
    ACTIONS(23), 1,
      anon_sym_repeat,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      sym_break_statement,
    ACTIONS(29), 1,
      anon_sym_goto,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(177), 1,
      ts_builtin_sym_end,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(49), 1,
      sym_comment,
    STATE(51), 1,
      aux_sym__block_repeat1,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(169), 1,
      sym_return_statement,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(219), 1,
      sym_variable_list,
    ACTIONS(179), 4,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_until,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [3151] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(163), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_COMMA,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(50), 1,
      sym_comment,
    STATE(124), 1,
      aux_sym__value_list_repeat1,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(181), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(183), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [3234] = 27,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(189), 1,
      ts_builtin_sym_end,
    ACTIONS(191), 1,
      sym_identifier,
    ACTIONS(196), 1,
      anon_sym_local,
    ACTIONS(199), 1,
      anon_sym_function,
    ACTIONS(202), 1,
      anon_sym_for,
    ACTIONS(205), 1,
      anon_sym_do,
    ACTIONS(208), 1,
      anon_sym_if,
    ACTIONS(211), 1,
      anon_sym_repeat,
    ACTIONS(214), 1,
      anon_sym_while,
    ACTIONS(217), 1,
      sym_break_statement,
    ACTIONS(220), 1,
      anon_sym_goto,
    ACTIONS(223), 1,
      anon_sym_COLON_COLON,
    ACTIONS(226), 1,
      anon_sym_SEMI,
    ACTIONS(229), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(219), 1,
      sym_variable_list,
    STATE(51), 2,
      sym_comment,
      aux_sym__block_repeat1,
    ACTIONS(194), 5,
      anon_sym_return,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_until,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [3333] = 31,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_local,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_for,
    ACTIONS(19), 1,
      anon_sym_do,
    ACTIONS(21), 1,
      anon_sym_if,
    ACTIONS(23), 1,
      anon_sym_repeat,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      sym_break_statement,
    ACTIONS(29), 1,
      anon_sym_goto,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_end,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(49), 1,
      aux_sym__block_repeat1,
    STATE(52), 1,
      sym_comment,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(171), 1,
      sym_return_statement,
    STATE(181), 1,
      sym__block,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(218), 1,
      sym_block,
    STATE(219), 1,
      sym_variable_list,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [3439] = 31,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_local,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_for,
    ACTIONS(19), 1,
      anon_sym_do,
    ACTIONS(21), 1,
      anon_sym_if,
    ACTIONS(23), 1,
      anon_sym_repeat,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      sym_break_statement,
    ACTIONS(29), 1,
      anon_sym_goto,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(234), 1,
      anon_sym_end,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(49), 1,
      aux_sym__block_repeat1,
    STATE(53), 1,
      sym_comment,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(171), 1,
      sym_return_statement,
    STATE(181), 1,
      sym__block,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(219), 1,
      sym_variable_list,
    STATE(236), 1,
      sym_block,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [3545] = 31,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_local,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_for,
    ACTIONS(19), 1,
      anon_sym_do,
    ACTIONS(21), 1,
      anon_sym_if,
    ACTIONS(23), 1,
      anon_sym_repeat,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      sym_break_statement,
    ACTIONS(29), 1,
      anon_sym_goto,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_end,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(49), 1,
      aux_sym__block_repeat1,
    STATE(54), 1,
      sym_comment,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(171), 1,
      sym_return_statement,
    STATE(181), 1,
      sym__block,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(219), 1,
      sym_variable_list,
    STATE(232), 1,
      sym_block,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [3651] = 31,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_local,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_for,
    ACTIONS(19), 1,
      anon_sym_do,
    ACTIONS(21), 1,
      anon_sym_if,
    ACTIONS(23), 1,
      anon_sym_repeat,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      sym_break_statement,
    ACTIONS(29), 1,
      anon_sym_goto,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(238), 1,
      anon_sym_end,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(49), 1,
      aux_sym__block_repeat1,
    STATE(55), 1,
      sym_comment,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(171), 1,
      sym_return_statement,
    STATE(181), 1,
      sym__block,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(219), 1,
      sym_variable_list,
    STATE(241), 1,
      sym_block,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [3757] = 31,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_local,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_for,
    ACTIONS(19), 1,
      anon_sym_do,
    ACTIONS(21), 1,
      anon_sym_if,
    ACTIONS(23), 1,
      anon_sym_repeat,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      sym_break_statement,
    ACTIONS(29), 1,
      anon_sym_goto,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_until,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(49), 1,
      aux_sym__block_repeat1,
    STATE(56), 1,
      sym_comment,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(171), 1,
      sym_return_statement,
    STATE(181), 1,
      sym__block,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(219), 1,
      sym_variable_list,
    STATE(249), 1,
      sym_block,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [3863] = 31,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_local,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_for,
    ACTIONS(19), 1,
      anon_sym_do,
    ACTIONS(21), 1,
      anon_sym_if,
    ACTIONS(23), 1,
      anon_sym_repeat,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      sym_break_statement,
    ACTIONS(29), 1,
      anon_sym_goto,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(242), 1,
      anon_sym_end,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(49), 1,
      aux_sym__block_repeat1,
    STATE(57), 1,
      sym_comment,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(171), 1,
      sym_return_statement,
    STATE(181), 1,
      sym__block,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(219), 1,
      sym_variable_list,
    STATE(248), 1,
      sym_block,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [3969] = 31,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_local,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_for,
    ACTIONS(19), 1,
      anon_sym_do,
    ACTIONS(21), 1,
      anon_sym_if,
    ACTIONS(23), 1,
      anon_sym_repeat,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      sym_break_statement,
    ACTIONS(29), 1,
      anon_sym_goto,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(244), 1,
      anon_sym_end,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(49), 1,
      aux_sym__block_repeat1,
    STATE(58), 1,
      sym_comment,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(171), 1,
      sym_return_statement,
    STATE(181), 1,
      sym__block,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(216), 1,
      sym_block,
    STATE(219), 1,
      sym_variable_list,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [4075] = 31,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_local,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_for,
    ACTIONS(19), 1,
      anon_sym_do,
    ACTIONS(21), 1,
      anon_sym_if,
    ACTIONS(23), 1,
      anon_sym_repeat,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      sym_break_statement,
    ACTIONS(29), 1,
      anon_sym_goto,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(246), 1,
      anon_sym_end,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(49), 1,
      aux_sym__block_repeat1,
    STATE(59), 1,
      sym_comment,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(171), 1,
      sym_return_statement,
    STATE(181), 1,
      sym__block,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(219), 1,
      sym_variable_list,
    STATE(237), 1,
      sym_block,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [4181] = 31,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_local,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_for,
    ACTIONS(19), 1,
      anon_sym_do,
    ACTIONS(21), 1,
      anon_sym_if,
    ACTIONS(23), 1,
      anon_sym_repeat,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      sym_break_statement,
    ACTIONS(29), 1,
      anon_sym_goto,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(248), 1,
      anon_sym_end,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(49), 1,
      aux_sym__block_repeat1,
    STATE(60), 1,
      sym_comment,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(171), 1,
      sym_return_statement,
    STATE(181), 1,
      sym__block,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(219), 1,
      sym_variable_list,
    STATE(221), 1,
      sym_block,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [4287] = 17,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(163), 1,
      anon_sym_and,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(61), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(250), 5,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(252), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [4365] = 17,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(163), 1,
      anon_sym_and,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(62), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(254), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(256), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [4442] = 30,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_return,
    ACTIONS(13), 1,
      anon_sym_local,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_for,
    ACTIONS(19), 1,
      anon_sym_do,
    ACTIONS(21), 1,
      anon_sym_if,
    ACTIONS(23), 1,
      anon_sym_repeat,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      sym_break_statement,
    ACTIONS(29), 1,
      anon_sym_goto,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(258), 1,
      ts_builtin_sym_end,
    STATE(2), 1,
      sym__table_variable,
    STATE(4), 1,
      sym_parenthesized_expression,
    STATE(49), 1,
      aux_sym__block_repeat1,
    STATE(63), 1,
      sym_comment,
    STATE(105), 1,
      sym_call,
    STATE(132), 1,
      sym_statement,
    STATE(161), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(171), 1,
      sym_return_statement,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(219), 1,
      sym_variable_list,
    STATE(224), 1,
      sym__block,
    STATE(135), 13,
      sym_local_function_definition_statement,
      sym_function_definition_statement,
      sym_for_generic_statement,
      sym_for_numeric_statement,
      sym_if_statement,
      sym_repeat_statement,
      sym_while_statement,
      sym_do_statement,
      sym_goto_statement,
      sym_label_statement,
      sym_local_variable_declaration,
      sym_variable_assignment,
      sym_empty_statement,
  [4545] = 17,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(163), 1,
      anon_sym_and,
    ACTIONS(187), 1,
      anon_sym_or,
    STATE(64), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(260), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(262), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [4622] = 24,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      ts_builtin_sym_end,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(65), 1,
      sym_comment,
    STATE(69), 1,
      sym_expression,
    STATE(162), 1,
      sym_expression_list,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(170), 1,
      sym_empty_statement,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    ACTIONS(268), 4,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_until,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [4708] = 9,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(41), 1,
      anon_sym_LBRACK,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(282), 1,
      anon_sym_EQ,
    STATE(8), 1,
      sym__named_field_identifier,
    STATE(11), 1,
      sym__indexed_field_identifier,
    STATE(66), 1,
      sym_comment,
    ACTIONS(47), 4,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_SLASH,
    ACTIONS(45), 24,
      sym__string_start,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_or,
      anon_sym_and,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COLON,
  [4762] = 23,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(286), 1,
      anon_sym_RBRACE,
    ACTIONS(288), 1,
      anon_sym_LBRACK,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(67), 1,
      sym_comment,
    STATE(107), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(184), 1,
      sym_field,
    STATE(220), 1,
      sym_field_list,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [4842] = 23,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(288), 1,
      anon_sym_LBRACK,
    ACTIONS(290), 1,
      anon_sym_RBRACE,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(68), 1,
      sym_comment,
    STATE(107), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(184), 1,
      sym_field,
    STATE(226), 1,
      sym_field_list,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [4922] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    ACTIONS(296), 1,
      anon_sym_else,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    STATE(69), 1,
      sym_comment,
    STATE(157), 1,
      aux_sym_expression_list_repeat1,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(292), 6,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [4993] = 22,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(288), 1,
      anon_sym_LBRACK,
    ACTIONS(302), 1,
      anon_sym_RBRACE,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(70), 1,
      sym_comment,
    STATE(107), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(194), 1,
      sym_field,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [5070] = 22,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(288), 1,
      anon_sym_LBRACK,
    ACTIONS(304), 1,
      anon_sym_RBRACE,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(71), 1,
      sym_comment,
    STATE(107), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(194), 1,
      sym_field,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [5147] = 17,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    ACTIONS(308), 1,
      anon_sym_else,
    STATE(72), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(306), 7,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_COMMA,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [5213] = 21,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    ACTIONS(284), 1,
      sym_identifier,
    ACTIONS(288), 1,
      anon_sym_LBRACK,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(73), 1,
      sym_comment,
    STATE(107), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(194), 1,
      sym_field,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [5287] = 21,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    ACTIONS(310), 1,
      anon_sym_RPAREN,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(69), 1,
      sym_expression,
    STATE(74), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(210), 1,
      sym_expression_list,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [5361] = 20,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(50), 1,
      sym_expression,
    STATE(75), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(211), 1,
      sym__value_list,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [5432] = 20,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(50), 1,
      sym_expression,
    STATE(76), 1,
      sym_comment,
    STATE(134), 1,
      sym__value_list,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [5503] = 20,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(50), 1,
      sym_expression,
    STATE(77), 1,
      sym_comment,
    STATE(141), 1,
      sym__value_list,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [5574] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(78), 1,
      sym_comment,
    STATE(119), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [5642] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(40), 1,
      sym_expression,
    STATE(79), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [5710] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(80), 1,
      sym_comment,
    STATE(113), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [5778] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(64), 1,
      sym_expression,
    STATE(81), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [5846] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(82), 1,
      sym_comment,
    STATE(115), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [5914] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(61), 1,
      sym_expression,
    STATE(83), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [5982] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(84), 1,
      sym_comment,
    STATE(114), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6050] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(29), 1,
      sym_expression,
    STATE(85), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6118] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(47), 1,
      sym_expression,
    STATE(86), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6186] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(87), 1,
      sym_comment,
    STATE(112), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6254] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(62), 1,
      sym_expression,
    STATE(88), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6322] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(89), 1,
      sym_comment,
    STATE(110), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6390] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(27), 1,
      sym_expression,
    STATE(90), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6458] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(91), 1,
      sym_comment,
    STATE(106), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6526] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(92), 1,
      sym_comment,
    STATE(118), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6594] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(93), 1,
      sym_comment,
    STATE(111), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6662] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(45), 1,
      sym_expression,
    STATE(94), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6730] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(44), 1,
      sym_expression,
    STATE(95), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6798] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(96), 1,
      sym_comment,
    STATE(108), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6866] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(72), 1,
      sym_expression,
    STATE(97), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [6934] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(33), 1,
      sym_expression,
    STATE(98), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [7002] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(34), 1,
      sym_expression,
    STATE(99), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [7070] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(35), 1,
      sym_expression,
    STATE(100), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [7138] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(38), 1,
      sym_expression,
    STATE(101), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [7206] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(39), 1,
      sym_expression,
    STATE(102), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [7274] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(103), 1,
      sym_comment,
    STATE(121), 1,
      sym_expression,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [7342] = 19,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      anon_sym_function,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      sym__string_start,
    STATE(2), 1,
      sym__table_variable,
    STATE(23), 1,
      sym_variable,
    STATE(24), 1,
      sym_prefix_expression,
    STATE(26), 1,
      sym_expression,
    STATE(104), 1,
      sym_comment,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    ACTIONS(270), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(272), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(276), 2,
      sym_vararg_expression,
      sym_number,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
    ACTIONS(278), 3,
      sym_true,
      sym_false,
      sym_nil,
    STATE(42), 5,
      sym_binary_expression,
      sym_unary_expression,
      sym_table,
      sym_function_definition,
      sym_string,
  [7410] = 10,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(41), 1,
      anon_sym_LBRACK,
    ACTIONS(51), 1,
      anon_sym_COLON,
    ACTIONS(316), 1,
      anon_sym_DOT,
    STATE(105), 1,
      sym_comment,
    STATE(159), 1,
      sym__named_field_identifier,
    STATE(160), 1,
      sym__indexed_field_identifier,
    ACTIONS(53), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    ACTIONS(312), 3,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
    ACTIONS(314), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [7459] = 16,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    STATE(106), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(318), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7518] = 16,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    STATE(107), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(320), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7577] = 16,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    STATE(108), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(322), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7636] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(328), 1,
      anon_sym_LT,
    STATE(109), 1,
      sym_comment,
    STATE(122), 1,
      sym_attribute,
    ACTIONS(324), 6,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(326), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [7674] = 17,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    ACTIONS(330), 1,
      anon_sym_do,
    ACTIONS(332), 1,
      anon_sym_COMMA,
    STATE(110), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7734] = 16,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    ACTIONS(334), 1,
      anon_sym_RPAREN,
    STATE(111), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7791] = 16,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    ACTIONS(336), 1,
      anon_sym_RBRACK,
    STATE(112), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7848] = 16,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    ACTIONS(338), 1,
      anon_sym_COMMA,
    STATE(113), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7905] = 16,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    ACTIONS(340), 1,
      anon_sym_then,
    STATE(114), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7962] = 16,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    ACTIONS(342), 1,
      anon_sym_do,
    STATE(115), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8019] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(348), 1,
      anon_sym_COMMA,
    STATE(116), 2,
      sym_comment,
      aux_sym__local_variable_list_repeat1,
    ACTIONS(344), 5,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(346), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8054] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(355), 1,
      anon_sym_COMMA,
    STATE(116), 1,
      aux_sym__local_variable_list_repeat1,
    STATE(117), 1,
      sym_comment,
    ACTIONS(351), 5,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(353), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8091] = 16,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    ACTIONS(357), 1,
      anon_sym_RBRACK,
    STATE(118), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8148] = 16,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    ACTIONS(359), 1,
      anon_sym_do,
    STATE(119), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8205] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(355), 1,
      anon_sym_COMMA,
    STATE(117), 1,
      aux_sym__local_variable_list_repeat1,
    STATE(120), 1,
      sym_comment,
    ACTIONS(361), 5,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(363), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8242] = 16,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(131), 1,
      anon_sym_SLASH,
    ACTIONS(133), 1,
      anon_sym_DOT_DOT,
    ACTIONS(135), 1,
      anon_sym_CARET,
    ACTIONS(153), 1,
      anon_sym_PIPE,
    ACTIONS(155), 1,
      anon_sym_TILDE,
    ACTIONS(157), 1,
      anon_sym_AMP,
    ACTIONS(298), 1,
      anon_sym_or,
    ACTIONS(300), 1,
      anon_sym_and,
    ACTIONS(365), 1,
      anon_sym_then,
    STATE(121), 1,
      sym_comment,
    ACTIONS(127), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(159), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(161), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(165), 4,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8299] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(122), 1,
      sym_comment,
    ACTIONS(367), 6,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(369), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8331] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(123), 1,
      sym_comment,
    ACTIONS(371), 6,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(373), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8363] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(185), 1,
      anon_sym_COMMA,
    STATE(124), 1,
      sym_comment,
    STATE(126), 1,
      aux_sym__value_list_repeat1,
    ACTIONS(375), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(377), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8399] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(125), 1,
      sym_comment,
    ACTIONS(379), 6,
      ts_builtin_sym_end,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(381), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8431] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(387), 1,
      anon_sym_COMMA,
    STATE(126), 2,
      sym_comment,
      aux_sym__value_list_repeat1,
    ACTIONS(383), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(385), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8465] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(394), 1,
      anon_sym_EQ,
    STATE(127), 1,
      sym_comment,
    ACTIONS(390), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(392), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8498] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(128), 1,
      sym_comment,
    ACTIONS(396), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(398), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8528] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(129), 1,
      sym_comment,
    ACTIONS(400), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(402), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8558] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(130), 1,
      sym_comment,
    ACTIONS(404), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(406), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8588] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(131), 1,
      sym_comment,
    ACTIONS(408), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(410), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8618] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(132), 1,
      sym_comment,
    ACTIONS(412), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(414), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8648] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(133), 1,
      sym_comment,
    ACTIONS(416), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(418), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8678] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(134), 1,
      sym_comment,
    ACTIONS(420), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(422), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8708] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(135), 1,
      sym_comment,
    ACTIONS(312), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(314), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8738] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(136), 1,
      sym_comment,
    ACTIONS(424), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(426), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8768] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(137), 1,
      sym_comment,
    ACTIONS(428), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(430), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8798] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(138), 1,
      sym_comment,
    ACTIONS(432), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(434), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8828] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(139), 1,
      sym_comment,
    ACTIONS(436), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(438), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8858] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(140), 1,
      sym_comment,
    ACTIONS(440), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(442), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8888] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(141), 1,
      sym_comment,
    ACTIONS(444), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(446), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8918] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(142), 1,
      sym_comment,
    ACTIONS(448), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(450), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8948] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(143), 1,
      sym_comment,
    ACTIONS(452), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(454), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [8978] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(144), 1,
      sym_comment,
    ACTIONS(456), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(458), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [9008] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(145), 1,
      sym_comment,
    ACTIONS(460), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(462), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [9038] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(146), 1,
      sym_comment,
    ACTIONS(464), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(466), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [9068] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(147), 1,
      sym_comment,
    ACTIONS(468), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(470), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [9098] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(148), 1,
      sym_comment,
    ACTIONS(472), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(474), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [9128] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(149), 1,
      sym_comment,
    ACTIONS(476), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(478), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [9158] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(150), 1,
      sym_comment,
    ACTIONS(480), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(482), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [9188] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(151), 1,
      sym_comment,
    ACTIONS(484), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(486), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [9218] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(152), 1,
      sym_comment,
    ACTIONS(488), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(490), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [9248] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(153), 1,
      sym_comment,
    ACTIONS(492), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(494), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [9278] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(154), 1,
      sym_comment,
    ACTIONS(496), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(498), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [9308] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(155), 1,
      sym_comment,
    ACTIONS(500), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(502), 15,
      anon_sym_return,
      anon_sym_local,
      anon_sym_function,
      anon_sym_for,
      anon_sym_do,
      anon_sym_end,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_while,
      sym_break_statement,
      anon_sym_goto,
      sym_identifier,
  [9338] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(308), 1,
      anon_sym_else,
    ACTIONS(504), 1,
      anon_sym_COMMA,
    STATE(156), 2,
      sym_comment,
      aux_sym_expression_list_repeat1,
    ACTIONS(306), 6,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [9360] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    ACTIONS(509), 1,
      anon_sym_else,
    STATE(156), 1,
      aux_sym_expression_list_repeat1,
    STATE(157), 1,
      sym_comment,
    ACTIONS(507), 6,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [9384] = 10,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(511), 1,
      sym_identifier,
    STATE(2), 1,
      sym__table_variable,
    STATE(158), 1,
      sym_comment,
    STATE(164), 1,
      sym_variable,
    STATE(167), 1,
      sym__table_method_variable,
    STATE(168), 1,
      sym__prefix_expression,
    STATE(199), 1,
      sym_prefix_expression,
    STATE(4), 2,
      sym_parenthesized_expression,
      sym_call,
  [9416] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(159), 1,
      sym_comment,
    ACTIONS(55), 8,
      sym__string_start,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
  [9433] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(160), 1,
      sym_comment,
    ACTIONS(55), 8,
      sym__string_start,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
  [9450] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(49), 1,
      anon_sym_COLON,
    ACTIONS(513), 1,
      anon_sym_COMMA,
    ACTIONS(515), 1,
      anon_sym_EQ,
    STATE(161), 1,
      sym_comment,
    STATE(189), 1,
      aux_sym_variable_list_repeat1,
    ACTIONS(53), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [9474] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(33), 1,
      anon_sym_SEMI,
    ACTIONS(519), 1,
      anon_sym_else,
    STATE(162), 1,
      sym_comment,
    STATE(172), 1,
      sym_empty_statement,
    ACTIONS(517), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [9496] = 8,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(121), 1,
      anon_sym_else,
    ACTIONS(521), 1,
      anon_sym_end,
    ACTIONS(523), 1,
      anon_sym_elseif,
    STATE(163), 1,
      sym_comment,
    STATE(173), 1,
      aux_sym_if_statement_repeat1,
    STATE(186), 1,
      sym_elseif_clause,
    STATE(212), 1,
      sym_else_clause,
  [9521] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(49), 1,
      anon_sym_COLON,
    STATE(164), 1,
      sym_comment,
    ACTIONS(525), 2,
      anon_sym_COMMA,
      anon_sym_EQ,
    ACTIONS(53), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [9540] = 8,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(121), 1,
      anon_sym_else,
    ACTIONS(523), 1,
      anon_sym_elseif,
    ACTIONS(527), 1,
      anon_sym_end,
    STATE(165), 1,
      sym_comment,
    STATE(166), 1,
      aux_sym_if_statement_repeat1,
    STATE(186), 1,
      sym_elseif_clause,
    STATE(217), 1,
      sym_else_clause,
  [9565] = 8,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(121), 1,
      anon_sym_else,
    ACTIONS(523), 1,
      anon_sym_elseif,
    ACTIONS(529), 1,
      anon_sym_end,
    STATE(166), 1,
      sym_comment,
    STATE(173), 1,
      aux_sym_if_statement_repeat1,
    STATE(186), 1,
      sym_elseif_clause,
    STATE(225), 1,
      sym_else_clause,
  [9590] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(531), 1,
      anon_sym_LBRACE,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      sym__string_start,
    STATE(17), 1,
      sym_argument_list,
    STATE(167), 1,
      sym_comment,
    STATE(15), 2,
      sym_table,
      sym_string,
  [9613] = 7,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(531), 1,
      anon_sym_LBRACE,
    ACTIONS(533), 1,
      anon_sym_LPAREN,
    ACTIONS(535), 1,
      sym__string_start,
    STATE(14), 1,
      sym_argument_list,
    STATE(168), 1,
      sym_comment,
    STATE(15), 2,
      sym_table,
      sym_string,
  [9636] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(539), 1,
      anon_sym_else,
    STATE(169), 1,
      sym_comment,
    ACTIONS(537), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [9652] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(519), 1,
      anon_sym_else,
    STATE(170), 1,
      sym_comment,
    ACTIONS(517), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [9668] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(179), 1,
      anon_sym_else,
    STATE(171), 1,
      sym_comment,
    ACTIONS(177), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [9684] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(543), 1,
      anon_sym_else,
    STATE(172), 1,
      sym_comment,
    ACTIONS(541), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [9700] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(545), 1,
      anon_sym_end,
    ACTIONS(547), 1,
      anon_sym_elseif,
    ACTIONS(550), 1,
      anon_sym_else,
    STATE(186), 1,
      sym_elseif_clause,
    STATE(173), 2,
      sym_comment,
      aux_sym_if_statement_repeat1,
  [9720] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(554), 1,
      anon_sym_COMMA,
    ACTIONS(552), 2,
      anon_sym_in,
      anon_sym_RPAREN,
    STATE(174), 2,
      sym_comment,
      aux_sym__name_list_repeat1,
  [9735] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(559), 1,
      anon_sym_DOT,
    STATE(175), 1,
      sym_comment,
    STATE(197), 1,
      sym__named_field_identifier,
    STATE(238), 1,
      sym__method_identifier,
  [9754] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(302), 1,
      anon_sym_RBRACE,
    STATE(176), 1,
      sym_comment,
    STATE(178), 1,
      aux_sym_field_list_repeat1,
    ACTIONS(561), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [9771] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(563), 1,
      sym_identifier,
    ACTIONS(565), 1,
      anon_sym_RPAREN,
    ACTIONS(567), 1,
      sym_vararg_expression,
    STATE(177), 1,
      sym_comment,
    STATE(234), 1,
      sym_parameter_list,
  [9790] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(572), 1,
      anon_sym_RBRACE,
    ACTIONS(569), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    STATE(178), 2,
      sym_comment,
      aux_sym_field_list_repeat1,
  [9805] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(574), 1,
      anon_sym_in,
    ACTIONS(576), 1,
      anon_sym_COMMA,
    ACTIONS(578), 1,
      anon_sym_EQ,
    STATE(179), 1,
      sym_comment,
    STATE(196), 1,
      aux_sym__name_list_repeat1,
  [9824] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(580), 1,
      anon_sym_LPAREN,
    STATE(150), 1,
      sym__function_body,
    STATE(180), 1,
      sym_comment,
    ACTIONS(582), 2,
      anon_sym_COLON,
      anon_sym_DOT,
  [9841] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(586), 1,
      anon_sym_else,
    STATE(181), 1,
      sym_comment,
    ACTIONS(584), 3,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_until,
  [9856] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(588), 1,
      sym_identifier,
    STATE(175), 1,
      sym__table_identifier,
    STATE(182), 1,
      sym_comment,
    STATE(200), 1,
      sym__table_function_variable,
    STATE(205), 1,
      sym__table_field_variable,
  [9875] = 6,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(590), 1,
      sym_identifier,
    ACTIONS(592), 1,
      anon_sym_function,
    STATE(120), 1,
      sym__local_variable,
    STATE(127), 1,
      sym__local_variable_list,
    STATE(183), 1,
      sym_comment,
  [9894] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(596), 1,
      anon_sym_RBRACE,
    STATE(176), 1,
      aux_sym_field_list_repeat1,
    STATE(184), 1,
      sym_comment,
    ACTIONS(594), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [9911] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(185), 1,
      sym_comment,
    ACTIONS(598), 3,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [9923] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(602), 1,
      anon_sym_else,
    STATE(186), 1,
      sym_comment,
    ACTIONS(600), 2,
      anon_sym_end,
      anon_sym_elseif,
  [9937] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(187), 1,
      sym_comment,
    ACTIONS(604), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [9949] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(606), 1,
      anon_sym_COMMA,
    ACTIONS(608), 1,
      anon_sym_RPAREN,
    STATE(188), 1,
      sym_comment,
    STATE(190), 1,
      aux_sym__name_list_repeat1,
  [9965] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(513), 1,
      anon_sym_COMMA,
    ACTIONS(610), 1,
      anon_sym_EQ,
    STATE(189), 1,
      sym_comment,
    STATE(195), 1,
      aux_sym_variable_list_repeat1,
  [9981] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(612), 1,
      anon_sym_COMMA,
    ACTIONS(614), 1,
      anon_sym_RPAREN,
    STATE(174), 1,
      aux_sym__name_list_repeat1,
    STATE(190), 1,
      sym_comment,
  [9997] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(618), 1,
      anon_sym_else,
    STATE(191), 1,
      sym_comment,
    ACTIONS(616), 2,
      anon_sym_end,
      anon_sym_elseif,
  [10011] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(192), 1,
      sym_comment,
    ACTIONS(620), 3,
      sym__string_start,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [10023] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(193), 1,
      sym_comment,
    ACTIONS(59), 3,
      anon_sym_LPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
  [10035] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(194), 1,
      sym_comment,
    ACTIONS(572), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [10047] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(525), 1,
      anon_sym_EQ,
    ACTIONS(622), 1,
      anon_sym_COMMA,
    STATE(195), 2,
      sym_comment,
      aux_sym_variable_list_repeat1,
  [10061] = 5,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(576), 1,
      anon_sym_COMMA,
    ACTIONS(625), 1,
      anon_sym_in,
    STATE(174), 1,
      aux_sym__name_list_repeat1,
    STATE(196), 1,
      sym_comment,
  [10077] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(627), 1,
      anon_sym_LPAREN,
    STATE(197), 1,
      sym_comment,
    ACTIONS(629), 2,
      anon_sym_COLON,
      anon_sym_DOT,
  [10091] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(631), 1,
      sym__comment_content,
    ACTIONS(633), 1,
      sym__comment_end,
    STATE(198), 1,
      sym_comment,
  [10104] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(635), 1,
      anon_sym_COLON,
    STATE(192), 1,
      sym__method_identifier,
    STATE(199), 1,
      sym_comment,
  [10117] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(580), 1,
      anon_sym_LPAREN,
    STATE(149), 1,
      sym__function_body,
    STATE(200), 1,
      sym_comment,
  [10130] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(637), 1,
      sym_identifier,
    STATE(123), 1,
      sym__local_variable,
    STATE(201), 1,
      sym_comment,
  [10143] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(639), 1,
      sym__string_content,
    ACTIONS(641), 1,
      sym__string_end,
    STATE(202), 1,
      sym_comment,
  [10156] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(643), 1,
      sym_identifier,
    ACTIONS(645), 1,
      sym_vararg_expression,
    STATE(203), 1,
      sym_comment,
  [10169] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(580), 1,
      anon_sym_LPAREN,
    STATE(155), 1,
      sym__function_body,
    STATE(204), 1,
      sym_comment,
  [10182] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    STATE(205), 1,
      sym_comment,
    ACTIONS(647), 2,
      anon_sym_COLON,
      anon_sym_DOT,
  [10193] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(580), 1,
      anon_sym_LPAREN,
    STATE(31), 1,
      sym__function_body,
    STATE(206), 1,
      sym_comment,
  [10206] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(643), 1,
      sym_identifier,
    ACTIONS(649), 1,
      sym_vararg_expression,
    STATE(207), 1,
      sym_comment,
  [10219] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(651), 1,
      sym__string_content,
    ACTIONS(653), 1,
      sym__string_end,
    STATE(208), 1,
      sym_comment,
  [10232] = 4,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(655), 1,
      sym_identifier,
    STATE(209), 1,
      sym_comment,
    STATE(247), 1,
      sym__name_list,
  [10245] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(657), 1,
      anon_sym_RPAREN,
    STATE(210), 1,
      sym_comment,
  [10255] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(659), 1,
      anon_sym_do,
    STATE(211), 1,
      sym_comment,
  [10265] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(661), 1,
      anon_sym_end,
    STATE(212), 1,
      sym_comment,
  [10275] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(663), 1,
      anon_sym_RPAREN,
    STATE(213), 1,
      sym_comment,
  [10285] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(665), 1,
      sym__comment_end,
    STATE(214), 1,
      sym_comment,
  [10295] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(667), 1,
      sym_identifier,
    STATE(215), 1,
      sym_comment,
  [10305] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(669), 1,
      anon_sym_end,
    STATE(216), 1,
      sym_comment,
  [10315] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(671), 1,
      anon_sym_end,
    STATE(217), 1,
      sym_comment,
  [10325] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(673), 1,
      anon_sym_end,
    STATE(218), 1,
      sym_comment,
  [10335] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(675), 1,
      anon_sym_EQ,
    STATE(219), 1,
      sym_comment,
  [10345] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(677), 1,
      anon_sym_RBRACE,
    STATE(220), 1,
      sym_comment,
  [10355] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(679), 1,
      anon_sym_end,
    STATE(221), 1,
      sym_comment,
  [10365] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(681), 1,
      sym__string_end,
    STATE(222), 1,
      sym_comment,
  [10375] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(683), 1,
      sym__string_end,
    STATE(223), 1,
      sym_comment,
  [10385] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(685), 1,
      ts_builtin_sym_end,
    STATE(224), 1,
      sym_comment,
  [10395] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(687), 1,
      anon_sym_end,
    STATE(225), 1,
      sym_comment,
  [10405] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(689), 1,
      anon_sym_RBRACE,
    STATE(226), 1,
      sym_comment,
  [10415] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(691), 1,
      anon_sym_RPAREN,
    STATE(227), 1,
      sym_comment,
  [10425] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(693), 1,
      anon_sym_RPAREN,
    STATE(228), 1,
      sym_comment,
  [10435] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(258), 1,
      ts_builtin_sym_end,
    STATE(229), 1,
      sym_comment,
  [10445] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(695), 1,
      ts_builtin_sym_end,
    STATE(230), 1,
      sym_comment,
  [10455] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(697), 1,
      anon_sym_EQ,
    STATE(231), 1,
      sym_comment,
  [10465] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(699), 1,
      anon_sym_end,
    STATE(232), 1,
      sym_comment,
  [10475] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(701), 1,
      sym_identifier,
    STATE(233), 1,
      sym_comment,
  [10485] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(703), 1,
      anon_sym_RPAREN,
    STATE(234), 1,
      sym_comment,
  [10495] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(643), 1,
      sym_identifier,
    STATE(235), 1,
      sym_comment,
  [10505] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(705), 1,
      anon_sym_end,
    STATE(236), 1,
      sym_comment,
  [10515] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(707), 1,
      anon_sym_end,
    STATE(237), 1,
      sym_comment,
  [10525] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(709), 1,
      anon_sym_LPAREN,
    STATE(238), 1,
      sym_comment,
  [10535] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(711), 1,
      sym_identifier,
    STATE(239), 1,
      sym_comment,
  [10545] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(713), 1,
      anon_sym_end,
    STATE(240), 1,
      sym_comment,
  [10555] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(715), 1,
      anon_sym_end,
    STATE(241), 1,
      sym_comment,
  [10565] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(717), 1,
      sym_identifier,
    STATE(242), 1,
      sym_comment,
  [10575] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(719), 1,
      sym_identifier,
    STATE(243), 1,
      sym_comment,
  [10585] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(721), 1,
      sym_identifier,
    STATE(244), 1,
      sym_comment,
  [10595] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(723), 1,
      anon_sym_GT,
    STATE(245), 1,
      sym_comment,
  [10605] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(604), 1,
      anon_sym_LPAREN,
    STATE(246), 1,
      sym_comment,
  [10615] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(725), 1,
      anon_sym_in,
    STATE(247), 1,
      sym_comment,
  [10625] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(727), 1,
      anon_sym_end,
    STATE(248), 1,
      sym_comment,
  [10635] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(729), 1,
      anon_sym_until,
    STATE(249), 1,
      sym_comment,
  [10645] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(731), 1,
      anon_sym_COLON_COLON,
    STATE(250), 1,
      sym_comment,
  [10655] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(733), 1,
      sym_identifier,
    STATE(251), 1,
      sym_comment,
  [10665] = 3,
    ACTIONS(3), 1,
      sym__comment_start,
    ACTIONS(735), 1,
      sym_identifier,
    STATE(252), 1,
      sym_comment,
  [10675] = 1,
    ACTIONS(737), 1,
      ts_builtin_sym_end,
  [10679] = 1,
    ACTIONS(739), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 72,
  [SMALL_STATE(4)] = 144,
  [SMALL_STATE(5)] = 217,
  [SMALL_STATE(6)] = 279,
  [SMALL_STATE(7)] = 341,
  [SMALL_STATE(8)] = 403,
  [SMALL_STATE(9)] = 465,
  [SMALL_STATE(10)] = 527,
  [SMALL_STATE(11)] = 589,
  [SMALL_STATE(12)] = 651,
  [SMALL_STATE(13)] = 713,
  [SMALL_STATE(14)] = 774,
  [SMALL_STATE(15)] = 835,
  [SMALL_STATE(16)] = 896,
  [SMALL_STATE(17)] = 957,
  [SMALL_STATE(18)] = 1018,
  [SMALL_STATE(19)] = 1079,
  [SMALL_STATE(20)] = 1140,
  [SMALL_STATE(21)] = 1201,
  [SMALL_STATE(22)] = 1262,
  [SMALL_STATE(23)] = 1323,
  [SMALL_STATE(24)] = 1384,
  [SMALL_STATE(25)] = 1446,
  [SMALL_STATE(26)] = 1567,
  [SMALL_STATE(27)] = 1633,
  [SMALL_STATE(28)] = 1699,
  [SMALL_STATE(29)] = 1755,
  [SMALL_STATE(30)] = 1813,
  [SMALL_STATE(31)] = 1869,
  [SMALL_STATE(32)] = 1925,
  [SMALL_STATE(33)] = 1981,
  [SMALL_STATE(34)] = 2055,
  [SMALL_STATE(35)] = 2135,
  [SMALL_STATE(36)] = 2213,
  [SMALL_STATE(37)] = 2269,
  [SMALL_STATE(38)] = 2325,
  [SMALL_STATE(39)] = 2397,
  [SMALL_STATE(40)] = 2467,
  [SMALL_STATE(41)] = 2535,
  [SMALL_STATE(42)] = 2591,
  [SMALL_STATE(43)] = 2647,
  [SMALL_STATE(44)] = 2703,
  [SMALL_STATE(45)] = 2765,
  [SMALL_STATE(46)] = 2823,
  [SMALL_STATE(47)] = 2879,
  [SMALL_STATE(48)] = 2937,
  [SMALL_STATE(49)] = 3045,
  [SMALL_STATE(50)] = 3151,
  [SMALL_STATE(51)] = 3234,
  [SMALL_STATE(52)] = 3333,
  [SMALL_STATE(53)] = 3439,
  [SMALL_STATE(54)] = 3545,
  [SMALL_STATE(55)] = 3651,
  [SMALL_STATE(56)] = 3757,
  [SMALL_STATE(57)] = 3863,
  [SMALL_STATE(58)] = 3969,
  [SMALL_STATE(59)] = 4075,
  [SMALL_STATE(60)] = 4181,
  [SMALL_STATE(61)] = 4287,
  [SMALL_STATE(62)] = 4365,
  [SMALL_STATE(63)] = 4442,
  [SMALL_STATE(64)] = 4545,
  [SMALL_STATE(65)] = 4622,
  [SMALL_STATE(66)] = 4708,
  [SMALL_STATE(67)] = 4762,
  [SMALL_STATE(68)] = 4842,
  [SMALL_STATE(69)] = 4922,
  [SMALL_STATE(70)] = 4993,
  [SMALL_STATE(71)] = 5070,
  [SMALL_STATE(72)] = 5147,
  [SMALL_STATE(73)] = 5213,
  [SMALL_STATE(74)] = 5287,
  [SMALL_STATE(75)] = 5361,
  [SMALL_STATE(76)] = 5432,
  [SMALL_STATE(77)] = 5503,
  [SMALL_STATE(78)] = 5574,
  [SMALL_STATE(79)] = 5642,
  [SMALL_STATE(80)] = 5710,
  [SMALL_STATE(81)] = 5778,
  [SMALL_STATE(82)] = 5846,
  [SMALL_STATE(83)] = 5914,
  [SMALL_STATE(84)] = 5982,
  [SMALL_STATE(85)] = 6050,
  [SMALL_STATE(86)] = 6118,
  [SMALL_STATE(87)] = 6186,
  [SMALL_STATE(88)] = 6254,
  [SMALL_STATE(89)] = 6322,
  [SMALL_STATE(90)] = 6390,
  [SMALL_STATE(91)] = 6458,
  [SMALL_STATE(92)] = 6526,
  [SMALL_STATE(93)] = 6594,
  [SMALL_STATE(94)] = 6662,
  [SMALL_STATE(95)] = 6730,
  [SMALL_STATE(96)] = 6798,
  [SMALL_STATE(97)] = 6866,
  [SMALL_STATE(98)] = 6934,
  [SMALL_STATE(99)] = 7002,
  [SMALL_STATE(100)] = 7070,
  [SMALL_STATE(101)] = 7138,
  [SMALL_STATE(102)] = 7206,
  [SMALL_STATE(103)] = 7274,
  [SMALL_STATE(104)] = 7342,
  [SMALL_STATE(105)] = 7410,
  [SMALL_STATE(106)] = 7459,
  [SMALL_STATE(107)] = 7518,
  [SMALL_STATE(108)] = 7577,
  [SMALL_STATE(109)] = 7636,
  [SMALL_STATE(110)] = 7674,
  [SMALL_STATE(111)] = 7734,
  [SMALL_STATE(112)] = 7791,
  [SMALL_STATE(113)] = 7848,
  [SMALL_STATE(114)] = 7905,
  [SMALL_STATE(115)] = 7962,
  [SMALL_STATE(116)] = 8019,
  [SMALL_STATE(117)] = 8054,
  [SMALL_STATE(118)] = 8091,
  [SMALL_STATE(119)] = 8148,
  [SMALL_STATE(120)] = 8205,
  [SMALL_STATE(121)] = 8242,
  [SMALL_STATE(122)] = 8299,
  [SMALL_STATE(123)] = 8331,
  [SMALL_STATE(124)] = 8363,
  [SMALL_STATE(125)] = 8399,
  [SMALL_STATE(126)] = 8431,
  [SMALL_STATE(127)] = 8465,
  [SMALL_STATE(128)] = 8498,
  [SMALL_STATE(129)] = 8528,
  [SMALL_STATE(130)] = 8558,
  [SMALL_STATE(131)] = 8588,
  [SMALL_STATE(132)] = 8618,
  [SMALL_STATE(133)] = 8648,
  [SMALL_STATE(134)] = 8678,
  [SMALL_STATE(135)] = 8708,
  [SMALL_STATE(136)] = 8738,
  [SMALL_STATE(137)] = 8768,
  [SMALL_STATE(138)] = 8798,
  [SMALL_STATE(139)] = 8828,
  [SMALL_STATE(140)] = 8858,
  [SMALL_STATE(141)] = 8888,
  [SMALL_STATE(142)] = 8918,
  [SMALL_STATE(143)] = 8948,
  [SMALL_STATE(144)] = 8978,
  [SMALL_STATE(145)] = 9008,
  [SMALL_STATE(146)] = 9038,
  [SMALL_STATE(147)] = 9068,
  [SMALL_STATE(148)] = 9098,
  [SMALL_STATE(149)] = 9128,
  [SMALL_STATE(150)] = 9158,
  [SMALL_STATE(151)] = 9188,
  [SMALL_STATE(152)] = 9218,
  [SMALL_STATE(153)] = 9248,
  [SMALL_STATE(154)] = 9278,
  [SMALL_STATE(155)] = 9308,
  [SMALL_STATE(156)] = 9338,
  [SMALL_STATE(157)] = 9360,
  [SMALL_STATE(158)] = 9384,
  [SMALL_STATE(159)] = 9416,
  [SMALL_STATE(160)] = 9433,
  [SMALL_STATE(161)] = 9450,
  [SMALL_STATE(162)] = 9474,
  [SMALL_STATE(163)] = 9496,
  [SMALL_STATE(164)] = 9521,
  [SMALL_STATE(165)] = 9540,
  [SMALL_STATE(166)] = 9565,
  [SMALL_STATE(167)] = 9590,
  [SMALL_STATE(168)] = 9613,
  [SMALL_STATE(169)] = 9636,
  [SMALL_STATE(170)] = 9652,
  [SMALL_STATE(171)] = 9668,
  [SMALL_STATE(172)] = 9684,
  [SMALL_STATE(173)] = 9700,
  [SMALL_STATE(174)] = 9720,
  [SMALL_STATE(175)] = 9735,
  [SMALL_STATE(176)] = 9754,
  [SMALL_STATE(177)] = 9771,
  [SMALL_STATE(178)] = 9790,
  [SMALL_STATE(179)] = 9805,
  [SMALL_STATE(180)] = 9824,
  [SMALL_STATE(181)] = 9841,
  [SMALL_STATE(182)] = 9856,
  [SMALL_STATE(183)] = 9875,
  [SMALL_STATE(184)] = 9894,
  [SMALL_STATE(185)] = 9911,
  [SMALL_STATE(186)] = 9923,
  [SMALL_STATE(187)] = 9937,
  [SMALL_STATE(188)] = 9949,
  [SMALL_STATE(189)] = 9965,
  [SMALL_STATE(190)] = 9981,
  [SMALL_STATE(191)] = 9997,
  [SMALL_STATE(192)] = 10011,
  [SMALL_STATE(193)] = 10023,
  [SMALL_STATE(194)] = 10035,
  [SMALL_STATE(195)] = 10047,
  [SMALL_STATE(196)] = 10061,
  [SMALL_STATE(197)] = 10077,
  [SMALL_STATE(198)] = 10091,
  [SMALL_STATE(199)] = 10104,
  [SMALL_STATE(200)] = 10117,
  [SMALL_STATE(201)] = 10130,
  [SMALL_STATE(202)] = 10143,
  [SMALL_STATE(203)] = 10156,
  [SMALL_STATE(204)] = 10169,
  [SMALL_STATE(205)] = 10182,
  [SMALL_STATE(206)] = 10193,
  [SMALL_STATE(207)] = 10206,
  [SMALL_STATE(208)] = 10219,
  [SMALL_STATE(209)] = 10232,
  [SMALL_STATE(210)] = 10245,
  [SMALL_STATE(211)] = 10255,
  [SMALL_STATE(212)] = 10265,
  [SMALL_STATE(213)] = 10275,
  [SMALL_STATE(214)] = 10285,
  [SMALL_STATE(215)] = 10295,
  [SMALL_STATE(216)] = 10305,
  [SMALL_STATE(217)] = 10315,
  [SMALL_STATE(218)] = 10325,
  [SMALL_STATE(219)] = 10335,
  [SMALL_STATE(220)] = 10345,
  [SMALL_STATE(221)] = 10355,
  [SMALL_STATE(222)] = 10365,
  [SMALL_STATE(223)] = 10375,
  [SMALL_STATE(224)] = 10385,
  [SMALL_STATE(225)] = 10395,
  [SMALL_STATE(226)] = 10405,
  [SMALL_STATE(227)] = 10415,
  [SMALL_STATE(228)] = 10425,
  [SMALL_STATE(229)] = 10435,
  [SMALL_STATE(230)] = 10445,
  [SMALL_STATE(231)] = 10455,
  [SMALL_STATE(232)] = 10465,
  [SMALL_STATE(233)] = 10475,
  [SMALL_STATE(234)] = 10485,
  [SMALL_STATE(235)] = 10495,
  [SMALL_STATE(236)] = 10505,
  [SMALL_STATE(237)] = 10515,
  [SMALL_STATE(238)] = 10525,
  [SMALL_STATE(239)] = 10535,
  [SMALL_STATE(240)] = 10545,
  [SMALL_STATE(241)] = 10555,
  [SMALL_STATE(242)] = 10565,
  [SMALL_STATE(243)] = 10575,
  [SMALL_STATE(244)] = 10585,
  [SMALL_STATE(245)] = 10595,
  [SMALL_STATE(246)] = 10605,
  [SMALL_STATE(247)] = 10615,
  [SMALL_STATE(248)] = 10625,
  [SMALL_STATE(249)] = 10635,
  [SMALL_STATE(250)] = 10645,
  [SMALL_STATE(251)] = 10655,
  [SMALL_STATE(252)] = 10665,
  [SMALL_STATE(253)] = 10675,
  [SMALL_STATE(254)] = 10679,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(3),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(57),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [37] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1, .production_id = 2),
  [39] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 1, .production_id = 2),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [45] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1, .production_id = 1),
  [47] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 1, .production_id = 1),
  [49] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_prefix_expression, 1),
  [51] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_prefix_expression, 1),
  [53] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__prefix_expression, 1),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__table_variable, 2, .production_id = 7),
  [57] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__table_variable, 2, .production_id = 7),
  [59] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_field_identifier, 2, .production_id = 22),
  [61] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_field_identifier, 2, .production_id = 22),
  [63] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__indexed_field_identifier, 3, .production_id = 22),
  [65] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__indexed_field_identifier, 3, .production_id = 22),
  [67] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__table_variable, 2, .production_id = 11),
  [69] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__table_variable, 2, .production_id = 11),
  [71] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3),
  [73] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3),
  [75] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call, 2, .production_id = 9),
  [77] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call, 2, .production_id = 9),
  [79] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 1),
  [81] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 1),
  [83] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2),
  [85] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2),
  [87] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call, 2, .production_id = 10),
  [89] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call, 2, .production_id = 10),
  [91] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2),
  [93] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 2),
  [95] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 2),
  [97] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 2),
  [99] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 3),
  [101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 3),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 3),
  [105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 3),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 1),
  [113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 1),
  [115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 25),
  [125] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 25),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, .production_id = 13),
  [139] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, .production_id = 13),
  [141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_body, 4, .production_id = 43),
  [143] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_body, 4, .production_id = 43),
  [145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 2, .production_id = 12),
  [147] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 2, .production_id = 12),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_body, 4, .production_id = 42),
  [151] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_body, 4, .production_id = 42),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [161] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_body, 5, .production_id = 48),
  [169] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_body, 5, .production_id = 48),
  [171] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_body, 3),
  [173] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_body, 3),
  [175] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_clause, 3, .production_id = 30),
  [177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block, 1),
  [179] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__block, 1),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value_list, 1, .production_id = 14),
  [183] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__value_list, 1, .production_id = 14),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__block_repeat1, 2),
  [191] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__block_repeat1, 2), SHIFT_REPEAT(3),
  [194] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__block_repeat1, 2),
  [196] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__block_repeat1, 2), SHIFT_REPEAT(183),
  [199] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__block_repeat1, 2), SHIFT_REPEAT(182),
  [202] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__block_repeat1, 2), SHIFT_REPEAT(209),
  [205] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__block_repeat1, 2), SHIFT_REPEAT(57),
  [208] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__block_repeat1, 2), SHIFT_REPEAT(84),
  [211] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__block_repeat1, 2), SHIFT_REPEAT(56),
  [214] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__block_repeat1, 2), SHIFT_REPEAT(82),
  [217] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__block_repeat1, 2), SHIFT_REPEAT(135),
  [220] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__block_repeat1, 2), SHIFT_REPEAT(243),
  [223] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__block_repeat1, 2), SHIFT_REPEAT(239),
  [226] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__block_repeat1, 2), SHIFT_REPEAT(142),
  [229] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__block_repeat1, 2), SHIFT_REPEAT(93),
  [232] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_clause, 1),
  [234] = {.entry = {.count = 1, .reusable = false}}, SHIFT(146),
  [236] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [238] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [240] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [242] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [244] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [246] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [248] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__value_list_repeat1, 2, .production_id = 40),
  [252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__value_list_repeat1, 2, .production_id = 40),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_repeat_statement, 4, .production_id = 32),
  [256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_repeat_statement, 4, .production_id = 32),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 1),
  [260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_repeat_statement, 3, .production_id = 21),
  [262] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_repeat_statement, 3, .production_id = 21),
  [264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 1),
  [266] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [268] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 1),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [272] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [278] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [282] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [284] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [292] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression_list, 1),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [296] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression_list, 1),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [302] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_list, 2),
  [304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_list, 3),
  [306] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_expression_list_repeat1, 2),
  [308] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_expression_list_repeat1, 2),
  [310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [314] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1),
  [316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 5, .production_id = 49),
  [320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 1, .production_id = 14),
  [322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 3, .production_id = 34),
  [324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__local_variable, 1, .production_id = 1),
  [326] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__local_variable, 1, .production_id = 1),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [344] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__local_variable_list_repeat1, 2),
  [346] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__local_variable_list_repeat1, 2),
  [348] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__local_variable_list_repeat1, 2), SHIFT_REPEAT(201),
  [351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__local_variable_list, 2, .production_id = 3),
  [353] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__local_variable_list, 2, .production_id = 3),
  [355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__local_variable_list, 1, .production_id = 3),
  [363] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__local_variable_list, 1, .production_id = 3),
  [365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [367] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__local_variable, 2, .production_id = 1),
  [369] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__local_variable, 2, .production_id = 1),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__local_variable_list_repeat1, 2, .production_id = 28),
  [373] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__local_variable_list_repeat1, 2, .production_id = 28),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value_list, 2, .production_id = 33),
  [377] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__value_list, 2, .production_id = 33),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 3, .production_id = 6),
  [381] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 3, .production_id = 6),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__value_list_repeat1, 2, .production_id = 41),
  [385] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__value_list_repeat1, 2, .production_id = 41),
  [387] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_list_repeat1, 2, .production_id = 41), SHIFT_REPEAT(83),
  [390] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_local_variable_declaration, 2),
  [392] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_local_variable_declaration, 2),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 7, .production_id = 51),
  [398] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 7, .production_id = 51),
  [400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_do_statement, 3, .production_id = 20),
  [402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_do_statement, 3, .production_id = 20),
  [404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 45),
  [406] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 45),
  [408] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_label_statement, 3, .production_id = 6),
  [410] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_label_statement, 3, .production_id = 6),
  [412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__block_repeat1, 1),
  [414] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__block_repeat1, 1),
  [416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_generic_statement, 6, .production_id = 44),
  [418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_generic_statement, 6, .production_id = 44),
  [420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_assignment, 3, .production_id = 23),
  [422] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_assignment, 3, .production_id = 23),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 5, .production_id = 39),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 5, .production_id = 39),
  [428] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 37),
  [430] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 37),
  [432] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 36),
  [434] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 36),
  [436] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 35),
  [438] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 35),
  [440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 47),
  [442] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 47),
  [444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_local_variable_declaration, 4, .production_id = 27),
  [446] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_local_variable_declaration, 4, .production_id = 27),
  [448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_empty_statement, 1),
  [450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_empty_statement, 1),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 46),
  [454] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 46),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_generic_statement, 7, .production_id = 50),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_generic_statement, 7, .production_id = 50),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_do_statement, 2),
  [462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_do_statement, 2),
  [464] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_numeric_statement, 8, .production_id = 52),
  [466] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_numeric_statement, 8, .production_id = 52),
  [468] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_numeric_statement, 11, .production_id = 55),
  [470] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_numeric_statement, 11, .production_id = 55),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 4, .production_id = 30),
  [474] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 4, .production_id = 30),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition_statement, 3, .production_id = 16),
  [478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition_statement, 3, .production_id = 16),
  [480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition_statement, 3, .production_id = 15),
  [482] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition_statement, 3, .production_id = 15),
  [484] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 4, .production_id = 30),
  [486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 4, .production_id = 30),
  [488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_numeric_statement, 10, .production_id = 54),
  [490] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_numeric_statement, 10, .production_id = 54),
  [492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_goto_statement, 2, .production_id = 6),
  [494] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_goto_statement, 2, .production_id = 6),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_numeric_statement, 9, .production_id = 53),
  [498] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_numeric_statement, 9, .production_id = 53),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_local_function_definition_statement, 4, .production_id = 26),
  [502] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_local_function_definition_statement, 4, .production_id = 26),
  [504] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_expression_list_repeat1, 2), SHIFT_REPEAT(97),
  [507] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression_list, 2),
  [509] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression_list, 2),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [515] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_list, 1),
  [517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2),
  [519] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 2),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [525] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_list_repeat1, 2),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block, 2),
  [539] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__block, 2),
  [541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 3),
  [543] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 3),
  [545] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 38),
  [547] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 38), SHIFT_REPEAT(103),
  [550] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 38),
  [552] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__name_list_repeat1, 2, .production_id = 29),
  [554] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__name_list_repeat1, 2, .production_id = 29), SHIFT_REPEAT(235),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [569] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_field_list_repeat1, 2), SHIFT_REPEAT(73),
  [572] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_field_list_repeat1, 2),
  [574] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__name_list, 1, .production_id = 1),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [582] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__table_identifier, 1, .production_id = 4),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 1),
  [586] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 1),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [590] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [592] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [596] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_list, 1),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__name_list_repeat1, 2, .production_id = 6),
  [600] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 1, .production_id = 31),
  [602] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 1, .production_id = 31),
  [604] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__method_identifier, 2, .production_id = 24),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [608] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 1, .production_id = 1),
  [610] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_list, 2),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [614] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 2, .production_id = 19),
  [616] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_clause, 4, .production_id = 35),
  [618] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_clause, 4, .production_id = 35),
  [620] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__table_method_variable, 2, .production_id = 8),
  [622] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_list_repeat1, 2), SHIFT_REPEAT(158),
  [625] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__name_list, 2, .production_id = 19),
  [627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__table_function_variable, 2, .production_id = 18),
  [629] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__table_field_variable, 2, .production_id = 18),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [647] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__table_identifier, 1, .production_id = 5),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [663] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 3, .production_id = 1),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [673] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_clause, 2, .production_id = 20),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [685] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 2),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [691] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 4, .production_id = 19),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 1),
  [695] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [709] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__table_function_variable, 2, .production_id = 17),
  [711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [737] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 3),
  [739] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_lua_external_scanner_create(void);
void tree_sitter_lua_external_scanner_destroy(void *);
bool tree_sitter_lua_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_lua_external_scanner_serialize(void *, char *);
void tree_sitter_lua_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_lua(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_lua_external_scanner_create,
      tree_sitter_lua_external_scanner_destroy,
      tree_sitter_lua_external_scanner_scan,
      tree_sitter_lua_external_scanner_serialize,
      tree_sitter_lua_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
