#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 94
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 40
#define ALIAS_COUNT 0
#define TOKEN_COUNT 24
#define EXTERNAL_TOKEN_COUNT 9
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 4
#define PRODUCTION_ID_COUNT 1

enum {
  anon_sym_LT_BANG = 1,
  aux_sym_doctype_token1 = 2,
  anon_sym_GT = 3,
  sym__doctype = 4,
  anon_sym_LT = 5,
  anon_sym_SLASH_GT = 6,
  anon_sym_LT_SLASH = 7,
  anon_sym_EQ = 8,
  sym_attribute_name = 9,
  sym_attribute_value = 10,
  anon_sym_SQUOTE = 11,
  aux_sym_quoted_attribute_value_token1 = 12,
  anon_sym_DQUOTE = 13,
  aux_sym_quoted_attribute_value_token2 = 14,
  sym_text = 15,
  sym__start_tag_name = 16,
  sym__script_start_tag_name = 17,
  sym__style_start_tag_name = 18,
  sym__end_tag_name = 19,
  sym_erroneous_end_tag_name = 20,
  sym__implicit_end_tag = 21,
  sym_raw_text = 22,
  sym_comment = 23,
  sym_fragment = 24,
  sym_doctype = 25,
  sym__node = 26,
  sym_element = 27,
  sym_script_element = 28,
  sym_style_element = 29,
  sym_start_tag = 30,
  sym_script_start_tag = 31,
  sym_style_start_tag = 32,
  sym_self_closing_tag = 33,
  sym_end_tag = 34,
  sym_erroneous_end_tag = 35,
  sym_attribute = 36,
  sym_quoted_attribute_value = 37,
  aux_sym_fragment_repeat1 = 38,
  aux_sym_start_tag_repeat1 = 39,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LT_BANG] = "<!",
  [aux_sym_doctype_token1] = "doctype_token1",
  [anon_sym_GT] = ">",
  [sym__doctype] = "doctype",
  [anon_sym_LT] = "<",
  [anon_sym_SLASH_GT] = "/>",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_EQ] = "=",
  [sym_attribute_name] = "attribute_name",
  [sym_attribute_value] = "attribute_value",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_quoted_attribute_value_token1] = "attribute_value",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_quoted_attribute_value_token2] = "attribute_value",
  [sym_text] = "text",
  [sym__start_tag_name] = "tag_name",
  [sym__script_start_tag_name] = "tag_name",
  [sym__style_start_tag_name] = "tag_name",
  [sym__end_tag_name] = "tag_name",
  [sym_erroneous_end_tag_name] = "erroneous_end_tag_name",
  [sym__implicit_end_tag] = "_implicit_end_tag",
  [sym_raw_text] = "raw_text",
  [sym_comment] = "comment",
  [sym_fragment] = "fragment",
  [sym_doctype] = "doctype",
  [sym__node] = "_node",
  [sym_element] = "element",
  [sym_script_element] = "script_element",
  [sym_style_element] = "style_element",
  [sym_start_tag] = "start_tag",
  [sym_script_start_tag] = "start_tag",
  [sym_style_start_tag] = "start_tag",
  [sym_self_closing_tag] = "self_closing_tag",
  [sym_end_tag] = "end_tag",
  [sym_erroneous_end_tag] = "erroneous_end_tag",
  [sym_attribute] = "attribute",
  [sym_quoted_attribute_value] = "quoted_attribute_value",
  [aux_sym_fragment_repeat1] = "fragment_repeat1",
  [aux_sym_start_tag_repeat1] = "start_tag_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LT_BANG] = anon_sym_LT_BANG,
  [aux_sym_doctype_token1] = aux_sym_doctype_token1,
  [anon_sym_GT] = anon_sym_GT,
  [sym__doctype] = sym__doctype,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_SLASH_GT] = anon_sym_SLASH_GT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_EQ] = anon_sym_EQ,
  [sym_attribute_name] = sym_attribute_name,
  [sym_attribute_value] = sym_attribute_value,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_quoted_attribute_value_token1] = sym_attribute_value,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_quoted_attribute_value_token2] = sym_attribute_value,
  [sym_text] = sym_text,
  [sym__start_tag_name] = sym__start_tag_name,
  [sym__script_start_tag_name] = sym__start_tag_name,
  [sym__style_start_tag_name] = sym__start_tag_name,
  [sym__end_tag_name] = sym__start_tag_name,
  [sym_erroneous_end_tag_name] = sym_erroneous_end_tag_name,
  [sym__implicit_end_tag] = sym__implicit_end_tag,
  [sym_raw_text] = sym_raw_text,
  [sym_comment] = sym_comment,
  [sym_fragment] = sym_fragment,
  [sym_doctype] = sym_doctype,
  [sym__node] = sym__node,
  [sym_element] = sym_element,
  [sym_script_element] = sym_script_element,
  [sym_style_element] = sym_style_element,
  [sym_start_tag] = sym_start_tag,
  [sym_script_start_tag] = sym_start_tag,
  [sym_style_start_tag] = sym_start_tag,
  [sym_self_closing_tag] = sym_self_closing_tag,
  [sym_end_tag] = sym_end_tag,
  [sym_erroneous_end_tag] = sym_erroneous_end_tag,
  [sym_attribute] = sym_attribute,
  [sym_quoted_attribute_value] = sym_quoted_attribute_value,
  [aux_sym_fragment_repeat1] = aux_sym_fragment_repeat1,
  [aux_sym_start_tag_repeat1] = aux_sym_start_tag_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LT_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_doctype_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [sym__doctype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_quoted_attribute_value_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_quoted_attribute_value_token2] = {
    .visible = true,
    .named = true,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [sym__start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__script_start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__style_start_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__end_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym_erroneous_end_tag_name] = {
    .visible = true,
    .named = true,
  },
  [sym__implicit_end_tag] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_text] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_doctype] = {
    .visible = true,
    .named = true,
  },
  [sym__node] = {
    .visible = false,
    .named = true,
  },
  [sym_element] = {
    .visible = true,
    .named = true,
  },
  [sym_script_element] = {
    .visible = true,
    .named = true,
  },
  [sym_style_element] = {
    .visible = true,
    .named = true,
  },
  [sym_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_script_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_style_start_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_self_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_erroneous_end_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_fragment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_start_tag_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(14);
      if (lookahead == '"') ADVANCE(29);
      if (lookahead == '\'') ADVANCE(26);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == '<') ADVANCE(20);
      if (lookahead == '=') ADVANCE(23);
      if (lookahead == '>') ADVANCE(18);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(29);
      if (lookahead == '\'') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (lookahead != 0 &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(30);
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 3:
      if (lookahead == '\'') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(27);
      if (lookahead != 0) ADVANCE(28);
      END_STATE();
    case 4:
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == '=') ADVANCE(23);
      if (lookahead == '>') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '<') ADVANCE(24);
      END_STATE();
    case 5:
      if (lookahead == '>') ADVANCE(21);
      END_STATE();
    case 6:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(10);
      END_STATE();
    case 7:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      END_STATE();
    case 8:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(6);
      END_STATE();
    case 9:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(7);
      END_STATE();
    case 10:
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(11);
      END_STATE();
    case 11:
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(9);
      END_STATE();
    case 12:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(16);
      if (lookahead != 0 &&
          lookahead != '>') ADVANCE(17);
      END_STATE();
    case 13:
      if (eof) ADVANCE(14);
      if (lookahead == '<') ADVANCE(20);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(32);
      if (lookahead != 0 &&
          lookahead != '>') ADVANCE(33);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_LT_BANG);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(aux_sym_doctype_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(16);
      if (lookahead != 0 &&
          lookahead != '>') ADVANCE(17);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(aux_sym_doctype_token1);
      if (lookahead != 0 &&
          lookahead != '>') ADVANCE(17);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym__doctype);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '/') ADVANCE(22);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_SLASH_GT);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(sym_attribute_name);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(24);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym_attribute_value);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(25);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(27);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(28);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(28);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(30);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(31);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(31);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(sym_text);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(32);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>') ADVANCE(33);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(sym_text);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>') ADVANCE(33);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 13, .external_lex_state = 2},
  [2] = {.lex_state = 13, .external_lex_state = 3},
  [3] = {.lex_state = 13, .external_lex_state = 3},
  [4] = {.lex_state = 13, .external_lex_state = 3},
  [5] = {.lex_state = 13, .external_lex_state = 3},
  [6] = {.lex_state = 13, .external_lex_state = 3},
  [7] = {.lex_state = 13, .external_lex_state = 2},
  [8] = {.lex_state = 13, .external_lex_state = 2},
  [9] = {.lex_state = 4, .external_lex_state = 4},
  [10] = {.lex_state = 13, .external_lex_state = 2},
  [11] = {.lex_state = 13, .external_lex_state = 2},
  [12] = {.lex_state = 13, .external_lex_state = 3},
  [13] = {.lex_state = 13, .external_lex_state = 3},
  [14] = {.lex_state = 13, .external_lex_state = 3},
  [15] = {.lex_state = 4, .external_lex_state = 4},
  [16] = {.lex_state = 13, .external_lex_state = 3},
  [17] = {.lex_state = 13, .external_lex_state = 2},
  [18] = {.lex_state = 13, .external_lex_state = 3},
  [19] = {.lex_state = 13, .external_lex_state = 3},
  [20] = {.lex_state = 13, .external_lex_state = 3},
  [21] = {.lex_state = 13, .external_lex_state = 2},
  [22] = {.lex_state = 13, .external_lex_state = 3},
  [23] = {.lex_state = 13, .external_lex_state = 2},
  [24] = {.lex_state = 13, .external_lex_state = 2},
  [25] = {.lex_state = 13, .external_lex_state = 3},
  [26] = {.lex_state = 13, .external_lex_state = 3},
  [27] = {.lex_state = 13, .external_lex_state = 2},
  [28] = {.lex_state = 4, .external_lex_state = 4},
  [29] = {.lex_state = 4, .external_lex_state = 4},
  [30] = {.lex_state = 13, .external_lex_state = 3},
  [31] = {.lex_state = 13, .external_lex_state = 2},
  [32] = {.lex_state = 4, .external_lex_state = 4},
  [33] = {.lex_state = 13, .external_lex_state = 3},
  [34] = {.lex_state = 13, .external_lex_state = 2},
  [35] = {.lex_state = 13, .external_lex_state = 3},
  [36] = {.lex_state = 13, .external_lex_state = 2},
  [37] = {.lex_state = 13, .external_lex_state = 3},
  [38] = {.lex_state = 13, .external_lex_state = 2},
  [39] = {.lex_state = 13, .external_lex_state = 2},
  [40] = {.lex_state = 1, .external_lex_state = 2},
  [41] = {.lex_state = 4, .external_lex_state = 2},
  [42] = {.lex_state = 4, .external_lex_state = 2},
  [43] = {.lex_state = 4, .external_lex_state = 4},
  [44] = {.lex_state = 1, .external_lex_state = 2},
  [45] = {.lex_state = 4, .external_lex_state = 2},
  [46] = {.lex_state = 4, .external_lex_state = 2},
  [47] = {.lex_state = 4, .external_lex_state = 2},
  [48] = {.lex_state = 4, .external_lex_state = 4},
  [49] = {.lex_state = 4, .external_lex_state = 2},
  [50] = {.lex_state = 4, .external_lex_state = 4},
  [51] = {.lex_state = 0, .external_lex_state = 5},
  [52] = {.lex_state = 0, .external_lex_state = 5},
  [53] = {.lex_state = 4, .external_lex_state = 4},
  [54] = {.lex_state = 0, .external_lex_state = 6},
  [55] = {.lex_state = 0, .external_lex_state = 6},
  [56] = {.lex_state = 0, .external_lex_state = 6},
  [57] = {.lex_state = 0, .external_lex_state = 6},
  [58] = {.lex_state = 4, .external_lex_state = 2},
  [59] = {.lex_state = 0, .external_lex_state = 6},
  [60] = {.lex_state = 0, .external_lex_state = 6},
  [61] = {.lex_state = 0, .external_lex_state = 6},
  [62] = {.lex_state = 0, .external_lex_state = 7},
  [63] = {.lex_state = 0, .external_lex_state = 2},
  [64] = {.lex_state = 2, .external_lex_state = 2},
  [65] = {.lex_state = 0, .external_lex_state = 2},
  [66] = {.lex_state = 0, .external_lex_state = 7},
  [67] = {.lex_state = 3, .external_lex_state = 2},
  [68] = {.lex_state = 0, .external_lex_state = 2},
  [69] = {.lex_state = 4, .external_lex_state = 2},
  [70] = {.lex_state = 4, .external_lex_state = 2},
  [71] = {.lex_state = 2, .external_lex_state = 2},
  [72] = {.lex_state = 0, .external_lex_state = 2},
  [73] = {.lex_state = 0, .external_lex_state = 6},
  [74] = {.lex_state = 3, .external_lex_state = 2},
  [75] = {.lex_state = 0, .external_lex_state = 2},
  [76] = {.lex_state = 0, .external_lex_state = 2},
  [77] = {.lex_state = 0, .external_lex_state = 2},
  [78] = {.lex_state = 0, .external_lex_state = 2},
  [79] = {.lex_state = 12, .external_lex_state = 2},
  [80] = {.lex_state = 0, .external_lex_state = 2},
  [81] = {.lex_state = 0, .external_lex_state = 8},
  [82] = {.lex_state = 0, .external_lex_state = 2},
  [83] = {.lex_state = 0, .external_lex_state = 2},
  [84] = {.lex_state = 0, .external_lex_state = 2},
  [85] = {.lex_state = 0, .external_lex_state = 9},
  [86] = {.lex_state = 0, .external_lex_state = 2},
  [87] = {.lex_state = 0, .external_lex_state = 2},
  [88] = {.lex_state = 0, .external_lex_state = 2},
  [89] = {.lex_state = 0, .external_lex_state = 8},
  [90] = {.lex_state = 12, .external_lex_state = 2},
  [91] = {.lex_state = 0, .external_lex_state = 2},
  [92] = {.lex_state = 0, .external_lex_state = 9},
  [93] = {.lex_state = 0, .external_lex_state = 2},
};

enum {
  ts_external_token__start_tag_name = 0,
  ts_external_token__script_start_tag_name = 1,
  ts_external_token__style_start_tag_name = 2,
  ts_external_token__end_tag_name = 3,
  ts_external_token_erroneous_end_tag_name = 4,
  ts_external_token_SLASH_GT = 5,
  ts_external_token__implicit_end_tag = 6,
  ts_external_token_raw_text = 7,
  ts_external_token_comment = 8,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__start_tag_name] = sym__start_tag_name,
  [ts_external_token__script_start_tag_name] = sym__script_start_tag_name,
  [ts_external_token__style_start_tag_name] = sym__style_start_tag_name,
  [ts_external_token__end_tag_name] = sym__end_tag_name,
  [ts_external_token_erroneous_end_tag_name] = sym_erroneous_end_tag_name,
  [ts_external_token_SLASH_GT] = anon_sym_SLASH_GT,
  [ts_external_token__implicit_end_tag] = sym__implicit_end_tag,
  [ts_external_token_raw_text] = sym_raw_text,
  [ts_external_token_comment] = sym_comment,
};

static bool ts_external_scanner_states[10][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__start_tag_name] = true,
    [ts_external_token__script_start_tag_name] = true,
    [ts_external_token__style_start_tag_name] = true,
    [ts_external_token__end_tag_name] = true,
    [ts_external_token_erroneous_end_tag_name] = true,
    [ts_external_token_SLASH_GT] = true,
    [ts_external_token__implicit_end_tag] = true,
    [ts_external_token_raw_text] = true,
    [ts_external_token_comment] = true,
  },
  [2] = {
    [ts_external_token_comment] = true,
  },
  [3] = {
    [ts_external_token__implicit_end_tag] = true,
    [ts_external_token_comment] = true,
  },
  [4] = {
    [ts_external_token_SLASH_GT] = true,
    [ts_external_token_comment] = true,
  },
  [5] = {
    [ts_external_token__start_tag_name] = true,
    [ts_external_token__script_start_tag_name] = true,
    [ts_external_token__style_start_tag_name] = true,
    [ts_external_token_comment] = true,
  },
  [6] = {
    [ts_external_token_raw_text] = true,
    [ts_external_token_comment] = true,
  },
  [7] = {
    [ts_external_token__end_tag_name] = true,
    [ts_external_token_erroneous_end_tag_name] = true,
    [ts_external_token_comment] = true,
  },
  [8] = {
    [ts_external_token_erroneous_end_tag_name] = true,
    [ts_external_token_comment] = true,
  },
  [9] = {
    [ts_external_token__end_tag_name] = true,
    [ts_external_token_comment] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LT_BANG] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [sym__doctype] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_SLASH_GT] = ACTIONS(1),
    [anon_sym_LT_SLASH] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym__start_tag_name] = ACTIONS(1),
    [sym__script_start_tag_name] = ACTIONS(1),
    [sym__style_start_tag_name] = ACTIONS(1),
    [sym__end_tag_name] = ACTIONS(1),
    [sym_erroneous_end_tag_name] = ACTIONS(1),
    [sym__implicit_end_tag] = ACTIONS(1),
    [sym_raw_text] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_fragment] = STATE(77),
    [sym_doctype] = STATE(8),
    [sym__node] = STATE(8),
    [sym_element] = STATE(8),
    [sym_script_element] = STATE(8),
    [sym_style_element] = STATE(8),
    [sym_start_tag] = STATE(4),
    [sym_script_start_tag] = STATE(54),
    [sym_style_start_tag] = STATE(57),
    [sym_self_closing_tag] = STATE(11),
    [sym_erroneous_end_tag] = STATE(8),
    [aux_sym_fragment_repeat1] = STATE(8),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_LT_BANG] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(9),
    [anon_sym_LT_SLASH] = ACTIONS(11),
    [sym_text] = ACTIONS(13),
    [sym_comment] = ACTIONS(3),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LT_BANG,
    ACTIONS(17), 1,
      anon_sym_LT,
    ACTIONS(19), 1,
      anon_sym_LT_SLASH,
    ACTIONS(21), 1,
      sym_text,
    ACTIONS(23), 1,
      sym__implicit_end_tag,
    STATE(5), 1,
      sym_start_tag,
    STATE(14), 1,
      sym_self_closing_tag,
    STATE(36), 1,
      sym_end_tag,
    STATE(55), 1,
      sym_style_start_tag,
    STATE(56), 1,
      sym_script_start_tag,
    STATE(6), 7,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      aux_sym_fragment_repeat1,
  [43] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LT_BANG,
    ACTIONS(17), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      sym_text,
    ACTIONS(25), 1,
      anon_sym_LT_SLASH,
    ACTIONS(27), 1,
      sym__implicit_end_tag,
    STATE(5), 1,
      sym_start_tag,
    STATE(14), 1,
      sym_self_closing_tag,
    STATE(22), 1,
      sym_end_tag,
    STATE(55), 1,
      sym_style_start_tag,
    STATE(56), 1,
      sym_script_start_tag,
    STATE(6), 7,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      aux_sym_fragment_repeat1,
  [86] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LT_BANG,
    ACTIONS(17), 1,
      anon_sym_LT,
    ACTIONS(19), 1,
      anon_sym_LT_SLASH,
    ACTIONS(29), 1,
      sym_text,
    ACTIONS(31), 1,
      sym__implicit_end_tag,
    STATE(5), 1,
      sym_start_tag,
    STATE(14), 1,
      sym_self_closing_tag,
    STATE(17), 1,
      sym_end_tag,
    STATE(55), 1,
      sym_style_start_tag,
    STATE(56), 1,
      sym_script_start_tag,
    STATE(2), 7,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      aux_sym_fragment_repeat1,
  [129] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LT_BANG,
    ACTIONS(17), 1,
      anon_sym_LT,
    ACTIONS(25), 1,
      anon_sym_LT_SLASH,
    ACTIONS(33), 1,
      sym_text,
    ACTIONS(35), 1,
      sym__implicit_end_tag,
    STATE(5), 1,
      sym_start_tag,
    STATE(12), 1,
      sym_end_tag,
    STATE(14), 1,
      sym_self_closing_tag,
    STATE(55), 1,
      sym_style_start_tag,
    STATE(56), 1,
      sym_script_start_tag,
    STATE(3), 7,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      aux_sym_fragment_repeat1,
  [172] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_LT_BANG,
    ACTIONS(40), 1,
      anon_sym_LT,
    ACTIONS(43), 1,
      anon_sym_LT_SLASH,
    ACTIONS(46), 1,
      sym_text,
    ACTIONS(49), 1,
      sym__implicit_end_tag,
    STATE(5), 1,
      sym_start_tag,
    STATE(14), 1,
      sym_self_closing_tag,
    STATE(55), 1,
      sym_style_start_tag,
    STATE(56), 1,
      sym_script_start_tag,
    STATE(6), 7,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      aux_sym_fragment_repeat1,
  [212] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(49), 1,
      ts_builtin_sym_end,
    ACTIONS(51), 1,
      anon_sym_LT_BANG,
    ACTIONS(54), 1,
      anon_sym_LT,
    ACTIONS(57), 1,
      anon_sym_LT_SLASH,
    ACTIONS(60), 1,
      sym_text,
    STATE(4), 1,
      sym_start_tag,
    STATE(11), 1,
      sym_self_closing_tag,
    STATE(54), 1,
      sym_script_start_tag,
    STATE(57), 1,
      sym_style_start_tag,
    STATE(7), 7,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      aux_sym_fragment_repeat1,
  [252] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LT_BANG,
    ACTIONS(9), 1,
      anon_sym_LT,
    ACTIONS(11), 1,
      anon_sym_LT_SLASH,
    ACTIONS(63), 1,
      ts_builtin_sym_end,
    ACTIONS(65), 1,
      sym_text,
    STATE(4), 1,
      sym_start_tag,
    STATE(11), 1,
      sym_self_closing_tag,
    STATE(54), 1,
      sym_script_start_tag,
    STATE(57), 1,
      sym_style_start_tag,
    STATE(7), 7,
      sym_doctype,
      sym__node,
      sym_element,
      sym_script_element,
      sym_style_element,
      sym_erroneous_end_tag,
      aux_sym_fragment_repeat1,
  [292] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 1,
      anon_sym_GT,
    ACTIONS(69), 1,
      anon_sym_SLASH_GT,
    ACTIONS(71), 1,
      sym_attribute_name,
    STATE(29), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [309] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 2,
      ts_builtin_sym_end,
      sym_text,
    ACTIONS(75), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [322] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 2,
      ts_builtin_sym_end,
      sym_text,
    ACTIONS(79), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [335] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(81), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [348] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(85), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [361] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(79), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [374] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(71), 1,
      sym_attribute_name,
    ACTIONS(89), 1,
      anon_sym_GT,
    ACTIONS(91), 1,
      anon_sym_SLASH_GT,
    STATE(28), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [391] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(93), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [404] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 2,
      ts_builtin_sym_end,
      sym_text,
    ACTIONS(81), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [417] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(97), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [430] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(101), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [443] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(75), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [456] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 2,
      ts_builtin_sym_end,
      sym_text,
    ACTIONS(85), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [469] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(105), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [482] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 2,
      ts_builtin_sym_end,
      sym_text,
    ACTIONS(111), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [495] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 2,
      ts_builtin_sym_end,
      sym_text,
    ACTIONS(115), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [508] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(117), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [521] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(123), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(121), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [534] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 2,
      ts_builtin_sym_end,
      sym_text,
    ACTIONS(127), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [547] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(131), 1,
      sym_attribute_name,
    ACTIONS(129), 2,
      anon_sym_GT,
      anon_sym_SLASH_GT,
    STATE(28), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [562] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(71), 1,
      sym_attribute_name,
    ACTIONS(89), 1,
      anon_sym_GT,
    ACTIONS(134), 1,
      anon_sym_SLASH_GT,
    STATE(28), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [579] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(127), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [592] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 2,
      ts_builtin_sym_end,
      sym_text,
    ACTIONS(93), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [605] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 1,
      anon_sym_GT,
    ACTIONS(71), 1,
      sym_attribute_name,
    ACTIONS(136), 1,
      anon_sym_SLASH_GT,
    STATE(15), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [622] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(140), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(138), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [635] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 2,
      ts_builtin_sym_end,
      sym_text,
    ACTIONS(117), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [648] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(111), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [661] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 2,
      ts_builtin_sym_end,
      sym_text,
    ACTIONS(105), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(113), 2,
      sym__implicit_end_tag,
      sym_text,
    ACTIONS(115), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [687] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 2,
      ts_builtin_sym_end,
      sym_text,
    ACTIONS(101), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [700] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 2,
      ts_builtin_sym_end,
      sym_text,
    ACTIONS(97), 3,
      anon_sym_LT_BANG,
      anon_sym_LT,
      anon_sym_LT_SLASH,
  [713] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(142), 1,
      sym_attribute_value,
    ACTIONS(144), 1,
      anon_sym_SQUOTE,
    ACTIONS(146), 1,
      anon_sym_DQUOTE,
    STATE(48), 1,
      sym_quoted_attribute_value,
  [729] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(148), 1,
      anon_sym_GT,
    ACTIONS(150), 1,
      sym_attribute_name,
    STATE(47), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [743] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(150), 1,
      sym_attribute_name,
    ACTIONS(152), 1,
      anon_sym_GT,
    STATE(47), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(156), 1,
      anon_sym_EQ,
    ACTIONS(154), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
  [769] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      sym_attribute_value,
    ACTIONS(160), 1,
      anon_sym_SQUOTE,
    ACTIONS(162), 1,
      anon_sym_DQUOTE,
    STATE(69), 1,
      sym_quoted_attribute_value,
  [785] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(150), 1,
      sym_attribute_name,
    ACTIONS(164), 1,
      anon_sym_GT,
    STATE(41), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [799] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(150), 1,
      sym_attribute_name,
    ACTIONS(166), 1,
      anon_sym_GT,
    STATE(42), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [813] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(129), 1,
      anon_sym_GT,
    ACTIONS(168), 1,
      sym_attribute_name,
    STATE(47), 2,
      sym_attribute,
      aux_sym_start_tag_repeat1,
  [827] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
  [836] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(173), 1,
      anon_sym_EQ,
    ACTIONS(154), 2,
      anon_sym_GT,
      sym_attribute_name,
  [847] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
  [856] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(177), 1,
      sym__start_tag_name,
    ACTIONS(179), 1,
      sym__script_start_tag_name,
    ACTIONS(181), 1,
      sym__style_start_tag_name,
  [869] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      sym__script_start_tag_name,
    ACTIONS(181), 1,
      sym__style_start_tag_name,
    ACTIONS(183), 1,
      sym__start_tag_name,
  [882] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(185), 3,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym_attribute_name,
  [891] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      anon_sym_LT_SLASH,
    ACTIONS(189), 1,
      sym_raw_text,
    STATE(21), 1,
      sym_end_tag,
  [904] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 1,
      anon_sym_LT_SLASH,
    ACTIONS(193), 1,
      sym_raw_text,
    STATE(35), 1,
      sym_end_tag,
  [917] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 1,
      anon_sym_LT_SLASH,
    ACTIONS(195), 1,
      sym_raw_text,
    STATE(13), 1,
      sym_end_tag,
  [930] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      anon_sym_LT_SLASH,
    ACTIONS(197), 1,
      sym_raw_text,
    STATE(23), 1,
      sym_end_tag,
  [943] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(185), 2,
      anon_sym_GT,
      sym_attribute_name,
  [951] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(199), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [959] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(201), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [967] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(203), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [975] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 1,
      sym__end_tag_name,
    ACTIONS(207), 1,
      sym_erroneous_end_tag_name,
  [985] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      anon_sym_LT_SLASH,
    STATE(38), 1,
      sym_end_tag,
  [995] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(209), 1,
      anon_sym_DQUOTE,
    ACTIONS(211), 1,
      aux_sym_quoted_attribute_value_token2,
  [1005] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 1,
      anon_sym_LT_SLASH,
    STATE(10), 1,
      sym_end_tag,
  [1015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(207), 1,
      sym_erroneous_end_tag_name,
    ACTIONS(213), 1,
      sym__end_tag_name,
  [1025] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(209), 1,
      anon_sym_SQUOTE,
    ACTIONS(215), 1,
      aux_sym_quoted_attribute_value_token1,
  [1035] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 1,
      anon_sym_LT_SLASH,
    STATE(19), 1,
      sym_end_tag,
  [1045] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 2,
      anon_sym_GT,
      sym_attribute_name,
  [1053] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 2,
      anon_sym_GT,
      sym_attribute_name,
  [1061] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_DQUOTE,
    ACTIONS(219), 1,
      aux_sym_quoted_attribute_value_token2,
  [1071] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 1,
      anon_sym_LT_SLASH,
    STATE(20), 1,
      sym_end_tag,
  [1081] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_raw_text,
      anon_sym_LT_SLASH,
  [1089] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_SQUOTE,
    ACTIONS(223), 1,
      aux_sym_quoted_attribute_value_token1,
  [1099] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 1,
      sym__doctype,
  [1106] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_GT,
  [1113] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(229), 1,
      ts_builtin_sym_end,
  [1120] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_SQUOTE,
  [1127] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(233), 1,
      aux_sym_doctype_token1,
  [1134] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(235), 1,
      anon_sym_GT,
  [1141] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(237), 1,
      sym_erroneous_end_tag_name,
  [1148] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_GT,
  [1155] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 1,
      anon_sym_GT,
  [1162] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(243), 1,
      anon_sym_GT,
  [1169] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 1,
      sym__end_tag_name,
  [1176] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(245), 1,
      anon_sym_SQUOTE,
  [1183] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(245), 1,
      anon_sym_DQUOTE,
  [1190] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_DQUOTE,
  [1197] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(207), 1,
      sym_erroneous_end_tag_name,
  [1204] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(247), 1,
      aux_sym_doctype_token1,
  [1211] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_GT,
  [1218] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 1,
      sym__end_tag_name,
  [1225] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      sym__doctype,
};

static uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 43,
  [SMALL_STATE(4)] = 86,
  [SMALL_STATE(5)] = 129,
  [SMALL_STATE(6)] = 172,
  [SMALL_STATE(7)] = 212,
  [SMALL_STATE(8)] = 252,
  [SMALL_STATE(9)] = 292,
  [SMALL_STATE(10)] = 309,
  [SMALL_STATE(11)] = 322,
  [SMALL_STATE(12)] = 335,
  [SMALL_STATE(13)] = 348,
  [SMALL_STATE(14)] = 361,
  [SMALL_STATE(15)] = 374,
  [SMALL_STATE(16)] = 391,
  [SMALL_STATE(17)] = 404,
  [SMALL_STATE(18)] = 417,
  [SMALL_STATE(19)] = 430,
  [SMALL_STATE(20)] = 443,
  [SMALL_STATE(21)] = 456,
  [SMALL_STATE(22)] = 469,
  [SMALL_STATE(23)] = 482,
  [SMALL_STATE(24)] = 495,
  [SMALL_STATE(25)] = 508,
  [SMALL_STATE(26)] = 521,
  [SMALL_STATE(27)] = 534,
  [SMALL_STATE(28)] = 547,
  [SMALL_STATE(29)] = 562,
  [SMALL_STATE(30)] = 579,
  [SMALL_STATE(31)] = 592,
  [SMALL_STATE(32)] = 605,
  [SMALL_STATE(33)] = 622,
  [SMALL_STATE(34)] = 635,
  [SMALL_STATE(35)] = 648,
  [SMALL_STATE(36)] = 661,
  [SMALL_STATE(37)] = 674,
  [SMALL_STATE(38)] = 687,
  [SMALL_STATE(39)] = 700,
  [SMALL_STATE(40)] = 713,
  [SMALL_STATE(41)] = 729,
  [SMALL_STATE(42)] = 743,
  [SMALL_STATE(43)] = 757,
  [SMALL_STATE(44)] = 769,
  [SMALL_STATE(45)] = 785,
  [SMALL_STATE(46)] = 799,
  [SMALL_STATE(47)] = 813,
  [SMALL_STATE(48)] = 827,
  [SMALL_STATE(49)] = 836,
  [SMALL_STATE(50)] = 847,
  [SMALL_STATE(51)] = 856,
  [SMALL_STATE(52)] = 869,
  [SMALL_STATE(53)] = 882,
  [SMALL_STATE(54)] = 891,
  [SMALL_STATE(55)] = 904,
  [SMALL_STATE(56)] = 917,
  [SMALL_STATE(57)] = 930,
  [SMALL_STATE(58)] = 943,
  [SMALL_STATE(59)] = 951,
  [SMALL_STATE(60)] = 959,
  [SMALL_STATE(61)] = 967,
  [SMALL_STATE(62)] = 975,
  [SMALL_STATE(63)] = 985,
  [SMALL_STATE(64)] = 995,
  [SMALL_STATE(65)] = 1005,
  [SMALL_STATE(66)] = 1015,
  [SMALL_STATE(67)] = 1025,
  [SMALL_STATE(68)] = 1035,
  [SMALL_STATE(69)] = 1045,
  [SMALL_STATE(70)] = 1053,
  [SMALL_STATE(71)] = 1061,
  [SMALL_STATE(72)] = 1071,
  [SMALL_STATE(73)] = 1081,
  [SMALL_STATE(74)] = 1089,
  [SMALL_STATE(75)] = 1099,
  [SMALL_STATE(76)] = 1106,
  [SMALL_STATE(77)] = 1113,
  [SMALL_STATE(78)] = 1120,
  [SMALL_STATE(79)] = 1127,
  [SMALL_STATE(80)] = 1134,
  [SMALL_STATE(81)] = 1141,
  [SMALL_STATE(82)] = 1148,
  [SMALL_STATE(83)] = 1155,
  [SMALL_STATE(84)] = 1162,
  [SMALL_STATE(85)] = 1169,
  [SMALL_STATE(86)] = 1176,
  [SMALL_STATE(87)] = 1183,
  [SMALL_STATE(88)] = 1190,
  [SMALL_STATE(89)] = 1197,
  [SMALL_STATE(90)] = 1204,
  [SMALL_STATE(91)] = 1211,
  [SMALL_STATE(92)] = 1218,
  [SMALL_STATE(93)] = 1225,
};

static TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fragment, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [37] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(93),
  [40] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(51),
  [43] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(89),
  [46] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(6),
  [49] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_fragment_repeat1, 2),
  [51] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(75),
  [54] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(52),
  [57] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(81),
  [60] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_fragment_repeat1, 2), SHIFT_REPEAT(7),
  [63] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fragment, 1),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [73] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_element, 3),
  [75] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_script_element, 3),
  [77] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 1),
  [79] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 1),
  [81] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 2),
  [83] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 2),
  [85] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_script_element, 2),
  [87] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_element, 2),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [93] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_self_closing_tag, 4),
  [95] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_self_closing_tag, 4),
  [97] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doctype, 4),
  [99] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctype, 4),
  [101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_element, 3),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_element, 3),
  [105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element, 3),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element, 3),
  [109] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_element, 2),
  [111] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_style_element, 2),
  [113] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_end_tag, 3),
  [115] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_end_tag, 3),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_erroneous_end_tag, 3),
  [119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_erroneous_end_tag, 3),
  [121] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_start_tag, 3),
  [123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_start_tag, 3),
  [125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_self_closing_tag, 3),
  [127] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_self_closing_tag, 3),
  [129] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2),
  [131] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(43),
  [134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [138] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_start_tag, 4),
  [140] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_start_tag, 4),
  [142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [154] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1),
  [156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [168] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_start_tag_repeat1, 2), SHIFT_REPEAT(49),
  [171] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 3),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [175] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_attribute_value, 2),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_attribute_value, 3),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [199] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_start_tag, 4),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_start_tag, 3),
  [203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_script_start_tag, 3),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [209] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [217] = {.entry = {.count = 1, .reusable = false}}, SHIFT(50),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_style_start_tag, 4),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [229] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_html_external_scanner_create(void);
void tree_sitter_html_external_scanner_destroy(void *);
bool tree_sitter_html_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_html_external_scanner_serialize(void *, char *);
void tree_sitter_html_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_html(void) {
  static TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = (const uint16_t *)ts_parse_table,
    .small_parse_table = (const uint16_t *)ts_small_parse_table,
    .small_parse_table_map = (const uint32_t *)ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = (const TSSymbol *)ts_alias_sequences,
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      (const bool *)ts_external_scanner_states,
      ts_external_scanner_symbol_map,
      tree_sitter_html_external_scanner_create,
      tree_sitter_html_external_scanner_destroy,
      tree_sitter_html_external_scanner_scan,
      tree_sitter_html_external_scanner_serialize,
      tree_sitter_html_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
