/**
 * @file compile_uri_format_main.cc
 *
 * @section LICENSE
 *
 * The MIT License
 *
 * @copyright Copyright (c) 2022-2023 TileDB, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "../generate_uri.h"
#include "../parse_uri.h"

using namespace tiledb::storage_format;
using namespace tiledb::sm::utils::parse;

int main() {
  (void)generate_timestamped_name(1, 2, 1);
  (void)generate_timestamped_name(1, 1);
  (void)generate_consolidated_fragment_name(
      tiledb::sm::URI{}, tiledb::sm::URI{}, 1);

  std::pair<uint64_t, uint64_t> x;
  (void)get_timestamp_range(tiledb::sm::URI{}, &x);
  (void)get_fragment_version("");
  (void)is_element_of(tiledb::sm::URI{}, tiledb::sm::URI{});

  return 0;
}
