/*
  Copyright © 2014 Jesse 'Jeaye' Wilkerson
  See licensing in LICENSE file, or at:
    http://www.opensource.org/licenses/MIT

  File: groff_section.hpp
  Author: Jesse 'Jeaye' Wilkerson
*/

#pragma once

namespace groff_detail
{
  extern std::vector<std::string> sections;

  void section(std::vector<std::string> &lines)
  {
    /* The amount of characters allowed after a section name. */
    static constexpr const size_t leniency{ 2 };
    for(auto &l : lines)
    {
      std::string tmp{ l };
      str::trim(tmp);
      std::string::size_type found{ std::string::npos };

      auto const is_section(std::find_if(sections.begin(), sections.end(),
      [&](std::string const &s)
      {
        found = tmp.find(s);
        return (found != std::string::npos) && (tmp.size() - s.size()) < leniency;
      }));

      if(is_section != sections.end() && found == 0)
      { l = ".SH " + str::ltrim(l); }
    }
  }

  /* No, I did not type this by hand. In fact, for future reference:
     grep -r "<span class=\"toctext\">" | sed 's/^.*<span class\=\"toctext\">//' | \
     sed 's/<\/span>.*$//' | grep -v "<span>" | sort -u
   */
  std::vector<std::string> sections
  {
    "3D Graphics",
    "Abstraction",
    "Acquire operation",
    "Adaptors",
    "Additional basic types and macros",
    "Additional support",
    "Additive operators",
    "Algorithm",
    "Algorithms",
    "Algorithms library",
    "Alignment",
    "Alignment specifier",
    "Allocation",
    "Allocator non-member operations",
    "Allocators",
    "Alternative keywords",
    "Alternatives",
    "# and ## operators",
    "Arithmetic",
    "Arithmetic comparison operators",
    "Arithmetic operations",
    "Arithmetic types defined by the language",
    "Array I/O implementations",
    "Array rvalues",
    "Arrays",
    "Arrays of unknown bound",
    "Array subscript operator",
    "Array to pointer conversion",
    "Array to pointer decay",
    "Array version, unique_ptr<T[]>",
    "ASCII chart",
    "Assertions",
    "Assignment",
    "Assignment operator",
    "Associative containers",
    "Atomic Operations library",
    "Atoms",
    "Attribute list",
    "Audio",
    "Backreferences",
    "Base",
    "Base specifiers and member initializer lists",
    "Basic",
    "Basic operations",
    "Basic types",
    "Benchmarking",
    "Bernoulli distributions",
    "Best viable function",
    "Binary arithmetic operators",
    "Binary search operations (on sorted ranges)",
    "Bind",
    "Binders",
    "Binding rules",
    "Bit fields",
    "Bitset",
    "Bitwise logic operators",
    "Bitwise operations",
    "Bitwise shift operators",
    "Block scope",
    "Boolean conversions",
    "Boolean type",
    "Braced init lists",
    "Bucket interface",
    "Built-in address-of operator",
    "Built-in comma operator",
    "Builtin compound assignment",
    "Built-in conversion operator",
    "Builtin direct assignment",
    "Built-in function call operator",
    "Built-in indirection operator",
    "Built-in member access operators",
    "Builtin operators",
    "Built-in pointer-to-member access operators",
    "Built-in postfix operators",
    "Built-in prefix operators",
    "Built-in subscript operator",
    "Call once",
    "Call to a class object",
    "Call to a named function",
    "Call to an overloaded operator",
    "Candidate functions",
    "Canonical implementations",
    "Capacity",
    "Capture and storage of exception objects",
    "Carries dependency",
    "Category:", /* XXX: Manually added. */
    "Categories:",
    "Hidden category:",
    "Hidden categories:",
    "C compatibility headers",
    "C FAQs",
    "C++ FAQs",
    "Character array manipulation",
    "Character arrays",
    "Character classes",
    "Character classification",
    "Character conversions",
    "Characteristics",
    "Character manipulation",
    "Character types",
    "chrono library",
    "C Language and library references",
    "C++ Language and library references",
    "Classes",
    "Classification",
    "Classification and comparison",
    "Class scope",
    "Class-specific overloads",
    "Class template instantiation",
    "C library",
    "C library locales",
    "Clocks",
    "C numeric limits interface",
    "Comments",
    "Common mathematical functions",
    "Communicating with the environment",
    "Communication",
    "Comparison",
    "Comparisons",
    "Compatibility with C",
    "Complexity",
    "Complex numbers",
    "Composite type categories",
    "Compound statement",
    "Compression",
    "Concept requirements",
    "Concurrency",
    "Conditional execution statements",
    "Conditional operator",
    "Condition evaluation",
    "Condition variables",
    "Configuration",
    "Constants",
    "Constant static members",
    "Constness",
    "Construction",
    "Construction and Seeding",
    "const T* specialization member types",
    "const-, volatile-, and ref-qualified member functions",
    "Const-volatility specifiers",
    "Consume operation",
    "Container",
    "Container adaptors",
    "Container data races",
    "Container element",
    "Containers",
    "Containers library",
    "Contents", /* XXX: Manually added. */
    "Convenience Typedefs",
    "Conversions",
    "Conversions to numeric formats",
    "Copy and swap",
    "Copy-initialization by conversion",
    "Core constant expressions",
    "Covariant return types",
    "C random library",
    "Cryptography",
    "C-style",
    "C++-style",
    "C-style date and time library",
    "C-style IO",
    "C-style memory management",
    "Current instantiation",
    "Dangling references",
    "Databases",
    "Data models",
    "Date and time",
    "Declarations",
    "Declaration statement",
    "Declarators",
    "Default conversions",
    "Default template arguments",
    "#define directives",
    "Definitions",
    "Delegating constructor",
    "Deleted implicitly-declared copy assignment operator",
    "Deleted implicitly-declared copy constructor",
    "Deleted implicitly-declared copy destructor",
    "Deleted implicitly-declared default constructor",
    "Deleted implicitly-declared move assignment operator",
    "Deleted implicitly-declared move constructor",
    "Dependency-ordered before",
    "Dependent types",
    "Deprecated headers",
    "Deprecated in C++11",
    "Deprecated member types",
    "Deprecates",
    "Description",
    "Destruction sequence",
    "Details",
    "Digraphs and trigraphs",
    "Direct input/output",
    "Duration",
    "During construction and destruction",
    "Dynamic exception specifications",
    "Dynamic memory management",
    "Dynamic type",
    "Early C++",
    "Element access",
    "Embedded languages bindings",
    "Embedded/realtime",
    "Enumeration scope",
    "Error and gamma functions",
    "Error category interface",
    "Error Conditions",
    "Error handling",
    "Error numbers",
    "Escape sequences",
    "Evaluations",
    "Example",
    "Example 1",
    "Example 1: non-member functions",
    "Example 2",
    "Example 3",
    "Examples",
    "Example With Comparator",
    "Exception categories",
    "Exception handling",
    "Exception objects",
    "Exceptions",
    "Exception safety",
    "Execution",
    "Exeptions",
    "Expanded value",
    "Expansion loci",
    "Explanation",
    "Explicit instantiation",
    "Explicit specializations of function templates",
    "Exponential functinos",
    "Exponential functions",
    "Expressions",
    "Expression statements",
    "External links",
    "Facet categories",
    "Facet category base classes",
    "File access",
    "File I/0 implementation",
    "File metadata",
    "File operations",
    "File positioning",
    "Files",
    "First version",
    "Floating - integral conversions",
    "Floating point conversions",
    "Floating-point environment",
    "Floating point manipulation functions",
    "Floating point promotion",
    "Floating point types",
    "Flow control",
    "footnotes",
    "Formal description",
    "Format",
    "Format conversions",
    "Format macro constants",
    "Formatted input",
    "Formatted input/output",
    "Formatted output",
    "Formatting",
    "Forward declaration",
    "Forward declarations",
    "Function adaptors",
    "Function argument lists",
    "Function call operator",
    "Function declaration",
    "Function-like macros",
    "Function objects",
    "Function Objects",
    "Function parameter list",
    "Function prototype scope",
    "Functions",
    "Function scope",
    "Functions managing the current thread",
    "Function template instantiation",
    "Function template specialization",
    "Function to pointer",
    "Fundamental types defined by the language",
    "Future development",
    "Future errors",
    "Futures",
    "Garbage collector support",
    "General",
    "General-purpose utilities",
    "General topics",
    "Generation",
    "Generic",
    "Generic locking algorithms",
    "Generic mutex management",
    "Generic numeric operations",
    "Get area",
    "Getting the result",
    "Global objects",
    "Global replacements",
    "glvalue",
    "GPS",
    "Graphics",
    "Graphic user interface",
    "Gtk+ widgets",
    "Handling of exception specification violations",
    "Handling of failures in exception handling",
    "Happens-before",
    "Hashing",
    "Hash policy",
    "Hash support",
    "Heap operations",
    "Helper classes",
    "Helper Classes",
    "Helper types",
    "History of C",
    "Hyperbolic functions",
    "#ifdef, #ifndef",
    "#if, #elif",
    "Implementation notes",
    "Implicit instantiation",
    "Implicitly-declared copy assignment operator",
    "Implicitly-declared copy constructor",
    "Implicitly-declared default constructor",
    "Implicitly-declared destructor",
    "Implicitly-declared move assignment operator",
    "Implicitly-declared move constructor",
    "Implicitly-defined copy assignment operator",
    "Implicitly-defined copy constructor",
    "Implicitly-defined destructor",
    "Implicitly-defined member functions",
    "Implicitly-defined move assignment operator",
    "Implicitly-defined move constructor",
    "In class definition",
    "Includes",
    "Incomplete type",
    "Increment and decrement",
    "In detail",
    "Initialization by constructor",
    "Initialization order",
    "Initializer lists",
    "inline Example",
    "Inline namespaces",
    "In namespace and block scope",
    "Input/output",
    "Input/Output",
    "Input/output library",
    "Integer types",
    "Integral conversions",
    "Integral promotion",
    "Internal extensible array",
    "Internationalization",
    "International monetary numeric formatting parameters",
    "Interprocess",
    "Inter-thread happens-before",
    "I/O Manipulators",
    "Iteration statements",
    "Iterator",
    "Iterator adaptors",
    "Iterator categories",
    "Iterator operations",
    "Iterator primitives",
    "Iterators",
    "Iterators library",
    "Iterator tags",
    "Javascript",
    "JSON",
    "Jump statements",
    "Keywords",
    "Labels",
    "Lambda captures",
    "Language support",
    "Layout",
    "Legend",
    "libc",
    "Library-wide",
    "Lifetime of a temporary",
    "Linkage",
    "List-initialization",
    "Literals",
    "Locale",
    "Locale-independent unicode conversion facets",
    "Locales",
    "Locales and facets",
    "Locale-specific facet categories",
    "Localization library",
    "Local monetary numeric formatting parameters",
    "Locking",
    "Logical operations",
    "Lookup",
    "Lookup rules",
    "Low level memory management",
    "lvalue",
    "Lvalue references",
    "Lvalue to rvalue conversion",
    "Lvalue transformations",
    "Macro constants",
    "Macros",
    "Main classes",
    "Manipulation",
    "Manipulators",
    "Matching",
    "Math",
    "Maths",
    "Member access",
    "Member accessibility by specifier",
    "Member alias templates",
    "Member classes",
    "Member constants",
    "Member function",
    "Member function operator()",
    "Member functions",
    "Member function table",
    "Member initialization",
    "Member name lookup",
    "Member objects",
    "Members of partial specializations",
    "Members of specializations",
    "Member type result_type",
    "Member types",
    "Member types and constants",
    "Memory allocation",
    "Memory leaks",
    "Memory management",
    "Methods",
    "Methods and operators",
    "Might be also useful",
    "Minimum/maximum operations",
    "Miscellaneous",
    "Miscellaneous algorithms and math",
    "Miscellaneous transformations",
    "Mixed categories",
    "Modification order",
    "Modifiers",
    "Modifying sequence operations",
    "Monetary numeric formatting parameters",
    "Multibyte/wide character conversion",
    "Multidimensional arrays",
    "Multiplicative operators",
    "Mutual exclusion",
    "Name lookup",
    "Namespaces",
    "Namespace scope",
    "Narrowing conversions",
    "Native handle",
    "Nearest integer floating point operations",
    "Negators",
    "Non-class initialization by conversion",
    "Non-deterministic random numbers",
    "Non-local jumps",
    "Non-member function definitions",
    "Non-member functions",
    "Non-member operations",
    "Non-member operators",
    "Non-modifying sequence operations",
    "Non-monetary numeric formatting parameters",
    "Non-static data members",
    "Non-type template parameter",
    "Non-type template parameters",
    "_Noreturn Example",
    "Normal distributions",
    "Note",
    "Notes",
    "Notification",
    "Null pointers",
    "Null-terminated strings",
    "Numeric arrays",
    "Numeric conversions",
    "numeric_limits",
    "Numeric limits",
    "Numeric operations",
    "Numeric promotions",
    "Numerics library",
    "Numeric string conversion",
    "Object-like macros",
    "Object representation and value representation",
    "Objects",
    "Observers",
    "Operating system",
    "Operations",
    "Operations on files",
    "Operators",
    "Optional Operations",
    "Ordering",
    "Order of the conversions",
    "Other",
    "Other concepts",
    "Output:", /* XXX: Manually added. */
    "Overflows",
    "Overloaded operators",
    "Overload resolution",
    "overloads for arithmetic types",
    "overloads for iterator types",
    "Pack expansion",
    "Pairs and tuples",
    "Parameter list",
    "Parameters",
    "Partitioning operations",
    "Pending member function call",
    "Phase 1",
    "Phase 2",
    "Phase 3",
    "Phase 4",
    "Phase 5",
    "Phase 6",
    "Phase 7",
    "Phase 8",
    "Phase 9",
    "Pointer categories",
    "Pointer comparison operators",
    "Pointer conversions",
    "Pointers",
    "Pointers to data members",
    "Pointers to functions",
    "Pointers to member functions",
    "Pointers to objects",
    "Pointers to void",
    "Pointer-to-member conversions",
    "Point of declaration",
    "Poisson distributions",
    "Polymorphic function wrappers",
    "Polymorphic objects",
    "Positioning",
    "POSIX-based character classes",
    "Possible implementation",
    "Possible output:", /* XXX: Manually added. */
    "Postconditions",
    "Power functions",
    "Precondition",
    "Preconditions",
    "Predefined generators",
    "Predefined macros",
    "Predefined random number generators",
    "Preprocessor",
    "Preprocessor macros",
    "Primary categories",
    "Primary expressions",
    "Primary type categories",
    "Primitives",
    "Private inheritance",
    "Private member access",
    "Process control",
    "Program termination",
    "Program utilities",
    "Properties",
    "Property queries",
    "Protected inheritance",
    "Protected member access",
    "Protected member functions",
    "Protected member objects",
    "Pseudo-random number generation",
    "Public inheritance",
    "Public member access",
    "Public member functions",
    "Pure virtual destructors",
    "Put area",
    "Putback",
    "Qualification conversions",
    "Qualified name lookup",
    "Quantifiers",
    "Random number distributions",
    "Random number engine adaptors",
    "Random number engines",
    "Random Number Generation",
    "Range",
    "Range access",
    "Range of values",
    "Ranking of implicit conversion sequences",
    "Reference initialization by conversion",
    "References",
    "Reference wrappers",
    "Regular Expressions library",
    "Related standards",
    "Relational operators",
    "Relationship with C library macro constants",
    "Relationship with the main function",
    "Relationship with volatile",
    "Relaxed ordering",
    "Release-Acquire ordering",
    "Release-Consume ordering",
    "Release operation",
    "Release sequence",
    "Requirements",
    "Restrictions",
    "Results",
    "Return value",
    "Rules",
    "Runtime type identification",
    "rvalue",
    "Rvalue references",
    "Sampling distributions",
    "Search",
    "Second version",
    "See also",
    "See Also",
    "Selection statements",
    "Sequence containers",
    "SequenceContainers in the standard library",
    "Sequenced-before",
    "Sequentially-consistent ordering",
    "Serialization",
    "Set operations (on sorted ranges)",
    "Setting the result",
    "Shared locking",
    "Signals",
    "Signal types",
    "Signed integers : maximum value",
    "Signed integers : minimum value",
    "Sign modifiers",
    "Single character matches",
    "Single-object version, unique_ptr<T>",
    "Size",
    "Smart pointer non-member operations",
    "Smart pointers",
    "Smart pointers categories",
    "Smart pointers helper classes",
    "Sorting operations",
    "Sorting operations (on sorted ranges)",
    "Special categories",
    "Special constant expression",
    "Specializations",
    "Specialized member functions",
    "Special member functions",
    "Specifiers",
    "Stage 1: conversion specifier selection",
    "Stage 2: character extraction",
    "Stage 2: locale-specific conversion",
    "Stage 3: conversion and storage",
    "Stage 3: padding",
    "Stage 4: output",
    "Standard C++",
    "Standard layout",
    "Standard library",
    "Standard pragmas",
    "Standard specializations",
    "Standard specializations for basic types",
    "Standard specializations for library types",
    "State",
    "State functions",
    "Static data members",
    "Static member functions",
    "Static type",
    "Storage duration",
    "Stream-based I/O",
    "Stream extraction and insertion",
    "Stream insertion/extraction operators",
    "Stream I/O functions",
    "Stream iterators",
    "Stream Iterators",
    "Strict aliasing",
    "String and stream conversions",
    "String conversions",
    "String examination",
    "String I/0 implementation",
    "String manipulation",
    "String operations",
    "Strings library",
    "Sub-expressions",
    "Subobjects",
    "Supported operations",
    "Swap, forward and move",
    "Synopsis",
    "Synospis",
    "Syntax",
    "System error",
    "Target access",
    "Template argument deduction",
    "Template argument lists",
    "Template argument substitution",
    "Template friend operators",
    "Template friends",
    "Template Non-type arguments",
    "Template parameter list",
    "Template parameters",
    "Template Parameters",
    "Template parameter scope",
    "Template template arguments",
    "Template template parameter",
    "Template type arguments",
    "Terminal",
    "Terms",
    "Testing",
    "Text",
    "The argument list",
    "The badbit",
    "The eofbit",
    "The failbit",
    "The imaginary constant",
    "The safe bool problem",
    "The sizeof... operator",
    "The type of the literal",
    "The unnamed namespace",
    "Thread-local storage",
    "Threads",
    "Thread safety",
    "Thread support library",
    "Time manipulation",
    "Time point",
    "Trade-offs / usage notes",
    "Traits",
    "Trigonometric functions",
    "Trivial copy assignment operator",
    "Trivial copy constructor",
    "Trivial default constructor",
    "Trivial destructor",
    "Trivial move assignment operator",
    "Trivial move constructor",
    "Try block",
    "T* specialization member types",
    "Type",
    "Type aliasing",
    "Type classification",
    "Typedefs",
    "Typedefs and specializations",
    "Type-dependent expressions",
    "Type modifications",
    "Type naming",
    "Type properties",
    "Type relationships",
    "Type requirements",
    "Types",
    "Type support",
    "Type template parameter",
    "Unary arithmetic operators",
    "#undef directive",
    "Undefined behavior",
    "Unevaluated expressions",
    "Unformatted input",
    "Unformatted input/output",
    "Unformatted output",
    "Uniform distributions",
    "Uninitialized storage",
    "Unknown specializations",
    "Unordered associative containers",
    "Unqualified name lookup",
    "Unsigned integers : maximum value",
    "Usage",
    "Using-declarations",
    "Using-directives",
    "Utilities",
    "Utilities library",
    "Value-dependent expressions",
    "Variadic functions",
    "vector<bool> specific modifiers",
    "Viable functions",
    "Video",
    "Virtual and pure virtual functions",
    "Virtual base classes",
    "Virtual destructor",
    "Virtual destructors",
    "Visible side-effects",
    "Void expressions",
    "Waiting",
    "Web",
    "Wide character array manipulation",
    "Wide string manimpulation",
    "XML",
    "xvalue"
  };
}
