## Contributing Code

Start here: [Introduction to Stan for New Developers](https://github.com/stan-dev/stan/wiki/Introduction-to-Stan-for-New-Developers)

The instructions for contributors including the Git process, the testing process, and the Stan coding standards, see the top-level Wiki:

* [Stan Developer Process](https://github.com/stan-dev/stan/wiki)

## Stan Manual Issues

If you would like to make a suggestion for fixing a typo or unclear part of the manual, please make a comment on the currently open next manual issue (it will be numbered by current release followed by `++`) and we will fix it in the next release after the current release:

* [Next Manual Issue](https://github.com/stan-dev/stan/issues?utf8=✓&q=is%3Aopen%20label%3ABug%20%22next%20manual%22%20label%3ADocumentation)

This is easier for us than having to deal with a typo pull request, though we will gladly take those, too.

## Submitting an Issue

If you want to report a bug or request a feature, the right place to do this is on each individual project's issue tracker.  Please first search to see if the issue has already been reported, and if you need to report a new issue, click on the `New` button in the upper right corner.

If you suspect a mathematical function is returning the wrong results or want to request a new function be added to Stan:

* [Stan Math Library](https://github.com/stan-dev/math/issues)

If you suspect a problem with the Stan language, the fitting algorithms, or with I/O, or if you want to see a new feature in all of the interfaces:

* [Stan Language, Algorithms, and Services](https://github.com/stan-dev/stan/issues)

If you suspect a problem or would like to see a new feature in one of the interfaces, choose the interface:

* [CmdStan Interface](https://github.com/stan-dev/cmdstan/issues)
* [RStan](https://github.com/stan-dev/rstan/issues)
* [PyStan](https://github.com/stan-dev/pystan/issues)
* [Stan.jl](https://github.com/goedman/Stan.jl/issues)
* [StataStan](https://github.com/stan-dev/statastan/issues)
* [MathematicaStan](https://github.com/stan-dev/MathematicaStan/issues)

If you suspect a problem or would like to request a feature in one of our higher-level packages:

* [RStanArm](https://github.com/stan-dev/rstanarm/issues)
* [ShinyStan](https://github.com/stan-dev/shinystan/issues)
* [BayesPlot](https://github.com/stan-dev/bayesplot/issues)
* [Loo](https://github.com/stan-dev/loo/issues)

If you have a problem with Stan's emacs mode or would like to request a feature:

* [Stan Emacs Mode](https://github.com/stan-dev/stan-mode/issues)

If you suspect a problem or would like to see something added to the web site (http://mc-stan.org)[http://mc-stan.org]:

* [Stan Web Pages](https://github.com/stan-dev/stan-dev.github.io/issues)

