# Values In Definition

## Don't specify values in column definition:
With enum, you declare the values as strings,
but internally the column is stored as the ordinal number of the string
in the enumerated list. The storage is therefore compact, but when you
sort a query by this column, the result is ordered by the ordinal value,
not alphabetically by the string value. You may not expect this behavior.
Not all databases allow you to add or remove a value from an ENUM or check
constraint; you can only redefine the column with a new set of values.
Moreover, if you make a value obsolete, you could upset historical data.
As a matter of policy, changing metadata — that is, changing the definition
of tables and columns—should be infrequent and with attention to testing and
quality assurance. There's a better solution to restrict values in a column:
create a lookup table with one row for each value you allow.
Then declare a foreign key constraint on the old table referencing
the new table.
Use metadata when validating against a fixed set of values.
Use data when validating against a fluid set of values.
