# Entity-Attribute-Value Pattern


  ## **Dynamic schema with variable attributes:**  
  Are you trying to create a schema where you can define new attributes
  at runtime.? This involves storing attributes as rows in an attribute table.
  This is referred to as the Entity-Attribute-Value or schemaless pattern.
  When you use this pattern,  you sacrifice many advantages that a conventional
  database design would have given you. You can't make mandatory attributes.
  You can't enforce referential integrity. You might find that attributes are
  not being named consistently. A solution is to store all related types in one table,
  with distinct columns for every attribute that exists in any type
  (Single Table Inheritance). Use one attribute to define the subtype of a given row.
  Many attributes are subtype-specific, and these columns must
  be given a null value on any row storing an object for which the attribute
  does not apply the columns with non-null values become sparse.
  Another solution is to create a separate table for each subtype
  (Concrete Table Inheritance). A third solution mimics inheritance,
  as though tables were object-oriented classes (Class Table Inheritance).
  Create a single table for the base type, containing attributes common to
  all subtypes. Then for each subtype, create another table, with a primary key
  that also serves as a foreign key to the base table.
  If you have many subtypes or if you must support new attributes frequently,
  you can add a BLOB column to store data in a format such as XML or JSON,
  which encodes both the attribute names and their values.
  This design is best when you can't limit yourself to a finite set of subtypes
  and when you need complete flexibility to define new attributes at any time.