# Readable Passwords

## Do not store readable passwords:   
It's not secure to store a password in clear text or even to pass it over the
network in the clear. If an attacker can read the SQL statement you use to
insert a password, they can see the password plainly.
Additionally, interpolating the user's input string into the SQL query in plain text
exposes it to discovery by an attacker.
If you can read passwords, so can a hacker.
The solution is to encode the password using a one-way cryptographic hash 
function. This function transforms its input string into a new string,
called the hash, that is unrecognizable.
Use a salt to thwart dictionary attacks. Don't put the plain-text password
into the SQL query. Instead, compute the hash in your application code,
and use only the hash in the SQL query.