/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.springframework.boot.cli.command.Command;
import org.springframework.boot.cli.command.CommandFactory;
import org.springframework.boot.cli.command.CommandRunner;
import org.springframework.boot.cli.command.core.HelpCommand;
import org.springframework.boot.cli.command.core.HintCommand;
import org.springframework.boot.cli.command.core.VersionCommand;
import org.springframework.boot.cli.command.shell.ShellCommand;
import org.springframework.boot.loader.tools.LogbackInitializer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SpringCli {
    private SpringCli() {
    }

    public static void main(String ... args) {
        System.setProperty("java.awt.headless", Boolean.toString(true));
        LogbackInitializer.initialize();
        CommandRunner runner = new CommandRunner("spring");
        ClassUtils.overrideThreadContextClassLoader((ClassLoader)SpringCli.createExtendedClassLoader((CommandRunner)runner));
        runner.addCommand((Command)new HelpCommand(runner));
        SpringCli.addServiceLoaderCommands((CommandRunner)runner);
        runner.addCommand((Command)new ShellCommand());
        runner.addCommand((Command)new HintCommand(runner));
        runner.setOptionCommands(new Class[]{HelpCommand.class, VersionCommand.class});
        runner.setHiddenCommands(new Class[]{HintCommand.class});
        int exitCode = runner.runAndHandleErrors(args);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    private static void addServiceLoaderCommands(CommandRunner runner) {
        ServiceLoader<CommandFactory> factories = ServiceLoader.load(CommandFactory.class);
        for (CommandFactory factory : factories) {
            runner.addCommands((Iterable)factory.getCommands());
        }
    }

    private static URLClassLoader createExtendedClassLoader(CommandRunner runner) {
        return new URLClassLoader(SpringCli.getExtensionURLs(), runner.getClass().getClassLoader());
    }

    private static URL[] getExtensionURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String home = SystemPropertyUtils.resolvePlaceholders((String)"${spring.home:${SPRING_HOME:.}}");
        File extDirectory = new File(new File(home, "lib"), "ext");
        if (extDirectory.isDirectory()) {
            File[] files = extDirectory.listFiles();
            Assert.state((files != null ? 1 : 0) != 0, (String)"'files' must not be null");
            for (File file : files) {
                if (!file.getName().endsWith(".jar")) continue;
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        return urls.toArray(new URL[0]);
    }
}

