/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef DIRECTOR_DETECTION_TABLES_H
#define DIRECTOR_DETECTION_TABLES_H

static const PlainGameDescriptor directorGames[] = {

	// Macromedia Sample Projectors
	{ "director",			"Macromedia Director Game" },
	{ "directortest",		"Macromedia Director Test Target" },
	{ "directortest-all",	"Macromedia Director All Movies Test Target" },
	{ "directorshokai",		"Macromedia Director紹介" }, // Macromedia Director Introduction
	{ "theapartment",		"The Apartment, Interactive demo" },
	{ "dirmacromedia",		"Macromedia Director" },
	{ "dirmacromind",		"MacroMind Director" },
	{ "lingoexpo",			"Director 4 Lingo Expo and Sample Titles" },

	// Commercially released games
	{ "10plus2",			"10+2" },
	{ "1stcdtoddler",		"My First CD-ROM: Toddler School" },
//	{ "3bessones",			"Les Tres Bessones: Jugar i Aprendre" }, // Catalan title, English selectable in game
	{ "abclunch",			"My Alphabet Lunch" },
	{ "abcpacovska",		"Alphabet: Play with the ABCs"},
	{ "abcpalsafety",		"Safety Scavenger Hunt" }, // Alphabet Pals
	{ "abductthis",			"Abduct This!" },
	{ "afiles",				"The A-Files" },
//	{ "agapito",			"Agapito's Crazy Adventure" },   // Not director?
	{ "alice",				"Alice: An Interactive Museum" },
	{ "alphabet",			"The Interactive Alphabet" },
	{ "amandastories",		"AmandaStories" },
	{ "amber",				"AMBER: Journeys Beyond" },
	{ "amertailmb",			"An American Tail Interactive MovieBook" },
	{ "arcade",				"Classic Arcade" },
	{ "arcadeairattack",	"Classic Arcade Air Attack" },
	{ "arcadeboing",		"Classic Arcade Boing" },
	{ "arcadehockey",		"Classic Arcade Air Hockey" },
	{ "arcadelander",		"Classic Arcade Lander" },
	{ "arcadesubs",			"Classic Arcade Subs" },
	{ "arcofdoom",			"Arc of Doom" },
	{ "artofmagic",			"Learn the Art of Magic with Jay Alexander" },
	{ "artrageous",			"ArtRageous!" },
	{ "artus1",				"Artus against the Demon of the Museum" },
	{ "atbat",				"At Bat" },
	{ "atvrally",			"ATV Rally" },
	{ "babarcoins",			"Babar and the Royal Coin Caper" },
	{ "babesintoyland",		"Babes in Toyland: An Interactive Adventure" },
	{ "backpackerjr",		"BackPacker Junior" },
	{ "badday",				"Bad Day on the Midway" },
	{ "badmilk",			"Bad Milk" },
	{ "bananasfun",			"Bananas in Pyjamas: It's Fun Time" },
	{ "bananaspack",		"Bananas in Pyjamas: Fun Pack" },
	{ "bananasparty",		"Bananas in Pyjamas: It's Party Time" },
	{ "barbnail",			"Barbie Nail Designer" },
	{ "barbpauper",			"Barbie as the Princess and the Pauper" },
	{ "barbrapunzel",		"Barbie as Rapunzel: A Creative Adventure" },
	{ "barbswanlake",		"Barbie of Swan Lake: The Enchanted Forest" },
	{ "bbbighelpers",		"Little Bears Make Big Helpers: Life's Little Lessons with the Berenstain Bears" },
	{ "bearfamily",			"A Bear Family Adventure" },
	{ "beautyorbeast",		"Beauty or the Beast" },
	{ "betterd",			"The Better Dead Ratification" },
	{ "beyondthewall",		"Beyond the Wall of Stars" },
	{ "biblechamps",		"Bible Champions: The Birth of Jesus" },
	{ "birdlife",			"Shelley Duvall's It's a Bird's Life" },
	{ "blinddate",			"National Lampoon's Blind Date" },
	{ "blinkybill1",		"Blinky Bill's Ghost Cave" },
	{ "blinkyk1",			"Blinky Bill: Play and Learn - Kindergarten" },
	{ "blinkyps",			"Blinky Bill: Play and Learn - Preschool" },
	{ "blinkyy1",			"Blinky Bill: Play and Learn - Year 1" },
	{ "bobcastle",			"Bob the Builder: Bob's Castle Adventure" },
	{ "bodypark",			"Body Park" },
	{ "brer",				"Brer Rabbit and the Wonderful Tar Baby" },
	{ "buzz1",				"Buzz Lightyear 1st Grade" },
	{ "carmenmath",			"Carmen Sandiego Math Detective" },
	{ "casino",				"Casino!" },
	{ "casino5p",			"Casino 5 Pack" },
	{ "casinoblackjack",	"Casino Black Jack" },
	{ "casinokeno",			"Casino Keno" },
	{ "casinopoker",		"Casino Poker" },
	{ "casinoslots",		"Casino Slots" },
	{ "casperact",			"Casper Activity Center" },
	{ "cassandra",			"The Cassandra Galleries" },
	{ "catcameback",		"The Cat Came Back" },
	{ "catshats",			"Black Cats and Pointed Hats" },
	{ "cbible",				"Children's Bible Stories" },
	{ "cclown",				"A Color Clown Comes to Town" },
	{ "ceremony",			"Ceremony of Innocence" },
	{ "chaos",				"The C.H.A.O.S. Continuum" },
	{ "checkersvillage",	"Checkers' Village" },
	{ "chopsuey",			"Chop Suey" },
	{ "circus",				"Circus!" },
	{ "connections",		"Connections" },
	{ "cracking",			"Cracking the Conspiracy" },
	{ "criticalpath",		"Critical Path" },
	{ "crusader",			"Crusader: A Conspiracy in the Kingdom of Jerusalem" },
	{ "crusader2000",		"Crusader: Edition 2000" },
	{ "crystalskull",		"The Crystal Skull" },
	{ "csimiami",			"CSI: Miami" },
	{ "daedalus",			"The Daedalus Encounter" },
	{ "darkeye",			"The Dark Eye" },
	{ "dazzeloids",			"Dazzeloids" },
	{ "dcanyon",			"Devil's Canyon: A Dinamation Adventure" },
	{ "deathstar",			"Death Star Destructo" },
	{ "derratsorcerum",		"Derrat Sorcerum" },
	{ "devo",				"DEVO Presents: Adventures of the Smart Patrol" },
	{ "digby",				"Digby's Adventures: Tales of a 1-Pound Dog" },
	{ "dimensionq",			"Iz and Auggie: Escape from Dimension Q" },
	{ "dispix2and3",		"Disney Pixar Learning: 2nd & 3rd Grade" },
	{ "donnamatrix",		"Donna Matrix" },
	{ "draculassecret",		"Dracula's Secret" },
	{ "easternmind",		"Eastern Mind: The Lost Souls of Tong Nou" },
	{ "eddieminx",			"Eddie & Minx: Waking Up the Magic" },
	{ "elmopreschool",		"Elmo's Preschool" },
	{ "elroybug",			"Elroy Goes Bugzerk" },
	{ "elroycostume",		"Elroy's Costume Closet" },
	{ "elroypave",			"Elroy Hits the Pavement" },
	{ "erdisaster",			"Emergency Room: Disaster Strikes" },
	{ "exploder",			"Winblows Exploder" },
	{ "fct",				"Big Top's Cartoon Toolbox Starring Felix the Cat" },
	{ "fctexport",			"Felix's Cartoon Transformer" },
	{ "fctplayer",			"Felix Cartoon Player" },
	{ "fff",				"Four Footed Friends" },
	{ "finegardening",		"Fine Gardening Propagation" },
	{ "fishwish",			"The Fish Who Could Wish" },
	{ "flipper",			"Flipper" },
	{ "flipper1",           "The Three Worlds of Flipper & Lopaka" },
	{ "flipper2",           "Flipper & Lopaka: Secrets of the Deep" },
	{ "foocastle",			"Foo Castle" },
	{ "forestia",			"Forestia: The Great Adventure" },
	{ "fpbacon",			"Fisher-Price Big Action Construction" },
	{ "fpbagarage",			"Fisher-Price Big Action Garage" },
	{ "fpdollhouse",		"Fisher-Price Time to Play: Grand Dollhouse" },
	{ "fpgacastle2",		"Great Adventures by Fisher-Price: Castle (1998)" },
	{ "fpgapirates",		"Great Adventures by Fisher-Price: Pirates" },
	{ "fpgawestern",		"Great Adventures by Fisher-Price: Wild Western Town" },
	{ "fplit",				"Fisher-Price Learning in Toyland" },
	{ "fplpairport",		"Fisher-Price Little People: Discovery Airport" },
	{ "fplpxmas",			"Fisher-Price Little People: Christmas Activity Center" },
	{ "fpready1",			"Fisher-Price Ready for School: First Grade" },
	{ "fpreadyk",			"Fisher-Price Ready for School: Kindergarten" },
	{ "fpreadyp",			"Fisher-Price Ready for Preschool" },
	{ "fpreadyt",			"Fisher-Price Ready for School: Toddler" },
	{ "fprpbaxter",			"Fisher-Price Read & Play: Baxter's Birthday" },
	{ "fprpyolanda",		"Fisher-Price Read & Play: Yolanda Yellsalot" },
	{ "frankac",			"Franklin's Activity Center" },
	{ "frankenstein",		"Frankenstein: Through the Eyes of the Monster" },
	{ "franklm",			"Franklin Learns Math" },
	{ "frankrw",			"Franklin's Reading World" },
	{ "freakshow",			"Freak Show" },
	{ "fsky",				"A Field Trip to the Sky" },
	{ "fuzzyfloppy1",		"Fuzzy & Floppy: The Adventure of the Golden Bee" },
	{ "gadget",				"Gadget: Invention, Travel & Adventure" },
	{ "gadgetpaf",			"Gadget: Past as Future" },
	{ "garage",				"Garage: Bad Dream Adventure" }, // English fan translation
	{ "garfieldmadcats",	"Garfield: Mad about Cats" },
	{ "garygadget1",		"Building Cars with Gary Gadget" }, // Sequels list under Swedish
	{ "generations",		"Generations" },
	{ "getaheadmath",		"Math Heads" },
	{ "getaheadmathcr",		"Math Heads Creator" },
	{ "getaheadstrat",		"Strategy Heads" },
	{ "getaheadstratcr",	"Strategy Heads Creator" },
	{ "ggmd",				"The Great Green Mouse Disaster" },
	{ "ggmdmaze",			"The Great Green Mouse Disaster: Mouse Maze" },
	{ "ggmdpics",			"The Great Green Mouse Disaster: Gallery" },
	{ "ggmdsuper",			"The Great Green Mouse Disaster: Super Game" },
	{ "gigglecity",			"Infinity City" },
	{ "gigglefarm",			"AlphaBonk Farm" },
	{ "giggletour",			"The Gigglebone Gang World Tour" },
	{ "gigglevania",		"Pantsylvania: The Kingdom of the Fancy Pants" },
	{ "goferwinkel",		"Goferwinkel's Adventures: The Lavender Land" },
	{ "goldilocks",			"Goldilocks Gamebook" },
	{ "gordak",				"Gord@k" },
	{ "grammarplaytime2",	"Grammar Playtime Vol.2: Asking Questions" },
	{ "gundam0079",			"Gundam 0079: The War for Earth" },
	{ "guscarn",			"Gus Goes to the Kooky Carnival" },
	{ "gusolis",			"Gus Goes to Cyberopolis" },
	{ "guspark",			"Gus Goes to CyberStone Park" },
	{ "gussshc",			"Gus and the CyberBuds Software SchoolHouse Collection" },
	{ "gustown",			"Gus Goes to Cybertown" },
	{ "hamletmurder",		"Hamlet: A Murder Mystery" },
	{ "hamsterland1",		"Busy People of Hamsterland" },
	{ "hamsterland2",		"Hamsterland: The Time Machine" },
	{ "heidi",				"Heidi: Your World is the Mountains" },
	{ "hellcab",			"Hell Cab" },
	{ "hhouse",				"Gahan Wilson's The Ultimate Haunted House" },
	{ "hkbigfun",			"Hello Kitty Big Fun Deluxe" },
	{ "horrortour1",		"Zeddas: Servant of Sheol" },
	{ "hotwheelscamaro",	"Hot Wheels Computer Cars - '93 Camaro" },
	{ "hotwheelshydro",		"Hot Wheels Computer Cars - Hydroplane" },
	{ "hotwheelsmustang",	"Hot Wheels Computer Cars - 1996 Mustang GT" },
	{ "hotwheelspistons",	"Hot Wheels Computer Cars - Power Pistons" },
	{ "hotwheelsrigor",		"Hot Wheels Computer Cars - Rigor Motor" },
	{ "hotwheelswiener",	"Hot Wheels Computer Cars - Oscar Mayer Wienermobile" },
	{ "id4p1",				"iD4 Mission Disk 1 - Alien Supreme Commander" },
	{ "id4p2",				"iD4 Mission Disk 2 - Alien Science Officer" },
	{ "id4p3",				"iD4 Mission Disk 3 - Warrior Alien" },
	{ "id4p4",				"iD4 Mission Disk 4 - Alien Navigator" },
	{ "id4p5",				"iD4 Mission Disk 5 - Captain Steve Hiller" },
	{ "id4p6",				"iD4 Mission Disk 6 - Dave's Computer" },
	{ "id4p7",				"iD4 Mission Disk 7 - President Whitmore" },
	{ "id4p8",				"iD4 Mission Disk 8 - Alien Attack Fighter" },
	{ "id4p9",				"iD4 Mission Disk 9 - FA-18 Fighter Jet" },
	{ "id4p10",				"iD4 Mission Disk 10 - Alien Bomber" },
	{ "id4p11",				"iD4 Mission Disk 11 - Area 51" },
	{ "improv",				"Don't Quit Your Day Job" },
	{ "ingenious",			"Ingenious!" },
	{ "ingenioused",		"Ingenious! Education Resources" },
	{ "ironhelix",			"Iron Helix" },
	{ "isaslm",				"I Saw A Strange Little Man" },
	{ "isis",				"Isis" },
	{ "ispy",				"I Spy" },
	{ "ispyschool",			"I Spy School Days" },
	{ "ispyspooky",			"I Spy Spooky Mansion" },
	{ "jewels1",			"Jewels of the Oracle" },
	{ "jewels2",			"Gems of Darkness" }, // Jewels II
	{ "jman",				"The Journeyman Project" },
	{ "jman2",				"The Journeyman Project 2: Buried in Time" },
	{ "jmmd",				"Just Me & My Dad" },
	{ "js123",				"JumpStart Numbers" },
	{ "jsabc",				"JumpStart ABC's" },
	{ "jsmusic",			"JumpStart Music" },
	{ "jsspanish",			"JumpStart Spanish" },
	{ "jsworld1",			"JumpStart World: First Grade" },
	{ "jsworld1t",			"JumpStart World: Teacher Control Panel 1st Grade" },
	{ "jsworld2",			"JumpStart World: Second Grade" },
	{ "jsworld2t",			"JumpStart World: Teacher Control Panel 2nd Grade" },
	{ "jsworldk",			"JumpStart World: Kindergarten" },
	{ "jsworldp",			"JumpStart World: Preschool" },
	{ "jumpaheadss2000at",  "Jump Ahead Starting School 2000: Assessment Test" },
	{ "jumpaheadss2000wb",  "Jump Ahead Starting School 2000: Workbook" },
	{ "karma",				"Karma: Curse of the 12 Caves" },
	{ "kellyparade",		"Kelly Club Pet Parade" },
	{ "keroppi",			"Keroppi Day Hopper" },
	{ "kidsmathsquest",		"Kid's Maths Quest" },
	{ "kingandi",			"The King and I: Animated Thinking Adventure" },
	{ "korkydragons",		"Dragons!" },
	{ "kothhoot",			"King of the Hill: Hootenany" },
	{ "koththunt",			"King of the Hill: Texas Hunting" },
	{ "kyoto",				"Cosmology of Kyoto" },
	{ "lbkinder",			"Maurice Sendak's Little Bear Kindergarten Thinking Adventures" },
	{ "lbpre",				"Maurice Sendak's Little Bear Preschool Thinking Adventures" },
	{ "lbtpreschool",		"The Land Before Time: Preschool Adventure" },
	{ "legendsofoz",		"The Legends of Oz" },
	{ "letters",			"Letters" },
	{ "louiscatorze",		"Louis Cat Orze: The Mystery of the Queen's Necklace" },
	{ "luxor",				"Secrets of the Luxor" },
	{ "madcc12",			"Madeline Classroom Companion: 1st & 2nd Grade" },
	{ "madccpk",			"Madeline Classroom Companion: Preschool & Kindergarten" },
	{ "madpup",				"Madeline and the Magnificent Puppet Show: A Learning Journey" },
	{ "madtg",				"Madeline Thinking Games" },
	{ "majestic",			"Majestic Part I: Alien Encounter" },
	{ "maniacsports",		"Maniac Sports" },
	{ "martian",			"Ray Bradbury's The Martian Chronicles Adventure Game" },
	{ "mask",				"The Mask: The Origin" },
	{ "mastermansion",		"Masterpiece Mansion" },
	{ "mathacejr",			"Math Ace Jr." },  // aka Bit-Bot's Math Voyage
	{ "mathmystery",		"Math Blaster Mystery: The Great Brain Robbery" },
	{ "maze",				"The Riddle of the Maze" },
	{ "mckenzie",			"McKenzie & Co." },
	{ "mckenziemf",			"McKenzie & Co.: More Friends" }, // Expansion for McKenzie & Co.
	{ "mcluhan",			"Understanding McLuhan" },
	{ "mcmillennium",		"Mission Code: Millennium" },
	{ "mediaband",			"Meet MediaBand" },
	{ "meetchuck",			"Meet Chuck" },
	{ "melements",			"Masters of the Elements" },
	{ "mentalmaths",		"Mental Maths Booster" },
	{ "miamath",			"Mia's Math Adventure: Just in Time!" },
	{ "miareading1",		"Mia's Reading Adventure: The Search for Grandma's Remedy" },
	{ "mickeyk",			"Mickey Mouse Kindergarten" },
	{ "mickeyp",			"Mickey Mouse Preschool" },
	{ "mickeyt",			"Mickey Mouse Toddler" },
	{ "microshaft",			"Microshaft Winblows" },
	{ "mightymachines",		"Mighty Machines" },
	{ "milo",				"Milo" },
	{ "milomagical",		"Milo and the Magical Stones" },
	{ "mirage",				"Mirage" },
	{ "missionplanetx",		"Mission To Planet X: Internet Coach for Kids" },
	{ "mmalgebra",			"Multimedia Algebra" },
	{ "mmiqtest",			"Multimedia IQ Test" },
	{ "mmmath3",			"Mission Masters Math Grade 3: Defeat Dirty D!" },
	{ "moominparty",		"The Great Moomin Party" },
	{ "mrsquack",			"Reading with Peter Cottontail: The Story of Mrs. Quack" },
	{ "mummy",				"Mummy: Tomb of the Pharaoh" },
	{ "muppetkidsearly5",	"Muppets Kids Early Learning Series Volume 5: Sound Patterns: Phonics" },
	{ "muppetkidsthinking",	"Muppets Kids Thinking Skills" },
	{ "murderbrett",		"Who Killed Brett Penance?" },
	{ "murdermagic",		"The Magic Death" },
	{ "murdersam",			"Who Killed Sam Rupert?" },
	{ "murdertaylor",		"Who Killed Taylor French? The Case of the Undressed Reporter" },
	{ "myfavmonster",		"My Favourite Monster" },
	{ "myfirstwords",		"My First Reading & Spelling Words" },
	{ "mylk",				"Mylk" },
	{ "myworld",			"Me & My World" },
	{ "necrobius",			"Necrobius" },
	{ "necromancer",		"Necromancer" },
	{ "nightcafe",			"Night Café" },
	{ "nikolaiknights",		"Nikolai in Time: In the Time of the Knights" },
	{ "nikolaimystery",		"Nikolai's Mysteries: The Mystery of the Black Windows" },
	{ "nikolaipirates",		"Nikolai's Pirates" },
	{ "nikolaispace",		"Nikolai in Outer Space" },
	{ "nikolaispaceedu",	"Nikolai Space Education" },
	{ "nikolaitoys",		"NN'nN Toy Makers" },
	{ "nikolaitreats",		"Nikolai's Treats" },
	{ "nile",				"Nile: Passage to Egypt" },
	{ "nine",				"9: The Last Resort" },
	{ "noddyfair",			"Noddy and the Toyland Fair" },
	{ "noddyschool",		"Noddy: Let's Get Ready For School" },
	{ "noddytoytown",		"Noddy: The Magic of ToyTown on a CD-ROM" },
	{ "noir",				"Noir: A Shadowy Thriller" },
	{ "nurseryrhymes",		"Multimedia Nursery Rhymes" },
	{ "okay2000",			"O!Kay! Best of 2000" },
	{ "okaydemo",			"O!Kay! Probier' mal! Try out!" },
	{ "okaydownunder",		"O!Kay! Down Under" },
	{ "okaydragon",			"O!Kay! Red Dragon" },
	{ "okayfriends",		"O!Kay! Friends" },
	{ "okayhenry",			"O!Kay! Henry in Love" },
	{ "okaytruehero",		"O!Kay! A True Hero" },
	{ "operafatal",			"Opera Fatal" },
	{ "oslotg",				"Adventures with Oslo: Tools and Gadgets" },
	{ "oztma",				"Oz: The Magical Adventure" },
	{ "paparazzi",			"Paparazzi!: Tales of Tinseltown" },
	{ "paws",				"P.A.W.S.: Personal Automated Wagging System" },
	{ "pbbear",				"P. B. Bear's Birthday Party" },
	{ "pecosbill",			"Pecos Bill" },
	{ "perdido",			"Lost in the Amazon" },
	{ "peterrabbit",		"The Adventures of Peter Rabbit and Benjamin Bunny" },
	{ "pennyhorse",			"Penny Horse" },
	{ "phonicsquest",		"Disney Phonics Quest" },
	{ "physicus",			"Physicus: Save the World with Science!" },
	{ "pingu1",				"Pingu: A Barrel of Fun!" },
	{ "pingu2",				"Pingu and Friends" },
	{ "pippi",				"Astrid Lindgren's Pippi" },
	{ "planetarizona",		"Escape from Planet Arizona" },
	{ "playroom",			"The Playroom" },
	{ "poohac",				"Winnie the Pooh Activity Center" },
	{ "poohb",				"Winnie the Pooh Baby" },
	{ "poohk",				"Winnie the Pooh Kindergarten" },
	{ "poohp",				"Winnie the Pooh Preschool" },
	{ "pooht",				"Winnie the Pooh Toddler" },
	{ "princessfashion",	"Disney's Princess Fashion Boutique" },
	{ "puppetmotel",		"Puppet Motel" },
	{ "pyst",				"Pyst" },
	{ "pyst2",				"Driven: The Sequel to Pyst" },
	{ "pystmake",			"The Making of Pyst" },
	{ "quantumgate2",		"The Vortex: Quantum Gate II" },
	{ "rainbowfish1",		"Rainbow Fish: The most beautiful fish in the ocean!" },
	{ "rainbowfish2",		"Rainbow Fish and the Whale" },
	{ "realpool",			"RealPool" },
	{ "rhem1",				"Rhem" },
	{ "rhlava",				"Rescue Heroes: Lava Landslide" },
	{ "rhmeteor",			"Rescue Heroes: Meteor Madness" },
	{ "rodneyfs",			"Rodney's Funscreen" },
	{ "rodneyfs2",			"Rodney's Funscreen² Extreme: Dinky's Revenge" },
	{ "rodneyww",			"Rodney's Wonder Window" },
	{ "safecracker",		"Safecracker" },
	{ "sajaklucky",			"Pat Sajak's Lucky Letters" },
	{ "screamingmetal",		"Screaming Metal" },
	{ "searchlearn",		"Search & Learn Adventures" },
	{ "secretkeys",			"Search for the Secret Keys with Mickey" },
	{ "secretpaths1",		"Secret Paths in the Forest" },
	{ "sfpd",               "SFPD Homicide Case File: The Body in the Bay" },
	{ "shellwhirl",			"Shell Whirl" },
	{ "shr1st2nd",			"Schoolhouse Rock!: 1st & 2nd Grade Essentials" },
	{ "shr3rd4th",			"Schoolhouse Rock!: 3rd & 4th Grade Essentials" },
	{ "shramerica",			"Schoolhouse Rock!: America Rock" },
	{ "shrgrammar",			"Schoolhouse Rock!: Grammar Rock" },
	{ "shrlucky",			"Schoolhouse Rock!: Lucky's Math Arcade" },
	{ "shrmath",			"Schoolhouse Rock!: Math Rock" },
	{ "shrmess",			"Schoolhouse Rock!: 1st-4th Grade Math Essentials" },
	{ "simpsonsplayer",		"The Simpsons Cartoon Player" },
	{ "simpsonsstudio",		"The Simpsons Cartoon Studio" },
	{ "sinkha",				"Sinkha: The 3D Multimedia Novel" },
	{ "sinkha1",			"Sinkha: Hyleyn" },
	{ "sinkha2",			"Sinkha: Atmosphere / Planet of the Clouds" },
	{ "sitfarm",			"Sitting on the Farm" },
	{ "skeeto10",			"Skipper & Skeeto: Fun in the Park" }, // Magnus & Myggen
	{ "skippy",             "Skippy and the Curse of the Temple of Ock" },
	{ "skyborg",			"SkyBorg: Into the Vortex" },
	{ "slamdunktyping",		"Slam Dunk Typing" },
	{ "smarty",				"Smarty" },
	{ "smallfish",			"Small Fish" },
	{ "smartsteps3rd",		"Smart Steps 3rd Grade" },
	{ "snh",				"A Silly Noisy House" },
	{ "snow7han",			"Snow White and the Seven Hansels: The Fairy Tale Game" },
	{ "spacestationalpha",	"Space Station Alpha: The Encounter" },
	{ "spellingbee",		"Arc Media Spelling Bee" },
	{ "spyclub",			"Spy Club" },
	{ "spykids3d",			"Spy Kids 3-D: Game Over" },
	{ "starwarped",			"Star Warped" },
	{ "staytooned",			"Stay Tooned!" },
	{ "superspy",			"SuperSpy 1" },
	{ "supertutorgram",		"Super Tutor Grammar" },
	{ "takeru",				"Buichi Terasawa's Takeru: Letter of the Law" },
	{ "teamxtreme1",		"Operation: Weather Disaster" },
	{ "teamxtreme2",		"Operation: Eco-Nightmare" },
	{ "the7colors",			"The Seven Colors: Legend of PSY・S City" }, // English fan translation
	{ "timmysafari",		"Timmy's Safari Adventure" },
	{ "tkkg1",				"A Case for TKKG 1: Jennifer is Missing" },
	{ "tkkg2",				"A Case for TKKG 2: Deadly Chocolate" },
	{ "tkkg3",				"A Case for TKKG 3: The Mystery of the Mayan Treasure" },
	{ "tkkg4",				"A Case for TKKG 4: The Secret of Dragon Claw Manor" },
	{ "tkkg5",				"A Case for TKKG 5: TKKG Betrayed" },
	{ "tkkg6",				"A Case for TKKG 6: The Forged Fifties" },
	{ "tkkg7",				"A Case for TKKG 7: Fire!" },
	{ "tkkg8",				"A Case for TKKG 8: The Captain's Legacy" },
	{ "tkkg9",				"A Case for TKKG 9: Voodoo Magic" },
	{ "tkkg10",				"A Case for TKKG 10: Panic in a Boarding School" },
	{ "tkkg11",				"A Case for TKKG 11: Action!" },
	{ "tkkg12",				"A Case for TKKG 12: Alarm at the Roller Coaster" },
	{ "tkkg13",				"A Case for TKKG 13: Cell 13" },
	{ "tkkg14",				"A Case for TKKG 14: Dangerous Holiday" },
	{ "tommy",				"Pete Townshend Presents Tommy: The Interactive Adventure" },
	{ "totaldistortion",	"Total Distortion" },
	{ "traitorsgate",		"Traitors Gate" },
	{ "travelrama",			"Travelrama USA" },
	{ "tweeniesrtp",		"Tweenies: Ready to Play" },
	{ "vcop",				"Virtual Cop" },
	{ "vcop1",				"Virtual Cop: Episode One: Good Cop / Bad Cop" },
	{ "vcop2",				"Virtual Cop: Episode Two: The Angel Returns" },
	{ "veniceglass",		"Venice Under Glass: A Basil Baker Mystery Adventure" },
	{ "videocasino",		"Video Casino" },
	{ "vjg",				"Vegas Jackpot Gold" },
	{ "vnc",				"Virtual Nightclub" },
	{ "voodoolounge",		"The Rolling Stones: Voodoo Lounge" },
	{ "vp2",				"Virtual Physics: The Eggs of Time" },
	{ "vvcyber",			"Victor Vector & Yondo: The Cyberplasm Formula" },
	{ "vvdinosaur",			"Victor Vector & Yondo: The Last Dinosaur Egg" },
	{ "vvharp",				"Victor Vector & Yondo: The Hypnotic Harp" },
	{ "vvvampire",			"Victor Vector & Yondo: The Vampire's Coffin" },
	{ "wallobee",			"Wallobee Jack: The Bingi Burra Stone" },
	{ "wallobee2",			"Wallobee Jack: The Thai Sun Adventure" },
	{ "wallobee3",			"Wallobee Jack: The Lost Lionardo" },
	{ "wallobee4",			"Wallobee Jack: Secret of the Sphinx" },
	{ "wallobeetemple",		"The temple of Monakumba: Starring Wallobee Jack" },
	{ "warlock",			"Spaceship Warlock" },
	{ "wiggles1",			"A Day with the Wiggles" },
	{ "winniewitch",		"Winnie the Witch" },
	{ "wishbone", 			"Wishbone and the Amazing Odyssey" },
	{ "wrath",				"Wrath of the Gods" },
	{ "xanthus",			"Xanthus" },
	{ "xfools",				"The X-Fools: The Spoof is Out There" },
	{ "xmasstory",			"A Christmas Story" },
	{ "y2lgeography",		"Yearn2Learn: Master Snoopy's World Geography" },
	{ "y2lmath",			"Yearn2Learn: Master Snoopy's Math" },
	{ "y2lsnoopycoloring",	"Yearn2Learn: Master Snoopy's Coloring Book" },
	{ "y2lflintcoloring",	"Yearn2Learn: The Flintstones Coloring Book" },
	{ "y2lpeanuts",			"Yearn2Learn: Peanuts" },
	{ "y2lsnoopy",			"Yearn2Learn: Snoopy" },
	{ "y2lspelling",		"Yearn2Learn: Master Snoopy's Spelling" },
	{ "ybr1",				"Yellow Brick Road" },
	{ "zerozero",			"Zero Zero" },

	// Multimedia or reference products
	{ "9worlds",			"Nine Worlds hosted by Patrick Stewart" },
	{ "aamn",				"Anatomy & Anaesthesia of the Mandibular Nerve" },
	{ "adamcmp",			"A.D.A.M. Comprehensive" },
	{ "adamess",			"A.D.A.M. Essentials" },
	{ "adamstd",			"A.D.A.M. Standard" },
	{ "adamtis",			"A.D.A.M. The Inside Story" },
	{ "alankay",			"Alan Kay CD-ROM Pack" },
	{ "alcohol101",			"Alcohol 101" },
	{ "alice2ocean",		"From Alice to Ocean: Alone Across the Outback" },
	{ "amhha",				"All My Hummingbirds Have Alibis" },
	{ "amnesty",			"Amnesty Interactive" },
	{ "artintact",			"the complete artintact komplett" },
	{ "artmarcopatrito",	"The Art of Marco Patrito" },
	{ "aruba",				"Aruba Interactive" },
	{ "athletics",			"International Athletics" },
	{ "babylon5int",		"Babylon 5 Interactive" },
	{ "babylon5guide",		"The Official Guide to Babylon 5" },
	{ "battles",			"Battles of the World" },
	{ "beatexp",			"The Beat Experience" },
	{ "bettypage",			"Betty Page: The World of a Pin-Up Queen" },
	{ "beyondcyberpunk",	"Beyond Cyberpunk! A Do-It-Yourself Guide to the Future" },
	{ "bht",				"A Brief History of Time: An Interactive Adventure" },
	{ "bioflix",			"BioFlix" },
	{ "biomorph",			"Biomorph Encyclopedia: Muybridge Revisited" },
	{ "blam",				"BLAM!" },
	{ "blam2",				"BLAM! 2" },
	{ "blam3",				"BLAM! 3" },
	{ "blindrom",			"BlindRom 0.9: The Prototype" },
	{ "bowie",				"JUMP: The David Bowie Interactive CD-ROM" },
	{ "browser",			"Browser: Artopolis 97" },
	{ "bugbook",			"The Multimedia Bug Book" },
	{ "canelect",			"Exploring Canada's Electoral System" },
	{ "cdphysics",			"CD Physics for Windows" },
	{ "cezanne",			"A is for ART, C is for Cezanne" },
	{ "cezannetour",		"Paul Cézanne Art Tours" },
	{ "chuniverse",			"The Challenge of the Universe" },
	{ "cinevolt",			"Cinema Volta: Weird Science & Childhood Memory" },
	{ "cocktailhour",		"Cocktail Hour: A Guide to Bartending" },
	{ "comusic",			"Computer Music: An Interactive Documentary" },
	{ "cpnre",				"Canadian Practical Nurse Registration Exam Practice" },
	{ "ctrain",				"Doing it in C++" },
	{ "dailymail100",		"Daily Mail Centenary: 100 Amazing Years" },
	{ "delphi4tutor",		"Borland Delphi 4 Tutor" },
	{ "dinos",				"Multimedia Dinosaurs" },
	{ "dynamichuman",		"The Dynamic Human: The 3D Guide to Anatomy and Physiology" },
	{ "easybass",			"Easy Bass" },
	{ "easyitalian",		"Easy Cooking Italian" },
	{ "edh",				"Executive Diet Helper" },
	{ "egypt",				"Egypt: Voyage to the Land of the Pharaohs" },
	{ "einstein",			"The Ultimate Einstein" },
	{ "elfascd",			"ELFAs CD - 1 september 1999" },
	{ "espanatomy",			"Anatomy & Physiology: The Unity of Form and Function" },
	{ "explorers",			"Explorers of the New World" },
	{ "explorespace1",		"Explore Space: The Solar System" },
	{ "explorespace2",		"Explore Space: Mars" },
	{ "explorespace3",		"Explore Space: The Sun & Moon" },
	{ "explorespace4",		"Explore Space: The Galaxy" },
	{ "explorespace5",		"Explore Space: Space Missions" },
	{ "flw",				"The Ultimate Frank Lloyd Wright: America's Architect" },
	{ "fractiondecimal",	"Fractions & Decimals" },
	{ "frequency",			"frEQuency" },
	{ "fusion",				"Harnessing the Energy of the Stars" },
	{ "futureview",			"FutureView: The 1990s and Beyond" },
	{ "ghetto",				"Stories from the Warsaw Ghetto" },
	{ "golfcd",				"The Great Golf CD: Links, Legends & Lore" },
	{ "gp2006",				"Grand Prix 2006 & Auto Directory" },
	{ "guns",				"Multimedia Guns" },
	{ "haight",				"Haight-Ashbury in the Sixties" },
	{ "heuther",			"Understanding Pathophysiology, 3rd Edition" },
	{ "hikaruhana",			"Shining Flower: Hikaruhana" },					// 光る花
	{ "hirezaudio",			"Hi Rez Audio" },
	{ "hunchback",			"Interactive Storybook: The Secret of the Hunchback" },
	{ "ibmcdextra",			"Sony Music CD Extra Sampler" },  // AKA IBM CD-Extra (CPDP 000350)
	{ "iptr",				"I Photograph to Remember" },
	{ "isscommerce",		"International Space Station: Space Commercialization" },
	{ "itc",				"Internet the City: A Guided Tour Through the Internet" },
	{ "journey2life",		"The Journey to Life" },
	{ "klondikegold",		"Klondike Gold - An Interactive History" },
	{ "learningcoreldraw3",	"Learning CorelDRAW 3" },
	{ "laughingbird",		"The Laughing Bird Restaurant" },
	{ "learninternet",		"Video Professor: Learn to Use the Internet" },
	{ "learnworks2",		"Video Professor: Learn Works for Windows 95, Level 2" },
	{ "leonardo",			"Leonardo the Inventor" },
	{ "lewisclark",			"Lewis & Clark Interactive Picture CD" },
	{ "lifemysteries",		"Life's Greatest Mysteries" },
	{ "lifeuniverse",		"Life in the Universe" },
	{ "louvre",				"Le Louvre: The palace & its paintings" },
	{ "lovedisk",			"Lovedisk 95" },
	{ "makers",				"Makers of the 20th Century" },
	{ "mediabook",			"The MediaBook CD for Director" },
	{ "moag",				"The Museum of Anything Goes" },
	{ "msa2001",			"Middle School Advantage 2001" },
	{ "ms500nations",		"Microsoft 500 Nations" },
	{ "msdinosaurs",		"Microsoft Dinosaurs" },
	{ "msoceans",			"Microsoft Oceans" },
	{ "mswine",				"Microsoft Wine Guide" },
	{ "mysteriousegypt",	"Mysterious Egypt" }, // aka Voyage in Egypt
	{ "newslinks",			"ABC NewsLinks" },
	{ "nia4",				"News in Action 4" },
	{ "nixon",				"Nixon: Watergate" },
	{ "nmm",				"Nine Month Miracle" },
	{ "nobel100",			"The Nobel Prize: 100 Years of Creativity and Innovation" },
	{ "painters",			"Emile de Antonio's Painters Painting" },
	{ "paris",				"Paris: History and Splendour" },
	{ "parisvt",			"Virtual Tourism Paris" },
	{ "parliament",			"People & Parliament: A Stranger's Guide to Westminster" },
	{ "paperplanes",		"WordPerfect Main Street presents Paper Planes" },
	{ "picasso",			"Picasso: the man, his works, the legend" },
	{ "pixar",				"Pixar Projector" },
	{ "planetstrass",		"Pl@net" },
	{ "potala",             "1000 Years Potala" },
	{ "princetonsat98",		"The Princeton Review: Inside the SAT '98" },
	{ "revwar",				"Revolutionary War Picture CD" },
	{ "rodneyab",			"Rodney's Art Brain" },
	{ "saguaro",            "Saguaro & the City: Investigate the Sonoran Desert with an Interactive CD ROM" },
	{ "saillusion",			"Scientific American Library: Illusion" },
	{ "sagasoftworks",		"The Saga Softworks" },
	{ "sarahcatalog",		"Sarah McLachlan Catalogue" },
	{ "sauniverse",			"Scientific American Library: The Universe" },
	{ "sciencesmart",		"Science Smart" },
	{ "scrutiny",			"ScruTiny in the Great Round" },
	{ "sentence",			"this is a sentence" },
	{ "sialmanac94",		"Sports Illustrated 1994 Multimedia Almanac" },
	{ "sk8board",			"RIDE: An Interactive Skateboarding Experience" },
	{ "skieurope96",		"Ski Europe '96" },
	{ "smithamerica",		"Smithsonian's America" },
	{ "sonysampler",		"Sony Music Sampler" },  // AKA "Sony CD Extra Sampler (CPDP-000310)"
	{ "sourcesfaith",		"Sources of Faith: An Interactive Guide to Seven World Faiths" },
	{ "supersonic",			"Supersonic: A Multimedia Guide to Modern Military Aircraft" },
	{ "survive",			"How Would You Survive?" },
	{ "take5",				"Take Five: Relaxation at Your Finger Tips" },
	{ "technik",			"Technology Interactive" },
	{ "texas",				"A Virtual Reality CD-ROM Guide to Texas" },
	{ "theatreimag",		"Theatre of the Imagination" },
	{ "toyota95",			"1995 Toyota Interactive" },
	{ "trekchair",			"Star Trek: Captain's Chair"},
	{ "trekguideds9",		"Star Trek: Deep Space Nine Episode Guide" },
	{ "trekguidetng",		"Star Trek: The Next Generation Episode Guide" },
	{ "trekomni",			"Star Trek Omnipedia" },
	{ "trekpedia98",		"Star Trek Encyclopedia 1998" },
	{ "trekship",			"Star Trek: Starship Creator"},
	{ "trekshipaddon",		"Star Trek: Starship Creator Add-on Pack"},
	{ "trektech",			"Star Trek: The Next Generation Interactive Technical Manual" },
	{ "truthsfictions",		"Truths & Fictions: A Journey from Documentary to Digital Photography" },
	{ "ugtmk",				"The Ultimate Guide to Mortal Kombat" },
	{ "universe",			"Invisible Universe" },
	{ "unwrap",				"Unwrap the Magic: Holiday 2000 Interactive CD-ROM" }, // J.C.Penney
	{ "ushistory",			"The History of the United States for Young People" },
	{ "venetiandeer",		"Venetian Deer" },
	{ "vote",				"Vote America: Your Field Guide to Electing a President" },
	{ "vtarot",				"Virtual Tarot" },
	{ "vusic",				"Vusic: The Screen Raver" },
	{ "wackyjacks",			"Wacky Jacks" },
	{ "warplanes",			"Warplanes: Modern Fighting Aircraft" },
	{ "webmaster",			"Webmaster: Fantastic Adventures in the World of the Internet" },
	{ "whales",				"World of Whales: An Interactive Voyage of Pure Wonder" },
	{ "wildblueyonder1",	"Wild Blue Yonder: Episode 1: 50 Years Of Gs And Jets" },
	{ "wine",				"The Wine CD" },
	{ "withopeneyes",		"With Open Eyes: Images from The Art Institute of Chicago" },
	{ "womanengineer",		"You Can Be a Woman Engineer" },
	{ "woodstock25",		"Woodstock: 25th Anniversary CD-ROM: 3 Days of Peace & Music" },
	{ "worldnet",			"AT&T WorldNet Service E-Guide" },
	{ "wwanimals",			"Wide World of Animals" },
	{ "xfua",				"The X-Files Unrestricted Access" },
	{ "xmen-burgerking",	"X-Men Evolution Burger King mini CD" },

	// Productivity software
	{ "expbooktoolkit2",	"Expanded Book Toolkit II" },
	{ "secretwriters",		"Secret Writer's Society" },

	// Shareware and freeware
	{ "101pet",				"Dalmation Adoption" },
	{ "50ftchicken",		"Attack of the 50-foot Chicken" },
	{ "alanna",				"The Lost Island of Alanna" },
	{ "antfarm",			"Ant Farm" },
	{ "antsafire",			"Ants Afire!" },
	{ "aolstarwars",		"Star Wars: Episode III: Game, Videos & More!" },
	{ "arad",				"Animaniacs River Adventure" },
	{ "astroblast",			"AstroBlast" },
	{ "belcher",			"The Belcher" },
	{ "bigsound",			"BigSound VW Player" },
	{ "bigtimemovie",		"Big Time Movie Studios" },
	{ "bingobuds",			"Bingo Buddies" },
	{ "bob",				"Bob" },
	{ "broadwayyb",			"The 2000-2001 Broadway Series Interactive Yearbook" },
	{ "catseyeview",		"Cat's Eye View" },
	{ "childishgambino",	"Capturing Donald Glover's Motion" },
	{ "chuckaduck",			"Chuck-A-Duck" },
	{ "colormind",			"ColorMind" },
	{ "courtneyfilter",		"The Courtney Filter" },
	{ "crybaby",			"Crying, Screaming Baby" },
	{ "deedeedanger",		"Dexter's Laboratory: Dee Dee Duplication Danger" },
	{ "dfireworks",			"The Digital Fireworks Stand" },
	{ "digihbd",			"Digital Happy Birthday Card" },
	{ "dreidel",			"DreidelLand: An Electronic Hanukah Treat" },
	{ "emigre",				"Emigre Signs of Type: Big Cheese" },
	{ "flingshot",			"The Rugrats Movie: Baby Food Flingshot" },
	{ "fortuneteller",		"The Fortune Teller" },
	{ "headhunter",			"HeadHunter" },
	{ "hurlman",			"Hurlman" },
	{ "illusions",			"Illusions" },
	{ "imision369",			"ImIsion 369" },
	{ "kfk",				"Kung Fu Kim" },
	{ "letterrally",		"Letter Rally" },
	{ "limit0",				"Limit 0" },
	{ "lovinghenry",		"Loving Henry" },
	{ "makeamug",			"Make-A-Mug" },
	{ "makingmusic",		"Morton Subotnick's Making Music" },
	{ "marathonsecrets",	"Marathon Secrets" },
	{ "mathtest",			"Math Test" },
	{ "missileattack",		"Missile Attack" },
	{ "myfavburps",			"My Favorite Burps" },
	{ "namegame",			"Name that Game" },
	{ "netmaze",			"Netmaze" },
	{ "nickmemory",			"Nicktoons Memory Challenge" },
	{ "njdevils2001",		"2001 New Jersey Devils Interactive CD ROM" },
	{ "nomis",				"Nomis" },
	{ "nyknicks2000",		"NY Knicks 2000" },
	{ "nykshuffle",			"NYK Shuffle" },
	{ "nyyankeesyb",		"New York Yankees Interactive Yearbook" },
	{ "pfarrypuzzle",		"Paul Farry Puzzle" },
	{ "popapenguin",		"Pop-a-Penguin" },
	{ "prangers1",			"PowerRangers Part 1" },
	{ "prangers2",			"PowerRangers Part 2" },
	{ "psych",				"Psych: An Interactive Stress Buster!" },
	{ "revdemo",			"Macromedia Director 4.0 Revolution" },  // from CD-ROM Now issue #7 '94
	{ "rooked",				"Rooked" },
	{ "saspurs2001",		"San Antonio Spurs 2001 Broadcast Screensaver" }, // Not a screensaver
	{ "saspurs2005",		"San Antonio Spurs Internet Hot-links" }, // Not a screensaver
	{ "scanmon",			"ScanMon" },
	{ "seinfeldondvd",		"Seinfeld on DVD" },
	{ "sensei",				"Sensei" },
	{ "simpsontrivia",		"The Simpsons Trivia" },
	{ "smile",				"SMILE! The Splattering" },
	{ "sorgato",			"Sylvain Sorgato's Drawings in variable color" },
	{ "spitwad",			"High School High Spitwad Game" },
	{ "springhead",			"Springhead" },
	{ "ssmorphclock",		"Morph Clock Screensaver" },
	{ "summertime",			"Summertime" },
	{ "thematrix",			"The Matrix: Cinemas Everywhere June 11" },
	{ "timeline",			"TimeLine Animation" },
	{ "troubleshoot101",	"Troubleshooting 101" },
	{ "twine",				"The World is Not Enough 007" },
	{ "verttice",			"DreamLight Verttice" },
	{ "wonkatrivia",		"Wonka Trivia" },
	{ "wriggle",			"Wriggle" },

	// Music videos and enhanced music CDs
	{ "avrilletgo",			"Avril Lavigne: Let Go" },
	{ "bobmambo5",			"Bob the Builder: Mambo No. 5" },
	{ "chaquico1000",		"Craig Chaquico: A Thousand Pictures" },
	{ "concentration",		"Solitudes: Natural Concentration" },
	{ "doorswindows",		"The Cranberries: Doors and Windows" },
	{ "freakshowost",		"The Residents: Freak Show: Multimedia Bonus Track" },
	{ "gingerbreadman",		"The Residents: Gingerbread Man" },
	{ "girlsaloudbox",		"Girls Aloud: The Singles Box Set" },
	{ "ebntelebreakdown",	"EBN: Telecommunication Breakdown" },
	{ "im7s7s",				"Iron Maiden: Seventh Son Of A Seventh Son" }, // 1998 rerelease
	{ "imesceneryfish",		"I Mother Earth: Scenery and Fish" },
	{ "listen7up",			"Listen 7UP! Music Mix CD: Volume 1" },
	{ "nyack",				"Nyack 11-Track Player" },
	{ "princerave",			"Prince: Rave Un2 the Joy Fantastic" },
	{ "relaxation",			"Solitudes: Natural Relaxation" },
	{ "relaxplayer",		"Solitudes: Natural Relaxation Audio Player" },
	{ "royksoppam",			"Röyksopp: Melody A.M." },
	{ "sarahsurfacing",		"Sarah McLachlan: Surfacing" },
	{ "smashchillin",		"Smash Hits: Chillin' Out Summer 2001" },
	{ "songbird",			"Solitudes: Songbird Symphony" },
	{ "stressrelief2",		"Solitudes: Natural Stress Relief II" },
	{ "tonetrakker",		"Tone Trakker" },

	// Arabic titles
	{ "abctrain",			"Alphabet Train" },
	{ "alhisab",			"هيا نتعلم الحساب والمفاهيم" },		   // Let's learn arithmetic (al-hisab) and concepts
	{ "anasheed",			"إسطوانة قطار القصص والأناشيد" },	   // Train of Stories & Songs
	{ "futsoft",			"برامج تعليمية من شركة فيوتشر سوفت" }, // Future Soft educational demos
	{ "hamamalachkal",		"تعلم مع همام الأشكال" },			   // Learn Shapes with Hamam
	{ "hamamalalwan",		"تعلم مع همام الألوان" },			   // Learn Colors with Hamam
	{ "hamamalhuruf",		"تعلم مع همام الحروف" },			   // Learn Letters with Hamam
	{ "ktaralarkam",		"قطاد الأرقام" },					   // Numbers Train
	{ "mesoftware",			"شركة الشرق الأوسط للبرمجيات" },	   // Middle East Software Company
	{ "sakhr",				"مجلة برامج صخر" },					   // Sakhr Software Catalogue

	// Catalan titles
	{ "3iadins",			"TV3 i a dins!" },
	{ "limit0inici",		"Límit 0 Inici" },

	// Czech titles
	{ "nemcina",			"Německá gramatika cvičebnice" },           // German grammar workbook

	// Danish titles
	{ "bamse1",				"Bamses allerskoreste spille-rom" },
	{ "bamse2",				"Bamse: Min egen spille-rom" },
	{ "bellini3",			"Bellinis Bikini" },  						// Ep 3 of Bellini series
	{ "billetrille1",		"Bille & Trille: Da fantasien slap løs" },
	{ "billetrille2",		"Bille & Trille: Helt ude i skoven" },
	{ "brspel",				"BR spel" },
	{ "pixeline1",			"Pixeline: Syng, leg og lær" },
	{ "pixeline2",			"Pixeline: og hulen i træet" },
	{ "pixeline3",			"Pixeline: på bedstemors loft" },
	{ "pixeline4",			"Pixeline: og huset i eventyrskoven" },
	{ "pixeline5",			"Pixeline: i sommerhuset" },
	{ "pixeline6",			"Pixeline: for fulde sejl" },
	{ "pixeline7",			"Pixeline: fuld af fis og ballade" },
	{ "pixeline8",			"Pixeline: og Kong Gulerod" },
	{ "pixeline9",			"Pixeline: I det Vilde Westen" },
	{ "pixelineskolevik",	"Pixeline Skolehjælp: Lær om Vikingerne - Kongekampen" },

	// Dutch titles
	{ "beestenboel",		"Beestenboel Zoölogic" },
	{ "boeboekshaboe",		"Boeboeks: Hop hop haboe!" },
	{ "boeboekstocht",		"Boeboeks: de toch naar opa Kakadoris" },
	{ "fcdk",				"F.C. De Kampioenen: Op Zoek Naar Neroke" },
	{ "griezelbus1",		"De Griezelbus 1" },
	{ "kjoeties",			"Invasie van de Kjoeties" },
	{ "lannoo",				"Lannoo Nieuwe Media Demo" },
	{ "samson",				"Op Reis Met Samson & Gert" },

	// Finnish titles
	{ "aapelin1",			"Aapelin ABC: Hurjistunut Pölynimuri" },
	{ "kcd",				"Kompuutteri Kaikille" },
	{ "kultapossu",			"Kultapossu ja Leo Leijona: Sateenkaarivarkaat" },
	{ "petepilotti1",		"Pete Pilotti & Pontiac: Seikkailu Lapponiassa" },

	// French titles
	{ "1contre100",			"1 contre 100" },
	{ "affaires1",			"Affaires à suivre: L'Île diabolique" },
	{ "boulebill",			"Boule et Bill: Au Voleur!" },
	{ "boitearire",			"La boîte à rire" },
	{ "fg25ans",			"25 Ans! Le CD-ROM de Fluide Glacial" },
	{ "forestiajr",			"Forestia Révoltozoo" },
	{ "guignols1",			"Les Guignols de l'Info ... LE JEU!" },
	{ "guignols2",			"Les Guignols de l'Info: Le cauchemar de PPD" },
	{ "lvi",				"La Vague Interactive" },
	{ "madmac",				"Mad Mac Cartoons" },
	{ "recfantome",			"Récréation fantôme" },
	{ "reinedesneiges",		"La reine des neiges" },
	{ "sethi2",				"Sethi et le sorcier inca" },
	{ "sethi3",				"Sethi et la Tribu de Neandertal" },
	{ "shadoks",			"Les Shadoks... Le jeu, la promenade" }, // Punctuation comes from lisezmoi.txt
	{ "svmvillagina5",		"SVM Multimedia: Villagina 5" },
	{ "teddybear",			"Opération Teddy Bear" },
	{ "tomlisaindiens",		"Tom et Lisa: les Indiens" },

	// German titles
	{ "bibi2",				"Bibi Blocksberg 2: Ein verhexter Schultag" },
	{ "bibifilm",			"Bibi Blocksberg: Mein verhextes Filmstudio" },
	{ "braingames",			"Brain Games" },
	{ "cklasse",			"Mercedes-Benz C-Class Information Booth" },
	{ "dieveteranen",		"Die Veteranen: So nutzlos wie eine Fuge von Bach" },
	{ "dudenmeyer",			"Duden/Meyer Multimedia sampler" },
	{ "flaschenfahrrad",	"Das Verkehrs-Lernspiel: Fred und das Flaschenfahrrad" },
	{ "girlspack",			"Girl's Pack!" },
	{ "globiabc",			"Globi's ABC" },
	{ "janoschpanama",		"JANOSCH: Oh, wie schön ist Panama" },
	{ "janoschverkehr",		"JANOSCH: Tiger und Bär im Straßenverkehr" },
	{ "loewe1",				"Löwenzahn 1" },
	{ "loewe2",				"Löwenzahn 2" },
	{ "loewe3",				"Löwenzahn 3" },
	{ "loewe4",				"Löwenzahn 4" },
	{ "loewe5",				"Löwenzahn 5" },
	{ "loewe6",				"Löwenzahn 6" },
	{ "mats3",				"Mats und das rätselhafte Tier" },
	{ "maus2",				"Die CD-ROM mit der Maus 2" },
	{ "max1",				"Max and the Secret Formula" },
	{ "max2",				"Max and Marie Go Shopping" },
	{ "max3",				"Max and the Haunted Castle" },
	{ "mrmore",				"Mr. More Interaktive" },
	{ "otelo",				"o.tel.o Online 01011" },
	{ "ravecard2001",		"Ravecard 2001" },
	{ "ravensburger",		"Ravensburger Interactive Demo-Sampler" },
	{ "raveshuttle",		"Rave Shuttle: The Cosmic Challenge" },
	{ "ritterrost",			"Ritter Rost - Die Eiserne Burg" },
	{ "tkkgkit",			"TKKG: Identikit" },
	{ "zwergnase",			"Zwerg Nase: Ein interaktives Märchen" },

	// Italian titles
	{ "fuzzyfloppy2",		"Fuzzy e Floppy: Il Furto Della Rotonda" },
	{ "fuzzyfloppy3",		"Fuzzy e Floppy: Il Raggio Magico" },
	{ "tesorovenezia",		"Il tesoro di Venezia" },
	{ "ironmask",			"The Iron Mask" },
	{ "lunes",				"I Lunes e la sfera di Lasifer" },					// Lunes & the sphere of Lasifer
	{ "magicanti",			"I Magicanti e i 3 elementi" },						// The Magicanti & the 3 elements
	{ "robidoc",			"Robi & Doc: L'isola della Scienza" },
	{ "wolfgang",			"Wolfgang il Cyberlupo" },  // According to developer Ugo Guidolin, an English version exists ?

	// Japanese games
	{ "4sight",				"four-sight" },
	{ "alexworld",			"ALeX-WORLD" },
	{ "alius",				"The Alius: Intaractive Adventure Movie" },		// Not a typo
	{ "angelgate",			"Angel Gate" },
	{ "animaltown",			"わくわくアニマルタウン" },							// Waku Waku Animal Town
	{ "ankh1",				"アンク ピラミッドの謎" },
	{ "ankh2",				"アンク 2 ツタンカーメンの謎" },
	{ "ankh3",				"アンク 3" },
	{ "apeodyssey",			"Ape Odyssey 2001" },
	{ "aramata",			"Aramata's Visual Wonderland: Magic of Perspective" },
	{ "atmarktown",			"Atmark Town" },
	{ "banddamashii",		"バンド魂" },	// Band Damashii
	{ "belzerion",			"Belzerion" },	// ベルゼリオン
	{ "bem",				"妖怪人間ベム 新たなる魂の迷宮" },					// Yokai Ningen Bemu
	{ "bemtoybox",			"妖怪人間ベム データToyBox" },						// Bem Data Toy Box
	{ "beyondthetime",		"Beyond the Time" },
	{ "bombreikochiba",		"千葉麗子 BOMB!" },	// Reiko Chiba - Bomb
	{ "cellofania",			"セロファニア" },
	{ "chinacrisis",		"China Crisis" },
	{ "chisanaensoka",		"小さな演奏家" },									// Little Musician (Crickets)
	{ "choroli",			"The Trip of Choroli" }, // title also provided in Japanese on the web - 「ちょろりの冒険」
	{ "chuchutataki",		"チュウチュウたたき" }, // Chu-Chu Tataki, part of the Shock Price 500 series
	{ "christmassmallhouse","Christmastime at Small House" },
	{ "chuckletime",		"チャックルタイム" },
	{ "chuteng",			"中天" },
	{ "cutie10",			"キューティ１０" },
	{ "cookie",				"Cookie's Bustle: 謎のボンボワールド"},					// Mysterious Bombo World
	{ "cookieginger",		"Cookie & Ginger"},
	{ "crouton",			"Croûton"},
	{ "dan",				"ダン" },											// Dan
	{ "djrom",				"The DJ-ROM: Da CD-Extra of Hip-Hop Music" },
	{ "digitalboy1",		"Digital Boy CD-ROM Vol. 1" },
	{ "digitalboy2",		"Digital Boy CD-ROM Vol. 2" },
	{ "digitalboy3",		"Digital Boy CD-ROM Vol. 3" },
	{ "dinoventure",		"The DinoVenture" },
	{ "dropcity",			"Drop City" },
	{ "dungeonstreet",		"Dungeon Street" },
	{ "nendo",				"Digital Nendo" },
	{ "earthtia",			"アースティアサーガ ラーサーレジェンド" },					// Earthtia Saga: Larthur's Legend
	{ "epson96",			"I Love EPSON '96 シェイプUPガールズ" },				// Shape Up Girls
	{ "erikotamuraoz",		"Eriko Tamura: Oz" },
	{ "fantazion",			"World Engine Fantazion" },
	{ "ffa",				"ファンキー ファニー エイリアンズ" },					// Funky Funny Aliens
	{ "garyukeiba",			"我流競馬" },										// "My style horse racing"
	{ "ganbareinuchan",		"がんばれ！ いぬちゃん ロケンロール編" },				// Ganbare! Inu-chan: Rock'n Roll Edition
	{ "ganbareinuchan2",	"がんばれ！ いぬちゃん 世界の旅へん" },				// Ganbare! Inu-chan: Tour Around the World
	{ "gate1",				"the GATE I 王国「MU」への扉" },
	{ "gate2",				"the GATE II 王国「MU」への扉" },
	{ "gate3",				"the GATE III 王国「MU」への扉" },					// Gateway to the Kingdom of MU
	{ "geraldmccoy",		"Detective Gerald McCoy" },
	{ "gocoo",				"GO-COO" },
	{ "granmarmalade",		"グラン・マーマレード・マジカル・ビレッジ" },
	{ "henachoco",			"へなちょこダービー" },								// HenaChoco Derby
	{ "henachoco02",		"サイテイバード" },								// Saitei Birds
	{ "henachoco03",		"難しい本を読むと眠くなる" },						// "Reading a Difficult Book Makes Me Sleepy"
	{ "henachoco04",		"あの素晴らしい弁当を2度3度" },								// That Wonderful Bento 2 or 3 Times
	{ "henachoco04r",		"あの素晴らしいラメンスペシャル" },								// That Wonderful Ramen Special
	{ "henachoco05",		"野犬ロデム" },								// Rodem the Wild
	{ "henachoco06",		"蒸し蒸しチキンそり旅行" },								// Steamed Chicken Sled Trip
	{ "henachoco07",		"うそつきと私" },								// Liar and Me
	{ "henachoco08",		"おませなおませな屋台大作戦" },								// Omasena Omasena Stall Strategy
	{ "henachoco09",		"ニセミジンコのうそひみつ" },								// The Secret Lie of Nisemijinko
	{ "henachoco11",		"スロプロウエスタン" }, // Slowpro Western
	{ "henachococd",		"ギャラクレヤン'75 オレニモインゼイクレヤン" }, // Galakureyan'75 Inzeikureyan
	{ "henachocoexpo",		"イタチョコの野望" }, // Itachoco's Ambition
	{ "henachocogala",		"スペースギャラクレヤン" }, // Space Galakureyan
	{ "hidoiyokun",			"ひどいよくん" }, // Hidoiyo-kun
	{ "himejijo",			"A.MAZING姫路城" },									// A.MAZING Himejijo (the HIMEJI Castle)
	{ "horrortour2",		"Zeddas: Horror Tour 2" },
	{ "horrortour3",		"ラビラーント" },									// Labyrinthe
	{ "incarnatia",			"Incarnatia" },
	{ "ganguten",			"インタラクティブ玩具店" }, // Interactive Toy Store
	{ "inugumi",			"犬組" },
	{ "ios",				"iós" },
	{ "intro",				"INTRO꞉ New Cultural EDGE Ver1.0" },
	{ "intro1",				"INTRO No. 1 1994" },
	{ "intro2",				"INTRO No. 2 1994" },
	{ "intro4",				"INTRO No. 4" },
	{ "jinkakuzukan",		"人格図鑑" }, // Personality Profile
	{ "junglepark",			"Jungle Park" },
	{ "jyajya",				"Jya jya" },										// HyperCard with D3 movie
	{ "kamennoyakata",		"仮面の館" }, // Kamen no Yakata
	{ "karuta",				"「フ・ジ・ワ・ラ・テ・イ・カ」の百人一首: かるたでおじゃる" },	// "Fu Ji Wa Ra Te I Ka" no Hyakunin Isshu: Karuta de Ojaru
	{ "katsumadojo",		"信光の勝馬道場" },
	{ "kazuyakun",			"数ヤ君" },
	{ "kenji",				"Kenji" },
	{ "keroncuel",			"ウルトラリゾート ケロンキュール" },											// Ultra Resort Keroncuel
	{ "kidsbox",			"Kids Box" },										// キッズボックス
	{ "kishido",			"棋士道" },											// Art of Shogi (Go)
	{ "lzone",				"L-ZONE" },
	{ "macaroni",			"マカロニほうれん荘 Interactive" },					// Romaji title in manual is Macaroni Hourensou
	{ "macrotv",			"MACRO-TV" },
	{ "mamauta1",			"ママうたおう! 第一巻みんなともだち" }, // Mama Utaou: Daiikkan Minna Tomodachi
	{ "maria",				"MA-RI-A 人形館の呪い" },
	{ "marinefantasy",		"大方洋二の海中写真館 Marine Fantasy" },
	{ "mecadrill",			"Mecadrill" },
	{ "mipeterwolf",		"～Music Island Vol.1～　\"ピーターと狼\"" },
	{ "missihb",			"MISS Interactive Hard Boiled" },
	{ "momotaro",			"日本語探検シリーズ『方言ももたろう』" },			// Nihongo Tanken Shirīzu: Hōgen Momotarō
	{ "moworld",			"Reiko's Adventures in MO-World" },
	{ "mukashibanashi",		"日本昔話" },										// Nihon Mukashi Banashi (Japanese Folk Tales)
	{ "multiakindo",		"マルチあきんど" }, // Multi Akindo
	{ "murphystv",			"Murphy's TV" },
	{ "negi1",				"ねぎ Vol. 1" }, // Negi
	{ "negi3",				"ねぎ3世" }, // Negi the 3rd
	{ "nemurenu",			"眠れぬ夜の小さなお話" }, // A Small Story on a Sleepless Night
	{ "nihonchiri",			"Visual日本地理" },									// Japan Geography
	{ "niningashi",			"ににんがし" },
	{ "noahsark",			"Noah's Ark" },
	{ "nonta",				"のんたくんとゆかいななかまたち" },					// Nonta-kun and his Wonderful Friends
	{ "novacity",			"Nova City" },
	{ "orgotto",			"Orgotto" },
	{ "osaka1",				"必修大阪弁集中講座I 2010年、標準語は大阪弁になる" }, // Hisshu Osaka-ben shuchu koza (Mandatory Osaka Dialect)
	{ "osaka2",				"必修大阪弁集中講座II 2015年、東京人の逆襲" },		// Tokyoites Strike Back
	{ "overringunder",		"Over-Ring-Under"},
	{ "pantosstory",		"Pantos Story"},
	{ "pasosuke",			"ぱそすけ"},
	{ "peaceland",			"PeaceLand" },
	{ "peepeebonbon",		"Pee Pee Bon Bon"},
	{ "phantplanet",		"アミューズメント プラネット ファンタスマゴリア" },	// Amusement Planet Phantasmagoria
	{ "phibos",				"フィボス ～彗星を追って～" },	// Phibos: Following the Comet
	{ "picklesbook",		"Pickle's Book" },
	{ "pinkgear",			"Pink Gear Collection" },
	{ "pinkgear2",			"Pink Gear 2" },
	{ "planetdob",			"Planet Dob" },
	{ "poporon",			"PoPoRon" },
	{ "popup",				"Pop Up Computer" },
	{ "popupmaker",			"Pop Up Maker" },
	{ "prescue",			"パラダイス レスキュ" },							// Paradise Rescue
	{ "pukapukarei",		"綾波育成計画 ぷかぷかレイちゃん" },					// Ayanami Ikusei Keikaku: Puka Puka Rei-chan
	{ "putlestory",			"Putlestory"},
	{ "pyramidint",			"Pyramid Interactive" },
	{ "racingdays",			"Racing Days" },
	{ "rad1",				"RAD (Volume One)" },
	{ "refixion1",			"Refixion" },
	{ "refixion2",			"Refixion II: Museum or Hospital" },
	{ "refixion3",			"Refixion III トナカイストーリー" },				// Refixion III: Tonakai Story
	{ "renderorgan",		"RenderOrgan" },
	{ "rheingold",			"ラインの黄金" },									// Das Rheingold
	{ "rolypolys",			"ローリーポーリーズの七転び八起き" },
	{ "rolypolys2",			"ローリーポーリーズの世界旅行" },
	{ "ronron",				"ゆけゆけロンロン!" },								// Yuke Yuke Ron Ron!
	{ "sabotenman",			"The Saboten Man" },
	{ "sakin2",				"砂金II" },										// Sakin II
	{ "sakuratoasobo",		"さくらとあそぼ" },								// Let's Play with "SAKURA"!
	{ "schoolworld",		"A-L: Artificial Life: School World" },
	{ "seesawc1",			"SeesawC1" },
	{ "smallhouse",			"Small House" },
	{ "startover",			"Start Over ROM" },
	{ "tantei",				"完全探偵マニュアル" },								// Perfect Detective Manual
	{ "tenroutoshi",		"天楼都市 傀儡達の静宴" },								// Tenrou Toshi: Kairaitachi no Seien
	{ "tetsuman",			"ハイ! 鉄マン です" },								// Hai! Tetsuman Desu
	{ "tetsumangaiden",		"鉄マン外伝 ゲーム大王の野望" },						// Tetsuman Gaiden: Game Daiou no Yabou
	{ "timegal",			"Time Gal" },
	{ "tokimemotype1",		"ときめきメモリアルタイピング" },					// Tokimeki Memorial Typing
	{ "tokimemotypegs",		"ときメモGSタイピング" },							// Tokimemo GS Typing (Girl's Side)
	{ "truegolf1",			"TrueGolf Part I" },
	{ "ttw",				"Through the Window: In Search for the Lost Bag" },
	{ "twinbeeparadise",	"ツインビーPARADISE in どんぶり島" },				// TwinBee Paradise in Donburi Shima
	{ "twistynight1",		"Twisty Night #1 合わせ月の夜" },
	{ "twistynight2",		"Twisty Night #2 フェンネル" },
	{ "twistynight3",		"Twisty Night #3 いにしえびと" },
	{ "ukiuki1",			"ウキウキ釣り天国 ～幻の天狗池～" },				// Ukiuki Tsuri Tengoku: Maboroshi no Tenguchi (Fishing)
	{ "ukiuki2",			"ウキウキ釣り天国2 ～波止の五目釣り～" },		// Ukiuki Tsuri Tengoku 2: Namitome no Gomokuzuri
	{ "ukiuki3",			"ウキウキ釣り天国3 ～人魚島のボート釣り～" },		// Ukiuki Tsuri Tengoku 3: Ningyo-tou no Boutozuri
	{ "ukiukiitsudemo",		"ウキウキ釣り天国 ～いつでもどこでも海釣り三昧～" },		// Ukiuki Tsuri Tengoku: Itsudemo Dokodemo Umitsuri Zanmai
	{ "ukiukistamp",		"うきうきスタンプ" },
	{ "ukyo1",				"うきょー1" },
	{ "ursaminorblue",		"銀河の魚 URSA minor BLUE" },				// Galaxy Fish: Ursa Minor Blue
	{ "victorianpark",		"Victorian Park" },
	{ "void",				"VOID" },
	{ "vvs",				"Virtual Variety Show" },
	{ "wackyraces",			"チキチキマシン猛レース ケンケンとブラック魔王のイジワル大作戦 Wacky Races" }, // Chiki Chiki Machine Mou Race: Kenken to Black Maou no Ijiwaru Daisakusen - Wacky Races
	{ "wariwari",			"わりわりワールド" },								// Wari Wari World
	{ "wbz",				"ウォーンバスター零" },							// Warn Buster Zero
	{ "wrestlelife",		"レッスルライフ プロレス カードゲーム" },			// Wrestle Life: Pro Wrestling Card Game
	{ "xaxa",				"XAXA MACHINE" },
	{ "ybr2",				"イエロー・ブリック・ロードII" },
	{ "ybr3",				"Yellow Brick Road ハラペコ月と星あつめ" },		// Yellow Brick Road: Harapeko Tsuki to Hoshi Atsume
	{ "yoidon",				"よ〜いドン!" },									// Yo-i Don!
	{ "yoshimotogeino",		"吉本芸能整形" },									// Yoshimoto Geino Seikei
	{ "zaibatsu",			"財閥銀行" },										// Zaibatsu Bank

	// Japanese art and multimedia reference
	{ "a5tours",			"A5 Tours: Special Data Library" },
	{ "americaodan",		"America Ōdan Ultra Quiz Dai 1-dan" }, // アメリカ横断ウルトラクイズ(第１弾)
	{ "americaodan2",		"America Ōdan Ultra Quiz ct.II Fukuzawa Anna-hen" }, // アメリカ横断ウルトラクイズｃｔ.II 福澤アナ編
	{ "anony",				"Anony" },
	{ "aumhodozenkiroku",	"「オウム」報道全記録 1989〜1995" }, // All Aum Coverage, 1989-1995
	{ "allthelunar",		"オール・ザ・ルナ LUNAR -ハイパーアプリケーションズ-" }, // All the Lunar: Hyper Applications
	{ "angelolatrie",		"Jean Cocteau: Angélolatrie & Phénixologie" },
	{ "aozoragaho",			"青空画報" }, // Blue Sky Pictorial
	{ "aquaplanet",			"Aquaplanet" },
	{ "aquazone",			"Aquazone" },
	{ "asylum300",			"Asylum 300" },
	{ "atmos",				"Atmos Tetsujin Re-Mix" }, // Bundled with the Windows/Mac release of Tetsujin Returns, aka Iron Angel of the Apocalypse: The Return
	{ "bakavideodrug",		"バカビデオドラッグ" }, // Baka Video Drug
	{ "chunchunworld",		"Chun-Chun World" },
	{ "clockkero",			"ケロ時計" },
	{ "clocksakura",		"さくら時計" },
	{ "clocktomoyo",		"知世時計" },
	{ "curiocity",			"キュリオシティ" },
	{ "cdromfanmacworld96",	"CD-ROM Fan MacWorld Expo Tokyo '96 Special Edition " },
	{ "ddoa",				"どきどき ON AIR ドラマシリーズ" },						// Doki Doki On-air Drama Series
	{ "delaware",			"Delaware: Catalog of Artoon" },
	{ "delphinokioku",		"デルフォイの記憶" },						// Delphi Memory
	{ "digitalgips3",		"Digital GIPS Vol. 3" },
	{ "doshifunspecial",	"Doshi-Fun Special" },
	{ "dothereggae",		"Do the Reggae" },
	{ "doubutsushokai",		"どうぶつ紹介ﾌﾟﾛｼﾞｪｸﾀ" }, // Animal Introduction Projector, Inuchan-related demo
	{ "ebisu",				"カンタンな人生の法則" }, // Yoshikazu Ebisu's Easy Laws of Life
	{ "eguchi",				"江口寿史 CG MUSEUM" },								// Hisashi Eguchi
	{ "fantasystudio",		"Fantasy Studio" }, // RPG Maker-style creation toolkit
	{ "fototune",			"FotoTune Multimedia Show" },
	{ "fukuda",				"Fukuda Shigeo Retrospective Collection" },
	{ "fukuokagoround",		"Fukuoka Go-Round" },
	{ "furbydentaku",		"ファービー電卓" },								// Furby Calculator
	{ "futarinoryori",		"ふたりの料理物語" },								// A Tale of Two Chefs
	{ "futurepromotion",	"Towa Tei: Future Promotion" },
	{ "gasbook",			"GASBOOK" },
	{ "gasbook2",			"GASBOOK 002" },
	{ "gasbook3",			"GASBOOK 3" },
	{ "gasbook4",			"GASBOOK vol. 4: Gas City" },
	{ "gasbook5",			"GASBOOK 5: Paradise" },
	{ "gasbook6",			"GASBOOK 6" },
	{ "gasbook7",			"GASBOOK 7" },
	{ "gasbook8",			"gasbook8" },
	{ "gecrs",				"GECRS - Guitar Education CD-ROM System" }, // By Takaaki Yonemochi
	{ "glassyocean",		"Glassy Ocean: original graphics & music" },
	{ "goalrush1",			"Goal Rush!!" },
	{ "goalrush2",			"Goal Rush!! 2 ～戦術分析編～" },
	{ "heididentaku1",		"ハイジ電卓１" },
	{ "heididentaku2",		"ハイジ電卓２" },
	{ "heididentaku3",		"ハイジ電卓３" },                                   // Heidi Calculators
	{ "heidimail",			"Heidi グリーティングメールカード" },               // グリーティングメールカード (Greeting Mail Card)
	{ "heidislide",			"Heidi スライドショー" },                           // Slideshow
	{ "hibino",				"Katsuhiko Hibino Interactive Exhibition" },
	{ "humanbody",			"The Human Body" },
	{ "illustratorsamerica","Illustrators in America" },
	{ "inuchanvalentine",	"いぬちゃんバレンタイン" }, // Inuchan Valentine
	{ "inuchanfighter",		"いぬちゃんファイタ−" }, // Inuchan Fighter
	{ "inuchanmovieparody",	"デジタルまんが いぬちゃん ナチュラルボーンクラーズ" }, // Digital Manga Inuchan: Natural Born Killers
	{ "japanart04",			"Japan Art Today 04" },
	{ "japanart07",			"Japan Art Today 07 村上隆「ロマンスの夕べ」展" }, // Japan Art Today 07: Takashi Murakami - "Romantic Evening" Exhibition
	{ "japanart14",			"Japan Art Today 14 岡崎京子" }, // Japan Art Today 14: "Kyoko Okazaki" First Exhibition in P-House Project Room
	{ "jinseiproresu",		"人生プロレス" }, // Life Pro Wrestling
	{ "keiri",				"経理入門" },										// Introduction to Accounting
	{ "llla",				"Live Love Life AIDS" },
	{ "mazebox",			"The Latest Works of MazeBox" },
	{ "macintosho20",		"村上隆" }, // Macintosho exhibit disk #20 - Takashi Murakami's Hiropon
	{ "microphonefiend",	"Microphone Fiend" },
	{ "mmedia11",			"Masters of Media: The Making of サクラ大戦" },			// Sakura Taisen
	{ "moderntimes",		"Charles Chaplin in Modern Times" },
	{ "mominoki",			"もみの木の下で ～ The Day of St.Claus" },			// Under the Fir Tree
	{ "monja",				"monja" },										// もんじゃ
	{ "morisawa",			"人間と文字" }, // Man and Writing
	{ "moritaka",			"森高千里 CD-ROM 渡良瀬橋" },
	{ "msseifuku",			"ミッションスクール制服図鑑" },			// Mission School Seifuku Zukan
	{ "musicforliving",		"Music for Living Sound" },
	{ "ngeeva00pf",			"Neon Genesis Evangelion: EVA-00 Paper Figure" },
	{ "no",					"NO" },
	{ "nycalling",			"N.Y. Calling" },
	{ "oceansbelow",		"Oceans Below" },
	{ "pbdisplay",			"PerfectBLUE DISPLAY" },
	{ "pbflash",			"PerfectBLUE FLASH" },
	{ "pbmima",				"PerfectBLUE MIMA" },
	{ "pbosakana",			"PerfectBLUE OSAKANA" },
	{ "pbtoilet1",			"PerfectBLUE TOILET1" },
	{ "pbtoilet2",			"PerfectBLUE TOILET2" },
	{ "panicook",			"PANICOOK" },
	{ "pepperon",			"ペペロン村の四季" },			// Four Seasons in Pepperon Village, aka Valmaison au fil des saisons, aka Livet i Pepperon
	{ "perfectblue",		"Perfect Blue そらいろ★ナイト" },
	{ "please",				"Please!" }, // by Teruo Takashima
	{ "pod1",				"POD: Super Pop Digital Magazine" },
	{ "pod3",				"POD: Super Pop Digital Magazine Vol. 3" },
	{ "pod4",				"POD: Super Pop Digital Magazine Vol. 4" },
	{ "pod5",				"POD: Super Pop Digital Magazine Vol. 5" },
	{ "pod6",				"POD: Super Pop Digital Magazine Vol. 6" },
	{ "pod7",				"POD: Super Pop Digital Magazine Vol. 7" },
	{ "pod8",				"POD: Super Pop Digital Magazine Vol. 8" },
	{ "pod9",				"POD: Super Pop Digital Magazine Vol. 9" },
	{ "previewreprise",		"Preview & Reprise: Haruhiko Shono" },
	{ "pyrethrum1",			"除虫菊Vol.1" },
	{ "randomdot",			"Random Dots" },
	{ "sailormoonart",		"美少女戦士セーラームーン CD-ROM原画集" }, // Pretty Soldier Sailor Moon CD-ROM Art Collection
	{ "sakurascr",			"さくらのSCRセレクタ" },							// Sakura's SCR Selector
	{ "satodesign",			"The Art of Computer Designing: A Black and White Approach" },
	{ "satohomosexual",		"Homosexual" },
	{ "sculpt4d",			"Sculpt 4D" },
	{ "shinshofukei",		"心象風景" }, // Psychological Landscape
	{ "spawncollection",	"Spawn Figure Collection for Windows 95" },
	{ "srdsunrise",			"スーパーロボット伝説 東北新社・サンライズロボット編" },  // Super Robot Densetsu: Touhokushinsha Sunrise Robot-hen
	{ "ssheidi1",			"Heidi スクリーンセーバー 1" },
	{ "ssheidi2",			"Heidi スクリーンセーバー 2" },
	{ "sskero",				"ケロ Screen Saver" },
	{ "sssakura",			"さくら Screen Saver" },
	{ "ssyamazaki",			"山崎君 Screen Saver" },							// Yamazaki-kun
	{ "ssyukito",			"雪兎さん Screen Saver" },							// Yukito-san
	{ "syzygys",			"SYZYGYSｸﾘｯｸｱﾆﾒ｢ｽﾓｳ組曲｣" }, // Syzygys Click Animation "Sumo Suite", by Hideki Nakazawa
	{ "tokon5",				"闘魂V: 長州 力" },									// Fighting Spirit V: Riki Choshu
	{ "tomato",				"To. Ma. To." },
	{ "tree",				"Onyx Tree Pro" },
	{ "tri3dtrial",			"Tri-3D-Trial" },
	{ "ukiukibgv",			"ウキウキ釣り天国 BGV" },							// Background Video? (Screen Saver)
	{ "undergroundaz",		"Underground AtoZ SO OUT" },
	{ "vcb",				"Virtual Cocktail Bar 200種類のカクテルのデータベース" },
	{ "vcbe",				"Virtual Cocktail Bar Executive" },
	{ "virtualmuseum",		"Virtual Museum" },
	{ "xmaspresent",		"Christmas Present" },
	{ "yokaanime18",		"よかアニメ18発！" }, // 18 Screwy Animations!
	{ "yokai",				"真・百物語: 妖怪紳士録" },                         // Ma hyakumonogatari: Yōkai shinshiroku
	{ "yokai200",			"水木しげるの妖怪図鑑 傑作200選 -日本編1" },        // Mizuki Shigeru no Yokai Zukan Kessaku 200-sen Nihon-hen 1
	{ "yokai400",			"水木しげるの妖怪図鑑 傑作400選 -日本編2" },        // Mizuki Shigeru no Yokai Zukan Kessaku 400-sen Nihon-hen 2
	{ "yokaizukan",			"妖精妖怪図鑑" },                                   // Fairy Yōkai Encyclopedia
	{ "yumemirukairo",		"「夢みる廻廊」所幸則フルカラーミュージアムCD-ROM" }, // Gallery of Dreams
	{ "zuiyomail",			"ZUIYO グリーティングメールカード" },               // グリーティングメールカード (Greeting Mail Card)

	// Japanese product demos
	{ "backgrounds",		"Backgrounds for Multimedia Series" },
	{ "bakkunooni",			"VOLT-AGE バックの鬼 -侘-" },						// Back Demon (texture packs)
	{ "bandaipreviews3",	"1995 Bandai Visual CD-ROM Previews かわら盤 Vol. 3" },
	{ "bebox",				"BeBox" },
	{ "businessmanager",	"琢磨 BusinessManager" },							// from Takuma Co.
	{ "calling",			"Calling" },
	{ "cnl",				"City Net Line" },
	{ "creativeeye",		"Creative EYE" },
	{ "fontfriends",		"フォントフレンズ" },
	{ "greetingstudio",		"Greeting STUDIO" },
	{ "hypercardlessons",	"HyperCard Lessons" },
	{ "hypermaterial",		"Hyper Material" },
	{ "imgimpact",			"Images with Impact!" },
	{ "inposition",			"INposition" },
	{ "intelligentnote",	"インテリジェントノート" },
	{ "inuchancd",			"いぬちゃんのうたＣＤデモ" }, // Inuchan's Song CD Demo - promoting the CD single released by "Doubutsu Band Meets Reiko Chiba"
	{ "jointnet",			"JOINT-net" },
	{ "koyosha",			"Koyosha CD-INSPIREシリーズ" },
	{ "kpt",				"Kai's Power Tools for Photoshop" },
	{ "macbasic",			"MacBASIC: Learning BASIC on HyperCard" },
	{ "maczaurus",			"Sharp Mac-Zaurus" },
	{ "negishihomes",		"Negishi Homes 建築見積ｿﾌﾄ" },					// Architectural Quote Software
	{ "nsxpress",			"Honda NSX Press CD-ROM" },
	{ "olnet",				"Open Library" },
	{ "picturecard",		"絵カード訓練システム" },						// Picture Card Training System
	{ "pipcatalog",			"PiPPiN Title CD-ROM Catalog" },
	{ "presenpack",			"Director PresenPack" },
	{ "pressit",			"PRESSiT" },
	{ "provektor2",			"Provektor II: Design & Image Library" },
	{ "provektor3",			"Provektor III: Design & Image Library" },
	{ "provektormed",		"Provektor Media" },
	{ "scripting",			"Macromedia Director Lingo Scripting Technology" },
	{ "secretsafari",		"Secret Safari" },
	{ "shadeviewer",		"Shade Viewer" },
	{ "sozaijiten",			"素材辞典" },									// Datacraft Materials Dictionary (texture packs)
	{ "strata",				"Strata Studio Pro" },
	{ "toeic",				"PowerTOEIC" },
	{ "toonet11",			"TooNet11" },
	{ "trans",				"Trans' ～僕とあたしの境界線～" }, // Trans': The Boundary Between Me and You
	{ "transland",			"トランスランド" },
	{ "wonderompm",			"アルダスページメーカー4.5J速習用CD-ROM" },		// CD-ROM for Quick Study of Aldus PageMaker 4.5J
	{ "wonderomcw",			"WONDEROM クラリスワークス" },					// WONDEROM ClarisWorks ver.2
	{ "voyagerkids",		"ボイジャーのキッズ CD-ROM" },

	// Norwegian titles
	{ "norgesjakten",		"Norgesjakten" },

	// Polish titles
	{ "kontyngent99",		"Katalog Samochodów Kontyngent '99" },

	// Portuguese titles
	{ "almabril98",			"Almanaque Abril 1998" },
	{ "bigmax",				"Revista BigMax" },
	{ "bpapao",				"A Turma do Bicho-Papão" },
	{ "divertire",			"Revista Divertire" },
	{ "irpf2002",			"Tutorial do IRPF 2002" },
	{ "kinderkit",			"Kinder-Kit" },
	{ "lobomau",			"As Histórias do Lobo Mau" },
	{ "objetivo",			"Astrologia e Geografia Objetivo" },
	{ "ratinho",			"Programa do Ratinho" },

	// Russian titles
	{ "engl",				"English for Beginners" },
	{ "max1max2",			"Макс демонстрация" },                         // Max (Tivola) demos of the first two games
	{ "plcd",				"Подводная Лодка" },						   // Podvodnaya Lodka (Submarine) magazine
	{ "pyatachok1",			"Пятачок и разные звери" },					   // Pong-Pong's Learning Adventure: The Animals
	{ "pyatachok2",			"Пятачок в Волшебном Лесу" },				   // Pong-Pong's Learning Adventure: Insects and Plants
	{ "pyatachok3",			"Пятачок в Затерянном мире" },				   // Pong-Pong's Learning Adventure: The Lost World
	{ "pyatachok4",			"Пятачок: Назад в будущее" },				   // Pong-Pong's Learning Adventure: Back to the Future
	{ "pyatachok5",			"Пятачок сдает экзамен по Анатомии" },		   // Pong-Pong's Learning Adventure: Mysteries of Human Body
	{ "tchaik",				"Пётр Ильи́ч Чайко́вский: Жизнь и творчество" }, // Pyotr Ilyich Tchaikovsky: Life and Work
	{ "tutti",				"Волшебные истории Тутти" },				   // Tutti's Magical Stories

	// Spanish titles
	{ "123habloingles",		"1·2·3 Hablo Inglés" },
	{ "abrapalabra",		"Abrapalabra: La Magicia de Aprender a Leer" },
	{ "clasplusbee2",		"Classical Plus: Ludwig van Beethoven" },	// Planeta DeAgostini, a Spanish-Italian company based in Barcelona
	{ "deportes",			"Deporte y Musculación" },
	{ "eso",				"ESO Essentials: Student's Interactive CD-ROM" },
	{ "inventos",			"Grandes Inventos" },
	{ "pcplus64",			"PC Plus Super CD 64" },
	{ "supermente",			"Super Mente" }, // Published only in Mexico
	{ "unlimitedcl",		"Unlimited CD-ROMs Educativos" },

	// Swedish titles
	{ "alfons",				"Alfons Åberg ”Bara Överallt!”" },
	{ "acneattack",			"Acne-Attack!" },
	{ "backpacker2",		"Backpacker 2" },							// Other games listed under English
	{ "backpackerjrdiy",	"BackPacker Junior - Do-It-Yourself" },
	{ "balticmission",		"Baltic Mission" },
	{ "ernie",				"Ernie: Broke in Bayonne" },
	{ "garygadget2",		"Bygg båtar med Mulle Meck" },              // First game listed under English
	{ "garygadget3",		"Bygg flygplan med Mulle Meck" },
	{ "garygadget4",		"Bygg hus med Mulle Meck" },
	{ "garygadget5",		"Upptäck rymden med Mulle Meck" },
	{ "historia",			"Svensk historia: från asatro till frihetskrig år 800-1500" },
	{ "jonssonligan1",		"Jönssonligan: Jakten på Mjölner" },
	{ "jonssonligan2",		"Jönssonligan går på djupet" },
	{ "mumin1",				"Kurragömma med Mumintrollen" },
	{ "onsalakorv",			"Onsalakorv" },
	{ "pettson1",			"Pettson o Findus i snickarbon" },
	{ "pettsonjk",			"Pettson o Findus julkalender" },
	{ "pettson2",			"Pettson & Findus i trädgården" },
	{ "pettsonjs",			"Pettsons julspel" },
	{ "pettson3",			"Pettson o Findus och mucklornas värld" },
	{ "pettson4",			"Pettson & Findus Spökskrämmarmaskinen" },
	{ "polis1",				"Polis" },
	{ "polis2",				"Polis 2: Någon ljuger" },
	{ "polis3",				"Polis 3: Vargspår" },
	{ "requiem",			"Requiem: en mordgåta på 1600-talet" },
	{ "rymdjakten",			"Rymdjakten" },
	{ "trazanbanarne",		"Trazan & Banarne - Speltajm" },
	{ "xtown1",				"CrossTown: Giftet" },
	{ "xtown2",				"CrossTown: Ängeln" },

	// Chinese titles
	{ "ypl2", 				"勇者泡泡龍2" },							// Yongzhe Paopao Long 2, aka Brave Bubble Dragon 2, aka Bubble Hero 2
	{ "creativenursery",	"创意学前华丈(一)" },						// Creative Nursery Chinese

	// Titles containing Director extras
	{ "amgpremiere",		"The American Girls Premiere" },
	{ "darylfgates",		"Police Quest Q&A with Daryl F. Gates" },
	{ "dcanyoncd",			"Dino CD Audio Player" },
	{ "freeallangels",		"Ash: Free All Angels Video Mixer" },
	{ "klingonlab",			"Klingon Language Lab" },
	{ "lbfamfun",			"Little Bear Family Fun" },
	{ "mousepractice",		"Mouse Practice" },	// from At Ease, disk 2
	{ "picarddossier",		"Mini-Omnipedia: Picard Dossier" },
	{ "poliq",				"Political IQ Test" },
	{ "pqmakingof",			"The Making of Police Quest" },
	{ "scissorsnstones",	"Scissors N Stones On-Line Manual" },
	{ "solmahjong",			"Solitudes Mahjong Game" },
	{ "superbowltrivia",	"Super Bowl Trivia Game" },
	{ "thinkinthingsdp",	"Dear Parents: About Thinkin' Things..." },
	{ "ultrobotkit",		"Robotoid Assembly Toolkit" },
	{ "ultrobotss",			"Screen Saver Viewer" },
	{ "williamsbts",		"Williams Arcade Classics: Behind the Scenes" },

	// DVD-ROM bonus content
	{ "planetrav",			"Planetary Traveler" },

	// Other products using VideoWorks or Director movies only
	// Examples are HyperCard, Authorware, and Microsoft Reference
	{ "encarta94",			"Microsoft Encarta '94" },
	{ "encarta95",			"Microsoft Encarta '95" },
	{ "encartaatlas2000",   "Microsoft Encarta Interactive World Atlas 2000" },
	{ "exoticjapan",		"Exotic Japan: A Guide to Japanese Culture and Language" },
	{ "famdoc3",			"The Family Doctor, 3rd Edition" },
	{ "macworldexpo92",		"Macworld Expo CD Boston 1992" },
	{ "manhole",			"The Manhole" },
	{ "mazebrew",			"MazeBrew" },
	{ "mazewars",			"Maze Wars+" },
	{ "mmmozart",			"Multimedia Mozart: The Dissonant Quartet" },
	{ "mmschubert",			"Multimedia Schubert: The \"Trout\" Quintet" },
	{ "osmo",				"Cosmic Osmo and the Worlds Beyond the Mackerel" },
	{ "shatter",			"Shatter by Mike Saenz" },
	{ "spelunx",			"Spelunx and the Caves of Mr. Seudo" },
	{ "stravinsky",			"Igor Stravinsky: The Rite of Spring" },

	// Magazines and periodicals
	{ "blender",			"Blender: The Pop Culture Magazine on CD-ROM" },
	{ "blenderbest",		"Best of Blender: The Interactive Entertainment Magazine" },
	{ "cmi",				"Computer Music Interactive" },
	{ "gamingmegapac",		"MacUser Presents Gaming MegaPac" },
	{ "godigital",			"Go Digital Interactive Magazine" },
	{ "insidemacgames",		"Inside Mac Games" },
	{ "interactivemagic",   "MacUser Mac Interactive Magic" },
	{ "iwave",				"Interactive Wave" },
	{ "maccubed",			"MacCubed³" },
	{ "macsca",				"Mac S.C.A. Magazine" },
	{ "macweekvideo",		"MacWEEK Guide to Desktop Video" },
	{ "mieuxmieux",			"Le CD-ROM Mac Mieux-Mieux" },
	{ "mindvirus",			"Mindvirus" },
	{ "mobiclic",			"Mobiclic" },
	{ "pcformat",			"PC Format" },
	{ "pcwuk",				"Personal Computer World" },
	{ "stream",				"Digital Culture Stream Magazine" },

	// Promos and catalogues
	{ "aaha2007",			"AAHA! Denver 2007: It's Different Here!" },	// American Animal Hospital Association
	{ "adamcatalog",		"The A.D.A.M. 1994 Catalog" },
	{ "adamscholar",		"The A.D.A.M. Scholar Series" },
	{ "applestore",			"Apple Company Store" },
	{ "aptesampler",		"APTE Product Sampler" },
	{ "arcmedia",			"Arc Media Demos" },
	{ "aromeinteractive",	"Arome Interactive Sampler" },
	{ "bestservice",		"Best Service Soundware Company Presentation" },  // from CD-ROM Now issue #7 '94
	{ "blaster",			"Blaster Series Demo" },
	{ "bpmc",				"Byron Preiss Multimedia Catalog" },
	{ "cmc",				"Creative Multimedia Catalog" },
	{ "compuserve",			"CompuServe Demo" },
	{ "coreltour",			"Corel Product Tour" },
	{ "davidsonpp",			"Davidson Product Previews" },
	{ "davidsonps",			"Davidson Product Sampler" },
	{ "dewarswl",			"DeWar's \"White Label\"" },
	{ "disneyint",			"Disney Interactive presents Learning & Creativity Sampler Volume I" },
	{ "disneylearning",		"Disney Interactive Learning Sampler" },
	{ "dkmm2",				"Dorling Kindersley Multimedia Sampler Disc 2" },
	{ "edmark",				"Edmark Demo" },
	{ "emme",				"E.M.M.E. Interactive: The Keys to Knowledge" },
	{ "eureka",				"Eureka Multimedia Promo" },
	{ "fppuddlebooks",		"Fisher-Price Read & Play: Puddle Books Demos" },
	{ "fpready",			"Fisher-Price Ready for School Demo" },		// General preview for Ready for School series. Does not correspond to a specific game.
	{ "grolier",			"Grolier Products" },
	{ "gusbuds",			"Gus and the CyberBuds Learning Adventure Series" },
	{ "headbone",			"Headbone CD-ROM Sampler" },
	{ "hoffman",			"H+a Collection" },
	{ "housejam",			"HouseJam - An excerpt from Meet MediaBand" },
	{ "ilearn",				"iLearn" },
	{ "imagineers",			"The Imagineers" },
	{ "imaginopolis",		"Microsoft Imaginopolis" },
	{ "incoming",			"iNCOMING" },
	{ "iona",				"Iona Software Demo CD" },
	{ "ipc",				"About InterActive Publishing" },
	{ "jsa",				"JumpStart Advanced: How Does Your Child Learn Best?" },
	{ "jslearn",			"JumpStart Learning System" },
	{ "kidtools",			"Kid Tools Series Demo" },
	{ "learningsystem",		"The Learning System" },
	{ "maxissampler",		"Maxis CD-ROM Sampler" },
	{ "mcdonaldland",		"Mission to McDonaldland" },    // Promo game distributed by McDonald's fastfood chain (AU/NZ only)
	{ "msgfromapple",		"Message from Apple" },
	{ "newton",				"World of Newton" },
	{ "optimumrsrc",		"Optimum Resource Sampler" },
	{ "origin",				"Origin Systems Product Catalog" },
	{ "playskool",			"Playskool Software Experience CD-ROM Sampler" },
	{ "poohlearn",			"Disney Learning Winnie the Pooh Demos" },
	{ "rh",					"Rescue Heroes Demo" },
	{ "sfk",				"Science for Kids Product Demos" },
	{ "sonywalkman",		"Sony Walkman PRD-155SB / PRD-150" },
	{ "tlc",				"The Learning Company Sampler" },
	{ "ubt",				"Under the Big Top" },
	{ "vygrpresents",		"Voyager Presents" },
	{ "wti",				"Workstation Technologies Inc: The Digital Video Company" },

	// Promos for Non-Director titles
	{ "3datlas97",			"3D Atlas 97" },
	{ "3datlas98",			"3D Atlas 98" },
	{ "adobedimensions",	"Professional Tips for Adobe Dimensions" },
	{ "agfa",				"AgfaType" },
	{ "aol",				"America Online" },
	{ "ataripack",			"Activision's Atari 2600 Action Pack" },
	{ "balto2",				"Balto II: Wolf Quest" },
	{ "baseballhits",		"Baseball's Greatest Hits"},
	{ "bcsinkfloat",		"Blue's Clues: Sink and Float" },
	{ "blockbuster2",		"Blockbuster Guide to Movies & Videos, 2nd Edition" },
	{ "blownaway",			"Blown Away" },
	{ "bobteam",			"Bob the Builder: Teamwork" },
	{ "bookshelf94",		"Microsoft Bookshelf '94" },
	{ "bookshelf95",		"Microsoft Bookshelf '95" },
	{ "c64pack",			"Activision's Commodore 64 15-Pack for Windows" },
	{ "cfdemo",				"The ClueFinders Demo" },
	{ "cinemania94",		"Microsoft Cinemania 94" },
	{ "cinemania95",		"Microsoft Cinemania 95" },
	{ "cinemania96",		"Microsoft Cinemania 96" },
	{ "clarisimpact",		"ClarisImpact" },
	{ "clarisworks",		"ClarisWorks" },
	{ "compton",			"Compton's Interactive Encyclopedia 1995 Edition" },
	{ "cpu",				"Connectix PowerBook Utilities" },
	{ "cricketdraw",		"CA Cricket Draw III" },
	{ "d",					"D" },
	{ "defendinghuman",		"Donald A. Norman: Defending Human Attributes in the Age of the Machine" },
	{ "dinosafari",			"Dinosaur Safari" },
	{ "dotsafe",			"Dotsafe" },
	{ "earthwormjim",		"Earthworm Jim" },
	{ "ephemeralfilms",		"Ephemeral Films: 1931-1961" },
	{ "exos",				"Exos PowerStick" },
	{ "explorapedia",		"Microsoft Explorapedia" },
	{ "eyewitnessscience",	"Eyewitness Encyclopedia of Science" },
	{ "famalbum",			"Family Album Creator" },
	{ "famdoc4",			"The Family Doctor, 4th Edition" },
	{ "freehand",			"Aldus FreeHand 2.0" },
	{ "geoquery",			"Odesta GeoQuery" },
	{ "greeneggs",			"Green Eggs and Ham" },
	{ "hollywoodhigh",		"Hollywood High" },
	{ "hoyle5",				"Hoyle Classic Games" },
	{ "hyperblade",			"HyperBlade" },
	{ "ideacomm",			"IDEAcomm Mac" },
	{ "iliad",				"Iliad" },
	{ "illustrator",		"Adobe Illustrator" },
	{ "it1d",				"In the First Degree" },
	{ "landdesigner",		"Sierra Land Designer" },
	{ "lbt8",				"The Land Before Time: The Big Freeze" },
	{ "leopardspots",		"How the Leopard Got His Spots" },
	{ "lion",				"Lion" },
	{ "lotus123",			"Lotus 1-2-3" },
	{ "macbasics",			"Macintosh Basics" },
	{ "macbeth",			"Macbeth" },
	{ "macos8",				"Mac OS 8" },
	{ "macportable",		"Your Apple Tour of the Macintosh Portable" },
	{ "mathblasterjr",		"Math Blaster Jr." },
	{ "mavisbeacon",		"Mavis Beacon Teaches Typing" },
	{ "mechwarrior2",		"MechWarrior 2" },
	{ "meetingmaker",		"Meeting Maker" },
	{ "mindbrain",			"The Lost Mind of Dr. Brain" },
	{ "mothergoosehires",	"Mixed-Up Mother Goose Deluxe" },
	{ "mousebasics",		"Mouse Basics" },
	{ "msaccess",			"Microsoft Access" },
	{ "msarcade",			"Microsoft Arcade" },
	{ "msartgallery",		"Microsoft Art Gallery" },
	{ "msautomap",			"Microsoft Automap Road Atlas" },
	{ "msbaseball",			"Microsoft Complete Baseball" },
	{ "msbasketball",		"Microsoft Complete Basketball" },
	{ "msbob",				"Microsoft Bob" },
	{ "mscomposers",		"Microsoft Illustrated Interactive Composer Series" },
	{ "msdangerous",		"Microsoft Dangerous Creatures" },
	{ "msdogs",				"Microsoft Dogs" },
	{ "msexcel",			"Microsoft Excel" },
	{ "msflight",			"Microsoft Flight Simulator" },
	{ "msfonts",			"Microsoft TrueType Font Pack" },
	{ "msgolf",				"Microsoft Golf" },
	{ "msmoney",			"Microsoft Money" },
	{ "msmouse",			"The Microsoft Mouse" },
	{ "msmouseh",			"Microsoft Home Mouse" },
	{ "msmusint",			"Microsoft Musical Instruments" },
	{ "msn",				"The Microsoft Network" },
	{ "msnatkey",			"Microsoft Natural Keyboard" },
	{ "msoffice",			"Microsoft Office" },
	{ "mspowerpoint",		"Microsoft PowerPoint" },
	{ "msproject",			"Microsoft Project" },
	{ "mspublish",			"Microsoft Publisher" },
	{ "mspublishd",			"Microsoft Publisher Design Packs" },
	{ "msschedule",			"Microsoft Schedule+" },
	{ "mssndbits",			"Microsoft SoundBits" },
	{ "msspaceflight",		"Microsoft Space Simulator & Microsoft Flight Simulator" },
	{ "msword",				"Microsoft Word" },
	{ "msworks",			"Microsoft Works" },
	{ "msbhumanbody",		"Scholastic's The Magic School Bus Explores the Human Body" },
	{ "msbsolarsystem",		"Scholastic's The Magic School Bus Explores the Solar System" },
	{ "mti",				"Muppet Treasure Island" },
	{ "musiccentral96",		"Microsoft Music Central 96" },
	{ "musicpublisher",		"Graphic Notes Music Publisher" },
	{ "netmarket",			"CUC netMarket Demo" },
	{ "nightsky",			"Night Sky Interactive" },
	{ "ofoto",				"Light Source Ofoto" },
	{ "onevolution",		"Stephen Jay Gould: On Evolution" },
	{ "orly",				"Orly's Draw-A-Story" },
	{ "pagemaker",			"Aldus PageMaker" },
	{ "panicpark",			"Panic in the Park" },
	{ "pitfall",			"Pitfall: The Mayan Adventure" },
	{ "powerchess",			"Power Chess" },
	{ "princeint",			"Prince Interactive" },
	{ "pspice",				"MicroSim PSpice" },
	{ "ramdoubler",			"RAM Doubler" },
	{ "raydream",			"Ray Dream Designer" },
	{ "readblasterjr",		"Reading Blaster Jr." },
	{ "redshift",			"RedShift: Multimedia Astronomy" },
	{ "rosettastone",		"The Rosetta Stone" },
	{ "santafe1",			"Santa Fe Mysteries: The Elk Moon Murder" },
	{ "shanghai",			"Shanghai: Great Moments" },
	{ "smashsounds1",		"Smash Sounds Volume 1" },
	{ "spycraft",			"Spycraft: The Great Game" },
	{ "statusmac",			"STATUS*Mac" },
	{ "system7smash",		"System 7 is a SMASH!" },
	{ "texturescape",		"Specular TextureScape" },
	{ "thetowerxmas",		"TOWER/CD ~Christmas Disc~" },
	{ "thisisspinaltap",	"This Is Spinal Tap" },
	{ "timelapse",			"Timelapse" },
	{ "trekfinalunity",		"Star Trek: The Next Generation - \"A Final Unity\"" },
	{ "ultrobot",			"Isaac Asimov's The Ultimate Robot" },
	{ "voyeur2",			"Voyeur 2" },
	{ "wep",				"The Best of Microsoft Entertainment Pack" },
	{ "windows31",			"Microsoft Windows 3.1" },
	{ "wfw31",				"Microsoft Windows for Workgroups 3.1" },
	{ "windows95",			"Microsoft Windows 95" },
	{ "worldatlas",			"World Reference Atlas" },
	{ "wpmainstreet",		"WordPerfect Main Street" },
	{ "wttf",				"Welcome to the Future" },
	{ "xfiles",				"The X-Files" },
	{ "znemesis",			"Zork Nemesis: The Forbidden Lands" },
	{ "zoombini",			"Logical Journey of the Zoombinis" },

	// Screen Savers
	{ "aslss",				"ASL ScreenSaver" },
	{ "barbssbubbles",		"Barbie Screen Styler: Bubbles" },
	{ "barbsskisses",		"Barbie Screen Styler: Kisses" },
	{ "barbssshoes",		"Barbie Screen Styler: Shoes" },
	{ "billetrille1ss",		"Bille & Trille 1 Screen Saver" },
	{ "cinemac",			"CineMac Screen Saver Factory" },
	{ "globiss",			"Globi's Bildschirmschoner" },
	{ "lewisclarkss",		"Lewis and Clark Screen Saver" },
	{ "nekojiruudonss",		"Nekojiru Udon Screen Saver" },
	{ "nightrider",			"Night Rider" }, // from "Now Fun!"
	{ "photos4us",			"Photos4us" },
	{ "pingufight",			"Pingu Snowball Fight" },
	{ "pingufish",			"Pingu Fish Chase" },
	{ "pinguss",			"Pingu Screen Savers" },
	{ "pingustorm",			"Pingu Snow Storm" },
	{ "pingustunt",			"Stunt Pingu" },
	{ "pingutime",			"Time for Pingu" },
	{ "ss007",				"The James Bond Screensaver" },
	{ "ss102dalmations",	"102 Dalmations Screen Saver" },
	{ "ssbeastie",			"Beastie Boys ScreenSaver" },
	{ "ssbudfranklouie",	"Budweiser: Frank & Louie Screen Saver" },
	{ "sscocacola",			"Coca-Cola Screen Saver" },
	{ "ssdietcoke",			"Diet Coke Screen Saver" },
	{ "ssgbi",				"German Bold Italic Screen Saver" },
	{ "sshercules",			"Hercules: The Legendary Journeys Screen Saver" },
	{ "sshighlander",       "Highlander: The Screen Saver" },
	{ "ssholidaymickey",	"Holiday Mickey Screen Saver" },
	{ "ssleepipes",			"The Lee Pipes Desktop Animated Feature" },
	{ "sslivepicture",		"Live Picture Screen Saver" },
	{ "ssnatureasart",		"Nature as Art" },
	{ "sspeekaboo",			"Winnie the Pooh Peek-a-Boo Screen Saver" },
	{ "ssrevwar",			"Revolutionary War Screen Saver" },
	{ "ssseven",			"Seven Screen Saver" },
	{ "tamafridgi",			"TamaFridgi" },

	// Press kits with Director content
	{ "bvi1997",			"Buena Vista International 1997 Promotional Interactive CD-ROM" },
	{ "bluesbros2000",		"Blues Brothers 2000 Full Promotion" },
	{ "easports2000",		"EA Sports 2000 (E3 1999)" },
	{ "hoaddams2",			"Hollywood Online: Addams Family Values" },
	{ "hoangus",			"Hollywood Online: Angus" },
	{ "hodolores",			"Hollywood Online: Dolores Claiborne" },
	{ "horobroy",			"Hollywood Online: Rob Roy: Legend of the Mist" },
	{ "hostargate",			"Hollywood Online: Stargate" },
	{ "hothenet",			"Hollywood Online: The Net" },
	{ "hotrekgens",			"Hollywood Online: Star Trek Generations"},
	{ "leepipes",			"Lee Pipes Press Kit" },
	{ "mulanpresskit",		"Mulan Multimedia Press Kit" },
	{ "stalker",			"S.T.A.L.K.E.R.: Shadow of Chernobyl" },
	{ "thesims",			"The Sims Electronic Press Kit" },
	{ "vug2005",			"Vivendi Universal Games 2005 E3 DPK" },
	{ "westwood",			"Westwood Studios Digital Press Kit 2000" },

	// Unknown (to sort)
	{ "planetearth",		"Planet Earth: The Story of Environmental Awareness" },
	{ "acaciarevise",		"Acacia's Revise Series" },
	{ "multimediastudio",	"The Multimedia Cartoon Studio" },
	{ 0, 0 }
};

namespace Director {

#define SUPPORT_STATUS ADGF_UNSTABLE

#define GENGAME1_(t,e,f,m,s,l,p,fl,v)				{ { t, e, AD_ENTRY1s(f, m, s), l, p, (fl | SUPPORT_STATUS), GUIO1(GUIO_NOASPECT) }, GID_GENERIC, v }
#define GENGAME1t_(t,e,f,m,s,l,p,fl,v)				{ { t, e, AD_ENTRY1s(f, m, s), l, p, (fl | SUPPORT_STATUS | ADGF_TAILMD5), GUIO1(GUIO_NOASPECT) }, GID_GENERIC, v }
#define GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,l,p,fl,v)	{ { t, e, AD_ENTRY2s(f1, m1, s1, f2, m2, s2), l, p, (fl | SUPPORT_STATUS), GUIO1(GUIO_NOASPECT) }, GID_GENERIC, v }
#define GENGAME2t_(t,e,f1,m1,s1,f2,m2,s2,l,p,fl,v)	{ { t, e, AD_ENTRY2s(f1, m1, s1, f2, m2, s2), l, p, (fl | SUPPORT_STATUS | ADGF_TAILMD5), GUIO1(GUIO_NOASPECT) }, GID_GENERIC, v }

#define MACGAME1(t,e,f,m,s,v)	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformMacintosh,ADGF_MACRESFORK,v)
#define MACGAME1t(t,e,f,m,s,v)	GENGAME1t_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformMacintosh,ADGF_MACRESFORK,v)
#define PIPGAME1(t,e,f,m,s,v)	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformPippin,ADGF_MACRESFORK,v)
#define WINGAME1(t,e,f,m,s,v)	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformWindows,ADGF_NO_FLAGS,v)
#define WINGAME1t(t,e,f,m,s,v)	GENGAME1t_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformWindows,ADGF_NO_FLAGS,v)
#define FMTGAME1(t,e,f,m,s,v)	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformFMTowns,ADGF_NO_FLAGS,v)
#define SHKGAME1(t,e,f,m,s,v)	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformShockwave,ADGF_NO_FLAGS,v)
#define MACDEMO1(t,e,f,m,s,v)	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformMacintosh,(ADGF_MACRESFORK|ADGF_DEMO),v)
#define MACDEMO1t(t,e,f,m,s,v)	GENGAME1t_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformMacintosh,(ADGF_MACRESFORK|ADGF_DEMO),v)
#define WINDEMO1(t,e,f,m,s,v)	GENGAME1_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformWindows,ADGF_DEMO,v)
#define WINDEMO1t(t,e,f,m,s,v)	GENGAME1t_(t,e,f,m,s,Common::EN_ANY,Common::kPlatformWindows,ADGF_DEMO,v)
#define MACGAME1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformMacintosh,ADGF_MACRESFORK,v)
#define PIPGAME1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformPippin,ADGF_MACRESFORK,v)
#define WINGAME1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformWindows,ADGF_NO_FLAGS,v)
#define WINGAME1t_l(t,e,f,m,s,l,v) GENGAME1t_(t,e,f,m,s,l,Common::kPlatformWindows,ADGF_NO_FLAGS,v)
#define MACGAME1t_l(t,e,f,m,s,l,v) GENGAME1t_(t,e,f,m,s,l,Common::kPlatformMacintosh,ADGF_MACRESFORK,v)
#define FMTGAME1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformFMTowns,ADGF_NO_FLAGS,v)
#define SHKGAME1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformShockwave,ADGF_NO_FLAGS,v)
#define MACDEMO1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformMacintosh,(ADGF_MACRESFORK|ADGF_DEMO),v)
#define PIPDEMO1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformPippin,(ADGF_MACRESFORK|ADGF_DEMO),v)
#define WINDEMO1_l(t,e,f,m,s,l,v) GENGAME1_(t,e,f,m,s,l,Common::kPlatformWindows,ADGF_DEMO,v)
#define WINDEMO1t_l(t,e,f,m,s,l,v) GENGAME1t_(t,e,f,m,s,l,Common::kPlatformWindows,ADGF_DEMO,v)

#define MACGAME2(t,e,f1,m1,s1,f2,m2,s2,v)	GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,Common::EN_ANY,Common::kPlatformMacintosh,ADGF_MACRESFORK,v)
#define PIPGAME2(t,e,f1,m1,s1,f2,m2,s2,v)	GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,Common::EN_ANY,Common::kPlatformPippin,ADGF_MACRESFORK,v)
#define WINGAME2(t,e,f1,m1,s1,f2,m2,s2,v)	GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,Common::EN_ANY,Common::kPlatformWindows,ADGF_NO_FLAGS,v)
#define WINGAME2t(t,e,f1,m1,s1,f2,m2,s2,v)	GENGAME2t_(t,e,f1,m1,s1,f2,m2,s2,Common::EN_ANY,Common::kPlatformWindows,ADGF_NO_FLAGS,v)
#define FMTGAME2(t,e,f1,m1,s1,f2,m2,s2,v)	GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,Common::EN_ANY,Common::kPlatformFMTowns,ADGF_NO_FLAGS,v)
#define MACDEMO2(t,e,f1,m1,s1,f2,m2,s2,v)	GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,Common::EN_ANY,Common::kPlatformMacintosh,(ADGF_MACRESFORK|ADGF_DEMO),v)
#define WINDEMO2(t,e,f1,m1,s1,f2,m2,s2,v)	GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,Common::EN_ANY,Common::kPlatformWindows,ADGF_DEMO,v)
#define WINDEMO2t(t,e,f1,m1,s1,f2,m2,s2,v)	GENGAME2t_(t,e,f1,m1,s1,f2,m2,s2,Common::EN_ANY,Common::kPlatformWindows,ADGF_DEMO,v)
#define MACGAME2_l(t,e,f1,m1,s1,f2,m2,s2,l,v) GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,l,Common::kPlatformMacintosh,ADGF_MACRESFORK,v)
#define PIPGAME2_l(t,e,f1,m1,s1,f2,m2,s2,l,v) GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,l,Common::kPlatformPippin,ADGF_MACRESFORK,v)
#define WINGAME2_l(t,e,f1,m1,s1,f2,m2,s2,l,v) GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,l,Common::kPlatformWindows,ADGF_NO_FLAGS,v)
#define WINGAME2t_l(t,e,f1,m1,s1,f2,m2,s2,l,v) GENGAME2t_(t,e,f1,m1,s1,f2,m2,s2,l,Common::kPlatformWindows,ADGF_NO_FLAGS,v)
#define FMTGAME2_l(t,e,f1,m1,s1,f2,m2,s2,l,v) GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,l,Common::kPlatformFMTowns,ADGF_NO_FLAGS,v)
#define MACDEMO2_l(t,e,f1,m1,s1,f2,m2,s2,l,v) GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,l,Common::kPlatformMacintosh,(ADGF_MACRESFORK|ADGF_DEMO),v)
#define WINDEMO2_l(t,e,f1,m1,s1,f2,m2,s2,l,v) GENGAME2_(t,e,f1,m1,s1,f2,m2,s2,l,Common::kPlatformWindows,ADGF_DEMO,v)
#define WINDEMO2t_l(t,e,f1,m1,s1,f2,m2,s2,l,v) GENGAME2t_(t,e,f1,m1,s1,f2,m2,s2,l,Common::kPlatformWindows,ADGF_DEMO,v)

static const DirectorGameDescription gameDescriptions[] = {
	// Execute all *.lingo files in game directory
	{
		{
			"directortest",
			"",
			AD_ENTRY1("lingotests", 0),
			Common::EN_ANY,
			Common::kPlatformMacintosh,
			ADGF_NO_FLAGS,
			GUIO1(GUIO_NOASPECT)
		},
		GID_TEST,
		400
	},

	// Execute all movies in directory
	{
		{
			"directortest-all",
			"",
			AD_ENTRY1("lingotests-all", 0),
			Common::EN_ANY,
			Common::kPlatformMacintosh,
			ADGF_NO_FLAGS,
			GUIO1(GUIO_NOASPECT)
		},
		GID_TESTALL,
		400
	},

	// Original filename is "•Main Menu" for all
	MACGAME1("theapartment", "D2", "xn--Main Menu-zd0e", "fc56c179cb8c6d4938e61ee61fd0032c", 48069, 200),
	MACGAME1("theapartment", "D3", "xn--Main Menu-zd0e", "9e838fe1a6af7992d656ca325e38dee5", 47655, 300),
	MACGAME1("theapartment", "D4", "xn--Main Menu-zd0e", "ff86181f03fe6eb060f65a985ca0580d", 160612, 400),

//////////////////////////////////////////////////
//
// MacroMind VideoWorks Player 1.00 (pre-director)
//
//////////////////////////////////////////////////

	MACGAME1("bigsound", "", "BigSound VW Player", "4b42e95a6e75cf440abcfeeeee8d622f", 19200, 0),

	// Touring Engine Ver 1.00
	MACDEMO1("illustrator", "v1 Tour", "Adobe Illustrator Tour", "4d331ce05dbec4a84465ed33fa5538fa", 64692, 0),

	MACGAME2_l("madmac", "", "VW Player", "16034c0db4619552e4fe7e108cb98dae", 17070,
							 "Vieux", "3555a71c668ce58018bc0863bdc18022", 14341, Common::FR_FRA, 0),

	// Published by MacroMind. Contains some VW-style animations.
	MACGAME1("mazewars", "", "Maze Wars+2", "24874b31f1f7f0adc3e8bc1efdc155e7", 128335, 0),

	// No projector provided. Files appear to be incomplete.
	MACDEMO2("shatter", "Scenes", "TITLE", "e0e1c08c5fd90678ba550a93bc47e261", 13863,
								  "CITY", "5fcc134c1252f25a31752e4cd6307c8c", 25288, 0),

//////////////////////////////////////////////////
//
// MacroMind VideoWorks II (pre-director)
//
//////////////////////////////////////////////////

/*****************************************************************
	VideoWorks movies called from HyperCard stacks
	Movies will play by using --start-movie flag from console
	These entries use VW II Driver 1.2
*****************************************************************/

	// Original filename is FutureView™(O.L.)
	MACGAME1("futureview", "", "FutureView (O.L.)", "f2dd4c1bacdb1ad0226ac14762a2bd56", 262089, 0),
	MACDEMO1("ideacomm", "Demo", "IDEAcomm Mac Demo", "b36cb9e6e36e7cb569d9af571d2dd1bd", 20750, 0),
	MACDEMO1("osmo", "Demo", "Cosmic Osmo Demo", "eba9620282bd39ff4ba2a9190e72880b", 127685, 0),

/*****************************************************************
	VideoWorks movies built using MacroMind Touring Engine
*****************************************************************/

	// Touring Engine V2.2B12
	// Original filename is GeoQuery® Tour
	MACDEMO1("freehand", "Demo", "FreeHand 2.0 demo", "1c6bb186e709e88fdcf9279e8799eab5", 74052, 0),
	MACDEMO1("geoquery", "Demo", "GeoQuery Tour", "48476e45e1bd9d67806ebe09b959679b", 74006, 0),
	MACDEMO1("musicpublisher", "Demo", "Music Publisher Demo", "1c6bb186e709e88fdcf9279e8799eab5", 74052, 0),
	MACDEMO2("pspice", "Demo", "Tour Engine", "1c6bb186e709e88fdcf9279e8799eab5", 74052,
							   "TOUR LIST", "1efdd9c0455c4e90466ee6a6dda182d1", 22386, 0),

	// Touring Engine 3.8 © Apple Computer, Inc. & MacroMind 1985-1988
	MACGAME2("macportable", "", "Double Click Me", "341b6ae632d9e52979e478ce27ffc42c", 114423,
								"MAIN MENU", "5bfdbf8b0fc6698c9724cd7634427fe1", 30071, 0),

//////////////////////////////////////////////////
//
// MacroMind Director v1
//
//////////////////////////////////////////////////

	{
		{
			"osmo", "CD Demo",
			AD_ENTRY1s("Osmo.BW.HC", "7efaee43e298e3a3d29607300b20147a", 796297),
			Common::EN_ANY,
			Common::kPlatformMacintosh,
			ADGF_CD | ADGF_DEMO | SUPPORT_STATUS,
			GUIO1(GUIO_NOASPECT)
		},
		GID_GENERIC,
		100	// MacroMind Player v 0.98
	},

	// Projector and movies are compiled into proprietary executable.
	// On exit, pop-up says "This Presentation was created using MacroMind Director 1.1"
	MACDEMO1_l("rosettastone", "Demo", "The Rosetta Stone", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 1379459, Common::JA_JPN, 110),

#undef SUPPORT_STATUS
#define SUPPORT_STATUS ADGF_NO_FLAGS

//////////////////////////////////////////////////
//
// MacroMind Director v2
//
//////////////////////////////////////////////////

	MACGAME1_l("alice", "", "Alice", "e54ec74aeb4355b0acd46320327c1bed", 271740, Common::JA_JPN, 200),
	// CD serial TONP-1506, uses CD-Audio
	MACGAME1_l("alice", "Digipak", "Alice", "e54ec74aeb4355b0acd46320327c1bed", 274018, Common::JA_JPN, 200),

	// Many separate apps on a single disk
	MACGAME1_l("apeodyssey", "Ape Man & Bambi (Ape Man)", "apeMAN", "cfa68a1bc49251497ebde18e5fc9c217", 165093, Common::JA_JPN, 200),
	MACGAME1_l("apeodyssey", "Ape Man & Bambi (Bambi)", "BAMBI", "cfa68a1bc49251497ebde18e5fc9c217", 243751, Common::JA_JPN, 200),
	MACGAME1_l("apeodyssey", "CBGB (Boyfriend)", "BOYFRIEND", "cfa68a1bc49251497ebde18e5fc9c217", 297469, Common::JA_JPN, 200),
	MACGAME1_l("apeodyssey", "CBGB (Girlfriend)", "Girlfriend", "cfa68a1bc49251497ebde18e5fc9c217", 258490, Common::JA_JPN, 200),
	MACGAME1_l("apeodyssey", "CBGB (Jet Stream)", "Jet Stream", "cfa68a1bc49251497ebde18e5fc9c217", 261052, Common::JA_JPN, 200),
	MACGAME1_l("apeodyssey", "CBGB (One Eyed Jack)", "One Eyed Jack", "cfa68a1bc49251497ebde18e5fc9c217", 253862, Common::JA_JPN, 200),
	MACGAME1_l("apeodyssey", "CBGB (Romantic Thriller)", "Romantic Thriller", "cfa68a1bc49251497ebde18e5fc9c217", 263567, Common::JA_JPN, 200),
	MACGAME1_l("apeodyssey", "CBGB (RR Diner)", "RR Diner", "cfa68a1bc49251497ebde18e5fc9c217", 258218, Common::JA_JPN, 200),
	MACGAME1_l("apeodyssey", "KenKen", "KenKen", "cfa68a1bc49251497ebde18e5fc9c217", 179808, Common::JA_JPN, 200),

	MACDEMO1("backgrounds", "Demo", "Backgrounds Demo", "d029fcb13fd2f0944f3c04577ad3b848", 2707940, 200),
	MACDEMO1("backgrounds", "Demo", "Backgrounds Demo", "d029fcb13fd2f0944f3c04577ad3b848", 2410386, 200),

	// Movies called from HyperCard with external MacroMind Player 2.0
	MACGAME1("beyondcyberpunk", "v1.5", "1984", "026bda630919f3692e649c00b1b52dd9", 34169, 200),

	MACDEMO1("illustrator", "v3.0 Demo", "a double click please", "cfa68a1bc49251497ebde18e5fc9c217", 194065, 200),

	MACGAME2("mindvirus", "Issue 02.94", "Projector", "cfa68a1bc49251497ebde18e5fc9c217", 271313,
										 "1", "409c1b65614c01facad7da6eb689f1c8", 1130108, 200),

	// Demos from Mac World Expo Boston 1992 Interactive Multimedia Reference CD-ROM
	MACDEMO2("msexcel", "Demo",	  "Double Click", "e54ec74aeb4355b0acd46320327c1bed", 236629,
								  "StartUp",	  "4be24cb9ca426e9ae318163f75ae55ee", 51057, 201),
	MACDEMO2("msword", "v5 Demo", "Double Click", "e54ec74aeb4355b0acd46320327c1bed", 204030,
								  "MSWD pt. 1",   "d30e1cae275e7ecfdde92df03a28b309", 249005, 201),

	// Movies called from HyperCard with external MacroMind Player 2.0
	MACGAME1("spelunx", "v1.2", "Spelunx", "3eb3598b7f6bb09de4dd31aca3683d8f", 371154, 200),

	// Original file name is STATUS*Mac 2.0 Demo
	MACDEMO1("statusmac", "2.0 Demo", "xn--STATUSMac 2.0 Demo-za43f", "cfa68a1bc49251497ebde18e5fc9c217", 742048, 200),

	MACGAME2("system7smash", "", "Double Click", "e54ec74aeb4355b0acd46320327c1bed", 225921,
								 "Smash", "7c11c3c07b87188cdf6260f922bb9e3c", 9031, 201),

	MACGAME1_l("tri3dtrial", "", "Tri-3D-Trial", "cfa68a1bc49251497ebde18e5fc9c217", 270967, Common::JA_JPN, 200),

	// Original file name is Spaceship Warlock™
	// v1.1.1 Classic and Trailer are from Spaceship Warlock AV
	MACGAME1("warlock", "v1.0",			  "xn--Spaceship Warlock-306j", "cfa68a1bc49251497ebde18e5fc9c217", 270837, 200),
	MACGAME1("warlock", "v1.1.1 Classic", "xn--Spaceship Warlock-306j", "cfa68a1bc49251497ebde18e5fc9c217", 270851, 200), // 1994
	MACGAME1("warlock", "v1.1.1 Classic", "xn--Spaceship Warlock-306j", "cfa68a1bc49251497ebde18e5fc9c217", 273115, 200), // 1996
	MACDEMO1("warlock", "v1.0 Demo", "xn--Spaceship Warlock Demo-j40n", "cfa68a1bc49251497ebde18e5fc9c217", 271099, 200),
	MACDEMO1("warlock", "v1.0 Demo", "xn--Spaceship Warlock Demo-j40n", "cfa68a1bc49251497ebde18e5fc9c217", 270843, 200), // 1991
	MACDEMO1("warlock", "Trailer",	 "SS Warlock Movie Trailer", "cfa68a1bc49251497ebde18e5fc9c217", 270843, 200), // 1991
	MACDEMO1("warlock", "Trailer",	 "SS Warlock Movie Trailer", "cfa68a1bc49251497ebde18e5fc9c217", 270857, 200), // 1994
	MACDEMO1("warlock", "Trailer",	 "SS Warlock Movie Trailer", "cfa68a1bc49251497ebde18e5fc9c217", 273121, 200), // 1996

//////////////////////////////////////////////////
//
// MacroMind / Macromedia Director v3
//
//////////////////////////////////////////////////

#undef SUPPORT_STATUS
#define SUPPORT_STATUS ADGF_NO_FLAGS

	// Original filename is 'BD-J/Demo'
	// Developed by ART Sector ONE / Richard M. Coombs
	// ベターデッド ーラティフィケーションー published by NEC Interchannel, Minato, Tokyo (1995)
	MACGAME1("betterd", "", "Better Dead 12 megs", "17efee018a660458fae80de4364021ac", 486717, 404),
	MACDEMO1_l("betterd", "Demo", "xn--BD-JDemo-na47b", "17efee018a660458fae80de4364021ac", 487275, Common::JA_JPN, 404),
	WINGAME1_l("betterd", "", "BETTERD.EXE", "e484d23ce2b6750d9e7e4a7b32632f47", 696877, Common::JA_JPN, 404),

	// Original filename is 東脳スタート
	MACGAME1_l("easternmind", "", "xn--zckm1a5qp59wok6a", "276bee761e48a6fd709df77d5c2f60dd", 394781, Common::JA_JPN, 313),

	MACDEMO1_l("henachoco", "Trial Version", "Hena Choco Derby Demo", "f5277c53bacd27936158dd3867e587e2", 1794011, Common::JA_JPN, 311),

	// Original demo filename is ﾑｽﾞｶｼｲﾎﾝｦﾖﾑﾄﾈﾑｸﾅﾙ
	MACDEMO1_l("henachoco03", "Demo", "xn--oj7cxalkre7cjz1d2agc0e8b1cm", "f5277c53bacd27936158dd3867e587e2", 1058521, Common::JA_JPN, 311),
	MACDEMO1_l("henachoco03", "Trial Version", "ITA Choco", "f5277c53bacd27936158dd3867e587e2", 1123529, Common::JA_JPN, 311),
	// Original filename is ﾑｽﾞｶｼｲﾎﾝｦﾖﾑﾄﾈﾑｸﾅﾙ
	MACGAME1_l("henachoco03", "", "xn--oj7cxalkre7cjz1d2agc0e8b1cm", "f5277c53bacd27936158dd3867e587e2", 1579812, Common::JA_JPN, 311),

	MACGAME1_l("henachoco04", "", "bentoben", "f5277c53bacd27936158dd3867e587e2", 2413669, Common::JA_JPN, 311),

	// Original filename is ' ダブルクリックして下さい'
	MACGAME1_l("japanart07", "", "xn-- -17t4bh9eswa8k2a2qnika8408g", "f5277c53bacd27936158dd3867e587e2", 392401, Common::JA_JPN, 310),
	// Decomposed variant of the above
	MACGAME1_l("japanart07", "", "xn-- -17t4bh9etpa0pa0nxb5n6jma0692i", "f5277c53bacd27936158dd3867e587e2", 392401, Common::JA_JPN, 310),

	MACGAME1_l("overringunder", "", "Over-Ring-Under", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 910381, Common::JA_JPN, 300),

	// Original filename is ~LEGEND OF PSY•S CITY~
	// English translation by Skye Sonomura (HomeStarRunnerTron)
	MACGAME1_l("the7colors", "", "xn--~LEGEND OF PSYS CITY~-up9l", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 383745, Common::JA_JPN, 300),
	// Alternate filename variation
	MACGAME1_l("the7colors", "", "xn--~LEGEND OF PSYS CITY~-u558i", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 383745, Common::JA_JPN, 300),
	MACGAME1("the7colors", "", "T7C-R!", "d84feae6ba35340857f46c9cbd6bd1a6", 398725, 300),
	MACGAME1_l("the7colors", "No CD Yo! 6/21/15 hack", "xn--~LEGEND OF PSYS CITY~-u558i", "a6e50f2b8f294640a1d0cbe91a73e81c", 392267, Common::JA_JPN, 300),

	MACGAME1_l("timegal", "", "TimeGal", "f5277c53bacd27936158dd3867e587e2", 392230, Common::JA_JPN, 311),

//////////////////////////////////////////////////
//
// Macromedia Director v4
//
//////////////////////////////////////////////////

	MACGAME1("chopsuey", "", "Chop8", "01be45e7241194dad07938e7059b88e3", 481254, 404),
	WINGAME1("chopsuey", "", "CHOPSUEY.EXE", "785e26240153a028549e8a66c2e904bf", 772382, 404),

	WINGAME1t_l("easternmind", "", "TONG_NOU.EXE", "5d8fe6160e5cde5a9fd0cfa6a8ed7901", 741471, Common::JA_JPN, 404),
	MACGAME1("easternmind", "", "Eastern Mind", "78138a77207907642744d0960c14d9e5", 483490, 404),
	WINGAME1("easternmind", "", "ESTRNMND.EXE", "2597cfb5466d193b5a18fc7b0e3a3fa5", 685789, 404),
	// Eastern Mind extras developed by
	// N.IIZUKA - OSD
	// Justin Case - OR Inc
	MACGAME1("easternmind", "Tong-Nou Characters", "Tong-Nou Characters", "2b8834cfd8a53e61b7f957a81eb627f4", 303933, 404),
	WINGAME1t("easternmind", "Tong-Nou Characters", "KARACTRS.EXE", "58dbf5a92fb2466356b474e449458df4", 2249267, 404),
	MACGAME1("easternmind", "Transcript", "Transcript Player", "78138a77207907642744d0960c14d9e5", 483490, 404),
	WINGAME1t("easternmind", "Transcript", "TRNSCRPT.EXE", "22b17cda5df54961327d8f89040d534f", 686807, 404),

	MACGAME2_l("fukuokagoround", "", "Fukuoka Go-Round",  "0c7bbb4b24823e5ab871cb4c1d6f3710", 484167, "shared.dir", "b83bfaec3666b328ec743e074a94115f", 20900286, Common::JA_JPN, 404),
	WINGAME2t_l("fukuokagoround", "", "FGR.EXE",  "dc2da038ba67c2bd2f5bb31b97261db9", 5293611, "SHARED.DIR", "6bf95a48f366bdf8af3a198c7b723c77", 16038266, Common::JA_JPN, 404),

	// Original filename 'がんばれ！いぬちゃん'
	MACGAME1_l("ganbareinuchan", "", "xn--n8jp8dzbs1jpcwcg96593c", "411051c134236a9ead0d0d1837aafb5e", 290426, Common::JA_JPN, 402),
	WINGAME2_l("ganbareinuchan", "", "INU.EXE", 	 "5c30d0b58fcc65a7227225e97dbb1539", 1860265,
									 "02SYOKAI.DIR", "192ef6907b84eedc325617e7950fb5f6", 597974, Common::JA_JPN, 404),
	// Original filename is 'ロケンロ−ル編デモ'
	MACDEMO1_l("ganbareinuchan", "Demo", "xn--t9gx88c6b6evbjb1c4777j", "cb46b4a5d76bdea0b0b4b9b7b2a42d01", 1452700, Common::JA_JPN, 402),
	// Decomposed variant of the above
	MACDEMO1_l("ganbareinuchan", "Demo", "xn--t9g248c9b2dvg1blb7c7642k", "cb46b4a5d76bdea0b0b4b9b7b2a42d01", 1452700, Common::JA_JPN, 402),

	// Original filename is 'いぬちゃんＲＯＭ新作デモ'
	MACDEMO1_l("ganbareinuchan2", "Demo", "xn--n8jyc6a7frd6opgo41v280bt08wva9a", "8ea9e9a699c61edddffd79ddd0c994d7", 290398, Common::JA_JPN, 402),
	MACDEMO1_l("ganbareinuchan2", "Demo", "xn--n8jyc6a7frdqb0ywhp41xex4bh34xxa2b", "8ea9e9a699c61edddffd79ddd0c994d7", 290398, Common::JA_JPN, 402),

	MACGAME1_l("ganbareinuchan2", "", "INUCHAN2", "0c7bbb4b24823e5ab871cb4c1d6f3710", 483187, Common::JA_JPN, 404),

	WINGAME1_l("henachoco", "", "HENADB.EXE", "b1f5f97ce93cafe828621843ff05df76", 2366787, Common::JA_JPN, 400),

	WINGAME1_l("henachoco02", "", "SAITEI.EXE", "4a5244b62e268a2ce38d9876bff91016", 2293467, Common::JA_JPN, 400),

	WINGAME1_l("henachoco03", "", "BOOK.EXE", "8bb2b769cc851916004aac0c887b0db9", 1795813, Common::JA_JPN, 400),

	WINGAME1_l("henachoco04", "", "BENTO.EXE", "3a42f519df56d4cecac5e0915cf90f33", 2330381, Common::JA_JPN, 400),

	MACGAME1_l("henachoco05", "", "yaken", "3731a1d809be07929da1f5d691ee3c97", 290398, Common::JA_JPN, 402),
	WINGAME1_l("henachoco05", "", "YAKEN.EXE", "1f9b0ef872de7b84063a53b2a1083c60", 2103629, Common::JA_JPN, 400),

	// German 16bit version is unconfirmed (Trac #13225)
	MACGAME1("majestic", "", "Majestic", "01be45e7241194dad07938e7059b88e3", 483518, 400),
	WINGAME1("majestic", "", "MAJESTIC.EXE", "624267f70253e5327981003a6fc0aeba", 23437631, 400),
	WINGAME1_l("majestic", "",  "Maj16.exe", "65ef7246e9ab04aff59fb734e9551727", 23688481, Common::DE_DEU, 400),
	WINGAME1t_l("majestic", "", "Maj32.exe", "d1cced6eff47da53845679d05b5d2bf3", 24166899, Common::DE_DEU, 400),

	PIPGAME1_l("nemurenu", "", "Sleepless", "5ac60d4dafefa00dd8060b6a4f9c4c4c", 48184, Common::JA_JPN, 404),

	// Original filename is 'ペペロン村の四季'
	MACGAME1_l("pepperon", "", "xn--u9j2la0f4a9404c9vg8wz", "8b138db44d4421cc7294a9dc792ccf1b", 521283, Common::JA_JPN, 404),
	// Decomposed variant of the above
	MACGAME1_l("pepperon", "", "xn--u9jtea0wb1ktbx480dksir53a", "8b138db44d4421cc7294a9dc792ccf1b", 521283, Common::JA_JPN, 404),
	WINGAME1t_l("pepperon", "", "PEPPERON/START95.EXE", "b7fd4c43d44291a15ef1829e96652a5b", 1094585, Common::JA_JPN, 404),
	// French version titled "Valmaison au fil des saisons"
	MACGAME1_l("pepperon", "", "Valmaison", "8b138db44d4421cc7294a9dc792ccf1b", 502569, Common::FR_FRA, 404),
	WINGAME1_l("pepperon", "", "PEPPERON/START95.EXE", "4086df04abc18956581cee17b48e81c1", 1805439, Common::FR_FRA, 404),
	// Dutch version titled "Op avontuur in kabouterstad"
	WINGAME2t_l("pepperon", "", "START95.EXE", "7dbb1621a27aea372c06a156197de57f", 1088309,
								"OPENN.DIR", "2effe5cc59f2262fcf204a479c027de3", 1807124, Common::NL_NLD, 404),

	// Korean Windows version is named 'Time Girl'
	WINGAME1_l("timegal", "", "TIMEGIRL.EXE", "0e5a7734bdc74198a62171ea4d51a364", 687457, Common::KO_KOR, 400),

//////////////////////////////////////////////////
//
// MacroMind / Macromedia Director v3
//
//////////////////////////////////////////////////


#undef SUPPORT_STATUS
#define SUPPORT_STATUS ADGF_UNSTABLE

	MACDEMO1("aamn", "Demo", "AAMN", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 354389, 301),

	// Found on ADAM The Inside Story v1.11 for Windows
	WINGAME2("adamscholar", "", "MAIN.EXE",  "de06298eb65f392f4e736a1c6b0b889c", 1152807,
								"SDEMO.DIR", "bfb9bd6de59c22f0c45da6ade0579384", 3158992, 311),

	// Original Mac filename is *デモスタート
	MACDEMO2_l("adamtis", "Demo", "Demo start",	  "1ae45c23586b41997ba52e2e7c771c4c", 1676689,
								  "step1",		  "7e17288d51f610daf84941e318404518", 393530, Common::JA_JPN, 311),

	MACDEMO1_l("adobedimensions", "Demo", "PD.Demo", "f5277c53bacd27936158dd3867e587e2", 1439236, Common::JA_JPN, 311),

	// Original filename is Agfa CD-ROM Demo/B&W
	MACDEMO1("agfa", "v3.1 Demo", "xn--Agfa CD-ROM DemoB&W-bba08g", "13ba95890bdaa1a07255c395499fe12e", 1283400, 300),

	// Original filename is アラン・ケイ
	MACDEMO1_l("alankay", "Demo", "Alan Kay", "276bee761e48a6fd709df77d5c2f60dd", 6188133, Common::JA_JPN, 311),

	MACGAME1_l("alexworld", "", "AlexWorld", "f5277c53bacd27936158dd3867e587e2", 391320, Common::JA_JPN, 300),
	WINGAME2t_l("alexworld", "", "ALEX.EXE", "309f70f00df28cec3fcf2141004fbca8", 369996,
								 "DATA/START.MMM", "cea4ebd9a0ff68e56209aedb37b229bc", 1248940, Common::JA_JPN, 300),

	MACGAME1("alice2ocean", "", "From Alice to Ocean", "1ae45c23586b41997ba52e2e7c771c4c", 375210, 310),

	// v3.0 is the 1991 Mac-only release, v4.0 is the 1993 Win/Mac hybrid release
	// In the Mac-only release, only the 'AmandaStories Color' version is Director, 'AmandaStories B & W' is HyperCard; also uses a single audio track
	// Original Mac filename of the 1993 version is AmandaStories®
	MACGAME1("amandastories", "v3.0", "AmandaStories", "1687f456d7f2bcf98e84fec6d3a03c17", 353729, 300),
	MACGAME1("amandastories", "v4.0", "xn--AmandaStories-1sa", "88e2dc106dd1e5da5aebf9ed36944a7f", 360905, 300),
	WINGAME1t("amandastories", "", "AMANDA.EXE", "9c44f3e450184e5db441bccbaf4a830a", 373139, 310),
	MACDEMO1("amandastories", "Sampler", "AmandaStories Sampler", "60cc4ccbab898f1f444088fb5aad90c4", 1783259, 311),

	// Uses audio tracks
	MACGAME1("amhha", "", "All My Hummingbirds Have Alibis", "9c97c1cbf6f01697685d3aac1d882526", 1356802, 300),

	// From Macintosh Demo Software Zenshuu CD-ROM '94 Disc 3
	// Original filename is アニマルタウンデモ版
	MACDEMO1_l("animaltown", "Demo", "Animal Town Demo Version", "f5277c53bacd27936158dd3867e587e2", 394921, Common::JA_JPN, 311),

	MACGAME1_l("aquaplanet", "", "click me!", "f5277c53bacd27936158dd3867e587e2", 392441, Common::JA_JPN, 310),

	MACDEMO1_l("asylum300", "Demo", "ASYLUM 300 DEMO", "4c7fddccfe5ab2e9c6398efa5dbe37c1", 1038023, Common::JA_JPN, 313),

	// Original filename is Babylon 5 Interactive/Mac
	MACGAME1("babylon5int", "", "xn--Babylon 5 InteractiveMac-lba01j", "7f443f2e63fd497a9ad85b10dc880a91", 1262385, 313),

	MACDEMO2_l("bakkunooni", "Wabi Demo", "Browser",	"7ba588d9fde9f714a42fec0a2c9d9655", 2835379,
										  "Main-Help-J", "2358b56196b9d9148990f5f5e9c7fb43", 8265, Common::JA_JPN, 311),

	// Original filename is 'ﾀﾞﾌﾞﾙｸﾘｯｸしてちょんまげ!!'
	MACGAME1_l("bakavideodrug", "", "xn--!!-l83ata4c3a3ovcsfp481v2cab5h2h5goa7fb", "f5277c53bacd27936158dd3867e587e2", 392249, Common::JA_JPN, 311),

	MACGAME1("belcher", "", "The Belcher", "d0683b94f369d0d60ebd6c47d4d1ea76", 470520, 301),

	// Also on the disk is the executable and resources for the 12" monitor version
	// "BELZERION 12", "f5277c53bacd27936158dd3867e587e2", 392623, 311
	MACGAME1_l("belzerion", "", "BELZERION 13", "f5277c53bacd27936158dd3867e587e2", 392619, Common::JA_JPN, 311),

	WINGAME1t("bestservice", "", "BESTDEMO.EXE", "437d0bc26a89a5f8cda3bef31db23897", 370015, 310),

	MACGAME1("beyondthewall", "",  "Beyond The Wall Of Stars", "107c6a6d3cce957eaa26d427e672000c", 465267, 300),
	MACGAME1("beyondthewall", "",  "Desktop Folder/bstars", "107c6a6d3cce957eaa26d427e672000c", 465267, 300),
	WINGAME2t("beyondthewall", "", "WALL.EXE",	"36a8d553a58437752e12b250389a4629", 225253,
								   "TITLE.MMM",	"1fa63036a9c55cdbec8830219315ee7a", 661220, 300),

	MACDEMO1_l("bigtimemovie", "Demo", "BIG TIME MOVIE-Studios", "f5277c53bacd27936158dd3867e587e2", 392265, Common::JA_JPN, 311),

	// Original filename is BioFlix©1993.Demo 1.0
	MACDEMO1("bioflix", "v1.0 Demo", "BioFlix 1993.Demo 1.0", "1ae45c23586b41997ba52e2e7c771c4c", 1070435, 310),

	MACGAME1("birdlife", "", "Click here to start (8mb)", "1ae45c23586b41997ba52e2e7c771c4c", 380802, 311),
	WINGAME1("birdlife", "", "BIRDMPC/BIRDLIFE.EXE", "65d06b5fef155a2473434571aff5bc29", 783483, 310),

	// Original filename is BOB©1991
	MACGAME1("bob", "", "BOB 1991", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 1209281, 300),

	// CD-ROM for Bomb! magazine focusing on "cyber idol" Reiko Chiba
	MACGAME1_l("bombreikochiba", "", "CD-BOMB!", "276bee761e48a6fd709df77d5c2f60dd", 393879, Common::JA_JPN, 310),

	// Full game uses audio tracks
	MACGAME1("bodypark", "", "xn--BodyPark -tic/BodyPark", "7f443f2e63fd497a9ad85b10dc880a91", 503467, 313),
	WINGAME1t("bodypark", "", "BODYPARK.EXE", "36b7c7de5e7ee6cb8c1ec02a8b3de59c", 370005, 310),
	WINDEMO1("bodypark", "Demo", "BODYPARK.EXE", "65d06b5fef155a2473434571aff5bc29", 1654314, 310),

	WINDEMO1("bookshelf94", "Demo", "BS94DEMO.EXE", "7c8230a804abf9353b05627a675b5ffb", 375300, 310),

	WINGAME1("bpmc", "", "BPMC.EXE", "1998188253fc8657198e3e78efe823a8", 370291, 313),
	// From Isaac Asimov's The Ultimate Robot CD
	MACGAME1("bpmc", "", "Byron Preiss Catalog", "1ae45c23586b41997ba52e2e7c771c4c", 684865, 311),
	// From Gahan Wilson's The Ultimate Haunted House CD
	MACGAME1("bpmc", "", "Byron Preiss Catalog", "7f443f2e63fd497a9ad85b10dc880a91", 5208397, 313),

	// Main disc is Hypercard; only this portion is Director
	MACDEMO1("blam", "BLAM! Propaganda", "BLAM! Promotion!!", "7f443f2e63fd497a9ad85b10dc880a91", 646898, 313),

	// Interactive book portion is Hypercard
	MACGAME1("blindrom", "", "PLAY BLIND", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384404, 310),

	// Bilingual English/Japanese
	MACGAME1("biomorph", "", "Bio-Morph.Start", "f5277c53bacd27936158dd3867e587e2", 392223, 311),

	// Original v3.5.1 demo filename is BusinessManager.デモ
	MACDEMO1_l("businessmanager", "v3.5.1 Demo", "BusinessManager.Demo", "f5277c53bacd27936158dd3867e587e2", 2102272, Common::JA_JPN, 311),
	MACDEMO1_l("businessmanager", "Demo", "BusinessManager.Demo", "f5277c53bacd27936158dd3867e587e2", 392347, Common::JA_JPN, 311),

	MACDEMO1_l("calling", "Demo", "CallingPlayer", "276bee761e48a6fd709df77d5c2f60dd", 392420, Common::JA_JPN, 313),

	// From Sanctuary Woods Multimedia. Projectors for English, French, Spanish are included on the disc.
	WINGAME2t("catcameback", "",   "TITLEE.EXE", "1cddc9c455b7f8ef78987282777170b7", 369998,
								   "TITLEE.MMM", "360492ae40b050acdb7117c713dddbcd", 3478, 310),
	WINGAME2t_l("catcameback", "", "TITLES.EXE", "fb7139c446dc35fa9648de71b0de2227", 369998,
								   "TITLES.MMM", "91e15ea5c292ae3d2934a82a9277c43a", 3478, Common::ES_ESP, 310),
	WINGAME2t_l("catcameback", "", "TITLEF.EXE", "c0f0fd8ded15c9932c58e6b08dbb843a", 369998,
								   "TITLEF.MMM", "0ada4096117f22b7cfe9395f6290b013", 3476, Common::FR_FRA, 310),
	// Found on CD-ROM Today, #4
	MACDEMO1("catcameback", "Demo", "Cat Came Back", "2ce360c9ea2da80a2c6d1040b0ad92dd", 386674, 313),

	// Each movie has its own projector
	WINGAME1("cdphysics", "", "CDPHYS/CDINTRO.EXE", "65d06b5fef155a2473434571aff5bc29", 370004, 313),

	MACDEMO1_l("cellofania", "Demo", "Cellofania.Demo", "f5277c53bacd27936158dd3867e587e2", 389970, Common::JA_JPN, 311),

	// English Mac filename is The C.H.A.O.S. Continuum™
	// Japanese Mac demo filename is CHAOS デモ and another file is called CHAOS Demo
	// English Mac demo from The Family Doctor, 3rd Edition
	MACGAME1("chaos", "", "xn--The C.H.A.O.S. Continuum-3r4o", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384225, 313),
	WINGAME2t("chaos", "", "CHAOS.EXE",    "5d1d9e1ff9a43e4d5b28441ce6d642fd", 375294,
						   "ANTEROOM.MMM", "6004a72285c7757e12ea214374e6fc5d", 15160, 310),
	MACDEMO1_l("chaos", "Demo", "Start CHAOS Demo", "f5277c53bacd27936158dd3867e587e2", 394683, Common::JA_JPN, 311),
	MACDEMO1("chaos", "Demo", "xn--CHAOS Continuum Demo-3h7l", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384212, 313),

	// Each section is on a separate disk with its own projector
	// https://www.youtube.com/watch?v=iDr0x22zRvs
	MACGAME1("childishgambino", "", "Donald Glover - Cut 1", "1ae45c23586b41997ba52e2e7c771c4c", 827602, 310),

	// Original filename is 小さな演奏家デモ
	MACDEMO1_l("chisanaensoka", "Demo", "Chisana enso-ka Demo", "f5277c53bacd27936158dd3867e587e2", 1500968, Common::JA_JPN, 311),

	MACDEMO1_l("chuckletime", "Demo", "Chuckle Time", "f5277c53bacd27936158dd3867e587e2", 608160, Common::JA_JPN, 311),

	WINDEMO1("cinemania94", "Demo",		 "CINEOVR.EXE",	 "7c8230a804abf9353b05627a675b5ffb", 1426843, 310),
	WINDEMO1("cinemania95", "1994 Demo", "CINEDEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 373209, 310),

	MACGAME1("cinevolt", "", "Cinema Volta", "2ce360c9ea2da80a2c6d1040b0ad92dd", 387911, 313),
	WINGAME1("cinevolt", "", "CINEVOLT.EXE", "65d06b5fef155a2473434571aff5bc29", 370009, 313),

	WINGAME1_l("cklasse", "", "c-klasse.exe", "39df1c7ff23ba627ddffaa5a77f83008", 376244, Common::DE_DEU, 313),

	MACDEMO1("clarisimpact", "Demo", "ClarisImpact Self Running Demo", "7f443f2e63fd497a9ad85b10dc880a91", 1241451, 310),

	MACDEMO1("clarisworks", "Demo", "ClarisWorks SRD Projector", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 353743, 300),

	// Found on The Family Doctor, 3rd Edition
	MACGAME1("cmc", "1993", "xn--Other Products...-", "1ae45c23586b41997ba52e2e7c771c4c", 5748468, 310),

	WINGAME1t("compuserve", "", "CSDEMO.EXE", "df9fd39763c4cc922e2cdad28d086a4c", 5331595, 404),

	// Found on CD-ROM Today, #4
	WINGAME1t("coreltour", "", "PRODTOUR.EXE", "296661dda59fcc1a4980e72797aac158", 375291, 300),

	MACDEMO1("cpu", "Demo", "CPU Demo Movie", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 533133, 300),

	MACDEMO1_l("creativeeye", "1994.02 Demo", "Creative EYE Demo", "f5277c53bacd27936158dd3867e587e2", 2354768, Common::JA_JPN, 311),
	MACDEMO1_l("creativeeye", "1994.06 Demo", "Creative EYE Demo", "276bee761e48a6fd709df77d5c2f60dd", 3343913, Common::JA_JPN, 313),

	// Windows version is not Director
	MACGAME1("criticalpath", "", "Critical Path", "2ce360c9ea2da80a2c6d1040b0ad92dd", 4504005, 310),

	MACDEMO1("cricketdraw", "Demo", "CA-Cricket Draw III Demo", "16759602b41cb957c8f13dba7f3f1984", 2026407, 301),

	// Original filename is キューティ１０デモ
	MACDEMO1_l("cutie10", "Demo", "Cutie 10 demo", "f5277c53bacd27936158dd3867e587e2", 390059, Common::JA_JPN, 311),

	MACGAME1_l("delphinokioku", "", "DELPHOI", "957b631d36a03be6c4671981a0b81681", 309951, Common::JA_JPN, 310),

	MACGAME1("digby", "", "Start Digby's Adventures!", "7f443f2e63fd497a9ad85b10dc880a91", 383758, 313),
	WINGAME1("digby", "", "DIGBY.EXE", "65d06b5fef155a2473434571aff5bc29", 370972, 310),

	// Original filename is 恐竜サファリアドベンチャー デモ
	// Full version isn't Director
	MACDEMO1_l("dinosafari", "Demo", "Dinosaur Safari Adventure Demo", "f5277c53bacd27936158dd3867e587e2", 394692, Common::JA_JPN, 311),

	// Demo version of Director Studio is provided (runs on 68k only). Readme instructs to run the
	// application and then open the Demo movie using the menu. However, the movie file is invisible,
	// so first you will need to copy the folder to your hard drive then modify the file properties.
	// The movie filename is 'Director Demo'.
	MACDEMO1("dirmacromind", "v3.1 Demo", "MacroMind Director 3.1.1 (SD)", "bd7b96d6c0c372e77e65ed0707aa34ee", 1191686, 311),

	MACDEMO1("donnamatrix", "Demo", "Donnamatrix Launch", "7f443f2e63fd497a9ad85b10dc880a91", 385436, 313),

	// Original filename is 'どうぶつ紹介ﾌﾟﾛｼﾞｪｸﾀ'
	MACGAME1_l("doubutsushokai", "", "xn--p8j0cn7c093vuh8c3p4khda8a5byithpbl", "1ed38b71d8d0f075483117f7fa559e7c", 440320, Common::JA_JPN, 300),
	// Decomposed variant of the above
	MACGAME1_l("doubutsushokai", "", "xn--p8j0ck7c8jc5225c1v9dm49l9dasbyc0jsiubn", "1ed38b71d8d0f075483117f7fa559e7c", 440320, Common::JA_JPN, 300),

	MACGAME1_l("dungeonstreet", "", "DungeonStreet", "3c96b93ed2a98b1e7e2eb609a3e1cc21", 397281, Common::JA_JPN, 311),

	// Original filename is '人生の法則'
	// Windows version is not Director.
	MACGAME1_l("ebisu", "", "xn--u9jy52g7nc5q2bdxi", "f5277c53bacd27936158dd3867e587e2", 392209, Common::JA_JPN, 311),

	// 1994 demo for Millie's Math House, Thinkin' Things, Kid Desk
	MACGAME1_l("edmark", "", "EDMARK", "276bee761e48a6fd709df77d5c2f60dd", 392437, Common::JA_JPN, 313),

	MACDEMO1("emigre", "Demo", "play cheese", "7c80091b84d4d5d48f7c773b30b10598", 990413, 310),

	MACGAME1("encarta94", "", "Installer Files/Encarta Projector", "7f443f2e63fd497a9ad85b10dc880a91", 385727, 313),
	// From CD Loisirs Nº6
	WINDEMO2t("encarta94", "", "ENCARTA.EXE", "15556b44638f59a1b55b050843562dfe", 370013,
							   "ENCADEMO.MMM", "17d992f65d52a070f1e7c15300031c79", 1321638, 300),

	MACGAME1("encarta95", "", "Installer Files/Encarta Projector", "7f443f2e63fd497a9ad85b10dc880a91", 385729, 313),
	WINDEMO1("encarta95", "Demo", "ENDEM95.EXE", "61d63911d437806fd473ffc31ddfc53d", 12109799, 311),

	// HyperCard application, calls movie using external MacroMind Player
	MACGAME2("exoticjapan", "", "MacroMind Player", "7f443f2e63fd497a9ad85b10dc880a91", 2196398,
								"Exotic Japan Stack", "28bdf606d2fbec537716ceae5edfaa93", 878941, 313),
	MACDEMO1("exoticjapan", "Sampler", "Exotic Japan Sampler", "e59139ac60997f52af77d7f03275ab30", 1790576, 311),

	WINDEMO1("explorapedia", "1994 Demo", "XPLDMO6.EXE", "d61e2e1e9f9d9907005adc992a451d02", 4724919, 311),

	// Main application is Hypercard, this movie is also able to be run standalone
	MACDEMO1("famdoc3", "", "How To Use Anatomy", "2ce360c9ea2da80a2c6d1040b0ad92dd", 3747110, 313),

	// Original filename 'FANTAZION™'
	MACGAME1_l("fantazion", "", "xn--FANTAZION-eh2e", "276bee761e48a6fd709df77d5c2f60dd", 420924, Common::JA_JPN, 310),
	WINGAME1_l("fantazion", "", "FTZ.EXE", "7c8230a804abf9353b05627a675b5ffb", 406250, Common::JA_JPN, 310),

	MACGAME1_l("erikotamuraoz", "", "OZ", "7f443f2e63fd497a9ad85b10dc880a91", 384207, Common::JA_JPN, 313),
	MACGAME1_l("erikotamuraoz", "Gallery OZ (16)", "Gallery OZ(16)", "7f443f2e63fd497a9ad85b10dc880a91", 384210, Common::JA_JPN, 313),
	MACGAME1_l("erikotamuraoz", "Gallery OZ (24)", "Gallery OZ(24)", "7f443f2e63fd497a9ad85b10dc880a91", 384207, Common::JA_JPN, 313),
	MACDEMO1_l("erikotamuraoz", "Demo", "OZ DEMO", "f5277c53bacd27936158dd3867e587e2", 391591, Common::JA_JPN, 311),

	// All four languages on one disc. Original Mac file name is Parents’ Guide FFF
	MACGAME1("fff",   "", "VroomBooks/Friends",    "7f443f2e63fd497a9ad85b10dc880a91", 413707, 313),
	WINGAME1("fff",   "", "VROOMBKS/FRIENDS.EXE",  "65d06b5fef155a2473434571aff5bc29", 384557, 313),
	MACGAME1_l("fff", "", "VroomBooks/Los Amigos", "7f443f2e63fd497a9ad85b10dc880a91", 413706, Common::ES_ESP, 313),
	MACGAME1_l("fff", "", "VroomBooks/Les Amis",   "7f443f2e63fd497a9ad85b10dc880a91", 413706, Common::FR_FRA, 313),
	MACGAME1_l("fff", "", "VroomBooks/Otomodachi", "7f443f2e63fd497a9ad85b10dc880a91", 413706, Common::JA_JPN, 313),
	WINGAME1_l("fff", "", "VROOMBKS/AMIGOS.EXE",   "65d06b5fef155a2473434571aff5bc29", 384556, Common::ES_ESP, 313),
	WINGAME1_l("fff", "", "VROOMBKS/LESAMIS.EXE",  "65d06b5fef155a2473434571aff5bc29", 384554, Common::FR_FRA, 313),
	WINGAME1_l("fff", "", "VROOMBKS/OTOMODAC.EXE", "65d06b5fef155a2473434571aff5bc29", 384554, Common::JA_JPN, 313),
	MACDEMO1("fff", "Parents' Guide", "VroomBooks/xn--Parents Guide FFF-j42j", "7f443f2e63fd497a9ad85b10dc880a91", 538761, 313),
	WINDEMO1("fff", "Parents' Guide", "VROOMBKS/PG_FFF.EXE", "65d06b5fef155a2473434571aff5bc29", 524393, 313),
	MACDEMO1("fff", "Demo", "Demo", "1ae45c23586b41997ba52e2e7c771c4c", 446649, 311),

	WINDEMO1("flw", "Demo", "FLWDEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 373260, 310),

	// Original filename is 256カラーでみてください。
	MACGAME1_l("fontfriends", "Catalog", "Try 256 colors", "f5277c53bacd27936158dd3867e587e2", 1577548, Common::JA_JPN, 311),

	MACGAME1("foocastle", "", "Foo Castle", "7f443f2e63fd497a9ad85b10dc880a91", 385299, 313),
	WINGAME1("foocastle", "", "FCASTLE.EXE", "65d06b5fef155a2473434571aff5bc29", 370481, 313),

	MACGAME1("fortuneteller", "v1.3", "The Fortune Teller 1.3", "1ae45c23586b41997ba52e2e7c771c4c", 1455979, 310),

	MACGAME1_l("fototune", "", "FotoTune Multimedia show", "1ae45c23586b41997ba52e2e7c771c4c", 378737, Common::JA_JPN, 311),

	MACGAME1("freakshow", "D3", "Freak Show Projector", "bb61dd0cc8356e51fe54c1a00f979b8f", 439227, 300),

	// Pippin version is D5
	// "Room(306)" application skips the opening cutscenes
	MACGAME1("gadget", "",			  "GADGET",		"7f443f2e63fd497a9ad85b10dc880a91", 384631, 313),
	MACGAME1("gadget", "Room(306)",	  "Room(306)",	"7f443f2e63fd497a9ad85b10dc880a91", 384629, 313),
	// MACGAME1("gadget", "Read Me",	  "Read Me",	"f5277c53bacd27936158dd3867e587e2", 392651, 311),
	WINGAME2t("gadget", "",			  "GADGET/GADGET.EXE",	"56b006cd4c970094b92ada995c9eccd1", 369009,
									  "DATA/GA00.MMM",		"0bd279685bdc6569a5ca2bcc6e458f1b", 324508, 310),
	WINGAME2t("gadget", "Room(306)",  "GADGET/ROOM306.EXE",	"7d0657bab79bc396a0c5b2271fbfeb16", 369009,
									  "DATA/GA00.MMM",		"0bd279685bdc6569a5ca2bcc6e458f1b", 324508, 310),
	MACGAME1_l("gadget", "",		  "GADGET",		"f5277c53bacd27936158dd3867e587e2", 392650, Common::JA_JPN, 311),
	MACGAME1_l("gadget", "Room(306)", "Room(306)",	"f5277c53bacd27936158dd3867e587e2", 392648, Common::JA_JPN, 311),
	// MACGAME1_l("gadget", "Read Me",	  "Read Me",	"f5277c53bacd27936158dd3867e587e2", 392651, Common::JA_JPN, 311),
	FMTGAME2_l("gadget", "",		  "GADGET/GADGET.EXE",	"56b006cd4c970094b92ada995c9eccd1", 369009,
									  "DATA/GA00.MMM",		"72ffa3d703affdf146ba19cb80e6bdbd", 324390, Common::JA_JPN, 310),
	FMTGAME2_l("gadget", "Room(306)", "GADGET/ROOM306.EXE",	"7d0657bab79bc396a0c5b2271fbfeb16", 369009,
									  "DATA/GA00.MMM",		"72ffa3d703affdf146ba19cb80e6bdbd", 324390, Common::JA_JPN, 310),
	// Warning text at the end is in both Japanese and English
	MACDEMO1("gadget", "Demo", "GADGET",	  "f5277c53bacd27936158dd3867e587e2", 390109, 311),
	WINDEMO2t("gadget", "Demo", "GADGET.EXE",		 "52a854cc16777395d05aa87859e6be5a", 684203,
								"DATA/01_HOTEL.DIR", "3287761cea8b676110a197e0c2ec7d31", 9403586, 311),

	// Original filename is 我流競馬ｵｰﾄﾃﾞﾓ
	MACDEMO1_l("garyukeiba", "Demo", "Garyu Keiba Auto Demo", "276bee761e48a6fd709df77d5c2f60dd", 392919, Common::JA_JPN, 313),

	MACDEMO1_l("goalrush1", "Demo", "GOAL RUSH!! DEMO", "f5277c53bacd27936158dd3867e587e2", 394728, Common::JA_JPN, 311),
	MACDEMO1_l("goalrush1", "Demo", "GOAL RUSH!! DEMO", "f5277c53bacd27936158dd3867e587e2", 392276, Common::JA_JPN, 311),
	MACDEMO1_l("goalrush2", "Demo", "GOAL RUSH!! DEMO", "276bee761e48a6fd709df77d5c2f60dd", 397152, Common::JA_JPN, 313),

	WINGAME1t("goferwinkel", "", "GOFERWIN/GOFER.EXE", "cba909306680f788d77244147ddf76ae", 1065773, 300),

	// Mac also has an 8-bit color binary. Win is limited to 8-bit color in D3.
	MACGAME1("golfcd", "", "Great Golf CD (24bit)", "7f443f2e63fd497a9ad85b10dc880a91", 3633301, 313),
	WINGAME2("golfcd", "", "GOLF.EXE", "65d06b5fef155a2473434571aff5bc29", 370009,
						   "GOLF.MMM", "b50a8023091450f5d2699e326b49d240", 3594574, 313),

	MACGAME1_l("gocoo", "", "GO-COO", "276bee761e48a6fd709df77d5c2f60dd", 394940, Common::JA_JPN, 313),

	MACDEMO1_l("granmarmalade", "Demo", "GranMarmalade", "f5277c53bacd27936158dd3867e587e2", 1076950, Common::JA_JPN, 311),

	MACGAME1("gustown", "", "GUS", "7f443f2e63fd497a9ad85b10dc880a91", 384206, 313),
	WINGAME2("gustown", "", "GUS.EXE", 	 "65d06b5fef155a2473434571aff5bc29", 369999,
							"CYBER.MMM", "c3b0a84cd1a8ae966c38a3deceed6496", 237702, 310),

	// Original filename is "   Hell Cab™"
	MACGAME1("hellcab", "",      "xn--   Hell Cab-t35f", "8cbe0a140f28b2165a66d73f4f153572", 601701, 313),
	MACGAME1_l("hellcab", "",    "Hell Cab", "656a96bd5bceba5f3d99b7490dda8734", 1336675, Common::JA_JPN, 313),
	WINGAME1t("hellcab", "",     "INSTALL/HELLCAB.EXE", "04d29e3212cebd0c2a30a2712cca7996", 370006, 310),
	WINGAME1t_l("hellcab", "",   "INSTALL/HELLCAB.EXE", "800dcd986c500ddb269796f59d9118b2", 370094, Common::ES_ESP, 310),
	WINGAME1t_l("hellcab", "",   "INSTALL/HELLCAB.EXE", "4b36e8e2d52166901a82c4a3f525f20f", 369982, Common::PT_BRA, 310),
	WINDEMO1t("hellcab", "Demo", "HELLCAB.EXE", "0ae05c878664bdfd2e7314d739a9f914", 370005, 310),
	MACDEMO1_l("hellcab", "Demo",   "HELLCAB Demo", "f5277c53bacd27936158dd3867e587e2", 389980, Common::JA_JPN, 311),

	// Windows version is D4
	MACGAME1("hhouse", "", "The Ultimate Haunted House", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384219, 313),
	WINDEMO2("hhouse", "1994 Demo", "HAUNTED.EXE", "2b3543a9131a49f665982d26513a84f8", 914491,
									"DEMO26.BMP",  "0b37032bbb63acf2d33e8d3b2e0a32aa", 17518, 310),

	MACGAME1("hikaruhana", "", "Shining Flower", "a6e50f2b8f294640a1d0cbe91a73e81c", 392231, 311),
	MACGAME1("hikaruhana", "Auto", "Shining Flower (Auto)", "a6e50f2b8f294640a1d0cbe91a73e81c", 392231, 311),
	MACGAME1_l("hikaruhana", "", "HikaruHana", "cebba8af8bf6e1131bdd0c7dfebfc3aa", 392231, Common::JA_JPN, 311),
	MACGAME1_l("hikaruhana", "Auto", "HikaruHana(Auto)", "cebba8af8bf6e1131bdd0c7dfebfc3aa", 392231, Common::JA_JPN, 311),
	MACDEMO1_l("hikaruhana", "Sample Version", "HikaruHana", "1e3c3caae3ba8ab04479ebc84fab326c", 392839, Common::JA_JPN, 311),

	MACDEMO1("hirezaudio", "Vol. 1 Demo", "Hi Rez Demo Projector", "1ae45c23586b41997ba52e2e7c771c4c", 1562852, 310),

	MACGAME1("hoaddams2", "", "AddamsFamilyInt", "7f443f2e63fd497a9ad85b10dc880a91", 1381040, 313),

	MACGAME1("hoangus", "", "Angus IPK", "2ce360c9ea2da80a2c6d1040b0ad92dd", 2029855, 313),
	WINGAME1("hoangus", "", "ANGUS.EXE", "7c8230a804abf9353b05627a675b5ffb", 2383326, 313),

	MACGAME1("hodolores", "", "Dolores Claiborne Interactive", "7f443f2e63fd497a9ad85b10dc880a91", 1475936, 313),
	WINGAME1("hodolores", "", "DOLRES.EXE", "65d06b5fef155a2473434571aff5bc29", 1671516, 313),

	MACGAME1("hostargate", "", "Stargate Interactive", "7f443f2e63fd497a9ad85b10dc880a91", 1394354, 313),

	MACGAME1("hothenet", "", "The Net Interactive Kit", "7f443f2e63fd497a9ad85b10dc880a91", 2027385, 313),
	WINGAME1("hothenet", "", "NET.EXE", "65d06b5fef155a2473434571aff5bc29", 2357523, 313),

	WINGAME1t("hotrekgens", "", "TREK.EXE", "dbf91fa10fef580c7f8e2962c4151d30", 1861869, 310),

	// Movies are played from HyperCard. Each of the 10 lessons and 3 practice examples are Director.
	MACDEMO1_l("hypercardlessons", "Demo", "Lesson1movie", "8ac6b58b68561d6227921cbfef30a02d", 62177, Common::JA_JPN, 300),

	MACDEMO1_l("hypermaterial", "Demo", "Browser_Demo", "f5277c53bacd27936158dd3867e587e2", 966053, Common::JA_JPN, 311),

	// Sanctuary Woods promos from Bird's Life, not present in the Win files.
	MACGAME1("ilearn", "", "More Fun!", "2ce360c9ea2da80a2c6d1040b0ad92dd", 14007865, 313),

	MACDEMO1("iliad", "", "Iliad 3.0 Demo", "cfa68a1bc49251497ebde18e5fc9c217", 270830, 200),

	WINDEMO1t("illustrator", "v4 for Windows Demo", "ADOBE.EXE", "1f857a750b64bb81fc5f4b8c89d53e5c", 225238, 300),

	WINGAME1("imaginopolis", "1994 Demo", "MSKIDS.EXE", "2b3543a9131a49f665982d26513a84f8", 370009, 310),

	// Original filesname is IMPACT!ムービー
	MACDEMO1_l("imgimpact", "Demo", "IMPACT! Movie", "a03ae8a9bf211bcb26388b6b6da17c2b", 1806375, Common::JA_JPN, 311),

	// Original filenames are ﾌﾟﾛｼﾞｪｸﾀ and 1.ノート
	MACDEMO2_l("intelligentnote", "Demo", "Projector", "a03ae8a9bf211bcb26388b6b6da17c2b", 320750,
										  "1.Note",    "9afa1fce2f0f999e00af7d32cb8bd82d", 4690, Common::JA_JPN, 311),

	MACGAME1_l("intro", "", "xn--w8jm4fv92r", "f5277c53bacd27936158dd3867e587e2", 392314, Common::JA_JPN, 311),

	WINGAME2t_l("intro1", "", "INTRO_01.EXE", "fe7c54b4af5508ef7378474c7e909a2b", 370007,
							  "INTRO_01.MMM", "d1c6d74fab37ea4443116c70d5c3fbad", 9889324, Common::JA_JPN, 311),

	// Original filename is 犬組デモ
	MACDEMO1_l("inugumi", "Demo", "Inugumi Demo", "f5277c53bacd27936158dd3867e587e2", 2366437, Common::JA_JPN, 311),

	MACGAME1("ipc", "", "About InterActive Publishing", "ec7aaa66647e526d72cb1c1d802df48b", 3056270, 313),
	WINGAME1("ipc", "", "ABOUTIPC.EXE", "65d06b5fef155a2473434571aff5bc29", 4270544, 310),
	// From Supersonic: A Multimedia Guide to Modern Military Aircraft
	MACGAME1("ipc", "", "About InterActive Publishing", "ec7aaa66647e526d72cb1c1d802df48b", 3033242, 313),
	WINGAME1("ipc", "", "ABOUTIPC.EXE", "4e6303630f4dd588e730d09241cf7e76", 3275100, 310),

	// Bilingual English/Spanish
	// Uses audio tracks
	MACGAME1("iptr", "CD", "I Photograph to Remember", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 405746, 300),
	MACGAME1("iptr", "Hard Disk", "I Photograph to Remember", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 400353, 300),
	MACDEMO1("iptr", "Sampler", "I Photograph to RememberBIG", "a46f8441517e09088aad16decb13580d", 2632155, 311),

	// Windows version is not Director
	// Mac version requires installation, 'Iron Helix™ Installer' / 'Iron Helix™ Minimum Installer', Stuffit
	// Original English filenames are 'Iron Helix™' and 'Iron Helix™ Minimum'
	MACGAME1("ironhelix", "", "xn--Iron Helix-398e/xn--Iron Helix-398e", "1ae45c23586b41997ba52e2e7c771c4c", 1757732, 311),
	MACGAME1("ironhelix", "Minimum", "xn--Iron Helix Minimum-lu3k/xn--Iron Helix Minimum-lu3k", "1ae45c23586b41997ba52e2e7c771c4c", 1608601, 311),
	MACGAME1_l("ironhelix", "", "Iron Helix", "f5277c53bacd27936158dd3867e587e2", 1746029, Common::JA_JPN, 311),
	MACGAME1_l("ironhelix", "Compact", "Iron Helix Compact", "f5277c53bacd27936158dd3867e587e2", 1596222, Common::JA_JPN, 311),
	MACDEMO1("ironhelix", "1992 Demo", "IRON HELIX DEMO", "7c80091b84d4d5d48f7c773b30b10598", 1634645, 310),
	MACDEMO1_l("ironhelix", "1993 Demo", "Iron Helix Demo (Japanese)", "1ae45c23586b41997ba52e2e7c771c4c", 378545, Common::JA_JPN, 311),
	MACDEMO1("ironhelix", "1994 Demo", "IRON HELIX DEMO", "7f443f2e63fd497a9ad85b10dc880a91", 2031615, 313),

	// From the two-floppy set Japan Art Today 04; this is the only Director application.
	// The others use different tools.
	// Original filename is '04-12SHOCHOROTｱﾆﾒ'
	MACGAME1_l("japanart04", "", "xn--04-12SHOCHOROT-eg31fvj4g", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 452303, Common::JA_JPN, 300),

	// Original filename is ' ﾀﾞﾌﾞﾙｸﾘｯｸして下さい'
	MACGAME1_l("japanart14", "", "xn-- -17t4bh9e390vlr5tbcab1fyg4fl2eb", "276bee761e48a6fd709df77d5c2f60dd", 393777, Common::JA_JPN, 313),

	MACGAME1("jman", "",	 "Journeyman.16 MB", "1ae45c23586b41997ba52e2e7c771c4c", 437743, 300),
	MACGAME1("jman", "v1.2", "Journeyman 16MB",  "2ce360c9ea2da80a2c6d1040b0ad92dd", 440902, 313),
	WINGAME1("jman", "", "JMAN.EXE",		 "7c8230a804abf9353b05627a675b5ffb", 375282, 300),
//	WINGAME1_l("jman", "", "JOURNEY.EXE",	 "65d06b5fef155a2473434571aff5bc29", -1, Common::JA_JPN, 300), FIXME: Needs additional file
	MACDEMO1("jman", "Sneak Preview", "Journeyman Sneak Preview", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 6222633, 300),
	MACDEMO1("jman", "CD Demo", "Journeyman Demo", "1ae45c23586b41997ba52e2e7c771c4c", 3077381, 311),
	MACDEMO1("jman", "CD Demo", "Journeyman Demo", "424093b2bc04a1bfa4376c878f67a364", 3083188, 300),
	MACDEMO1("jman", "v1.2 Demo", "Journeyman Demo", "1ae45c23586b41997ba52e2e7c771c4c", 3077381, 311),
	MACDEMO1("jman", "IMG CD Demo", "Journeyman Demo", "1ae45c23586b41997ba52e2e7c771c4c", 2880877, 311),
	MACDEMO1("jman", "Looping Demo", "Journeyman Looping Demo", "1ae45c23586b41997ba52e2e7c771c4c", 3077402, 311),
	WINDEMO1("jman", "Demo", "JMDEMO.EXE", "7c8230a804abf9353b05627a675b5ffb", 375305, 300),

	// Original filename is JOINT-net/DEMO
	MACDEMO1_l("jointnet", "Demo", "JOINT-net-DEMO", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 895326, Common::JA_JPN, 300),

	// HyperCard game calls movie using external MacroMind Player
	MACGAME2_l("jyajya", "", "MacroMind Player", "f5277c53bacd27936158dd3867e587e2", 390204,
							 "JyajyaInit",		 "5d96a5c42b500370663431f360af3629", 669, Common::JA_JPN, 311),

	// Original filename is 信光の勝馬道場ｵｰﾄﾃﾞﾓ
	MACDEMO1_l("katsumadojo", "Demo", "Shinko's Katsuma Dojo Auto Demo", "a1da9af48fe47cf9c7e90f83dd5ddd0f", 2138506, Common::JA_JPN, 313),

	// Original filename is 数ヤ君デモ
	MACDEMO1_l("kazuyakun", "Demo", "Kazuya-kun Demo", "276bee761e48a6fd709df77d5c2f60dd", 8631576, Common::JA_JPN, 313),

	// Series of HyperCard stacks with 22 Director movies
	MACGAME2_l("keiri", "", "Title",   "99da7ea12500740dc3aa1ee4c7408e86", 24333,
							"Title2a", "4f246b30ccbad438e09fdd7c13b97c86", 37069, Common::JA_JPN, 300),

	WINGAME1("keroppi", "", "KEROPPI.EXE", "65d06b5fef155a2473434571aff5bc29", 371272, 310),

	// Original filename is 棋士道
	MACDEMO1_l("kishido", "Demo", "Kishido", "f5277c53bacd27936158dd3867e587e2", 4026173, Common::JA_JPN, 311),

	// Original filename is KOYOSHA INSPIRE シリーズ
	MACDEMO1_l("koyosha", "Demo", "KOYOSHA INSPIRE series", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384058, Common::JA_JPN, 313),

	// Original filename is Kai's Power Tools™ Demo 1.0dj-j
	MACDEMO1_l("kpt", "Demo", "Kai's Power Tools Demo 1.0dj-j", "1ae45c23586b41997ba52e2e7c771c4c", 381144, Common::JA_JPN, 311),

	MACGAME1("kyoto", "v1.01", "Cosmology of KYOTO", "f5277c53bacd27936158dd3867e587e2", 392249, 311),
	MACDEMO1("kyoto", "Demo", "COK Overview-E", "f5277c53bacd27936158dd3867e587e2", 2140545, 311),
	MACDEMO1_l("kyoto", "Demo", "DemoStart(J)", "f5277c53bacd27936158dd3867e587e2", 441040, Common::JA_JPN, 311),

	// Full product lineup for The Learning Company (1994)
	// Windows version includes a 16-color executable
	MACGAME1("learningsystem", "Billboard", "The Learning System", "7f443f2e63fd497a9ad85b10dc880a91", 384230, 313),
	WINGAME1("learningsystem", "Billboard", "BBWIN256.EXE", "7c8230a804abf9353b05627a675b5ffb", 375297, 313),

	MACGAME1("legendsofoz", "", "OZMM", "ef9b835d26074e9e5ba10e0432404253", 1051364, 313),
	WINGAME1("legendsofoz", "", "OZMM.EXE", "236c3b91788d7d5308691ef27fe91aa0", 369250, 313),

	// Portuguese version is D4
	MACGAME1("leonardo", "", "Leonardo the Inventor", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384215, 313),
	WINGAME2("leonardo", "", "LEO.EXE", 	 "65d06b5fef155a2473434571aff5bc29", 370000,
							 "BEGINLEO.MMM", "aec1417e69dd85c5c00fae628b150a0d", 812, 310),

	// European multilanguage (En-Fr-De-Es-It)
	WINGAME2t("leonardo", "", "LEO.EXE", 	  "f5767a0c04966f5b5a61ac20fc141a7d",  370013,
							  "LANGUAGE.MMM", "adbd451a838fc412dd3d8a5d3eca2836 ", 546658, 310),

	WINDEMO2("leopardspots", "Demo", "LEOPARD.EXE", "2b3543a9131a49f665982d26513a84f8", 1081371,
									 "DEMO37.BMP",	"6be5fb3f1aa30dfa6db320a2a8c484c8", 17518, 310),

	MACGAME1("lingoexpo", "", "Navigator", "4dacf23c1bb75093a882c4fd89dededb", 38, 400),

	MACGAME1_l("lvi", "Nº1", "xn--LVI8Mo-ka28a", "7f443f2e63fd497a9ad85b10dc880a91", 384206, Common::FR_FRA, 310),
	WINGAME1_l("lvi", "Nº1", "LVI.EXE", "65d06b5fef155a2473434571aff5bc29", 634203, Common::FR_FRA, 310),

	MACDEMO1_l("lotus123", "Tour", "Tour of 1-2-3.v3", "1ed38b71d8d0f075483117f7fa559e7c", 367077, Common::JA_JPN, 302),
	WINDEMO1t("lotus123", "Release 4 Tour", "123TOUR.EXE", "3192b417bdc7a11b266ceed5b6476ee2", 353568, 300),

#undef SUPPORT_STATUS
#define SUPPORT_STATUS ADGF_NO_FLAGS

	MACGAME1("lzone",  "",	"L-ZONE", "f5277c53bacd27936158dd3867e587e2", 392228, 311),
	// MACGAME1("lzone", "Readme", "Read Me First", "f5277c53bacd27936158dd3867e587e2", 392224, 311),
	MACGAME1("lzone", "v2",	"L-ZONE", "276bee761e48a6fd709df77d5c2f60dd", 395088, 313),
	// MACGAME1("lzone", "Readme",	"Read Me First", "276bee761e48a6fd709df77d5c2f60dd", 394664, 313),
	GENGAME1_("lzone", "",	"L-ZONE", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 384712, Common::EN_ANY, Common::kPlatformMacintoshII, ADGF_MACRESFORK, 300),
	WINGAME1t("lzone", "",	"L_ZONE/L_ZONE.EXE", "079429bfc54a1df8e7b4d379aefa0b59", 370009, 300),

#undef SUPPORT_STATUS
#define SUPPORT_STATUS ADGF_UNSTABLE

	// This may be a hybrid of media from Director, HyperCard, and Farallon MediaTracks
	// Original filenames are MB.DemoMovie/C and MB.DemoMovie/M
	MACDEMO1_l("macbasic", "Color Demo", "MB.DemoMovie-C", "7ed88097881eaf2ae4b05c9bf7efdc7c", 170323, Common::JA_JPN, 310),
	MACDEMO1_l("macbasic", "Monochrome Demo", "MB.DemoMovie-M", "3c3f3b36eb63d8148b5a3517e3febdfc", 39876, Common::JA_JPN, 310),

	// Training movies that came with preinstalled Mac OS 7 installs
	MACGAME1("macbasics", "v5.0.3", "Macintosh Basics", "2ce360c9ea2da80a2c6d1040b0ad92dd", 403625, 310),
	MACGAME1("mousebasics", "v4.5", "Mouse Basics", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 360662, 300),
	MACGAME1("mousebasics", "", "Mouse Basics", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 360704, 300),

	MACGAME2_l("macintosho20", "", "DOB", "f5277c53bacd27936158dd3867e587e2", 392248, "data", "7379e695efd1cb858c3cb28ec2e8fac6", 1513714, Common::JA_JPN, 311),

	MACGAME1("macweekvideo", "", "Click Here To Get Started!", "dc99af32d1580cd6177dc77d49a103d6", 383331, 313),

	// HyperCard stack that calls a single movie using PlayAccel and MacroMind Player 3.1
	// Original HyperCard filename is EXPO CD™ Boston 1992
	// This nice looping intro movie is QTMoovs:Expo intro anim.mma
	MACGAME2("macworldexpo92", "", "MacroMind Player",	  "1ae45c23586b41997ba52e2e7c771c4c", 372737,
								   "xn--EXPO CD Boston 1992 -vh7l", "4799cdcd7394a1eccb14b667a1ee2707", 71106, 310),

	// Original filename is ﾌﾟﾛｼﾞｪｸﾀ
	MACDEMO2_l("maczaurus", "Demo", "Projector", "a03ae8a9bf211bcb26388b6b6da17c2b", 309263,
									"MSI C-S",   "224006f035e5f5fc0dd0133fbc5c6b89", 142729, Common::JA_JPN, 311),

	// Original Mac filename is Maniac Sports™
	MACGAME1("maniacsports", "", "xn--Maniac Sports-8q9g", "2ce360c9ea2da80a2c6d1040b0ad92dd", 420962, 311),
	WINGAME2t("maniacsports", "", "MANIAC.EXE", "06c073b9e084e7f41c814f00229e3cde", 371274,
								  "SUPPORT/MSINTRO.MMM", "02bfadbf255139d60a0b9dd1382936d1", 377340, 311),

	MACDEMO1_l("marinefantasy", "Demo", "MarineFantasy", "276bee761e48a6fd709df77d5c2f60dd", 394970, Common::JA_JPN, 313),

	// Mac version on same disc is D4
	// Developed by MetroLight Studios, Los Angeles
	// Published by Cambrix, Woodland Hills, California (1996)
	WINGAME2("mask", "", "MASK.EXE", "c7da3e208b35c77d39af787cf74a57ae", 2377627,
						 "MEDIA/GRAPHICS/G001_1.PIC", "4b8b3b5379cf7ceecf9ac444e0b241d5", 207148, 311),

	// aka Bit-Bot's Math Voyage; A Viagem na Matemática do Bit Bot (PT-BR)
	// Developed by Magic Quest, Inc.
	// Floppy version of Bit-Bot's Math Voyage (v2.0.4) requires installation, InstallShield v3
	//   {"BBMV1.Z", "4d8576b627d6dcc79d0a57237261a0ef", 264550}
	//   {"BBMV2.1", "e8c7538d7e2942a91412375873188177", 710280}
	//   {"BBMV2.2", "8a1c7a1a1088713b27bb3dc2aadee46b", 1430074}
	//   {"BBMV2.3", "3ee535d23a7452b5905607ff708f46b2", 195088}
	//   {"BBMV3.Z", "a7ffc5ca2248b0586fa18a25791ff8c7", 1006724}
	MACGAME1("mathacejr", "v1.0.1", "xn--Math Ace Jr. CD-le3i", "2ce360c9ea2da80a2c6d1040b0ad92dd", 654765, 313),
	WINGAME1t("mathacejr", "v1.0.8", "MATHACEJ.EXE", "f31adf00de16b451d5a516788d14f84a", 678371, 310),
	WINGAME1t("mathacejr", "v2.0.4", "BBMV.EXE", "8306aab5c8ecae7911adf68bc3634cea", 429822, 310),
	WINGAME1t("mathacejr", "v2.0.10", "BBMV.EXE", "7bb0a645d72403a47621a95540b11530", 637336, 310),
	WINGAME1t_l("mathacejr", "v2.0.14", "BBMV.EXE", "4eb5532666489fd01c605f64e268d9b6", 678289, Common::PT_BRA, 310),

	MACGAME1("maze", "", "Maze", "c4917547b9d9fda87567a9b3544489c4", 384278, 300),
	MACGAME1("maze", "", "Maze", "39b6473190fb6f175c9dc5fbd7349de0", 327110, 300),

	// Selection of demos narrated by the MazeBox Tone Cruise mascot:
	//		Pyramid Interactive, Virtual Cocktail Bar, MazeBrew, Virtual Edo Castle,
	//		Soul Gunner, Q TV, Tennoz, Kokuyo, a CD-ROM cultural course, and others
	// Original filename is 付録
	MACGAME1_l("mazebox", "Vol.1", "xn--bnq597n", "f5277c53bacd27936158dd3867e587e2", 419531, Common::JA_JPN, 311),

	// Game runs from Aldus SuperCard with Director launcher and movies
	// This demo detection entry is for the movie launched from "MazeBox Works Vol.1", do not use
	// MACDEMO1_l("mazebrew", "Demo", "MBW", "3350d8c895d47d217d2dfa58aa95496d", 558, Common::JA_JPN, 311),
	MACGAME1_l("mazebrew", "v2.0", "MazeBrew  v.2.0", "f5277c53bacd27936158dd3867e587e2", 491957, Common::JA_JPN, 311),

	MACDEMO1("meetingmaker", "Demo", "Meeting Maker Demo", "19fe54e0b5c60405c7a88d9e4e032965", 721720, 300),

	WINDEMO1("mindbrain", "Demo", "INSTALL.EXE", "54fbe8edce6731ba6e89c16fd3be8e6d", 2558723, 404),

	// Original filename is ピーターと狼
	// One gameplay mode supports General MIDI
	MACDEMO1_l("mipeterwolf", "Demo", "Peter and the Wolf", "f5277c53bacd27936158dd3867e587e2", 394653, Common::JA_JPN, 311),
	MACDEMO1_l("mipeterwolf", "Demo", "xn--o9juj9b8hb1942h", "f5277c53bacd27936158dd3867e587e2", 394644, Common::JA_JPN, 311),
	// Decomposed variant of the above filename
	MACDEMO1_l("mipeterwolf", "Demo", "xn--o9j5ete2cvkb7839i", "f5277c53bacd27936158dd3867e587e2", 394644, Common::JA_JPN, 311),

	MACDEMO1("mmmozart", "Sampler", "Mozart Sampler", "67fb0a6c1b3c11367b06e2cf30c9ced9", 1700284, 311),
	MACDEMO1("mmschubert", "Sampler", "Schubert Sampler", "52890d7211ae1258734c612f636da2c0", 1703212, 311),

	MACDEMO1_l("moderntimes", "Demo", "ModernTimes", "f5277c53bacd27936158dd3867e587e2", 391357, Common::JA_JPN, 311),
	MACDEMO1_l("moderntimes", "Demo", "ModernTimes", "f5277c53bacd27936158dd3867e587e2", 391334, Common::JA_JPN, 311),

	MACGAME1("mousepractice", "", " Mouse Practice", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 349937, 300),

	// Demos from The Computer Buyer Collection Volume 1 - Sep 1995
	WINDEMO2t("msarcade",	   "Demo",		"ARCADE.EXE",   "a7f83e35541a2952cd4848becee98c1d", 1843614,
											"DEMO2.BMP",	"7a28df7b3c8e46ac03d2c093bf60da86", 17518, 310),
	WINDEMO1("msartgallery",   "Demo",		"ARTGDEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 370002, 310),
	WINDEMO2("msbaseball",	   "1994 Demo",	"BASEBALL.EXE", "2b3543a9131a49f665982d26513a84f8", 370013,
											"BASEB1.MMM",	"12442f926d45ec25c6c2a9814229dc01", 1268842, 310),
	WINDEMO2("msbasketball",   "1994 Demo",	"BASKET.EXE",   "2b3543a9131a49f665982d26513a84f8", 370014,
											"BASKET1.MMM",	"5cecd4221e2b3b1d3cabc0d270631bfb", 799854, 310),
	WINDEMO2("msbhumanbody",   "1994 Demo", "HUMAN.EXE",	"2b3543a9131a49f665982d26513a84f8", 918807,
											"DEMO27.BMP",	"e2f2097bb3e44f98defeee9bbd4ed675", 17518, 310),
	WINDEMO2("msbsolarsystem", "1994 Demo",	"SOLAR.EXE",	"2b3543a9131a49f665982d26513a84f8", 930151,
											"DEMO28.BMP",	"80d9e50b6375124b7e13904982d2bfbd", 17518, 310),
	WINDEMO1("mscomposers",	   "Demo",		"COMPDEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 370005, 310),
	WINDEMO2("msdinosaurs",	   "Demo",		"DINODEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 370003,
											"DINODEMO.MMM", "10e316126c6a7f8e61a7c2cac81141dc", 2914748, 310),
	WINDEMO2("msflight",	   "Demo",		"FLIGHT.EXE",   "2b3543a9131a49f665982d26513a84f8", 3485236,
											"DEMO19.BMP",	"af4ae36145d47e895e89ecd784f6835d", 17518, 310),
	WINDEMO1("msfonts",		   "Demo",		"FNTS.EXE",		"2b3543a9131a49f665982d26513a84f8", 1419279, 310),
	WINDEMO2("msgolf",	  	   "1994 Demo", "GOLFDEMO.EXE", "febc8580c2d7d91b635f961c4f63da01", 4350031,
											"BMP1S1.AIF",	"baebf66575633107875c6cff78db0c1b", 77628, 311),
	WINDEMO2("msmoney",		   "Demo",		"MONEY.EXE",	"2b3543a9131a49f665982d26513a84f8", 2510607,
											"VMDEM.AIF",	"5aa4f6cb232fb6f2eb29e428c0249a3d", 200390, 310),
	WINDEMO1("msmouse",		   "1994 Demo",	"MOUSE2OH.EXE", "2b3543a9131a49f665982d26513a84f8", 370016, 310),
	WINDEMO1("msmouseh",	   "1994 Demo",	"HMOUSE.EXE",   "2b3543a9131a49f665982d26513a84f8", 370013, 310),
	WINDEMO1("msmusint",	   "Demo",		"MUSIDEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 370003, 310),
	WINDEMO1("msnatkey",	   "1994 Demo",	"QUIKLOOP.EXE", "2b3543a9131a49f665982d26513a84f8", 370016, 310),
	WINDEMO1("mspublish",	   "v2.0 Demo",	"PUBDEMO.EXE",  "2b3543a9131a49f665982d26513a84f8", 3184344, 310),
	WINDEMO1("mspublishd",	   "Demo",		"PUBLISH.EXE",  "2b3543a9131a49f665982d26513a84f8", 1644502, 310),
	WINDEMO1("mssndbits",	   "Demo",		"SNDBITS.EXE",  "2b3543a9131a49f665982d26513a84f8", 1476769, 310),

	// Found on CD-ROM Today, #4
	WINDEMO2t("msbaseball", "Demo", "BASEBALL.EXE", "3c11ad6da2a2c9dcb7e02171b04ce23d", 375284,
									"BASEB1.MMM",	"6cd090073aa3e159490d4a0458adaf7e", 1251222, 300),

	MACGAME1("msdinosaurs", "Overview Movie", "Overview Movie", "479541070b3cbab6fd8473ce6267fb98", 792604, 310),
	// From CD Loisirs Nº6
	WINDEMO2t("msdinosaurs", "Demo", "DINOSAUR.EXE", "593f33ddf837f0b9c737712351ff6faa", 370013,
									 "DINODEMO.MMM", "78863a9c384aea75affff8bb61294751", 2959664, 300),

	// From CD Loisirs Nº6
	WINDEMO2t("msdangerous", "Demo", "DANGER.EXE", "04af79d00b4492d86baff5fe3601f534", 370004,
									 "DANG1.MMM", "57b3823b36c60a065bb6f8a11d49dccb", 4872194, 300),
	WINDEMO2t("msspaceflight", "Demo", "SPACE.EXE", "66eeaad4eb9d8ed1ad9c445ed4eacb14", 370004,
									   "FLIG1.MMM", "fcdf7ed5bf3da589ef3d516db2b97af1", 4097580, 300),

	MACDEMO1("msproject", "Demo", "MS Project demo", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 1059914, 300),

	// "Message from Apple" found on Nikkei Mac CD-ROM (1994-2-17)
	// "from Apple/Message" found on Macintosh Demo Software Zenshuu CD-ROM '94, disc 1
	MACGAME1_l("msgfromapple", "", "Message from Apple", "4c7fddccfe5ab2e9c6398efa5dbe37c1", 395566, Common::JA_JPN, 313),
	MACGAME1_l("msgfromapple", "", "from Apple/Message", "4c7fddccfe5ab2e9c6398efa5dbe37c1", 395526, Common::JA_JPN, 313),

	// French version is D5
	MACGAME1("murderbrett", "", "The Environmental Surfer", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384213, 300),
	WINGAME1("murderbrett", "", "BRETTP.EXE", "65d06b5fef155a2473434571aff5bc29", 370010, 300),

	MACGAME2("murdermagic", "", "The Magic Death", "a8788e8b79dccc582b9818ec63734bed", 736498,
								"Support/Alibis",  "4d13f45b86ccffef28985a9ab2b04132", 370074, 313),
	WINGAME2t("murdermagic", "", "MAGIC.EXE",  "86416853b3f18e841c091dd551f0fa53", 375298,
								 "ALIBIS.MMM", "c77e7f0771aee22c5bf219a9073a9aeb", 543666, 310),

	// Original Mac English filename is Who Killed Sam Rupert?
	// Original Japanese demo filename is サム・ルパート殺人事件ﾃﾞﾓ
	// English Mac demo from The Family Doctor, 3rd Edition
	MACGAME2("murdersam", "",		"xn--Who Killed Sam Rupert-iba04l",  "243ed9ef948de907401784d0938a4ed5", 518740,
									"Sam Rupert/Alibis",				 "c496cb1502cd50af164a3ed7cf659762", 2608803, 310),
	WINGAME1("murdersam", "1993", 	"RUPERT.EXE", "5c6862a40a48881913ee7c50d25cd984", 225256, 300),
	WINGAME2("murdersam", "1994", 	"SAM.EXE",	"65d06b5fef155a2473434571aff5bc29", 370016,
								  	"ALIBIS.MMM", "effe3e6f9b60da13ba7d39caa44632af", 2720784, 310),
	MACDEMO1("murdersam", "Demo", 	"Sam Rupert Demo", "1ae45c23586b41997ba52e2e7c771c4c", 375280, 310),
	MACDEMO1_l("murdersam", "Demo", "Sam Rupert Murder Demo", "2ce360c9ea2da80a2c6d1040b0ad92dd", 382269, Common::JA_JPN, 313),

	// German and Korean versions are D4
	MACGAME1("murdertaylor", "", "Taylor French", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384213, 300),
	WINGAME1("murdertaylor", "", "TAYLORF.EXE", "65d06b5fef155a2473434571aff5bc29", 370010, 300),

	// Found on CD-ROM Today, #4
	MACDEMO1("myfavmonster", "Demo", "Monster Projector", "2ce360c9ea2da80a2c6d1040b0ad92dd", 417605, 313),
	WINDEMO2t("myfavmonster", "Demo", "MONSTER.EXE", "ba7d54defb25afcc92815006ca75ea39", 375283,
									  "IPL.MMM",	 "0119abf0ba09f7684aef45abfb4ac47e", 27372, 300),

	MACGAME1("mylk", "", "Mylk DoubleClickMe!", "8a33471513b6896d3d13b8a9c8790d86", 356024, 300),

	MACDEMO1("necrobius", "Demo", "Necrobius (Demo)", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 356609, 300),

	MACDEMO1("necromancer", "Demo", "Necromancer Launch", "7f443f2e63fd497a9ad85b10dc880a91", 385441, 313),

	// Original filename is 建築見積ｿﾌﾄ Movie
	MACDEMO1_l("negishihomes", "Demo", "Kenchiku Mitsumori Sofuto Movie", "276bee761e48a6fd709df77d5c2f60dd", 1880083, Common::JA_JPN, 313),

	MACDEMO1("newton", "Demo", "Complete Newton Demo", "7f443f2e63fd497a9ad85b10dc880a91", 383319, 313),

	MACGAME1("nightrider", "", "Night Rider", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 351573, 301),

	WINDEMO1("nmm", "Demo", "NMMDEMO.EXE", "27f013955218ac0b57241d0b4768ad6c", 7621747, 311),

	MACDEMO1_l("nonta", "Demo", "Nonta", "f5277c53bacd27936158dd3867e587e2", 390006, Common::JA_JPN, 311),

	// Original movie filename is NOVA オープニングZ
	MACDEMO2_l("novacity", "Demo", "demo",			 "f5277c53bacd27936158dd3867e587e2", 390125,
								   "NOVA Opening Z", "1ffe4ff06bb9a2a97d76e5e20c51dcc8", 3810895, Common::JA_JPN, 311),

	MACDEMO1_l("nsxpress", "Demo", "NSX Press", "f5277c53bacd27936158dd3867e587e2", 451879, Common::JA_JPN, 311),
	MACDEMO1_l("oceansbelow", "Demo", "Oceans Below Auto-Demo", "f5277c53bacd27936158dd3867e587e2", 2680055, Common::JA_JPN, 311),

	MACDEMO1("ofoto", "Tour", "Ofoto Tour", "5cc0930b4cd0b9dfc587b241ba37bf54", 353745, 300),

	// Original projector filenames are OLﾌﾟﾛｼﾞｪｸﾀ and ﾌﾟﾛｼﾞｪｸﾀ
	// Second filename is 藤沢.ムービー
	MACDEMO1_l("olnet", "Light Demo", "OL Projector",	"f5277c53bacd27936158dd3867e587e2", 4447122, Common::JA_JPN, 311),
	MACDEMO2_l("olnet", "Net Demo",	  "Projector",		"a03ae8a9bf211bcb26388b6b6da17c2b", 439678,
									  "Fujisawa.Movie", "dbb8c3b27f5017f5fa10c3fc77da8282", 5554, Common::JA_JPN, 311),

	// Game is HyperCard based. Movies will play with --start-movie from console.
	MACGAME1("osmo", "v1.6 Floppy", "vwLogos", "7ca99dfa4b620da808266ce75cabc311", 1770, 311),

	{
		{
			"osmo", "v1.2 CD",
			AD_ENTRY1s("vwIntroOsmo", "910c6e4bf76294802e985e5b55994a73", 11118),
			Common::EN_ANY,
			Common::kPlatformMacintosh,
			(ADGF_CD|ADGF_MACRESFORK|SUPPORT_STATUS),
			GUIO1(GUIO_NOASPECT)
		},
		GID_GENERIC,
		311
	},

	MACDEMO1("pagemaker", "5.0 Demo", "PageMaker 5.0 Demo", "cdb60bbb5f203e860de63df641bf5995", 1425719, 310),

	MACGAME1_l("peaceland", "", "PeaceLand 8m", "f5277c53bacd27936158dd3867e587e2", 392232, Common::JA_JPN, 311),
	MACDEMO1_l("peaceland", "Demo", "PeaceLand", "276bee761e48a6fd709df77d5c2f60dd", 393877, Common::JA_JPN, 313),

	WINGAME1t_l("phibos", "", "PHIBOS.EXE", "298f47fd72d3f3cee220c25dd797dbb4", 747095, Common::JA_JPN, 404),

	// Original Mac-only release
	MACGAME1_l("picklesbook", "", "Pickle's Book/Pickle", "c9ec74eea228500976ba680a362308bb", 456728, Common::JA_JPN, 300),
	// On the same CD as the Windows version, but built with a different version?
	MACGAME1("picklesbook", "", "Pickle", "276bee761e48a6fd709df77d5c2f60dd", 528017, 310),

	MACDEMO1_l("picturecard", "Demo", "Surmount", "f5277c53bacd27936158dd3867e587e2", 4407104, Common::JA_JPN, 311),

	MACDEMO1("pixar", "1993 Demo", "Pixar Projector", "1ae45c23586b41997ba52e2e7c771c4c", 2323942, 310),

	MACDEMO1("playroom", "Color Demo", "Color Playroom Demo", "b29b31f423a332e7f9e059187e62e1be", 1000478, 300),
	// MACDEMO1("playroom", "Demo",	   "Demo",				  "b29b31f423a332e7f9e059187e62e1be", 1000478, 300),

	MACGAME2_l("presenpack", "", "Start",		 "f5277c53bacd27936158dd3867e587e2", 389999,
								 "SampleMovie1", "ad6bc606c81db01035f12e3d230d6b89", 2872686, Common::JA_JPN, 311),

	// Product is by 株式会社パークウェーブ (Parc Wave)
	// Original filename is PRESSiT.デモ
	MACDEMO1_l("pressit", "Demo", "PRESSiT.Demo", "f5277c53bacd27936158dd3867e587e2", 1209513, Common::JA_JPN, 311),

	MACDEMO1("provektor2", "Demo", "Provektor Demo", "7c80091b84d4d5d48f7c773b30b10598", 1238290, 311),
	MACDEMO1("provektor2", "Cheese Grater", "Cheese", "7c80091b84d4d5d48f7c773b30b10598", 388625, 311),
	MACDEMO1("provektor3", "Demo", "PV3_Demo", "7c80091b84d4d5d48f7c773b30b10598", 1437117, 311),
	MACDEMO1("provektormed", "Demo", "PVM_Demo", "7c80091b84d4d5d48f7c773b30b10598", 2025083, 311),

	MACGAME1_l("pyramidint", "", "Pyramid Interactive", "f5277c53bacd27936158dd3867e587e2", 396919, Common::JA_JPN, 311),
	MACDEMO1_l("pyramidint", "Demo", "PyramidInteractive", "f5277c53bacd27936158dd3867e587e2", 1590926, Common::JA_JPN, 311),

	WINGAME2t_l("rad1", "", "WIN/RAD.EXE",   "664059c3a8f1acce4f469f4761264972", 375278,
							"RADD/RAD1.MMM", "5f6af07fecaac4820c19d5e10c50d3a0", 1392154, Common::JA_JPN, 310),

	MACDEMO1("ramdoubler", "", "RAM Doubler Tour", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 445441, 300),

	// Original filename is ランダムドット
	MACGAME1_l("randomdot", "", "xn--6ckgpc8i3bzd", "f5277c53bacd27936158dd3867e587e2", 392934, Common::JA_JPN, 310),

	// Original Japanese filename is レイドリームデモVer.1
	MACDEMO1("raydream", "Tour", "Ray Dream Designer Tour", "1ae45c23586b41997ba52e2e7c771c4c", 3170687, 311),
	MACDEMO1("raydream", "Gallery", "Ray Dream Gallery 3.2", "2ce360c9ea2da80a2c6d1040b0ad92dd", 6007322, 313),
	MACDEMO1_l("raydream", "Demo", "Ray Dream Demo Ver.1", "276bee761e48a6fd709df77d5c2f60dd", 394826, Common::JA_JPN, 313),

	MACDEMO1("redshift", "1993 Demo", "RedShift Demonstration", "1ae45c23586b41997ba52e2e7c771c4c", 2503476, 311),

	MACGAME1_l("refixion1", "", "REFIXION", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 355989, Common::JA_JPN, 300),
	MACGAME1_l("refixion2", "", "Museum or Hospital", "1ae45c23586b41997ba52e2e7c771c4c", 375585, Common::JA_JPN, 300),
	MACGAME1_l("refixion3", "", "The Reindeer Story", "f5277c53bacd27936158dd3867e587e2", 392217, Common::JA_JPN, 300),

	MACGAME1_l("reinedesneiges", "", "La Reine des Neiges", "a546ef2b921a9b48fd93928f1a505f22", 483490, Common::FR_FRA, 404),
	WINGAME1t_l("reinedesneiges", "", "RDNMOF.EXE", "ab9aa09225b65ed997ad18a8ff3993bf", 741699, Common::FR_FRA, 404),

	// Original Mac version is Director. Later DOS port uses MADE engine (also in ScummVM).
	MACDEMO1("rodneyfs", "Demo", "Rodney's Funscreen demo", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 356610, 300),
	// MACDEMO1("rodneyfs", "Demo", "Sample Application",	"9f0bb7ec7720e4f680ee3aa3d22c1c9d", 356610, 300),
	MACGAME1("rodneyfs", "", "Rodney's Funscreen", "aee832d8a6903b138f76b40bcee84637", 328535, 310),

	MACGAME1("rodneyww", "", "xn--Wonder Window-8q9g", "1ae45c23586b41997ba52e2e7c771c4c", 375226, 310),
	WINGAME1("rodneyww", "", "APP/RWW.EXE", "dac3b117db9be024ff6747b1b6c49d9c", 408259, 310),

	MACGAME1("satodesign", "Gift Disk", "Animation", "a03ae8a9bf211bcb26388b6b6da17c2b", 388853, 311),
	MACGAME1("satohomosexual", "", "SATO&NAKAZAWA", "a03ae8a9bf211bcb26388b6b6da17c2b", 736276, 311),

	MACGAME1_l("schoolworld", "Breed",	  "BREED",			  "f5277c53bacd27936158dd3867e587e2", 545024, Common::JA_JPN, 311),
	WINGAME2t_l("schoolworld", "Breed",	  "BREED.EXE",		  "4dcee516cdda1661c2c62852d8c1350f", 375277,
										  "BREED.MMM",		  "0bc20ce52a7672998e45b48ea5f28b42", 34576, Common::JA_JPN, 310),
	MACGAME1_l("schoolworld", "Capture",  "CAPTURE",		  "f5277c53bacd27936158dd3867e587e2", 1652208, Common::JA_JPN, 311),
	WINGAME2t_l("schoolworld", "Capture", "CAPTURE.EXE",	  "f0bfae0867a86735affd5d0e07e857e7", 375279,
										  "CAPTURE.MMM",	  "856d2396bf2a8d82a1d5ee460dc080a0", 1448122, Common::JA_JPN, 310),
	MACDEMO1_l("schoolworld", "Demo",	  "SchoolWorld-DEMO", "f5277c53bacd27936158dd3867e587e2", 4046527, Common::JA_JPN, 311),

	// Manual only. Full game is made in VB3 and contains unsupported content
	WINGAME2t("scissorsnstones", "", "MANUAL.EXE", "ef9462b3aaa45bb50824b33b808c1639", 2494292,
									 "SNS.ICO",	   "6545337dac69926f2776a9234c2015e6", 766, 310),

	// Full game was never released
	MACDEMO1("screamingmetal", "v1.0 Demo", "xn--Screaming Metal Demo-3h7l", "0a280df213c5bf3eca241f37151e1d56", 372934, 310),
	MACDEMO1("screamingmetal", "1993 Demo", "Screaming Launch", "7f443f2e63fd497a9ad85b10dc880a91", 385627, 313),

	MACDEMO1_l("scripting", "Vol.1 Demo", "Start Here!", "f5277c53bacd27936158dd3867e587e2", 389987, Common::JA_JPN, 311),
	MACDEMO1_l("scripting", "Vol.2 Demo", "SCRIPTING", "4c7fddccfe5ab2e9c6398efa5dbe37c1", 990005, Common::JA_JPN, 313),

	// Using Sculpt demo allows choice of English or Japanese
	MACDEMO1_l("sculpt4d", "Vol.1 Demo", "Sculpt DemoVol.1",  "1ae45c23586b41997ba52e2e7c771c4c", 816123, Common::JA_JPN, 311),
	MACDEMO1("sculpt4d",   "Vol.2 Demo", "SculptDemo2",		  "2ce360c9ea2da80a2c6d1040b0ad92dd", 1460345, 313),
	MACDEMO1("sculpt4d",   "Vol.3 Demo", "SculptDemo Vol.3",  "f54ac20d51c496911f9144ee595ade60", 2311451, 300),
	MACDEMO1("sculpt4d",   "Vol.5 Demo", "Sculpt Demo Vol.5", "f54ac20d51c496911f9144ee595ade60", 1456309, 300),
	MACDEMO1("sculpt4d",   "Using Demo", "UsingSculpt1.0",    "2ce360c9ea2da80a2c6d1040b0ad92dd", 383380, 313),

	MACGAME1("sfk", "", "More SFK Products!", "1ae45c23586b41997ba52e2e7c771c4c", 377667, 310),

	MACGAME1_l("directorshokai", "", "Director Movie", "276bee761e48a6fd709df77d5c2f60dd", 395882, Common::JA_JPN, 313),

	// Found on The Cat Came Back
	WINDEMO1("sitfarm", "Demo", "MOREFUN.EXE", "65d06b5fef155a2473434571aff5bc29", 4397800, 310),

	MACGAME1("sialmanac94", "", "1994 Almanac", "c72a99a71c87ad34e416f7e7776450a8", 499898, 310),
	WINGAME1("sialmanac94", "", "SPORTSI.EXE", "990caf82b2406e3342fb93ddb7222bf5", 461040, 310),

	WINDEMO2("sk8board", "Demo", "RIDE.EXE",  "65d06b5fef155a2473434571aff5bc29", 370013,
								 "INTRO.MMM", "91195cec43e8a7bafe8b91d5e121b2e5", 273118, 310),

	// Demo from Blender 1.5
	// Version 1.2 onwards are D4
	MACGAME1("smile", "v1.1", "SMILE! The Splattering", "249f5b6c2a2b050af6ebd533203c5e32", 2479330, 310),
	MACDEMO1("smile", "v1.1", "Smile!", "1ae45c23586b41997ba52e2e7c771c4c", 1462136, 310),

	MACGAME1("smithamerica", "", "Smithsonian's America", "b2df07bdfe2a843e8f355a77a1cca47e", 384223, 313),
	WINGAME2t("smithamerica", "", "AMERICA.EXE", "762716cefb27adf3156d5978ce62c0d8", 370010,
								  "AMERG.MMM",	 "44c614d4bcc9c2dbc0b5372f40d73c9b", 1928814, 310),

	// Original Mac version uses audio tracks, hybrid Mac/Win uses WAV files
	// German version (Das Bi-Ba-Butze-Haus) published by Systhema, Munich (1995) and later by Rowohlt-Systhema (1999)
	// 1999 version is D4
	MACGAME1("snh", "", "A Silly Noisy House", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 353764, 300),
	MACGAME1("snh", "Hybrid release", "A Silly Noisy House", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 356886, 300),
	WINGAME1t("snh", "Hybrid release", "SNH.EXE", "6b1c74a8dbe1f083ee942859016d3345", 378901, 310),
	MACDEMO1("snh", "Sampler", "Silly Noisy House Sampler", "2064fd9b1871f02d216d20e92019a7ac", 1592078, 311),

	// Game is HyperCard based. Movies will play with --start-movie from console.
	MACGAME1("spelunx", "v2.01 Color", "Spelunx", "8c4ac0488e92704a257698ee45affea5", 1208328, 313),

	WINGAME1("spyclub", "", "SPYCLUB.EXE", "65d06b5fef155a2473434571aff5bc29", -1, 300),

	WINGAME1("ssbeastie", "", "BEASTIE.exe", "7c8230a804abf9353b05627a675b5ffb", 1739737, 310),

	// Original filename is Strata PowerPCデモ
	MACDEMO1_l("strata", "Demo", "Strata PowerPC Demo", "f5277c53bacd27936158dd3867e587e2", 3981125, Common::JA_JPN, 311),

	MACDEMO1("stravinsky", "Sampler", "Stravinsky Sampler", "283b66579162e5654fbb0ece117c9885", 2039600, 311),

	MACGAME1("supersonic", "", "Double-click me", "1ae45c23586b41997ba52e2e7c771c4c", 375190, 310),
	WINGAME2("supersonic", "", "SUPERS.EXE",   "7c8230a804abf9353b05627a675b5ffb", 375290,
							   "MAINMENU.MMM", "8ea99e5a90c5193af63049c35331d6f2", 648142, 310),

	// Win version requires installation, INSTALL.EXE
	MACGAME1("take5", "", "Take Five", "1ae45c23586b41997ba52e2e7c771c4c", 1626989, 313),
	WINGAME1("take5", "", "TAKEFIVE.EXE", "65d06b5fef155a2473434571aff5bc29", 370000, 313),

	// First animation fails to run on Mac emulators with the error "Problem with the file: Rotate Anim.mma" (22)
	MACGAME1("timeline", "24bit 1", "TimeLine 24bit 1", "1ae45c23586b41997ba52e2e7c771c4c", 252208, 310),
	MACGAME1("timeline", "24bit 2", "TimeLine 24bit 2", "1ae45c23586b41997ba52e2e7c771c4c", 252204, 310),

	WINDEMO1t("tlc", "", "TLC.EXE", "0b70b84c5ccaa5e1568fbddf04117477", 375297, 310),

	// Original filename is 闘魂V/デモ
	MACDEMO1_l("tokon5", "Demo", "Tokon V-Demo", "f5277c53bacd27936158dd3867e587e2", 392241, Common::JA_JPN, 311),

	MACDEMO1_l("toonet11", "Demo", "TooNet11_DEMO", "f5277c53bacd27936158dd3867e587e2", 829506, Common::JA_JPN, 311),

	MACDEMO1("totaldistortion", "Demo", "TD Demo!", "1ae45c23586b41997ba52e2e7c771c4c", 380803, 311),
	MACDEMO1_l("totaldistortion", "Demo", "TD Demo", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384199, Common::JA_JPN, 313),
	// from Macromind Director 4.0.4 CD
	MACDEMO1("totaldistortion", "Great Big Demo", "TD CD Demo!", "1ae45c23586b41997ba52e2e7c771c4c", 287839, 311),

	MACDEMO1_l("transland", "Demo", "Trans Demo", "f5277c53bacd27936158dd3867e587e2", 2339109, Common::JA_JPN, 311),

	// from the Macromind Director 4.0.4 CD, full game is D4
	MACDEMO1("travelrama", "Preview", "Travelrama Preview", "7f443f2e63fd497a9ad85b10dc880a91", 388022, 314),

	MACDEMO1_l("tree", "Demo", "TREE Demo", "f54ac20d51c496911f9144ee595ade60", 1104691, Common::JA_JPN, 311),

	WINDEMO2("trekfinalunity", "Demo", "PLAYDEMO.EXE", "65d06b5fef155a2473434571aff5bc29", 370018,
									   "LOGO.MMM",	   "347503372c22dc494f1762f5c6e262c3", 4358472, 310),

	MACDEMO1_l("ttw", "Demo", "T.T.W.Demo", "51e8b81db434a6dcae723f6b7724143d", 691076, Common::JA_JPN, 302),
	MACGAME1_l("ttw", "", "whales", "e184bbb4cc78e49733829ea7e2dc728a", 67777, Common::JA_JPN, 302),

	// Full version is D4
	MACDEMO2_l("ukiuki1", "Demo", "DEMO",	   "f5277c53bacd27936158dd3867e587e2", 392252,
								  "D_opening", "107b285846b271eda498870c2ea5ccf7", 1676918, Common::JA_JPN, 311),

	// Original filename is うきうきスタンプ3のおしらせ
	MACDEMO1_l("ukiukistamp", "Vol.3 Demo", "Notice of Ukiuki Stamp 3", "f5277c53bacd27936158dd3867e587e2", 392288, Common::JA_JPN, 311),

	// Original filename is うきょー1デモ版
	MACDEMO1_l("ukyo1", "Demo", "Ukyo 1 demo version", "f5277c53bacd27936158dd3867e587e2", 392517, Common::JA_JPN, 311),

	// Isaac Asimov's The Ultimate Robot CD-ROM
	MACGAME1("ultrobotkit", "", "Robotoid Assembly", "1ae45c23586b41997ba52e2e7c771c4c", 1639801, 311),
	WINGAME2("ultrobotkit", "", "TOOLKIT.EXE", "65d06b5fef155a2473434571aff5bc29", 1858955,
								"BLANK.MMM",   "0c47901562a50baa79beb6a5e4504f15", 656, 310),
	MACGAME1("ultrobotss", "", "Screen Saver Viewer", "2ce360c9ea2da80a2c6d1040b0ad92dd", 381980, 313),
	WINDEMO1("ultrobot", "Demo", "ROBODEMO.EXE", "2b3543a9131a49f665982d26513a84f8", 373521, 310),

	MACGAME1_l("vcb", "", "Virtual Cocktail Bar", "f5277c53bacd27936158dd3867e587e2", 393446, Common::JA_JPN, 311),

	MACDEMO1_l("vcbe", "Demo", "VirtualCocktailBar Exective", "f5277c53bacd27936158dd3867e587e2", 394005, Common::JA_JPN, 311),
	MACDEMO1_l("vcbe", "Demo", "VirtualCocktailBar Exective", "f5277c53bacd27936158dd3867e587e2", 393996, Common::JA_JPN, 311),
	MACGAME1_l("vcbe", "", "VirtualCocktailBarExecutive", "f5277c53bacd27936158dd3867e587e2", 394073, Common::JA_JPN, 311),

	// Original filenames are DreamLight® Verttice™ 1.0 and DreamLight® Verttice™ 1.1
	MACGAME1("verttice", "v1.0", "xn--DreamLight Verttice 1.0-35a3288r", "b57fff2bb16ad91d6e807ceeab357271", 1082993, 311),
	MACGAME1("verttice", "v1.1", "xn--DreamLight Verttice 1.1-35a3288r", "1ae45c23586b41997ba52e2e7c771c4c", 1086927, 311),
	MACGAME1("verttice", "v1.1 PowerMac", "xn--DreamLight Verttice 1.1-35a3288r", "1ae45c23586b41997ba52e2e7c771c4c", 1089191, 311),

	// System 7 + Power Mac versions are D4
	MACGAME1("videocasino", "", "xn--Video Casino Sys. 6-co0l", "96936d0dbef06314515f134ccbbc35e1", 1488811, 310),
	MACDEMO1("videocasino", "Demo", "VC.Demo.14.Start", "1ae45c23586b41997ba52e2e7c771c4c", 877609, 310),

	MACGAME2("vvcyber", "", "Start Game! (16Mb)", "7f443f2e63fd497a9ad85b10dc880a91", 384590,
							"CH0MAC/START0",  "6d6781e7183df66d8995285e4e3f1a50", 551, 310),
	WINGAME2t("vvcyber", "", "CYBER.EXE", "979fad26abe804c85c791d56d24d8935", 371139,
							 "START0.MMM", "c6ad604fa2b61bf568bd4b00fa1a212a", 1126, 310),
	MACDEMO1("vvcyber", "Demo", "CyberPlasm", "2ce360c9ea2da80a2c6d1040b0ad92dd", 503901, 310),
	WINDEMO2t("vvcyber", "Demo", "CYBER.EXE", "f6a00141499568e167ab0ed901fffa05", 639439,
								 "CYBER.MMM", "eaa81c1e5ee7229bca5f214f86337f3d", 270188, 310),

//	MACGAME1("vvdinosaur", "", "Start Game", "d41d8cd98f00b204e9800998ecf8427e", -1, 300),
	MACGAME2("vvdinosaur", "", "Start Adventure (8Mb)", 	  "2ce360c9ea2da80a2c6d1040b0ad92dd", 384984,
							   "Dinosaur/Chapter1/LDE Intro", "4ae7c14351bc9cfd812c410ba37aecd3", 407023, 310),
//	WINGAME1("vvdinosaur", "", "DINOSAUR.EXE", "4e6303630f4dd588e730d09241cf7e76", -1, 300),
	WINGAME2t("vvdinosaur", "v1.1", "DINOSAUR.EXE", "d9a7b8248c831b9af1a0f3c43269d9d6", 370049,
								    "STARTLDE.MMM", "87da46f4deaa55032ed54b3d366c272d", 792, 310),

	MACGAME2("vvharp", "",  "Start Adventure! (8mb)", "7f443f2e63fd497a9ad85b10dc880a91", 383150,
						    "Hypnotic/Chapter1/1_01", "827500ffd04e12fca366acdd5e03d83b", 1168697, 310),
	WINGAME2t("vvharp", "", "HYPNOTIC.EXE", "0cf51de2c038e003dd4046295e12a5d6", 370272,
							"START.MMM",	"cab5ffd61f5f547d2b7be44fe6b67c76", 954, 310),

//	MACGAME1("vvvampire", "", "The Vampire's Coffin", "d41d8cd98f00b204e9800998ecf8427e", -1, 300),
	MACGAME1("vvvampire", "", "The Vampire's Coffin", "7f443f2e63fd497a9ad85b10dc880a91", 384070, 313),
	WINGAME2t("vvvampire", "", "VAMPIRE.EXE", "97019593c1c86ac3be60c3ba468c07b6", 370837,
							   "START.MMM",	  "425df941db805b5599e37a1e7b1c4d59", 1584, 310),

	MACGAME1_l("vvs", "", "VVS Theater-ExtraLarge", "f5277c53bacd27936158dd3867e587e2", 912651, Common::JA_JPN, 311),
	MACDEMO1_l("vvs", "Demo", "VVS Theater", "f5277c53bacd27936158dd3867e587e2", 639512, Common::JA_JPN, 311),

	MACGAME1("wackyjacks", "v1.2", "Wacky Jacks 1.2/Wacky Jacks", "7f443f2e63fd497a9ad85b10dc880a91", 428279, 310),
	// from the Macromind Director 4.0.4 CD
	MACDEMO1("wackyjacks", "Demo", "Wacky Jacks Preview", "7f443f2e63fd497a9ad85b10dc880a91", 388159, 314),

	// Original filename is 'WackyRaces/Intercative' - typo on the original disc
	MACDEMO1_l("wackyraces", "", "xn--WackyRacesIntercative-6a27h", "71f7df248f2ebc7f0df0c9be39d3aeea", 377276, Common::JA_JPN, 313),

	// Original filename is 'WallobeeJack/Demo'
	// Contained on the Canadian retail game disc, intended to be run in retail stores.
	// Bilingual English/French
	MACDEMO1("wallobee", "Demo", "xn--WallobeeJackDemo-3a24f", "2ce360c9ea2da80a2c6d1040b0ad92dd", 383688, 313),
	// English version - both are on the same disc
	MACGAME1("wallobee", "", "WallobeeJack English", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384611, 313),
	// French version; original filename is 'WallobeeJack Français'
	MACGAME1_l("wallobee", "", "xn--WallobeeJack Franais-k1b", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384610, Common::FR_FRA, 313),
	// Decomposed variant of the above
	MACGAME1_l("wallobee", "", "xn--WallobeeJack Francais-lhm", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384610, Common::FR_FRA, 313),
	// American release, English version - both are on the same disc
	MACGAME1("wallobee", "American rerelease", "Bingi Burra", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384683, 313),
	// American release, French version
	MACGAME1_l("wallobee", "American rerelease", "Bingi Burra", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384688, Common::FR_FRA, 313),

	MACGAME1("wallobee2", "", "Thai Sun", "2ce360c9ea2da80a2c6d1040b0ad92dd", 384678, 313),

#undef SUPPORT_STATUS
#define SUPPORT_STATUS ADGF_NO_FLAGS

	// Original AV filename is Spaceship Warlock™ AV
	// Later demo is originally found on Inside Mac Games
	// Mac AV versions are from 1994 and 1996, the latter provided by eriktorbjorn
	// Republished in Europe by Visual Media Systems, Bièvres, France (1995)
	WINGAME2t("warlock",   "v1.1.3 MPC", "SSWARLCK.EXE",     "802c503582d855cb961227e7a619f4b0", 370867,
										 "NAV/AREACTOR.MMM", "f9cc7b0012ee5fb4008d32f57b80fc72", 33380, 310),
	WINGAME2t_l("warlock", "v1.1.3 MPC", "SSWARLCK.EXE",     "802c503582d855cb961227e7a619f4b0", 370867,
										 "NAV/AREACTOR.MMM", "1480a7134cbd257d5e13b0a09d39ec69", 33536, Common::FR_FRA, 310),
	WINDEMO2t("warlock",   "Demo",		 "SSWDEMO.EXE",		 "ab56bba682d468c84a762f3589cfafe6", 370934,
										 "ADEMO.MMM",		 "7e36622944a0a01c5757f2299dcf88d8", 388598, 310),
	WINDEMO2t_l("warlock", "Demo",		 "SSWDEMO.EXE",		 "ab56bba682d468c84a762f3589cfafe6", 370934,
										 "ADEMO.MMM",		 "4249a5573427e0883f36c22835a49ec9", 388660, Common::FR_FRA, 310),
	MACGAME1("warlock",	   "v1.1.2 AV",  "xn--Spaceship Warlock AV-5h7l", "e043b322d17e0f2ca7f73520466a4311", 381950, 313), // 1994
	MACGAME1("warlock",	   "v1.1.2 AV",	 "xn--Spaceship Warlock AV-5h7l", "e043b322d17e0f2ca7f73520466a4311", 384214, 313), // 1996
	MACDEMO1("warlock",	   "Demo",		 "Spaceship Launch",			  "7f443f2e63fd497a9ad85b10dc880a91", 385616, 313),
	MACDEMO1("warlock",	   "AV Trailer", "SS Warlock Movie Trailer AV",   "e043b322d17e0f2ca7f73520466a4311", 384221, 313),

#undef SUPPORT_STATUS
#define SUPPORT_STATUS ADGF_UNSTABLE

	WINDEMO1("wep", "Demo", "WEP.EXE", "2b3543a9131a49f665982d26513a84f8", 1796465, 310),

	// Produced by Microsoft; designed by AdWare Inc, Los Gatos, California (1992)
	WINDEMO1("wfw31", "Demo", "WFWDEMO.EXE", "d98c3f5c1b7ea3039c47cc63d238a60d", 253540, 300),

	// Designed and produced by AdWare Inc, Los Gatos, California (1992)
	WINDEMO2t("windows31", "Demo", "WINDEMO.EXE", "7d007410fece051b819735a282da7601", 255447,
								   "WINDEMO.MMM", "0c13c2c5768cd54b01e5b9b1ef093f28", 2824822, 300),

	// Original filename is WONDEROMPM4.5J Ver.2 ｻﾝﾌﾟﾙ
	MACDEMO1_l("wonderompm", "Sample Version", "WONDEROMPM4.5J Ver.2 sample", "f5277c53bacd27936158dd3867e587e2", 392318, Common::JA_JPN, 311),

	WINGAME2t("woodstock25", "",     "FESTIVAL.EXE", 		  "91505a118fd9384e3bdff6f4e518b1e5", 370006,
									 "WDSTOCK/MAIN/INTROTIT", "5f667d6fb422c9100a6e45e189c84272", 279922, 310),
	WINDEMO1t("woodstock25", "Demo", "WDSTOCK.EXE", 		  "35aaa39965705c32d927a0c8fbed27af", 2099951, 310),
	WINDEMO1t("woodstock25", "Demo", "WDSTOCK.EXE",			  "dd8af0fd34231850dc0e0c88cb04aa66", 2474071, 310),

	WINDEMO1("wpmainstreet", "", "WPMAINST.EXE", "65d06b5fef155a2473434571aff5bc29", 370000, 300),

	MACGAME1("wrath", "", "Wrath of the Gods", "2ce360c9ea2da80a2c6d1040b0ad92dd", 413730, 300),
	WINGAME2("wrath", "", "000WRATH.EXE", "3162423a1d0885eb1eb94f557a86b258", 372970,
						  "SHARDCST.MMM", "22af72fba773cc5313d99c91b2e5aea9", 3432948, 300),
	WINGAME2("wrath", "", "000WRATH.EXE", "3162423a1d0885eb1eb94f557a86b258", 372970,
						  "SHARDCST.MMM", "35b0a9fa9cc4ed5088d665848c5258dc", 3432878, 300),
	WINDEMO2("wrath", "Demo", "000WRATH.EXE", "3162423a1d0885eb1eb94f557a86b258", 372970,
							  "SHARDCST.MMM", "85d166abe18730d96e9d4137c66255a1", 3553330, 300),

	MACDEMO1("wriggle", "Demo", "'93 Wriggle Demo", "9f0bb7ec7720e4f680ee3aa3d22c1c9d", 353737, 300),

	MACGAME1("wti", "", "WTI Projector", "1ae45c23586b41997ba52e2e7c771c4c", 3715229, 310),

	// may be vaporware; original name is ∆ X A N T H U S ∆
	MACDEMO1("xanthus", "Demo", "xn-- X A N T H U S -hd6ipa", "1ae45c23586b41997ba52e2e7c771c4c", 375191, 300),

	// Requires installation, 'Installer', uses Smaller Installer by Cyclos
	MACGAME1("y2lflintcoloring", "", "Coloring Book", "2ce360c9ea2da80a2c6d1040b0ad92dd", 490543, 313),

	MACGAME1("y2lmath", "v1.07", "Snoopy Math", "7f443f2e63fd497a9ad85b10dc880a91", 605754, 313),
	WINGAME1t("y2lmath", "v1.07", "SNPYMATH.EXE", "3a06c99298df30784a402f62f65c2bde", 413887, 313),

	// Developed by Image Smith
	// Requires installation from floppy disks, uses Smaller Installer by Cyclos
	MACGAME1("y2lpeanuts", "v1.2 Floppy", "Peanuts", "1ae45c23586b41997ba52e2e7c771c4c", 543503, 311),
	MACGAME1("y2lpeanuts", "v1.2a Floppy", "Peanuts", "1ae45c23586b41997ba52e2e7c771c4c", 543531, 311),
	// from the Macromind Director 4.0.4 CD
	MACDEMO1("y2lpeanuts", "Crippled Version", "PEANUTS", "1ae45c23586b41997ba52e2e7c771c4c", 546601, 311),
	MACDEMO1("y2lpeanuts", "1 minute Demo", "Y-2-L Demo", "1ae45c23586b41997ba52e2e7c771c4c", 381129, 311),

	// CD-ROM language selection: German, Swedish, Dutch, Danish, English, French
	{
		{
			"y2lpeanuts", "v1.4i CD",
			AD_ENTRY1s("Peanuts", "7f443f2e63fd497a9ad85b10dc880a91", 463686),
			Common::EN_ANY,
			Common::kPlatformMacintosh,
			(ADGF_CD|ADGF_MACRESFORK|SUPPORT_STATUS),
			GUIO1(GUIO_NOASPECT)
		},
		GID_GENERIC,
		313
	},

	// from Yearn2Learn: Master Snoopy's Math
	// English Mac demos are simply quicktime files, no director
	WINDEMO2t("y2lpeanuts", "QuickTime Preview", "PEANUTS.EXE",  "a9f24851955b9e260274cd9380254f5b", 370017,
												 "PNTSDEMO.MMM", "0b2d12348cc93d2cad1338d102d0011a", 1070, 310),
	WINDEMO2t("y2lsnoopy", "QuickTime Preview",  "SNOOPY.EXE",   "6a1c5ea0d9870bacd2017e1f2267a743", 370016,
												 "SNPYDEMO.MMM", "5c183b406bd582849c2944762a7f446a", 1066, 310),

	// Original filename is スヌーピー Demo
	MACDEMO1_l("y2lsnoopy", "v1.2 Demo", "Snoopy Demo", "1ae45c23586b41997ba52e2e7c771c4c", 402007, Common::JA_JPN, 311),

	WINGAME2t("y2lsnoopy", "", "SNOOPY.EXE", 		   "39b10174e67241af11ccb4cf08b6c741", 418576,
							   "Y2LDATA/INTROANI.MMM", "c725cff357223fbfc3d534e7892b0118", 542438, 310),

	// Requires installation from floppy disks
	WINGAME1("y2lspelling", "v1.0 Floppy", "SPELLACE.EXE", "65d06b5fef155a2473434571aff5bc29", 438552, 310),

	MACDEMO1_l("ybr1", "Demo", "YBR-DEMO",	"f5277c53bacd27936158dd3867e587e2", 392247, Common::JA_JPN, 310),
	MACGAME2("ybr1", "",   "xn-- YBR -",	"f5277c53bacd27936158dd3867e587e2", 414242,
						   "DATA-Mac/START","19000b57887e228ec0cbffd500ee5faa",	2412880, 310),
	WINGAME2("ybr1", "",   "YBR/YBR.EXE",	"2cc9e2dacb90fb130f6ee9519b66c5a8", 369007,
						   "DATA/START.MMM","69012b34b3f0e6f1886133b807db4476", 2566872, 310),
	MACGAME2_l("ybr1", "", "xn-- YBR -",	"f5277c53bacd27936158dd3867e587e2", 414242,
						   "DATA-Mac/START","ca4a6650d8f8ce04b26bcbc941bf0a86", 2416986, Common::JA_JPN, 310),
	PIPGAME2_l("ybr1", "", "YBR",			"f5277c53bacd27936158dd3867e587e2", 414242,
						   "START",			"9fad29c4cf9f7791e5dda075259e2fdd", 2418439, Common::JA_JPN, 300),
	WINGAME2_l("ybr1", "", "YBR/YBR.EXE",	"2cc9e2dacb90fb130f6ee9519b66c5a8", 369007,
						   "DATA/START.MMM","9e02f41270708101b1d5d04cb822a784", 2563274, Common::JA_JPN, 310),
	WINGAME2_l("ybr1", "IBM release", "YBR/YBR.EXE",	"2cc9e2dacb90fb130f6ee9519b66c5a8", 369007,
						   "DATA/START.MMM",	"6b913b1747abc48c230523e916e5e60a", 2554968, Common::JA_JPN, 310),

	// Original filename is 財閥銀行
	MACDEMO1_l("zaibatsu", "Demo", "Zaibatsu Bank", "a03ae8a9bf211bcb26388b6b6da17c2b", 1830354, Common::JA_JPN, 311),

//////////////////////////////////////////////////
//
// Macromedia Director v4
//
//////////////////////////////////////////////////

	WINDEMO1("3datlas97", "Demo", "ATLAS97.EXE", "b5da314bdfd9344530a24093f2e0b566", 8300357, 404),

	MACGAME1_l("4sight", "", "four-sight", "0c7bbb4b24823e5ab871cb4c1d6f3710", 508091, Common::JA_JPN, 404),
	WINGAME1_l("4sight", "", "4_SIGHT.EXE", "26c279f80434c0a641d28cec198c783f", 740581, Common::JA_JPN, 404),

	MACGAME1("9worlds", "", "Nine Worlds", "3930940b5b4b2ae2563cc29b812855a6", 482582, 404),
	WINGAME1("9worlds", "", "9WORLDS.EXE", "9da9df906149916b340a0a8fbee5ca52", 741994, 404),
	MACGAME1_l("9worlds", "", "Neun Welten", "3930940b5b4b2ae2563cc29b812855a6", 483518, Common::DE_DEU, 404),
	WINGAME1_l("9worlds", "", "9WORLDS.EXE", "054e5af279a05ab64627ef664631fe37", 742002, Common::DE_DEU, 404),

	MACGAME1("abcpalsafety", "", "SAFETY SCAVENGER HUNT", "4577dd3eadc467a986ab172d90871b22", 325733, 404),
	WINGAME1("abcpalsafety", "", "EWOLSFTY.EXE", "a998d49776a611940e872a97a5fe3d1d", 4586417, 404),

	MACGAME1_l("abrapalabra", "", "ABRAPALABRA", "bcd3c718db258701496b3c5bcb827ef2", 483518, Common::ES_ESP, 404),
	WINGAME1_l("abrapalabra", "", "PALABRA.EXE", "a24a52bdb12d61eae64b9088b25ea03b", 862425, Common::ES_ESP, 404),

	// Found on A.D.A.M. v1.1 for Mac
	MACGAME1("adamcatalog", "", "A.D.A.M. Catalog", "99312ebd2a530b9e88f536f754c6b335", 302321, 400),

	// Found on Nine Month Miracle for Mac
	MACDEMO1("adamcmp", "Demo", "Comprehensive", "17efee018a660458fae80de4364021ac", 483490, 404),

	// Found on Nine Month Miracle for Mac
	MACDEMO1("adamess", "Demo", "Essentials",	"17efee018a660458fae80de4364021ac", 483490, 404),
	// Found on Life's Greatest Mysteries v1.01 (Win)
	WINGAME1t("adamess", "Demo", "ESSDEMO.EXE", "81dbb88c9cce74bdbc05fb655c07d84e", 3440475, 400),

	// Found on Nine Month Miracle for Mac
	MACDEMO1("adamstd", "Demo", "Standard", "17efee018a660458fae80de4364021ac", 483490, 404),

	// Found on A.D.A.M. v1.11 for Mac
	MACGAME1("adamscholar", "", "Run Demo!", "17efee018a660458fae80de4364021ac", 483746, 404),

	// Animated Dissection of Anatomy for Medicine
	// Created by A.D.A.M. Software, Marietta, Georgia, USA
	// Mac demo called "The Inside Story Demo" found on v1.1
	// Puzzle demo is found on apcmag.cd Dec 1999 disc 3, published by Australian Consolidated Press
	// PUZZLE.EXE is the only file in this demo
	// Versions 2.x are labeled 1997 Edition
	MACGAME2("adamtis", "v1.1",		  "Adam Player.ppc",			   "17085276f3b938562330a4e8bfdc97ce", 57446,
									  "A.D.A.M. The Inside Story 1.1", "aff58aef8781629c7fb011c389d45e37", 334061, 404),
	MACGAME2("adamtis", "v1.11",	  "Adam Player.ppc",			   "17085276f3b938562330a4e8bfdc97ce", 57446,
									  "A.D.A.M. The Inside Story 1.1", "aff58aef8781629c7fb011c389d45e37", 336715, 404),
	WINGAME2t("adamtis", "v1.11",	  "ADAMPLAY.EXE",		   "e1df8f99d27cdead0717ee63685ceb2c", 695721,
									  "INSIDE.EXE",			   "ddefd17508c1399690fa6127fb18faf8", 1341120,	404),
	WINGAME2t("adamtis", "v2.01",	  "ADAMPLAY.EXE",		   "e1df8f99d27cdead0717ee63685ceb2c", 695855,
									  "INSIDE.EXE",			   "ab403a2e33b087e318eaacec6abb60a7", 2532288,	404),
	MACDEMO1("adamtis", "Demo",		  "The Inside Story Demo", "22815cf659b911c4e07d0015cac5d98f", 301669,	400),
	MACDEMO1("adamtis", "Demo",		  "Inside Story Demo",	   "ea646eccc9a53f44ce082459d4809a06", 481226,	404),
	WINDEMO1t("adamtis", "Demo",	  "ADAMDEMO.EXE",		   "451a5ea3f5a47874dbad22d1715d2635", 7342649, 404),
	WINDEMO1("adamtis", "Skull Demo", "PUZZLE.EXE",			   "d2dcc8b55382fc1807e357af5108f7ba", 1057997,	404),

	// CD serial SYHB-002
	MACGAME1("alice", "", "Alice", "3b61149c922f0fd815ca29686e4f554a", 304458, 400),
	WINGAME1t("alice", "", "ALICE_W/ALICE.EXE", "da6b3cb75f548d5c79ef831320b97035", 684733, 400),
	// CD serial TORT-3001
	MACGAME1_l("alice", "Hybrid", "Alice", "3b61149c922f0fd815ca29686e4f554a", 304486, Common::JA_JPN, 404),
	WINGAME1t_l("alice", "Hybrid", "ALICE_W/ALICE.EXE", "ea9c19490428c8ef13934d3c159e1950", 684733, Common::JA_JPN, 404),

	// Developed by Collabo Software and NOVUM, distributed by XING Inc.
	// Mac projector does indeed end in .EXE
	// Win has projectors for 8-bit and 16-bit color
	MACGAME1_l("alius", "",				"ALIUS_FAT.EXE", "df355a56c186f3d6a64d99e96600f48c", 498937, Common::JA_JPN, 404),
	WINGAME1_l("alius", "8-bit Color",	"ALIUS_8.EXE",   "9db857a65199db5251a33b2121ec5984", 2426433, Common::JA_JPN, 404),
	WINGAME1_l("alius", "16-bit Color",	"ALIUS_16.EXE",  "98ac4e872421263dbbde1636b1e9d0e1", 2635737, Common::JA_JPN, 404),

	MACGAME1("alphabet", "", "Alpha.ppc",  "71287376e445ab9c98f0d150bb0ed175", 59188, 404),
	WINGAME2("alphabet", "", "ALPHA.EXE",  "c89c8301db7ef0ebffedf435863b3ffc", 749092,
							 "SHARED.DXR", "4e0c4cda8a75154f568d75095ac1132f", 333196, 404),

	// Windows version is D5
	MACGAME1("amber", "", "xn--AMBER-Journeys Beyond-yb4m", "a6a7812d8b3de0da884197eb26a1b059", 60086, 404),

	// Original filename is 'ｱﾒﾘｶ横断ｳﾙﾄﾗｸｲｽﾞ Demo'
	MACDEMO1_l("americaodan", "Demo", "xn-- Demo-g40kn3x3n73alaj4a1a0e1ezj7clw4h", "32cb3a881f2d47a7e525370b198b2c5c", 484095, Common::JA_JPN, 404),
	WINDEMO1t_l("americaodan", "Demo", "UQDEMO.EXE", "5c1a4cd7aa8a767a2729af64d9c7654c", 15259871, Common::JA_JPN, 404),
	// Original filename is 'ｱﾒﾘｶ横断ｳﾙﾄﾗｸｲｽﾞct.Ⅱ Demo'
	MACDEMO1_l("americaodan2", "Demo", "xn--ct. Demo-q35dl985ddlkjw05bpan6b9a5f2ftlvdpa0a4j", "bcd3c718db258701496b3c5bcb827ef2", 484067, Common::JA_JPN, 404),
	WINDEMO1t_l("americaodan2", "Demo", "UQ2DEMO.EXE", "b49fa67b361e2692023d464b43beae4e", 12070621, Common::JA_JPN, 404),

	MACGAME2("amnesty", "", "Double-Click Me", "ef59432e7b24df951cb7096cfd45d168", 373184,
							"Media/Rights.Dir", "196e02dd14e685b599cfc6f8dcc7cd3b", 641230, 400),
	WINGAME1t("amnesty", "", "AMNESTY.EXE", "3e647bd639f00391da11f015a241d9e7", 736902, 404),

	WINGAME2_l("angelgate", "",		"ANGEL.EXE", "046f0458f64b9008bc4b0dca5b895390", 746991,
									"FILE/START","9823012f8f3dc309edd7b3642de9070a", 59734, Common::JA_JPN, 404),
	WINDEMO2_l("angelgate", "Demo", "DEMO.EXE",	 "32640d047e9e0d9498a6654de07e8248", 746865,
									"START",	 "9261f9d13410517d9172975ea33695c2", 10354, Common::JA_JPN, 404),
	MACDEMO2_l("angelgate", "Demo", "DEMO",		 "bcd3c718db258701496b3c5bcb827ef2", 483159,
									"START",	 "66600069c64ac7938eba0531ea1c1537", 10482, Common::JA_JPN, 404),
	// Original filename is 'デモ', e.g. 'demo'
	MACDEMO2_l("angelgate", "Demo", "xn--edkuc", 	 "bcd3c718db258701496b3c5bcb827ef2", 483159,
									"MOVIE/START",	 "9261f9d13410517d9172975ea33695c2", 10354, Common::JA_JPN, 404),
	// Decomposed variant of the above filename
	MACDEMO2_l("angelgate", "Demo", "xn--2bkvetd", 	 "bcd3c718db258701496b3c5bcb827ef2", 483159,
									"MOVIE/START",	 "9261f9d13410517d9172975ea33695c2", 10354, Common::JA_JPN, 404),


	MACDEMO1_l("angelolatrie", "Autodemo", "COCTEAU", "8b138db44d4421cc7294a9dc792ccf1b", 501681, Common::JA_JPN, 404),
	WINDEMO1t_l("angelolatrie", "Autodemo", "C_WIN.EXE", "2ddf245ee6775e5b22413ae02fa539a9", 702249, Common::JA_JPN, 404),

	MACGAME1_l("ankh1", "", "ANKH", "4577dd3eadc467a986ab172d90871b22", 500393, Common::JA_JPN, 404),
	WINGAME1_l("ankh1", "", "ANKH.EXE", "ca3b036aed6f38beb3ee762e171b663e", 746959, Common::JA_JPN, 404),
	MACDEMO1_l("ankh1", "Demo", "ANKH-demo", "4577dd3eadc467a986ab172d90871b22", 500393, Common::JA_JPN, 404),

	MACGAME1("antfarm", "", "Ant Farm", "3269beea2787a0881008e44087479a1f", 302924, 404),

	// Original filename is Ants Afire!™ 1.2
	// Original Pro demo filename is Ants Afire! Pro™ PM
	// Demo is from Inside Mac Games #25 - Mar 25 1995
	// 2nd demo from MacCubed³ #1
	MACGAME1("antsafire", "v1.2", "xn--Ants Afire! 1.2-ke3i", "1682231de376e5465240f6e4a7952072", 291960, 404),
	MACDEMO1("antsafire", "Pro 1.2.7 Demo", "xn--Ants Afire! Pro PM-qu3k", "71287376e445ab9c98f0d150bb0ed175", 60096, 404), // 1.2 on title screen
	MACDEMO1("antsafire", "Pro 1.2.7 Demo", "Ants Afire! Pro Demo 1.2.7", "ea646eccc9a53f44ce082459d4809a06", 483490, 400),

	MACDEMO1("aol", "v2.6 Demo", "America Online Easy", "67f572196550aedb1f9523d782022be0", 482582, 404),
	WINDEMO2t("aol", "Demo", "AOL.EXE",		"b91b98671625a60252dba2cc7d052e7d", 1426687,
							 "AOLMOV.AVI",	"8a3ce7dd86e5674240aff51c9a82c193", 5795846, 404),

	MACGAME1("applestore", "", "Apple Company Store", "19b7c96659c773e73b13986d06b28c5c", 773792, 404),

	MACDEMO1_l("aquazone", "Demo (Version 1.5)", "AZ demo", "97474208c44c78f26bef8b2011d341aa", 487303, Common::JA_JPN, 404),
	WINDEMO1t_l("aquazone", "Demo", "AZDEMO.EXE", "4644e6e5015ed2c7e4a30619c5efc464", 4011337, Common::JA_JPN, 404),

	MACGAME2_l("aramata", "", "START", "0c7bbb4b24823e5ab871cb4c1d6f3710", 484095,
							  "SRC/MACLOBBY.Dxr", "2332900b20b0d33e0617e5e7505923e8", 290058, Common::JA_JPN, 404),
	WINGAME2t_l("aramata", "", "START.EXE", "bb031b7d7a57557636530e80b4c061b3", 747081,
							   "SRC/WINLOBBY.Dxr", "f53af0b58070d2450a3672847434b609", 5282042, Common::JA_JPN, 404),

	MACGAME1("arcofdoom", "", "Arc Player (4mb)", "ea553e3f3fa123ad38fa5249621e8c8b", 295170, 404),
	WINGAME2("arcofdoom", "", "ARC.EXE", 		  "fd3e9ad004597b01656b28c348a2ae7f", 687973,
							  "ARC/BEGINARC.DIR", "c144c827f33d77597992e149a4763ffa", 29674, 404),
	MACDEMO1("arcofdoom", "Demo", "ArcDemo", "cdb27c916044ae4dceb4b7326063fa03", 301669, 400),

	// English and German selectable from main menu
	// The Four Seasons of Gourmet French Cuisine
	// The Art of Making Great Pastries
	MACGAME1("aromeinteractive", "", "Demo", "77f4098988d5386794d1530065f514cd", 301669, 400),

	WINDEMO2("artofmagic", "Demo", "MAGIC.EXE", "57347ee90d930c1bb222c5652c4b3a50", 690969,
								   "WINWORLD.DIR", "0cf86a011d48ef31790514f13f92484d", 19977904, 404),

	MACGAME2("artrageous", "", "Artrageous!", "17efee018a660458fae80de4364021ac", 483490,
							   "DATA/ArtStar.dir", "a70e3e1be70e2d2a4251c207c77e33cc", 89820, 404),
	WINGAME2("artrageous", "", "ART.EXE", 		   "926ca15bcb7bdccc8f9b14b052d05f83", 696827,
							   "DATA/ARTSTAR.DIR", "a70e3e1be70e2d2a4251c207c77e33cc", 89820, 404),

	MACGAME1("aruba", "", "ARUBA POWER PC", "d8b8e42c2d9875b47ea762ca3fd45122", 57122, 404),
	WINGAME1("aruba", "", "ARUBA.EXE", "adb2655694ddacd49513ae50f58977ea", 696671, 404),

	// Full game is not Director
	WINDEMO1("ataripack", "Demo", "ACTDEMO.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 404),

	MACGAME1("atbat", "2.0", "At Bat", "ea553e3f3fa123ad38fa5249621e8c8b", 292906, 403),
	WINGAME1t("atbat", "2.0", "ATBAT.EXE", "de8a2b4f91c1e7a22e36f394a3a64af5", 842033, 404),
	WINDEMO1t("atbat", "", "ATBATDMO.EXE", "2000eefeb4bf68749dad55e101cbd318", 3266657, 400),

	MACGAME2("athletics", "", "ATHLETICS",   "17efee018a660458fae80de4364021ac", 482610,
							  "FIRSTMOV",	 "f2d6cb666b17905bbccc332ddb60dc07", 16198, 404),
	WINGAME2("athletics", "", "PROJECT.EXE", "b804f1e4bf84c31979502329ee0f8c28", 696839,
							  "FIRSTMOV",	 "f2d6cb666b17905bbccc332ddb60dc07", 16198, 404),

	// Developed by Future Pirates
	// L sets gextendmemoryflg to 1; S sets it to 0
	PIPGAME1_l("atmarktown", "", "L", "f48b3fd88055f0700ceb2b378d25b079", 57774, Common::JA_JPN, 404),

	// Original filename is 'オウム報道全記録Demo'
	MACDEMO1_l("aumhodozenkiroku", "Demo", "xn--Demo-4k4cxa39ay43tw0mbx1jiloc9h", "7fd44b6dffa0ea0402eaed4c3769b39b", 304674, Common::JA_JPN, 404),

	// Both Mac and Win versions require installation to extract executable
	// Russian version appears to be identical with only assets replaced
	// Original Japanese Mac filename is バッドデイ(Power PC)
	MACGAME1("badday", "",	 "BadDay (Universal)", "b7e69c37b7355022d400c14aa97c5d54", 483781, 404),
	MACGAME1_l("badday", "", "xn--(Power PC)-jx4ilmwb1a7h", "c5f8c31feb5c3d4596b63455c520fc46", 60096, Common::JA_JPN, 404),
	WINGAME2("badday", "",   "BAD_DAY.EXE", "4ad339db5379a860b33cbb0fa64f18e2", 742342,
							 "BADDAY.DXR",	"b4b6fa644f64555f9f7af51454c40909", 288810, 404),
	WINGAME2_l("badday", "", "BAD_DAY.EXE",	"4ad339db5379a860b33cbb0fa64f18e2", 742342,
							 "BADDAY.DXR",	"b4b6fa644f64555f9f7af51454c40909", 397994, Common::RU_RUS, 404),
	WINGAME2t_l("badday", "", "BDM/BAD_DAY.EXE",   "3023f944e8d494393bf08c0cb7a61ba0", 768773,
							  "BADDAY/BADDAY.DXR", "1e28a7f03ff2441eb8a5ac07204222dd", 549108, Common::JA_JPN, 404),

	// Original filename is みんなであそぼ　デモ
	// Kidsoft US packaging says A Bear Family Adventure featuring Playtime in the Park by Erica Dale
	MACDEMO1_l("bearfamily", "Demo", "Playtime Demo", "77f4098988d5386794d1530065f514cd", 301697, Common::JA_JPN, 400),

	MACGAME2("beatexp", "", "The Beat Experience", "17efee018a660458fae80de4364021ac", 485790,
							"MAIN.DIR",			   "8735a5265dcf7d6861992f63f8eb82bf", 5761636, 404),
	WINGAME1t("beatexp", "", "BEATEXP/BEATEXP.EXE", "046a68edce43728141b1b7239e8667c8", 3588245, 404),
	MACDEMO2("beatexp", "Demo", "The Beat Experience", "17efee018a660458fae80de4364021ac", 485790,
								"MAIN.DIR",			   "b4b6fa644f64555f9f7af51454c40909", 397994, 404),

	// Original filename is BeBoxへの招待
	MACDEMO1_l("bebox", "Demo", "Invitation to BeBox", "5e2eb92e059fd2aa880c537da1385aa1", 484067, Common::JA_JPN, 404),

	WINGAME1_l("beestenboel", "", "ZOOLOGIC.EXE", "348bbc6d04f4ab2b9493c764cdbea8f4", 773051, Common::NL_NLD, 404),

	// Developed and published by Vantan International, Shibuya, Tokyo
	// Original filename for game is 新たなる魂の迷宮
	// Filename for toy box is データToyBox
	MACGAME1_l("bem", "", "xn--f9jwam9iq41vctmzz3e04s", "0c7bbb4b24823e5ab871cb4c1d6f3710", 483963, Common::JA_JPN, 404),
	WINGAME1t_l("bem", "", "BEM1.EXE", "5ab66bac290cb2891745d69b5656ed44", 743253, Common::JA_JPN, 404),
	MACGAME1_l("bemtoybox", "", "xn--ToyBox-hu4e9b90a", "0c7bbb4b24823e5ab871cb4c1d6f3710", 484067, Common::JA_JPN, 404),
	// Decomposed variant of the above
	MACGAME1_l("bemtoybox", "", "xn--ToyBox-vm4eyk6b36a", "0c7bbb4b24823e5ab871cb4c1d6f3710", 484067, Common::JA_JPN, 404),

	// Bilingual Japanese/English
	MACGAME1("beyondthetime", "", "Beyond the time", "2c7d0c0d55cbe3f622c7d68cedb671e0", 500421, 404),
	WINGAME2t("beyondthetime", "", "TIME.EXE",		"ed9f213b3bddf7573d40367cf1068b5c", 748793,
								   "DATAFILE.DXR",	"9778090a1465580b644be34699245b3a", 17508, 404),

	// Demo is from covermount of PC Guide (UK) Feb 1997
	MACGAME1("bht", "",   "A Brief History Of Time 16megs", "8719de9c083aca942fc0e5c0a127b6dc", 486726, 404),
	MACGAME1_l("bht", "", "Eine kurze Geschichte der Zeit", "8719de9c083aca942fc0e5c0a127b6dc", 486726, Common::DE_DEU, 404),
	WINGAME2("bht", "",		"BHT.EXE",		"d2f280d5ec355b252ffdadbe19332893", 692381,
							"PLAY_BHT.DIR", "663acc406405b6fcac7e2d89230c4cc2", 8398, 404),
	WINDEMO2("bht", "Demo", "BHT.EXE",		"d2f280d5ec355b252ffdadbe19332893", 692381,
							"PLAY_BHT.DIR", "9417d6ebe716c963a4424a1611aaa2ca", 3522, 404),
	WINGAME2_l("bht", "",	"BHT.EXE",		"d2f280d5ec355b252ffdadbe19332893", 692381,
							"PLAY_BHT.DIR", "a11fe20066d9e84423df6c3ef4966636", 69068, Common::DE_DEU, 404),

	WINDEMO2t("baseballhits", "Demo", "BASEBALL.EXE", "008d1690b0b764f8a75e4f4c6542b739", 3569928,
									  "WINDEMO.DIR", "e8e44e90e25c0efe74ddb77df545db1e", 2958900, 400),
	// Found on CD-ROM Today, #4
	MACDEMO1("baseballhits", "Demo", "Baseball demo", "5f850a4b82c69bb4074650c3c2044784", 301669, 400),
	WINDEMO2t("baseballhits", "Demo", "BASEBALL.EXE", "008d1690b0b764f8a75e4f4c6542b739", 3569928,
									  "WINDEMO.DIR", "6f9289021ac872ed504209b0b944c8fb", 2958900, 400),

	MACGAME1("blam2", "", "   BLAM!2-powermac", "71287376e445ab9c98f0d150bb0ed175", 60096, 404),

	WINGAME1("blaster", "", "DEMO.EXE", "617725437da4d66c176a9e7011977097", 24300731, 400),

	MACGAME1("blender",  "Volume 1.5", "Blender 1.5",		 "bcd3c718db258701496b3c5bcb827ef2", 483518, 404),
	WINGAME2t("blender", "Volume 1.5", "BLENDER.EXE",		 "f280c3cee63594aca2687ce96dbe0dde", 776767,
									   "FILES/OPENING.DIR",	 "08164bbffad6fc8bf45e81f0b47acfbb", 2986544, 404),
	MACGAME2("blender",  "Volume 2.1", "BLENDME (POWERMAC)", "9d10bbbf1b8d527e203c6be2eac3518c", 58058,
									   "FILES/OPENING.DIR",	 "f5d3c1e813ec276de53d5ff13a6bf337", 2888054, 404),
	WINGAME2t("blender", "Volume 2.1", "BLENDME.EXE",		 "ce776239b21820b1a8030cffa190ab37", 728849,
									   "FILES/OPENING.DIR",	 "b4fdf4b19e4a425a241624855617802a", 2887926, 404),
	MACGAME2("blender",  "Volume 2.2", "BLENDME (POWERMAC)", "9d10bbbf1b8d527e203c6be2eac3518c", 58058,
									   "FILES/OPENING.DIR",	 "9984fd46227b54b7e48a76cec2cec06b", 1991202, 404),
	WINGAME2t("blender", "Volume 2.2", "BLENDME.EXE",		 "ce776239b21820b1a8030cffa190ab37", 728849,
									   "FILES/OPENING.DIR",	 "3dd81344b84bc717bee11e878afe4339", 1991074, 404),
	// from CD-ROM Magazine #8
	WINDEMO2t("blender", "Volume 1.2", "BLENDER.EXE",		 "7ea9c92fdbd88f397b0e559e451cea0a", 776073,
									   "OPENING2.DIR",		 "3b7612dc2ed897b59f2063b82b8cc49c", 1849464, 404),
	WINDEMO2t("blender", "Volume 1.4", "BLENDER.EXE",		 "a2d1e9d51c277082fe7911f6bb4613ed", 704513,
									   "OPENING.DIR",		 "fa5a476ae30b10113541098d7dd11168", 12138642, 404),
	WINDEMO2t("blender", "Volume 2.3", "BLENDME.EXE",		 "ce776239b21820b1a8030cffa190ab37", 728849,
									   "OPENING.DIR",		 "cf1e8a8c8e8ee15fddda07490ded4b0e", 6989498, 404),

	MACGAME1("blenderbest", "", "PPC LAUNCHER", "9d10bbbf1b8d527e203c6be2eac3518c", 58058, 404),
	WINGAME1("blenderbest", "", "BLENDPC.EXE", "408fdb0f6806d93a9af0412f3704481e", 728849, 404),

	WINGAME1t("blinddate", "", "BLINDATE.EXE", "200eb58f092b3714e66596d9c435c301", 685837, 404),
	MACGAME1("blinddate", "", "Blind Date", "5323b298a375507307a2db7de1681a64", 310661, 404),

	// Original release is Win/Mac hybrid, Softkey release is Windows only
	// aka La Caverna dei Fantasmi (IT); Blinky Bill 1 en het verhaal van de Griezel-Grot (NL); A Caverna do Fantasma de Blinky Bill (PT)
	// Mac demo from MacFormat #44, Win demo from CD-ROM Today v2n10
	// French and Dutch demos from Transposia 98
	WINGAME1t(	"blinkybill1", "Softkey", "BLINKY95.EXE", "d63bdcee971abdccd26a7f9ad1faa39e", 713061, 404),
	MACGAME2_l(	"blinkybill1", "", "BB/16M", "17efee018a660458fae80de4364021ac", 481254,
								   "La Caverna dei Fantasmi", "cbf7119d62a3528d490cd517b4451061", 5967, Common::IT_ITA, 404),
	WINGAME1t_l("blinkybill1", "", "BLINKY95.EXE", "e711b3a14fe5664380c58f3e366e0b5c", 727459, Common::IT_ITA, 404),
	WINGAME2_l(	"blinkybill1", "", "start.exe",	   "be1e65196a1d1c810d84c0084a5c1033", 717299,
								   "ghost0.dxr",   "5d79d1d50d7abc7bc7b6d72b3b4b831d", 112048, Common::NL_NLD, 404),
	WINGAME1t_l("blinkybill1", "", "BLINKY95.EXE", "146512cdebe499a48872cc9e8710d738", 717025, Common::PT_BRA, 404),
	MACGAME2_l(	"blinkybill1", "", "BB/16M", "17efee018a660458fae80de4364021ac", 481254,
								   "A Caverna do Fantasma", "cbf7119d62a3528d490cd517b4451061", 5965, Common::IT_ITA, 404),
	MACDEMO2(	"blinkybill1", "Demo", "BB/16M", "17efee018a660458fae80de4364021ac", 481254,
									   "Ghost Cave Demo 16Mb", "5b8b1a76b4724565b8b3f184a753b79a", 2502, 404),
	WINDEMO1t(	"blinkybill1", "Demo", "BLINKY.EXE", "6641493b9033e5c39e0f0fa1870b1081", 712501, 404),
	WINDEMO1t_l("blinkybill1", "Demo", "BBDEMO95.EXE", "cfb7565e3f99adf6fed6cefab3cd8f2d", 716797, Common::FR_FRA, 404),
	WINDEMO1t_l("blinkybill1", "Demo", "BBDEMO95.EXE", "14e7a58d39b94b3374277382bf8effff", 715635, Common::NL_NLD, 404),

	WINDEMO1("blockbuster2", "Demo", "BB2.EXE", "132e49c93beae46c2803db11584e6315", 8447185, 404),

	WINDEMO2t_l("blownaway", "Demo", "DEMO.EXE", "db13582be83388b285f634b4165068ce", 745999,
									 "DEMO2.DXR", "39242284ad536ac5285fc6dfd239138f", 1694128, Common::DE_DEU, 404),

	WINDEMO1("bookshelf95", "Demo", "BS95DEMO.EXE", "9493e1f5e92c89de805f07e1529243d4", 2593543, 404),

	WINGAME2("bowie", "", "JUMP.EXE", 			"1706ba3b999d724957198c134e508127", 684317,
						  "INTRO/INTROBIT.DIR",	"c47416d9dc69baa552a6be470cd558cd", 895164, 404),

	MACGAME1("brer", "", "Brer Rabbit", "67f572196550aedb1f9523d782022be0", 483500, 404),
	WINGAME1t("brer", "", "BRER.EXE", "80b9c1a56bfa3c37c233341dc6bbdcc7", 699943, 404),

	WINDEMO1t("bugbook", "Demo", "BUGBOOK.EXE", "424749843e7c8e33d36e212f6c114a7c", 770291, 404),

	// Full game is not Director
	WINDEMO1("c64pack", "Demo", "C64DEMO.EXE", "0458e44d9ad4ae0d3a583ac4141d21ae", 1007517, 404),

	// Retail CD release from BeachWare, Inc.
	// Windows version also has CASINO2.EXE (Casino! Basic) for low performance PCs
	// Director-based AUTORUN.EXE launcher chooses between these options on Win9X
	// Win demo from "Classic Arcade" BeachWare CD
	MACGAME1("casino", "", "Casino! for PowerPC", "5bb6f4e7f9f026e2b5cf758796db3cd2", 57728, 400),
	WINGAME2t("casino", "", "CASINO.EXE", 	 "fdae6bb9b74fabe7e5eab6df294b02f5", 692873,
							"DATA/KENO.DIR", "b33710f7a6e8b79b490a659aa75e0416", 377712, 404),
	MACDEMO1("casino", "Sampler", "Casino! Sampler", "cbce20666bfe47a9533331c6be1e6039", 285255, 404),
	//GOLDILKS.EXE is not related, just used to prevent misdetections
	WINDEMO2t("casino", "Sampler", "CASINO.EXE", 	"9957a5c3d67e857b5fd9cb084f7f8726", 1801785,
								   "GOLDILKS.EXE",	"a59533f9043f9e642fc17d39c843d55b", 1894363, 404),

	// aka Cat'sEyeView
	// by Eij Kato
	// Later entries use Director 6
	MACDEMO1("catseyeview", "Demo", "Cat's Eye View.DEMO", "33f733b2809b94c3301096902f642b6e", 289490, 402),
	MACGAME1("catseyeview", "Vol. 1", "CAT'S EYE VIEW vol.1", "6f75a7279e4b05a6bce8c16971e9f244", 483187, 404),
	MACGAME1("catseyeview", "Vol. 2", "Cat'sEyeView vol.2", "6f75a7279e4b05a6bce8c16971e9f244", 483187, 404),
	MACGAME1("catseyeview", "Vol. 3", "Cat'sEyeView vol.3", "2c94dee7ddad3e6b47c7d62565286007", 484095, 404),
	WINGAME1("catseyeview", "Vol. 3", "CatsEyeView3.exe", "9ba8ac33552a3053cb1f23679422775e", 1900433, 404),

	MACGAME1("cbible", "", "Children's Bible Stories", "17efee018a660458fae80de4364021ac", 483490, 404),
	WINGAME1("cbible", "", "CBIBLE.EXE", "d408f781d32337f8a5a9b3655c7d7803", 1727225, 404),

	// Both versions require installation
	MACGAME1("cclown", "", "Color Clown", "bcea0da496deb8bf81c136a8538b9a01", 851892, 404),
	WINGAME1("cclown", "", "CCLOWN.EXE", "9bb66730af24e8a5d5cbbddfe98b33e6", 1050805, 404),
	WINDEMO1("cclown", "Help", "HCLOWN.EXE", "ed58a56a9e9e003433854a041cfb12c0", 698845, 404),

	// Original filename is 'CD-RAMギャラリー'
	MACGAME1_l("cdromfanmacworld96", "CD-RAM Gallery", "xn--CD-RAM-8q4e6oxbk2r", "8ea9e9a699c61edddffd79ddd0c994d7", 290006, Common::JA_JPN, 402),
	// Decomposed variant of the above filename
	MACGAME1_l("cdromfanmacworld96", "CD-RAM Gallery", "xn--CD-RAM-1m4etfmt3bl0t", "8ea9e9a699c61edddffd79ddd0c994d7", 290006, Common::JA_JPN, 402),
	// Original filename is 'まるちめ日記ﾘﾐｯｸｽﾃｷｽﾄ'
	MACGAME1_l("cdromfanmacworld96", "Maruchime Diary", "xn--h9jxck2b3563cwn3b2w5k3bai4cb4ep5nxe", "17efee018a660458fae80de4364021ac", 483159, Common::JA_JPN, 404),

	// Original Mac filename is Paul Cézanne 8 Mb
	MACGAME1("cezannetour", "", "Paul Cezanne 8 Mb", "2dca4bcd28ed470676af68563bf6a63e", 484075, 404),
	WINGAME1("cezannetour", "", "CEZANNE.EXE", "1463f0b6aa7d3d20de66699c16de2f98", 688027, 404),

	// from Hypermind
	WINDEMO2("chuniverse", "Demo", "UNIVERSE.EXE", "53f7608bfe324d1837fa03966a879470", 697235,
								   "DEFI.DXR",	   "f23981667821bd1ead36e94b3c6d7878", 1149448, 404),

	WINDEMO1("cinemania95", "1995 Demo", "CINEDEMO.EXE", "22a3ac2d4ad33edbfe531d269fe59738", 692419, 404),

	// French speech, English text
	WINDEMO1_l("cinemania96", "Demo", "CINE_FR.EXE", "1411329e65c11a6b1ebb57fc28f79d2f", 697783, Common::FR_FRA, 404),

	MACGAME1("chaquico1000", "ECD", "1000 Pictures", "01be45e7241194dad07938e7059b88e3", 486726, 404),
	WINGAME1("chaquico1000", "ECD", "1000_PIC.EXE", "7f69b6805b6a70c75b98171370ab906f", 4110937, 404),

	// Original filename is Chine Crisis /demo
	MACDEMO1_l("chinacrisis", "Demo", "Chine Crisis -demo", "b06606b4d174b85d41b265bd366959d6", 288158, Common::JA_JPN, 402),

	MACGAME1_l("choroli", "", "The Trip Of Choroli", "953c7bda965b8ee1ddb01e9120186412", 484021, Common::JA_JPN, 404),

	MACGAME1("chuckaduck", "", "Chuck A Duck", "77f4098988d5386794d1530065f514cd", 303933, 400),

	MACGAME1("chunchunworld", "", "CHUN-CHUN WORLD", "01be45e7241194dad07938e7059b88e3", 483518, 404),
	MACGAME1("chunchunworld", "From Harz", "From Harz", "e6833f1ce3b022f0128e4c80a55bcd46", 285282, 404),
	// Original filename is '"CHUN-CHUN" GOODについて'
	MACGAME1("chunchunworld", "Goods", "xn--CHUN-CHUN GOOD-paj56cka5082ujsalb3g", "e6833f1ce3b022f0128e4c80a55bcd46", 285282, 404),
	MACGAME1("chunchunworld", "Theme Song Artist", "Theme Song Artist", "3930940b5b4b2ae2563cc29b812855a6", 484095, 404),
	WINGAME1("chunchunworld", "", "CHUN_GM.EXE", "4594a0bc467703c82cd0c76651b6a34c", 696721, 404),
	MACGAME1("chunchunworld", "From Harz", "FROMHARZ.EXE", "ec8d69f8ff1972fa199b631e94ac3cda", 696739, 404),
	MACGAME1("chunchunworld", "Goods", "GOODS.EXE", "80a022cc330c1a3d26514c17cbe4943e", 696827, 404),
	MACGAME1("chunchunworld", "Theme Song Artist", "ARTIST.EXE", "e4b601ba3bf6fe9c661e0ab520c6c9cc", 696877, 404),
	MACGAME1("chunchunworld", "Theme Song View", "TSV_SL.EXE", "190b00ab0c009de914a5f3c5878547fb", 5596259, 404),

	// Original Mac filename is 中天スタート
	MACGAME1_l("chuteng", "", "Chu-Teng Start", "ea646eccc9a53f44ce082459d4809a06", 484351, Common::JA_JPN, 404),
	WINGAME1_l("chuteng", "", "CHUTENG.EXE", "aaef7b33829ff7b0243412c89869e011", 746971, Common::JA_JPN, 404),

	MACDEMO1("cinemac", "Sample Projector", "Sample Projector with BackDrop", "2c27791a84756be6201d281bad54f7bb", 285958, 404),

	MACGAME2("circus", "v1.0.6", "Circus!",  "dc5a87dda7a0daf46604515f7d2cca66", 319863,
								 "MAIN.DIR", "9aadad95362ec5204151e14dc8bf7e6c", 4324948, 404),
	WINGAME2("circus", "", "CIRCUS.EXE", "50d81af709047f5d1310468a3cd5a248", 1503187,
						   "MAIN.DIR",	 "9aadad95362ec5204151e14dc8bf7e6c", 4324948, 404),
	PIPGAME1_l("circus", "", "Circus!", "0d69b9bb731fba3d861a5f18e1810aa5", 61483, Common::JA_JPN, 404),
	MACDEMO2("circus", "Demo", "Demo",		  "dc5a87dda7a0daf46604515f7d2cca66", 308286,
							   "PREVIEW.MOV", "7d33c9b1fa93092499e29305f9b3a414", 5698025, 403),
	WINDEMO2t("circus", "Demo", "DEMO.EXE",	   "f4c553260761cbc7b070515d514b44ad", 685645,
								"PREVIEW.MOV", "2975f81df0e3540567f6e9460ba831f1", 5698025, 400),
	MACDEMO2("circus", "Looping Demo", "DemoLoop", "dc5a87dda7a0daf46604515f7d2cca66", 308286,
									   "PREVIEW.MOV", "7d33c9b1fa93092499e29305f9b3a414", 5698025, 403),
	WINDEMO2t("circus", "Looping Demo", "PREVIEW.EXE", "edeb117e306c77f1496631ff9d6f1cbb", 686139,
										"PREVIEW.MOV", "2975f81df0e3540567f6e9460ba831f1", 5698025, 400),

	// Product catalog - does not correspond to any single game
	// Mac version found on Blockbuster Video Guide to Movies & Videos
	// Win version found on the Billboard Music Guide CD (1995 and 1997)
	// The icon is the only additional file that could be used for detection
	MACGAME1("cmc", "", "Creative Multimedia Catalog", "0c7bbb4b24823e5ab871cb4c1d6f3710", 483490, 404),
	WINGAME2("cmc", "", "CATALOG.EXE", "11029bddba243a6be861367d45be5db9", 3896961,
						"CMC.ICO",	   "cecbfb6ffa9bd2b1fe27e2d571809c7f", 766, 404),

	// Original filename is CityNetLine デモ版
	MACDEMO1_l("cnl", "Demo", "CityNetLine Demo Version", "f5033f237ad1b1639fc46d01a82ac380", 286140, Common::JA_JPN, 404),

	WINDEMO2t("compton", "Guided Tour", "TOURDEMO.EXE", "cb88f94bc905aeb3ef8717196c4b0be9", 688039,
										"DEMO.DXR",		"7d87e2099fc0d3de8869a00f4a084f97", 1730688, 404),

	WINDEMO2t("comusic", "Sampler", "START.EXE", "53331f10b1eb1d9e45e713e80e2a7c1b", 731053,
								    "INIT.DIR",  "5b7a286b8e36f97ae594c35f4f89db51", 57796, 404),

	WINGAME2t("connections", "", "CONNECT.EXE", "6fab237cd2349f6450fabe8739148904", 690019,
								 "LAUNCHER.DXR", "5bc82c8782a446f5874873e3dfd5d96b", 825370, 404),
	WINGAME2t("connections", "", "CONNECT.EXE", "6fab237cd2349f6450fabe8739148904", 690019,
								 "LAUNCHER.DXR", "d69465f1d0d4ffe3cbf65900097254d0", 835456, 404),  // on HFS partition
	MACGAME1("connections", "", "Connections", "8120c82507f7ec1e19bab566ca529cda", 494340, 404),
	WINDEMO2("connections", "Demo", "CONNECT.EXE", "9ee064f5c862e75cf73ba567724dc8b9", 690023,
									"HOST2.DXR",   "42dc875a908e208af49fe3a0fa0c0a6d", 427760, 404),

	MACGAME1_l("cookieginger", "", "COOKIE", "17efee018a660458fae80de4364021ac", 484181, Common::JA_JPN, 404),
	WINGAME2t_l("cookieginger", "", "COOKIE.EXE", "03f2a878ff04b2e1ad7549fc6895da56", 766213,
									"MENU",		  "de44ab9002ee4f9a56805682a057fd47", 276800, Common::JA_JPN, 404),

	// From Blender 1.5
	// Original filename is 'the courtney filter™'
	MACGAME1("courtneyfilter", "", "xn--the courtney filter-jo0l", "bcd3c718db258701496b3c5bcb827ef2", 482582, 404),

	// Mac version's executable is inside an installer
	MACGAME1_l("crouton", "", "CROUTON F/CROUTON", "18f6634ce655067ddfaa413d3313515d", 484370, Common::JA_JPN, 404),
	WINGAME1t_l("crouton", "", "CROUTON.EXE", "03f2a878ff04b2e1ad7549fc6895da56", 766817, Common::JA_JPN, 404),

	// Rodney Alan Greenblat for Nick Games
	// Windows version from Disc Inferno from APC magazine (Australia), Dec 1999
	// Later Shockwave version is from Nickelodeon Clickamajigs
	WINGAME1("crybaby", "", "crybaby.exe", "e67c787e86a948dcac23fd0d533f53ab", 1211165, 404),

	// From Personal Computer World (UK) disc no. 4 - Dec 1996
	WINDEMO2("ctrain", "Demo", "DEMO.EXE", "d8226e09cff86cece90b52bc9eeaac7b", 1585550,
							   "01.DIR",   "63a263078c15a7352a3a6c0494e1d304", 1374398, 404),

	// Curio City (キュリオ シティ) is a quarterly series of virtual mall and entertainment CD-ROMs
	// issued by Mitsui & Co. to promote its Curio City shopping services.
	MACGAME1_l("curiocity", "Vol.1", "CURIO CITY", "8719de9c083aca942fc0e5c0a127b6dc", 502589, Common::JA_JPN, 404),
	WINGAME1_l("curiocity", "Vol.1", "CURIO.EXE", "15a14209211895887d80e650984b9e32", 747389, Common::JA_JPN, 404),

	WINDEMO1t("d", "Demo", "DDEMO.EXE", "66359d2e80ba536e34cb4f70772a80e1", 697001, 404),

	// MACGAME2("daedalus",   "Minimal",  "DAEDALUS",	   "0c7bbb4b24823e5ab871cb4c1d6f3710", 483490,
	//									  "DAEDALUS.DAT",  "4eb2fab14f1b932ae9f01d8b05a411de", 69538, 404),
	MACGAME2("daedalus",   "", "DAEDALUS",	   "0c7bbb4b24823e5ab871cb4c1d6f3710", 483490,
							   "DAEDALUS.DAT", "2b9e22ee93e5d58f383ef389fa09e12b", 69538, 404),
	// MACGAME2_l("daedalus", "Minimal",  "DAEDALUS",	  "0c7bbb4b24823e5ab871cb4c1d6f3710", 483490,
	//									  "DAEDALUS.DAT", "2b9e22ee93e5d58f383ef389fa09e12b", 69538, Common::DE_DEU, 404),
	MACGAME2_l("daedalus", "", "DAEDALUS",	   "0c7bbb4b24823e5ab871cb4c1d6f3710", 483490,
							   "DAEDALUS.DAT", "4eb2fab14f1b932ae9f01d8b05a411de", 69538, Common::DE_DEU, 404),
	// MACGAME2_l("daedalus", "Minimal",  "DAEDALUS",	  "0c7bbb4b24823e5ab871cb4c1d6f3710", 483518,
	//									  "DAEDALUS.DAT", "2b9e22ee93e5d58f383ef389fa09e12b", 69538, Common::FR_FRA, 404),
	MACGAME2_l("daedalus", "", "DAEDALUS",	   "0c7bbb4b24823e5ab871cb4c1d6f3710", 483518,
							   "DAEDALUS.DAT", "4eb2fab14f1b932ae9f01d8b05a411de", 69538, Common::FR_FRA, 404),

	WINDEMO2("dailymail100", "Demo", "STARTUP.EXE", "2e62abdad839e42068afdcd0644d7dcf", 1129467,
									 "LAUNCH2.DIR", "f913a0c83847ccc9df461311a4475a77", 223086, 404),

	// Mac executable is ダン
	MACGAME1_l("dan", "", "xn--6ck8e", "ea646eccc9a53f44ce082459d4809a06", 484887, Common::JA_JPN, 404),
	WINGAME2_l("dan", "", "DAN.EXE",  		 "1c0ff839ffc63cc21ce0017b5ad807ce", 740257,
						  "WINMOV/OP01.DXR", "c654ab3dd5edbb0e9e4ac1a47d768e62", 1763612, Common::JA_JPN, 404),

	// Both Mac and Win versions require installation to extract executable
	// Mac version has 68k, PowerPC, and a fat binary (default) as options in the installer
	// Mac installer is a Stuffit installer
	// Windows version in SETUP/DATA.Z
	MACGAME1("darkeye", "", "The Dark Eye (Universal)", "67f572196550aedb1f9523d782022be0", 486078, 404),
	WINGAME1t("darkeye", "", "DARKEYE.EXE", "67ba8428573dba0c8e12e7f02e4ef1bc", 742326, 404),

	// From the Police Quest Collection
	WINGAME1t("darylfgates", "", "INTERVEW.EXE", "8262bbad22daa2cdd9cf13ebba1b84ea", 1059729, 400),

	WINGAME1("davidsonpp", "1995", "DPP.EXE", "36c28cd89054df395c17c024a6ad6197", 112839901, 404),

	// Original Pippin filename is ダズロイド
	MACGAME1("dazzeloids", "", "Dazzeloids", "c9c25d0d249d529680302a81c30852d0", 367064, 404),
	MACDEMO1("dazzeloids", "Demo", "Dazzleoids", "77f4098988d5386794d1530065f514cd", 301697, 400),
	PIPGAME1_l("dazzeloids", "", "xn--eck0br2b9l", "2324c2928417a696fca46535ded53e32", 67986, Common::JA_JPN, 404),
	WINGAME1t("dazzeloids", "", "DAZZ.EXE", "4c968958368bed9ad4f5ec0e05d04b9f", 1034266, 404),
	PIPDEMO1_l("dazzeloids", "Non-interactive Demo", "xn--PippinDEMO-jx4ixivcug6w", "8b138db44d4421cc7294a9dc792ccf1b", 502657, Common::JA_JPN, 404),

	MACGAME1_l("dcanyon", "", "Devils Canyon (16+Mb)", "97474208c44c78f26bef8b2011d341aa", 483518, Common::IT_ITA, 404),
	WINGAME2("dcanyon", "",	  "DCANYON.EXE",		   "f5033a9fd54d41d348fa97bd13f8f088", 1050728,
							  "00INTRO.DIR",		   "d0c7645593725340480e2425811d6d8f", 3644052, 404),
	WINGAME2_l("dcanyon", "", "DCANYON.EXE",		   "f5033a9fd54d41d348fa97bd13f8f088", 1050728,
							  "00intro.Dir",		   "f6ca66b328f7fbcdd2e911273d74677c", 3777126, Common::IT_ITA, 404),
	WINGAME2_l("dcanyon", "", "DCANYON.EXE",		   "85e7939a0c3041660defb80e0d530230", 744381,
							  "00INTRO.DIR",		   "3621850ac727f9cf116c41143482c16c", 4044830, Common::ZH_CHN, 404),
	WINGAME1("dcanyoncd", "", "DINO_CD.EXE",		   "5fe054ed623541a92c04f1572ecb6c5d", 3160272, 404),

	// From CD Loisirs Nº6
	MACDEMO1("defendinghuman", "Demo", "Donald A Norman", "77f4098988d5386794d1530065f514cd", 301669, 400),

	// Mac executable is Derrat Sorcerum™ v1.0.3
	MACGAME1("derratsorcerum", "", "xn--Derrat Sorcerum v1.0.3-h40n", "a546ef2b921a9b48fd93928f1a505f22", 483506, 404),
	MACDEMO1("derratsorcerum", "Demo", "Derrat Sorcerum Demo v1.0.3", "a546ef2b921a9b48fd93928f1a505f22", 483506, 404),

	// Both Mac and Win versions require installation to extract executable
	MACGAME1("devo", "", "Smart Patrol", "01be45e7241194dad07938e7059b88e3", 478250, 404),
	WINGAME1("devo", "", "SMRTPTRL.EXE", "6030100dbff520b8763f6e98d15389d7", 741904, 404),

	// From Blender 1.5
	WINGAME1t("dewarswl", "", "dewars.exe", "b7e96f0dadee0f5a0f732e380bd7b5ea", 698341, 404),

	MACGAME1_l("digby", "", "Start Digby's Adventures", "a8e65a2268226bd59f12ebdc58a221f3", 481482, Common::ZH_CHN, 404),
	WINGAME1_l("digby", "", "DIGBY.EXE", "adc126fbc4387e5d8e84dcd5abd33653", 684269, Common::ZH_CHN, 400),

	MACGAME1_l("dieveteranen", "", "Die Veteranen", "a33b948ad52edc74a4439e176a3ba8bf", 1929826, Common::DE_DEU, 403),
	WINGAME1t_l("dieveteranen", "", "VETERANS.EXE", "a00b43e9262390ecf5028e057e6e0633", 692689, Common::DE_DEU, 400),

	MACGAME1_l("digitalboy1", "", "D_BOYMAC", "27519b873d23565470f627ad2f3d1b03", 501763, Common::JA_JPN, 404),
	WINGAME1t_l("digitalboy1", "", "D_BOYWIN.EXE", "fe921a468b2e8d6430833f8cf447171f", 2489733, Common::JA_JPN, 404),
	MACGAME2_l("digitalboy2", "", "D_BOYMAC", "bab5a4a4eb31642ce7f2e89038a95ef1", 501763,
								  "BOOKMARK.HTM", "2df648dbdf24b16880b7a14c1853c8dc", 2308, Common::JA_JPN, 404),
	WINGAME1t_l("digitalboy2", "", "D_BOYWIN.EXE", "080f123110205c26c0941756f2c255ae", 742873, Common::JA_JPN, 404),
	MACGAME2_l("digitalboy3", "", "D_BOYMAC", "bab5a4a4eb31642ce7f2e89038a95ef1", 501763,
								  "HTML/ANOTHER.HTM", "9c03bee25458afb918549a89f6ba8b70", 2692, Common::JA_JPN, 404),
	WINGAME1t_l("digitalboy3", "", "D_BOYWIN.EXE", "983157668ccbadfb35814ad897a46266", 742873, Common::JA_JPN, 404),

	MACGAME1_l("digitalgips3", "", "GIPSvol.3(PM)", "dcf4cc0d9aa3cf8fa0c127cf72477af9", 60665, Common::JA_JPN, 404),
	WINGAME1t_l("digitalgips3", "", "GIPS3.EXE", "5c314e820553eb6159c98f31e2615dfb", 742075, Common::JA_JPN, 404),

	WINGAME1t_l("dinoventure", "", "WINDINO.EXE", "c79c8650364bb44cfe195b136bf3eedb", 4210471, Common::JA_JPN, 404),

	MACDEMO1_l("dirmacromedia", "v4.0.3J Demo", "Director 4.0 Demo", "e258089af01c8233db77039828cc83f8", 1488951, Common::JA_JPN, 403),
	MACDEMO1_l("dirmacromedia", "v4.0.4J Demo", "Director 4.0 Demo", "ac3ee6f9e7854e3c1122a3f7cf5f9fd8", 1522370, Common::JA_JPN, 404),

	MACGAME1("dkmm2", "", "DKSDMac", "8554afe42cffb4add44bf37e48e1d954", 322661, 400),
	WINGAME1t("dkmm2", "", "DKSD2PC.EXE", "d43fd79cc7ec54a1b2b55562f4634b49", 862849, 404),

	MACGAME1("doorswindows", "", "doors and windows-start", "01be45e7241194dad07938e7059b88e3", 483490, 404),
	WINGAME1t("doorswindows", "", "doorwin.EXE", "af8680b093a154b6ece67b16569260a7", 2400203, 404),

	WINGAME1t_l("doshifunspecial", "", "DOSHIFUN.EXE", "7bf89e4d7175aef9f5ea532774cf2d4e", 4854695, Common::JA_JPN, 404),

	MACGAME1_l("dothereggae", "", "DoTheReggae", "f808a9f231b77617fa559cf9d2da66c1", 303896, Common::JA_JPN, 404),
	WINGAME2t_l("dothereggae", "", "REGGAE.EXE", 	   "07c61f99800a1e8871387e1c2c03828e", 15392661,
								   "SOUNDFIL/ALL.003", "298d5757a5e8fd686fb8432285e4e32e", 244678, Common::JA_JPN, 404),

	// Het Geheim Van Dracula localized by Transposia,
	// Dracula : Le Mystère du chateau published by Hoffmann + associates
	WINGAME2("draculassecret", "", "SECRET.EXE", "79cca0ac2870f070ea5228bff152b462", 808748,
								   "Int_1.Dir",	 "6210e24521f440ebd600d869c473444e", 5951298, 404),
	WINGAME2_l("draculassecret", "", "Dracula.exe", 	  "033eed030a848f54a8f1671f50c616e9", 772925,
									 "Dracula/INT_1.DIR", "bac609d9496142c8393a68435c25660d", 9387886, Common::FR_FRA, 404),
	WINGAME2_l("draculassecret", "", "secret.exe",		  "b24fbaf90985cdb79132eda2ee5b73d2", 1132985,
									 "Dracula/Int_1.Dir", "f2357c8e4b94e87b9d53018ecb9f1ed6", 5699816, Common::NL_NLD, 404), // original release
	MACGAME2_l("draculassecret", "", "Secret.PPC",  "b147d31ed577b9bbd3af764f178bb71c", 57832,
									 "Int_1.Dir",	"f2357c8e4b94e87b9d53018ecb9f1ed6", 5699816, Common::NL_NLD, 404),
	WINGAME2t_l("draculassecret", "", "secret.EXE",	"935dd6dc5bd2ea550396bdfd4f96d975", 763851,
									  "Int_1.Dir",	"a849d2170b83ea07df7c6f45c2d049a7", 5699816, Common::NL_NLD, 404),  // subdir on original release

	MACGAME1("dreidel", "", "dreidel", "77f4098988d5386794d1530065f514cd", 303933, 400),

	MACGAME2_l("dropcity", "", "Mac_Hi",   "17efee018a660458fae80de4364021ac", 481803,
							   "MAIN.Mov", "24a0bed30cef7fc9a83410f14cc51adc", 108648, Common::JA_JPN, 404),
	WINGAME2t_l("dropcity", "", "WIN.EXE",  "9680a67c57977e5d4a679455f722c240", 1298847,
								"MAIN.MOV", "69989b3693715e55366abdcb8cc77a2c", 90280972, Common::JA_JPN, 404),

	MACGAME1_l("earthtia", "", "LATHUR'S LEGEND", "b267d7e5f42c170a4f5dbb50a0f4e064", 289562, Common::JA_JPN, 402),

	// Full game is not Director
	WINDEMO1("earthwormjim", "Demo", "EWJDEMO.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	MACGAME2("easyitalian", "", "Easy Cooking Italian", "a8e65a2268226bd59f12ebdc58a221f3", 483490,
								"CONTENTS.DIR", 		"39a45c2f7a24e78213cfdf1c65322b46", 274382, 404),
	WINGAME2("easyitalian", "", "ITALIAN.EXE",  "acec057095e38421040129da764e0e16", 698291,
								"CONTENTS.DIR", "39a45c2f7a24e78213cfdf1c65322b46", 274382, 404),

	MACGAME1("ebntelebreakdown", "", "EBNTBeCD.MAC", "51f11d985a921c2cfcf2b763b7b9c2e3", 499512, 404),
	WINGAME1t("ebntelebreakdown", "", "EBNTBCDW.EXE", "77399581d91215a1149dcf08411d2f63", 2631477, 404),

	MACGAME1("edh", "", "Executive Diet Helper CD", "7e1e1bad51542c9a3b484b1dacdf47fc", 635616, 404),
	WINGAME1("edh", "", "EDHCD.EXE", "fdeadce56c6654312bf280eb21f36692", 9841489, 404),

	MACGAME1("einstein", "Hybrid",  "The Ultimate Einstein", "01be45e7241194dad07938e7059b88e3", 483468, 404),
	WINGAME2t("einstein", "Hybrid", "EINSTEIN.EXE",  "883dd5374ab39bd789fe984521c324a0", 711771,
							  		"EINSPLSH.DIR",  "dc7c483b682d841d4b6b9ef9d6d4d300", 161738, 404),
	WINGAME2("einstein", "", "EINSTEIN.EXE",  "5f2b54a1cbf0c62913d4f1fa07b5f3a9", 711759,
							 "EINSPLSH.DIR", "a722aca2b068e3aa02fef514c4b53730", 161738, 404),


	WINDEMO2t("elmopreschool", "Demo", "ELMO.EXE",			"52a0a157d70d370f4091e86ecf7a9408", 5070639,
									   "SHARED/CWLOGO.DIR",	"1e0c7e14f5f945965a780b0f7d336659", 652996, 404),

	// Demo is found on Pantsylvania CD
	MACDEMO1("elroybug", "Demo", "Elroy Goes Bugzerk Demo", "bcd3c718db258701496b3c5bcb827ef2", 498394, 404),
	WINDEMO1("elroybug", "Demo", "ELRYDEMO.EXE", "cb2d86ea52d81d12d1fe8eadfb4a118c", 2438763, 404),

	// Developed and published by Headbone Interactive, Seattle
	// Demo contains Apparelizer 1.0 minigame; Found on Disc Inferno from APC magazine (Australia), Dec 1999
	MACGAME1("elroycostume", "", "Elroy's Costume Closet", "0c7bbb4b24823e5ab871cb4c1d6f3710", 483490, 404),
	WINGAME1("elroycostume", "", "ECCLOSET.EXE", "f2fb9b1c60d3d1ee2b664165f4199391", 1327420, 404),
	WINDEMO1("elroycostume", "Demo", "elroy.exe", "9d18c6a224dd0e5be4ad03a05c74254b", 854349, 404),

	MACGAME1("elroypave", "", "Elroy Hits the Pavement", "17efee018a660458fae80de4364021ac", 525584, 404),
	WINGAME1("elroypave", "", "PAVEMENT.EXE", "7937f42747788b558bc32cced3d8f66b", 758491, 404),
	MACDEMO1("elroypave", "Demo", "Pavement Demo", "17efee018a660458fae80de4364021ac", 520880, 404),
	WINDEMO2("elroypave", "Demo", "PAVEDEMO.EXE",			 "073eb1dd818796efe9513b11a8a4bb2d", 802180,
								  "PAVEDEMO/P12/SHARED.DXR", "7fe5e2fa28260cbfa2d8675d948401b8", 112470, 404),

	// Separate binaries for English or French, 68K or PowerPC
	MACGAME1("emme", "", "The Keys to Knowledge PowerMac", "6d6772c4177764f6b556ba7c88f9b949", 60649, 404),
	MACGAME1_l("emme", "", "Les Secrets de la conn..Pow_Mac", "6d6772c4177764f6b556ba7c88f9b949", 60649, Common::FR_FRA, 404),
	WINGAME1("emme", "", "EMMPCENG.EXE", "b03fc5677dddb8fa85d24361a0e1e9b9", 4406907, 404),
	WINGAME1_l("emme", "", "EMMPCFRA.EXE", "b3ab1dab136dd60fca422409d8876375", 5120157, Common::FR_FRA, 404),

	WINDEMO2t("encarta95", "1995 Demo", "ENCARTA.EXE", 		 "f3ed0fec480c8b0396bfd3b22044fa6f", 12015231,
									    "SOUNDS/HURDY2.AIF", "a649e6394bc3f8b7037fead811bf7226", 217286, 404),

	// From CD Loisirs Nº6
	MACDEMO1("ephemeralfilms", "Demo", "Ephemeral Films", "77f4098988d5386794d1530065f514cd", 301669, 400),

	WINDEMO1("exos", "Demo", "EXOSDEMO.EXE", "e26dc25e9f03c4343375e84521dc0c7d", 4001759, 404),

	MACDEMO1_l("expbooktoolkit2", "1.5 Demo", "T2v1.5 DEMO", "0c7bbb4b24823e5ab871cb4c1d6f3710", 502657, Common::JA_JPN, 404),

	WINDEMO1("explorapedia", "1995 Demo", "XPLDEMO.EXE", "11f73ebd2da334912e717c05c33b7340", 4731995, 404),

	MACGAME2("explorers", "",	"Explorers",	"ea646eccc9a53f44ce082459d4809a06", 483518,
								"startExp.dir",	"9493238107c896d4b44b20088d3bc12e", 19114, 404),
	MACGAME2_l("explorers", "",	"Exploradores",	"ea646eccc9a53f44ce082459d4809a06", 483518,
								"STARTEXP.DIR", "3c3ab943769c548856d7cd84a8f808ec", 11198, Common::PT_BRA, 404),
	WINGAME2("explorers", "",	"XPLRNW.EXE",	"907c28b272eb40fad1b5f42ec841b010", 696741,
								"STARTEXP.DIR", "9493238107c896d4b44b20088d3bc12e", 19114, 404),
	WINGAME2_l("explorers", "", "XPLRNW.EXE",	"907c28b272eb40fad1b5f42ec841b010", 696741,
								"STARTEXP.DIR", "3c3ab943769c548856d7cd84a8f808ec", 11198, Common::PT_BRA, 404),

	// From MacFormat #42
	MACDEMO1("eyewitnessscience", "", "SCIENCE", "ec8ef0209ab8e43a803b5c283c3ce8fb", 310482, 403),

	WINDEMO2t("famalbum", "Tour", "TOUR.EXE",  "73b4edd8e627dc50d8107913d9386c9a", 1962659,
								  "LINGO.INI", "4f75e838a13079b4fc75af0fd6f70f3c", 826, 404),

	WINDEMO1("famdoc4", "1995 Demo", "BUBBA.EXE", "40e115073d00b7b763ff63b49e0ff798", 9322307, 404),
	WINDEMO1("famdoc4", "1996 Demo", "FAMDOC4.EXE", "cd004ff93ca55c4a5f04e4ec20db5d80", 13804287, 404),

	MACGAME1_l("fantasystudio", "", "xn--bcks5bae8ac5ovkid", "da0da5d543b237051975ad70bec129f4", 484743, Common::JA_JPN, 404),
	// Decomposed variant of the above
	MACGAME1_l("fantasystudio", "", "xn--2bkaw2bxdbn9bd8s8lyd", "da0da5d543b237051975ad70bec129f4", 484743, Common::JA_JPN, 404),

	// Full game is D3
	MACDEMO1_l("fantazion", "Demo", "Demo-16M", "77f4098988d5386794d1530065f514cd", 303053, Common::JA_JPN, 400),

	// Mac version requires installation, Felix Cartoon Toolbox Installer, uses Smaller Installer by Cyclos
	MACGAME1("fct",		  "", " Felix Cartoon Toolbox",	  "7446214d1f3b0309e51bc477b03096c9", 295690, 404),
	MACGAME1("fct",		  "", "Felix Cartoon Toolbox",	  "2acc993d795f2c196e5e5d82ea4f79ef", 68217, 404),
	WINGAME2("fct",		  "", "FELIX.EXE",				  "6475efb8f19537e6753ba898daaf8c8d", 694477,
							  "TOONDATA/1001",			  "79dbf7e5fbc80bbbcfdba5bd829b75f8", 5266, 404),
	MACGAME1("fctplayer", "", "Mac Felix Cartoon Player", "7446214d1f3b0309e51bc477b03096c9", 295667, 404),
	WINGAME2t("fctplayer", "", "PLAYER.EXE",			  "957fca2c54a595615d777112d2f00997", 834551,
							   "FILEIO.DLL",			  "dedd9461680203b848d85a8714bed814", 12832, 404),
	WINGAME2("fctexport", "", "TRANSFMR.EXE",			  "ca58379b982a714d975358421fe4be50", 1542693,
							  "TOONDATA/1001",			  "79dbf7e5fbc80bbbcfdba5bd829b75f8", 5266, 404),
	MACDEMO1("fct",	  "Demo", "BIG TOP DEMO",			  "ea646eccc9a53f44ce082459d4809a06", 486703, 404),

	WINGAME2("flw", "", "FLW.EXE", 		 "7d02787f74f2adfc0c66f34646380c0e", 720683,
						"FLW/FLWMM.DIR", "67be429651378de0de7ad0982b291824", 1230280, 400),

	MACGAME1_l("ffa", "", "FFA-8M", "411051c134236a9ead0d0d1837aafb5e", 290426, Common::JA_JPN, 402),
	PIPGAME1_l("ffa", "", "FFA", "2618a85198d0180e3eae9162f81aafed", 60921, Common::JA_JPN, 404),

	// Fred en de Flessenfiets (Demo)
	WINDEMO2t_l("flaschenfahrrad", "Demo", "FREDDEMO.EXE", 		"7a7f294d8c8fb9a956b7f098b29a2aed", 812075,
										   "FuFF/INTROFR.DXR",	"cf2e3e4cc089a7effd80423c2c2a283b", 3895154, Common::NL_NLD, 404),

	// Willy, der Zauberfisch : ein Meer voll Überraschungen!
	// Originally published by Tivola, Hamburg (1997)
	// Tivola edition is dual language De/En
	// De vis die kon wensen localized by Bombilla, Amsterdam
	// Published in English by Oxford University Press (1995)
	MACGAME1_l("fishwish", "", "Willy, der Zauberfisch", "ab2bda961c62f9deb2c1ba297d0a1ea9", 501559, Common::DE_DEU, 404),
	WINGAME2t_l("fishwish", "",	 "WILLY.EXE",	 	 "8b96b5ebd1e11d431e08971a2e3b6053", 2503499,
								 "EDATA/BUMPER.DIR", "8576a2bab07feb9f7055bfd5ceb3b2c4", 307048, Common::DE_DEU, 404),
	WINGAME1_l("fishwish", "",	 "WENSVIS.EXE",	 "50004a80942bafec52bbde5c09674bf9", 696993, Common::NL_NLD, 404),
	WINDEMO1("fishwish", "Demo", "FISHWISH.EXE", "04e5006ccbb86e4ba2d866ce9a5f69ae", 696845, 404),

	MACGAME2("fprpbaxter", "", "bigplayer", "07710cabdfcf6d9fba4205dce062399c", 642187,
							   "baxt0.Dir", "b475dcad8c26a234f825fe6f88c7ae0b", 5126656, 404),
	WINGAME2("fprpbaxter", "", "START.EXE",  "560c84484a76412254325caa953deeae", 698957,
							   "STARTW.DIR", "515c16244e84c2e2c2ef8a4e84c59e43", 29216, 404),

	MACGAME2("fprpyolanda", "", "bigplayer", "07710cabdfcf6d9fba4205dce062399c", 642187,
								"YP1.DIR",   "86dca2337cbbd2612fc92bd5d0805d85", 4509574, 404),
	WINGAME2("fprpyolanda", "", "START.EXE", "560c84484a76412254325caa953deeae", 698957,
								"YP1.DIR",   "86dca2337cbbd2612fc92bd5d0805d85", 4509574, 404),

	// ©1996 Davidson & Associates, Inc.
	MACDEMO1("fpgapirates", "Preview v1.0", "Pirates Preview (Power Mac)", "ccf864a8dc6e9d0d26eb73b4683e634b", 63276, 404),
	WINDEMO1t("fpgapirates", "Preview v1.0", "FPPSTART.EXE", "824388aeb958eda1a5691a1d6667a410", 792405, 404),

	// Collection of demos for the Puddle Books series
	MACGAME1("fppuddlebooks", "v1.0d2", "Puddle Books Demo", "07710cabdfcf6d9fba4205dce062399c", 644451, 404),
	WINGAME2("fppuddlebooks", "", "START.EXE", "c988e54a65cc107345f113a601bc47f7", 696731,
								  "START.DIR", "d66ca8450f52c8632e9c24e193c47bec", 9030, 404),

	// Portuguese version is from cover disc of Revista Big Max #10
	MACGAME1("frankenstein", "",	 "Frankenstein", 	 "01be45e7241194dad07938e7059b88e3", 483515, 403),
	WINGAME2("frankenstein", "",	 "FRANKIE.EXE",		 "a9a4e3a07f3ecda7e59215aabb844532", 2229509,
									 "MUSIC/ANMMUS.AIF", "5410aa67e91e805319da71a6aea32657", 505424, 404),
	WINGAME2_l("frankenstein", "",	 "FRANKIE.EXE",	 	 "98beeaa18c58708b0ce82de320e3bdf7", 2196911,
									 "MUSIC/ANMMUS.AIF", "5410aa67e91e805319da71a6aea32657", 505424, Common::DE_DEU, 404),
	WINGAME2_l("frankenstein", "",	 "FRANKIE.EXE",	 	 "1e4e424f5c6c78f68080e973fc4493a0", 2386679,
									 "MUSIC/ANMMUS.AIF", "5410aa67e91e805319da71a6aea32657", 505424,  Common::PT_BRA, 404),
	MACDEMO1("frankenstein", "Demo", "Frankenstein (PowerMac)", "db9f5fce2025aa6c1f8755af849fd49b", 60978, 404),
	MACDEMO1("frankenstein", "Demo", "Frankenstein Demo", "01be45e7241194dad07938e7059b88e3", 483526, 403),
	WINDEMO1("frankenstein", "Demo", "FRNKDEMO.EXE", "ed00aa67138b715a8bee6f41756852c5", 7365699, 400),

	MACDEMO1("frankrw", "Demo", "Franklin's Reading World Demo", "b66a5580d7b10e365241932e941b1dda", 483490, 404),
	WINDEMO2("frankrw", "Demo", "TITLE.EXE", "8879c4196154261cba4cba13fd8e6497", 696855,
								"TITLE.DXR", "e2b2e3bdf7d87ecd98e9bb768b7ed555", 2371220, 404),

	// Mac demo from CD Loisirs Nº6
	MACGAME1("freakshow", "D4", "FreakShow Projector", "dc5a87dda7a0daf46604515f7d2cca66", 300388, 404),
	WINGAME1t("freakshow", "", "INSTALL/FREAKS.EXE", "e36cf1ec95f220eb165f38b0e7b572a5", 695893, 400),
	MACDEMO1("freakshow", "Demo", "Freak Show", "77f4098988d5386794d1530065f514cd", 301669, 400),

	// http://discogs.com/release/2052805
	// Remastered album released by Euro Ralph, Hamburg (1994)
	MACGAME1("freakshowost", "Europe", "Power Bonus", "5bb6f4e7f9f026e2b5cf758796db3cd2", 57802, 404),
	WINGAME1t("freakshowost", "Europe", "BONUS.EXE", "5e36d25090274a82c43f39a3e450987b", 1358749, 404),

	// Should be Mac versions of these demos as well according to CONTENTS.TXT
	WINDEMO1t("frequency", "Interview", "INTERVU.EXE", "cf6f480f58715e48a3e18d0aee6b724e", 26083203, 404),
	WINDEMO1t("frequency", "frEQout", "FREQOUT.EXE", "ff223654239ccacd0a2e2e158187789b", 31765595, 404),

	MACDEMO1("fsky", "Demo", "A Field Trip to the Sky", "a1bb13f9e6b70ec5a5ed1ad350b5fecc", 498249, 404),

	// Bilingual Japanese/English
	MACGAME1("fukuda", "", "Mac/FUKUDA",  "0b55676d539ba5e29560e7c4da4fbad6", 483187, 404),
	WINGAME1t("fukuda", "", "WIN/MAIN/FUKUDA.EXE",  "71eec68c19354b67badc7c82f159374b", 739951, 404),

	// Original filename is ・ふたりの料理物語
	MACDEMO1_l("futarinoryori", "Demo", "A Tale of Two Chefs", "22815cf659b911c4e07d0015cac5d98f", 301681, Common::JA_JPN, 400),

	MACGAME1_l("futurepromotion", "", "FUTURE",  "2885d9aacbeaecf4a27a7978a6b55c9b", 290474, Common::JA_JPN, 400),
	WINGAME2t_l("futurepromotion", "", "FUTURE.EXE",  "a8e1020f952480d98920b1c7cc08644d", 6099243,
									   "FUTU.DXR",	  "e0a46377cd751a43d5a2912ddada370c", 1847366, Common::JA_JPN, 404),

	// Developed by DeAgostini Multimedia, Novara, Piedmont, Italy (1995)
	// Original Italian title is Fuzzy e Floppy: Il mistero dell'ape d'oro
	// Spanish title: Fuzzy & Floppy: Las Aventuras de La Abeja de Oro
	// German title: Fuzzy & Floppy auf der Jagd nach der goldenen Biene
	// English version by Macmillan Interactive Publishing (MIP), London
	MACGAME1("fuzzyfloppy1", "", "Fuzzy & Floppy (PPC)", "25e6bf9372fb9350b0873a2c1c66e312", 60068, 404),
	WINGAME1t("fuzzyfloppy1", "", "BEE.EXE", "f60a44f4c3fe602685f972e16746040d", 696827, 404),
	WINGAME1_l("fuzzyfloppy1", "", "APEDORO.EXE", "317dfcb883a6dd59129606adcd3ffdcb", 696827, Common::IT_ITA, 404),
	WINDEMO1t("fuzzyfloppy1", "Demo", "APE.EXE", "f60a44f4c3fe602685f972e16746040d", 696827, 404),

	WINGAME1t_l("fuzzyfloppy2", "", "ROTONDA.EXE", "99b7160243ac5807dc1e39c603284620", 701131, Common::IT_ITA, 404),

	MACGAME2_l("gate1", "", "THE_GATE",		"8ea9e9a699c61edddffd79ddd0c994d7", 290654,
							"start.Dxr",	"f4f0efc5c519b3ebd63c6d3f8e343967", 5622, Common::JA_JPN, 402),
	MACGAME2_l("gate2", "", "THE_GATE",		"8ea9e9a699c61edddffd79ddd0c994d7", 290654,
							"start.Dxr",	"27456dc17d056a822d5c8a3c046dc0d2", 5618, Common::JA_JPN, 402),
	MACGAME2_l("gate3", "", "THE_GATE",		"33f733b2809b94c3301096902f642b6e", 290654,
							"start.Dxr",	"662bb0fe055817639198f4b9851496de", 5636, Common::JA_JPN, 402),
	WINGAME1_l("gate1", "", "THE_GATE.EXE", "dd0bb1a07ad5b5d4489ac8f54e6ada2e", 712014, Common::JA_JPN, 402),
	WINGAME1_l("gate2", "", "THE_GATE.EXE", "0818b5c0ced885b5ebcef1bfd9523405", 711962, Common::JA_JPN, 402),
	WINGAME1_l("gate3", "", "THE_GATE.EXE", "48f4e49459ad83330521457642875406", 712003, Common::JA_JPN, 402),

	MACDEMO1_l("gecrs", "Demo", "GECRS 8MB", "0666ae690e459d3d0d91800ebd94de46", 290426, Common::JA_JPN, 402),

	MACGAME1_l("geraldmccoy", "", "Gerald McCoy", "19a5add87e0382e9149cd7d95de25186", 308080, Common::JA_JPN, 402),
	WINGAME1t_l("geraldmccoy", "", "G_MCCOY.EXE", "c9a6fb1d25b7ccd7e21cacbe1ecc2181", 739921, Common::JA_JPN, 404),

	// Original German Mac filename is Mäusejagd
	// Original multilingual Mac filename is Gröna Musikmössen
	// International release plays in English, Danish, Finnish, Swedish, Norwegian
	MACGAME1("ggmd", "", "Grona Musikmossen",			"8c50fe295dd0e2e523d430e8d6fba448", 483791, 404),
	MACGAME1_l("ggmd", "", "xn--Musejagd-0za",			"ea646eccc9a53f44ce082459d4809a06", 483490, Common::DE_DEU, 404),
	MACGAME1_l("ggmd", "", "Help! Muizen in 't hotel!", "e6833f1ce3b022f0128e4c80a55bcd46", 285538, Common::NL_NLD, 404),
	WINGAME1("ggmd", "",   "KMDGM.EXE",					"c45bac8f730cae2e2a174dbc14deff7b", 690021, 404),
	WINGAME2_l("ggmd", "", "MAUSJAGD.EXE",				"04d63d66464bce6356f9d70d83487838", 1302352,
						   "SHARED.DXR",				"15f0add56f03a01a98b076f4792608f6", 389060, Common::DE_DEU, 404),
	WINGAME1_l("ggmd", "", "MUIZEN.EXE",				"97f8977dae92d12cc8f9c7deff5e8f8d", 1483435, Common::NL_NLD, 404),
	MACGAME1("ggmdmaze", "", "Mouse Maze",				"17efee018a660458fae80de4364021ac", 482866, 404),
	WINGAME1("ggmdmaze", "", "MOUSMAZE.EXE",			"c306a1b1065c2ffe0ce2bfc0d58c52b4", 1690622, 404),
	MACGAME1_l("ggmdpics", "", "Gallery",				"ea646eccc9a53f44ce082459d4809a06", 483490, Common::DE_DEU, 404),
	MACGAME1_l("ggmdpics", "", "Galerij",				"ea646eccc9a53f44ce082459d4809a06", 483774, Common::NL_NLD, 404),
	WINGAME2_l("ggmdpics", "", "GALLERY.EXE",			"c476512cadbbcffc6af5cfee8670f8f7", 5099674,
							   "SHARED.DXR",			"15f0add56f03a01a98b076f4792608f6", 389060, Common::DE_DEU, 404),
	WINGAME1_l("ggmdpics", "", "GALERIJ.EXE",			"c476512cadbbcffc6af5cfee8670f8f7", 5099674, Common::NL_NLD, 404),
	MACGAME1("ggmdsuper", "", "SuperGame",				"17efee018a660458fae80de4364021ac", 482866, 404),
	MACGAME1_l("ggmdsuper", "", "Super Spel",			"17efee018a660458fae80de4364021ac", 482866, Common::NL_NLD, 404),
	WINGAME1("ggmdsuper", "", "SUPRGAME.EXE",			"5da9f151d28659d83cb381ceca7493f1", 740518, 404),
	WINGAME2_l("ggmdsuper", "", "SUPER.EXE",			"5da9f151d28659d83cb381ceca7493f1", 740518,
								"GGMDMENU.DXR",			"019cea5d103d926591e3845b9516997b", 283120, Common::NL_NLD, 404),

	MACGAME1("gigglecity", "",	   "Infinity City",		 "e6833f1ce3b022f0128e4c80a55bcd46", 285282, 404),
	WINGAME2("gigglecity", "",	   "INFINITY.EXE",		 "07b919509db761c7910f5677216b588d", 3228770,
								   "INTRO.DXR",			 "42c09c7363745b69f0616591055d510d", 2498942, 404),
	MACDEMO1("gigglecity", "Demo", "Infinity City Demo", "2d1fb07ef7ec0f4dad1a279989fa8f57", 304124, 404),
	WINDEMO1("gigglecity", "Demo", "ICDEMO.EXE",		 "f8eb3a346a02193cec8bc14497b73a8f", 802018, 404),

	// Demo is found on Pantsylvania CD
	MACGAME1("gigglefarm", "",	   "AlphaBonk Farm PowerMac", "bcd3c718db258701496b3c5bcb827ef2", 502333, 404),
	MACDEMO1("gigglefarm", "Demo", "AlphaBonk Farm Demo",	  "bcd3c718db258701496b3c5bcb827ef2", 502333, 404),
	WINGAME1("gigglefarm", "",	   "ALPHBNK.EXE", "9720ed078d3318e7dc51f1480e1280f0", 740982, 404),
	WINDEMO1("gigglefarm", "Demo", "ABFDEMO.EXE", "6ccff5b1e2541065b66ce6b33b2ade9f", 8517847, 404),

	MACGAME1("gigglevania", "", "Pantsylvania", "d9082ba24e164f376ffb3090c43fa997", 304149, 404),
	WINGAME2("gigglevania", "", "PANTS.EXE",	"1b10e3c6f6a47971802fe835642130ce", 697317,
								"INTRO.DXR",	"41101e9d94da0a627e75f5b93ae22f48", 5008606, 404),

	// CD-ROM Expanded Album by Ion, Los Angeles and Cryptic, San Francisco (1994)
	// European distribution by BMG Interactive, New York
	MACGAME1("gingerbreadman", "", "Gingerbread Man", "dc5a87dda7a0daf46604515f7d2cca66", 311476, 403),
	WINGAME1("gingerbreadman", "", "GBMAN.EXE", "e35da92f92ee7750a02b979a28492d7d", 696963, 404),
	MACDEMO1("gingerbreadman", "Demo", "Gingerbread Man Demo", "dc5a87dda7a0daf46604515f7d2cca66", 307880, 403),

	MACGAME1("godigital", "Vol.1 No.1",	"Go Digital vol.1 no.1", "dc5a87dda7a0daf46604515f7d2cca66", 291322, 403),
	MACGAME1("godigital", "Vol.1 No.2", "Go Digital vol 1 # 2",  "97474208c44c78f26bef8b2011d341aa", 482838, 404),
	MACGAME1("godigital", "Vol.2 No.1", "GoDigital3",			 "e6833f1ce3b022f0128e4c80a55bcd46", 284630, 404),
	WINGAME1("godigital", "Vol.1 No.1",	"GODIGIT.EXE", "8183e02291e69b19c9b1b149a8036ffd", 34247559, 404),
	WINGAME1("godigital", "Vol.1 No.2", "GODIGIT.EXE", "7ce7407982b9c3abfab010432a0b9b96", 703515, 404),
	WINGAME1("godigital", "Vol.2 No.1", "GODIG3.EXE",  "601b468f1e0e22319b7abd5c0d1787e7", 889427, 404),

	MACDEMO1("goldilocks", "Sampler", "Goldilocks Gamebook Sampler", "cbce20666bfe47a9533331c6be1e6039", 285267, 403),
	// from http://web.archive.org/web/20051126063716id_/http://www.beachware.com/download/goldsea.exe (self-extracting ZIP)
	WINDEMO1t("goldilocks", "Sampler", "GOLDILKS.EXE", "a59533f9043f9e642fc17d39c843d55b", 1894363, 404),
	WINDEMO1t("goldilocks", "Sampler", "GOLDILKS.EXE", "a59533f9043f9e642fc17d39c843d55b", 1894348, 404),	// if extracted using 7zip

	// Both versions require installation
	// Mac: "Gord@k Mac Installer", VISE 3.5 installer
	// Win: SETUP32.EXE, InstallShield v3
	MACGAME1( "gordak", "", "GORDAK",		"5f48d38b0c9b9c8790796d1eb1525713", 486726, 404),
	WINGAME1t("gordak", "", "GordakCD.exe", "0d9d03bf2462f22aed3cd3e7d49018df", 737262, 404),

	MACDEMO2_l("greetingstudio", "Demo", "Click Me",   "17efee018a660458fae80de4364021ac", 484351,
										 "MAIN.DIR",   "f5f8e6c76bb0659fc80fa2c1c263afa9", 3016176, Common::JA_JPN, 404),
	WINDEMO1_l("greetingstudio", "Demo", "SHOWME.EXE", "711b37028bca19093720fcb281c08b4d", 754977, Common::JA_JPN, 404),

	MACDEMO1("grolier", "Catalog", "Grolier Products", "f5033f237ad1b1639fc46d01a82ac380", 283274, 404),

	MACGAME1_l("guignols1", "", "LE JEU ! 12Mo", "e07d16e7d0986ef7acf3a5e302ed905e", 484075, Common::FR_FRA, 404),
	WINGAME2_l("guignols1", "", "ELM.EXE",	   "b04c8494176cbc3b2080bf1630ae1748", 697216,
								"GIGAMAT.DXR", "ab5960b3e663600388b5cc1b29f4920e", 744020, Common::FR_FRA, 404),

	// Full game is D5
	MACDEMO1("gundam0079", "Demo", "Gundam Demo", "01be45e7241194dad07938e7059b88e3", 483376, 400),

	MACGAME1("guns", "", "Multimedia Guns", "01be45e7241194dad07938e7059b88e3", 486671, 404),
	WINGAME2("guns", "", "GUNS.EXE", "43342caa10c6dc46f983787da1b625b7", 1636235,
						 "DATA/MAINMENU/MAINMENU.PIC", "9453f965417c5cb5c22d78bb3ce84a4f", 260166, 404),

	MACGAME1("gusbuds", "",		"MMV Product Demos for PowerMac", "692f6732b6d7deaa00c9b3df57bb30ce", 60324, 404),
	MACDEMO1("guscarn", "Demo", "Carnival Demo 4 you",			  "67f572196550aedb1f9523d782022be0", 481482, 404),
	MACDEMO1("gusolis", "Demo", "Cyberopolis DEMO",				  "77f4098988d5386794d1530065f514cd", 304217, 400),
	MACGAME1("guspark", "",		"Gus goes to CyberStone Park",	  "ccfbfc1a0ac231db40a250babaa6ad7c", 285538, 404),
	MACDEMO1("gustown", "Demo", "Gus Goes To CyberTown DEMO",	  "77f4098988d5386794d1530065f514cd", 304217, 400),
	// Guus in Cyberstad (demo)
	WINDEMO2_l("gustown", "Demo", "GUUS.EXE",	  "775eb4d8a78916b10e7531eebc758dd2", 8319869,
								  "STRAAT.DIR",	  "3f8a0dbad3f6af64d23bf2fc257bdd3d", 3286688, Common::NL_NLD, 404),

	WINGAME1("gusbuds", "",		"MMVDEMOS.EXE", "71d4ad9e9dc92a81561476d4d9813492", 692037, 404),

	WINGAME1("guspark", "",		"CYBSTONE.EXE", "ac22c7568c90ab4af7396148521f446e", 707439, 400),
	WINGAME1_l("guspark", "",	"CYBSTONE.EXE", "dc0be57ab8e9f9b54de24ac41b1b4854", 703913, Common::PT_BRA, 404),

	// Disc 1 is called Haight, Disc 2 is called Ashbury. You can start either one.
	// Mac partition contains three mini-games that can be launched directly from Finder
	// Original Mac game filenames are Tune ◊ In, Turn ◊ On, Drop ◊ Out
	// Demos are found on CD-ROM La Revista Nº6 (Spain) from Zinco Multimedia
	MACGAME1("haight", "Haight",   "Haight-Ashbury in the Sixties", "c9c25d0d249d529680302a81c30852d0", 493066, 404),
	MACDEMO1("haight", "Demo",     "Haight-Ashbury Short",          "c9c25d0d249d529680302a81c30852d0", 539498, 404),
	MACGAME1("haight", "Tune In",  "Tune In",                       "c9c25d0d249d529680302a81c30852d0", 493066, 404),
	MACGAME1("haight", "Turn On",  "Turn On",                       "c9c25d0d249d529680302a81c30852d0", 493066, 404),
	MACGAME1("haight", "Drop Out", "Drop Out",                      "c9c25d0d249d529680302a81c30852d0", 539498, 404),
	WINGAME1("haight", "Haight",   "HAIGHT.EXE",                    "f309096bd3eb9f45283d7218bb8f1c88", 821499, 404),
	WINDEMO1("haight", "Demo",     "HAROCK.EXE",                    "cd0ffd0e7612cd60aadaf42a7b4f480c", 821041, 404),
	WINDEMO1t("haight", "Demo",	   "HAROCK.EXE",					"5ceb3361a90e783c42991de65984b3ca", 820913, 404),

	// Different releases of hamsterland1 allow choice of language on the opening screen
	// English is always available, along with one alternate language
	// Dutch version was localized by Pride Kids Interactive of Ede, Netherlands
	MACGAME2_l("hamsterland1", "", "Hamsterland", "bcd3c718db258701496b3c5bcb827ef2", 483774,
								   "AIRDK",		  "f74f18a9d454db63465dac151a6b5706", 8425728, Common::DA_DNK, 400),
	MACGAME2_l("hamsterland1", "", "Hamsterland", "bcd3c718db258701496b3c5bcb827ef2", 483774,
								   "AIRSW",		  "ccf7c642796c5aeb9fee4c663bdd02d9", 7588992, Common::SE_SWE, 400),
	WINGAME2_l("hamsterland1", "", "HAMSTER.EXE", "2bb6e93d9aab502f46dbf163d51eb785", 785327,
								   "AIRDK",		  "ad98bbbd724e31a8a125e284a74d0241", 8425546, Common::DA_DNK, 400),
	WINGAME2_l("hamsterland1", "", "HAMSTER.EXE", "a0d2cfdf10ec14c00338329277bc8acc", 727653,
								   "AIRSP",		  "9b5b82d488b96b2fcf5e78ec8769e29a", 8432260, Common::ES_ESP, 400),
	WINGAME2_l("hamsterland1", "", "HAMSTER.EXE", "11669580c1f85b8caa4cd02373e7c947", 785221,
								   "AIRNL",		  "369dbec85b84239ea1ee10d647723243", 8426154, Common::NL_NLD, 404),
	WINGAME2_l("hamsterland1", "", "HAMSTER.EXE", "2bb6e93d9aab502f46dbf163d51eb785", 785327,
								   "AIRSW",		  "410efb55564b8eb2042eea61d0f8025b", 7588828, Common::SE_SWE, 400),

	// Original Mac filename is La Máquina del Tiempo
	MACGAME1_l("hamsterland2", "", "La Maquina del Tiempo", "2c7d0c0d55cbe3f622c7d68cedb671e0", 483774, Common::ES_ESP, 400),
	WINGAME1_l("hamsterland2", "", "HL2SP.EXE", "8dd22b8bde300c9fb5b66808905300f7", 875665, Common::ES_ESP, 400),
	MACGAME1("hamsterland2", "", "The Time Machine", "2c7d0c0d55cbe3f622c7d68cedb671e0", 483774, 400),
	WINGAME1("hamsterland2", "", "HL2EN.EXE", "4c812a63165c1f50242e879aae62718d", 859681, 400),

	// Sampler is found on AlphaBonk Farm and probably elsewhere
	MACGAME1("headbone", "Sampler", "Headbone CD-ROM Sampler", "5bbb193a8785c70abe2a4d86b99e1536", 304126, 404),
	WINGAME2("headbone", "Sampler", "SAMPLER.EXE",  "b083372f35bfaa97f68cfa7f9bb5222e", 2132572,
									"DemoMain.dxr", "d16606eadccdb21f654f4b4264fc996a", 2711628, 404),

	MACGAME1_l("henachoco04r", "", "RamenSpecial", "3731a1d809be07929da1f5d691ee3c97", 290398, Common::JA_JPN, 402),

	MACGAME1_l("henachoco06", "", "musimusichikin", "3731a1d809be07929da1f5d691ee3c97", 290398, Common::JA_JPN, 402),

	// Original filenames are '第１話' through '第５話'
	MACGAME1_l("henachoco07", "Episode 1", "xn--jwzs62ach2g", "3731a1d809be07929da1f5d691ee3c97", 290398, Common::JA_JPN, 402),
	MACGAME1_l("henachoco07", "Episode 2", "xn--jwzs62afh2g", "3731a1d809be07929da1f5d691ee3c97", 290398, Common::JA_JPN, 402),
	MACGAME1_l("henachoco07", "Episode 3", "xn--jwzs62aih2g", "3731a1d809be07929da1f5d691ee3c97", 290398, Common::JA_JPN, 402),
	MACGAME1_l("henachoco07", "Episode 4", "xn--jwzs62alh2g", "3731a1d809be07929da1f5d691ee3c97", 290398, Common::JA_JPN, 402),
	MACGAME1_l("henachoco07", "Episode 5", "xn--jwzs62aoh2g", "3731a1d809be07929da1f5d691ee3c97", 290398, Common::JA_JPN, 402),

	MACGAME1_l("henachoco08", "", "yataideomase", "3731a1d809be07929da1f5d691ee3c97", 290398, Common::JA_JPN, 402),

	MACGAME1_l("henachoco09", "", "nisemizi", "3731a1d809be07929da1f5d691ee3c97", 290398, Common::JA_JPN, 402),

	MACGAME1_l("henachoco11", "", "surowest", "3731a1d809be07929da1f5d691ee3c97", 290398, Common::JA_JPN, 402),

	MACGAME1_l("henachocoexpo", "", "iTA-YABOU", "3731a1d809be07929da1f5d691ee3c97", 290426, Common::JA_JPN, 402),

	// Original filename is 'オレニモインゼイクレヤンNew'
	MACGAME1_l("henachococd", "", "xn--New-qi4ba8azb4g2fxj0a3gg8gf", "ace16ae334528bef72c8a232539b4952", 292201, Common::JA_JPN, 402),
	// Decomposed variant of the above
	MACGAME1_l("henachococd", "", "xn--New-hh4b3bb3b5b1g6gnk3a0hh4hg", "ace16ae334528bef72c8a232539b4952", 292201, Common::JA_JPN, 402),
	WINGAME1t_l("henachococd", "", "INKURE.EXE", "0eeb6c11f37605f7e506eab7624cc193", 19324531, Common::JA_JPN, 404),

	MACGAME1_l("henachocogala", "", "galacle", "3731a1d809be07929da1f5d691ee3c97", 290398, Common::JA_JPN, 402),

	// Mac version is D3
	WINGAME1t("hhouse", "",			"HHOUSE.EXE",  "b0486032820bc6a413dd836650f8b0c3", 3181345, 400),
	WINDEMO1("hhouse", "1995 Demo", "HAUNTED.EXE", "5b7e970d8b8dec473e31cc6815c03bf6", 1166813, 404),

	MACGAME1_l("hibino", "", "INTERACTIVE EXHIBITION ppc", "422270206b9bd6aff43bbe95047f6ce9", 59757, Common::JA_JPN, 404),
	WINGAME1t_l("hibino", "", "HIBINO.EXE", "58bc10d8a9cf443e9451dd2c0325e23e", 747203, Common::JA_JPN, 404),

	// Original Mac filenames are "ひどいよ第一話", "ひどいよくん第二話", "ひどいよくん第三話"
	MACGAME1_l("hidoiyokun", "Dai-ichi-wa", "xn--n8jwd0a9fz90pnw8c3lwa", "35707ed8fa1cb9a3cb643b51681cd0a9", 290398, Common::JA_JPN, 402),
	MACGAME1_l("hidoiyokun", "Dai-ni-wa ", "xn--n8jwa0f9a2hxc9690agv6dhz2a", "35707ed8fa1cb9a3cb643b51681cd0a9", 290398, Common::JA_JPN, 402),
	MACGAME1_l("hidoiyokun", "Dai-san-wa", "xn--n8jwa0f9a2hxcs640aeqxehz2a", "35707ed8fa1cb9a3cb643b51681cd0a9", 290398, Common::JA_JPN, 402),

	// Found on Uki Uki 3 CD
	// Original movie filename is デモ
	MACDEMO2_l("himejijo", "Demo", "Macromedia Player", "de889febf08007ca7ac501a952cfba6f", 457275,
								   "Demo",				"88c318f3e821b4a76f8ff67bb97c002f", 6736268, Common::JA_JPN, 400),

	WINGAME2("hkbigfun", "", "KITTY.EXE", "42e600e8a917de593f4048428ec8d8b8", 703689,
							 "KINTRO",	  "b3fc8f8073f442573a371729d242c6c6", 971508, 404),

	MACGAME1("horobroy", "", "Rob Roy", "01be45e7241194dad07938e7059b88e3", 483382, 404),
	WINGAME1("horobroy", "", "ROBROY.EXE", "65d06b5fef155a2473434571aff5bc29", 2047746, 400),

	MACGAME1("horrortour1", "",	  "ZEDDAS(7M)", "da0da5d543b237051975ad70bec129f4", 483443, 404),
	WINGAME1("horrortour1", "",	  "ZEDDAS.EXE", "d3ce91f305dd0f4d2f5e9ff6d4e41a3b", 741818, 404),
	WINGAME2_l("horrortour1", "", "HORROR.EXE", "b16ecf8ebc02142c742b8a9acc935d52", 752425,
								  "HORROR.DAT", "42f0450d970a95f0dd47727988996ce9", 450, Common::ZH_TWN, 404),

	MACGAME1_l("horrortour1", "", "HorrorTour(7M)", "b7e69c37b7355022d400c14aa97c5d54", 483443, Common::JA_JPN, 404),
	WINGAME2_l("horrortour1", "", "HORROR.EXE", 	"b16ecf8ebc02142c742b8a9acc935d52", 752425,
								  "MOVIE/A00W.DXR", "772a21f2ab11134c6ec34f8c0fda3335", 8182870, Common::JA_JPN, 404),
	MACGAME1_l("horrortour2", "", "ZEDDAS PowerPC", "da7d3f1d85bdb99518b586c40d2a673e", 60013, Common::JA_JPN, 400),
	WINGAME2_l("horrortour2", "", "HT2.EXE",		   "499d8545ee2325b18d3f09fb2c0fc26e", 698029,
								  "NEWHT2/A002AW.DIR", "fa060cc849870e9f7821033a61edeb89", 6262642, Common::JA_JPN, 404),

	// Developed by Michael Eleftheriades
	// Mac version from The Mac CD-ROM 6
	// Windows version from CD-ROM Now issue #7 '94
	MACGAME1("housejam", "", "HOUSEJAM", "6ba1e12a35baf58a0d61f537e7489010", 283046, 404),
	WINGAME1t("housejam", "", "HOUSEJAM.EXE", "f00912d1c03213bb002d3062cbd1d123", 12034983, 404),

	// Full game is supported in SCI engine
	WINDEMO2t("hoyle5", "Demo", "HOYLE5.EXE", "499760334d09425e80c69e9a1b178ec5", 6287863,
								"LINGO.INI",  "4f75e838a13079b4fc75af0fd6f70f3c", 826, 404),

	MACGAME1("hurlman", "", "Hurlman", "6385f77fa00b44ccbb04258b864eeae6", 338931, 400),

	// full game is not Director
	WINDEMO2("hyperblade", "Demo", "HYPER.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817,
								   "HYPER.DIR", "44dce69e0473dae382bf80926a080c80", 2003612, 404),

	WINGAME1t("hotwheelscamaro", "", "CAMARO.EXE", "564b1fa630690b74eb1e2b940df4a8c6", 1435537, 404),
	WINGAME1t("hotwheelshydro", "", "HYDRO.EXE", "74a10424115e3f5e47b0422f31998e53", 1437147, 404),
	WINGAME1t("hotwheelsmustang", "", "MUSTANG.EXE", "b3eb31d3d5006cbb61116a36d1fa5ada", 1434270, 404),
	WINGAME1t("hotwheelspistons", "", "PISTONS.EXE", "357e222858329db60762765b982771b4", 1434560, 404),
	WINGAME1t("hotwheelsrigor", "", "RIGOR.EXE", "db508eeafce0c568a6fab9254e3cfbe4", 1443043, 404),
	WINGAME1t("hotwheelswiener", "", "WIENER.EXE", "6d0228018fb293aa6e48b2a51e273e4d", 1391592, 404),

	MACGAME1("hunchback", "", "Hunchback", "17efee018a660458fae80de4364021ac", 481226, 404),
	WINGAME1t("hunchback", "", "HUNCH.EXE", "27d1a388006a4b2d63b1810248a55b14", 25837061, 404),

	WINGAME2("id4p1", "", "SUPREME.EXE", "629eb9a5d991a2dbe380804e8c37043a", 1664965,
						  "ALIEN.ICO",	 "fcd97560b8b3f7404f9119bc06bbd5b5", 766, 404),
	WINGAME2("id4p2", "", "SCIENCE.EXE", "812a4b81b70e61e547c14dbbd507b402", 1766499,
						  "ALIEN.ICO",	 "fcd97560b8b3f7404f9119bc06bbd5b5", 766, 404),
	WINGAME2("id4p3", "", "WARRIOR.EXE", "387245092ce0583c6fd0c54000b1502a", 1751593,
						  "ALIEN.ICO",	 "fcd97560b8b3f7404f9119bc06bbd5b5", 766, 404),
	WINGAME2("id4p4", "", "NAV.EXE", 	 "29de2d1fd34029b3c97ce852a7fc665e", 1834037,
						  "ALIEN.ICO",	 "fcd97560b8b3f7404f9119bc06bbd5b5", 766, 404),
	WINGAME2("id4p5", "", "STEVE.EXE",   "14f19b724dd6361e4bf3cfddbac87d3f", 1797301,
						  "F18.ICO",	 "02a3ae4b3fc4d7dce93542f2345f178d", 766, 404),
	WINGAME2("id4p6", "", "DAVE.EXE", 	 "237f9db2ea9a38fa6f7292974539f494", 1774167,
						  "F18.ICO",	 "02a3ae4b3fc4d7dce93542f2345f178d", 766, 404),
	WINGAME2("id4p7", "", "PREZ.EXE",	 "e7d03a6d749d65dbcea7171ec4627e9c", 1666293,
						  "F18.ICO",	 "02a3ae4b3fc4d7dce93542f2345f178d", 766, 404),
	WINGAME2("id4p8", "", "ALIEN_F.EXE", "ee2eb92900d515ed7872c57f3b89a408", 1754975,
						  "ID4.ICO",	 "309dc88201ab742ffeb3e77f391cef3d", 766, 404),
	WINGAME2("id4p9", "", "F18.EXE",	 "7a0292909a5103c89297c40cce1d836c", 1691893,
						  "F18.ICO",	 "02a3ae4b3fc4d7dce93542f2345f178d", 766, 404),
	WINGAME2("id4p10", "", "BOMBER.EXE", "17758a9f425f7f3e7a926951e6c770f4", 1844189,
						   "ID4.ICO",	 "309dc88201ab742ffeb3e77f391cef3d", 766, 404),
	WINGAME2("id4p11", "", "AREA51.EXE", "78be40f9c7e8e1770c388cc16a522aaf", 1776077,
						   "ID4.ICO",	 "309dc88201ab742ffeb3e77f391cef3d", 766, 404),

	// From More MacCube, disc 3
	MACGAME1("illusions", "", "ILLUSIONS", "7fd44b6dffa0ea0402eaed4c3769b39b", 285282, 404),

	MACGAME2_l("illustratorsamerica", "", "IIA.PPC",  "da7d3f1d85bdb99518b586c40d2a673e", 63845,
										  "MENU.Dxr", "1b5b5a6ed3a683e5a03c2b77d4558cc9", 6195040, Common::JA_JPN, 403),
	WINGAME2t_l("illustratorsamerica", "", "IIA.EXE",  "77a83014d697fbb3f908739b03e8341a", 771599,
										   "MENU.Dxr", "215b90c31bdf2dd19104534d11af3328", 6195040, Common::JA_JPN, 403),

	MACDEMO1("imagineers", "Portfolio", "The Imagineers Demo", "f00c61f30719f8ed5f64ddff2e3c7268", 482302, 404),

	WINGAME1("imaginopolis", "1995 Demo", "MSKIDS.EXE", "f99d634a7880364990da8564010b95e2", 3394725, 400),

	MACGAME1("imesceneryfish", "ECD", "Scenery and Fish", "e60d4b832a771b0064a703938f82dfb3", 2804, 404),
	WINGAME2("imesceneryfish", "ECD", "runme.exe",		  "47b17c219097afb877fd9bc15455e4d4", 738415,
									  "main.dir",		  "0b20d6b771b4f5fd50e823c3773aecdd", 3526788, 404),

	MACGAME1("imision369", "v2.1", "ImIsion 369", "5830ee2b9ecc97ce8026d00e0977f555", 296780, 404),

	// Play as either Shirley (disc 1) or Dolan (disc 2)
	MACGAME2("improv", "Shirley", "IMPROV (PowerPC)", "096e0aacbc1670c80a354c3c49b3fabe", 60324,
								  "INTRO.DIR",		  "62695e977e1a29647e630f70349a3690", 2926976, 400),
	MACGAME2("improv", "Dolan",   "IMPROV (PowerPC)", "096e0aacbc1670c80a354c3c49b3fabe", 60324,
								  "INTRO.DIR",		  "dd667e45e402729581c70f278140f3a5", 3400832, 400),
	WINGAME2("improv", "Shirley", "IMPROV.EXE",		  "097276acd3caee9bc79b85af79278643", 730079,
								  "INTRO.DIR",		  "37f2d3c0b6f805e7a0f3a3ea62f8297c", 44532, 400),
	WINGAME2("improv", "Dolan",   "IMPROV.EXE",		  "097276acd3caee9bc79b85af79278643", 730079,
								  "INTRO.DIR",		  "075c3c7bd7c059280ca86c6b906bf97b", 46366, 400),

	// Non-interactive preview of Dark Eye and Smart Patrol from the Bad Day CD
	WINGAME1("incoming", "Preview", "INCOMING.EXE", "7c40db466105d08a53bb41023abdaa6a", 743550, 404),
	// Non-interactive preview of Bad Day and Smart Patrol from The Dark Eye v1.0.3 CD
	MACGAME1("incoming", "Preview", "iNCOMING", "01be45e7241194dad07938e7059b88e3", 483467, 404),
	WINGAME1t("incoming", "Preview", "INCOMING.EXE", "66bfffe0023556b08bd71a42dc7ce9c7", 743518, 404),

	MACGAME1("insidemacgames", "Volume 1", "IMG CD-ROM", "2e2becf3549673a8107c0d2028a08fc1", 353787, 400),

	// Also launches three other projectors on disc, including some D3 and D5
	MACGAME1("interactivemagic", "", "Mac Interactive Magic", "337c94c66b435e075a2d7f94b3cffc49", 483490, 404),

	MACGAME2_l("intro2", "", "Intro_02",	 "0666ae690e459d3d0d91800ebd94de46", 290398,
							 "NEW_EDGE.DIR", "d0b2d1726192b1b9f54c9958e29e337b", 407960, Common::JA_JPN, 402),
	WINGAME2t_l("intro2", "", "INTRO_2.EXE",  "bbca5270c1b88a67e5f05f498ef61114", 1531397,
							  "NEW_EDGE.DIR", "132a479c6e69f34a13961c77431d46a8", 407960, Common::JA_JPN, 404),

	MACGAME2_l("intro4", "", "Intro_04",  "8719de9c083aca942fc0e5c0a127b6dc", 484067,
							 "INTRO.DIR", "542e9b1dda64de784066a65a557b1496", 2063096, Common::JA_JPN, 404),
	WINGAME2t_l("intro4", "", "INTRO_04.EXE", "192f16367c1d249beff3d416f1e99c6c", 2221741,
							  "INTRO.DIR", 	  "1917276c6c3af2efdb740a36903ae7e7", 2063096, Common::JA_JPN, 404),

	// Original filename is チュートリアル
	MACDEMO1_l("inposition", "Tutorial", "Tutorial", "77f4098988d5386794d1530065f514cd", 305533, Common::JA_JPN, 400),

	// Original filename is 'いぬちゃんのうたＣＤデモ'
	MACGAME1_l("inuchancd", "", "xn--n8jyc6a7frd6opgo41v280bt08wva9a", "8ea9e9a699c61edddffd79ddd0c994d7", 290398, Common::JA_JPN, 402),
	// Decomposed variant of the above
	MACGAME1_l("inuchancd", "", "xn--n8je9eg8cn0m6e8b70a4jr269sna", "8ea9e9a699c61edddffd79ddd0c994d7", 290398, Common::JA_JPN, 402),

	// Original filename is 'いぬちゃんバレンタイン'
	MACGAME1_l("inuchanvalentine", "", "xn--n8jyc6a7frdweui5ewkocc", "8ea9e9a699c61edddffd79ddd0c994d7", 290398, Common::JA_JPN, 402),
	// Decomposed variant of the above
	MACGAME1_l("inuchanvalentine", "", "xn--n8jyc6a7frdqb3ezk8e1ltcc", "8ea9e9a699c61edddffd79ddd0c994d7", 290398, Common::JA_JPN, 402),

	MACGAME1_l("inuchanfighter", "", "xn--t9g017crcwb6g1d9dya7vvh", "8ea9e9a699c61edddffd79ddd0c994d7", 290398, Common::JA_JPN, 402),

	// Original filename is '映画パロディ２本立て', e.g. 'Two Movie Parody'
	MACGAME1_l("inuchanmovieparody", "", "xn--m9jtg6dqbxjq815azsbr17clqkdp63a", "8ea9e9a699c61edddffd79ddd0c994d7", 290398, Common::JA_JPN, 402),
	// Decomposed variant of the above
	MACGAME1_l("inuchanmovieparody", "", "xn--m9j7ec1b4l0b5m5841bd8bdu0d01meq88a", "8ea9e9a699c61edddffd79ddd0c994d7", 290398, Common::JA_JPN, 402),

	// Original Mac filename is Grandes Inventos™
	MACGAME1_l("inventos", "", "Grandes Inventos", "bcd3c718db258701496b3c5bcb827ef2", 483774, Common::ES_ESP, 404),
	WINGAME1_l("inventos", "", "INVENTOS.EXE", "667c71ae2c24cae2e7e4e82b52d5a7bc", 750295, Common::ES_ESP, 404),

	// Demos and product catalog from Iona Software, Ltd.
	MACDEMO1("iona", "'96", "IONA DEMO", "547fefcd6bda748214be2068a7bcdead", 292216, 404),
	WINDEMO2("iona", "'96", "DEMO.EXE", "95a3aeb1017546da820a8d3c95d3c4e4", 1946711,
							"MAIN.DIR", "71eacbde48a94043390d7dab58b8bb52", 1812168, 404),
	// Iona + Edmark catalog
	WINDEMO2t("iona", "'96+Edmark", "DEMO.EXE",		"103e0c6cce7f5f1f61580dc6913f273c", 1060457,
									"EDMOVIES/BBH", "3ada3c95704cafcbee5c96e7d2216c4c", 3051912, 404),

	WINGAME2_l("ios", "", "IOS.EXE",   "2b8edd5af0f79d84542c57754b7fbf61", 1004833,
						  "0START/05", "3c35f13540c5cef6cc69556934fbf0f0", 45486, Common::JA_JPN, 404),
	WINGAME2_l("ios", "How To Game", "HOW.EXE", "a526a724f26e266b17815b4f7f7ae079", 1863309,
									 "HOW02",	"86a19681ed45c043b5756f5a6ea189de", 2116536, Common::JA_JPN, 404),

	MACGAME1("isaslm", "", "install this stuff/VM folder/VMplay", "27519b873d23565470f627ad2f3d1b03", 322465, 400),
	// WINGAME1t("isaslm", "", "PLAY_IT.EXE", "ab30cc755f44ac3844fee3214cfc5ead", 691009, 400),
	WINGAME1t("isaslm", "", "VMCD.EXE", "02b7441caf27724af5d055259d0d8e30", 1104401, 400),


	MACGAME1("isis", "", "ISIS", "dedfabf9ee7bf5aab003bdab4137bca6", 777630, 404),
	WINGAME2("isis", "", "ISIS.EXE", 				 "59c1cb960199dd3f041262ab5271bb23", 14747213,
						 "ISISF/ISISMOV/AWAKEN.MOV", "4af94a98adcce7f9132492d9ae951857", 7308178, 404),
	MACGAME1_l("isis", "", "ISIS", "dedfabf9ee7bf5aab003bdab4137bca6", 780354, Common::DE_DEU, 404),
	WINGAME2_l("isis", "", "ISIS.EXE",				   "d7f7e89495ac22c75b3fc04c09675b6e", 16750643,
						   "ISISF/ISISMOV/AWAKEN.MOV", "44547ec0c4277d7a9e0df5cd9ae92929", 7307271, Common::DE_DEU, 404),

	WINDEMO1t("it1d", "Demo", "INTHE1ST.EXE", "b6c6fd5d3cdb941f63128e13716c2f68", 2597207, 400),
	// found on PC Format CD-ROM Collection 19
	WINDEMO1t("it1d", "Demo", "INTHE1ST.EXE", "685717457c3219012eda7403579f94c9", 2576067, 400),

	MACGAME1("iwave", "Issue 1", "!", "ae7178ba5dd9dcd15fb7a27cd99089b2", 484389, 400),
	WINGAME1("iwave", "Issue 1", "IWAVE.EXE", "67aa1f75dc23e071e5325be04e9738a6", 690955, 400),

	// Note: There are four versions of the binary included on the disc.
	// French version was distributed by Ubi Soft
	// English versions 2.00 and 2.0.1 were distibuted by Discis and DreamCatcher, respectively
	// Horses of Asva demo is found on Czech Super Hry III CD from Future Media International
	// Japanese demo was distributed by UEP
	// Original filename of Japanese demo is ２分間デモ
	MACGAME2("jewels1", "v2.00",		 "Jewels 11 Meg",	"339c89a148c4ff2c5c815c62ac006325", 483666,
										 "NAVLOAD.Dxr",		"862688a820a7494f8a9edd196e04b5bf", 164, 404),
	MACGAME1t_l("jewels1", "2.00",		 "Jewels 11 Meg",	"4b3bf99f4e591b71fe79cde05eece71e", 1200512, Common::FR_FRA, 404),
	MACGAME2_l("jewels1", "",			 "Jewels 11 Meg",	"339c89a148c4ff2c5c815c62ac006325", 483666,
										 "NAVLOAD.Dxr",		"711211bf062c3cab48ce90870900bc3b", 215, Common::FR_FRA, 404),
	MACDEMO1("jewels1", "Demo",			 "Two-Minute Demo", "01be45e7241194dad07938e7059b88e3", 483490, 404),
	WINGAME2t("jewels1", "v2.00",		 "JEWELS.EXE",		"342a30a28575249a6f18ce409e15fc26", 712515,
										 "NAVLOAD.DXR",		"8c11e4282c40a82107e6638112d7b495", 765030, 404),
	WINGAME2t_l("jewels1", "v2.00",		 "JEWELS.EXE",		"a3c4be6eb9803f577ed1d80d51e236e1", 800395,
										 "NAVLOAD.DXR",		"c696b2453b861d51cea75c7398acb5a8", 405050, Common::FR_FRA, 404),
	WINGAME2("jewels1", "v2.0.1",		 "JEWELS.EXE",		"bb6d81471d166088260090472c6c3a87", 800395,
										 "NAVLOAD.DXR",		"ff8446121236a1cbfb1fe431fea5bc09", 405042, 404),
	WINGAME2_l("jewels1", "",			 "JEWELS.EXE",		"bb6d81471d166088260090472c6c3a87", 800395,
										 "NAVLOAD.DXR",		"e7dfda887f9040bb29ad822717a11cc7", 405236, Common::DE_DEU, 404),
	WINDEMO2("jewels1", "Horses Demo",	 "HORSE.EXE",		"03bbe56c80fcbca3939ba08407d99f76", 847689,
										 "PUZZ_19.DXR",		"7de54130d57b063db0649027c3fd052d", 1181314, 404),
	WINDEMO2("jewels1", "Demo",			 "JEWELS.EXE",		"abcc448c035e88d4edb4a29034fd1e34", 863983,
										 "PUZZ_01.DXR",		"ea75491b1be5352de158c310fcf7baf5", 267074, 400),
	WINDEMO2("jewels1", "Nightsky Demo", "DEMO.EXE",		"ebee52d3c4280674c600177df5b09da0", 800403,
										 "NAVLOAD.DXR",		"1f4466ba91364dd7223264b86dd5402c", 403980, 404),
	WINDEMO2_l("jewels1", "Demo",		 "DEMO.EXE",		"ebee52d3c4280674c600177df5b09da0", 800403,
										 "NAVLOAD.DXR",		"1f4466ba91364dd7223264b86dd5402c", 403980, Common::FR_FRA, 404),
	MACDEMO1_l("jewels1", "Demo",		 "xn--edkuc862lmq0ddizf", "01be45e7241194dad07938e7059b88e3", 483518, Common::JA_JPN, 404),
	MACDEMO1("jewels1", "Preview",				 "Jewels (Millions of colors)", "dc5a87dda7a0daf46604515f7d2cca66", 291988, 400),
	MACDEMO1("jewels1", "Preview, Puzzles only", "Jewels (Puzzles Only)", "dc5a87dda7a0daf46604515f7d2cca66", 291988, 400),
	MACDEMO1("jewels1", "Preview, Tour",		 "Jewels Tour", "dc5a87dda7a0daf46604515f7d2cca66", 291988, 400),

	// Original filename is '人格図鑑'
	MACGAME1_l("jinkakuzukan", "", "xn--gmq53rj3o0s5b", "bcd3c718db258701496b3c5bcb827ef2", 484095, Common::JA_JPN, 404),
	WINGAME1t_l("jinkakuzukan", "", "JIN_98.EXE", "a054f384ec95c65e01738e4d16970937", 752141, Common::JA_JPN, 404),

	// Original filename is JMP Turbo™
	MACGAME1("jman", "Turbo!", "JMP Turbo", "cc3321069072b90f091f220bba16e4d4", -1, 400),
	MACGAME1("jman", "Making Of", "The Journey", "cc3321069072b90f091f220bba16e4d4", -1, 400),
	MACDEMO1("jman", "Director's Cut Demo", "Journeyman - Director's Cut", "01be45e7241194dad07938e7059b88e3", 484284, 400),

	// Original filename is Buried in Time™ PowerPC; also contains 68k binary
	// Revised '06/22/94 demo' is from Bandai Visual CD-ROM Previews Kawara-ban Vol. 3
	// On this Japanese disc, the filename is encoded as MacRoman, resulting in Buried in Timeｪ Demo
	// The MacRoman filename should have been Buried in Time™ Demo
	MACGAME1("jman2", "", "Buried in Time PowerPC", "71287376e445ab9c98f0d150bb0ed175", 80334, 400),
	MACGAME1_l("jman2", "", "Buried in Time PowerPC", "71287376e445ab9c98f0d150bb0ed175", 86324, Common::DE_DEU, 400),
	MACDEMO1("jman2", "Demo", "Buried in Time Demo", "1ae45c23586b41997ba52e2e7c771c4c", 437743, 400),
	MACDEMO1("jman2", "06/22/94 Demo", "Buried in Time Demo", "cdb27c916044ae4dceb4b7326063fa03", 328895, 400),
	MACDEMO1("jman2", "06/22/94 Demo 2", "xn--Buried in Time Demo-yp97h", "cdb27c916044ae4dceb4b7326063fa03", 329595, 400),
	MACDEMO1("jman2", "06/22/94 Demo 2", "xn--Buried in Time Demo-eo0l", "cdb27c916044ae4dceb4b7326063fa03", 329595, 400),
	MACDEMO1("jman2", "Final Demo", "Buried in Time Demo", "cc3321069072b90f091f220bba16e4d4", 292731, 400),
	MACDEMO1("jman2", "IMG Jun/95 Demo", "xn--Buried in Time Demo-eo0l", "ea646eccc9a53f44ce082459d4809a06", 494206, 404),
	MACDEMO1("jman2", "Gallery", "BIT Gallery", "01be45e7241194dad07938e7059b88e3", 484284, 400),
	MACDEMO1("jman2", "Overview", "BIT Overview", "01be45e7241194dad07938e7059b88e3", 484284, 400),
	MACDEMO1_l("jman2", "10/05/95 Demo", "B.I.T Demo PPC", "950744d1d93c7a137d66ab6fec146070", 60665, Common::JA_JPN, 404),
	WINDEMO1t_l("jman2", "10/02/95 Demo", "BITDEMO.EXE", "649a48ec679574c4df376c62e091f844", 727569, Common::JA_JPN, 404),

	// Windows version on the same disc is not Director
	MACGAME1("jmmd", "", "Just Me & My Dad", "ea646eccc9a53f44ce082459d4809a06", 486710, 400),

	// Bilingual English & Spanish
	MACGAME2("journey2life", "", "The Journey to Life", "bcd3c718db258701496b3c5bcb827ef2", 483518,
								 "MEDIA/INTRO.Dxr",		"429f9d51429671b2f9bdd44d33ffb6b2", 774408, 404),
	WINGAME2("journey2life", "", "LIFE.EXE",			"b23041f4f5cce3d15ef985bbd513030a", 756297,
								 "MEDIA/INTRO.Dxr",		"429f9d51429671b2f9bdd44d33ffb6b2", 774408, 404),

	PIPGAME1_l("junglepark", "", "JunglePark for Pippin", "dcf4cc0d9aa3cf8fa0c127cf72477af9", 60665, Common::JA_JPN, 404),
	MACGAME1_l("junglepark", "", "JunglePark for ppc", "fb8ad82e79d2c65872a48261c8aeaaac", 60665, Common::JA_JPN, 404),
	MACGAME1_l("junglepark", "Hybrid release", "JunglePark ppc", "af6f439598af8d750d8298c4e62ba88c", 60665, Common::JA_JPN, 404),
	WINGAME1t_l("junglepark", "Hybrid release", "JU_PARK.EXE", "f5357cf42fc929f98b4000015bf327db", 697087, Common::JA_JPN, 404),
	MACGAME1_l("junglepark", "", "Jungle Park PPC", "4730ce8bdd2ab17bf714da3ff7f3e510", 60884, Common::FR_FRA, 404),
	WINGAME2t_l("junglepark", "", "JUNGLE.EXE",		  "ce26af47699aa5a1c1948de7d81916f8", 742377,
								  "JUNGLE/TITLE.DXR", "3576dfffc2f643049f421ffb2087ddaa", 1405334, Common::FR_FRA, 404),

	// Original Taiwan release is called 塔克拉玛干—敦煌传奇 (Taklamakan: Dunhuang Chuanqi)
	MACGAME1("karma", "", "Karma", "ea646eccc9a53f44ce082459d4809a06", 485279, 404),
	WINGAME2("karma", "", "KARMA.EXE", "e830af6b5dfca4964184e7d61039e120", 697047,
						  "01_0Y.BIM", "246c2f5ab5499d46f395aa9d0da05c9a", 780158, 404),
	WINGAME1_l("karma", "", "DH.EXE", "f917ac9c649bff9eaf538ae69432a145", 690991, Common::ZH_TWN, 400),

	// Original Mac filename is かるたでおじゃる
	MACGAME1_l("karuta", "", "xn--t8jb4b0a4b1lzbf", "78138a77207907642744d0960c14d9e5", 486623, Common::JA_JPN, 404),
	WINGAME1t_l("karuta", "", "KARUTA.EXE", "2afac76249c458f5151ed0ed0ddadfe9", 746987, Common::JA_JPN, 404),
	// Original Mac filename is かるた
	MACDEMO1_l("karuta", "Demo", "Karuta",		 "78138a77207907642744d0960c14d9e5", 484567, Common::JA_JPN, 404),
	WINDEMO2_l("karuta", "Demo", "S.EXE",		 "aa3900a47af9c2b5f066fbbff43dd1f3", 746989,
								 "OPENING4.DIR", "89beafaa3b41f1c533d13fb378d5eebf", 3995204, Common::JA_JPN, 404),

	MACDEMO1_l("kenji", "Demo", "KENJI", "4577dd3eadc467a986ab172d90871b22", 502033, Common::JA_JPN, 404),

	WINGAME2("kfk", "", "KFK.EXE", 		"75a9f8838cd654701afdd50e68cf5736", 2696447,
						"KFKTHEME.MID", "ce462c95d4fcb85c6a967893937ed7be", 13033, 404),

	// Windows and Mac versions are D5
	PIPGAME1("kidsbox", "", "KIDS BOX", "bcd3c718db258701496b3c5bcb827ef2", 484095, 404),
	// Filename is 'キッズ・ボックス体験版', or 'Kids Box Trial Version'
	MACDEMO1_l("kidsbox", "Trial Version", "xn--ncke4ac8bb8onj201w4bzdvqte", "bcd3c718db258701496b3c5bcb827ef2", 484067, Common::JA_JPN, 404),
	// Decomposed variant
	MACDEMO1_l("kidsbox", "Trial Version", "xn--2bka2dk1cd9dd8swlt060aix7dzd6e", "bcd3c718db258701496b3c5bcb827ef2", 484067, Common::JA_JPN, 404),

	WINGAME1("kidtools", "", "DEMO.EXE", "da65c64d0821c0d689f8a3ead9301a2a", 15606953, 400),

	// Original Mac filename is Kinder-Kit™
	MACGAME1_l("kinderkit", "", "Kinder-Kit", "bcd3c718db258701496b3c5bcb827ef2", 483774, Common::PT_BRA, 404),
	WINGAME1_l("kinderkit", "", "KKIT.EXE", "a24a52bdb12d61eae64b9088b25ea03b", 862425, Common::PT_BRA, 404),

	// From Star Trek: Klingon (Disc 3)
	MACGAME1("klingonlab", "", "Klingon Language Lab/Klingon Language Lab", "b797956eb3a4dabcc15bfadf6fc66591", 481226, 404),
	WINGAME1("klingonlab", "", "TREK_WIN.EXE", "204417e63c0a2df18cf42d780b97ed58", 1425763, 400),

	WINGAME2("klondikegold", "", "KLONDIKE.EXE", "58a1d6965e1bc2a3281d1060e09f8d19", 908685,
								 "DREDGE.DIR",   "9b20cdc5ce0dffe165a495f94bb1b450", 4916524, 404),

	MACGAME1("korkydragons", "", "Dragons!", "0c7bbb4b24823e5ab871cb4c1d6f3710", 486726, 404),
	WINGAME1t("korkydragons", "", "DRAGONS!.EXE", "4d35a9f14ea5b012e552cd6b3a7e7452", 698833, 404),

	MACGAME1("kyoto", "v2.0", "Cosmology of KYOTO", "8719de9c083aca942fc0e5c0a127b6dc", 484114, 404),
	WINGAME2("kyoto", "", "PLAY_E.EXE",					  "84cc8880f8c46b4da121b4c9f184418a", 691269,
						  "CK_DATA/OPENING/ID_INPUT.DXR", "7c17a91e5b06471c11e3c6977040773a", 550062,  404),
	MACGAME1_l("kyoto", "v2.0", "Cosmology of KYOTO", "8719de9c083aca942fc0e5c0a127b6dc", 484189, Common::JA_JPN, 404),
	WINGAME2_l("kyoto", "", "PLAY.EXE",		"865b1b59e32e51a6670b9105ac8501ec", 741137,
							"OPENING1.DXR", "b96015c8c138c6626b10fffaed28efea", 679328, Common::JA_JPN, 404),

	MACGAME1("laughingbird", "", "The Laughing Bird Restaurant", "547553eca48ebc089e893ba1905c2b74", 673138, 404),

	WINGAME1t("learningcoreldraw3", "", "PROGRAM/LRNDRAW3.EXE", "aa6fa44a1161fe91f3be54ded6b53cbf", 1152788, 404),

	WINGAME2_l("leonardo", "", "LEO.EXE", "0be0b03b89bb4aba716a974c3ccc3950", 692347,
							   "LEOWINMV/INDEX.DIR", "f43523ae0244588c5a42656f54837b80", 201882, Common::PT_BRA, 404),

	WINDEMO2("letters", "Demo", "LETTERS.EXE", "ed0636bab94b299d96552e4c71bc82a1", 3875399,
								"CWLOGO.DIR",  "efb5c1918f5637bf9228ffc24f89ef72", 652996, 404),

	WINGAME1t("lifemysteries", "v1.01", "_SETUP/LGM/LGM.EXE", "c9ffbacdc78482eeaf644730a2fedc15", 1024075, 404),
	WINGAME1t("lifemysteries", "Demo", "LGMDEM.EXE", "dd13662fa71a413c2ba9228ea73e5448", 5539283, 404),

	// full game is DOS only, not Director
	MACDEMO1("lion", "Demo", "Lion Demo", "01be45e7241194dad07938e7059b88e3", 484284, 400),

	WINGAME1_l("lobomau", "", "LOBO.EXE", "162d4d1aaf42b6e8d7dfc520e5de2bed", 201828999, Common::PT_BRA, 400),

	MACGAME1("louiscatorze", "", "Louis Catorze", "2c7d0c0d55cbe3f622c7d68cedb671e0", 486698, 404),
	WINGAME2("louiscatorze", "", "LOUIS.EXE",		   "21610856ba0f75598624edd58291600b", 719433,
								 "LOUIS/V0ASTART.DIR", "65586336bda5bdc737c1ad420b0d403b", 2019106, 404),

	MACGAME1("louvre", "", "Louvre 5 Mo", "a685f1809706f42bff5f3ee94f606065", 483518, 404),
	WINGAME2("louvre", "", "LOUVRE.EXE",  "f575ed4b37c05ab4249f9d6d3c3d7e17", 698829,
						   "DATA/M1.DXR", "17648995fadc61c05dcf096190b33287", 4914344, 404),

	// From MacFormat #44
	MACGAME1("lovinghenry", "", "Loving Henry", "041f913ae9bfaebe53a238c14a7281e0", 291052, 403),

	// Win/Mac versions are D3
	PIPGAME1_l("lzone", "", "L-ZONE", "07c3095bd36e5aed00ba12f17f761070", 60096, Common::JA_JPN, 400),

	// Pre-rendered CG animated adventure based on the popular comedy manga
	// Developed by Future Pirates, published by Toshiba EMI
	MACGAME1_l("macaroni", "", "Macaroni.PowerMac", "be7faef1b5c713e2d13a693eb6e1f5c9", 180281, Common::JA_JPN, 404),

	// From CD Loisirs Nº6
	MACDEMO1("macbeth", "Demo", "Macbeth", "77f4098988d5386794d1530065f514cd", 301669, 400),

	MACDEMO1("macos8", "Tour", "Mac OS 8 Tour", "2332900b20b0d33e0617e5e7505923e8", 776072, 404),

	// Developed by MACRO-ARTS
	MACGAME1_l("macrotv", "", "PowerMAC(8M)", "b9e5259d0d603e23740f6e744cd842ab", 79749, Common::JA_JPN, 404),
	WINGAME1t_l("macrotv", "", "MACROTV.EXE", "e72b8bf0a6c8bb95b9e770139630ae91", 790607, Common::JA_JPN, 404),

	// Mac filenames contain n° instead of no
	MACGAME1_l("macsca", "Numéro 12", "Version Director no12", "7093a24634992bf9d23ff31ae1dea424", 284048, Common::FR_FRA, 404),

	WINDEMO2("madpup", "Demo 1", "MAD.EXE",			  "c135c843d7313da01272f061d2ab64b1", 4725743,
								 "SHARED/CWLOGO.DIR", "78025e16a47ae3826fc2221ced7f4acd", 653008, 404),
	WINDEMO1("madpup", "Demo 2", "MADPUP2.EXE", "a399589a31c26a01663c00a265ac3640", 696857, 404),

	WINDEMO1("madtg", "1996 Demo", "MADTG.EXE", "f53afbe0ae5126fa04adce4952a84b7f", 5867859, 404),

	// Original filename is Make•A•Mug™ V1.0
	MACGAME1("makeamug", "v1.0", "xn--MakeAMug V1.0-lt6gb312b", "4f8bb7ad0cbcec1815538ba15a899061", 304279, 400),

	// Original filename is 'メイキング ミュージック デモ'
	MACDEMO1_l("makingmusic", "Demo", "xn--  -mg4anble1dyesb5rraw7a1p9e", "0c7bbb4b24823e5ab871cb4c1d6f3710", 502657, Common::JA_JPN, 404),
	// Decomposed variant of the above filename
	MACDEMO1_l("makingmusic", "Demo", "xn--  -of4abb5d3cqd2fzgpb5ywa2a4b3r6f", "0c7bbb4b24823e5ab871cb4c1d6f3710", 502657, Common::JA_JPN, 404),

	MACGAME1("makers", "", "Makers of the 20th Century", "da0da5d543b237051975ad70bec129f4", 482610, 404),
	WINGAME2("makers", "", "MAKERS.EXE", "d879d7b40dd9f2eb59a2fbae5bc62306", 690883,
						   "MAKERS/MAIN.DIR", "05c3dff851aecbfeb1d3818404f3140c", 3391418, 404),

	// Original filename is 'ママ　うたおう！'
	MACGAME1_l("mamauta1", "", "xn--p6jvhap8h77aa78233b", "8b138db44d4421cc7294a9dc792ccf1b", 308012, Common::JA_JPN, 402),
	WINGAME1t_l("mamauta1", "", "MAMAUTA.EXE", "89106ff6f97699c9c6237bc65df3d042", 760057, Common::JA_JPN, 404),

	MACDEMO1_l("manhole", "Masterpiece Edition Demo", "The Manhole DEMO", "583a2d78dfcc184f2fbabfd3187322c1", 301861, Common::JA_JPN, 400),
	MACDEMO1_l("manhole", "Masterpiece Edition Demo", "The Manhole DEMO", "583a2d78dfcc184f2fbabfd3187322c1", 301669, Common::JA_JPN, 400),

	MACGAME1("marathonsecrets", "v1.0", "Marathon Secrets 1.0", "cdb27c916044ae4dceb4b7326063fa03", 301669, 400),

	// Windows version on same disc is D3
	MACGAME1("mask", "", "The Mask", "32a48ccef630fd453ac3501f72474545", 291308, 403),

	MACGAME2("mastermansion", "", "Masterpiece Mansion", "bdd793ba61c4333dfeaf976d6adc38fe", 285277,
								  "movs/carm.aif",		 "adbfaa083d5bc24c33f533298f2708ed", 965436, 404),
	WINGAME2("mastermansion", "", "MANSION.EXE", 	"b397657fec77654afc589000612de963", 84700821,
								  "MOVS/CARM.AIF",  "adbfaa083d5bc24c33f533298f2708ed", 965436, 404),
	WINDEMO1t("mastermansion", "Demo", "MANSION.EXE", "c641804b034e11abeaa289ca52c4b38c", 17866669, 404),
	MACGAME2("mastermansion", "Art Explorer", "Art Explorer",  "9e9696433d18629b88714089034c086b", 285253,
											  "movs/carm.aif", "adbfaa083d5bc24c33f533298f2708ed", 965436, 404),
	WINGAME2("mastermansion", "Art Explorer", "EXPLORER.EXE",  "7a335c6571e359b56453edb78e6fdc53", 36685767,
											  "MOVS/CARM.AIF", "adbfaa083d5bc24c33f533298f2708ed", 965436, 404),

	WINDEMO1t_l("mathmystery", "Demo", "LB_DEMO.EXE", "32f5a6d9ad00ece84526e1fe23965524", 698539, Common::NB_NOR, 404),

	MACGAME1("martian", "", "The Martian Chronicles PPC CD", "db9b7f11aea52a294d2986a94a184000", 60072, 404),
	WINGAME2t("martian", "", "MC.EXE",			 "55e0837d623be4218b317370abc5fc3b", 1764151,
							 "BUTTONS/MAIN.QTW", "06a9aab09811715e8ec2cc553c4bdcb4", 1391726, 404),

	MACDEMO1("mathblasterjr", "Preview v1.0c", "Math Blaster Jr. Power MAC", "602e61f10c158183218405dd30a09b3f", 60068, 404),
	// from Great Adventures by Fisher-Price: Castle (1995)
	MACDEMO1("mathblasterjr", "Preview v1.0c", "Math Blst Jr. Pwr Mac", "602e61f10c158183218405dd30a09b3f", 60068, 404),

	MACGAME1("mathtest", "", "mathtest (mac)", "cdb27c916044ae4dceb4b7326063fa03", 301925, 400),

	// German title is Max und die Geheimformel
	// German demo from CD ROM Hits 1995-10
	WINDEMO1t_l("max1", "Demo", "MAX1DEMO.EXE", "6805c5c8e800dd10648494421506b2f7", 700829, Common::DE_DEU, 404),
	MACDEMO1_l("max1", "Demo", "Max en de geheime... DEMO", "a2f5930615493c2358b2ad07e731c475", 502790, Common::NL_NLD, 404),
	WINDEMO1_l("max1", "Demo", "MAX1DMA.EXE", "b35d311e2982849c08379f2d74519d58", 752991, Common::NL_NLD, 404),

	// German demo from CD ROM Hits 1995-10
	WINDEMO1t_l("max2", "Demo", "MAX2DEMO.EXE", "e4a961e789ce970e3d23356d327b9f31", 700837, Common::DE_DEU, 404),
	MACDEMO1_l("max2", "Demo", "Max en Merel... DEMO", "a2f5930615493c2358b2ad07e731c475", 502790, Common::NL_NLD, 404),

	// Max und das Schloßgespenst (original) published by Tivola (1996)
	// Max en het gele-sokjes-spook published by Uitgeverij Bombilla, Amsterdam (1996)
	// Max et le château hanté published by E.M.M.E., Boulogne, Paris (2001)
	// Макс и привидения из замка localized by New Media Generation (NMG), Yakimanka, Moscow (1997)
	// English and usually German are always selectable languages during gameplay
	// Original Mac German filename is Max und das Schloßgespenst
	// Original Mac French filename is Max et le château hanté
	MACGAME1_l("max3", "", "Max und das Schlossgespenst",  "dd5bb78cb7db5c8fa7b87ddf3136b337", 504078, Common::DE_DEU, 404),
	MACGAME1_l("max3", "", "Max et le chateau hante",      "504e7e5b53a02dbebd3d19bf9a9b73d9", 504078, Common::FR_FRA, 404),
	MACGAME1_l("max3", "", "Max en het gele-sokjes-spook", "a2f5930615493c2358b2ad07e731c475", 502790, Common::NL_NLD, 404),
	WINGAME2_l("max3", "", "MAX3.EXE",      "aba98fa8042bb9f87dedf00be1d19de2", 702881,
						   "MAX/INTRO.DXR", "d24b1bf0650bf2be02da6b55bf045b2e", 3340376, Common::DE_DEU, 404),
	WINGAME1_l("max3", "", "M3_START.EXE", "99cc0c88814c402d8de01e8980582d65", 702863, Common::FR_FRA, 404),

	MACGAME1("maxissampler", "", "Maxis Power Mac CD-ROM Sampler", "01be45e7241194dad07938e7059b88e3", 483490, 404),
	WINGAME2t("maxissampler", "", "SAMPLER.EXE", "5d0ee796571b99d402a06438ae2f3d56", 696815,
								  "HOMECRE.DIR", "c01c5736dd1a49f52169c01e8d39a998", 1313276, 404),

	WINGAME1("mckenzie", "", "MCKFRAME.EXE", "581608fa7224b0b62e11e397d2aa76c1", 3217950, 404),
	WINDEMO1("mckenzie", "November 16 Demo", "MCKDEMO.EXE", "f2bc8c75f8df853780619583ba216beb", 8634631, 404),
	WINDEMO1t("mckenzie", "30 Megs Demo", "MCKDEMO.EXE", "7f524fed018d3455c0a9358b34543123", 7212177, 404),

	WINGAME1("mckenziemf", "", "MCKFRAME.EXE", "49c04e880f314a4965d21273df4f2dee", 4038355, 404),

	WINGAME1t("mcluhan", "", "MCLUHAN/MCLUHAN.EXE", "317d00bfea3c27688462f01bdd6ac2aa", 3587645, 404),
	MACGAME1("mcluhan", "", "McLuhan Folder/Understanding McLuhan", "f18e1cf6fb9fea099aae580c2057e551", 308558, 404),

	WINDEMO1t("mcmillennium", "Demo", "MILLDEMO.EXE", "028a149906ca490f8634e30c6b3c3957", 3630918, 404),

	// Full game is not Director
	WINDEMO1("mechwarrior2", "Demo", "MW2DEMO.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	// Original file name for v1.0 and v1.1 is Meet MediaBand™
	MACGAME2("mediaband", "v1.0", "xn--Meet MediaBand-yk6h", "17efee018a660458fae80de4364021ac", 483774,
								  "title", "88e717a623bc2690d84a1246e512eaff", 2646636, 404),
	MACGAME2("mediaband", "v1.1", "xn--Meet MediaBand-yk6h", "17efee018a660458fae80de4364021ac", 483774,
								  "title", "14a64b7999d909a23df7842cec65458c", 2752392, 404),
	MACGAME2("mediaband", "v4.2", "Meet MediaBand", "1682231de376e5465240f6e4a7952072", 291988,
								  "Main/Intro", "6f190b627f696ef29819c71682bd7057", 1055430, 403),
	WINGAME1t("mediaband", "v1.1", "MEDIABND.EXE", "c18c8e9dfd1101d86ab9e6d00b6c77fe", 717921, 404),

	// Projector is 4.0 Demo from Lingo Workshop
	MACDEMO1("mediabook", "Sampler", "MediaBook Sampler 16Mb", "78138a77207907642744d0960c14d9e5", 510450, 400),
	MACDEMO1("mediabook", "ToolBox Sampler", "ToolBox Sampler", "da61a96a720dbd5f987d86e9eb4b7a09", 302000, 400),

	// CD has audio tracks, unsure if called from game
	WINGAME2t("milo", "", "LAUNCHER.EXE", "09441c0931944d1cb3e3da72b59efc12", 721983,
						  "MILO.EXE", "4035595e298631d18e23dd377fa469c0", 704645, 400),
	WINGAME1("milo", "v2.02", "milo/milo.exe", "ade4937def30cb38c60f3ac737036577", 704645, 404),

	MACGAME1("mirage", "", "Mirage", "0c7bbb4b24823e5ab871cb4c1d6f3710", 486698, 404),
	WINGAME2("mirage", "", "MIRAGE.EXE", "2291ea234c14f1ccb8f2e67ae09bbfa3", 696867,
						   "SALOON.DXR", "907076196661a01bc709488945e3aa88", 4118090, 404),
	MACGAME2("mirage", "Making Of", "The Making of Mirage", "78138a77207907642744d0960c14d9e5", 486726,
									"MAKING.MOV",			"3d0bca691d8c8c9ca3c37633f4178006", 39280, 404),
	WINGAME2("mirage", "Making Of", "MAKINGOF.EXE", "2458926212e5589c013b7e7c28b9bee0", 698407,
									"MAKING.MOV",	"9ef43f401f119a913b3edfcde52de341", 53442432, 404),
	WINDEMO1t("mirage", "Demo", "MIRAGE.EXE", "83f5b8b60d480ac0d39a8356d9457c81", 1810139, 404),

	MACGAME1("mmiqtest", "", "Multimedia IQ Test", "7fd44b6dffa0ea0402eaed4c3769b39b", 285566, 404),
	WINGAME1("mmiqtest", "", "IQTEST.EXE", "2a788332a4d3af3e5c5f9fe230e6c89f", 740528, 404),

	MACGAME1("moag", "", "MacMoag", "46697df7ffee90bf7cd4c0cec4c54c28", 494808, 404),
	WINGAME1("moag", "", "WINMOAG.EXE", "3483a0e7c65996c4edce7f8c0c3c43e3", 726173, 404),

	// Original filename is もみの木の下で.予告編
	MACDEMO1_l("mominoki", "Demo", "Mominoki no shita de.Trailer", "0666ae690e459d3d0d91800ebd94de46", 290654, Common::JA_JPN, 402),

	MACGAME1_l("monja", "", "monja", "cd6695c8488c2ad352336af5afdcf5bd", 481803, Common::JA_JPN, 404),
	WINGAME1t_l("monja", "", "MONJA.EXE", "5bc2c8a824528ec4de0f8d8feb8f004e", 212008995, Common::JA_JPN, 404),

	MACGAME1_l("moritaka", "", "WATARASE-BASHI", "c761bfe3a0865ca0f43cb5556230ed5b", 107527, Common::JA_JPN, 404),
	PIPGAME1_l("moritaka", "", "Pippin Projector", "b708dcf9cdc19e6e186000ad93e41997", 73705, Common::JA_JPN, 404),

	// Full game is supported in SCI engine
	MACDEMO1("mothergoosehires", "Demo", "Mother Goose Demo", "77f4098988d5386794d1530065f514cd", 303933, 400),

	MACGAME1_l("moworld", "", "MO-World", "27519b873d23565470f627ad2f3d1b03", 321547, Common::JA_JPN, 400),

	MACGAME1_l("murphystv", "", "MURPHY", "8ea9e9a699c61edddffd79ddd0c994d7", 288162, Common::JA_JPN, 402),
	WINGAME2t_l("murphystv", "", "MURPHY.EXE",		  "8614c962ec56d95d8a0b602621661bcd", 742693,
								 "MAF_MAIN/OP_W.DIR", "3abaa54840ef29e069be8811dee5588c", 655758, Common::JA_JPN, 404),

	// Created by Fritsch & Friends MediaGroup, Babelsberg, Germany
	// Found on In´side MULTIMEDIA: Das Computermagazin mit CD-ROM 07/96 by Tronic Media World, Hesse, Germany
	WINGAME1_l("mrmore", "", "MRMORE.EXE", "8273050f0eccbd62542225bc92fc6ad3", 689995, Common::DE_DEU, 404),

	// Both versions require installation to extract executables
	MACGAME1("mrsquack", "", "Reading with Peter Cottontail", "97474208c44c78f26bef8b2011d341aa", 483708, 404),
	WINGAME1("mrsquack", "", "QUACK.EXE", "5f80de56cd9c653721b451b752189264", 763381, 404),

	// Original filename 'ＭＳ制服図鑑でも'
	MACDEMO1_l("msseifuku", "Demo", "xn--n9juc805lw7d3myt85ddl2inba", "8ea9e9a699c61edddffd79ddd0c994d7", 289490, Common::JA_JPN, 402),
	// Alternate decomposed filename format
	MACDEMO1_l("msseifuku", "Demo", "xn--m9jwc6c242pk7ev40awn6eywzjtba", "8ea9e9a699c61edddffd79ddd0c994d7", 289490, Common::JA_JPN, 402),

	// Demos from Microsoft Exposition CD
	WINDEMO1("ms500nations",   "Demo",			  "500NAT.EXE",	  "d74e6aa33e11561a38eb82dd52b91613", 2284149, 404),
	WINDEMO1("msaccess",	   "Windows 95 Demo", "ACDEMO.EXE",	  "ea5d410e9d0e3f2160d1d43364a8ae24", 1979227, 404),
	WINDEMO1("msautomap",	   "Demo",			  "MARA.EXE",	  "b7850776d9e103e4ad4c2de6b4237226", 8317329, 400),
	WINDEMO1("msbaseball",	   "1995 Demo",		  "COMPBASE.EXE", "9b46c1cb673ff60b97a5468cc9cf833c", 4602907, 404),
	WINDEMO1("msbasketball",   "1995 Demo",		  "COMPBASK.EXE", "a600b567ae40200f94b1cb5d32f7fce6", 5280287, 404),
	WINDEMO1("msbob",		   "Demo",			  "BOBDEMO.EXE",  "e975ae22434e98a910549e8a160a08a3", 3083061, 400),
	WINDEMO1("msbhumanbody",   "1995 Demo",		  "HUMAN.EXE",	  "c88694c3fe8da8b6fc86b9bd4214e568", 1153901, 404),
	WINDEMO1("msbsolarsystem", "1995 Demo",		  "SOLAR.EXE",	  "0b4ee6125ef4c2dbe32854f69e2240d0", 1176537, 404),
	WINDEMO1("msdogs",		   "Demo",			  "DOGSDEMO.EXE", "0735a8ad4b4e09b6575afbe301946260", 4490505, 404),
	WINDEMO1("msexcel",		   "Demo",			  "EXDEMO.EXE",	  "3971666400faf88a1d0b91b93122bdc8", 2514951, 404),
	WINDEMO1("msgolf",		   "1995 Demo",		  "GOLFDEMO.EXE", "3cf38257dcbd44ff89a2e0deba601428", 3687453, 404),
	WINDEMO1("msmouse",		   "1995 Demo",		  "MOUSE2OH.EXE", "fe9401c1a9bf87ca9b246cae7ddace19", 4278473, 400),
	WINDEMO1("msmouseh",	   "1995 Demo",		  "HMOUSE.EXE",	  "53f18ec3c4984be4b36b67322df662c8", 3560439, 400),
	WINDEMO1("msnatkey",	   "1995 Demo",		  "KEYBDDEM.EXE", "ab38b5fb4c2c5f8cb61a55bde3328c78", 8368681, 400),
	WINDEMO1("msoceans",	   "Demo",			  "OCNSDEMO.EXE", "1086dc080877b260479a322830652e34", 4771371, 404),

	// Earlier Win demo is text only. Multimedia demo created by The HyperMedia Group of Emeryville, CA
	MACDEMO1("msoffice", "v4.2 Demo", "Microsoft Office 4.2 Complete", "22815cf659b911c4e07d0015cac5d98f", 304189, 400),
	WINDEMO1("msoffice", "Windows 95 Demo", "OFC95DEM.EXE", "3a3b86311ea93318c00e615910c9b9af", 2278071, 404),
	WINDEMO1("msoffice", "HyperMedia Demo", "OFFICE.EXE",	"6d3a440ed39ea166bc709941d1ac4d1e", 2259121, 404),
	WINDEMO1t_l("msoffice", "HyperMedia Demo", "GERMOFC.EXE", "e78e12d833531484399680158e141f8e", 2562727, Common::DE_DEU, 404),
	// JP version created by The HyperMedia Group, produced by S.I.P. Corporation
	WINDEMO1t_l("msoffice", "HyperMedia Demo", "START.EXE", "09cc52110abd047f4fa78280f550e0bf", 742563, Common::JA_JPN, 404),
	// Found on PC Review disc 17, demo created by Pub Pow Inc.
	WINDEMO1t("msoffice", "Professional for Windows 95 Demo", "OFC95DEM.EXE", "cfbf1f3af1520d2af001399ffd01af6d", 2278779, 404),

	WINDEMO2("mspowerpoint",		"Demo", "PPDEMO.EXE",	"8c49e85fe392cc16bfaaa4e4f5f3b38f", 2382163,
											"PPMENU.DIR",	"9af214d29ea0db2bc1cda9263b7adade", 1802184, 404),
	WINDEMO1("msproject",			"Demo",	"PROJDEMO.EXE", "01d88edc91499189f59467d32a0c27b2", 692401, 404),
	WINDEMO1("mspublish",	   "1995 Demo",	"PUBDEMO.EXE",  "6803a5c6453a680538e7fc15507be0bd", 2760365, 400),
	WINDEMO1("msschedule",			"Demo", "SCDEMO.EXE",	"3490bdb0957fed1ef43b09f774720ce2", 2595817, 404),
	WINDEMO1("mswine",				"Demo", "WINEDEMO.EXE",	"c84dcde32949946851630de98c6c9aa7", 2048505, 404),
	WINDEMO1("msword",	 "Windows 95 Demo", "WDDEMO.EXE",	"978b912f4d83feefbc2a72e19bf63539", 2408327, 404),
	WINDEMO1("msworks",				"Demo", "WORKS.EXE",	"2f28c708b365ab1b7f8ae511bf515a33", 5021281, 400),

	// Original filename is 日本昔話
	MACDEMO1_l("mukashibanashi", "Demo", "Nihon Mukashi Banashi", "8ea9e9a699c61edddffd79ddd0c994d7", 290654, Common::JA_JPN, 402),

	// The main entry executable on the disc root isn't Director
	MACGAME1_l("multiakindo", "", "DATA/MA for Mac", "0c7bbb4b24823e5ab871cb4c1d6f3710", 481803, Common::JA_JPN, 404),

	// Both Mac and Win versions require installation to extract executable and some data files
	MACGAME1("mummy", "", "MUMMY", "01be45e7241194dad07938e7059b88e3", 503304, 404),
	WINGAME2("mummy", "", "MUMMY.EXE",		  "2ebe3a4ef8c128db46794333d4b61c36", 2939630,
						  "MUSIC/INTRO1.MOV", "a7df6b011014719d3fbc9c5f1af18f3b", 1919338, 404),

	// Demo for a game that is detected in mTropolis engine
	WINDEMO1("mti", "Demo", "MUPPETS/MUPPETS.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	MACDEMO1("multimediastudio", "Demo", "Cartoon Studio", "9414302660bf6b78d3866199d3476128", 288891, 403),

	// English version is D3
	MACGAME2_l("murdertaylor", "", "Taylor French", "dc839fb9e2f8e6bfc4f4f995c57df495", 291427,
								   "S4.dir",		"b5547cc66a7eb4820805eaa48e43717c", 924798, Common::DE_DEU, 404),
	WINGAME2_l("murdertaylor", "", "TF.EXE",		"d7a97fbe1daf2bc5fdecee2725c297cd", 952741,
								   "S4.DIR",		"b5547cc66a7eb4820805eaa48e43717c", 924798, Common::DE_DEU, 404),
	WINGAME1_l("murdertaylor", "", "JOURNA.EXE",	"e6504ba65562c9950806c0dd395e3adb", 688299, Common::KO_KOR, 400),

	WINDEMO1("musiccentral96", "Demo", "MC96DEMO.EXE", "6b30dbea5949e64edd66427290b0fd8c", 690031, 404),

	WINGAME1("mylk", "", "mylk.exe", "032b0860a694ece5f64f37cfe1ebdfa0", 904859, 400),

	MACGAME1("mysteriousegypt", "",   "Mysterious Egypt",		   "32cb3a881f2d47a7e525370b198b2c5c", 483746, 404),
	MACGAME1_l("mysteriousegypt", "", "Matka muinaiseen Egyptiin", "17efee018a660458fae80de4364021ac", 483774, Common::FI_FIN, 404),
	WINGAME1_l("mysteriousegypt", "", "EGYPTI.EXE",				   "8bdf5baaa1fd82daf59fe0a96d356530", 1295295, Common::FI_FIN, 404),
	MACDEMO1_l("mysteriousegypt", "Demo", "Egypti demo", "337c94c66b435e075a2d7f94b3cffc49", 483746, Common::FI_FIN, 404),
	WINDEMO1_l("mysteriousegypt", "Demo", "EGYPTI.EXE",	 "2e8cba31e473bd1567476f57d6aeb4d6", 5574413, Common::FI_FIN, 404),

	MACGAME1("myworld", "", "Me & My World", "bda8fd92e5483a1fa311e9fc68e355fe", 295773, 404),
	WINGAME1t("myworld", "", "MYWORLD.EXE", "c1be044a34660346d843cf51faca4604", 2138764, 404),

	// Windows demo is from PC Gamer (US) demo disc #10 - Sep 1995
	MACGAME1("necrobius", "Beta", "MAC_APPS/NCROBIUS.PPC", "345463782e71ed33885925d258fe566f", 60096, 404),
	WINGAME1t("necrobius", "Beta", "WIN_APPS/N_BIUS.EXE", "c1b8ced1a94efcbaa86bdf12f28a0097", 692919, 404),
	WINDEMO1("necrobius", "Demo", "N_BIUS.EXE", "d17330706956c2fda3ee482b39b0609f", 705049, 400),

	MACGAME1_l("negi1", "", "Power", "1e817476c1d58b61cc74a08d685460fd", 100069, Common::JA_JPN, 404),
	WINGAME1t_l("negi1", "", "NEGI.EXE", "295224cdc826db343629e7741f5163af", 751189, Common::JA_JPN, 400),

	// Rest of screensavers are D5
	MACGAME1("nekojiruudonss", "Ashi", "ASHI", "bc1822fcc8cf27e2ffb1028c691fb06d", 395020, 402),
	MACGAME1("nekojiruudonss", "Chin", "CHIN", "bc1822fcc8cf27e2ffb1028c691fb06d", 395020, 402),
	MACGAME1("nekojiruudonss", "Doga", "DOGA", "bc1822fcc8cf27e2ffb1028c691fb06d", 395020, 402),
	MACGAME1("nekojiruudonss", "Guruguru", "GURUGURU", "bc1822fcc8cf27e2ffb1028c691fb06d", 395020, 402),
	MACGAME1("nekojiruudonss", "Nezumi", "NEZUMI", "bc1822fcc8cf27e2ffb1028c691fb06d", 395020, 402),
	MACGAME1("nekojiruudonss", "Zikansa", "ZIKANSA", "bc1822fcc8cf27e2ffb1028c691fb06d", 395020, 402),

	// Main app isn't Director.
	// Original filename 'Nendo デモムービー'
	MACDEMO1_l("nendo", "Demo Movie", "xn--Nendo -8v4emd6eta10ab", "bcd3c718db258701496b3c5bcb827ef2", 481803, Common::JA_JPN, 404),
	// decomposed version of the filename above
	MACDEMO1_l("nendo", "Demo Movie", "xn--Nendo -1m4ea71b5dvgxa35ac", "bcd3c718db258701496b3c5bcb827ef2", 481803, Common::JA_JPN, 404),

	MACGAME1("netmaze", "v1.1", "Netmaze 1.1", "ea646eccc9a53f44ce082459d4809a06", 483518, 404),

	WINDEMO1("newslinks", "Demo", "NEWS.EXE", "22900fa6922d71b1f880aa3cc0bbad1a", 16526563, 404),

	// Published by Corel CD Home. Later released as Nikolai's Knights.
	// Original Mac filename is In the Time of the Knights™
	MACGAME2("nikolaiknights", "Corel", "xn--In the Time of the Knights-jf8p", "da0da5d543b237051975ad70bec129f4", 488222,
										"1_TIME.DXR", "75d8d359ae371ba60967177e8f3ce48b", 1720524, 404),
	WINGAME2("nikolaiknights", "Corel", "KNIGHTS.EXE", "5ab667a256a0c334e9adca78564dbc5d", 740436,
										"1_TIME.DXR", "75d8d359ae371ba60967177e8f3ce48b", 1720524, 404),

	// Later released as Nikolai's Toys
	// Original Mac filename is NN’nN Toy Makers™
	MACGAME1("nikolaitoys", "", "NNNN/xn--NNnN Toy Makers-5w9hs4m", "2c7d0c0d55cbe3f622c7d68cedb671e0", 486770, 404),
	WINGAME1("nikolaitoys", "", "NNNN/NNN_TOYS.EXE", "22147e4c6311f670f72d43f8b793169e", 3206640, 404),

	MACDEMO1("nightsky", "Sampler", "Night Sky Interactive Sampler", "cbce20666bfe47a9533331c6be1e6039", 285269, 400),
	WINDEMO1("nightsky", "Sampler", "NIGHTSKY.EXE", "68f1fe67a5881fd47b08e905401d174c", 4300149, 404),

	// Original filename is Visual日本地理DEMO
	MACDEMO1_l("nihonchiri", "Demo", "Visual Nihon Chiri DEMO", "8b138db44d4421cc7294a9dc792ccf1b", 306940, Common::JA_JPN, 402),

	MACGAME1("nile", "", "Nile Passage to Egypt", "9765ad17bce6a2b40dd7f48377e82436", 512734, 404),
	WINGAME2("nile", "", "NILE.EXE",	 "9b00cbba14f0a2e0445784ebacf62c78", 2846777,
						 "NILEGO23.DIR", "1a306c36ff503a93bde94252acc24ea6", 2259356, 404),

	// Full game is D5
	WINDEMO1("nine", "Demo", "NINEDEMO.EXE", "d7596e7f6e8bc7c95d4217ff431a2f02", 711181, 404),

	// Demo executable name is ににんがしデモ
	// Full version executable name is ににんがし
	// There are also projectors to play audio in 11kHz or for systems with 4MB RAM
	MACGAME1_l("niningashi", "",	 "Niningashi",		"0666ae690e459d3d0d91800ebd94de46", 290682, Common::JA_JPN, 402),
	MACDEMO1_l("niningashi", "Demo", "Niningashi Demo", "0666ae690e459d3d0d91800ebd94de46", 290682, Common::JA_JPN, 402),
	WINDEMO2_l("niningashi", "Demo", "S.EXE",			"0c8a24a885123f20992c0c74d8c5062c", 768683,
									 "MAIN.DXR",		"8af3de22d679eb4e192429ca682bb974", 1119286, Common::JA_JPN, 404),

	WINDEMO2t("nixon", "Demo", "NIXON.EXE",  "2136d259b08bff165dea5085938abd12", 3193595,
							   "WATERGAT.E", "2ac9de0cd93580da85993f842eed8417", 3106294, 404),

	// Pregnancy demo is from ADAM v1.11 for Mac and NMM v1.0
	// Windows demo from Life's Greatest Mysteries v1.01
	MACGAME2("nmm", "",		"Nine Month Miracle 1.0/ADAM Resources/Adam Player.ppc", "df028c9e22b2dec8f7ffeee28ca7b991", 57470,
							"_A.D.A.M. Data/Fetus Images",							 "9aaef35beea323a4d1c714c32163c143", 563806, 404),
	MACDEMO1("nmm", "Demo", "NMM Demo", "17efee018a660458fae80de4364021ac", 481226, 404),
	WINDEMO1t("nmm", "Demo", "NMMDEMO.EXE", "69404c5a228259b44356f1eb477317d2", 7622823, 404),

	MACDEMO2_l("noahsark", "Demo", "GO", "97474208c44c78f26bef8b2011d341aa", 484067,
								   "NOADATA/NOAm16h.dxr", "5ff168be3f36b3c7c1a27e0ba92af80a", 4313024, Common::JA_JPN, 404),
	WINDEMO2t_l("noahsark", "Demo", "GO.EXE", "bf8926c2275b8e83f237812a18964dbd", 747005,
									"NOADATA/NOAW08H.DXR", "c66f86fe178c6a0bb9c5165202c0f8c3", 2991026, Common::JA_JPN, 404),

	WINGAME1("noddytoytown", "", "MNWG/NODDY.EXE", "d16d57c823205e32759e1771bfdbb330", 4505770, 404),

	WINDEMO1("noir", "Demo", "NOIRDEMO.EXE", "a9690aa58c6da36b7a6bf88fd4c81ffc", 10949309, 404),

	// Original filename is Nomis™ PPC
	MACGAME1("nomis", "", "Nomis PPC", "6dd87d48277cf2cd886e5168266ce4bf", 58051, 403),

	MACDEMO1("nurseryrhymes", "Sampler", "Nursery Rhymes Sampler", "cbce20666bfe47a9533331c6be1e6039", 285273, 400),
	WINDEMO1("nurseryrhymes", "Sampler", "NURSERY.EXE", "c7cca77d8c1c88e8003db72abb05da0a", 4518423, 404),

	WINDEMO1("nyack", "Demo", "NYACKDEM.EXE", "8902ed0bcaf2d78151f819ba41eaf124", 720431, 404),

	// From CD Loisirs Nº6
	MACDEMO1("onevolution", "Demo", "Stephen Jay Gould", "77f4098988d5386794d1530065f514cd", 301669, 400),

	WINGAME1("operafatal", "",	 "OPERA.EXE",		 "2b9da5566698a1f4b453e1a27e00ad29", 697739, 400),
	MACGAME2("operafatal", "",	 "OPERA FATAL",		 "f5033f237ad1b1639fc46d01a82ac380", 285310,
								 "Opera/SPRINT.Dxr", "3e86f01eeac5fa3349c5177378997a7f", 694912, 400),
	MACGAME2_l("operafatal", "", "OPERA FATAL",		 "f5033f237ad1b1639fc46d01a82ac380", 285310,
								 "Opera/SPRINT.Dxr", "3eb6f5568c9ced258059e2cfd30751c5", 479616, Common::IT_ITA, 400),
	// From bugreport #13466
	// Windows version is identical to regular Windows version
	MACGAME2("operafatal", "Hybrid release", "OPERA FATAL",		 "f5033f237ad1b1639fc46d01a82ac380", 285310,
											 "Opera/SPRINT.Dxr", "26c83c0cac1d40e91487e3a142d29733", 479390, 404),

	MACDEMO1("orgotto", "Demo", "ORGOTTO", "0c7bbb4b24823e5ab871cb4c1d6f3710", 484351, 404),
	WINDEMO1("orgotto", "Demo", "ORGOTTO.EXE", "f9272ef143c610ebd4dcb8301aa9b678", 760137, 404),

	// Found on PC Gamer (US) demo discs #1,3,4,6
	// V10 found on Czech Super Hry III (FMI)
	// V7 (alt) found on PC Review, Issue 38 (December 1994)
	WINGAME1("origin", "V6",  "CATALOG.EXE", "31ccde4688ffea57022b05d467bad4ed", 8844619, 400),
	WINGAME1("origin", "V7",  "CAT_WOG.EXE", "4753368b2fd973e18b5917b1f43bb29b", 9337013, 400),
	WINGAME1t("origin", "V7",  "CATALOG.EXE", "40ba0c1bf02701fbe6ed12011b487082", 8498835, 400),
	WINGAME1("origin", "V8",  "CATALOG.EXE", "e6fe968cbe2b51ea423af58216c78392", 9509999, 400),
	WINGAME1("origin", "V10", "CATALOG.EXE", "7cff9d0feac9240a93dbd442f556e6d5", 9509767, 400),
	WINGAME1t("origin", "V11", "CATALOG.EXE", "204be6f83ddff4b59834645ae33cb923", 10347633, 400),
	WINGAME1("origin", "Fall 95", "CATALOG.EXE", "7d68d0cada5849c3732e5b87ee26a4c8", 9990989, 404),

	WINGAME1_l("osaka1", "",	 "OSAKA.EXE", "c0479277618ab17bd9c79b5da66ab435", 1491097, Common::JA_JPN, 400),
	WINDEMO2_l("osaka1", "Demo", "DEMO.EXE",  "763f360a098cf3bec7cbdc5685b1e4a3", 1193483,
								 "START.DIR", "83190aa4c2db873334d36bac329ec670", 825036, Common::JA_JPN, 404),
	MACDEMO2_l("osaka1", "Demo", "DEMO",	  "5a012e69fec2369ad2e8d73c42d928f3", 1096269,
								 "START.DIR", "8b82c58788768cfa88115217de4e8995", 825192, Common::JA_JPN, 404),

	MACGAME1("oslotg", "", "OSLO's T&G", "ef59432e7b24df951cb7096cfd45d168", 307427, 400),
	WINGAME1("oslotg", "", "OSLOTG.EXE", "c4be18eb4f16e3e21df22d0703866900", 995939, 400),

	WINGAME1("painters", "", "PAINTERS.EXE", "3cba94b585493ef5f22d0d650b6eb7fd", 895727, 404),
	MACGAME1("painters", "", "Painters Painting", "0a81aee4106eec4ffc0cc564a7c15a23", 288774, 404),

	MACGAME1_l("panicook", "", "Panicook", "bcd3c718db258701496b3c5bcb827ef2", 484095, Common::JA_JPN, 404),
	WINGAME1t_l("panicook", "", "PANICOOK.EXE", "50c3a90ab98c6c048014c27de116cdfd", 123273637, Common::JA_JPN, 404),
	MACDEMO1_l("panicook", "Demo", "Panicook Demo", "bcd3c718db258701496b3c5bcb827ef2", 484095, Common::JA_JPN, 404),
	WINDEMO1t_l("panicook", "Demo", "PANIDEMO.EXE", "90fefc4f81483cbe9aa06e98a7c3afff", 15573239, Common::JA_JPN, 404),

	// Full version isn't Director
	// Found on Electronic Entertainment CD-ROM Sampler Disc (December 1995)
	WINDEMO1t("panicpark", "Demo", "PANIC!.EXE", "171360aac3ee8ebbb1eee36cebe703f2", 2013371, 404),
	// Found on The Best of Select: Games Special 4, batch file is the only other file in the folder
	WINDEMO2t("panicpark", "Demo", "PANIC.EXE", "9d0fe435d9becfcc67f7c25ad1f88102", 2370615,
								   "GOWIN.BAT", "206e3ef43a49e92cda0727a3ba870dc5", 10, 404),

	// Developed by Museworthy
	MACGAME1("paparazzi", "", "MUSEWTHY/Paparazzi!", "0c7bbb4b24823e5ab871cb4c1d6f3710", 482610, 404),
	WINGAME1t("paparazzi", "", "PPRAZZI.EXE", "2b0ea9256d85425a2a31e4bdf0ba3aa9", 5331351, 400),

	// Windows version isn't Director
	// Demo from CD Loisirs Nº6
	MACGAME2("paperplanes", "", "Paper Planes", "cdb27c916044ae4dceb4b7326063fa03", 303933,
								"Demo", "e704dc2489f81643aa7717105004bc9d", 1777750, 400),
	MACDEMO2("paperplanes", "Demo", "Paper Planes", "cdb27c916044ae4dceb4b7326063fa03", 303933,
									"Demo", "edceb9d0a3b4726dca10f8a825e20fee", 1895406, 400),

	// Full version is bilingual. Demo is French only.
	// Demo found on EMME Keys to Knowledge sampler CD
	MACGAME1("paris", "",		"PARIS History & Splendour", "1c2e5371b835680e7c1ca8bcea008bef", 482838, 404),
	WINGAME1("paris", "",		"PARISPC.EXE",	"efff9526abac439e895005efb07499cb", 234012595, 404),
	MACDEMO1_l("paris", "Demo", "DEMO PARIS INFO LINK-EMME", "1c2e5371b835680e7c1ca8bcea008bef", 482838, Common::FR_FRA, 404),
	WINDEMO1_l("paris", "Demo", "DPARISPC.EXE", "875af2a4007c6ec11939ca0cc1f380d5", 719579, Common::FR_FRA, 404),

	// All four languages found on Apple Europe Edition CD
	MACGAME1("parisvt",	  "", "Virtual Tourism PARIS (E)", "a8e65a2268226bd59f12ebdc58a221f3", 483746, 404),
	MACGAME1_l("parisvt", "", "Virtual Tourism PARIS (D)", "a8e65a2268226bd59f12ebdc58a221f3", 483746, Common::DE_DEU, 404),
	MACGAME1_l("parisvt", "", "Virtual Tourism PARIS (F)", "a8e65a2268226bd59f12ebdc58a221f3", 483746, Common::FR_FRA, 404),
	MACGAME1_l("parisvt", "", "Virtual Tourism PARIS (I)", "a8e65a2268226bd59f12ebdc58a221f3", 483746, Common::IT_ITA, 404),

	// Original filename is 'ぱそすけPPC'
	MACGAME1_l("pasosuke", "", "xn--PPC-873bpbxa3l", "6822defa470ade9836e0d90f365a035c", 58401, Common::JA_JPN, 404),
	WINGAME1_l("pasosuke", "", "PASOSUKE.EXE", "81c32e386efd5b68848dacc0a24e8736", 746803, Common::JA_JPN, 404),

	MACGAME1("paws", "", "Start the Dog!", "af8fad5423f5416fe7743198e3909294", 325061, 404),
	MACDEMO1("paws", "Making of", "The Making of P.A.W.S", "a55b1e9e9d04a2234189a6bcfbe69e4c", 295404, 404),
	WINGAME1("paws", "", "PAWS_HD/STARTDOG.EXE", "5c9a56c88b4bb8732377f93f62a885a4", 818961, 404),
	WINDEMO1("paws", "Making of", "MAKEPAWS.EXE", "559f4c728a348c18b96cddaf102e3413", 874293, 404),

	WINDEMO1("pbbear", "Sampler", "PBBEAR.EXE", "dc58e6e06807f4a4a4cc278f8748659f", 696807, 404),

	MACGAME1("pecosbill", "", "Pecos Bill", "67f572196550aedb1f9523d782022be0", 483500, 404),
	WINGAME1("pecosbill", "", "PECOS.EXE", "948eb8995faf757e4ad899ea45b3fae7", 700035, 404),

	MACGAME1_l("peepeebonbon", "", "PPBB.MAC", "33f733b2809b94c3301096902f642b6e", 289518, Common::JA_JPN, 402),
	WINGAME1t_l("peepeebonbon", "", "PPBB.EXE", "ccfe8e10528261b78f4a8c9657a54ff8", 746983, Common::JA_JPN, 404),

	MACGAME1_l("planetdob", "", "Planet Dob", "01be45e7241194dad07938e7059b88e3", 484095, Common::JA_JPN, 404),

	MACGAME1_l("please", "", "PLEASE!", "8ea9e9a699c61edddffd79ddd0c994d7", 290006, Common::JA_JPN, 402),

	MACGAME1_l("pod1", "", "POD1MAC", "8ea9e9a699c61edddffd79ddd0c994d7", 309132, Common::JA_JPN, 400),
	WINGAME1t_l("pod1", "", "POD1WIN.EXE", "af356f6331ffd615a1a1954b9338d8f1", 690987, Common::JA_JPN, 404),

	MACGAME1_l("pod3", "", "POD3MAC", "e6833f1ce3b022f0128e4c80a55bcd46", 311035, Common::JA_JPN, 404),
	WINGAME1t_l("pod3", "", "POD3WIN.EXE", "771fcc769bdeea7887087e662e2c3430", 741859, Common::JA_JPN, 404),

	MACGAME1_l("pod4", "", "POD4MAC", "b727e823af7807a4ccfd3575b85a902f", 315394, Common::JA_JPN, 404),
	WINGAME1t_l("pod4", "", "POD4WIN.EXE", "e7b938cb64222c6fc6d3161d54d73dbc", 746971, Common::JA_JPN, 404),

	MACGAME1_l("pod5", "", "POD5 for MAC", "8ea9e9a699c61edddffd79ddd0c994d7", 315394, Common::JA_JPN, 404),
	WINGAME1t_l("pod5", "", "POD5WIN.EXE", "771fcc769bdeea7887087e662e2c3430", 741859, Common::JA_JPN, 404),

	MACGAME1_l("pod6", "", "POD6 for Macintosh", "e6833f1ce3b022f0128e4c80a55bcd46", 311035, Common::JA_JPN, 404),
	WINGAME1t_l("pod6", "", "POD6WIN.EXE", "771fcc769bdeea7887087e662e2c3430", 741859, Common::JA_JPN, 404),

	MACGAME1_l("pod7", "", "POD7 for Macintosh", "e6833f1ce3b022f0128e4c80a55bcd46", 311035, Common::JA_JPN, 404),
	WINGAME1t_l("pod7", "", "POD7WIN.EXE", "771fcc769bdeea7887087e662e2c3430", 741859, Common::JA_JPN, 404),

	MACGAME1_l("pod8", "", "POD8 For Macintosh", "e6833f1ce3b022f0128e4c80a55bcd46", 311035, Common::JA_JPN, 404),
	WINGAME1t_l("pod8", "", "POD8WIN.EXE", "771fcc769bdeea7887087e662e2c3430", 741859, Common::JA_JPN, 404),

	MACGAME1_l("pod9", "", "POD9 For Macintsosh", "8ea9e9a699c61edddffd79ddd0c994d7", 315394, Common::JA_JPN, 404),
	WINGAME1t_l("pod9", "", "POD9WIN.EXE", "771fcc769bdeea7887087e662e2c3430", 741859, Common::JA_JPN, 404),

	MACGAME1_l("petepilotti1", "",	   "Seikkailu Lapponiassa", "a8e65a2268226bd59f12ebdc58a221f3", 483746, Common::FI_FIN, 404),
	MACDEMO1_l("petepilotti1", "Demo", "Pete Pilotin esittely", "0c7bbb4b24823e5ab871cb4c1d6f3710", 483746, Common::FI_FIN, 404),
	WINGAME1_l("petepilotti1", "",	   "PETE.EXE",	   "4d4637a93653ece18e7d1238cc52a111", 1295281, Common::FI_FIN, 404),
	WINDEMO1_l("petepilotti1", "Demo", "PETEDEMO.EXE", "fd8a1586ac3e8e95746b31e0c9daf767", 8772665, Common::FI_FIN, 404),

	// Mac version requires hard drive installation
	// Choice of American or British English by selecting Language = 0 or 1 in PETER.INI
	MACGAME1("peterrabbit", "", "Peter Rabbit (PowerMac)", "fd5cf6efd07077a06519145fc3700e63", 62616, 404),

	// These tile puzzles are identical except for the image
	MACGAME1("pfarrypuzzle", "Flower", "Flower Puzzle", "cdb27c916044ae4dceb4b7326063fa03", 303940, 400),
	MACGAME1("pfarrypuzzle", "Iris", "Iris Puzzle", "cdb27c916044ae4dceb4b7326063fa03", 303940, 400),
	MACGAME1("pfarrypuzzle", "Lighthouse", "Lighthouse Puzzle", "cdb27c916044ae4dceb4b7326063fa03", 303940, 400),
	MACGAME1("pfarrypuzzle", "Old Camera", "Old Camera Puzzle", "cdb27c916044ae4dceb4b7326063fa03", 303940, 400),
	MACGAME1("pfarrypuzzle", "Sunflower", "Sunflower Puzzle", "cdb27c916044ae4dceb4b7326063fa03", 303940, 400),

	MACDEMO1_l("phantplanet", "Demo", "PHANTASMAGORIA demo", "dc5a87dda7a0daf46604515f7d2cca66", 291960, Common::JA_JPN, 403),
	WINDEMO1t_l("phantplanet", "Demo", "PHANDEMO.EXE", "56dc12f841f627be652d23e457875f61", 692923, Common::JA_JPN, 404),
	MACGAME1_l("phantplanet", "Hybrid release", "phantasmagoria_PPC", "602e61f10c158183218405dd30a09b3f", 60096, Common::JA_JPN, 404),
	WINGAME1_l("phantplanet", "Hybrid release", "PHANTAS.EXE", "c2dd62dd0f9488ae8102970553eff170", 690449, Common::JA_JPN, 400),
	// Under the working title 'Micromondo'
	MACDEMO1("phantplanet", "Demo", "MICROMONDO Demo", "8f597c0dc7a7f0d1d1e0b85404c62c1e", 286152, 404),
	WINDEMO1t("phantplanet", "Demo", "MICRO.EXE", "ce31b9d507cb6355f8f8018f081671df", 744320, 404),

	MACDEMO1("photos4us", "Demo", "Photos4us", "2c27791a84756be6201d281bad54f7bb", 351560, 404),

	// From Star Trek: Borg (Disc 2)
	MACGAME1("picarddossier", "", "Picard Dossier", "e1dc28c1dd8409c2d2e0d5d269df5ffc", 519813, 400),
	WINGAME1t("picarddossier", "", "OMNIBORG.EXE", "59dbe112ee3a8d2a5c9cdf5f528dcfbd", 811363, 404),

	WINGAME1("picklesbook", "", "PICKLE.EXE", "fb00695cb48e574f4acd75587b280756", 805141, 404),

	// Full game is not Director
	// The second, later demo also contained the earlier demo as PITOLD.EXE in an incomplete state
	WINDEMO1t("pitfall", "Demo", "PITDEMO.EXE", "0f492b1b4d9598bd0ac19ea35f89dd3a", 712817, 404),
	WINDEMO1t("pitfall", "Demo", "PITDEMO.EXE", "71bca5c0c57532387e37ca1d322602a9", 699305, 404),

	// 1996.3; Developed by Future Pirates
	PIPGAME1_l("pipcatalog", "Vol. 1", "PiPPiN_DEMO", "d5ba36a687a999e0929a58c0c37edc79", 58401, Common::JA_JPN, 404),

	// Game contains Swedish, Danish, Finnish, Norwegian, English (US+UK), German, French, Spanish, Dutch, Japanese, Italian
	MACGAME1_l("pippi", "v1.3.1", "Pippi Start", "7c5a372c48e8879b2b1d107efe27e3b6", 530154, Common::EN_ANY, 404),
	WINGAME1t_l("pippi", "v1.3.1", "PIPPI.EXE", "816d2d015cda54a7836a41141caa9d8d", 696959, Common::EN_ANY, 404),
	// TDK rerelease
	// Is there a Mac version? (MobyGames has this as a hybrid release)
	WINGAME1t_l("pippi", "V1.3.1, TDK", "PIPPI.EXE", "2f3533b95406015d03d5dcd8ba7d961f", 691043, Common::EN_ANY, 404),
	// Published by Ahead Multimedia AB
	MACGAME1_l("pippi", "v1.3.3", "Pippi Start", "5f48d38b0c9b9c8790796d1eb1525713", 517216, Common::EN_ANY, 404),
	WINGAME1t_l("pippi", "v1.3.3", "PIPPI.EXE", "2f3533b95406015d03d5dcd8ba7d961f", 691043, Common::EN_ANY, 404),

	MACGAME1("planetarizona", "", "Planet Arizona", "0c7bbb4b24823e5ab871cb4c1d6f3710", 488433, 400),
	WINGAME1("planetarizona", "", "ARIZONA.EXE", "a23462ec87eff973d2cdb2ddfd4a59fa", 698651, 400),

	// Mac demo from MacFormat #44
	// Win demo from Computer Buyer v17n68 (January 1997)
	MACDEMO1("planetearth", "Demo", "Planet Earth", "a546ef2b921a9b48fd93928f1a505f22", 483490, 404),
	WINDEMO1t("planetearth", "", "PLANETE.EXE", "1ab2d4f204eb42c9a8ff5257f7cef149", 690069, 404),

	// Found on the Play-Doh Creations CD
	MACGAME1("playskool", "",  "goHIGmem PPC", "a6043fbba9186296faf8a2b82e5e4182", 64250, 404),
	WINGAME2t("playskool", "", "SAMPLER.EXE",  "4de224099dd6f16d5c9892f94c975f2a", 696951,
							   "START.DIR",	   "cbd61d015d533b25f3d568002f96bcee", 21469988, 404),

	// Distributed with Vote America demo
	WINGAME1t("poliq", "", "POLIQ.EXE", "08ea6f2f9af69af4d70967870fd92f81", 1376591, 404),

	MACGAME1("popapenguin", "", "pwrmacp", "ccf864a8dc6e9d0d26eb73b4683e634b", 61012, 404),

	MACGAME1_l("popup", "", "POP UP COMPUTER", "c1c73a286e7fdb439c8d49c79a2d9997", 318305, Common::JA_JPN, 400),
	WINGAME1_l("popup", "", "POPUP.EXE", "f47f7663a75120eca6c9e91025d51786", 65216494, Common::JA_JPN, 400),
	MACDEMO1_l("popup", "Demo", "POP UP COMPUTER DEMO", "8272aef35bd90e06bac5d622707d9459", 304941, Common::JA_JPN, 400),

	// Main game is not Director, just the autodemo
	MACDEMO1_l("popupmaker", "Auto Demo", "PopupMaker AUTODEMO", "c2cd18765b3d7d36a0f10ef0b1fe2472", 484283, Common::JA_JPN, 404),

	// Laser Publishing of Berkeley, California (1995)
	// Plays in English, Simplified Chinese, Tibetan
	// Alternate titles are 布达拉宫 and ཕོ་བྲང་པོ་ཏ་ལ་
	WINGAME1("potala", "", "POTALA.EXE", "2d5780d54e3c26281ef4aadef7d004b8", 35710089, 400),

	// From the Police Quest Collection
	WINGAME1("pqmakingof", "", "MAKING.EXE", "aae6a546b0c6bc51758053d14d9f6db2", 2127119, 400),

	MACGAME1("prangers1", "", "Power Rangers", "13fe5212d9fc599e34b1260dc09970be", 303281, 400),
	MACGAME1("prangers2", "", "PR Part 2", "0ecc4b4483d638bfb727cc5472b2fde3", 303281, 400),

	// original file name is Paradise*Rescue
	MACGAME1_l("prescue", "", "ParadiseRescue", "bcd3c718db258701496b3c5bcb827ef2", 502965, Common::JA_JPN, 404),
	WINGAME1_l("prescue", "", "P_RESCUE.EXE", "c66e73719aff15a2ba4f33cf2e21581a", 813265, Common::JA_JPN, 404),

	MACDEMO1("princeint", "Demo", "Mac_Int2", "dc5a87dda7a0daf46604515f7d2cca66", 289980, 403),
	WINDEMO1("princeint", "Demo", "PRINC2.EXE", "86fa884d22484ffa46407a2aa1ece297", 4758501, 400),

	// original file name is psych™
	MACGAME1("psych", "v1.0.5", "psych", "85dfccc89072ba781bc90783998c3937", 284622, 403),
	MACGAME1("psych", "v2.0.1", "psych", "1e0f16853ec1652a51ade41823405440", 406450, 403),

	// 1995 Mac only release
	MACGAME1("puppetmotel", "", "Puppet Motel", "8719de9c083aca942fc0e5c0a127b6dc", 641110, 404),

	// Original filename is '除虫菊Vol.1 Demo(PPC)'
	MACDEMO1_l("pyrethrum1", "Demo", "xn--Vol.1 Demo(PPC)-u825b41x5o6e", "422270206b9bd6aff43bbe95047f6ce9", 60665, Common::JA_JPN, 404),
	WINDEMO1t_l("pyrethrum1", "Demo", "VOL1DEMO.EXE", "bbe7ddbe439266f2ed57b9723f8a5c6c", 746843, Common::JA_JPN, 404),

	// Original filename is 'ボルテックス'
	MACDEMO1_l("quantumgate2", "Demo",	 "xn--pckua2al3iyd", "b7e69c37b7355022d400c14aa97c5d54", 484067, Common::JA_JPN, 404),
	// Decomposed variant of the above filename
	MACDEMO1_l("quantumgate2", "Demo",	 "xn--2bk1b4a0bo8jve", "b7e69c37b7355022d400c14aa97c5d54", 484067, Common::JA_JPN, 404),
	WINDEMO1t_l("quantumgate2", "Demo",	 "VORTEX.EXE", "11627f883100bb7cf5bb232a2322941f", 739889, Common::JA_JPN, 404),

	MACDEMO1_l("racingdays", "Demo", "Racing Days World", "fbe75e9140b23cf5bb2f5fd6f7ce8e88", 481803, Common::JA_JPN, 404),
	MACDEMO1_l("racingdays", "Demo", "Racing Days World", "0d5f13d9321d36c23b63f229460928b4", 481803, Common::JA_JPN, 404),
	MACDEMO1_l("racingdays", "Demo v1.01", "Racing Days World 1.01", "fbe75e9140b23cf5bb2f5fd6f7ce8e88", 481803, Common::JA_JPN, 404),

	MACDEMO1("readblasterjr", "Preview v1.0c", "Reading Blaster Jr. Power Mac", "49aa41e6b624e64e8e48850faa882cc8", 63276, 404),
	// from Great Adventures by Fisher-Price: Castle (1995)
	MACDEMO1("readblasterjr", "Preview v1.0c", "Reading Blaster Power Mac", "49aa41e6b624e64e8e48850faa882cc8", 61732, 404),

	MACDEMO1("redshift", "1994 Demo", "RSDEMO.MAC", "4f7ff33ce95ed9f42befdae4f9b6b690", 292244, 403),
	MACDEMO2("redshift", "Sound Demo", "RedShift Demo", "22815cf659b911c4e07d0015cac5d98f", 301669,
									   "audio.mov", "5ff901438143b3706808cf050b464900", 1843, 400),
	MACDEMO1("redshift", "No Sound Demo", "RedShift Demo", "22815cf659b911c4e07d0015cac5d98f", 301669, 400),

	MACGAME1_l("renderorgan", "", "RenderOrgan", "0c7bbb4b24823e5ab871cb4c1d6f3710", 505374, Common::JA_JPN, 404),
	WINGAME1_l("renderorgan", "", "743.EXE", "7a59a30b6b2db921f6d354cd74faf09a", 697963, Common::JA_JPN, 404),

	WINGAME2t("revdemo", "", "START.EXE", "6a008daf08422d013321e4ebe756efae", 690985,
							 "REVOLUTN.DIR",  "445271a8e88f63db033c51a46278b177", 73893456, 404),

	// Original filename is ラインの黄金CD
	MACDEMO1_l("rheingold", "Demo", "Das Rheingold CD", "b7e69c37b7355022d400c14aa97c5d54", 484351, Common::JA_JPN, 404),

	MACGAME1("rooked", "v1.1P", "ROOKED v1.1P", "58b4e23f8260c100f84232e7b62b74f8", 504455, 404),

	// Developed by Masahiro Fukuda & Co, published by Mizuki of Kashiba, Nara, Japan (1995)
	// Auto Mode plays game as a non-interactive movie
	WINGAME1_l("sabotenman", "",          "SABOTEN.EXE",  "30721602cb11d8764c5f0d9999ebe04d", 753725, Common::JA_JPN, 404),
	WINGAME1_l("sabotenman", "Auto Mode", "AUTOMODE.EXE", "67388a4076d1ba021dc7aa551798754e", 754423, Common::JA_JPN, 404),

	WINGAME1t("sagasoftworks", "", "__ENTER.EXE", "87718e74da6c30b5dc22e5564b4524d5", 696703, 404),

	MACGAME1_l("sailormoonart", "", "SAILORMOON", "b06606b4d174b85d41b265bd366959d6", 290450, Common::JA_JPN, 402),

	// Found on Sakhr Arabic Grammar v1.1
	// Product catalogue for Sakhr Software Co., Heliopolis, Egypt
	WINGAME1_l("sakhr", "", "MMDEMO.EXE", "0e5436b4daa9e787abb2692bb5ca5454", 740524, Common::AR_ARB, 404),

	MACGAME1_l("sakin2", "", "STARTCD", "67f572196550aedb1f9523d782022be0", 484351, Common::JA_JPN, 404),
	WINGAME1_l("sakin2", "", "STARTCD.EXE", "0c8a44b04aa6e8f1483b05f6b567fa3c", 749233, Common::JA_JPN, 404),

	// Full game is not Director
	WINDEMO1("santafe1", "Demo", "ELKMOON.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	MACGAME1("scanmon", "v1.06", "ScanMon 1.06", "477070ab597e76599fe1887c8dbccf73", 303978, 404),

	MACGAME1("sciencesmart", "", "Science Smart", "e020c33ab426b167647fed5e7aea6659", 295454, 403),
	WINGAME1("sciencesmart", "", "SCIENCE.EXE", "23e748085b255870650ae18b15dd986b", 759951, 404),

	MACGAME1("scrutiny", "", "ScruTiny in the Great Round", "f5c99f14046b52844b2e9bd0575f1eed", 494142, 404),
	WINGAME1("scrutiny", "", "SCRUTINY.EXE", "05dd9dfaf51383c242f61e990575fa34", 724885, 404),
	WINDEMO1t("scrutiny", "Demo", "SCRUTINY.EXE", "a59b58eb52edb172fc142ad6eeceb0f8", 715449, 404),

	WINDEMO1("searchlearn", "Demo", "SEARCH.EXE", "a563a1a244faf97137b47a3c0ee82176", 8088823, 404),

	MACGAME1("sensei", "", "Sensei", "6ab7bac3d8fe6bcf4da81750d7ca286c", 284630, 404),

	MACGAME1("sfpd", "v1.00", "Body in the Bay", "01be45e7241194dad07938e7059b88e3", 483774, 404),

	// Product was published by 夢本舗株式会社 (Yumehonpo)
	MACDEMO2_l("shadeviewer", "Operation Manual", "Manual", "8b138db44d4421cc7294a9dc792ccf1b", 502657,
							"xn--n8jlpy8c5cwhn28z6jxbst0e", "07c17d30a1e0cad5ef8a865587afb5ed", 4049, Common::JA_JPN, 404),

	// Full game is not Director
	WINDEMO1("shanghai", "Demo", "SHGMDEMO.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	WINDEMO1t_l("shinshofukei", "Autodemo", "SINSYOU.EXE", "daa65f2f0459fef6725d8a94a68c7ab0", 761098, Common::JA_JPN, 404),
	// Original filename is '心象風景'
	MACGAME1_l("shinshofukei", "", "xn--15t91mv19ahjk", "r:8b138db44d4421cc7294a9dc792ccf1b", 502617, Common::JA_JPN, 404),
	WINGAME1t_l("shinshofukei", "", "SINSYO2.EXE", "bb16588758a1ebd5df9fa8ecdd6bc249", 1296944, Common::JA_JPN, 404),

	WINDEMO1("shramerica", "Demo", "SHRAMER.EXE", "b50e77a25088cfe1cb88ee2dc4d3a9c9", 1335269, 404),
	WINDEMO1("shrgrammar", "Demo", "SHRGRAM.EXE", "c3ee0462fe5935cf1eabfbdecfe33f03", 698575, 404),
	WINDEMO1("shrmath", "Demo", "SHRMATH.EXE", "bc3ec272680e0e57f76032a2a8e196eb", 690109, 404),

	// Player app is a standalone player for cartoons created in Studio
	// Demo is found on apcmag.cd Dec 1999 disc 3, published by Australian Consolidated Press
	// Larger demo found on Computer Shopper 107 (February 1997)
	MACGAME1("simpsonsstudio", "",	   "Simpsons Cartoon Studio", "cd98745b01c43b49b223ecb1543cb3b1", 317514, 403),
	WINGAME1("simpsonsstudio", "",	   "SIMPSONS.EXE", "358af28ffe3fa515a9b9a03149483cb1", 3368957, 404),
	WINDEMO1("simpsonsstudio", "Demo", "SIMPDEMO.EXE", "bcd332d5061ec00b103c1529b4095a49", 901047, 404),
	WINDEMO1t("simpsonsstudio", "Demo", "SIMPSONS/SIMPDEMO.EXE", "e45f75ff547f392b8a4208afb15d0d1b", 2670335, 404),
	MACGAME1("simpsonsplayer", "",	   "Simpsons Cartoon Player", "f18e1cf6fb9fea099aae580c2057e551", 502040, 403),
	WINGAME1("simpsonsplayer", "",	   "SPLAYER.EXE",  "8966c096c5718316fddc7b238dd9df94", 884843, 404),

	// Win version is D5
	MACGAME1("simpsontrivia", "v3.1", "Simpsons Trivia 3.1", "db9b7f11aea52a294d2986a94a184000", 58354, 403),

	// Published by Pearson in association with the Ski Club of Great Britain
	WINDEMO1("skieurope96", "Demo", "SKI.EXE", "3643257d68fadce83611760435ca5cd4", 696861, 404),

	// Windows demo is from PC Gamer (US) demo disc #11 - Oct 1995
	MACGAME1("skyborg", "", "SkyBorg 1.0", "bcd3c718db258701496b3c5bcb827ef2", 486698, 404),
	WINGAME1t("skyborg", "", "BORG.EXE", "4a42a5d099ebb80c2ed8bc28b0a7e51c", 1887499, 404),
	WINDEMO1("skyborg", "Demo", "SKYBORG.EXE", "a2c76a72f703012808ab241c0e189694", 22368545, 404),

	WINDEMO1("smashsounds1", "Demo", "SMASH.EXE", "cc9f6f623ef61d2ac364eb41f65957ed", 2076581, 404),

	// Previous versions are D3
	// Demo from Software of the Month Club (May 1996)
	WINDEMO1t("smile", "v1.2", "smiledmo.exe", "72fefa3c49aa47731e6ab0bb076ccca7", 1872801, 400),

	// German version of Silly Noisy House (1999)
	WINGAME1_l("snh", "", "DBBBH.EXE", "9e13813fd39da5e27627ee28894d6ec0", 738336, Common::DE_DEU, 404),

	// From Blender 1.5
	MACGAME1("sonywalkman", "", "SONY AD LAUNCHER", "0c7bbb4b24823e5ab871cb4c1d6f3710", 481254, 404),
	WINGAME1t("sonywalkman", "", "SONY.EXE", "9858a13454c751dc1eb7527cff4ba0c8", 710099, 404),

	MACGAME1("sorgato", "", "SORGATO'S VARIABLE COLOR", "4011dd51c0eed1b5cf1fbf55360a7f60", 304189, 400),

	// Developed by KimTec UK; Published by McGraw-Hill, London (1996)
	// Provides an introduction to the seven main religions in the world
	WINDEMO1("sourcesfaith", "Demo", "SOFDEMO.EXE", "551ee34dcc8a03020aa75269b4b02c30", 3903813, 404),

	// Original filename is 素材辞典『体験版』ブラウザ
	MACDEMO1_l("sozaijiten", "Vol. 1 (Stone) Trial Version", "Sozaijiten (Trial Version) Browser", "d1ef4c4efcc587aea2a84a70d9eb778a", 297377, Common::JA_JPN, 402),

	MACGAME1("spacestationalpha", "", "The Encounter 16+MB", "e019f541a05887922e2ee19bcff5bb25", 483774, 404),

	MACGAME1("spitwad", "", "HSH", "f5033f237ad1b1639fc46d01a82ac380", 283018, 404),

	MACGAME1("springhead", "", "Springhead", "e6833f1ce3b022f0128e4c80a55bcd46", 288490, 404),

	// Full game is not Director
	WINDEMO1("spycraft", "Demo", "SPYCRAFT.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	// Original filename is 東北新社･ｻﾝﾗｲｽﾞﾛﾎﾞｯﾄ編
	MACGAME1_l("srdsunrise", "", "xn--djrs64bpib449aukfxo2t9baxa4fva2f2f0eoc0atc", "1c2e5371b835680e7c1ca8bcea008bef", 502589, Common::JA_JPN, 404),
	WINGAME1t_l("srdsunrise", "", "SRR_2.EXE", "3da1ce225f70e341500d0995e575f0e6", 747123, Common::JA_JPN, 404),

	MACGAME1("sscocacola", "", "Coca-Cola Animations", "6e86a061950bc3987ce2ddf531bfde34", 295426, 403),
	MACGAME1("ssdietcoke", "", "DietCoke Animations", "6e86a061950bc3987ce2ddf531bfde34", 295426, 403),
	MACGAME1("sslivepicture", "", "Live Picture Screen Saver", "4502263d183dd9dae0e3c3505fdf8ae1", 555539, 404),

	WINGAME1("ssseven", "", "SEVEN.EXE", "f85b47849209eb19709dabe338544827", 1892673, 404),

	MACGAME1("stream", "Volume 1", "Stream_1", "cdb27c916044ae4dceb4b7326063fa03", 304217, 400),
	WINGAME1("stream", "Volume 1", "STREAM_1.EXE", "147c76b43a5ec051381c238488f722d5", 690979, 400),

	// by Eij Kato
	MACDEMO1("summertime", "Demo", "Summertime.DEM0", "33f733b2809b94c3301096902f642b6e", 289490, 402),

	// From Super Sunday: An Interactive History Volume 2
	MACGAME1("superbowltrivia", "", "SB Trivia Game", "4979678478db83693217cf295f53572c", 544413, 404),

	WINGAME1_l("supermente", "", "superm.exe", "57181623661742fcad179aa387b75a29", 742640, Common::RU_RUS, 404),

	MACGAME1("superspy", "", "ssi english", "ccf864a8dc6e9d0d26eb73b4683e634b", 60324, 400),
	MACGAME1_l("superspy", "", "SSI (Power Mac)", "5f036ea61efdcc5e30074a404dbf4d80", 61030, Common::DE_DEU, 400),
	MACGAME1_l("superspy", "", "ssi hebrew", "49aa41e6b624e64e8e48850faa882cc8", 60324, Common::HE_ISR, 400),
	MACGAME1_l("superspy", "", "SSI", "8f6a07fe6aa88428dd73557e1cd53d06", 58058, Common::IT_ITA, 400),
	WINGAME1("superspy", "", "ssie.exe", "1f256591c24a3bef0875aee737114057", 2181003, 400),
	WINGAME1_l("superspy", "", "Ssi.exe", "88272b3e24689c3986f4f4aa8c50e1f7", 2307489, Common::DE_DEU, 400),
	WINGAME1_l("superspy", "", "ssih.exe", "f016f23131189b2b65669f5258538fb5", 2261091, Common::HE_ISR, 400),
	WINGAME1_l("superspy", "", "SSI.EXE", "890c17a442dd3d96ab331f96d8c1eed8", 3648017, Common::IT_ITA, 400),

	// Mac executable is How Would You Survive?
	MACGAME1("survive", "", "How Would You Survive", "01be45e7241194dad07938e7059b88e3", 501316, 404),
	WINGAME1("survive", "", "SURVIVE.EXE", "6d798bb5d6d90cc4bae30510a87eff3c", 703155, 404),

	MACGAME1_l("svmvillagina5", "", "Villagina 5 -8Mo", "08876be0a21938f382038f8d12d5e5d9", 483423, Common::FR_FRA, 404),
	WINGAME1_l("svmvillagina5", "", "VILLAGE.EXE", "fd8420e5fc9dcca6f7ddcb3d17bec5c0", 743945, Common::FR_FRA, 404),

	// Original filename is 'SYZYGYSｸﾘｯｸｱﾆﾒ｢ｽﾓｳ組曲｣'
	MACGAME1_l("syzygys", "", "xn--SYZYGYS-zj5o702ne6ytna4l0a3a5eb1g1hmjwa1h", "17efee018a660458fae80de4364021ac", 483159, Common::JA_JPN, 402),

	WINGAME1("teamxtreme1", "", "XTREME.EXE", "45ab80997efedec388ff5200722e673c", 690123, 400),
	WINGAME1("teamxtreme2", "", "TX2.EXE", "50c80bd2add25e574494838772973beb", 2585471, 400),

	// From MacFormat #42
	MACDEMO1("texturescape", "", "TextureScape Show", "77f4098988d5386794d1530065f514cd", 303961, 400),

	// Mac full executable name is ハイ！鉄マンです
	// Mac demo executable name is デモ
	MACGAME1_l("tetsuman", "",	   "Tetsuman",		"bcd3c718db258701496b3c5bcb827ef2", 484323, Common::JA_JPN, 404),
	MACDEMO2_l("tetsuman", "Demo", "Demo",			"bcd3c718db258701496b3c5bcb827ef2", 484323,
								   "LOGO",			"eca1db6f65dbd3213dbddf121adb3db2", 1050164, Common::JA_JPN, 404),
	MACDEMO2_l("tetsuman", "Demo", "xn--edkuc",			"bcd3c718db258701496b3c5bcb827ef2", 484067,
								   "MOVIE/LOGO",			"47d62361bd7d3cbf48918c8136a8c5fa", 1050036, Common::JA_JPN, 404),
	MACDEMO2_l("tetsuman", "Demo", "xn--2bkvetd",			"bcd3c718db258701496b3c5bcb827ef2", 484067,
								   "MOVIE/LOGO",			"47d62361bd7d3cbf48918c8136a8c5fa", 1050036, Common::JA_JPN, 404),
	WINGAME1_l("tetsuman", "", 	   "TETUMAN.EXE", 	"460a27915f96f1aeb50b271722637a60", 746847, Common::JA_JPN, 404),
	WINDEMO2_l("tetsuman", "Demo", "DEMO.EXE", 		"460a27915f96f1aeb50b271722637a60", 746847,
								   "SHARED.DIR", 	"1a294eaa8f725a54aa00e5ec6d3560a9", 1656378, Common::JA_JPN, 404),

	// Pippin disc contains Pippin + Mac executables
	// On Win/Mac disc, the original Mac executable name is 鉄マン外伝
	// Mac demo executable name is デモ
	MACGAME1_l("tetsumangaiden", "",	 "Tetsuman Gaiden", "ea646eccc9a53f44ce082459d4809a06", 484323, Common::JA_JPN, 404),
	MACDEMO2_l("tetsumangaiden", "Demo", "Demo",			"0cbcb147543278d3f719fc31a3e6def6", 1097597,
										 "LOGO",			"e656c2676aa805ae95c40dbd3ac3cd61", 1049760, Common::JA_JPN, 404),
	PIPGAME1_l("tetsumangaiden", "",	 "GAIDEN.Pippin",	"2618a85198d0180e3eae9162f81aafed", 61059, Common::JA_JPN, 404),
	WINGAME1_l("tetsumangaiden", "",	 "GAIDEN.EXE",		"e0176c2683e3f3cac971e976bafb8fee", 747105, Common::JA_JPN, 404),
	WINDEMO2_l("tetsumangaiden", "Demo", "S.EXE",			"6e8d348333574dad57d316b780bc5f35", 747195,
										 "LOGO",			"82d44fb57e72e6243b55634379a74f6c", 1051768, Common::JA_JPN, 404),

	WINGAME1t("theatreimag", "", "THEATRE/THEATRE.EXE", "9076c221dbf17077310a308ccdf41623", 751065, 404),

	// Full version is not Director
	MACDEMO1_l("thetowerxmas", "Demo", "TowerXmasDiscDEMO", "b0fb747bd526bd4ba820a4072d009bd0", 481803, Common::JA_JPN, 404),

	// Mac version is not Director
	WINGAME1("thinkinthingsdp", "", "PARENTS.EXE", "4e82061a925caa16320c52b38aeb68c5", 1160899, 400),

	// From CD Loisirs Nº6
	MACDEMO1("thisisspinaltap", "Demo", "Spinal Tap", "79f66d95f0089330fa2d3d12a3cc0b2e", 291972, 403),

	// Full version is not Director
	WINDEMO1("timelapse", "Demo", "TLOVIEW.EXE", "6cd9f5644c8aa66ce60a23ee02762eab", 75131959, 404),

	MACDEMO1_l("toeic", "Demo", "TOEIC", "77f4098988d5386794d1530065f514cd", 301937, Common::JA_JPN, 400),

	WINDEMO1t("tommy", "Demo", "TOMMY.EXE", "c754198b33865bb95d77c1188d0a67d6", 696897, 404),

	// Full version is available on Tone Tales from Tomorrow Too from Ntone (CD9)
	WINDEMO1("tonetrakker", "Demo", "TTSTART.EXE", "7ab8fc552f890fe827ccd60679032527", 697017, 404),

	// Mac executable name is TD MAC/PPC
	// Earlier demos are D3; the Great Big Demo is from Spaceship Warlock AV (1996)
	// Great Big Windows demo is also on this disc, despite it being HFS and Mac-only
	MACGAME1("totaldistortion", "",	"TD MACPPC",	"17efee018a660458fae80de4364021ac", 486074, 404),
	WINGAME1("totaldistortion", "", "TOTAL_DN.EXE", "461b407c321e80487ae4882056310f9f", 700747, 404),
	MACDEMO1("totaldistortion",	 "Great Big Demo", "TD Demo 12 Meg", "17efee018a660458fae80de4364021ac", 485818, 404),
	WINDEMO1t("totaldistortion", "Great Big Demo", "TD_DEMO.EXE",	 "028063f8a752f5ffda7477f328500d82", 700447, 404),
	WINDEMO1t("totaldistortion", "Demo",		   "TD_DEMO.EXE",	 "a6782c106252b247345b41a895068808", 696855, 404),
	WINDEMO1t("totaldistortion", "Demo",		   "TD_DEMO.EXE",	 "9383e298afa7e1a5f24f381051458e00", 684187, 400),
	MACDEMO1_l("totaldistortion","Great Big Demo", "Total Distortion DemoJ", "98f6c9068ba48471757da0b522ce3e67", 485818, Common::JA_JPN, 404),

	MACGAME1("toyota95", "", "Toyota 95", "01be45e7241194dad07938e7059b88e3", 486985, 404),

	// Developed by Zenda Studio
	MACGAME1("travelrama", "", "Travelrama - PowerMac ONLY!/Travelrama PowerMac", "d8b8e42c2d9875b47ea762ca3fd45122", 128137, 404),
	MACGAME1("travelrama", "Tour", "Travelrama Tour", "e6833f1ce3b022f0128e4c80a55bcd46", 288518, 404),
	WINGAME1t("travelrama", "", "TRAMAWIN/TRAMA.EXE", "52d68e3a8d54b2091dd58ddc464c850d", 698215, 404),
	WINGAME1t("travelrama", "Tour", "TRAMAWIN/TOUR.EXE", "cf439eb7a102716908c4f7ef0bb09637", 697009, 404),

	MACGAME1("trekguideds9", "v1.0", "Omnipedia DS9 Episodes", "1c2e5371b835680e7c1ca8bcea008bef", 505317, 400),
	WINGAME1("trekguideds9", "v1.0", "OMNI_DS9.EXE", "0058390ff77e527c7bb413081004c304", 805517, 400),

	MACGAME1("trekguidetng", "v1.1", "TNG Episodes", "1c2e5371b835680e7c1ca8bcea008bef", 520149, 400),
	WINGAME1("trekguidetng", "v1.1", "OMNI_TNG.EXE", "0049d72e2d5869408fc33860ec4b5c1f", 794201, 400),

	MACGAME1("trekomni", "v1.00", "Omnipedia", "b7e69c37b7355022d400c14aa97c5d54", 516791, 400),
	MACGAME1("trekomni", "v1.1.2 Upgrade", "Omnipedia 2", "b7e69c37b7355022d400c14aa97c5d54", 613253, 400),
	WINGAME1("trekomni", "Premier Edition", "ST_OMNI.EXE", "1a648d47632561f10a98782f1dde5738", 811827, 400),
	WINGAME1("trekomni", "v1.1.2 Upgrade", "ST_OMNI2.EXE", "1d60aad73cc9c69776a878aa59e65230", 809781, 400),

	MACGAME1("trektech", "", "Install on Hard Drive (Big)/STNG Technical Manual (PowerPC)", "a9bd9f3a82fcde6e4d151868e256aec7", 525690, 400),
	WINGAME1("trektech", "", "STARTREK/NCC1701D.EXE", "02aec408cee26413a096aec9b1cb1878", 720249, 400),
	WINGAME1_l("trektech", "", "STARTREK/NCC1701D.EXE", "dc960a161de1883867030b3612313f06", 726723, Common::DE_DEU, 400),
	MACDEMO1("trektech", "Demo", "TrekForMac", "68ed73866232194a9a5609040dc1f242", 289696, 403),
	MACDEMO1("trektech", "Demo", "For_Mac", "bcd3c718db258701496b3c5bcb827ef2", 481226, 404),
	WINDEMO1t("trektech", "Demo", "TREK_WIN.EXE", "e2f2951b83acf5b15e4d325aa3980872", 4061175, 404),

	MACGAME1_l("truegolf1", "", "TrueGolf PartI", "9fcf36bf9966574b13e459eb9b94a814", 481862, Common::JA_JPN, 403),

	// Bilingual English/Spanish
	// Spanish title is Verdades y Ficciones
	MACGAME1("truthsfictions", "", "Truths & Fictions", "4577dd3eadc467a986ab172d90871b22", 534968, 404),

	WINGAME1t("ugtmk", "", "TUG2MK.EXE", "3612d22c5c2f6bda8449828eaf338173", 692411, 404),

	// Original filenames are 合わせ月の夜 (disc 1), フェンネル (disc 2), いにしえびと (disc 3)
	MACGAME1_l("twistynight1", "", "Moonlit Night", "8ea9e9a699c61edddffd79ddd0c994d7", 290682, Common::JA_JPN, 402),
	MACGAME1_l("twistynight2", "", "Fennel", "8ea9e9a699c61edddffd79ddd0c994d7", 290682, Common::JA_JPN, 402),
	MACGAME1_l("twistynight3", "", "Young Man", "8ea9e9a699c61edddffd79ddd0c994d7", 290682, Common::JA_JPN, 402),

	// Demos from Big Top Productions: Felix the Cat, Hello Kitty, Keroppi & The Groove Thing
	WINGAME1("ubt", "", "BTDEMO.EXE", "dbe72b7dc91c72db5b4597857aecf5c6", 696813, 404),

	// YOBI.EXE is a projector for lower performance systems
	WINGAME1_l("ukiuki1", "",	  "TENNGU.EXE", "f0bbb9938a7cb899b6fc93ef7f3e8150", 747145, Common::JA_JPN, 404),
	WINDEMO2_l("ukiuki1", "Demo", "S.EXE",		"09430e02b3540e623d0b400792958901", 747145,
								  "LOGO.DIR",	"b6d341c63fbea25898fc310981413c28", 1053528, Common::JA_JPN, 404),
	WINGAME1("ukiukibgv", "",	  "BGV",		"4dc07ac998272bb4027a9979f5b6c3b6", 1097649, 404),
	{
		{
			"ukiuki1", "CD Demo",
			// Original filename is 幻の天狗池
			AD_ENTRY1s("Maboroshi no tengu-chi", "792a89586ed20c4662b51c2bfd43be80", 1102407),
			Common::JA_JPN,
			Common::kPlatformMacintosh,
			ADGF_CD | ADGF_DEMO | SUPPORT_STATUS,
			GUIO1(GUIO_NOASPECT)
		},
		GID_GENERIC,
		404
	},

	// Original Mac demo filename is デモ
	// Original Mac full game filename is 波止の五目釣り
	// Windows demos on Uki Uki 3 sample disc are hidden in MOVIE/BMP
	// All of the Windows demo projectors use the S.EXE filename
	MACGAME1_l("ukiuki2", "",	  "Hashi no gomoku-dzuri", "bcd3c718db258701496b3c5bcb827ef2", 488946, Common::JA_JPN, 404),
	MACDEMO2_l("ukiuki2", "Demo", "Demo",				   "5ef06a50a335ec0a9a0f9017057ccfe9", 1097469,
								  "START",				   "c1eaf606b97d1fb5a55214485d330aa9", 9228, Common::JA_JPN, 404),
	WINDEMO2_l("ukiuki2", "Demo", "S.EXE",				   "5ef06a50a335ec0a9a0f9017057ccfe9", 1097469,
								  "OPENING",			   "c1eaf606b97d1fb5a55214485d330aa9", 9228, Common::JA_JPN, 404),

	// Demo is D5
	// Original filename is 人魚島のボート釣り
	MACGAME1_l("ukiuki3", "", "Ningyo shima no boto-dzuri", "bcd3c718db258701496b3c5bcb827ef2", 488038, Common::JA_JPN, 404),

	// Bilingual Japanese/English
	MACGAME1("undergroundaz", "", "SO_OUT", "47e49b52d4c99ea6ea72c3dcbb57b34b", 290422, 400),
	WINGAME1t("undergroundaz", "", "SO_OUT.EXE", "cbffbb52e532daf671a6398c25d6db1d", 4637941, 404),
	// Standalone app in a subdirectory
	MACGAME1("undergroundaz", "Left Hand Drawings", "DRAWING", "8ea9e9a699c61edddffd79ddd0c994d7", 290398, 402),
	WINGAME1t("undergroundaz", "Left Hand Drawings", "DRAWING.EXE", "e1afecdd3458db84a7a4a0c26b8ebad3", 716183, 404),

	MACGAME1("universe", "", "xn--Invisible Universe -ere/Invisible Universe", "78138a77207907642744d0960c14d9e5", 596510, 404),
	WINGAME2t("universe", "", "UNIVERSE/UNIVERSE.EXE", "2ae0654d19de7b366e9d6e9ac4588c50", 700157,
							  "UNIVERSE/STARTUP.DIR",  "34d4084b17cea8982fd24f9561d77d65", 24958, 404),

	WINGAME1t("ushistory", "", "HISTORY.EXE", "5660e6a7b772b5bf8867627ab0d7a58b", 703629, 404),

	// System 6 version is D3
	MACGAME1("videocasino", "", "xn--Video Casino PowerMac-pb4m", "ccf864a8dc6e9d0d26eb73b4683e634b", 60068, 404),
	MACDEMO1("videocasino", "Demo", "VC.Demo.14.7.Start", "17efee018a660458fae80de4364021ac", 483490, 404),

	// Demo covering various Voyager Japan discs
	// Original filename is 'キッズ CD-ROM'
	MACDEMO1_l("voyagerkids", "Demo", "xn-- CD-ROM-8s4f7dxd", "4577dd3eadc467a986ab172d90871b22", 502657, Common::JA_JPN, 404),
	// Decomposed variant of the above filename
	MACDEMO1_l("voyagerkids", "Demo", "xn-- CD-ROM-oo4flgueve", "4577dd3eadc467a986ab172d90871b22", 502657, Common::JA_JPN, 404),

	// Original Mac fllenames begin with Virtual Cop™
	MACDEMO1("vcop", "Demo", "Virtual Cop IPK", "ea646eccc9a53f44ce082459d4809a06", 482838, 404),
	MACGAME1("vcop1", "", "Virtual Cop (8MB)", "0c7bbb4b24823e5ab871cb4c1d6f3710", 483774, 404),
	WINGAME1("vcop1", "", "VCOP.EXE", "dfa4c8709ed83f2ac79aeecf9b2d1f95", 697427, 404),
	MACGAME1("vcop2", "", "Cop II, The Angel Returns", "0c7bbb4b24823e5ab871cb4c1d6f3710", 482838, 404),
	WINGAME1("vcop2", "", "VCOP2.EXE", "9683bc8aeb2d47f2e38908bac65fd9bd", 723653, 404),

	// Original filename is DreamLight® Verttice™ 2.0
	MACGAME1("verttice", "v2.0", "DreamLight Verttice 2.0", "b7e69c37b7355022d400c14aa97c5d54", 512047, 404),

	MACDEMO1_l("victorianpark", "Demo", "Victorian Park DEMO", "0d5f13d9321d36c23b63f229460928b4", 483443, Common::JA_JPN, 404),

	MACGAME1_l("virtualmuseum", "", "Virtual Museum Vol.1", "8b138db44d4421cc7294a9dc792ccf1b", 503337, Common::JA_JPN, 403),

	WINDEMO1t("vote", "Demo", "VOTEDEMO.EXE", "9730557013fd18686943f3787c030f23", 7679955, 404),

	MACGAME1("vnc", "", "VNC", "0c7bbb4b24823e5ab871cb4c1d6f3710", 486116, 404),
	WINGAME1("vnc", "", "VNC.EXE", "40ba00213a10164eb6e01847108f9b21", 1086869, 404),
	WINGAME1("vnc", "Beta", "VNC.EXE", "e6f284971c09f19e3277aa8ebcf58cbd", 726643, 404),

	// Mac version requires installation, 'Install Voodoo Lounge', StuffIt
	MACGAME1("voodoolounge",  "",	   "Voodoo Lounge", "b7e69c37b7355022d400c14aa97c5d54", 502080, 404),
	WINGAME2t("voodoolounge", "",	   "VOODOO.EXE", "09553ceec915a1eeb9a990245bfd189b", 866187,
									   "VLMOVIES/16_VIPLG.DXR", "9ca1989d17bf1946b6349027eb8b681b", 3344100, 404),
	MACGAME1("voodoolounge",  "Raver", "Voodoo Raver", "b7e69c37b7355022d400c14aa97c5d54", 499816, 404),
	WINGAME1t("voodoolounge", "Raver", "SCRNRAVE.EXE", "0b6366628443168328b40c0660741ed8", 696751, 404),
	WINDEMO2t("voodoolounge", "Demo",  "VOODOO.EXE", "0122b7c0fb828771d6dc589bba448e01", 1119265,
									   "VLMOVIES/16_VIPLG.DXR", "53e5b7f4aad56a651d9e00ed7b7bd70d", 6901738, 404),

	// English Windows version also contains this application
	// "The PC version is launched from a very simple projector called "GOPREV.EXE", which lives in the "SUPPL" folder.
	// The installer copies this executable to a directory on the hard drive, and creates a lingo.ini file that puts the
	// drive letter of the CD-ROM drive into a global called CDPath. This projector calls the movie CDPath&"PREVIEW.DIR"."
	// WINGAME1t("vygrpresents", "Installed", "GOPREV.EXE", "d6cbe5df16170418dee965c5bc1d5e87", 712453, 400),
	// Japanese version is Mac-only
	MACGAME1("vygrpresents", "", "Voyager Preview", "4efba92cbb95eff273c40e57d0f0f535", 296494, 403),
	WINGAME1t("vygrpresents", "", "PREVIEW.EXE", "d1e277b509be1fe48f5ca6c48324382c", 4278225, 404),
	MACGAME1_l("vygrpresents", "", "Voyager Preview", "4577dd3eadc467a986ab172d90871b22", 310336, Common::JA_JPN, 402),

	WINDEMO1t("vtarot", "Demo", "VTAROT.EXE", "4c6c3949bda323f92f09a5769bbb250c", 693261, 404),

	// Original Mac filename is VUSIC™ The Screen Raver™
	MACDEMO1("vusic", "Demo", "VUSIC The Screen Raver", "5bbb193a8785c70abe2a4d86b99e1536", 283291, 403),
	WINDEMO1("vusic", "Demo", "VUSIC.EXE", "ff2c0a776d5f0c9aa5bc115d3b36676b", 693375, 400),

	// Original filename 'ワロビージャックの大冒険<デモ>'
	MACDEMO2_l("wallobee", "Demo", "xn--baa0pja0512dela6bueub9gshf1k1a1rt742c060a2x4u", "0666ae690e459d3d0d91800ebd94de46", 290780,
								   "001b.mov", "2b49fe4e49f9e846fb6e78f92e9a296d", 6675, Common::JA_JPN, 402),

	MACDEMO2_l("wallobee2", "Demo", "xn--baa0pja0512dela6bueub9gshf1k1a1rt742c060a2x4u", "0666ae690e459d3d0d91800ebd94de46", 290780,
									"000.MOV", "92db07a408eca6bc0ebc230e31e6caa4", 461940, Common::JA_JPN, 402),

	MACGAME1("wallobee3", "", "Lost Lionardo", "cdb27c916044ae4dceb4b7326063fa03", 303961, 400),
	WINGAME1("wallobee3", "", "LIONARDO.EXE", "51de9e2a40f06d96ca59fcf37c6f297a", 775449, 400),

	MACGAME1("wallobee4", "", "Secret of the Sphinx", "1682231de376e5465240f6e4a7952072", 291988, 403),
	WINGAME1t("wallobee4", "", "SPHINX.EXE", "3d6137ab4553d7e86c1773b081d2b04b", 829780, 403),

	SHKGAME1("wallobeetemple", "", "loadwallo.dcr", "caa01358070ebfbb1a491fe62b88247d", 27986, 404),
	SHKGAME1_l("wallobeetemple", "", "loadwallof.dcr", "4d23617c9a9e468e1b6da0937e3adb11", 28361, Common::FR_FRA, 404),

	// Published in Japan by NEC and Emotion Digital (Bandai), Taito City, Tokyo
	WINGAME2t_l("warlock", "", "START.EXE",	   "c2ceb9ac99aaf6a5020c9e9adf42ac91", 694159,
							   "SSWARLCK.DIR", "3713bde5de54cd74cafacbe430134022", 608862, Common::JA_JPN, 400),
	MACDEMO2_l("warlock", "Demo", "sswdemo",	   "9e3f05103eeb6b4b356e3c7c1e9b6802", 288134,
							   "SSWdemo.DIR", "12a30501049536d72d5d46e285f48c47", 10112, Common::JA_JPN, 402),
	MACGAME2_l("warlock", "", "SSWARLOCK",	   "22815cf659b911c4e07d0015cac5d98f", 301929,
							   "NAV/SHARED.DIR", "18e32edc1081957290c03aafa89354e4", 624390, Common::JA_JPN, 400),

	// Original Mac filename is わりわりワールド_デモ
	MACDEMO1_l("wariwari", "Demo", "Wari Wari World Demo", "f808a9f231b77617fa559cf9d2da66c1", 502975, Common::JA_JPN, 400),
	WINDEMO2_l("wariwari", "Demo", "S.EXE",				   "56faebd9531821fe9be95515c43f7fcc", 744019,
								   "WADEMO.DXR",		   "cf6453b97f7e1cb1fb19ecb59bbb9caf", 6213026, Common::JA_JPN, 404),

	MACDEMO1("warplanes", "Demo", "Warplanes Demo", "4f7ff33ce95ed9f42befdae4f9b6b690", 292244, 403),

	MACGAME1("whales", "", "World Of Whales", "da0da5d543b237051975ad70bec129f4", 483774, 404),

	MACGAME1("wildblueyonder1", "", "Wild Blue Yonder 1", "dc5a87dda7a0daf46604515f7d2cca66", 292244, 403),

	WINGAME1t("williamsbts", "", "BEHIND.EXE", "0a432cb988c9865c478bdc195429d3fd", 693077, 404),
	MACGAME1("williamsbts", "", "Behind the Scenes", "5442b05b2d320eb2e2ec3c74fa41f953", 483490, 404),

	WINDEMO1("windows95", "Demo", "W95DEMO.EXE", "508a025373f0e8f6ae514578cf97c281", 24814094, 404),

	// Heksenspul met Hennie de heks en de kat Helmer (NL); Häxan Hekla (SE)
	// Published in the UK by Oxford University Press
	WINGAME1_l("winniewitch", "", "HENNIE.EXE", "25b6c57704b8a2913cfa5d7f30adbc9a", 967339, Common::NL_NLD, 400),
	WINGAME1t_l("winniewitch", "", "HEKLA.EXE", "4ccad55d613b194bc69684ebe3e03777", 698139, Common::SE_SWE, 404),
	WINDEMO1("winniewitch", "Demo", "WINNIE.EXE", "6efbdb88014d09c9d189a019cffa89ff", 977277, 404),

	// Japanese title 'よく見てごらん！'
	// Original filename is 'よく見てごらん！DEMO'
	MACDEMO1_l("withopeneyes", "Demo", "xn--DEMO-p73c4a0jrlma4hx340j3t8k", "4577dd3eadc467a986ab172d90871b22", 502657, Common::JA_JPN, 404),
	// Decomposed variant of the above filename
	MACDEMO1_l("withopeneyes", "Demo", "xn--DEMO-p73cya6krlma4hwc4581n9dwl", "4577dd3eadc467a986ab172d90871b22", 502657, Common::JA_JPN, 404),

	MACGAME1_l("wolfgang", "v1.0", "Wolfgang", "01be45e7241194dad07938e7059b88e3", 483518, Common::IT_ITA, 404),
	WINGAME1t_l("wolfgang", "v1.0", "TOSYS/WOLFGANG.EXE", "35faee21d2aadf32cf2e68535ed3a77e", 1256449, Common::IT_ITA, 404),
	WINGAME1t_l("wolfgang", "v2.0", "WOLF95.EXE", "f6b43329b6ad968eb4fb15436549ef85", 1305318, Common::IT_ITA, 404),

	MACDEMO1_l("wonderomcw", "Demo", "WONDEROM_CW", "549afa25835bcd35daff0f399e54149e", 290726, Common::JA_JPN, 402),

	WINDEMO1("worldatlas", "Sampler", "ATLAS.EXE", "dc58e6e06807f4a4a4cc278f8748659f", 696807, 404),

	// Found on
	// 1995-08-16 Mac/Win hybrid v1.2 release of SimTower
	// 1995-10-28 Mac/Win hybrid release of Marty
	MACDEMO1("wrath", "Demo", "Wrath of the Gods", "7fd44b6dffa0ea0402eaed4c3769b39b", 309696, 404),
	WINDEMO2t("wrath", "Demo", "000WRATH.EXE", "5d0ee796571b99d402a06438ae2f3d56", 696815,
							   "SHARED.DIR", "27afa0d790af95b99ba30da10c883f92", 3570628, 404),
	// Found on The Crystal Skull CD
	MACDEMO2("wrath",  "Demo", "gomac",		 "01be45e7241194dad07938e7059b88e3", 508848,
							   "Shared.Dir", "89f558d6a6535c16ec440948d86988b8", 3570542, 404),
	WINDEMO2t("wrath", "", "WRATH.EXE",	 "5d0ee796571b99d402a06438ae2f3d56", 696815,
						   "SHARED.DIR", "e709f7b88f6241e4f45632beb0533ac1", 3570542, 404),

	// Full game is not Director
	MACDEMO1("wttf", "Demo", "WTTF", "01be45e7241194dad07938e7059b88e3", 483518, 404),

	WINDEMO1("wwanimals", "Demo", "ANIMALS.EXE", "25fee176193d52cf7cbc2b604bfcbf8c", 6961631, 404),

	MACGAME1_l("xaxa", "", "XAXA MACHINE", "ff0b7a4b925c7345785c372d618d0967", 342977, Common::JA_JPN, 400),

	MACGAME1_l("xmaspresent", "", "Christmas Present", "8b138db44d4421cc7294a9dc792ccf1b", 308920, Common::JA_JPN, 402),
	MACGAME1_l("xmaspresent", "Music", "xn-- MUSIC -", "75e98233db68c83153cb1d6cfd601286", 310000, Common::JA_JPN, 402),

	// Pippin version is D5
	// Published by Oxford Multimedia (1995)
	WINDEMO1("xmasstory", "Demo", "ACS.EXE", "864edd47c1870fafa463340f9e2ac878", 692713, 404),

	// Windows version requires install, INSTALL.Z, InstallShield V3
	// Mac version requires install, Install Me, uses Smaller Installer by Cyclos
	MACGAME1("y2lsnoopycoloring", "v1.0", "MS Coloring Book", "c5ca29779414b218e7cb8007e6a2c5ed", 491992, 404),
	WINGAME1t("y2lsnoopycoloring", "v1.0", "COLBOOK.EXE", "28ae91c6227fa616d1342c9db2b927d7", 728111, 400),

	// Windows version requires installation, INSTALL.Z, InstallShield v3
	MACGAME1("y2lgeography", "", "MSWorldGeography", "c5ca29779414b218e7cb8007e6a2c5ed", 550644, 404),
	WINGAME1("y2lgeography", "", "MS_GEO.EXE", "97bed0dfebc8d7e1fd4547578fe07c3f", 710977, 404),

	MACGAME1_l("ybr2", "", "YBR2", "b797956eb3a4dabcc15bfadf6fc66591", 504153, Common::JA_JPN, 400),
	WINGAME1_l("ybr2", "", "YBR2.EXE", "dbe273c1df60305be98a1a582ddd2c3b", 860579, Common::JA_JPN, 400),
	WINDEMO1_l("ybr2", "Demo", "YBR2DEMO.EXE", "25ecc053e02a0ef537d34d615119c814", 900973, Common::JA_JPN, 400),

	// Original Mac filename is よーいドンDEMO
	MACDEMO1_l("yoidon", "Demo", "Yo-i Don DEMO", "3a0c62a46f36157434c4204e50f22886", 305032, Common::JA_JPN, 403),
	WINDEMO2_l("yoidon", "Demo", "S.EXE",		  "9448daa2ccbc2c3707df48323327feb0", 747007,
								 "START.DXR",	  "651764cd9add9cc56022dc499b2aca92", 9803044, Common::JA_JPN, 404),

	// Original Mac filename is 真・百物語
	MACGAME1_l("yokai", "", "xn--vek138qttcmsa439e", "17efee018a660458fae80de4364021ac", 556245, Common::JA_JPN, 404),
	WINGAME1t_l("yokai", "", "YOUKAI.EXE", "0e8457a40c5ed1729ffdaf025ad92309", 740279, Common::JA_JPN, 404),

	// Original filename is '吉本芸能整形'
	MACGAME1_l("yoshimotogeino", "", "xn--9pry7xgzejzbf61d6fc", "0c7bbb4b24823e5ab871cb4c1d6f3710", 484067, Common::JA_JPN, 404),
	WINGAME1t_l("yoshimotogeino", "", "YOSHI.EXE", "ad61e5d1455ed0f24af19ceac3377312", 1258187, Common::JA_JPN, 404),

	MACGAME1_l("yokaanime18", "", "xn--18-z73ankte4jofn518co1ol", "e5a799da09d626f4954f306d12bbb6ea", 340613, Common::JA_JPN, 400),

	// Published by Nikkei and Sakura Notes of Minato City, Tokyo (1996)
	// Windows disc contains a projector SWAP.EXE that loads the program using virtual memory
	// Four different Mac projectors for various memory and monitor configurations
	// Original Mac filename is 17インチ1670万色(要10Ｍ）
	MACGAME1_l("yumemirukairo", "", "xn--171670(10-hv4htktuj831avm1hqewau034bqra", "8b138db44d4421cc7294a9dc792ccf1b", 505178, Common::JA_JPN, 400),
	WINGAME1_l("yumemirukairo", "", "YUMEMIRU.EXE", "a6573719b2f3c3fbc6b7ad6a7bb191c0", 866281, Common::JA_JPN, 404),

	// Only the cutscenes are in Director.
	// Also, only the original Chinese version uses Director; the
	// English version doesn't.
	WINGAME1_l("ypl2", "Cutscene 1", "PASS/PASS1.EXE", "dbde91e9fbe6dad229a76a7020a993e9", 1046143, Common::ZH_TWN, 403),
	WINGAME1_l("ypl2", "Cutscene 2", "PASS/PASS2.EXE", "46c84f9fc725cc7e89e0c52e5aea552b", 1254663, Common::ZH_TWN, 403),
	WINGAME1_l("ypl2", "Cutscene 3", "PASS/PASS3.EXE", "0ee12b196f0ac38705c8cde769136273", 1253461, Common::ZH_TWN, 403),
	WINGAME1_l("ypl2", "Cutscene 4", "PASS/PASS4.EXE", "e69b54557917d38fbdb36e927f3fcfcb", 1101831, Common::ZH_TWN, 403),
	WINGAME1_l("ypl2", "Cutscene 5", "PASS/PASS5.EXE", "27a4a7c4cf35d79614025fd8988e0df6", 989331,  Common::ZH_TWN, 403),
	WINGAME1_l("ypl2", "Cutscene 6", "PASS/PASS6.EXE", "eb49dec55e182667a0020eaf6537d4b3", 2258049, Common::ZH_TWN, 403),
	WINGAME1_l("ypl2", "Ending",	 "PASS/END.EXE",   "3e4f99800e0b401d31295726d71f601c", 4772023, Common::ZH_TWN, 403),

	// Full game is supported in ZVision engine
	WINDEMO1("znemesis", "Demo", "ZORKDEMO.EXE", "4a8fd0d74faef305bc935e1aac94d3e8", 712817, 400),

	WINDEMO1("zoombini", "Demo", "_ZOOMDAT.EXE", "d573b80bb932f50cbe69395b158e9f47", 696927, 404),
	WINDEMO1t("zoombini", "Demo", "ZOOMBINI.EXE", "fffa1e234005c89a366a4f5a3d82d34e", 4632551, 404),

//////////////////////////////////////////////////
//
// Macromedia Director v5
//
//////////////////////////////////////////////////

	// From Elmo's Art Workshop CD
	MACDEMO1("3datlas98", "Demo", "3D98DEMO", "231d3041df162be4a0ddd36a74eb03b6", 718357, 501),
	WINDEMO1t("3datlas98", "Demo", "3D98DEMO.EXE", "843fd6ad5664c9fcce2ee722f64b2991", 917511, 500),

	WINGAME1_l("a5tours", "", "A5TOURS.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410246, Common::JA_JPN, 501),

	// Run Windows installer (ASENNA.EXE) on Win9X extract 32-bit executable
	MACGAME1_l("aapelin1", "", "Aapelin ABC, 7-9 v", "231d3041df162be4a0ddd36a74eb03b6", 719261, Common::FI_FIN, 501),
	WINGAME1_l("aapelin1", "", "Aapeli32.exe", "3460ad87d2ba57104e2810a77b53c220", 1396675, Common::FI_FIN, 500),

	// GT Publishing, New York, ABCD-ROM series (1997)
	WINGAME1("abclunch", "", "ABC95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1421779, 501),

	// From Computer Buyer v17n68 (January 1997)
	WINDEMO1t("acaciarevise", "", "PCDEMO.EXE", "203616f3f18a0f2a1a326ac1f6944028", 943091, 501),

	WINGAME1t_l("acneattack", "", "Acne.exe", "9ec3d648c42e41cc2263d3c643d7ad1e", 1905311, Common::SE_SWE, 501),

	// Installers for both platforms also use Director
	MACGAME1("alcohol101", "", "Let's Party", "2d2ac01320f4c2dce8e156cda5c73fe8", 719289, 501),
	WINGAME2("alcohol101", "", "START95.EXE",  "1a7acbba10a7246ba58c1d53fc7203f5", 1411661,
							   "INTRO.DXR",	   "de5b5bbc9cc4659b3a6464efffd22fb9", 903418, 501),

	WINDEMO1_l("almabril98", "Demo", "DEMO AA98 START.EXE", "3460ad87d2ba57104e2810a77b53c220", 4180353, Common::PT_BRA, 500),

	// Mac version is D4
	WINGAME1("amber", "", "AMBER_JB.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1418103, 500),
	WINDEMO2t("amber", "Demo", "DEMO.EXE", "98f65233a8d80a75513267fed14c1e18", 1417811,
							   "AMBERHUB.DXR", "a95601f2521fd00c88ac424d66da1605", 868766, 501),

	MACGAME2_l("aozoragaho", "", "PPC", 	    "08166af62693ceab79b28d90d2f6c86b", 105571,
								 "BIRTH1.Dxr",  "323c3b8c0caed115a9c574b7aed4f0c4", 507450, Common::JA_JPN, 501),
	WINGAME2t_l("aozoragaho", "", "32.EXE",     "2787761ff8a943701c291da6e618310b", 1410721,
								  "BIRTH1.Dxr", "4d2206c4a02f720aafae108334a7880a", 507450, Common::JA_JPN, 501),

	// Original file names are ' ANKH2 ' and ' ANKH3 '
	MACGAME1_l("ankh2", "", "ANKH2", "779a44f65837ded641cc3fbbebe5ace1", 721432, Common::JA_JPN, 501),

	MACGAME1_l("ankh3", "", "ANKH3", "f715a3036c1b54ab1121e90388948018", 720456, Common::JA_JPN, 501),

	MACDEMO1("aptesampler", "", "Product Sampler", "aa6a527c1314eae56f00d9b9fb587683", 719033, 501),
	WINDEMO1t("aptesampler", "", "APTE32.EXE", "a42cd36dd6224f4382f676f946e48914", 1410355, 501),

	WINGAME1("arad", "", "arad95nt.exe", "3460ad87d2ba57104e2810a77b53c220", 2623135, 500),

	// Retail CD release from BeachWare, Inc.
	MACGAME1("arcade", "", "Classic Arcade", "3ecbe87870ab4b0c0acb10a9e22eb561", 705402, 500),
	WINGAME1t("arcade", "", "ARCADE.EXE", "4f7f250aeae7c255602855f42ad271ea", 925519, 501),

	// Available here: http://web.archive.org/web/20080412010505/http://www.beachware.com/download/
	// Each shareware title plays 1 of 2 arcade games until unlocked with registration code
	// All games are also available and unlocked on the retail BeachWare Classic Arcade CD
	MACGAME1("arcadeboing", "",	"Classic Arcade Boing!", "231d3041df162be4a0ddd36a74eb03b6", 719005, 501),
	WINGAME2("arcadeairattack", "", "shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Bomber.Dxr",	"e2409782f6bfa16862fba0437c9cdf3d", 3443518, 501),
	WINGAME2("arcadeboing", "",		"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Astro.Dxr",	"4378f9b78697520087e603856f0f2246", 1379858, 501),
	WINGAME2("arcadehockey", "",	"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Bumper.Dxr",	"696e88ec6cf6fd9a5c5422f91dd8608a", 681780, 501),
	WINGAME2("arcadelander", "",	"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Moon.Dxr",		"66102dd187a016df492c0657beeef3cc", 2008328, 501),
	WINGAME2("arcadesubs", "",		"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Caverns.Dxr",	"57bf22de8a2f1822e9259d4a3d8e3f5a", 3188250, 501),

	MACGAME1("arcmedia", "", "MAC.EXE",		"231d3041df162be4a0ddd36a74eb03b6", 716997, 501),
	WINGAME2("arcmedia", "", "WIN95.EXE",	"1a7acbba10a7246ba58c1d53fc7203f5", 1411325,
							 "000MAIN.DXR", "0fb364d9201b3b652f575282abb6ea16", 311662, 501),

	// Launcher, ' ATMOS ' in the root, is also Director
	MACGAME1_l("atmos", "", "mac/ATMOS", "4c38a51a21a1ad231f218c4786ff771d", 105599, Common::JA_JPN, 501),
	WINGAME1t_l("atmos", "", "ATMOS/ATMOS.EXE", "b9ce0053d4bf2570adfed84903734efa", 1410461, Common::JA_JPN, 501),

	WINGAME1("babesintoyland", "", "BABESIN.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411231, 501),

	MACGAME1("babylon5guide", "", "Babylon 5 Guided Tour", "06ed90580400cd9e263525f84c8075fd", 705445, 500),
	WINGAME2t("babylon5guide", "", "B5TOUR.EXE", "87f3188518ebf28da4db11334819cd63", 1410463,
								   "INTRO.DXR",  "0b5efb79490763ddb50f018eacba9f11", 1663348, 501),

	// At game start, choice of languages includes Finnish, Swedish, English, Danish
	// Developed by TATI Mixedia, Gothenburg, Sweden (1999); published locally by IQ Media Nordic, Stockholm
	WINDEMO1("backpackerjr", "Demo", "BPJDEMO.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1418681, 501),

	WINDEMO1t("backpackerjr", "Demo", "BPJDEMO.EXE", "8320e90992dffe88d21d39743ed7b89e", 1418643, 501),
	WINDEMO1t("backpackerjr", "Demo", "BPJDEMO.EXE", "8320e90992dffe88d21d39743ed7b89e", 1418681, 501),


	// Requires installation, installer is also Director
	WINGAME1_l("backpacker2", "", "BP2NEW.EXE", "842014a812b454620f64b860fd7211f0", 940821, Common::NB_NOR, 501),
	WINGAME1t_l("backpacker2", "", "BP2NEW.EXE", "8320e90992dffe88d21d39743ed7b89e", 1418983, Common::SE_SWE, 501),

	// BackPacker Junior - Multilingual version
	// Swedish, Norwegian, Danish, English
	MACGAME1_l("backpackerjr", "v1.1", "BackPacker Junior", "6e7e31d05709e1d38d63f4df6a59eec0", 718125, Common::EN_ANY, 501),
	MACGAME1_l("backpackerjrdiy", "v1.1", "xn--BPJ D.I.Y.-", "b861188374e80b1184e7f96dcab4fc9b", 718097, Common::EN_ANY, 501),
	WINGAME1t_l("backpackerjr", "v1.1", "BPJunior.exe", "8320e90992dffe88d21d39743ed7b89e", 1418697, Common::EN_ANY, 501),
	WINGAME1t_l("backpackerjrdiy", "v1.1", "DIY.exe", "8a71d255edf60f7e8a0641206da26fcc", 1467987, Common::EN_ANY, 501),
	// 2002 Win/Mac hybrid release published by Elävät Kirjat
	// Requires installation, Instdata{1,2,3,4}/install.exe, uses Vise
	MACGAME1_l("backpackerjr", "v1.1", "BP Juniori", "6f364c18bf735ea9034f1d0009e2df17", 705481, Common::EN_ANY, 500),
	MACGAME1_l("backpackerjrdiy", "v1.1", "xn--D.I.Y.-", "6f364c18bf735ea9034f1d0009e2df17", 705481, Common::EN_ANY, 500),
	WINGAME1t_l("backpackerjr", "v1.1", "BPJuniori.exe", "8320e90992dffe88d21d39743ed7b89e", 1418697, Common::EN_ANY, 501),
	WINGAME1t_l("backpackerjrdiy", "v1.1", "DIY.exe", "245511e514fac31b8a998c0a7806e59f", 1518587, Common::EN_ANY, 501),

	// Original filename is 'かわら盤Vol.03'
	MACGAME1_l("bandaipreviews3", "", "xn--Vol.03-953eurwbv611j", "33f733b2809b94c3301096902f642b6e", 292846, Common::JA_JPN, 402),

	// Based on the Australian TV children's TV series
	// Swedish released in association with Lattjo Lajban (1998)
	// Brazilian version was released on CD Expert Kids nº 19 (1999)
	WINGAME1("bananasfun", "",   "BIP32.EXE",      "1a7acbba10a7246ba58c1d53fc7203f5", 1410665, 501),
	MACGAME1_l("bananasfun", "", "It's Fun Time!", "07f19d8ae16dd1ffab68540c78fa0b8b", 719743, Common::PT_BRA, 501),
	MACGAME1_l("bananasfun", "", "It’s Fun Time!", "231d3041df162be4a0ddd36a74eb03b6", 719743, Common::SE_SWE, 501),

	// Original filename is 'バンド魂'
	MACGAME1_l("banddamashii", "", "xn--gdkn9hz648b", "2e75b0d7a218c71d5dd00a27eb755f00", 718756, Common::JA_JPN, 501),
	// Decomposed variant filename
	MACGAME1_l("banddamashii", "", "xn--2bka4l0a5pm493d", "2e75b0d7a218c71d5dd00a27eb755f00", 718756, Common::JA_JPN, 501),
	WINGAME1t_l("banddamashii", "", "BANDAMA.EXE", "aa0a9072ef442a0f996bd8884273857d", 1709856, Common::JA_JPN, 501),

	WINGAME1("barbssbubbles", "Screensaver", "BUBBLES.EXE", "77c85ac62fdb5a5f1ed40209ca88f78e", 1117695, 501),
	WINGAME1("barbsskisses", "Screensaver", "KISSES.EXE", "77c85ac62fdb5a5f1ed40209ca88f78e", 1145437, 501),
	WINGAME1("barbssshoes", "Screensaver", "SHOES.EXE", "77c85ac62fdb5a5f1ed40209ca88f78e", 1380835, 501),

	MACGAME1("battles", "", "BATTLES OF THE WORLD", "06ed90580400cd9e263525f84c8075fd", 705701, 500),
	WINGAME1("battles", "", "BT_INT32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1400693, 500),

	MACGAME2("biblechamps", "", "Startup", "ebae3c8021827b2d88f1a0297167415f", 1030114,
								"INTRO.dxr", "09a572dd9a5346708a529eaa3a0df400", 432698, 500),
	WINGAME2("biblechamps", "", "Start32.EXE", "ecf9a4bf5fa21a6918b8c2a26fbe500a", 1508419,
								"INTRO.dxr", "09a572dd9a5346708a529eaa3a0df400", 432698, 500),

	WINGAME1_l("bigmax", "nº10", "BIG32.EXE", "3460ad87d2ba57104e2810a77b53c220", 4539109, Common::PT_BRA, 500),

	MACGAME1("blam3", "", "  BLAM!3ppc.prj", "8a093239a2bbfd73269bc70f873c69b8", 106887, 501),

	MACGAME1("blender", "Volume 2.5", "Blender (PPC)",	   "f102e699371fd85eaf57606a1c0b1adc", 94329, 501),
	MACGAME1("blender", "Volume 3.1", "Blender (PPC)",	   "013ce52c2d8fa0f004fe6d1118448a58", 108119, 501),
	WINGAME2("blender", "Volume 2.5", "BLENDME.EXE",	   "2e62abdad839e42068afdcd0644d7dcf", 949909,
									  "FILES/OPENING.DIR", "45cb69d7174a3f93d54e9a5ee1fb9f3b", 2274768, 500),
	WINGAME1("blender", "Volume 3.1", "LNCHR_32.EXE",	   "1a7acbba10a7246ba58c1d53fc7203f5", 1421431, 501),

	// Designed by In Chair Viewing (ICV)
	// Binaries provided for Win3.1, Win95, WinNT
	WINGAME1("bluesbros2000", "Windows 95", "Blues95.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410935, 501),
	WINGAME1("bluesbros2000", "Windows NT", "BluesNT.exe", "842014a812b454620f64b860fd7211f0", 932773, 501),

	MACGAME1("browser", "", "Artropolis 97 (PPC)", "b6618c98b209ba70ed7ae7e85e7306ef", 107863, 501),
	WINGAME1("browser", "", "Artropolis 97.exe", "3460ad87d2ba57104e2810a77b53c220", 1394247, 501),

	MACGAME1("bvi1997", "", "BVI", "c148f66ae3511fb88733102aa27efe7e", 718353, 501),
	WINGAME1("bvi1997", "", "BVI95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 9097249, 501),

	// Bilingual English and French
	MACGAME1("canelect", "", "Elect", "6e7e31d05709e1d38d63f4df6a59eec0", 719289, 501),
	WINGAME1("canelect", "", "ELECT_95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1479345, 501),

	// Available here: http://web.archive.org/web/20080412010505/http://www.beachware.com/download/
	// Each shareware title plays one of several casino games until unlocked with registration code
	// The games are also available and unlocked on various retail CDs from BeachWare
	WINGAME2("casinoblackjack", "",	"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Black.Dxr",	"c934d66f73149927ce9842ac3b6a6219", 433022, 501),
	WINGAME2("casinokeno", "",		"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Keno.Dxr",		"229860fdf77f1d92da7ca23535393597", 314064, 501),
	WINGAME2("casinopoker", "",		"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Draw.Dxr",		"56f8b8fa6324b2abc16eafa8aa6ba403", 489404, 501),
	WINGAME2("casinoslots", "",		"shware32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427,
									"Quarters.Dxr",	"4b91f3fa860cd4de3b0aa167f3afdff3", 527618, 501),

	MACGAME1("cassandra", "", "The Cassandra Galleries", "231d3041df162be4a0ddd36a74eb03b6", 718353, 501),
	WINGAME1("cassandra", "", "GOWIN32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 2083273, 501),

	MACGAME1("cezanne", "", "CEZANNE", "8e171256e4811dc976720da230634d87", 705689, 500),
	WINGAME1("cezanne", "", "CEZWIN95.EXE", "3460ad87d2ba57104e2810a77b53c220", 2763107, 500),

	WINGAME1t_l("choroli", "", "The trip of choroli.exe", "de072eb89068861c64d8abf08b70d29d", 4452460, Common::JA_JPN, 501),

	MACDEMO1_l("christmassmallhouse", "Demo 1", "Demo Xmas",    "552992fb31c736ca67ffd403096596d6", 719604, Common::JA_JPN, 500),
	WINDEMO1t_l("christmassmallhouse", "Demo 1", "DEMOXMAS.EXE",    "e64f9a6a2a78de2ed6e73498237f422b", 1411640, Common::JA_JPN, 501),
	MACDEMO1_l("christmassmallhouse", "Demo 2", "Demo Xmas",    "c148f66ae3511fb88733102aa27efe7e", 719636, Common::JA_JPN, 501),
	WINDEMO1_l("christmassmallhouse", "Demo 2", "X_demo.exe",    "2535f11350bc1f2b7ca2dcc6c0cdddfd", 1411520, Common::JA_JPN, 501),

	// Bundled with the game itself
	MACDEMO1_l("christmassmallhouse", "Demo 3", "Demo Xmas",    "552992fb31c736ca67ffd403096596d6", 719625, Common::JA_JPN, 500),
	WINDEMO1t_l("christmassmallhouse", "Demo 3", "DEMOXMAS.EXE",    "65f7ded3e5015879e5279fbd004c3978", 1411610, Common::JA_JPN, 501),

	MACGAME1_l("christmassmallhouse", "", "Small Xmas",    "552992fb31c736ca67ffd403096596d6", 719617, Common::JA_JPN, 500),
	WINGAME1t_l("christmassmallhouse", "", "XMAS.EXE",    "f3e3c481eb26507c6ce59a487c005e8c", 1411646, Common::JA_JPN, 501),

	// Original filename is 'チュウチュウたたき'
	MACGAME1_l("chuchutataki", "", "xn--w8j9aa6za4nb00ac",    "c148f66ae3511fb88733102aa27efe7e", 106172, Common::JA_JPN, 501),
	WINGAME1t_l("chuchutataki", "", "TYUUTYUU.EXE",    "bfb442750a6a264825fac3cc12a69d71", 1411220, Common::JA_JPN, 501),

	// Series includes Schubert, Tchaikovsky, Mozart, Vivaldi and probably more
	WINGAME1_l("clasplusbee2", "", "BEE2_95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1694421, Common::ES_ESP, 501),

	// Clocks from Let's Play with Sakura CD
	// Windows versions are D6
	// Original filenames follow the entries on each line
	MACGAME1_l("clockkero", "",	  "Kero Tokei",	  "65063397536553c4f6ff2a6c07194bf7", 1602707, Common::JA_JPN, 500), // ケロ時計
	MACGAME1_l("clocksakura", "", "Sakura Tokei", "65063397536553c4f6ff2a6c07194bf7", 1602709, Common::JA_JPN, 500), // さくら時計
	MACGAME1_l("clocktomoyo", "", "Tomoyo Tokei", "65063397536553c4f6ff2a6c07194bf7", 1602707, Common::JA_JPN, 500), // 知世時計

	// Launcher uses Director 6 and Authorware
	// Developed by Arome Interactive, distributed by Global Star Software
	// Requires installation, DATA.Z, InstallShield v3
	WINGAME1t("cocktailhour", "", "COCKT32.EXE", "f594dd4e50ea175e8d3453b3cd16b536", 1411465, 501),

	MACGAME1("colormind", "v1.5", "ColorMind 1.5", "37faaf693259d7a4fa031f4a2edf3098", 126087, 501),

	WINGAME2t("cracking", "", "crack.exe", "c2093c2b5dc9d3dc5b491e4df027e202", 1842361,
							  "ufog8.dxr", "7c8222a010d40b59dd96a97f0b4fa974", 542472, 500),

	MACGAME1_l("crusader", "", "Croisades", "6e7e31d05709e1d38d63f4df6a59eec0", 718381, Common::FR_FRA, 501),
	WINGAME1("crusader", "", "CRUSAD95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427, 501),
	WINGAME1_l("crusader", "", "KREUZZ95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427, Common::DE_DEU, 501),
	WINGAME1_l("crusader", "", "CROISA95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1410427, Common::FR_FRA, 501),

	// Mac version requires installation, Crystal Skull Installer, uses VISE
	// 3 CDs, executables are only on CD 1
	MACGAME1("crystalskull",  "", "Crystal Skull", "c148f66ae3511fb88733102aa27efe7e", 719459,  501),
	WINGAME1t("crystalskull", "", "CRYS32.EXE",	   "3f5fd025e808943e1fa9b91ce63ef9b7", 1410495, 501),

	WINGAME2("davidsonps", "v1.0", "DPS32.EXE",	  "3460ad87d2ba57104e2810a77b53c220", 1401517,
								   "DPSHOT.DXR",  "d980c9272bc723c57238a31790b71f11", 1354686, 500),
	// Developed by Wag the Dog Productions
	MACDEMO1("davidsonps", "v2.0L", "DPS v2.0", "9fbd2e99a6a23933083ba0934e4a7d01", 705417, 500),
	WINDEMO1t("davidsonps", "v2.0L", "DPS2032.EXE", "7c325424b7deb932de6f080dc6c9b8e6", 1425025, 501),
	{
		{
			"davidsonps", "CD",
			AD_ENTRY2s("DPS32.EXE",	 "3460ad87d2ba57104e2810a77b53c220", 1401517,
					   "DPSHOT.DXR", "08b944be3cccdbbe3646fce08f2780f0", 1357970),
			Common::EN_ANY,
			Common::kPlatformWindows,
			ADGF_CD | SUPPORT_STATUS,
			GUIO1(GUIO_NOASPECT)
		},
		GID_GENERIC,
		500
	},

	// Mini-game from Star Warped can also be launched separately
	MACGAME1("deathstar", "Minigame", "Death Star Destructo", "11aea1c6868839f53cc6312df724364f", 107835, 501),
	WINGAME1t("deathstar", "Minigame", "DSD32.EXE", "9e3c304fdd669c79b5670057557cd1fb", 2758841, 501),

	// From MacFormat #42
	MACGAME1("digihbd", "", "Digital Happy Birthday Card", "61f3e061ae6236d8f72312ae9de83f46", 703153, 500),

	// Windows executables for Win 3.1 and 95; Mac executables for 68k, PPC, and Fat binary
	MACGAME1("dimensionq", "", "Dimension Q", "c148f66ae3511fb88733102aa27efe7e", 719313, 501),
	WINGAME1("dimensionq", "", "DIMENQ95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1416041, 501),
	MACDEMO1("dimensionq", "Trailer", "Dimension Q Trailer", "08d6f6e39fbd8388faf57f602acaebcc", 705702, 500),
	WINDEMO1("dimensionq", "Trailer", "DIMQ95.EXE", "3460ad87d2ba57104e2810a77b53c220", 6877089, 500),

	MACGAME1("dinos", "", "Dinos", "231d3041df162be4a0ddd36a74eb03b6", 718285, 500),
	WINGAME1("dinos", "", "DINO98.EXE", "3460ad87d2ba57104e2810a77b53c220", 1393813, 500),

	MACGAME1_l("djrom", "", "DJ-ROM", "4a3fc901992d82fa2197da9da1be6992", 107572, Common::JA_JPN, 501),
	WINGAME1_l("djrom", "", "DJROM.exe", "38b75ecdedf662326fe4931a68ae60cd", 1823050, Common::JA_JPN, 501),

	// Each file is a standalone animation contained; there's no launcher
	// Japanese/English bilingual
	// Mac version includes a few extra items not in the Windows version
	MACGAME1("delaware", "Color Cycletoon", "Color_Cycletoon", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "blue nude ll", "blue_nude_ll", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "esg", "esg", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "let's go human being", "let's_go_human_being", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "the venus of milo", "the_venus_of_milo", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "computer in love", "computer_in_love", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "mona lisa", "mona_lisa", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "walk, don't run", "walk,_don't_run", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "sharaku", "sharaku", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "too much too toon", "too_much_too_toon", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "identity", "identity", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "the thinker", "the_thinker", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "never mind the bollocks", "never_mind_the_bollocks", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "composition", "composition", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "duchamp", "duchamp", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "help!", "help!", "2f2af9379a930c8e31bee14e31925477", 108480, 501),
	MACGAME1("delaware", "umbrella", "umbrella", "2f2af9379a930c8e31bee14e31925477", 108480, 501),

	WINGAME1t("delaware", "blue nude ll", "01blue_nude_ll.exe", "24ae70cc3ccf728d79a9b93440ea75c1", 2445488, 501),
	WINGAME1t("delaware", "esg", "02esg.exe", "5f54b8c25fd333d5b4138cd1bc381f79", 7492550, 501),
	WINGAME1t("delaware", "let's go human being", "03let's_go_human_being.exe", "7fa9aa902fd41f4551868ef48318d51a", 7601274, 501),
	WINGAME1t("delaware", "the venus of milo", "04the_venus_of_milo.exe", "f1e0bb37b7a849adbb65b86b9fe3da4a", 2591210, 501),
	WINGAME1t("delaware", "computer in love", "05computer_in_love.exe", "a25a48014f94ef766b72c9f11c42f4f6", 8343178, 501),
	WINGAME1t("delaware", "mona lisa", "06mona_lisa.exe", "b540c878a1ff40e8e470c0f0cf3e4f70", 2602166, 501),
	WINGAME1t("delaware", "walk, don't run", "07walk,_don't_run.exe", "7105141c4ee3392d237548ba18ca19f1", 2460152, 501),
	WINGAME1t("delaware", "sharaku", "08sharaku.exe", "cb240f3be19a4b120fc37881bbeb1e7a", 2501974, 501),
	WINGAME1t("delaware", "too much too toon", "09too_much_too_toon.exe", "ce1e5dcda3913aef0b0fa70cdd2bb1d9", 2546746, 501),
	WINGAME1t("delaware", "identity", "10identity.exe", "c44ddbf87e1f8503ca0a7fa9c9a21f22", 2404758, 501),
	WINGAME1t("delaware", "the thinker", "11the_thinker.exe", "b12c52cb1ed6bf9658ee0f0d44ce9f6b", 8498468, 501),
	WINGAME1t("delaware", "never mind the bollocks", "12never_mind_the_bollocks.exe", "bf6759ac50902409d53691d028705570", 2693444, 501),

	// Other versions are D4
	MACGAME1_l("draculassecret", "", "Dracula.PPC", "65f0701cced8f5c64813e1e0353f0510", 108119, Common::FR_FRA, 501),

	// Published by Bibliographisches Institut & F.A. Brockhaus AG
	// Contains previews for:
	// - Mein erstes Lexikon
	// - Das Wunder unseres Körpers
	// - Wie funktioniert das?
	// - Das Flaggschiff des Königs
	// Mac filename is "Duden/Meyer MM"
	MACGAME1_l("dudenmeyer", "", "xn--DudenMeyer MM-ta40e", "06ed90580400cd9e263525f84c8075fd", 704509, Common::DE_DEU, 500),
	WINGAME1t_l("dudenmeyer", "", "DUDMEY.EXE", "e838d14566480d75a674e6e94b736088", 1094419, Common::DE_DEU, 501),

	// Win version on same discs is D6
	MACGAME1("dynamichuman", "v2.0", "Dynamic Human 2.0", "bfd348abd981acae64c13d5e5e4d9540", 718353, 501),

	MACGAME1("easybass", "", "Bass",		"231d3041df162be4a0ddd36a74eb03b6", 719261, 501),
	WINGAME2("easybass", "", "WIN95.EXE",	"1a7acbba10a7246ba58c1d53fc7203f5", 1411387,
							 "322MAIN.DXR", "5f66f50a682be582b7b88444945b45df", 1007992, 501),

	MACGAME1("edmark", "", "Edmark Demo", "d0f3aedb1f7c46853243b6a560440dd7", 705613, 500),
	WINGAME2("edmark", "", "DEMO.EXE",	  "2e62abdad839e42068afdcd0644d7dcf", 917547,
						   "MAININT",	  "1e995592236894b843c3853906bbee1d", 2935876, 500),

	// Original Mac filename is 江口寿史
	MACGAME1_l("eguchi", "", "xn--6or4a778bbur", "552992fb31c736ca67ffd403096596d6", 719653, Common::JA_JPN, 501),
	WINGAME1_l("eguchi", "", "EGU32.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410078, Common::JA_JPN, 501),

	MACGAME1_l("epson96", "", "EPSON'96", "c7de2891be2a39e6552807db386faae6", 703181, Common::JA_JPN, 500),
	WINGAME1t_l("epson96", "", "EPSON96.EXE", "f535d4df97b64fcefa85667ce59012de", 2264365, Common::JA_JPN, 500),

	MACGAME1_l("ernie", "", "Ernie (PPC)", "4c38a51a21a1ad231f218c4786ff771d", 106955, Common::SE_SWE, 501),
	WINGAME1t_l("ernie", "", "Ernie.exe", "5b5c34933594af422baa9344b07e0b6a", 1417481, Common::SE_SWE, 501),
	WINDEMO1_l("ernie", "Demo", "ERNIE.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1417371, Common::SE_SWE, 500),

	// "Explore Space" 5 CD Bundle
	MACGAME2("explorespace1", "", "Solar",				 "231d3041df162be4a0ddd36a74eb03b6", 719005,
								  "PROGRAM/456MAIN.Dxr", "c6ce20cd8a95fd88aee9fabe8987aee6", 375330, 501),
	WINGAME2("explorespace1", "", "WIN95.EXE",			 "1a7acbba10a7246ba58c1d53fc7203f5", 1411387,
								  "PROGRAM/456MAIN.DXR", "c6ce20cd8a95fd88aee9fabe8987aee6", 375330, 501),

	MACGAME2("explorespace2", "", "Mars",				 "231d3041df162be4a0ddd36a74eb03b6", 719005,
								  "PROGRAM/457MAIN.Dxr", "9bb4f9407e4658f50ae970fc0a5133a6", 435968, 501),
	WINGAME2("explorespace2", "", "WIN95.EXE",			 "1a7acbba10a7246ba58c1d53fc7203f5", 1411387,
								  "PROGRAM/457MAIN.DXR", "9bb4f9407e4658f50ae970fc0a5133a6", 435968, 501),

	MACGAME2("explorespace3", "", "Sun_Moon",			 "231d3041df162be4a0ddd36a74eb03b6", 719005,
								  "PROGRAM/458MAIN.Dxr", "78244a687f279eda8655ac9fd7ce5531", 531620, 501),
	WINGAME2("explorespace3", "", "WIN95.EXE",			 "1a7acbba10a7246ba58c1d53fc7203f5", 1411387,
								  "PROGRAM/458MAIN.DXR", "78244a687f279eda8655ac9fd7ce5531", 531620, 501),

	MACGAME2("explorespace4", "", "Galaxy",				 "231d3041df162be4a0ddd36a74eb03b6", 719005,
								  "PROGRAM/460MAIN.Dxr", "4212a73dc3482104192ad4f0937446cf", 275180, 501),
	WINGAME2("explorespace4", "", "WIN95.EXE",			 "1a7acbba10a7246ba58c1d53fc7203f5", 1411387,
								  "PROGRAM/460MAIN.DXR", "4212a73dc3482104192ad4f0937446cf", 275180, 501),

	MACGAME2("explorespace5", "", "Space",				 "231d3041df162be4a0ddd36a74eb03b6", 719005,
								  "PROGRAM/459MAIN.Dxr", "3868e98be38c2fbff814e2b8f1663fc9", 376868, 501),
	WINGAME2("explorespace5", "", "WIN95.EXE",			 "1a7acbba10a7246ba58c1d53fc7203f5", 1411387,
								  "PROGRAM/459MAIN.DXR", "3868e98be38c2fbff814e2b8f1663fc9", 376868, 501),

	// Developed by Brilliant Interactive Ideas, published by Brainstorm
	MACGAME1("flipper", "", "Flipper!",	  "6e7e31d05709e1d38d63f4df6a59eec0", 718381, 501),
	WINGAME1("flipper", "", "FLIP32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1398201, 500),

	MACDEMO1("fplit", "Demo", "Toyland Preview", "9fbd2e99a6a23933083ba0934e4a7d01", 705417, 500),

	WINDEMO1t("fpready", "Demo", "FPRFS32.EXE", "b976d39fa7f7cf18a05149b5593f43e0", 2901579, 501),

	// ©1996 Davidson & Associates, Inc.
	MACGAME1("fpreadyp", "", "Ready for Preschool", "231d3041df162be4a0ddd36a74eb03b6", 719022, 501),
	WINGAME2t("fpreadyp", "", "PRE32/START32.EXE", "564db7e9ffacb6c0fecbf83c1f988069", 1394437,
							  "FILES/INTRO.DIR",   "7272848176803ae06bcbc930a1177175", 3043164, 501),
	MACDEMO1("fpreadyp", "Preview v1.0", "RFPS Preview", "06ed90580400cd9e263525f84c8075fd", 705417, 500),
	WINDEMO2t("fpreadyp", "Preview v1.0", "START32.EXE", "5308d6298ee641b15c9b4e5b282e4f25", 1396105,
										  "PSSTART.DIR", "38e260d5cab3aba21f800216025e5cae", 25276, 501),

	MACGAME1("frankac", "", "Franklin's Activity Center", "06ed90580400cd9e263525f84c8075fd", 705445, 500),
	WINGAME2("frankac", "",	  "NAVIGATE.EXE", "2e62abdad839e42068afdcd0644d7dcf", 917643,
							  "NAVIGATE.DXR", "01549a16ecc542ead343bb2ed8ebf604", 3303124, 500),
	WINGAME2_l("frankac", "", "NAVIGATE.EXE", "2e62abdad839e42068afdcd0644d7dcf", 917643,
							  "NAVIGATE.DXR", "edeb8f86c0579a44f8163a135a30dd90", 4062902, Common::PT_BRA, 500),

	MACDEMO1("franklm", "Demo", "xn--Franklin Learns Math Info.-", "f637b7b88b82c0772082f84a0b2cf628", 705417, 500),
	WINDEMO1("franklm", "Demo", "FLMINFO.EXE", "2e62abdad839e42068afdcd0644d7dcf", 1119725, 500),

	// Other versions are D3
	PIPGAME1("gadget", "", "GADGET", "d7e907d3933869f055ae59774c87f501", 111000, 501),

	MACGAME1("gadgetpaf", "",	"GADGET -Past as Future- (Disc1)", "3b96e0a903130cf68e6f8362bb4d096c", 178907, 501),
	MACGAME1_l("gadgetpaf", "", "GADGET -Past as Future- (Disc1)", "4b2213a9fb04f390ec074c54b916370d", 113169, Common::JA_JPN, 501),
	WINGAME2("gadgetpaf", "",	"GADGET.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411507,
								"TEXT_E.Cxt", "5f14330705974a22deb9a12cd8ae6e79", 691046, 501),
	WINGAME2_l("gadgetpaf", "", "GADGET.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411507,
								"TEXT_E.Cxt", "056ab5419f65fab51fa50c28ad360e76", 561824, Common::ES_ESP, 501),

	MACGAME1("gamingmegapac", "", "Gaming MegaPac", "b861188374e80b1184e7f96dcab4fc9b", 719005, 501),

	MACGAME1_l("gasbook", "", "VOL1_10M", "5a97d1b69b1cac7dd335c32a297c281b", 742542, Common::JA_JPN, 501),
	WINGAME1t_l("gasbook", "", "GAS32.EXE", "cc7b111dfaa7c7534c21b7bde144fa03", 1407638, Common::JA_JPN, 501),

	MACGAME1_l("gasbook2", "", "GASBOOK 2", "73b69ba46fc63ad964cd7119e7f04c1b", 723046, Common::JA_JPN, 501),

	// Creators make heads to be used in the full games
	MACGAME1("getaheadmath", "",	"Math Heads (PPC)",	  "b6618c98b209ba70ed7ae7e85e7306ef", 107473, 501),
	MACGAME1("getaheadstrat", "",	"Strategy Heads",	  "f5d1590da086b496507871f12382e973", 719456, 501),
	WINGAME1("getaheadmath", "",	"MATHHD32.EXE",		  "6860e78189ba90c10a46c31d8069fc5f", 1412189, 501),
	WINGAME1("getaheadstrat", "",	"STRATEGY.EXE",		  "3fbb58682d34ce5ec8b774064725b172", 1412265, 501),
	MACGAME1("getaheadmathcr", "",	"Math Heads Creator", "f5d1590da086b496507871f12382e973", 719289, 501),
	MACGAME1("getaheadstratcr", "",	"Creator",			  "f5d1590da086b496507871f12382e973", 719271, 501),
	WINGAME1("getaheadmathcr", "",	"CREATE32.EXE",		  "3fbb58682d34ce5ec8b774064725b172", 1410627, 501),
	WINGAME1("getaheadstratcr", "",	"CREATOR.EXE",		  "3fbb58682d34ce5ec8b774064725b172", 1412265, 501),

	MACGAME1("ghetto", "", "Ghetto 8MB", "35dbf55e70f69e00ca016e3663379970", 704793, 500),
	WINGAME1("ghetto", "", "GHETTO.EXE", "2e62abdad839e42068afdcd0644d7dcf", 917597, 500),

	MACGAME1("giggletour", "", "World Tour", "35dbf55e70f69e00ca016e3663379970", 705681, 500),
	WINGAME1("giggletour", "", "WRLDTR32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1393973, 500),
	MACDEMO1("giggletour", "Trailer", "World Tour Trailer", "08d6f6e39fbd8388faf57f602acaebcc", 705673, 500),
	WINDEMO1("giggletour", "Trailer", "WRLD95.EXE", "3460ad87d2ba57104e2810a77b53c220", 4262595, 500),

	// Original filename is 'たむらしげる原画集クジラの跳躍'
	MACGAME2_l("glassyocean", "", "xn--18jjx6d7d8bq20axc8y5662a7j1dsf3cv0b8v9c", "8f4da7096fa8725ad3ed3153811c9e38", 719664,
								  "DATA/TAMURA.Dxr", "401a9dcb7a3d874bc3798bdef929ead2", 155168, Common::JA_JPN, 501),  // unconfirmed
	MACGAME2_l("glassyocean", "", "xn--18jjx6d7d8bq20axc8y5662a7j1dsf3cv0b8v9c", "285baf96a2c5333603f23e3ff8ef7940", 4718,
								  "DATA/TAMURA.Dxr", "401a9dcb7a3d874bc3798bdef929ead2", 155168, Common::JA_JPN, 501),
	// Decomposed variant
	MACGAME2_l("glassyocean", "", "xn--08jlx6d7d8bq5ib3t8cv3a0327avlsefrrdo9bit3d", "285baf96a2c5333603f23e3ff8ef7940", 4718,
								  "DATA/TAMURA.Dxr", "401a9dcb7a3d874bc3798bdef929ead2", 155168, Common::JA_JPN, 501),
	WINGAME2t_l("glassyocean", "", "START.EXE",		  "c5dcc03aca7e0bed95844afdd86f866c", 1410529,
								   "DATA/TAMURA.DXR", "a7bd15f6f42162fed7f32e0a739617ec", 155168, Common::JA_JPN, 501),

	// Green Eggs and Hamulator mini-game
	// Demo for a Living Books game that is supported in MOHAWK engine
	// Found on Disc Inferno from APC magazine (Australia), Dec 1999
	WINDEMO1("greeneggs", "Demo", "seuss95.exe", "3460ad87d2ba57104e2810a77b53c220", 2555603, 500),

	// Demo is from the covermount of Joystick (France) N°77 Dec 1996 (CD-ROM Collection N°19)
	MACGAME1_l("guignols2", "", "Le Cauchemar de PPD", "f3817a8eca9efb143a23b76525dedfa9", 718381, Common::FR_FRA, 501),
	WINGAME1_l("guignols2", "", "CPPD.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1465338, Common::FR_FRA, 501),
	WINDEMO1_l("guignols2", "Demo", "GUIGNOLS.EXE", "2e62abdad839e42068afdcd0644d7dcf", 971988, Common::FR_FRA, 501),

	MACGAME2("gundam0079", "",   "Gundam0079",	   "4c38a51a21a1ad231f218c4786ff771d", 106955,
								 "MENU.CST",	   "d4de2296fc46f76cc249b0a1d01e7003", 3580645, 501),
	MACGAME2_l("gundam0079", "", "GUNDAM0079",	   "4c38a51a21a1ad231f218c4786ff771d", 106955,
								 "MENU.Cxt",	   "730d60b0f5fbc925a01b04319c50e59d", 2862062, Common::JA_JPN, 501),
	WINGAME1t("gundam0079", "",  "Gundam0079.exe", "ad9789b126467a250480581b671a4385", 1411761, 501),

	MACGAME1("gussshc", "", "Write On", "9e9309ff1b58f6b56a440893e9723bd6", 705585, 500),
	WINGAME1("gussshc", "", "SCHOOL.EXE", "2e62abdad839e42068afdcd0644d7dcf", 917645, 500),

	// Sourced from Dimension Q disc
	MACGAME1("headbone", "Sampler 2", "Sampler 2",	 "35dbf55e70f69e00ca016e3663379970", 705671, 500),
	WINGAME2("headbone", "Sampler 2", "SAMPLER.EXE", "c3c38bd3907ca7e13220b74bd0317a6c", 1019877,
									  "DEMOS.DXR",	 "d8c086a6879d092b409110f9bf5b93de", 3016920, 500),

	// From MacFormat #42, original file name 'HeadHunter™'
	MACGAME1("headhunter", "", "xn--HeadHunter-398e", "315c637cac0a4b735dc6e3f7cb1842f7", 721143, 500),

	// Hoffman + Associates previews. Found on Nikolai in Outer Space.
	WINGAME1("hoffman", "", "HARUNNER.EXE", "3460ad87d2ba57104e2810a77b53c220", 1458773, 500),

	// Later Win demo found on Math Heads CD
	MACDEMO1("hollywoodhigh", "Demo", "Hollywood Hot Shot", "3ecbe87870ab4b0c0acb10a9e22eb561", 705674, 500),
	WINDEMO1("hollywoodhigh", "Demo", "HOTSHOT.EXE", "2e62abdad839e42068afdcd0644d7dcf", 9949661, 500),
	WINDEMO1("hollywoodhigh", "Demo", "HOTSHOT.EXE", "5b056b97e60209a45665e27ff39d8010", 10066133, 501),

	// Win version must be installed in 32-bit Windows to extract executable
	WINGAME2_l("horrortour3", "", "HT3.exe", 	"3460ad87d2ba57104e2810a77b53c220", 5128359,
								  "Asm001.dir", "d67f5146ef071f8a1e074383659fc9b0", 249634, Common::JA_JPN, 500),
	MACGAME1_l("horrortour3", "", "HT3", "b545372e9f6e9351d4119af9258d8de0", 108736, Common::JA_JPN, 500),

	WINGAME1t_l("humanbody", "", "ANIM.EXE", "10883c886da86bd2359a60c689d106a7", 1709290, Common::JA_JPN, 501),
	WINGAME1t_l("humanbody", "Credits", "CREDIT.EXE", "eac7ab84229508620f59bca0873da513", 1813181, Common::JA_JPN, 501),
	WINGAME1t_l("humanbody", "Save da Vinci", "SAVE_DV.EXE", "d5e1ffdb93d1624d469ce7574ec92727", 1410848, Common::JA_JPN, 501),

	// Distributed with IBM Aptiva PCs
	WINGAME2("ibmcdextra", "", "SAMPLER.EXE", "2e62abdad839e42068afdcd0644d7dcf", 929109,
							   "TOADMM.DIR",  "b67c1bd97094091404ed1cde88279880", 2573710, 500),

	// Installers for both platforms also use Director
	MACGAME1_l("incarnatia", "", "incarnatia_PowerMac", "2e7d373f75c014be20cfb04c5cd65dae", 108480, Common::JA_JPN, 501),
	WINGAME1_l("incarnatia", "", "incarnatia_Win.exe", "38b75ecdedf662326fe4931a68ae60cd", 1414152, Common::JA_JPN, 501),

	// Australian Broadcasting Corporation (ABC) has made this available for free download
	// https://www.abc.net.au/science/ingenious/patch.htm
	MACGAME1("ingenious", "",	 "Ingenious",	"f5d1590da086b496507871f12382e973", 754577,	 501),
	WINGAME1t("ingenious", "",	 "INGW95.EXE",	"706038517a38b3b61f04ee783bcbfe78", 1398293, 501),
	MACGAME1("ingenioused", "",	 "EdRes",		"f5d1590da086b496507871f12382e973", 754551,	 501),
	WINGAME1t("ingenioused", "", "EdRes95.exe",	"ed161f0dbe88c909dac7f10535c340ad", 1417113, 501),
	// from "Patch for Windows 2000 and Windows XP"
	WINGAME1t("ingenious", "",	 "IngW95.exe",	"2c210cc563d5562741b34fb6156e37c3", 1414789, 501),

	// Later releases are titled "I Spy School Days"
	// Bilingual Spanish/English release by Star E-Media of Orange County, California
	MACGAME1("ispy", "",	  "Play I Spy",	 "6e7e31d05709e1d38d63f4df6a59eec0", 719289, 501),
	MACGAME1("ispy", "Star",  "I Spy",		 "6e7e31d05709e1d38d63f4df6a59eec0", 719338, 501),
	MACGAME1_l("ispy", "",	  "Veo, Veo",	 "83bbffe673e902df8fa3e99067f73cb0", 704745, Common::ES_ESP, 500),
	WINGAME1("ispy", "",	  "Ispy95.exe",	 "1a7acbba10a7246ba58c1d53fc7203f5", 1443421, 501),
	WINGAME1_l("ispy", "",	  "veo-veo.exe", "3460ad87d2ba57104e2810a77b53c220", 1433357, Common::ES_ESP, 500),
	WINGAME1_l("ispy", "",	  "Ispy95.exe",	 "1a7acbba10a7246ba58c1d53fc7203f5", 1437966, Common::RU_RUS, 501),

	// Original filename is Internet The City™
	MACGAME1("itc", "", "Internet The City", "4ab012350c6e1c39eda772e33df30cea", 719289, 501),

	// Later released as Jewels II: The Ultimate Challenge
	MACDEMO1("jewels2", "Demo", "Jewels II", "231d3041df162be4a0ddd36a74eb03b6", 719261, 501),
	WINGAME1("jewels2", "", "JewsII95.exe", "3460ad87d2ba57104e2810a77b53c220", 1454223, 500),

	WINGAME1t_l("jinseiproresu", "", "JINPRO32.EXE", "1edfa12f4560c0bd105a9497ed2f0188", 1388043, Common::JA_JPN, 500),

	MACGAME1("jslearn", "1997 D5 Demo", "JumpStart Previews", "231d3041df162be4a0ddd36a74eb03b6", 718745, 501),
	WINGAME1("jslearn", "1997 D5 Demo", "PREV32A.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411155, 501),

	WINDEMO1t_l("kamennoyakata", "Autodemo", "KAMEN.EXE", "caf065869e9d30a6e6672312eae0790a", 1431020, Common::JA_JPN, 501),

	// Multi-disc game but the executable is only on disc 1
	MACGAME1_l("keroncuel", "", "keron folder/KERONCUEL", "8f4da7096fa8725ad3ed3153811c9e38", 719664, Common::JA_JPN, 501),
	WINGAME1t_l("keroncuel", "", "KERONFOL/KERONCUE.EXE", "4bf5fa422a92233d03280dfb30df4ed9", 1418708, Common::JA_JPN, 501),

	// Bilingual English/Japanese
	MACGAME1("llla", "",	  "LLLA",	 "f808a9f231b77617fa559cf9d2da66c1", 304804, 501),
	WINGAME1("llla", "",	  "LLLA_PC.EXE",	 "3646e2d759d305f25dc7b65970e1024e", 603678, 501),

	// Requires installation
	// Windows files in DATA.1 (renamed InstallShield v3 archive)
	// Mac files in Life in the Universe Installer
	WINGAME2t("lifeuniverse", "Compact", "SWHLife.exe", "b2fa91f178adc1f393267d5dfe0089e0", 1394457,
										 "LU_main.Dxr", "17dc83fcb87914cc55cfe3a6b6104dca", 23921856, 500),
	WINGAME2t("lifeuniverse", "Full", "SWHLife.exe", "b2fa91f178adc1f393267d5dfe0089e0", 1394457,
									  "LU_main.Dxr", "b3a548cd57f5129afac208e24463fa1d", 13234768, 500),
	MACGAME2("lifeuniverse", "Compact", "Start Life (PPC)", "cf7d00bbabf0e5476195616940febf05", 104815,
										"LU_main.Dxr", "17dc83fcb87914cc55cfe3a6b6104dca", 23921856, 501),
	MACGAME2("lifeuniverse", "Full", "Start Life (PPC)", "cf7d00bbabf0e5476195616940febf05", 104815,
									 "LU_main.Dxr", "b3a548cd57f5129afac208e24463fa1d", 13234768, 501),

	MACGAME1("lovedisk", "", "MAP/LOVEDISK", "b69f9cb79da512852ed383a1cfef14b9", 719005, 501),

	WINGAME1t("luxor", "", "SECRETS.EXE", "7f1d08293b07dbdff264858dd38ac6f0", 938231, 501),
	MACGAME1("luxor", "", "Secrets PPC", "0fb300fd8a82c7a2d264cea1736bd124", 96616, 505),

	MACGAME1("kidsbox", "", "KIDS BOX(PPC)", "e7ee6c4e4cf63575db94bf3fc433053d", 107863, 500),
	WINGAME1t("kidsbox", "Normal", "KIDS_N.EXE", "7abed0fbe806404b5e4045927b293950", 1443095, 500),
	WINGAME1t("kidsbox", "Slow", "KIDS_O.EXE", "7abed0fbe806404b5e4045927b293950", 1443093, 500),

	MACGAME1("maccubed", "Disc 1", "Let's Go! Arcade", "5b3a7fa45ec7655c5f9b7fe39ae37a11", 705357, 500),
	MACGAME1("maccubed", "Disc 2", "Let's Go! Games", "5b3a7fa45ec7655c5f9b7fe39ae37a11", 705357, 500),
	MACGAME1("maccubed", "Disc 3", "Let's Go! Kids, Board &Card", "5b3a7fa45ec7655c5f9b7fe39ae37a11", 705357, 500),
	MACGAME1("maccubed", "Disc 4", "Let's Go! Education", "5b3a7fa45ec7655c5f9b7fe39ae37a11", 705357, 500),
	MACGAME1("maccubed", "Disc 5", "Let's Go! Home and Office", "5b3a7fa45ec7655c5f9b7fe39ae37a11", 705357, 500),
	MACGAME1("maccubed", "Disc 6", "Let's Go! Multimedia", "5b3a7fa45ec7655c5f9b7fe39ae37a11", 705357, 500),
	MACGAME1("maccubed", "Disc 7", "Let's Go! Internet & Utilities", "5b3a7fa45ec7655c5f9b7fe39ae37a11", 705357, 500),

	// Original Mac Pre-K filename contains non-printable character
	// Full games do not use Director except for Progress Report utilities
	MACDEMO1("madcc12", "Demo",	"Madeline 1st & 2nd Grade Demo", "32c629eab7202d758c52c758493f1847", 719261, 501),
	MACDEMO1("madccpk", "Demo", "Madeline Pre-K Demo", "32c629eab7202d758c52c758493f1847", 719261, 501),
	WINDEMO1("madcc12", "Demo",		 "MAD12.EXE",  "842014a812b454620f64b860fd7211f0", 932335, 501),
	WINDEMO1("madcc12", "Slideshow", "SLIDES.EXE", "2e62abdad839e42068afdcd0644d7dcf", 1192485, 501),
	WINDEMO1("madccpk", "Demo",		 "MADPK.EXE",  "842014a812b454620f64b860fd7211f0", 932303, 501),

	WINGAME1_l("maria", "", "MARIA1.EXE", "3460ad87d2ba57104e2810a77b53c220", 6727617, Common::JA_JPN, 500),

	// Original filename is Mavis 5 Demo 12/12
	MACDEMO1("mavisbeacon", "v5.0 Demo", "xn--Mavis 5 Demo 1212-7a88f", "35dbf55e70f69e00ca016e3663379970", 703153, 500),

	// Original Mac filename is Demonstraciä
	// Found on Russian Max 3 CD from NRG
	MACGAME1_l("max1max2", "Demo", "Demonstracia", "06ed90580400cd9e263525f84c8075fd", 705673, Common::RU_RUS, 500),

	// Original filename is 'メカフォルダ/メカドリル'
	MACGAME1_l("mecadrill", "", "xn--jckd8d2dsc3c/xn--lck0c6ctbf", "16f51fc148898582fcdb6f58456ceb52", 719636, Common::JA_JPN, 501),
	// Decomposed variant of the above filename
	MACGAME1_l("mecadrill", "", "xn--2bk5af5f2e0ctd/xn--2bk9a5e9d0bg", "16f51fc148898582fcdb6f58456ceb52", 719636, Common::JA_JPN, 501),
	WINGAME1t_l("mecadrill", "", "MECA/MECA95.EXE", "ff76ffa3616a1acb82f6b12bc94bec64", 1390011, Common::JA_JPN, 505),

	MACGAME1_l("microphonefiend", "8", "Microphone Fiend8", "bfd348abd981acae64c13d5e5e4d9540", 719785, Common::JA_JPN, 501),
	MACGAME1_l("microphonefiend", "16", "Microphone Fiend16", "d8f16d8e1dbd01ebf1f74f028b16a126", 117830, Common::JA_JPN, 501),

	// On hybrid CD with Joystick (France) covermount
	// Original filenames use N° instead of No
	MACGAME1_l("mieuxmieux", "N°16", "CD Mieux-Mieux No16", "227fcce08de8028e2201f5f4eb3b3cc3", 720132, Common::FR_FRA, 501),

	MACGAME1_l("missihb", "", "MISS", "3f932e8f25860fdae3426c1eb4f31817", 718756, Common::JA_JPN, 501),
	WINGAME1_l("missihb", "", "MISS95.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410206, Common::JA_JPN, 501),

	WINGAME1t("missileattack", "", "sub95.exe", "f5dde0458de1a26d6901a7847f35ff57", 1737817, 501),

	// Published by APTE
	MACGAME1("missionplanetx", "v2.0", "Mission To Planet X", "575bc118621e964630087984e463c283", 705445, 500),
	WINGAME1t("missionplanetx", "v2.0", "MISSN32.EXE", "b7775ca5e79f95cddd5fecfa31c8f84d", 1413807, 501),

	WINGAME1("mmalgebra", "", "mmalgbra.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1887007, 501),

	// Apple Masters of Media #011
	MACGAME1_l("mmedia11", "", "Making of SAKURA", "bef2a1951fe8853c36f7313940040cb6", 717656, Common::JA_JPN, 501),

	MACGAME1("mmmath3", "", "Mission Masters Math 3", "ec6fba1c2d0fd9dbe987f4336cb08e2b", 718381, 501),
	WINGAME1("mmmath3", "", "INTRO323.EXE", "d82e8bf2e13128be8b1c2a6afe536308", 1415493, 501),

	WINGAME1t("mobiclic", "Windows 3.1", "CLICK31.EXE", "10771f3a2f953a520de24746c1031f68", 927410, 501),
	WINGAME1t("mobiclic", "Windows 95", "CLICK95.EXE", "b540921a864caea4868e7e0261b59f3d", 1405572, 501),

	// Original finnish release: "Suuri Muumijuhla"
	// English release: "The Great Moomin Party"
	// Norwegian release: "Fest i Mummidalen"
	// Swedish release: "Fest i Mumindalen"
	// Danish release: "Fest i Mumidalen"
	// Windows versions require installation
	MACGAME2("moominparty", "", "The Great Moomin Party", "250a5349ecb5d19b4352b5d11095f24b", 719033,
								"HD_DATA/MENU.Dxr",		  "7fb1b0b67828e2e04245895c8d67c63d", 5076140, 501),
	WINGAME2t("moominparty", "Windows 95",  "Mumin95.exe", 		"f11b230993af8dba0fd2efa0d3271c89", 1416715,
									  	    "hd_data/MENU.DXR", "6a895814b03d85d79c53c7a1f9eaf128", 5076140, 501),
	WINGAME2t("moominparty", "Windows 3.1", "MUMIN31.EXE", 		"92fc805cebf17a05026b508293afd0c4", 938553,
									  		"HD_DATA/MENU.DXR", "6a895814b03d85d79c53c7a1f9eaf128", 5076140, 501),
	MACGAME2_l("moominparty", "", "Fest i Mummidalen", "250a5349ecb5d19b4352b5d11095f24b", 719033,
								  "HD_DATA/MENU.Dxr",  "36355463fa9d59c7f191445d07aa9072", 5064032, Common::NB_NOR, 501),
	WINGAME2t_l("moominparty", "Windows 95",  "Mumin95.exe", 	  "f11b230993af8dba0fd2efa0d3271c89", 1416715,
									  	      "hd_data/MENU.DXR", "21d9332d7345fddebcab25b8482e7cfb", 5064032, Common::NB_NOR, 501),
	WINGAME2t_l("moominparty", "Windows 3.1", "MUMIN31.EXE", 	  "92fc805cebf17a05026b508293afd0c4", 938553,
									  		  "hd_data/MENU.DXR", "21d9332d7345fddebcab25b8482e7cfb", 5064032, Common::NB_NOR, 501),
	MACGAME2_l("moominparty", "", "Fest i Mumindalen", "231d3041df162be4a0ddd36a74eb03b6", 719033,
								  "HD_DATA/MENU.Dxr",  "2ad2b9e9477bdc7d48959b8df8830fd5", 5072990, Common::SE_SWE, 501),
	WINGAME2t_l("moominparty", "Windows 95",  "Mumin95.exe", 	  "f11b230993af8dba0fd2efa0d3271c89", 1416715,
									  	      "hd_data/MENU.DXR", "4809a8c0c7c064f3ea0dbd6844260c67", 5072990, Common::SE_SWE, 501),
	WINGAME2t_l("moominparty", "Windows 3.1", "MUMIN31.EXE", 	  "92fc805cebf17a05026b508293afd0c4", 938553,
									  		  "HD_DATA/MENU.DXR", "4809a8c0c7c064f3ea0dbd6844260c67", 5072990, Common::SE_SWE, 501),
	MACGAME2_l("moominparty", "", "Suuri Muumijuhla", "250a5349ecb5d19b4352b5d11095f24b", 719033,
								  "HD_DATA/MENU.Dxr",  "f4b8f898cb03062f0d2e94b5c9922879", 5070544, Common::FI_FIN, 501),
	WINGAME2t_l("moominparty", "Windows 95",  "Mumin95.exe", 	  "f11b230993af8dba0fd2efa0d3271c89", 1416715,
									  	      "hd_data/MENU.DXR", "4809a8c0c7c064f3ea0dbd6844260c67", 5070544, Common::FI_FIN, 501),
	WINGAME2t_l("moominparty", "Windows 3.1", "MUMIN31.EXE", 	  "92fc805cebf17a05026b508293afd0c4", 938553,
									  		  "HD_DATA/MENU.DXR", "4809a8c0c7c064f3ea0dbd6844260c67", 5070544, Common::FI_FIN, 501),

	WINGAME1("msn", "Preview", "MSNPREV8.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 5215403, 501),

	WINGAME2("muppetkidsearly5", "",   "bright32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 2159587,
									   "sndpats.dir",  "5d1c7b91fcb9cfc0ea438bb09b968df1", 1369944, 501),
	WINGAME2("muppetkidsthinking", "", "bright32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 2159587,
									   "thinkskl.dir", "8a6267e64700117ee7ebaab48316741d", 1504798, 501),

	// English version is D3
	MACGAME1_l("murderbrett", "", "Brad, le surfeur", "227fcce08de8028e2201f5f4eb3b3cc3", 720160, Common::FR_FRA, 500),
	WINGAME1_l("murderbrett", "", "BRAD.EXE", "e1c3cb4df694b887f3708f9ebb72302f", 934342, Common::FR_FRA, 500),

	// Bilingual Japanese/English
	MACGAME1("musicforliving",  "", "ASL", "4f2c70510b4cbedf758cf9958d218e6e", 705445,  505),
	WINGAME1t("musicforliving", "", "ASL.EXE",	   "b7853a82d4edff6be38b545143e95940", 1411198, 501),

	// From MacFormat #44
	MACGAME1("myfavburps", "", "My Favorite Burps", "7b0837f93c5de519acdf1feea2a4ccf2", 703153, 500),

	// Original filename is 'ねぎ3世'
	MACGAME1_l("negi3", "", "xn--3-l8t6do49k", "e2acdaafa16d8dbecbeca418d7e44899", 719636, Common::JA_JPN, 500),
	// Decomposed variant
	MACGAME1_l("negi3", "", "xn--3-j8t9dxhu56l", "e2acdaafa16d8dbecbeca418d7e44899", 719636, Common::JA_JPN, 500),
	WINGAME1t_l("negi3", "", "NEGI_3.EXE", "da9cee84ee984174c52d359132ad4ac6", 929342, Common::JA_JPN, 501),

	// Other screensavers are D4
	MACGAME1("nekojiruudonss", "Diginya", "DIGINYA", "82def1f3b9980018ed9b662893884546", 873267, 501),
	MACGAME1("nekojiruudonss", "Firekoro", "FIREKORO", "82def1f3b9980018ed9b662893884546", 873268, 501),
	MACGAME1("nekojiruudonss", "Indozin", "INDOZIN", "82def1f3b9980018ed9b662893884546", 873267, 501),
	MACGAME1("nekojiruudonss", "Itachi", "ITACHI", "82def1f3b9980018ed9b662893884546", 873266, 501),
	MACGAME1("nekojiruudonss", "Koma", "KOMA", "82def1f3b9980018ed9b662893884546", 873265, 501),
	MACGAME1("nekojiruudonss", "Komatta", "KOMATTA", "82def1f3b9980018ed9b662893884546", 873267, 501),
	MACGAME1("nekojiruudonss", "Koropeta", "KOROPETA", "82def1f3b9980018ed9b662893884546", 873308, 501),
	MACGAME1("nekojiruudonss", "N_N", "N_N", "82def1f3b9980018ed9b662893884546", 873263, 501),
	MACGAME1("nekojiruudonss", "Noguchi", "NOGUCHI", "82def1f3b9980018ed9b662893884546", 873267, 501),
	MACGAME1("nekojiruudonss", "Saru", "SARU", "82def1f3b9980018ed9b662893884546", 873264, 501),
	MACGAME1("nekojiruudonss", "Taikyoku", "TAIKYOKU", "82def1f3b9980018ed9b662893884546", 873308, 501),
	WINGAME1t("nekojiruudonss", "Diginya", "DIGINYA.EXE", "f8ffb68095f80fd385f1ba9d4c76ec26", 1601138, 501),
	WINGAME1t("nekojiruudonss", "Firekoro", "FIREKORO.EXE", "af297fb6a0f204af5ef1e47c9b9b7830", 1541948, 501),
	WINGAME1t("nekojiruudonss", "Indo", "INDO.EXE", "88212f81d6ed89d66666c647f483020f", 1613050, 501),  // Indozin?
	WINGAME1t("nekojiruudonss", "Install1", "INSTALL1.EXE", "8a9fb7cd79b396bf0a4a915e60e629c3", 1857700, 501),  // Ashi?
	WINGAME1t("nekojiruudonss", "Install2", "INSTALL2.EXE", "9f7c7d17c44c4baeaf26d03803236f12", 1827410, 501),  // Chin?
	WINGAME1t("nekojiruudonss", "Install3", "INSTALL3.EXE", "e088934cd3f7324c7290b34c0c8e8a96", 1834716, 501),  // Doga?
	WINGAME1t("nekojiruudonss", "Install4", "INSTALL4.EXE", "d49af229d14bbe19cb4b16134dd21e72", 1861494, 501),  // Guruguru?
	WINGAME1t("nekojiruudonss", "Install5", "INSTALL5.EXE", "5a98fe24a8920fe304111958c10cebf6", 1791866, 501),  // Nezumi?
	WINGAME1t("nekojiruudonss", "Install6", "INSTALL6.EXE", "e0813c040f52a3697bf985d4d0ff44aa", 2560174, 501),  // Zikansa?
	WINGAME1t("nekojiruudonss", "Itachi", "ITACHI.EXE", "a12d5ae1b9080b9c573e867b5033ce6d", 1897196, 501),
	WINGAME1t("nekojiruudonss", "Koma", "KOMA.EXE", "78f7d8806360e12c04cc508ae7d063ab", 1674152, 501),
	WINGAME1t("nekojiruudonss", "Komatta", "KOMATTA.EXE", "1060c4d7606374365bd937519ec6f71f", 1741794, 501),
	WINGAME1t("nekojiruudonss", "Koropeta", "KOROPETA.EXE", "9d7ee4a0ab7b822e476fb597f6a32155", 1893820, 501),
	WINGAME1t("nekojiruudonss", "N_N", "N_N.EXE", "a02a23cbe6b3079592ecebce8107ac39", 1539396, 501),
	WINGAME1t("nekojiruudonss", "Noguchi", "NOGUCHI.EXE", "ff9d22ae7dbcf5a19dc40736dc98a322", 1789020, 501),
	WINGAME1t("nekojiruudonss", "Saru", "SARU.EXE", "11300003a98cede0fdde607aba6212ec", 1556846, 501),
	WINGAME1t("nekojiruudonss", "Taikyoku", "TAIKYOKU.EXE", "37352ac6d45277dbe9ed0beb05e680df", 1660674, 501),
	MACDEMO1("nekojiruudonss", "Diginya sample", "DIGINYA", "82def1f3b9980018ed9b662893884546", 717613, 501),
	MACDEMO1("nekojiruudonss", "Firekoro sample", "FIREKORO", "82def1f3b9980018ed9b662893884546", 717613, 501),
	MACDEMO1("nekojiruudonss", "Indozin sample", "INDOZIN", "82def1f3b9980018ed9b662893884546", 717613, 501),
	MACDEMO1("nekojiruudonss", "Itachi sample", "ITACHI", "82def1f3b9980018ed9b662893884546", 717613, 501),
	MACDEMO1("nekojiruudonss", "Koma sample", "KOMA", "82def1f3b9980018ed9b662893884546", 717613, 501),
	MACDEMO1("nekojiruudonss", "Komatta sample", "KOMATTA", "82def1f3b9980018ed9b662893884546", 717613, 501),
	MACDEMO1("nekojiruudonss", "Koropeta sample", "KOROPETA", "82def1f3b9980018ed9b662893884546", 717613, 501),
	MACDEMO1("nekojiruudonss", "N_N sample", "N_N", "82def1f3b9980018ed9b662893884546", 717613, 501),
	MACDEMO1("nekojiruudonss", "Noguchi sample", "NOGUCHI", "82def1f3b9980018ed9b662893884546", 717613, 501),
	MACDEMO1("nekojiruudonss", "Saru sample", "SARU", "82def1f3b9980018ed9b662893884546", 717613, 501),
	MACDEMO1("nekojiruudonss", "Taikyoku sample", "TAIKYOKU", "82def1f3b9980018ed9b662893884546", 717613, 501),

	// Found on PC World (Czechia) Sept 2003
	WINGAME2_l("nemcina", "", "START_32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1710313,
							  "CVIC.DXR",     "8f12d20e12dddc2fc3207e1f4e571d17", 23223862, Common::CS_CZE, 500),

	MACGAME1("nickmemory", "", "Memory Challenge", "cb5fe0ca2ddb43abe9996ef569918a53", 703153, 500),

	// All original Mac filenames end with ™
	// Nikolai in Outer Space did not get a Mac release
	MACGAME1("nikolaiknights", "v2.0", "Nikolai's Knights",   "c43bfadda9be111e461dc0b735430ad3", 720690, 501),
	MACGAME1("nikolaimystery", "",     "Nikolai's Mysteries", "c43bfadda9be111e461dc0b735430ad3", 719241, 501),
	MACGAME1("nikolaipirates", "",     "Nikolai's Pirates",   "c43bfadda9be111e461dc0b735430ad3", 719289, 501),
	WINGAME1("nikolaiknights", "v2.0", "KNIGHT95.EXE",         "1a7acbba10a7246ba58c1d53fc7203f5", 1410541, 501),
	WINGAME1("nikolaipirates", "",     "PIRATE95.EXE",         "3460ad87d2ba57104e2810a77b53c220", 1394017, 500),
	WINGAME1("nikolaispace", "",       "0_LAUNCH.EXE",         "3460ad87d2ba57104e2810a77b53c220", 1394291, 501),

	// spaceedu module can also be launched externally
	WINGAME1("nikolaispaceedu", "", "spaceedu.exe", "3460ad87d2ba57104e2810a77b53c220", 1394307, 500),

	// Both versions require installation to extract executable
	MACGAME1("nine", "", "The Last Resort", "957d819f99e30d54f68824ebe3d5d4ae", 730760, 500),
	WINGAME1("nine", "", "nine_95.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1555823, 501),

	WINGAME1t_l("norgesjakten", "Windows 3", "STARTW3.EXE", "de6712e37479f952a52d3e64f172cd24", 1324086, Common::NB_NOR, 501),
	WINGAME1t_l("norgesjakten", "Windows 95", "STARTW95.EXE", "5f330f89a31a02dd9ce8c1c62828e73d", 1412717, Common::NB_NOR, 501),

	WINGAME1("noir", "", "NOIR.EXE", "2e62abdad839e42068afdcd0644d7dcf", 1020879, 500),

	MACGAME1_l("nycalling", "", "NYC_PPC",	   "67c3c173091ee69b1e67a5ac494cc3c7", 108452, Common::JA_JPN, 501),
	WINGAME1t_l("nycalling", "", "NYC.EXE", "7637d3433f7b8679fe1ff4b4f1c25a24", 1409654, Common::JA_JPN, 501),

	WINDEMO1("orly", "Director Demo", "_ORLYDEM.EXE", "2e62abdad839e42068afdcd0644d7dcf", 917641, 500),

	MACDEMO1_l("osaka2", "Demo", "OSAKA2",	   "2e75b0d7a218c71d5dd00a27eb755f00", 719012, Common::JA_JPN, 501),
	WINDEMO1_l("osaka2", "Demo", "OSAKA2.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410110, Common::JA_JPN, 501),

	WINGAME1("parliament", "", "GUIDE.EXE", "2e62abdad839e42068afdcd0644d7dcf", 918871, 500),

	// Screen savers from Perfect Blue (requires installation)
	MACGAME1("pbdisplay", "",   "Display",      "687fa112eefc7ff11ed97ab0dce67401", 806915, 501),
	MACGAME1("pbflash", "",     "Flash",        "687fa112eefc7ff11ed97ab0dce67401", 806913, 501),
	MACGAME1("pbmima", "",      "MIMA",         "687fa112eefc7ff11ed97ab0dce67401", 806912, 501),
	MACGAME1("pbosakana", "",   "OSAKANA",      "687fa112eefc7ff11ed97ab0dce67401", 806915, 501),
	MACGAME1_l("pbtoilet1", "", "Toilet1",      "687fa112eefc7ff11ed97ab0dce67401", 806915, Common::JA_JPN, 501),
	MACGAME1_l("pbtoilet2", "", "Toilet2",      "687fa112eefc7ff11ed97ab0dce67401", 806915, Common::JA_JPN, 501),
	WINGAME1("pbdisplay", "",   "INSTALL1.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 2339226, 501),
	WINGAME1("pbflash", "",     "INSTALL2.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 2181972, 501),
	WINGAME1("pbmima", "",      "INSTALL6.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 1517124, 501),
	WINGAME1("pbosakana", "",   "INSTALL3.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 1665350, 501),
	WINGAME1_l("pbtoilet1", "", "INSTALL4.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 2878548, Common::JA_JPN, 501),
	WINGAME1_l("pbtoilet2", "", "INSTALL5.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 2836264, Common::JA_JPN, 501),

	// Also calls external files such as pdf, html, midi
	WINGAME2("pcwuk", "Disc no.4", "FILE.EXE",	   "842014a812b454620f64b860fd7211f0", 968431,
								   "INTPCW12.DXR", "85c81b0cf75a2576568026c7b55d5f17", 254794, 501),

	// Initial language selection for Portuguese, Spanish or English
	// Mac executable to be renamed from Perdido na Amazônia
	MACGAME1("perdido", "", "Perdido na Amazonia", "ddaaf48a4becb8fec47508ecd38b9c12", 717025, 501),
	WINGAME1("perdido", "", "AMAZW95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1413431, 501),

	// Original Mac filename is そらいろナイト
	MACGAME1_l("perfectblue", "", "xn--n8j6b4gra9i6ima", "687fa112eefc7ff11ed97ab0dce67401", 718381, Common::JA_JPN, 501),
	WINGAME1_l("perfectblue", "", "PERFECTB.EXE", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 1420772, Common::JA_JPN, 501),

	WINGAME1_l("pettson1", "", "PETT32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1430755, Common::SE_SWE, 501),

	WINDEMO1("picasso", "Demo", "PICASS32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1413437, 500),

	// Later releases are D6
	// Multi3 disc from Zeta Multimedia (Barcelona) contains Brazil/Catalan/Spanish
	// Other projectors on the disc (Mac):
	// "Pingu Screen Saver Chooser", "35dbf55e70f69e00ca016e3663379970", 705445, 500
	// "Remove Pingu", "35dbf55e70f69e00ca016e3663379970", 705445, 500
	MACGAME1("pingu1", "",		"Pingu CD-ROM", "35dbf55e70f69e00ca016e3663379970", 705445, 500),
	WINGAME2("pingu1", "1282A", "PINGU.EXE",	"2e62abdad839e42068afdcd0644d7dcf", 917473,
								"PINTITLE.DXR", "2e604dfd80ce4189dc0162dbe47ca7e2", 478854, 500),
	WINGAME2_l("pingu1", "",	"PINGU.EXE",	"2e62abdad839e42068afdcd0644d7dcf", 917473,
								"PINTITLE.DXR", "e56af5ddd0750b8ec04cb4ea3d707066", 489234, Common::CA_ESP, 500),
	WINGAME2_l("pingu1", "",	"PINGU.EXE",	"2e62abdad839e42068afdcd0644d7dcf", 917473,
								"PINTITLE.DXR", "2b0c09c2aab5064afd0006fc33579d52", 482580, Common::ES_ESP, 500),
	WINGAME2_l("pingu1", "",	"PINGU.EXE",	"2e62abdad839e42068afdcd0644d7dcf", 917473,
								"PINTITLE.DXR", "3c4192601421a1eee08bb6b8f0c33b84", 481270, Common::PT_BRA, 500),
	WINGAME2t_l("pingu1", "",	"PINGU.EXE",	"828102166219aa43f00c7cd72c0a4fc9", 917473,
								"Pintitle.dxr", "f9a790a2bd485d634bf638bfd3db18a0", 524602, Common::SE_SWE, 500),

	// Included with pingu1. Contains no text nor speech.
	// Mac version uses a different projector for each screen saver
	WINGAME1t("pinguss", "Screen Saver Selector, GSP", "SETSAVER.EXE", "31422fa4d499e7ca40fce27bbd477ba0", 2126261, 500),
	WINGAME1t("pinguss", "Screen Saver Player, GSP", "PINGU_SS.EXE", "bc77d1a74e85f794dc13007abb98a8c6", 918527, 500),
	WINGAME1("pinguss", "Screen Saver Player, Zeta", "Pingu_ss.exe", "2e62abdad839e42068afdcd0644d7dcf", 918549, 500),
	MACGAME1("pingufish",  "Screen Saver", " PINGU - Fish Chase",	  "35dbf55e70f69e00ca016e3663379970", 799004, 500),
	MACGAME1("pingufight", "Screen Saver", " PINGU - Snowball Fight", "35dbf55e70f69e00ca016e3663379970", 799004, 500),
	MACGAME1("pingustorm", "Screen Saver", " PINGU - Snow Storm",	  "35dbf55e70f69e00ca016e3663379970", 799004, 500),
	MACGAME1("pingustunt", "Screen Saver", " PINGU - Stunt Pingu",	  "35dbf55e70f69e00ca016e3663379970", 799004, 500),
	MACGAME1("pingutime",  "Screen Saver", " PINGU - Time for Pingu", "35dbf55e70f69e00ca016e3663379970", 799026, 500),

	MACGAME1_l("pinkgear", "", "Go To PINKGEAR", "ff888459bfaa03ad82ec5f7f1eae3de3", 718756, Common::JA_JPN, 501),
	WINGAME1_l("pinkgear", "", "GOTOPINK.EXE", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 3592612, Common::JA_JPN, 501),

	// Found on Sierra On-Line's MasterCook Cooking Light v4.0 (1996)
	// There are no Mac demos on this disc
	WINDEMO1t("powerchess", "Demo", "PCHESW95.EXE", "10fd2ee7da83e6d0a703aca0533e5ee9", 1400353, 501),

	MACGAME1_l("previewreprise", "", "P & R", "59c48d4bd00b30a19e1c446b30af5aa9", 185613, Common::JA_JPN, 501),
	WINGAME1t_l("previewreprise", "", "Prhs/Autorun.exe", "0c75190ea7b2730322cefd0916c2e7f6", 3049965, Common::JA_JPN, 501),

	WINGAME1("princetonsat98", "", "sat98_32.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1446775, 501),

	// 1998 PC/Mac re-release
	MACGAME1("puppetmotel", "", "Puppet Motel", "4ab012350c6e1c39eda772e33df30cea", 812398, 501),
	WINGAME1t("puppetmotel", "", "PUPPET.EXE", "c43660296f937be289ffaa593b47b4a1", 1434927, 501),

	MACGAME1_l("putlestory", "", "PutlestorY", "552992fb31c736ca67ffd403096596d6", 720654, Common::JA_JPN, 501),
	WINGAME1t_l("putlestory", "", "PUTLE32.EXE", "74c72ab0fcdb4c69114047c74cef486e", 1403206, Common::JA_JPN, 501),

	// From Russian "Pyatachok Anthology" DVD
	WINGAME2t_l("pyatachok1", "",	"START.EXE",	 "97ecdb7aa731b30ba6b1715eab4e0e0d", 917671,
									"Data/Eorc.dir", "5c38097a92432551284a6540ee5a1159", 329642, Common::RU_RUS, 500),

	// Disc contains an audio track, not used by the game
	// Mac version requires installation, 'PYST Installer' / 'MACINTOSH/Installer PYST(MAC)' (FR) / 'MACINTOSH/Installieren PYST(MAC)' (DE), VISE
	// Win version requires installation, 'HDINST/PROGRAM.Z' / 'PC_WIN95/HDINST/PROGRAM.Z' (FR, DE), InstallShield v3
	MACGAME2("pyst", "",	"PYST PPC",	  "56418baf7647cf3d7759cab01570ae52", 105599,
							"LOCAL.Cxt",  "6f436360360c6ba46ca264b584870549", 2597, 501),
	WINGAME2t("pyst", "",	"PYST32.EXE", "6046cf0efaee83bb48b68fc8af8e417a", 1411439,
							"LOCAL.CXT",  "6f436360360c6ba46ca264b584870549", 2597, 501),
	MACGAME2_l("pyst", "",	"PYST PPC",	  "56418baf7647cf3d7759cab01570ae52", 105599,
							"LOCAL.CXT",  "e0cf322f7d2ede12d182f413015fd69a", 2541, Common::FR_FRA, 501),
	WINGAME2t_l("pyst", "", "PYST32.EXE", "6046cf0efaee83bb48b68fc8af8e417a", 1411439,
							"Local.Cxt",  "e0cf322f7d2ede12d182f413015fd69a", 2541, Common::FR_FRA, 501),
	MACGAME2_l("pyst", "",	"PYST PPC",	  "56418baf7647cf3d7759cab01570ae52", 105599,
							"Local.Cxt",  "61c1e5ec419fe137f723295c396cabce", 2543, Common::DE_DEU, 501),
	WINGAME2t_l("pyst", "", "PYST32.EXE", "6046cf0efaee83bb48b68fc8af8e417a", 1411439,
							"Local.Cxt",  "61c1e5ec419fe137f723295c396cabce", 2543, Common::DE_DEU, 501),

	// "Making of Pyst" parody video from X-Fools
	WINGAME1("pystmake", "", "PYST32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1464563, 501),

	// Full game was not released. Windows previews differ on Star Warped and X-Fools discs.
	MACDEMO1("pyst2", "Preview", "Driven Preview", "8a093239a2bbfd73269bc70f873c69b8", 107835, 501),
	WINDEMO1t("pyst2", "Preview", "DRIVEN32.EXE", "43be05ea19a1b52a86c6ad86a71ce0ad", 1464207, 501), // Star Warped
	WINDEMO1("pyst2", "Preview", "DRIVEN32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1464241, 501), // X-Fools

	MACGAME1_l("ravensburger", "", "Ravensburger Demo", "aaebd553081fa7382390dc8366623035", 720369, Common::DE_DEU, 501),
	WINGAME2_l("ravensburger", "", "START.EXE",			"65ef7246e9ab04aff59fb734e9551727", 1076085,
								   "SPIELBAR.DXR",		"869c9c88894c73510341c7ce63b9be36", 495092, Common::DE_DEU, 501),

	MACGAME1_l("raveshuttle", "", "Rave Shuttle", "7b0837f93c5de519acdf1feea2a4ccf2", 705673, Common::DE_DEU, 500),
	WINGAME1_l("raveshuttle", "", "RAVES.EXE", "2e62abdad839e42068afdcd0644d7dcf", 1000911, Common::DE_DEU, 500),

	// Released only in Japan by Interlink of Minato City, Tokyo (1997)
	// Games play fully in English with Japanese credits only
	MACGAME1("rodneyab", "",  "ArtBrain",	  "4023a53e495618c3edb90531e09dc2d0", 720449, 501),
	WINGAME1("rodneyab", "",  "ARTBRAIN.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410136, 501),
	MACGAME1("rodneyfs2", "", "FunScreen2",	  "4023a53e495618c3edb90531e09dc2d0", 719253, 501),
	WINGAME1("rodneyfs2", "", "FSCREEN2.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1412242, 501),

	// Banabana 1-go Demo from MacPeople 1998 No. 2
	MACGAME1_l("rolypolys", "",		 "ROLY_PPC",	 "7f6e753dda02c8aca539b21e1d3a0108", 127070, Common::JA_JPN, 501),
	MACDEMO1_l("rolypolys2", "Demo", "CatchUp!",	 "1da813df08575abf9f94ec1151852005", 738510, Common::JA_JPN, 501),
	WINGAME1t_l("rolypolys", "",	 "KOTOWZ32.EXE", "b2afd5fd125c07052c26a9210d1fbd69", 1411360, Common::JA_JPN, 501),
	WINDEMO1t_l("rolypolys2", "Demo", "DEMO32.EXE",	 "a08e306c9beca27115c25f934f89dbda", 1411230, Common::JA_JPN, 501),
	MACDEMO1_l("rolypolys2", "Banabana 1-go Demo", "xn--1-jguha2ab3kr732a", "1da813df08575abf9f94ec1151852005", 719664, Common::JA_JPN, 501),

	// Original Mac filename is ロンロン
	// Original Win filename is ロンロン.EXE
	MACGAME1_l("ronron", "", "xn--hekarb", "e158dde6f7c52692400f4f58f84405b5", 103908, Common::JA_JPN, 501),
	WINGAME1t_l("ronron", "", "xn--.EXE-9u4ca5bb", "a7f01320844d04408e1519e398a5e0d0", 1451774, Common::JA_JPN, 501),

	// Requires installation, sc32inst.exe, Vise installer
	WINGAME1("safecracker", "", "sc_eng.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1415977, 501),

	// Published by the University of Arizona and the Environmental Education Exchange
	MACGAME1("saguaro", "", "Settings/SCInstall", "ec6fba1c2d0fd9dbe987f4336cb08e2b", 719005, 501),
	WINGAME1("saguaro", "", "SCWIN32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1417616, 501),

	// Use 32-bit Windows executable in SUPPORT/WIN_95
	MACGAME1("saillusion", "", "Illusion", "3f3285490a1764d200c9a82041bf4937", 719289, 501),
	MACGAME1_l("saillusion", "", "Illusion", "06ed90580400cd9e263525f84c8075fd", 705673, Common::DE_DEU, 500),
	WINGAME1("saillusion", "", "ILLUSION.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411175, 501),
	WINGAME1_l("saillusion", "", "Illusion.exe", "1c1fa9c5797b8d2cdc04ad283d9e41d7", 1412949, Common::DE_DEU, 501),

	// Catalogue is found on Surfacing ECD
	// Windows version calls catalogue from ECD main menu
	MACGAME1("sarahcatalog", "",	  "Cat player",		 "b861188374e80b1184e7f96dcab4fc9b", 718353, 501),
	MACGAME1("sarahsurfacing", "ECD", "surf ecd Player", "06ed90580400cd9e263525f84c8075fd", 704765, 501),
	WINGAME1("sarahsurfacing", "ECD", "RUNME32.EXE",	 "3460ad87d2ba57104e2810a77b53c220", 1462645, 501),

	MACGAME1("sauniverse", "", "UNIVPPC", "f488a0465587e739b67e53d224449b9a", 94329, 500),
	WINGAME1("sauniverse", "", "UNIV32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1468873, 501),

	MACGAME1("secretpaths1", "", "Secret Paths in the Forest", "4f0fb528e9c495fd2822ad400178e7a8", 717027, 501),
	WINGAME1("secretpaths1", "", "Secret Paths in the Forest.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1425465, 501),

	MACDEMO1_l("secretsafari", "Demo", "Demo Safari",    "5eb167ccbe590c1d5eb727821277b67f", 719636, Common::JA_JPN, 501),
	WINDEMO1_l("secretsafari", "Demo", "Sf_demo.exe",    "2535f11350bc1f2b7ca2dcc6c0cdddfd", 1411258, Common::JA_JPN, 501),
	MACGAME1_l("secretsafari", "", "S_SAFARI",    "552992fb31c736ca67ffd403096596d6", 719604, Common::JA_JPN, 500),
	WINGAME1t_l("secretsafari", "", "S_SAFARI.EXE",    "3095ddaae36b31cbf935ffc4b86e9b0d", 1411782, Common::JA_JPN, 501),

	MACGAME2_l("seesawc1", "", "PPC", 		"56418baf7647cf3d7759cab01570ae52", 107863,
							   "LOGO.Dxr", 	"c07ca30e8b34193973884a0c0976ce58", 307654, Common::JA_JPN, 501),
	WINGAME2t_l("seesawc1", "", "SC01_32.EXE", "e2d36c3beece0f74c7879b0b52392fb5", 1409869,
								"LOGO.Dxr",	   "337cb3bf89776b70541bc8257cdc5f24", 307654, Common::JA_JPN, 501),

	// Microfolie's Editions, Vanves, Paris (1997)
	// English title is "The Shadoks The Game - The Stroll" (official website)
	// There is even English box art; however the game language is French only
	MACGAME1_l("shadoks", "", "Les Shadoks... Le jeu/La Promenade", "06ed90580400cd9e263525f84c8075fd", 705445, Common::FR_FRA, 500),
	WINGAME1t_l("shadoks", "", "SHADOK.EXE", "911caea045282cf686d593145cf666d3", 1423982, Common::FR_FRA, 501),

	// From SHR Math Essentials Disc 2
	MACDEMO1("shr1st2nd", "Demo", "Grades 1 & 2 Essentials Demo", "9f75f1febafbb9224db5e45f39bf21a6", 719289, 501),
	WINDEMO1t("shr1st2nd", "Demo", "SHR12.EXE", "0be8a483dba4dad21cbb157188a60dc3", 932325, 501),
	MACDEMO1("shr3rd4th", "Demo", "SHR 3_4 Demo", "231d3041df162be4a0ddd36a74eb03b6", 716997, 501),
	WINDEMO1t("shr3rd4th", "Demo", "SHR34.EXE", "2d1b7ff645de655475fbd36de2d1e3a5", 932323, 501),
	// From Elmo's Art Workshop CD
	MACDEMO1("shr1st2nd", "Demo", "GRADES 1 & 2 ESSENTIALS DEMO", "9f75f1febafbb9224db5e45f39bf21a6", 719033, 501),
	MACDEMO1("shr3rd4th", "Demo", "xn--GRADES 3 & 4 ESSENTIALS DEMO -", "231d3041df162be4a0ddd36a74eb03b6", 719005, 501),

	// Mac version requires installation, 'Install America Rock', VISE 3.5 installer
	// Parents & Teachers Corner in this version is Authorware
	MACGAME1("shramerica", "", "SHR America", "8b3f39fdc186bc38c2f71c5240d03a99", 776201, 500),
	WINGAME1t("shramerica", "", "COPY2HD/SHRA_W95.EXE", "6a1d8117819ee2798420d98cf5f02751", 4098299, 501),
	MACGAME1("shramerica", "Print Activities", "Print Activities", "4f2c70510b4cbedf758cf9958d218e6e", 705417, 500),
	WINGAME1t("shramerica", "Print Activities", "PRINTPAK.EXE", "bb0fd2312d141d8cc05f77eb01c54885", 917721, 501),
	// From SHR Exploration Station, Win version is misspelled on disc
	MACDEMO1("shramerica", "Demo", "America Rock Demo", "d7c07df0d9f0176877a3c7c095ee0143", 705417, 500),
	WINDEMO1t("shramerica", "Demo", "amercia.exe", "c4906b1e01232db6ae2f1e8e365d92a4", 917695, 501),
	// From SHR Math Rock
	MACDEMO1("shramerica", "Demo", "America Rock Demo", "d7c07df0d9f0176877a3c7c095ee0143", 703153, 500),

	// Mac version requires install, 'Install Math Rock', VISE 3.5 installer
	MACGAME1("shrmath", "", "SHR Math", "6e7e31d05709e1d38d63f4df6a59eec0", 728467, 501),
	// From SHR Math Essentials Disc 1
	MACGAME1("shrmath", "", "SHR Math Rock", "6e7e31d05709e1d38d63f4df6a59eec0", 728723, 501),
	WINGAME1t("shrmath", "", "COPY2HD/shrm_w95.exe", "9bf9b922d2164b5badeebd1ec9fd615d", 4056173, 501),
	MACGAME1("shrmath", "Parents and Teachers Corner", "Parents & Teachers Corner", "2d2ac01320f4c2dce8e156cda5c73fe8", 719005, 501),
	WINGAME1t("shrmath", "Parents and Teachers Corner", "CORNER95.EXE", "4fe95d0eb535305fcea26c701dd0fdeb", 1413323, 501),
	MACGAME1("shrmath", "Print Activities", "Print Activities", "4f2c70510b4cbedf758cf9958d218e6e", 705417, 500),
	WINGAME1t("shrmath", "Print Activities", "PRINTPAK.EXE", "bb0fd2312d141d8cc05f77eb01c54885", 917721, 500),

	WINDEMO1("shrmess", "Demo", "SHRMESS.EXE", "842014a812b454620f64b860fd7211f0", 932319, 501),

	// Created by Tony Clemens, Desktop Wizard (1997)
	WINGAME1("simpsontrivia", "v3.1", "Simpsons Trivia.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 2355677, 501),

	// Created by Virtual Views / Marco Patrito
	// Published in the US by Mojave, St George, Utah (1995)
	// Plays in English, Italian, Spanish, French, German
	// French version from covermount of PC Fun Nº38 from PressImage, 10ᵉ Paris
	// Mac filename is ' Sinkha '
	MACGAME1("sinkha", "",		"xn-- Sinkha -",   "cb91232ecece0045461d236d5914c03d", 719033, 501),
	WINGAME2("sinkha", "",		"SINKHA.EXE",	   "3460ad87d2ba57104e2810a77b53c220", 1393825,
								"SINKHA.DXR",	   "b8516633b5124711a8c550a2ed539255", 745484, 500),
	WINGAME2_l("sinkha", "",	"SINKHA.EXE",	   "3460ad87d2ba57104e2810a77b53c220", 1393825,
								"SINKHA.DXR",	   "363580346c873a70fe1098175b99aa81", 709524, Common::FR_FRA, 500),

	MACGAME1("sinkha", "Music and Animation", "Music&Animation", "08d6f6e39fbd8388faf57f602acaebcc", 705445, 500),
	WINGAME2("sinkha", "Music and Animation", "MUSIC.EXE",		 "3460ad87d2ba57104e2810a77b53c220", 1393827,
											  "MUS_ANIM.DXR",    "2e31baec8a4957593db517bbf46c6740", 1141212, 500),

	// Developed by Mary Boies Software, published by Creative Wonders
	// Windows version also found in Middle School Advantage 2001 bundle
	MACGAME1("slamdunktyping", "",     "Mac Install/Slam Dunk Typing/Slam Dunk Typing", "5683c6b3956a3bca7fb5fc5bbb237984", 718945, 501),
	WINGAME1("slamdunktyping", "",     "INSTALL/SD/32BIT/SDT95.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1840781, 501),
	WINDEMO1t("slamdunktyping", "Demo", "SDTDEMO.EXE",				 "8a289cf740ad38ffdaf6c72636869da5", 932727, 501),
	WINDEMO1("slamdunktyping", "Demo", "SLAMDUNK.EXE",				 "1a7acbba10a7246ba58c1d53fc7203f5", 3143069, 501),
	MACDEMO1("slamdunktyping", "Demo", "Mac Slam Dunk",				 "231d3041df162be4a0ddd36a74eb03b6", 719261, 501),
	// From Elmo's Art Workshop CD
	MACDEMO1("slamdunktyping", "Demo", "SLAM DUNK TYPING DEMO", "231d3041df162be4a0ddd36a74eb03b6", 719005, 501),

	MACDEMO1_l("smallhouse", "Demo 1", "Demo SH",    "552992fb31c736ca67ffd403096596d6", 719604, Common::JA_JPN, 501),
	WINDEMO2t_l("smallhouse", "Demo 1", "DEMOSH.EXE",    "73246839eb7cc3acaf10e67b837a32c1", 1411908,
								 "SMALL.BIN", "d6c43c560b883f4a9d8d45142c610cfd", 766, Common::JA_JPN, 501),
	MACGAME1_l("smallhouse", "", "Small House",    "552992fb31c736ca67ffd403096596d6", 719617, Common::JA_JPN, 501),
	WINGAME2_l("smallhouse", "", "SMALL.EXE",    "2535f11350bc1f2b7ca2dcc6c0cdddfd", 1411970,
								 "SMALL.BIN", "30ca1e177f721ca74ee0b02c4d397df6", 766, Common::JA_JPN, 501),

	// Bundled with Christmastime at Small House
	MACDEMO1_l("smallhouse", "Demo 2", "Demo SH",    "552992fb31c736ca67ffd403096596d6", 719626, Common::JA_JPN, 501),
	WINDEMO2t_l("smallhouse", "Demo 2", "DEMOSH.EXE",    "73246839eb7cc3acaf10e67b837a32c1", 1411908,
								 "S_DEMO/OPEN/MAIN.Dxr", "29c1134c7ffe2e7f1d3fc271443405ea", 361806, Common::JA_JPN, 501),

	MACGAME1("smarty", "", "Smarty.PPC", "559818fe064f608c69bf86d4c60dee93", 107863, 501),
	MACGAME1("smarty", "Uplink rerelease", "MacPPC", "d2531c0b8c0553be7c7cd5f6c6a07b78", 107863, 501),
	WINGAME1t("smarty", "Uplink rerelease", "WIN95.EXE", "99e9564000991686652e4fed0dc5576d", 1737973, 500),

	// Polish version (Królewna Śnieżka i siedmiu Jaśków) is from the covermount of CyberMycha 07/2002
	WINGAME1_l("snow7han", "", "Snw7han.exe", "65ef7246e9ab04aff59fb734e9551727", 941245, Common::PL_POL, 501),

	// Almost the same as the "IBM CD-Extra Sampler" with different music
	WINGAME2t("sonysampler", "", "SAMPLER.EXE", "262770f6b1b8f1c7f26de01999c98b8b", 978423,
								 "KIRKMM.DIR",  "781b607854e4c69c1a18af15d9fcf37d", 1039698, 500),

	// Original filename is 僐儗僋僔儑儞.exe
	WINGAME1_l("spawncollection", "", "Spawn32.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 2768388, Common::JA_JPN, 501),

	MACGAME1("spellingbee", "", "SPELLING",	   "231d3041df162be4a0ddd36a74eb03b6", 719261, 501),
	WINGAME2("spellingbee", "", "WIN95.EXE",   "1a7acbba10a7246ba58c1d53fc7203f5", 1411387,
								"136MAIN.DXR", "b46fe5ee3a0903bb763121059cee2c06", 679554, 501),

	// Windows provides 640x480 and 800x600 movies; Mac provides 640x480 and 832x624 movies
	// Created by Unis Multimedia, Hollywood, California (1996) using CinéMac 1.2.2c
	// The low- and hi-res movies have the same filenames, so there can be only one installed at a time
	MACGAME1("sshighlander", "v1.10e", "Highlander Screen Saver", "6b91ac61174d6a07bea6a8820a1fe172", 802522, 500),
	WINGAME1("sshighlander", "", "Highlander Screen Saver.exe", "3460ad87d2ba57104e2810a77b53c220", 1976229, 500),

	// Screen savers found on Let's Play with "Sakura" activity CD
	// Windows versions on same disc are D6
	// Original filenames follow the entries on each line
	MACGAME1_l("sskero", "",	 "Kero",		 "65063397536553c4f6ff2a6c07194bf7", 1608622, Common::JA_JPN, 500), // ケロ
	MACGAME1_l("sssakura", "",	 "Sakura",		 "65063397536553c4f6ff2a6c07194bf7", 1608788, Common::JA_JPN, 500), // さくら
	MACGAME1_l("ssyamazaki", "", "Yamazaki-kun", "65063397536553c4f6ff2a6c07194bf7", 3693218, Common::JA_JPN, 500), // 山崎君
	MACGAME1_l("ssyukito", "",	 "Yukito-san",	 "65063397536553c4f6ff2a6c07194bf7", 4867440, Common::JA_JPN, 500), // 雪兎さん

	// Found on Revolutionary War Picture CD from Holiday Digital Pictures
	MACGAME1("ssrevwar", "", "Revolutionary War Screen Saver", "43234754a346ed7ac25b581f6d106866", 218094, 500),

	WINGAME1("trekchair", "", "Cap_win.exe", "a28313a078c0cd3cebdf505af1d63d88", 1399089, 400),

	// Mac version requires installation, Install Star Warped, VISE
	// Preview is from X-Fools disc
	// Win/Mac previews from Microshaft Winblows are D6
	MACGAME1("starwarped", "", "Star Warped", "d2531c0b8c0553be7c7cd5f6c6a07b78", 107835, 501),
	WINGAME1t("starwarped", "", "STARW32.EXE", "6fb02f659d0a3e8dd24bbf1933930138", 1863971, 501),
	WINDEMO1("starwarped", "Preview", "EWOK32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411571, 501),

	MACGAME1("staytooned", "", "Power Mac Stay Tooned!", "d692140f81aaf86096538f66d6477404", 94301, 500),
	WINGAME2("staytooned", "", "START32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1394421,
							   "PROJECT.DXR", "6490c4706e8b72b61c01a7eb1a39a96c", 2828130, 500),

	MACGAME2("takeru",   "Chapter 1", "Takeru",		  "231d3041df162be4a0ddd36a74eb03b6", 719289,
									  "menu.Dxr",	  "2c0e5edc98e83efd468d9927395d809a", 3024360, 501),
	MACGAME2("takeru",   "Chapter 2", "Takeru2",	  "231d3041df162be4a0ddd36a74eb03b6", 719289,
									  "menu2.Dxr",	  "59fc8473757d5f05b92bd38622771cb9", 3052200, 501),
	WINGAME2("takeru",	 "Chapter 1", "TAKERU32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411857,
									  "A_FIRST.DXR",  "a974472966857faa6039140ccd125a48", 10230, 501),
	WINGAME2("takeru",	 "Chapter 2", "TAK_2_32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411337,
									  "A_SECOND.DXR", "c2d0c64659f18d1c53ad48371125d6a0", 9706, 501),
	MACGAME2_l("takeru", "Chapter 1", "Takeru",		  "231d3041df162be4a0ddd36a74eb03b6", 719289,
									  "menu.Dxr",	  "bc2f80a2535d06afeff8c5faf369d7c4", 3014370, Common::DE_DEU, 501),
	MACGAME2_l("takeru", "Chapter 2", "Takeru2",	  "231d3041df162be4a0ddd36a74eb03b6", 719289,
									  "menu2.Dxr",	  "98f7ef959aa84c3b14fa8a2bd741fcf2", 3080880, Common::DE_DEU, 501),
	WINGAME2_l("takeru", "Chapter 1", "TAKERU32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411857,
									  "A_FIRST.DXR",  "6d6ed808178aa818746f24ab5de13e99", 10236, Common::DE_DEU, 501),
	WINGAME2_l("takeru", "Chapter 2", "TAK_2_32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1411337,
									  "A_SECOND.DXR", "2b3b43f4c2239bcf49a5ffd7ca4bd57f", 9712, Common::DE_DEU, 501),
	WINDEMO1("takeru",	 "Demo",	  "TAKERU32.EXE", "3460ad87d2ba57104e2810a77b53c220", 1395275, 500),

	// Created by Syzygy using CineMac
	// Found on Komputer för alla Jan 1998 from Bonnier Publishing, Stockholm
	WINGAME1("tamafridgi", "", "PCSETUP.EXE", "2e62abdad839e42068afdcd0644d7dcf", 1026715, 500),

	// Original Mac filename is 完全探偵ﾏﾆｭｱﾙ.ppc
	MACGAME1_l("tantei", "", "Tantei.ppc", "2e8327655bfb5602e0ec40792949925f", 108736, Common::JA_JPN, 501),
	WINGAME1_l("tantei", "", "TANTEI.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410270, Common::JA_JPN, 501),

	MACGAME1_l("teddybear", "", "Teddy Bear", "f117b8395c4859d11b9c02c741e22cea", 704793, Common::FR_FRA, 500),
	WINGAME1_l("teddybear", "", "BEAR95.EXE", "3460ad87d2ba57104e2810a77b53c220", 1394051, Common::FR_FRA, 500),

	// Original Mac filename is "天楼都市フォルダ/天楼都市 for Mac"
	// "0_tenrou.exe" doesn't add "Opning" to the search path, Readme.txt says to use "tenrou.exe"
	MACGAME1_l("tenroutoshi", "", "xn--jck3b1c9dp66v0cguuvth6e/xn-- for Mac-n00o010bmx4alc3h", "dabaeab8b01bece0610362ff5f8416b3", 108480, Common::JA_JPN, 501),
	WINGAME1t_l("tenroutoshi", "", "tenrou.exe", "c6bd12ec20e510dd7b6c8a8268999d59", 1411066, Common::JA_JPN, 501),

	MACGAME1("texas", "", "Texas Tourism", "ad32f236d2637602b7299e6b748a7571", 705417, 500),
	WINGAME1t("texas", "", "TEXAS32.EXE", "ac6cf1ba40918db9d7fa1dd837169834", 1410513, 501),

	// ein Fall für TKKG: Katjas Geheimnis (bilingual DE/EN)
	MACGAME2("tkkg1", "", "TKKG start", "6e7e31d05709e1d38d63f4df6a59eec0", 719005,
						  "SCORE.DXR",  "9ffb87ff9d3110435da99a052279fb4c", 10434, 501),
	WINGAME1t("tkkg1", "", "TKKG1_95.EX_", "a6284109fe843164812af767fb9f41c8", 1411299, 501),

	MACGAME1("trekchair", "", "xn--Star Trek Captain's Chair-tl1p/Captain's Chair Player", "d8bad538d97edf5990c451699e429db3", 764476, 501),
	WINGAME1t("trekchair", "", "CAP_WIN.EXE", "6c3c66dd2a5a91257fd2691e3888d47d", 1399089, 500),

	MACGAME1("troubleshoot101", "Basic", "Troubleshooting 101 IA", "62e979424add2428daa835610fb83864", 719261, 501),
	MACGAME1("troubleshoot101", "Music", "Troubleshooting 101 IA w MUSIC", "222fbd020a3910ef748724945145771c", 719261, 501),

	// Original filename is ﾂｲﾝﾋﾞｰPARADISE in どんぶり島.exe
	WINGAME1_l("twinbeeparadise", "", "TwinBee PARADISE in Donburi Shima.exe", "2535f11350bc1f2b7ca2dcc6c0cdddfd", 1410246, Common::JA_JPN, 501),

	WINDEMO2_l("ukiuki3", "Demo", "S.EXE",	  "f7bf3d09655f30ba327810f010150004", 1035432,
								  "LOGO.DIR", "7cd32d690ffaaf21c75ccfb9507a712d", 1052642, Common::JA_JPN, 501),
	{
		{
			"ukiuki3", "CD Demo",
			// Original filename is 幻の天狗池.EXE
			AD_ENTRY1s("BOAT95.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410860),
			Common::JA_JPN,
			Common::kPlatformWindows,
			ADGF_DEMO | ADGF_CD | SUPPORT_STATUS,
			GUIO1(GUIO_NOASPECT)
		},
		GID_GENERIC,
		501
	},

	MACGAME1_l("ursaminorblue", "Hybrid release", "URSA (PPC)", "08166af62693ceab79b28d90d2f6c86b", 106927, Common::JA_JPN, 501),
	WINGAME1_l("ursaminorblue", "Hybrid release", "START/UMB_32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1405383, Common::JA_JPN, 501),

	MACGAME1("venetiandeer", "", "Venetian Deer", "1a352eb1a1c0b1e1b6ac041d58c50cbc", 716741, 501),
	WINGAME1t("venetiandeer", "", "DEER.EXE", "5098878e6a7813b0a2a480d36cd352bc", 952215, 501),

	// Developed by DeAgostini Multimedia
	// Should also have a Mac version from the same disc
	WINGAME1t_l("tesorovenezia", "", "VEN95.EXE", "d28edd9d3e3474feec760c942c410993", 1393935, Common::IT_ITA, 501),

	MACGAME1("vp2", "", "VPhys2", "cb91232ecece0045461d236d5914c03d", 719261, 500),
	MACDEMO1("vp2", "Demo", "VP2Demo", "cb91232ecece0045461d236d5914c03d", 719261, 500),
	WINGAME1("vp2", "", "VPHYS2.EXE", "c3c38bd3907ca7e13220b74bd0317a6c", 1021347, 500),
	WINDEMO1("vp2", "Demo", "VP2DEMO.EXE", "c3c38bd3907ca7e13220b74bd0317a6c", 1021353, 500),

	MACGAME1("wine", "", "double-click me!", "231d3041df162be4a0ddd36a74eb03b6", 719289, 501),
	WINGAME2("wine", "", "WIN95.EXE",		 "1a7acbba10a7246ba58c1d53fc7203f5", 1411337,
						 "160MAIN.DXR",		 "23dbb4744121b077d331b01123709519", 592640, 501),

	// Created by Human Code, Inc.
	// Doesn't require installation
	MACGAME1("wishbone", "", "WISHBONE/Copy2HD-power mac/Odyssey-power [hi]", "ae7c14ee5672c3bc9deac15a8d6d5c77", 94073, 500),
	WINGAME1t("wishbone", "", "WISHBONE/PCINSTAL/WISH95.EXE", "8abf603fcfbf054089bfe2dad14d9569", 1622975, 501),
	// Requires install
	// Windows: DATA1.CAB, InstallShield
	// Mac: Install Wishbone™ Odyssey, VISE
	MACGAME1("wishbone", "v1.0c", "Odyssey", "15a4144726d15488814dab951ec7c3ff", 94073, 500),
	WINGAME1t("wishbone", "v1.0c", "odyssey.exe", "8abf603fcfbf054089bfe2dad14d9569", 1622975, 501),

	MACGAME1("womanengineer", "", "PowerPC", "6710977cfafc46ebe050897e01719f89", 105855, 501),
	WINGAME1("womanengineer", "", "ENG32.EXE", "1a7acbba10a7246ba58c1d53fc7203f5", 1823493, 501),

	WINGAME1_l("wbz", "", "WBZ.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1410284, Common::JA_JPN, 501),

	// Original filename is 'カードバトル'
	MACGAME1_l("wrestlelife", "", "xn--lckycc2a0k0d", "c08abfb9c78cf67386f12b92a7481422", 718728, Common::JA_JPN, 501),
	// Decomposed variant of above filename
	MACGAME1_l("wrestlelife", "", "xn--2bka6c5fc4b3n0e", "c08abfb9c78cf67386f12b92a7481422", 718728, Common::JA_JPN, 501),
	WINGAME1t_l("wrestlelife", "", "BATTLE.EXE", "4a212b51566fdde40f0abcd811d335cc", 1394459, Common::JA_JPN, 505),

	// Mac and Windows versions are D4
	PIPGAME1_l("ybr2", "", "YBR2", "d2531c0b8c0553be7c7cd5f6c6a07b78", 105599, Common::JA_JPN, 501),

	// Original Mac filenames are ハラペコ
	MACGAME1_l("ybr3", "", "Harapeco", "0dab15dae11b5458512beb4ac85cafc1", 113641, Common::JA_JPN, 501),
	WINGAME1_l("ybr3", "", "YBRH.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410805, Common::JA_JPN, 500),
	MACGAME1_l("ybr3", "Single", "Harapeco", "4ab012350c6e1c39eda772e33df30cea", 723903, Common::JA_JPN, 500),
	WINGAME1_l("ybr3", "Single", "YBRSingl.exe", "1a7acbba10a7246ba58c1d53fc7203f5", 1410799, Common::JA_JPN, 500),

	// Developed by Kodansha Co. of Bunkyo, Tokyo
	// Original Mac filename is 妖怪図鑑1
	MACGAME1_l("yokai200", "", "xn--1-we0by4fq4jlr4e", "5b6db61d580e40b903a7f0797b0bdad7", 719012, Common::JA_JPN, 501),
	WINGAME1_l("yokai200", "", "YOUKAI1.EXE", "38b75ecdedf662326fe4931a68ae60cd", 1411170, Common::JA_JPN, 501),

	MACGAME1("zerozero", "", "ZeroMac", "eb3ff85d5e34918bb3ad54d90a21c567", 972761, 500),
	MACGAME1("zerozero", "Uplink rerelease", "ZeroMac", "667b7ed544734f910bb9d9f4e47f76b1", 972761, 500),
	// Original release and Uplink rerelease have the same executable on Windows
	WINGAME1t("zerozero", "", "ZERO95.EXE", "b81561a42d11d5533fc9e93bfa3d4cfd", 1394631, 500),

//////////////////////////////////////////////////
//
// Macromedia Director v6
//
//////////////////////////////////////////////////

	// Disney's 101 Dalmations
	WINGAME1("101pet", "", "101pet.exe", "d62438566e44826960fc16c5c23dbe43", 1862441, 650),

	MACGAME1("10plus2", "", "10plus2 PPC", "22e2e91bed55f087b739983679e4a0ff", 114739, 600),
	WINGAME2("10plus2", "", "START95.EXE", "a593079aecf5bd938ce75264cac24b2d", 1508485,
							"START.Dir",   "b9f7a692dce72c30e54325c4a957e582", 9290, 600),

	WINGAME1("1stcdtoddler", "", "_dkilbbt.exe", "d62438566e44826960fc16c5c23dbe43", 2012554, 650),

	WINGAME1_l("3iadins", "", "TVC.EXE", "d62438566e44826960fc16c5c23dbe43", 1777420, Common::CA_ESP, 650),

	// Created by NOVA Online for PBS / WGBH Boston
	// Companion app for NOVA episode "Special Effects: Titanic and Beyond"
	// Original PBS Airdate: November 3, 1998
	// https://www.pbs.org/wgbh/nova/specialfx2/
	// Win9X version found on apcmag.cd Dec 1999 disc 3, published by Australian Consolidated Press
	MACGAME1("50ftchicken", "",		   "NOVA_Chicken", "7b83483a881626b278258c109c1bd3b4", 1030370, 602),
	WINGAME1("50ftchicken", "Win 9X",  "NOVAchi9.exe", "a593079aecf5bd938ce75264cac24b2d", 1637982, 600),
	WINGAME1("50ftchicken", "Win 3.x", "NOVAchi3.exe", "b0f3841f6e8005e519445b22de37749b", 1259932, 600),
	SHKGAME1("50ftchicken", "",		   "chicken.dcr",  "55fa0c9afa4ee4102b50258544fc28d4", 442575, 600),

	// Published by Future Soft of Nasr City, Cairo
	WINGAME1_l("abctrain", "", "abc.exe", "a593079aecf5bd938ce75264cac24b2d", 2091687, Common::AR_ARB, 600),

	// Mini-game from X-Fools that can also be launched separately
	MACGAME1("abductthis", "", "Abduct This!", "41fa2186d635be3094403c75b5f44d4b", 115391, 600),
	WINGAME1t("abductthis", "", "abduct32.exe", "eef786210abfb8e140e843dc707e5025", 3644633, 600),

	MACGAME1("afiles", "", "The A-Files",	"63e8b9f6744efefbb8a004a2b76e2b1d", 118530, 602),
	WINGAME2("afiles", "", "Projector.exe", "4c850adf7c36a9a3dea64c880eaf25c0", 1515545,
						   "intro.dir",		"8030f92799c85ab5a6fd1c23f4ce6734", 396047, 602),

	// Cherry Coke Presents a Myst clone
	MACGAME1("alanna", "", "Alanna", "05c94e6fcb102f9fa795e354c956b28e", 1029257, 600),

	MACGAME1("amertailmb", "", "An American Tail MB", "41fa2186d635be3094403c75b5f44d4b", 115647, 600),
	WINGAME1("amertailmb", "", "Amer32.exe", "518a98696fe1122e08410b0f157f21bf", 2075235, 602),

	// Full game is not Director; no Director content on Disc 2
	MACDEMO1("amgpremiere", "Advanced Tutorial", "Advanced Tutorial", "ddfa76b82cb37f6349b55f13ff5b034a", 1026901, 600),
	MACDEMO1("amgpremiere", "Beginning Tutorial", "Beginning Tutorial", "ddfa76b82cb37f6349b55f13ff5b034a", 1026901, 600),
	MACDEMO1("amgpremiere", "Director's Guide", "Director's Guide", "ddfa76b82cb37f6349b55f13ff5b034a", 1026901, 600),
	WINDEMO1("amgpremiere", "Advanced Tutorial", "ADVTUTOR.EXE", "a593079aecf5bd938ce75264cac24b2d", 3019357, 600),
	WINDEMO1("amgpremiere", "Beginning Tutorial", "BEGTUTOR.EXE", "a593079aecf5bd938ce75264cac24b2d", 2078039, 600),
	WINDEMO1("amgpremiere", "Director's Guide", "DIRGUIDE.EXE", "a593079aecf5bd938ce75264cac24b2d", 2070484, 600),

	MACGAME1_l("anony", "", "Anony", "65063397536553c4f6ff2a6c07194bf7", 1845815, Common::JA_JPN, 602),
	WINGAME1t_l("anony", "", "ANONY.EXE", "83a8b0577877f3ca90ef2df6e6e287ae", 2029722, Common::JA_JPN, 602),

	MACGAME1_l("aslss", "", "ASL", "aa9d5cab48b17f563110dc271c6663b4", 1133578, Common::JA_JPN, 601),

	// Fun Pack is on the Party Time CD
	WINGAME1("bananaspack", "", "_Fun_Pack.exe", "a593079aecf5bd938ce75264cac24b2d", 1508656, 600),
	WINGAME1("bananasparty", "", "_Party_Time.exe", "a593079aecf5bd938ce75264cac24b2d", 1508811, 600),

	WINGAME2("barbnail", "", "LAUNCH.EXE", "518a98696fe1122e08410b0f157f21bf", 1758656,
							 "intro.dxr",  "8732eb742a8bbfd6de5c55b22e41317b", 2549490, 602),

	// from Australian PC User, December 1998
	WINDEMO1t("bcsinkfloat", "", "BLUE204.EXE", "a7d531197a24161364c0f69c86972702", 1492403, 600),

	// Part of box set with music CD and photo book
	MACGAME1("bettypage", "", "Betty", "be947e969e358cc77e6a96ee42bab3f1", 1031674, 601),
	WINGAME1("bettypage", "", "betty.exe", "a593079aecf5bd938ce75264cac24b2d", 1510046, 600),

	WINGAME1_l("bigmax", "nº20", "BIG32.EXE", "518a98696fe1122e08410b0f157f21bf", 7313980, Common::PT_BRA, 602),

	// From Soleau Software, New York, a member of the Association of Shareware Professionals (ASP)
	WINGAME1("bingobuds", "v1.1", "BINGO.EXE", "b0f3841f6e8005e519445b22de37749b", 4373364, 600),

	// Japanese release, "Zlurp", is part of the Digitalogue Future Artist Series
	MACGAME1_l("boitearire", "", "Zlurp", "e402b347a9cf682d2154c70cfefdbf26", 115776, Common::JA_JPN, 601),
	WINGAME1t_l("boitearire", "", "ZLURP.EXE", "cf81c34b261e9bc9e4af4dffa9298b5f", 1710871, Common::JA_JPN, 600),

	WINGAME1t_l("brspel", "", "START.EXE", "8d1bfc4ea72c1892412f2ecabb96c990", 3465523, Common::DA_DNK, 650),

	MACGAME1("carmenmath", "", "Carmen Math Detective", "65063397536553c4f6ff2a6c07194bf7", 1420730, 602),
	WINGAME1t("carmenmath", "", "CMD32.EXE", "75c2569890b01e3d701b2784c25c2866", 1552305, 602),

	MACGAME1("casperact", "", "Casper Activity Center", "904cb6465321d8e1d12d2a5a29612050", 1029165, 600),
	WINGAME1("casperact", "", "CASPER32.EXE", "a593079aecf5bd938ce75264cac24b2d", 1819279, 600),

	// Earlier entries use Director 4
	MACGAME1("catseyeview", "Vol. 4 v2.0", "Cat'sEyeView vol.4_v2.0", "55d01cca925752c170ac1e9c01d1f87e", 1032146, 601),
	WINGAME1t("catseyeview", "Vol. 4 v2.0", "Cat'sEyeView vol.4_v2.0.exe", "1f1162726e10a6db5102a87999b68884", 7136677, 600),
	MACGAME1_l("catseyeview", "Vol. 4 v2.0", "Cat'sEyeView vol.4_v2.0(Fr)", "55d01cca925752c170ac1e9c01d1f87e", 1032146, Common::FR_FRA, 601),
	WINGAME1t_l("catseyeview", "Vol. 4 v2.0", "Cat'sEyeView vol.4_v2.0 (Fr).exe", "a67d77c1141ce8650c84ee8a9e22ec6a", 2027143, Common::FR_FRA, 600),
	MACGAME1("catseyeview", "Vol. 5", "Cat'sEyeView vol.5", "23032a9abc807f7c258c9d58d4708fb4", 1031418, 601),
	WINGAME1t("catseyeview", "Vol. 5 v2.0", "Cat'sEyeView vol.5_v2.0.exe", "bef4d07e711fde035a986dff8a40d935", 3438397, 600),
	MACGAME1("catseyeview", "Vol. 6 R2", "Cat'sEyeView vol.6", "e4932358e3bf9905bbb068d02c247c9b", 1030442, 601),
	WINGAME1t("catseyeview", "Vol. 6 v2.0", "Cat'sEyeView vol.6_2.0.exe", "e1208aefc85d692b9e6fd477a04f2314", 7333831, 600),
	MACGAME1("catseyeview", "Vol. 7", "Cat'sEyeView7", "55d01cca925752c170ac1e9c01d1f87e", 1030462, 601),
	WINGAME1t("catseyeview", "Vol. 7", "Cat'sEyeView7.exe", "1c8ec55a7a65ba13890697e0e92670a5", 6017657, 600),

	MACGAME1("catshats", "", "Cats and Hats", "cc27aab06406e53f53bcf7efd154ac1c", 1033985, 602),
	WINGAME1("catshats", "", "HEXEN32.EXE", "be5ee23851ba95ce0b790e50f75f7e2e", 1661593, 602),

	// Developed by Real World Multimedia, Wiltshire, England (1997)
	// Distributed in Germany by Funware, Hamburg
	MACGAME2("ceremony", "",   "Ceremony PPC",	"d001d6e8615e35edc03465683f56e84d", 115675,
							   "00startCD.dir", "f40c38467c0ad3fca7d3626b134c13b3", 15503, 600),
	WINGAME2("ceremony", "",   "ceremony.exe",  "a593079aecf5bd938ce75264cac24b2d", 1700809,
							   "00startCD.dir", "f40c38467c0ad3fca7d3626b134c13b3", 15503, 600),
	MACGAME2_l("ceremony", "", "Ceremony PPC",  "d001d6e8615e35edc03465683f56e84d", 115675,
							   "00startCD.dir", "39d2e56f6a29bdf0f38888489f99d60c", 15507, Common::DE_DEU, 600),
	WINGAME2_l("ceremony", "", "ceremony.exe",  "a593079aecf5bd938ce75264cac24b2d", 1700809,
							   "00startCD.dir", "39d2e56f6a29bdf0f38888489f99d60c", 15507, Common::DE_DEU, 600),

	// General preview for ClueFinders series. Does not correspond to a specific game.
	WINGAME1t("cfdemo", "", "CFdemo.exe", "30ed83ee5d4c757df42517befc0fd129", 11941853, 650),

	// Full game can be unlocked with registration key
	// Developed by LittleFingers Software, Redding, Connecticut
	// Later Mac OS X version is D10
	// https://web.archive.org/*/http://littlefingers.com/
	MACGAME1("checkersvillage", "Classic OS", "Checkers Village", "a593079aecf5bd938ce75264cac24b2d", 3871783, 600),
	WINGAME1("checkersvillage", "", "Checkers Village.exe", "a593079aecf5bd938ce75264cac24b2d", 3871783, 600),

	// Clocks from Let's Play with Sakura CD
	// Mac versions are D5
	// Original filenames follow the entries on each line
	WINGAME1_l("clockkero", "",	  "Kero Tokei.exe",	  "45871c12eb944f09f50ee742113a1e2d", 2770370, Common::JA_JPN, 650), // ケロ時計.exe
	WINGAME1_l("clocksakura", "", "Sakura Tokei.exe", "45871c12eb944f09f50ee742113a1e2d", 2754593, Common::JA_JPN, 650), // さくら時計.exe
	WINGAME1_l("clocktomoyo", "", "Tomoyo Tokei.exe", "45871c12eb944f09f50ee742113a1e2d", 3184823, Common::JA_JPN, 650), // 知世時計.exe

	MACGAME1("concentration", "ECD", "Natural",	   "f987dae6f5cdd01875c886a491591e72", 1031658, 650),
	WINGAME2("concentration", "ECD", "win95.exe",  "d62438566e44826960fc16c5c23dbe43", 1703271,
									 "stub32.dxr", "c835559b5556665bc755350ec9bd8244", 47639, 650),

	WINGAME1t_l("creativenursery", "", "Nursery.exe", "62db2ff1a11e43aeab99efd97620c398", 1798660, Common::ZH_CHN, 602),

	MACGAME1_l("crusader2000", "", "Lancer Croisades", "398eb2cdf121feb490097c6323d52267", 1031745, Common::FR_FRA, 650),
	WINGAME1_l("crusader2000", "", "Croisade.exe", "d62438566e44826960fc16c5c23dbe43", 1546312, Common::FR_FRA, 650),

	// Doki Doki On-air Drama Series acts as a companion to a series of radio broadcasts
	// It includes the audio episodes alongside sketches, interviews, and mini-games
	// Original filenames are as follows:
	// Vol.1 - 胸さわぎのＳＥＡＳＯＮ
	// Vol.2 - アイドル探偵ＹＯＵ＆ＭＹ
	// Vol.3 - 超合身ザンガード
	// Vol.4 - 怪盗エルフ・リーリィ
	MACGAME1_l("ddoa", "Vol.1", "xn--x8jn0f4f9104b0gsh1a7ei1bc", "baed611e800d4619b66bbb28db3df1c7", 1033267, Common::JA_JPN, 601),
	MACGAME1_l("ddoa", "Vol.2", "xn--ccke5ivf059nsbyabl1u6iaqa4d0be", "baed611e800d4619b66bbb28db3df1c7", 1033523, Common::JA_JPN, 601),
	MACGAME1_l("ddoa", "Vol.3", "xn--mckta2dwiub0759and2ei6b", "fd87b233709108cc1fb001523ce772f5", 1033199, Common::JA_JPN, 601),
	MACGAME1_l("ddoa", "Vol.4", "xn--dckj9k8cad7ij0189hun1b", "fd87b233709108cc1fb001523ce772f5", 1033199, Common::JA_JPN, 601),

	MACGAME1("deedeedanger", "", "Dee Dee Danger", "f4e6bb84a18322cc5077c336eeec4549", 115739, 650),

	WINGAME1("delphi4tutor", "", "Del4Tutor.exe", "ece1c7a090010965890840102978e693", 3125198, 601),

	WINGAME1("dfireworks", "Ver.98", "Firewk32.exe", "ece1c7a090010965890840102978e693", 1513130, 601),

	// Plays movies and launches 5 demos. Only the MSN preview uses Director
	// Other engines include MediaStation ASB and Bill Appleton's DreamFactory
	MACGAME1("disneyint", "", "DIeduSLVppc", "0096dc69d72faeb63ec7dbbb96899fac", 113411, 600),
	WINGAME1("disneyint", "", "DIEdu32.exe", "a593079aecf5bd938ce75264cac24b2d", 1510321, 600),

	// Mac version on same discs is D5
	WINGAME1("dynamichuman", "v2.0", "DH2.EXE", "d62438566e44826960fc16c5c23dbe43", 1718624, 650),

	// Published by Birchtree Interactive, Tillson, Ontario (1998)
	// There are four demos described here:
	// https://web.archive.org/web/20000623024147/http://www.eddieandminx.com/demo.htm
	// Map demo found on Disc Inferno from APC magazine (Australia), Dec 1999
	WINDEMO1("eddieminx", "Map Demo", "mapgame.exe", "518a98696fe1122e08410b0f157f21bf", 5876875, 602),

	MACGAME1("egypt", "", "Egypt", "0944b962ebb00f4b5d5149d220f8449b", 114142, 702),

	WINDEMO1_l("engl", "Demo", "ENGL.EXE", "a593079aecf5bd938ce75264cac24b2d", 13304811, Common::RU_RUS, 600),

	MACGAME1("espanatomy", "", "Anatomy & Physiology ESP", "e3a044ab01f96d6645bc315628c2b00f", 118396, 602),
	WINGAME1("espanatomy", "", "Anatomy & Physiology ESP.exe", "625deae5e42f9453c5e4ccf7d322f048", 1526924, 602),

	// Mini-game from Microshaft Winblows that can also be launched separately
	MACGAME1("exploder", "", "Winblows Exploder", "089658f6d7d68f07eece8a68e5fdc35e", 115391, 600),
	WINGAME1t("exploder", "", "EXPLODER.EXE", "ae488c615d7ecb621c96c59b98eccf9b", 4712625, 600),

	MACGAME1("flingshot", "", "FlingShot", "769cbb727ae2dda3f8ab6682d65ab439", 1031461, 650),

	WINGAME1("forestia", "", "FORESTIA.EXE", "9ba84c313bc116ffa08029aad52cd2e8", 1859350, 601),
	WINGAME1_l("forestia", "", "Forestia.exe", "5e123b0ddb0f1193e1f840c50f24e382", 1521194, Common::FI_FIN, 650),
	MACGAME1_l("forestia", "", "FORESTIA", "3c0d928e84acac2ee6739a4360e70fc6", 1032662, Common::FR_FRA, 602),

	// Later releases are D8
	WINGAME1_l("forestiajr", "", "Forestia Junior.exe", "5e123b0ddb0f1193e1f840c50f24e382", 1553190, Common::FR_FRA, 650),

	MACDEMO1("fpbacon", "Crane Demo", "FP Construction Demo", "1d9149b9745e35ef93ed4cdf08ec3af7", 1031726, 600),
	WINDEMO1("fpbacon", "Crane Demo", "CONDEM95.EXE", "a593079aecf5bd938ce75264cac24b2d", 1508205, 600),

	MACGAME1("fpbagarage", "", "Big Action Garage", "1d9149b9745e35ef93ed4cdf08ec3af7", 1032662, 602),
	WINGAME2("fpbagarage", "", "GARAGE.EXE", "518a98696fe1122e08410b0f157f21bf", 1512853,
							   "START.DXR",  "f69996bd5a1dea3971c7647e86b4ee30", 190436, 602),

	// Developed by Funnybone Interactive
	// 1995 release (developed by The Learning Company) doesn't use Director
	WINGAME1("fpgacastle2", "", "CASTLE32.EX_", "518a98696fe1122e08410b0f157f21bf", 1563605, 602),
	MACDEMO1("fpgacastle2", "Crocodile Kitchen Demo", "Castle Demo", "1d9149b9745e35ef93ed4cdf08ec3af7", 1032634, 602),
	WINDEMO1("fpgacastle2", "Crocodile Kitchen Demo", "CASDEM95.EXE", "518a98696fe1122e08410b0f157f21bf", 1512624, 602),

	// Developed by Funnybone Interactive (1998)
	// Mac version requires installation, Western Town Installer, uses Stuffit
	MACGAME1("fpgawestern", "v1.0", "Wild Western Town", "55d01cca925752c170ac1e9c01d1f87e", 1031390, 601),
	WINGAME1t("fpgawestern", "v1.0", "WTOWN95.EX_", "b39b0c779c1b4e1e2df4e090e79c1c7d", 1856175, 600),
	MACDEMO1("fpgawestern", "Wacky Wanted Posters Demo v1.0d", "Western Town Demo", "ade290061bd8f78051a8e872a889855c", 1031646, 601),
	WINDEMO1t("fpgawestern", "Wacky Wanted Posters Demo v1.0d", "WEST95.EXE", "d52066d7c271da97d1cfa9911d0ee0fc", 1512580, 602),

	MACDEMO1("fpdollhouse", "Dress Up Demo", "FP Dollhouse Demo", "1d9149b9745e35ef93ed4cdf08ec3af7", 1031658, 602),
	WINDEMO1("fpdollhouse", "Dress Up Demo", "DHDEMO95.EXE", "518a98696fe1122e08410b0f157f21bf", 1512578, 602),

	// Mac version requires installation, Christmas Installer, Stuffit
	MACGAME1("fplpxmas", "", "Christmas", "1d9149b9745e35ef93ed4cdf08ec3af7", 1032378, 602),
	WINGAME1("fplpxmas", "", "XFUN32.EXE", "518a98696fe1122e08410b0f157f21bf", 1566416, 602),

	MACDEMO1("fpreadyt", "ABC Fun Demo", "FP Toddler Demo", "1d9149b9745e35ef93ed4cdf08ec3af7", 1032634, 602),
	WINDEMO1("fpreadyt", "ABC Fun Demo", "TODDEM95.EXE",	"518a98696fe1122e08410b0f157f21bf", 1512576, 602),

	MACDEMO1("fpreadyk", "Toy Shop Demo", "FP Kindergarten Demo", "1d9149b9745e35ef93ed4cdf08ec3af7", 1032634, 602),
	WINDEMO1("fpreadyk", "Toy Shop Demo", "KGDEMO95.EXE",		  "518a98696fe1122e08410b0f157f21bf", 1512576, 602),

	// ©1998 Funnybone Interactive
	MACGAME1("fpready1", "", "1st Grade", "06ed90580400cd9e263525f84c8075fd", 705417, 500),
	WINGAME1t("fpready1", "", "PIR32BIT/START32.EXE", "d49dd78b62186c056e8ade13b73c45e6", 1394357, 501),
	MACDEMO1("fpready1", "Acorn Arcade Demo v1.0w", "1st Grade Demo", "c387e039049babcadf92d4e104136735", 1031912, 602),
	WINDEMO1t("fpready1", "Acorn Arcade Demo v1.0w", "FIRST95.EXE", "8095efb3ed13755b7ebbe2e0d61f1821", 1498587, 602),

	MACGAME1("fusion", "", "Start FUSION Mac", "3849d7cd0cdbe4f46333879cbed56492", 1029165, 600),
	WINGAME1("fusion", "", "FUSION.exe", "518a98696fe1122e08410b0f157f21bf", 1513751, 602),

	// Contains previews for educational and religious products for children and adults
	// Miscellaneous section contains an art package and an encyclopedia on pregnancy and birth
	WINGAME1_l("futsoft", "", "fs_demo.exe", "a593079aecf5bd938ce75264cac24b2d", 2091687, Common::AR_ARB, 600),

	// Original filename is 'インタラクティブ玩具店'
	MACGAME1_l("ganguten", "", "xn--dckb7a1dsbzgyf6cy650b9o1ahp2c", "d0bb81dd635d881620e56937b3a97d05", 118590, Common::JA_JPN, 602),
	WINGAME1t_l("ganguten", "", "GANGU.exe", "5aaa037ac67c88fbdcc878e63325222d", 1515326, Common::JA_JPN, 602),

	MACGAME1_l("garage", "",  "Garage",		"e5ed4533b25be47b708bb1245550cb2c", 118562, Common::JA_JPN, 650),
	WINGAME2t("garage",   "", "Garage.exe", "8e13d7be0966107e030f3ad7abf0c580", 1516264,
							  "open.swf",   "9ae5c59509bf2cba7f8678d514fbc3ae", 96640, 650),
	WINGAME2t_l("garage", "", "Garage.exe", "8e13d7be0966107e030f3ad7abf0c580", 1516264,
							  "open.swf",	"603b5e73868db3add430d62ddcce7d1c", 178668, Common::JA_JPN, 650),

	// Miel Monteur - Miel Bouwt Auto's! localized by Transposia
	// Dutch Mac demo is found in the Flipper & Lopaka compilation
	WINGAME1_l("garygadget1", "",	  "Willy32.exe",	   "d62438566e44826960fc16c5c23dbe43", 1518423, Common::DE_DEU, 650),
	WINDEMO1_l("garygadget1", "Demo", "miel.exe",          "518a98696fe1122e08410b0f157f21bf", 1512519, Common::NL_NLD, 602),
	MACDEMO1_l("garygadget1", "Demo", "Miel Monteur demo", "329aab81c0d74c5d3f31ddad26bcc639", 1029165, Common::NL_NLD, 600),

	// Dutch Windows version on same disc is D8
	MACGAME1_l("garygadget2", "", "Schiffe bauen mit Willy", "1eb3e6dd864a8a9bf5fbd63ea2bc8ebc", 1032634, Common::DE_DEU, 602),
	MACGAME2_l("garygadget2", "", "Game",                    "1d9149b9745e35ef93ed4cdf08ec3af7", 1030361,
								  "StartCD.dxr",             "07c672f1c05c4c12ac6abbb371a0ee1f", 24053, Common::NL_NLD, 600),
	WINGAME1_l("garygadget2", "", "Willy2.exe",				 "d62438566e44826960fc16c5c23dbe43", 1507905, Common::DE_DEU, 650),

	WINGAME1t_l("garygadget2", "", "Mullebat.exe", "1bb8255461245bc03a78c6c5079efd6e", 1522688, Common::NB_NOR, 602),

	MACGAME1_l("gasbook3", "", "GASBOOK3", "5ae5e3068e6b1fb4e5677cfbaef51515", 1034203, Common::JA_JPN, 601),
	WINGAME1t_l("gasbook3", "", "GASBOOK3.exe", "bb265ad1ae65aefd80f4a4a2e537864a", 1512553, Common::JA_JPN, 601),
	MACGAME1_l("gasbook3", "ici la lune (demo)", "ici la lune (demo)", "49b20f92c7b6cf7e5b6135cc692e8d26", 719876, Common::JA_JPN, 601),
	WINGAME1t_l("gasbook3", "ici la lune", "MOONPC1.exe", "437ee4c438cdd3047f36a3d00e7384c2", 6101238, Common::JA_JPN, 601),
	MACGAME1_l("gasbook3", "Microcosumos", "Microcosumos", "12075a95165837e4874e1867e7b0fdb6", 1133441, Common::JA_JPN, 601),
	WINGAME1t_l("gasbook3", "Microcosumos", "MICROCOS.exe", "f1347d0d7d2d11065a132e842600f9a3", 3418948, Common::JA_JPN, 601),

	MACGAME1_l("gasbook4", "", "GAS CITY", "319477b0f456e459201947c41064d33d", 118587, Common::JA_JPN, 601),
	WINGAME1t_l("gasbook4", "", "GAS_CITY.EXE", "e4a2118e48297ca2a476ba74420b079a", 1936788, Common::JA_JPN, 601),

	// Content from the first disc, 'Side 1'
	MACGAME1_l("gasbook5", "Antirom", "fruitpencer", "2bcd01161eb741dcf9506dc7432d1d7c", 1035204, Common::JA_JPN, 602),
	WINGAME1t_l("gasbook5", "Antirom", "fruitpencer.exe", "7ac2da9ff1093d6a8c9c926c6f831c17", 1910435, Common::JA_JPN, 602),
	MACGAME1_l("gasbook5", "Gorgerous", "GORGEROUS", "2bcd01161eb741dcf9506dc7432d1d7c", 1034296, Common::JA_JPN, 602),
	WINGAME1t_l("gasbook5", "Gorgerous", "GORGEROUS.exe", "624edbe33b963b3f78f070be722dafa0", 1910439, Common::JA_JPN, 602),
	// Original filename 'スーパーミルクちゃん'
	MACGAME1_l("gasbook5", "Hideyuki Tanaka", "xn--h9j8c2b3f1byi0d7dygb", "2bcd01161eb741dcf9506dc7432d1d7c", 1035204, Common::JA_JPN, 602),
	WINGAME1t_l("gasbook5", "Hideyuki Tanaka", "SUPERMILK.exe", "af41be23b3ea55a58169c6405895f33f", 1910455, Common::JA_JPN, 602),
	MACGAME1_l("gasbook5", "Imaitoons", "SPIDEAD", "2bcd01161eb741dcf9506dc7432d1d7c", 1032968, Common::JA_JPN, 602),
	WINGAME1t_l("gasbook5", "Imaitoons", "SPIDEAD.exe", "061d7a8d9ee9bc04bf19bf8e581808d0", 1710679, Common::JA_JPN, 650),
	// Original filename '%20' (yeah, actually)
	MACGAME1_l("gasbook5", "Jodi", "xn--20-da8l", "9b791fba37ea0eb1bc9717ddd2478cba", 1032378, Common::JA_JPN, 602),
	WINGAME1t_l("gasbook5", "Jodi", "xn--20.exe-ha20a", "6a5e3badb1368582af28dfb1db1f9c56", 1876545, Common::JA_JPN, 602),
	// Original filename is a single tabstop
	MACGAME1_l("gasbook5", "Katsuki Tanaka", "KATSUKI TANAKA/xn--p6j", "2bcd01161eb741dcf9506dc7432d1d7c", 1035232, Common::JA_JPN, 602),
	// Original filename is 'マー王王.exe'
	WINGAME1t_l("gasbook5", "Katsuki Tanaka", "xn--.exe-4s4cygl107ba", "567064352203f3e36f060d7b7bfbdf04", 1910457, Common::JA_JPN, 602),
	MACGAME1_l("gasbook5", "Sistema Solar Technologies Inc.", "xn--Sistema Solar Technologies Inc.-", "34479398d80e2af650174fdd1f3a7d3e", 1035232, Common::JA_JPN, 602),
	// Content from the second disc, 'Side 2'
	MACGAME1("gasbook5", "DOTMOV", "DOTMOV", "2bcd01161eb741dcf9506dc7432d1d7c", 1035232, 602),
	WINGAME1t("gasbook5", "DOTMOV", "DOTMOV.exe", "554c457a6189a433b28bd887306e6e58", 1911412, 602),
	MACGAME1_l("gasbook5", "FutureFarmers", "FutureFarmers", "2bcd01161eb741dcf9506dc7432d1d7c", 1034324, Common::JA_JPN, 602),
	WINGAME1t_l("gasbook5", "FutureFarmers", "FutureFarmers.exe", "44296bf74ce4896ccbe1e2c7a322eff2", 1910449, Common::JA_JPN, 602),
	MACGAME1_l("gasbook5", "groovisions", "GRV0911", "2bcd01161eb741dcf9506dc7432d1d7c", 1034256, Common::JA_JPN, 602),
	WINGAME1t_l("gasbook5", "groovisions", "GRV0911.exe", "d82aa9f3a6b02bd82eb0b0e8fe75e128", 1910447, Common::JA_JPN, 602),
	MACGAME1_l("gasbook5", "Ichiro Tanida", "Ichiro Tanida", "2bcd01161eb741dcf9506dc7432d1d7c", 1034296, Common::JA_JPN, 602),
	WINGAME1t_l("gasbook5", "Ichiro Tanida", "ICHIRO_TANIDA.exe", "e405783a91d8ffa261d4c792eeb5bed4", 1910437, Common::JA_JPN, 602),
	MACGAME1_l("gasbook5", "Fontrom Volume 2", "FONTROM2", "078483b4b9b3a88bcf2c322529e88bfb", 1035296, Common::JA_JPN, 602),
	WINGAME1t_l("gasbook5", "Fontrom Volume 2", "FONTROM2.exe", "690b272f3251feb2e65c2efa40000461", 1710689, Common::JA_JPN, 602),
	// Original filename is a series of spaces and tabs (<tab><tab><tab><tab><tab><space><tab><tab><tab>)
	MACGAME1_l("gasbook5", "patterns for modernities", "xn-- -caaaaabaa6ebbbbcbb", "2bcd01161eb741dcf9506dc7432d1d7c", 1032968, Common::JA_JPN, 602),
	WINGAME1t_l("gasbook5", "patterns for modernities", "pfm.exe", "229bf06d879da191478b26c447ef2b46", 1910453, Common::JA_JPN, 602),
	MACGAME1_l("gasbook5", "volumeone", "volumeone", "2bcd01161eb741dcf9506dc7432d1d7c", 1034324, Common::JA_JPN, 602),
	WINGAME1t_l("gasbook5", "volumeone", "volumeone.exe", "0d2812c175b45b7fab3479004e4d8624", 1826285, Common::JA_JPN, 602),
	MACGAME1_l("gasbook5", "Tota Chris", "start!!", "50fe84424f7945696d8c0ae98e4658a5", 1035232, Common::JA_JPN, 602),
	WINGAME1t_l("gasbook5", "Tota Chris", "CarbonicWater.exe", "b982146caa0bad2b4f85750a1f909da3", 1786590, Common::JA_JPN, 602),

	MACGAME1("gasbook6", "Anti-Rom", "cdgeez", "fa52f0136cde568a46249ce74f01a324", 111247, 602),
	WINGAME1t("gasbook6", "Anti-Rom", "CDGEEZA.exe", "e8073df19d36c85f3d15e220bc74371c", 3446208, 602),
	MACGAME1("gasbook6", "Daniel Jenett - jetfilm", "jetfilm", "2afb3de2b098fca8a06b5f133b910203", 1035268, 602),
	WINGAME1t("gasbook6", "Daniel Jenett - jetfilm", "jetfilm.exe", "cc847313de5ed673decf915acad33628", 2199712, 602),
	MACGAME1("gasbook6", "jodi", "-0FFSCR", "dc43d30c8a52d165c26319abb5258983", 1032335, 602),
	WINGAME1t("gasbook6", "jodi", "-OFFSCR.exe", "7788665622877779f8f7996685642d48", 1686169, 606),
	MACGAME1("gasbook6", "JONNI NITRO 1", "JN1", "078483b4b9b3a88bcf2c322529e88bfb", 1034360, 602),
	MACGAME1("gasbook6", "JONNI NITRO 2", "JN2", "078483b4b9b3a88bcf2c322529e88bfb", 1034360, 602),
	MACGAME1("gasbook6", "SKOT", "SKOT", "2afb3de2b098fca8a06b5f133b910203", 1035268, 602),
	WINGAME1t("gasbook6", "SKOT", "skot.exe", "f8090c50a402af6eb4a782d755789955", 1916105, 650),
	MACGAME1("gasbook6", "soulmatesGraphica - talking tommy", "talking tommy", "d75c9a4cc2c921cbcfa2e976bce9abd0", 1039241, 602),
	MACGAME1("gasbook6", "soulmatesGraphica - cruising on", "cruising on+", "d1d1ee07987a38fd726f152a52d96114", 1305708, 602),
	WINGAME1t("gasbook6", "soulmatesGraphica - talking tommy", "tomy.exe", "0db2058ef04a25155175d3fb6ffbc164", 3088746, 602),
	MACGAME1("gasbook6", "The Designers Republic", "DR-Infoburst", "a37dbec9be7989aed94fcacdad3747ea", 115767, 650),
	WINGAME1t("gasbook6", "The Designers Republic", "DR_Infoburst.exe", "c567e0a8cd2d59ccd687706105a1f530", 10470327, 602),

	WINDEMO1("generations", "v4.2 Demo", "GEN95.EXE", "a593079aecf5bd938ce75264cac24b2d", 15646702, 600),

	// Gigglebone Gang games (Beestenbende) were published in Belgium and the Netherlands by Zwijsen CD-ROMs
	// https://nationaalarchiefeducatievegames.nl/archief?filter=Headbone%20Interactive
	WINDEMO2_l("gigglecity", "Demo", "WIN95.EXE", "a593079aecf5bd938ce75264cac24b2d", 1700151,
									 "INTRO.DXR", "514a17949a7e30d2ed616c3954dadb7a", 3254498, Common::NL_NLD, 600),
	WINDEMO2_l("gigglefarm", "Demo", "WIN95.EXE", "a593079aecf5bd938ce75264cac24b2d", 1700151,
									 "INTRO.DXR", "c6e4a53180109b3bf4a156910aa042aa", 1070088, Common::NL_NLD, 600),

	// Language selection at start for High German / Swiss German
	MACGAME1_l("globiabc", "", "Globi's ABC Power PC", "0bc838e9350c4749e2d10523d620a2ad", 117356, Common::DE_DEU, 650),
	WINGAME1_l("globiabc", "", "GLOBI32.EXE", "d62438566e44826960fc16c5c23dbe43", 1711195, Common::DE_DEU, 650),

	// Windows screen saver is in BILDNT directory
	MACGAME1_l("globiss", "", "Globi's Bildschirmschoner", "512aa445bccb66babe48419237422745", 1150767, Common::DE_DEU, 650),
	WINGAME1_l("globiss", "", "GLOBISAZ.EXE", "6e893e1d588f51d9d6202410a38a73a6", 9857917, Common::DE_DEU, 650),

	// Published by A-Star Interactive (Singapore)
	WINGAME1("grammarplaytime2", "", "H_32.exe", "a593079aecf5bd938ce75264cac24b2d", 2234889, 600),

	WINGAME1_l("griezelbus1", "", "BUS95.EXE", "518a98696fe1122e08410b0f157f21bf", 1748606, Common::NL_NLD, 602),

	WINGAME1("hamletmurder", "", "PMHamlet.exe", "a593079aecf5bd938ce75264cac24b2d", 1873557, 600),

	WINGAME1t_l("historia", "", "HISTORIA.EXE", "1c213a176ea0441a145ebf6f1f5b9f66", 1508366, Common::SE_SWE, 600),

	WINGAME2t("im7s7s", "", "start.exe", "be7baec9613a6e07c6acdaad2c12a90f", 2931014,
							"more/seventh.dxr", "8f809a4856310c3fc44ac73be59ee365", 45067836, 650),

	// Based on the original I Spy CD-ROM, now with dozens of new challenges
	// Flemish Edition (c) 2000, Standaard Uitgeverij, Antwerp
	// Dutch Edition (c) 2000, Halloween Educational Software, Amsterdam
	// Mac installer creates an invisible projector file
	MACGAME1("ispyschool", "",	 "Play I Spy School Days", "fa259c68cd2594e863524ca7d18db67a", 116034, 650),
	MACGAME2_l("ispyschool", "", "Speel ik zie, ik zie",   "904cb6465321d8e1d12d2a5a29612050", 1029165,
								 "ISPYMAIN.DXR",		   "d46cbab557f938b88660e77c4fe64b5a", 7136056, Common::NL_BEL, 600),
	MACGAME2_l("ispyschool", "", "Speel ik zie, ik zie",   "904cb6465321d8e1d12d2a5a29612050", 1029165,
								 "ISPYMAIN.DXR",		   "e152e96487decca8ddc8ab16de55366e", 7156892, Common::NL_NLD, 600),
	WINGAME1("ispyschool", "",	 "Ispy.exe",			   "d62438566e44826960fc16c5c23dbe43", 1580375, 650),
	WINGAME1_l("ispyschool", "", "Ikzie32.exe",			   "a593079aecf5bd938ce75264cac24b2d", 1989859, Common::NL_BEL, 600),
	WINGAME1_l("ispyschool", "", "Ikzie32.exe",			   "a593079aecf5bd938ce75264cac24b2d", 1989785, Common::NL_NLD, 600),

	WINGAME1("js123", "", "JSNUMS.EXE", "f78f95afb7457fd465be3691a3932b15", 1532801, 602),

	MACGAME1("jsabc", "", "JumpStart LG ABCs", "833281980d0b2e2ffdf900a0e818f5d8", 116032, 602),
	WINGAME1("jsabc", "", "JSLG_ABC.exe", "518a98696fe1122e08410b0f157f21bf", 1588391, 602),

	MACGAME1("jslearn", "1997 D6 Demo", "JumpStart Previews", "9d08e05121dedcc5ee4c2a9495b78747", 987498, 600),
	MACGAME1("jslearn", "1998 Demo", "JumpStart Previews", "9d08e05121dedcc5ee4c2a9495b78747", 987818, 602),
	MACGAME1("jslearn", "1999 Demo", "JumpStart Previews", "fa259c68cd2594e863524ca7d18db67a", 115488, 602),
	WINGAME1("jslearn", "1997 D6 Demo", "PREV32A.EXE", "a593079aecf5bd938ce75264cac24b2d", 1509011, 600),
	WINGAME1("jslearn", "1998 Demo", "PREV32A.EXE", "518a98696fe1122e08410b0f157f21bf", 1513371, 602),
	WINGAME1("jslearn", "1999 Demo", "PREV32A.EXE", "518a98696fe1122e08410b0f157f21bf", 1601517, 602),

	MACGAME1("jsmusic", "", "JumpStart Music", "63e8b9f6744efefbb8a004a2b76e2b1d", 116032, 602),
	WINGAME1("jsmusic", "", "MUSIC.EXE", "f78f95afb7457fd465be3691a3932b15", 1532043, 602),

	MACGAME1("jsspanish", "", "JumpStart Spanish", "55d01cca925752c170ac1e9c01d1f87e", 1031646, 601),
	WINGAME1("jsspanish", "", "JSSPAN.EXE", "ece1c7a090010965890840102978e693", 1511580, 601),

	WINGAME1("jumpaheadss2000at", "", "ATEST.EXE", "a593079aecf5bd938ce75264cac24b2d", 1508221, 600),
	WINGAME1("jumpaheadss2000wb", "", "WORKBOOK.EXE", "a593079aecf5bd938ce75264cac24b2d", 1731863, 600),

	WINGAME1_l("kcd", "K15 2001", "V_Fi.exe", "518a98696fe1122e08410b0f157f21bf", 1704035, Common::FI_FIN, 602),

	WINGAME1("kingandi", "", "King&I.exe", "518a98696fe1122e08410b0f157f21bf", 1967220, 602),

	WINGAME2_l("kontyngent99", "", "START.EXE", "d62438566e44826960fc16c5c23dbe43", 1513041,
								   "MAIN.DXR",	"98b4f7339e1f8f6628035e6317f78912", 21043440, Common::PL_POL, 650),

	// Published by Future Soft of Nasr City, Cairo
	WINGAME1_l("ktaralarkam", "", "123.exe", "a593079aecf5bd938ce75264cac24b2d", 2748951, Common::AR_ARB, 600),

	WINGAME1_l("kultapossu", "", "POSSU_95.EXE", "518a98696fe1122e08410b0f157f21bf", 1531081, Common::FI_FIN, 602),

	WINDEMO1("landdesigner", "Demo", "CLD_DEMO.EXE", "518a98696fe1122e08410b0f157f21bf", 22576635, 602),

	WINGAME1("learninternet", "", "VIDPROF.EXE", "b0f3841f6e8005e519445b22de37749b", 2674733, 600),
	WINGAME1("learnworks2", "v4.0", "Vidprof.exe", "b0f3841f6e8005e519445b22de37749b", 2854401, 600),

	WINGAME1("letterrally", "1.0", "L_Rally.exe", "b0f3841f6e8005e519445b22de37749b", 3921651, 600),

	WINDEMO1("madtg", "1998 Demo", "MTGDSLID.EXE", "b0f3841f6e8005e519445b22de37749b", 1317661, 600),

	WINGAME1t("mcdonaldland", "", "McLand.exe", "f15f57b8b90986d6b34f8bf3a5487dfb", 1501901, 602),

	// Masters of the Elements - English and German (from lotharsm)
	// Original Dutch game Meesters van Macht released in 1997
	// Released in Germany as "Meister Zufall und die Herrscher der Elemente"
	// Developed by IJsfontein, published by Tivola
	// File version of MVM.EXE is 6.0.2.32
	// The game disc is a hybrid CD-ROM containing both the Windows and the Macintosh release.
	MACGAME2("melements", "",	"check.dxr",			  "f48ce7700bbf5f00a03373397b491a87", 898334,
								"Masters of the Elements", 0, 1034962, 602),
	WINGAME2("melements", "",	"CHECK.DXR",			  "c31ee30eebd24a8cf31691fc9926daa4", 901820,
								"MVM.EXE",				  0, 2565921, 602),
	MACGAME2_l("melements", "", "check.dxr",			  "bd320cbd150d4d54fec798ce0222bc63", 575554,
								"Meister Zufall",		  "398eb2cdf121feb490097c6323d52267", 1034962, Common::DE_DEU, 602),
	WINGAME2_l("melements", "", "CHECK.DXR",			  "d1cd0ed95b0e30597e0089bf3e5caf0f", 575414,
								"MVM.EXE",				  "518a98696fe1122e08410b0f157f21bf", 1512503, Common::DE_DEU, 602),

	WINGAME1("meetchuck", "", "HORSE.EXE", "b0f3841f6e8005e519445b22de37749b", 1130649, 600),

	// Mac version requires installation, Install Microshaft, Vise 3.6 installer
	WINGAME1t("microshaft", "", "MICRO32.EXE", "ae4c5d1b7e9c84a22cc32893a74469f6", 2121827, 600),
	MACGAME1("microshaft", "", " Microshaft Launcher", "089658f6d7d68f07eece8a68e5fdc35e", 115391, 600),

	MACGAME1_l("morisawa", "", "xn--o9jt62g2uibikdr4d", "6c317cf4d0d541b8f70626502d31fde9", 1035144, Common::JA_JPN, 602),
	WINGAME1t_l("morisawa", "", "MORISAWA.EXE", "40ec21a9805accd535cb6d03f26a3e56", 1516350, Common::JA_JPN, 602),

	MACGAME1("mulanpresskit", "", "Disney's Mulan", "d16e0af2a86b6b04a8f9c86205c0d3d2", 1031738, 601),
	WINGAME1("mulanpresskit", "", "MULAN.EXE", "ece1c7a090010965890840102978e693", 1828679, 601),

	MACGAME2_l("mumin1", "", "start", "1d9149b9745e35ef93ed4cdf08ec3af7", 1032405,
							 "mum1dir/01DALEN.DXR", "c90f2bb4d9479eedc47b9742422448a4", 3679416, Common::FI_FIN, 650),
	WINGAME2t_l("mumin1", "", "START.EXE", "f9522a8bce8bbc5300efa1699dee56c0", 1733522,
							  "MUM1DIR/01DALEN.DXR", "1e9170db3f9bac48df2ffd329b96f32d", 3679416, Common::FI_FIN, 600),

	WINGAME1("namegame", "1.0", "NTG.exe", "268206a2b95394636b750968be370c55", 3722937, 602),

	MACGAME1("netmarket", "", "netMarket", "ade290061bd8f78051a8e872a889855c", 1030738, 600),
	WINGAME1("netmarket", "", "NETMKT32.EXE", "3cb7a28198b9b8acd58d6d0e74272531", 1514399, 600),

	MACGAME1_l("ngeeva00pf", "", "EVA-00", "fd87b233709108cc1fb001523ce772f5", 1034175, Common::JA_JPN, 601),
	WINGAME1t_l("ngeeva00pf", "", "EVA-00.exe", "78a827f7380c27c19f0035843437cf9a", 1520172, Common::JA_JPN, 600),

	// Study guide from The Daily Telegraph
	// Mac executable filename does indeed end in .exe
	MACGAME1("nia4", "", "nia4.exe", "ee2cca33b022bed087aa3911f9ec78b1", 1032689, 650),
	WINGAME1("nia4", "", "nia4w95.exe", "d62438566e44826960fc16c5c23dbe43", 1711499, 650),

	// Original Mac filename is Nikolai's Treats™
	MACGAME1("nikolaitreats", "", "Nikolai's Treats", "ce0a3a5891a35b2dd2ab706e8e376baa", 1032717, 650),

	// Mac executable is originally Café
	// Choice of French or English gameplay at start
	MACGAME1("nightcafe", "", "Cafe", "e8fd8a7b24520e47344c2d9768a2479f", 1029193, 600),
	WINGAME1("nightcafe", "", "Cafe95.exe", "a593079aecf5bd938ce75264cac24b2d", 1701222, 600),

	MACGAME1_l("no", "#1", "NO#1", "4e6ee3e16e7e3860944a9fc21c348d48", 116326, Common::JA_JPN, 602),
	MACGAME1_l("no", "#2", "NO#2", "4e6ee3e16e7e3860944a9fc21c348d48", 116326, Common::JA_JPN, 602),
	WINGAME1t_l("no", "#1", "NO#1.EXE", "8619f2cb5220c0375c577a25ed465742", 1514179, Common::JA_JPN, 602),
	WINGAME1t_l("no", "#2", "NO#2.EXE", "533a1888d8005a98e48858fa63977617", 1514197, Common::JA_JPN, 602),
	WINGAME1t_l("no", "Screensaver", "No_saver.exe", "fffb27a504feaf07cdd68ec88d708b99", 1822020, Common::JA_JPN, 602),

	// US name is Noddy: Playtime in Toyland
	WINGAME1_l("noddyschool", "", "Noddy.exe", "518a98696fe1122e08410b0f157f21bf", 1552898, Common::EN_GRB, 602),
	WINGAME1_l("noddyschool", "", "NODDY.EXE", "518a98696fe1122e08410b0f157f21bf", 1556536, Common::EN_USA, 602),

	// Found on NY Knicks CDK from CDKNet LLC, Garden City, New York
	// Extremely annoying, play with sound off
	WINGAME2("nykshuffle", "", "KNICKS.EXE",  "d62438566e44826960fc16c5c23dbe43", 4229955,
							   "CDKPLAY.KXE", "a3b34c0871dc2fd51eec5559b68f709d", 4, 650),

	// Designed and produced by C-Squared Studios, Caldwell, New Jersey (1998)
	MACGAME1("nyyankeesyb", "", "start-ppc",	 "fa259c68cd2594e863524ca7d18db67a", 115115, 650),
	WINGAME2("nyyankeesyb", "", "START95.EXE",	 "d62438566e44826960fc16c5c23dbe43", 1544371,
								"tradition.dxr", "05bc2cd75e7bd414d735d2fc91835989", 1206863, 650),

	// Found on covermount of CD-ROM Today (Brazil) Volume 4 Número 16
	// Only a 16-bit executable is provided
	WINGAME1_l("objetivo", "", "OBETIVO.EXE", "b0f3841f6e8005e519445b22de37749b", 11660888, Common::PT_BRA, 600),

	// O!Kay is a monthly magazine for German students in grades 1 to 4 to learn English.
	// If ordered, every three months a CD-ROM is included with unique educational games.
	// The "Try out" demos most likely also required paid subscriptions.
	MACGAME1_l("okaydemo", "",		"O!Kay!  Demo",	"a40c77fb7f0033d5a9c1c8d526244729", 1036504, Common::DE_DEU, 650),
	WINGAME2_l("okaydemo", "",		"START32.EXE",	"1b8d78ddca650041b8997cac7af3184b", 2027288,
									"TITEL.DXR",	"ade368a04615f440386c74f0266dc7f7", 216938, Common::DE_DEU, 650),
	MACGAME2_l("okaydownunder", "", "Start",		"136e1ab1d4d13168964afb699bda13aa", 1034240,
									"Titel.dxr",	"48e1ee3d905895ef775761a60cefe056", 1505702, Common::DE_DEU, 650),
	WINGAME1_l("okaydownunder", "", "Ok49932.exe",	"1b8d78ddca650041b8997cac7af3184b", 1890546, Common::DE_DEU, 650),
	MACGAME2_l("okaydragon", "",	"Start",		"3cef8710f4eddbe16fa186b198833ace", 1034014,
									"Titel.dxr",	"8f4430db871ea50643037a16274fb6e4", 858265, Common::DE_DEU, 650),
	WINGAME1_l("okaydragon", "",	"Ok29932.exe",	"1b8d78ddca650041b8997cac7af3184b", 2109486, Common::DE_DEU, 650),
	MACGAME2_l("okayfriends", "",	"Start",		"136e1ab1d4d13168964afb699bda13aa", 1034240,
									"Titel.dxr",	"d390b52b55266630faf7d9697c271605", 1857650, Common::DE_DEU, 650),
	WINGAME1_l("okayfriends", "",	"Ok10032.exe",	"d62438566e44826960fc16c5c23dbe43", 2278721, Common::DE_DEU, 650),
	MACGAME2_l("okayhenry", "",		"Start",		"136e1ab1d4d13168964afb699bda13aa", 1034204,
									"titel.dxr",	"db3b00a35d78d6065ee36c7f60558fe6", 698410, Common::DE_DEU, 650),
	WINGAME1_l("okayhenry", "",		"Ok19932.exe",	"1b8d78ddca650041b8997cac7af3184b", 2009104, Common::DE_DEU, 650),
	MACGAME2_l("okaytruehero", "",	"Start",		"136e1ab1d4d13168964afb699bda13aa", 1034240,
									"Titel.dxr",	"e8b13e9e34dcfbdd4481f7f0b8209903", 1134260, Common::DE_DEU, 650),
	WINGAME1_l("okaytruehero", "",	"ok39932.exe",	"1b8d78ddca650041b8997cac7af3184b", 1883584, Common::DE_DEU, 650),

	WINGAME1t_l("onsalakorv", "", "onsala.EXE", "41d87422d7c0f48886a99a7fe05ba1c0", 1713409, Common::SE_SWE, 650),

	MACGAME2_l("pantosstory", "", "START", "7d0c7ae431938c53e64d443b05bf19fd", 1035232,
								  "PANTOS/A00.Dxr", "a36c3a6044d0dbcfa30b147cbdfc4f5f", 1367720, Common::JA_JPN, 602),
	WINGAME2t_l("pantosstory", "", "START.EXE", "0aabeac068ad6048f8c7ed19ac7458ea", 1861862,
								  "PANTOS/A00.DXR", "cadb6e5b4dd143c7754b31026f4c2676", 1367720, Common::JA_JPN, 602),

	WINGAME1t_l("pettson1", "", "GUBBEN.EXE", "9ee9a4d1112db68a3a64f26d043518a3", 1341473, Common::NB_NOR, 600),

	WINGAME2_l("pettson2", "", "START32.EXE", "518a98696fe1122e08410b0f157f21bf", 1723219,
							   "START.DXR",	  "18d333b1b9b02d76b35a07252046d295", 37384, Common::SE_SWE, 602),
	WINGAME2t_l("pettson2", "", "START32.EXE", "28eec06adcc3671e6bc67c27c58976d1", 2986791,
	           "Pinnspel.dxr", "c1e66de74590ba3ad88ea1650b8cfd80", 5085428, Common::DE_DEU, 602),

	// German version is D7
	MACGAME1_l("pettsonjk", "", "Starta kalendern",		 "98f39f06e78cc7d3e20b498d30f737b6", 1029165, Common::SE_SWE, 600),
	MACGAME1_l("pettsonjk", "", "Pesosen joulukalenteri", "3aaab7a6b2cbcc767f839bd6d8d3dd26", 1032582, Common::FI_FIN, 602),
	WINGAME1_l("pettsonjk", "", "PETWIN95.EXE", "a593079aecf5bd938ce75264cac24b2d", 1702396, Common::SE_SWE, 600),
	WINGAME1_l("pettsonjk", "", "PETWIN95.EXE", "518a98696fe1122e08410b0f157f21bf", 1738188, Common::FI_FIN, 602),

	// Global Software Products catalogue # 1282B (1999) and 1282C (Favourites, 2006)
	WINGAME2("pingu1", "1282B", "PINGU.EXE",	"d62438566e44826960fc16c5c23dbe43", 1570152,
								"BBCLOGO.DXR",	"0af3596b90ae5ee1fcd14c4a84d72c5f", 1516128, 650),
	WINGAME1t("pingu1", "1282C", "Pingu.exe",	"9c45cf40937389a60376270df0727459", 1999206, 650),
	// Pingu: La collection de tout-petits
	// French version by Hachette Multimédia
	// Uninstaller is also Director
	// MACGAME1("pingu1", "", "Supprimer Pingu", "5c4cee7e93b3ee1dbc7ce29e8e26ecd7", 1032759, Common::FR_FRA, 601),
	MACGAME1_l("pingu1", "", "Pingu", "5c4cee7e93b3ee1dbc7ce29e8e26ecd7", 1032759, Common::FR_FRA, 601),
	WINGAME1t_l("pingu1", "", "PINGU.EXE", "92bec8aaa2eb0534fcaa8926550af7e6", 2210575, Common::FR_FRA, 602),

	WINGAME1t("pinguss", "Screen Saver Selector, 1282C", "SetSaver.exe", "0f21f1be9dd5342dba28168ab3841378", 2736484, 602),
	WINGAME1t("pinguss", "Screen Saver Player, 1282C", "Pingu_ss.exe", "75ef68e4bb5b6d0cc4f2bd194dccd1d1", 1513419, 602),
	WINGAME1t_l("pinguss", "Screen Saver Selector", "xn--Slecteur d'crans Pingu-b8bk", "5c4cee7e93b3ee1dbc7ce29e8e26ecd7", 1032759, Common::FR_FRA, 601),
	WINGAME1t_l("pinguss", "Screen Saver Player", "Pingu Prefs/xn--Economiseur d'cran Pingu-ofc", "5c4cee7e93b3ee1dbc7ce29e8e26ecd7", 1178287, Common::FR_FRA, 601),
	WINGAME1t_l("pinguss", "Screen Saver Selector", "SETSAVER.EXE", "38009fd3ab76cfa53e042cfa237a1e0e", 2960627, Common::FR_FRA, 602),
	WINGAME1t_l("pinguss", "Screen Saver Player", "PINGU_SS.EXE", "580c32dab238a74b0b301c30d0eebbd4", 1710441, Common::FR_FRA, 602),

	// Mac version requires installation, BBC Pingu and Friends Installer, Vise 5.5.2 installer
	// Windows version identical to GSP 1283B (Double the Fun, 2007)
	// Dutch version is D10
	WINGAME1t("pingu2", "", "INSTDATA/PINGU.EXE", "7a0cacb2cf70098385095aa75b08d410", 1570152, 602),
	MACGAME1("pingu2", "", "BBC Pingu and friends", "63e8b9f6744efefbb8a004a2b76e2b1d", 115739, 650),

	// Four disc game, but the Director executable is only on disc 1
	MACGAME1_l("pinkgear2", "", "PINK GEAR/Go To PINK GEAR", "b8bf83e119ac8980193921b8c5eabb2c", 118654, Common::JA_JPN, 602),
	WINGAME1_l("pinkgear2", "", "PINK GEAR/Go To PINK GEAR.exe", "45871c12eb944f09f50ee742113a1e2d", 2215164, Common::JA_JPN, 602),

	WINGAME1_l("plcd", "Nº11 1998", "submarine.exe", "a593079aecf5bd938ce75264cac24b2d", 1700379, Common::RU_RUS, 600),
	WINGAME2_l("plcd", "Nº12 1998", "Start.exe",	 "d62438566e44826960fc16c5c23dbe43", 1919710,
									"Mainmenu.dxr",	 "23c87266e4b249d6cb25c09c50ae0666", 10447472, Common::RU_RUS, 650),

	// DVD-ROM content from Planetary Traveler movie
	WINGAME1("planetrav", "", "PCDVD.EXE", "a593079aecf5bd938ce75264cac24b2d", 2345815, 600),

	// Projectors on the installation disc for Swedish, Norwegian, Danish, Finnish
	MACGAME1_l("polis1", "", "KRIPOS", "921df0a5f150a57b621baa2cace66e12", 1032653, Common::NB_NOR, 650),
	MACGAME1_l("polis1", "", "STRISSER", "921df0a5f150a57b621baa2cace66e12", 1032653, Common::DA_DNK, 650),
	MACGAME1_l("polis1", "", "POLIS", "921df0a5f150a57b621baa2cace66e12", 1032653, Common::SE_SWE, 650),
	MACGAME1_l("polis1", "", "POLIISI", "921df0a5f150a57b621baa2cace66e12", 1032653, Common::FI_FIN, 650),
	WINGAME1_l("polis1", "", "Kripos.exe", "d62438566e44826960fc16c5c23dbe43", 1514881, Common::NB_NOR, 650),
	WINGAME1_l("polis1", "", "Strisser.exe", "d62438566e44826960fc16c5c23dbe43", 1514881, Common::DA_DNK, 650),
	WINGAME1_l("polis1", "", "Polis.exe", "d62438566e44826960fc16c5c23dbe43", 1514881, Common::SE_SWE, 650),
	WINGAME1_l("polis1", "", "Poliisi.exe", "d62438566e44826960fc16c5c23dbe43", 1514881, Common::FI_FIN, 650),

	MACGAME1("poohlearn", "", "Learning Demos", "83b232d2d02d9238e481019eb93e7194", 2766, 650),
	WINGAME1("poohlearn", "", "demos.exe", "d62438566e44826960fc16c5c23dbe43", 2313191, 650),

	// Mac demo is from Disney Interactive Learning Sampler CD
	// Mac installer uses Director 7.0.2
	MACDEMO1("poohp", "D6 Demo", "PSchool.Mac", "e0eb86f93a9fba6ea6c4141eed29d923", 116023, 650),
	WINDEMO1("poohp", "D6 Demo", "PSchool.exe", "d62438566e44826960fc16c5c23dbe43", 1501560, 650),

	MACGAME1_l("poporon", "", " PoPoRon", "68a0694e294e201c167feff1953eb8ce", 118587, Common::JA_JPN, 601),
	WINGAME1t_l("poporon", "", "POPORON.EXE", "37c0c99d35e762a2f44ef93732bc9337", 1799789, Common::JA_JPN, 601),

	// From Russian "Pyatachok Anthology" DVD, games are Eng/Rus
	WINGAME1t("pyatachok2", "", "Pig2.exe", "60d9a1a113aff3c5481afdc445e00ac0", 1704003, 602),
	WINGAME1t("pyatachok3", "", "Pongo 3.exe", "f1363e5fbef1e0450de9d1f74641f980", 1703971, 602),
	WINGAME1t("pyatachok4", "", "Pig4.exe", "e267270ccb1f1c985cbbd02a3f4e3030", 1703949, 602),

	// Original file name is RealPool™
	MACGAME1("realpool", "", "xn--RealPool-on5d", "269b100b24bda808238eb6feb183781f", 114791, 600),

	MACGAME1_l("requiem", "", "Requiem", "996eca6a1e73c99493ea7e553f2e0db6", 1030510, Common::SE_SWE, 601),
	WINGAME1t_l("requiem", "", "Requiem.exe", "bdd6110d880b41f29b8e98f9c4406eb6", 1515454, Common::SE_SWE, 601),

	// American Revolutionary War
	MACGAME2("revwar", "", "BEGIN",		   "2806e0d1bac713be5677a62b425d3c98", 1030361,
						   "mainmenu.dxr", "9343ddc8818f99929eeb1067b8329707", 5592862, 650),
	WINGAME2("revwar", "", "BEGIN.exe",	   "d62438566e44826960fc16c5c23dbe43", 1514063,
						   "mainmenu.dxr", "1b6c62ffd84ac53fce242a8f0a4cc337", 5839626, 650),

	// Edison: Bio-Mania
	WINGAME2_l("robidoc", "", "start.exe", "518a98696fe1122e08410b0f157f21bf", 1518949,
							  "Bio.exe", "55180c6a904d1b35c6ae60cab1f84949", 188408, Common::NL_NLD, 600),

	WINGAME1t_l("rymdjakten", "Romjakten", "ROMJAKT.EXE", "c4259b2ecfd421bd28f29b8a6ddf42f3", 1522656, Common::NB_NOR, 602),
	MACGAME1t_l("rymdjakten", "Romjakten", "Romjakten", "960f8041921e1ca6c0781cb0f17abc25", 1032378, Common::NB_NOR, 602),

	// Found on Let's Play with "Sakura"
	// This directly runs the screen savers available on the CD
	// Original filename is さくらのscrセレクタ
	MACGAME1_l("sakurascr", "", "Sakura's scr selector", "65063397536553c4f6ff2a6c07194bf7", 1822055, Common::JA_JPN, 602),

	// Original filenames are さくらとあそぼ
	MACGAME1_l("sakuratoasobo", "", "Let's Play with Sakura", "8d83064402198a909b0abcebc6b46d2b", 118198, Common::JA_JPN, 602),
	WINGAME1_l("sakuratoasobo", "", "Let's Play with Sakura.exe", "45871c12eb944f09f50ee742113a1e2d", 1982850, Common::JA_JPN, 650),

	WINGAME2_l("samson", "", "start.exe", "a593079aecf5bd938ce75264cac24b2d", 1919963,
							 "GOSCHOT.DXR", "045e8b0091317831da84596f807779cd", 161404, Common::NL_NLD, 600),

	MACGAME1("secretwriters", "", "Secret Writer's Society", "1b0e3f44bd18e81164b424a268e4fdf7", 1028926, 600),
	WINGAME1t("secretwriters", "", "WRITING.EXE", "48c8c31df289713b629af6a4c4e519fb", 1508719, 600),


	MACGAME1("shrlucky", "", "Arcade", "dab7a517b0877454d1e16c40c9b5a9be", 1029193, 600),
	WINGAME1("shrlucky", "", "COPYARC/ARCWIN95.EXE", "a593079aecf5bd938ce75264cac24b2d", 7304861, 600),

	// From Elmo's Art Workshop CD
	WINDEMO1t("shrmess", "Demo", "SHRM14.EXE", "fc37d09a744d04f7dd5b31e0ab9f50e6", 1318025, 606),
	MACDEMO1("shrmess", "Demo", "MATH ESSENTIALS DEMO", "b0b0e36586489ca6070d20feeff52fa5", 1028001, 606),

	// German/English bilingual
	MACGAME2("smallfish", "", "Small_Fish", "7a36d53490a07ddc212b65cad9ed11f3", 115767,
							  "data/casts/scripts.cxt", "b56dd8f86edc9b21f88c6363109ab219", 191362, 600),
	WINGAME2t("smallfish", "", "START.EXE", "5b9294e4836af8dc30a7e8a8fc799bb2", 1527107,
							   "data/casts/scripts.cxt", "54978ce7d55a5a2c58d7234fddc961b2", 191362, 602),

	WINGAME1("ss007", "", "007.exe", "d62438566e44826960fc16c5c23dbe43", 4971852, 650),

	MACGAME1("ssgbi", "", "GBI Screen Saver", "9c9907925c1bf80a71ae27f423925725", 1130762, 601),

	// Part of "Lee Pipes Press Kit"
	// Both versions require installation
	MACGAME1("ssleepipes", "", "pipes",		"dc48a185cfddce0d48a199fd25e328ac", 94195, 650),
	WINGAME2("ssleepipes", "", "pipes.exe", 			  "a593079aecf5bd938ce75264cac24b2d", 1545446,
							   "pipes_data/episode1.dxr", "45b6a2d7952903bd554c82c0a0d6044a", 2809574, 600),

	// Screen savers found on Let's Play with "Sakura" activity CD
	// Mac versions are D5
	WINGAME1_l("sskero", "",	 "Kero.exe",	 "45871c12eb944f09f50ee742113a1e2d", 1730497, Common::JA_JPN, 650),
	WINGAME1_l("sssakura", "",	 "Sakura.exe",	 "45871c12eb944f09f50ee742113a1e2d", 1736349, Common::JA_JPN, 650),
	WINGAME1_l("ssyamazaki", "", "Yamazaki.exe", "45871c12eb944f09f50ee742113a1e2d", 3854052, Common::JA_JPN, 650),
	WINGAME1_l("ssyukito", "",	 "Yukito.exe",	 "45871c12eb944f09f50ee742113a1e2d", 5003908, Common::JA_JPN, 650),

	// Mac version is D5
	WINGAME1("ssrevwar", "", "Revwar.exe", "d62438566e44826960fc16c5c23dbe43", 21088827, 650),

	MACGAME1_l("startover", "", "START OVER", "a9351ab8f542c648b3e7db3957d5c102", 118562, Common::JA_JPN, 602),
	WINGAME1t_l("startover", "", "START OVER.EXE", "5b3c75060e6c0ec4fd463ae5fcf68e23", 1733326, Common::JA_JPN, 602),
	// Standalone app contained in a subdirectory
	MACGAME1_l("startover", "motion dive", "motion dive (Harada ver.)", "0c1f969fbe24210107d0db4194b15d61", 118806, Common::JA_JPN, 600),
	WINGAME1t_l("startover", "motion dive", "motion dive HD.exe", "fe36065675486a97715027200f230783", 5135271, Common::JA_JPN, 602),

	// From Microshaft Winblows, full game is D5
	MACDEMO1("starwarped", "Preview", "Star Warped Preview", "089658f6d7d68f07eece8a68e5fdc35e", 115391, 600),
	WINDEMO1t("starwarped", "Preview", "EWOK32.EXE", "9502e2cb4d6e767310b908950bb7f74b", 1701371, 600),

	// Developed by Accurate Research, Inc. of Sunnyvale, California (1998)
	// Part of the Super Tutor series sold through Homeworkhelp.com
	// Found in the Middle School Advantage 2001 bundle and High Achiever Grammar from PC Treasures
	WINGAME1("supertutorgram", "v1.0", "GRAMMAR.EXE", "a593079aecf5bd938ce75264cac24b2d", 1853673, 600),

	WINDEMO1_l("tchaik", "Demo", "TCHAIK.EXE", "a593079aecf5bd938ce75264cac24b2d", 15780729, Common::RU_RUS, 600),

	WINGAME1("technik", "", "Techni00.exe", "1b8d78ddca650041b8997cac7af3184b", 1615559, 650),

	WINGAME1("thesims", "", "maxis.exe", "d62438566e44826960fc16c5c23dbe43", 1915533, 650),

	// ein Fall für TKKG: Tödliche Schokolade (bilingual DE/EN)
	MACGAME2("tkkg2", "", "TKKG start", "7ce3e3594ca71914e50806cf934ac714", 1032378,
						  "SCORE.DXR",  "4d3d5b66729e31d35828e40aee85fe39", 10849, 602),
	WINGAME1t("tkkg2", "", "TKKG2_95.EX_", "913a935918698c299c30b96b6b696ba2", 1705034, 602),
	// Dutch numbering is different from German originals
	// Een zaak voor TKKG 2: dodelijke chocolade (bilingual NL/EN)
	WINGAME1_l("tkkg2", "", "Tkkg2_95.exe", "518a98696fe1122e08410b0f157f21bf", 1705034, Common::NL_NLD, 602),

	// ein Fall für TKKG: Der Schatz der Maya (bilingual DE/EN)
	MACGAME2("tkkg3", "", "TKKG start", "017b653021b4e4896e6a50cc5fedb24c", 1032378,
						  "SCORE.DXR",  "03b65143b31d75bf149da998877029b0", 11197, 602),
	WINGAME1t("tkkg3", "", "TKKG3_95.EX_", "c5dcc31f2d26e29c18f87e0524eac70f", 1513532, 602),
	// Een zaak voor TKKG 1: De schat van de Maya's (bilingual NL/EN) (Demo)
	WINDEMO2t_l("tkkg3", "Demo", "start.exe", "e39e34d0866c08539cb557af3a45c00e", 1289732,
								 "DEMO_00.dxr", "d3793c1016aea64ebabeeca7c4e3a65d", 2488656, Common::NL_NLD, 602),
	MACDEMO2_l("tkkg3", "", "start", "b0b0e36586489ca6070d20feeff52fa5", 1026645,
							"DEMO_00.DXR", "1ea80b7d22a6db7ce669a988812f0d64", 2488656, Common::NL_NLD, 606),

	// ein Fall für TKKG: Das Rätsel der Villa Drachenkralle (bilingual DE/EN)
	MACGAME2("tkkg4", "", "TKKG start", "b21aa60a64051a4f3873b1500444aa3b", 1032378,
						  "SCORE.DXR",  "26a12f39d812059982637f153dad58a8", 1162642, 602),
	WINGAME1t("tkkg4", "", "TKKG4_95.EX_", "8d61eba98b5da877fe293e97cf0fcadd", 1513570, 602),
	// Een zaak voor TKKG 5: het raadsel van villa Drakenklauw (bilingual NL/EN)
	WINGAME1_l("tkkg4", "", "tkkg4_95.exe", "518a98696fe1122e08410b0f157f21bf", 1513570, Common::NL_NLD, 602),

	// ein Fall für TKKG: Verrat an TKKG (bilingual DE/EN)
	MACGAME2("tkkg5", "", "TKKG Start", "cf534db714fe9bd4c6059755094f9bed", 1037002,
						  "Score.dxr",  "a9fc73baaaae5693650b555b173eb328", 27052, 602),
	WINGAME1t("tkkg5", "", "TKKG5_95.ex_", "4e86d530315553774f70ad9ad61e0c52", 1597094, 602),

	// ein Fall für TKKG: Der Fälscherbande auf der Spur (bilingual DE/EN)
	MACGAME2("tkkg6", "", "TKKG-Start", "dd58f1859ddab9bf15867a510cf7bfe4", 1033758,
						  "Score.dxr",  "3b6e459f27a81a5f33c8b2bccefe6888", 26322, 650),
	WINGAME1t("tkkg6", "", "Tkkg6_32.exe", "52239d8b9852067433fbce14928fe650", 1594089, 602),

	// Bilingual Japanese/English
	MACGAME1("tomato", "",  "tomato2", "9c595b98af545997155f2f020ad2ec5f", 1028001, 606),
	WINGAME1t("tomato", "", "TOMATO2.EXE", "82536fc9800cf7fabda97c74cca3ed8f", 1550097, 606),

	MACGAME1("traitorsgate", "", "Traitors Gate", "65063397536553c4f6ff2a6c07194bf7", 1935940, 650),
	MACGAME1("traitorsgate", "DVD", "Traitors Gate", "65063397536553c4f6ff2a6c07194bf7", 1933716, 650),
	WINGAME1t("traitorsgate", "", "TGstart.exe", "4c2e7bffa671bc537ff8e93fd51d4139", 2074713, 650),
	WINGAME1t("traitorsgate", "DVD", "TGstart.exe", "4c2e7bffa671bc537ff8e93fd51d4139", 2072959, 650),
	WINGAME1("traitorsgate", "", "TRG001.EXE", "b762d2cc3f7db2a6446135917fe92496", 2072959, 650),

	MACGAME1("trekpedia98", "", "Ency98 Player", "b0b0e36586489ca6070d20feeff52fa5", 1091806, 600),
	WINGAME1("trekpedia98", "", "ENCY98.EXE", "35f1550747fcf691283b0f2486144e2b", 1707566, 600),

	MACGAME1("trekship", "", "Starship Creator/Starship Creator", "f26885badb07dcf3a79defda517d4ddb", 1055900, 650),
	MACGAME1("trekship", "Mission Watcher", "Starship Creator/ShipMain/Mission Watcher", "ce8cd9917c9ba9d454d8ed71478a1486", 113475, 650),
	WINGAME1t("trekship", "", "sscreate.exe", "701fb8cda51a79d3a768a7f612025fd5", 1910562, 602),
	WINGAME1t("trekship", "Mission Watcher", "ShipMain/MssnWchr.exe", "749923faa5cd1c281089a2143c4510ad", 1518003, 602),

	// Mac version requires installation, Creator Add-On Installer, Vise 3.6 installer
	MACGAME1("trekshipaddon", "", "Starship Creator Add-On Pack", "1d5dcfc080add51c584a7111cf80a404", 1057502, 650),
	MACGAME1("trekshipaddon", "Mission Watcher", "ShipMain/Mission Watcher", "ce8cd9917c9ba9d454d8ed71478a1486", 113475, 650),
	WINGAME1t("trekshipaddon", "", "addonpak/sscreate.exe", "68d5ccbfc4921c19d1d46b866ec4080d", 2753651, 602),
	WINGAME1t("trekshipaddon", "Mission Watcher", "addonpak/ShipMain/MssnWchr.exe", "749923faa5cd1c281089a2143c4510ad", 1518003, 602),

	// Overview of Tutti's Magical Stories series
	WINGAME1_l("tutti", "", "TUTTI.EXE", "a593079aecf5bd938ce75264cac24b2d", 14715583, Common::RU_RUS, 600),

	// Promotional item produced by Chester Square, London
	WINGAME1("twine", "", "bond.exe", "d62438566e44826960fc16c5c23dbe43", 14288637, 650),

	// Original filename is '海釣り三昧'
	MACGAME1_l("ukiukiitsudemo", "", "xn--nbkx10ghrq4vg9p1c", "a00a1a1ccf38e246513d66ce47c52bdb", 1033359, Common::JA_JPN, 601),
	WINGAME1t_l("ukiukiitsudemo", "", "UMITURI.EXE", "732605d38e43561a547893ee6f857081", 1052363, Common::JA_JPN, 601),

	WINGAME1("void", "", "VOID.exe", "1154a54e6fb77f82e9091a9adc37a4cb", 1701070, 602),

	// Launcher included in european version of the game, contains instructions, lore and credits
	WINGAME1("voyeur2", "Launcher", "voyeur2.exe", "e7bccfe54354d08a9d2d0e181f66406b", 2003432, 602),

	// CD check projector uses Win95 GUI mockup to ask your drive speed then launch game
	WINGAME1("wiggles1", "", "WIGGLES.EXE", "d62438566e44826960fc16c5c23dbe43", 1862279, 650),

	// Found on Disc Inferno from APC magazine (Australia), Dec 1999
	MACGAME1("wonkatrivia", "v1.0", "wonkatriviaPPC.prj", "c2f8ae6c5a7b8f9aab5597f7de517443", 113731, 650),

	WINGAME1("worldnet", "", "EGUIDE95.EXE", "518a98696fe1122e08410b0f157f21bf", 2876414, 602),

	WINDEMO2t("xfiles", "CD Demo", "X-Files.exe", "44a15040c26429c13411859d6fd03bbf", 1527961,
								   "INTRO.DXR",   "8de2b376be89ec9611d489a8a90bb2c9", 1844200, 600),

	// Mac version requires installation, Install The X-Fools, VISE 3.5 installer
	WINGAME1t("xfools", "", "xfools32.exe", "e4621a51bf38b4e15d407913df781392", 2115343, 600),
	MACGAME1("xfools", "", "The X-Fools", "41fa2186d635be3094403c75b5f44d4b", 113127, 600),
	MACDEMO1("xfools", "Preview", "The X-Fools Preview", "41fa2186d635be3094403c75b5f44d4b", 115391, 600), // Star Warped
	WINDEMO1t("xfools", "Preview", "XMAN32.EXE", "9502e2cb4d6e767310b908950bb7f74b", 1701371, 600), // Star Warped + Microshaft Winblows
	MACDEMO1("xfools", "Preview", "The X-Fools Preview", "089658f6d7d68f07eece8a68e5fdc35e", 115391, 600), // Microshaft Winblows

	// Disc 2 has no director content
	WINGAME2t("xfua", "", "X-FILES.EXE", "44a15040c26429c13411859d6fd03bbf", 1719387,
						  "LAUNCH.DXR",	 "e44000f96f5e329da90d25779cb14995", 30096, 602),

	MACGAME1_l("xtown1", "", "GIFTET", "7a36d53490a07ddc212b65cad9ed11f3", 116103, Common::SE_SWE, 650),
	WINGAME1t_l("xtown1", "", "GIFTET.EXE", "dd8c395cb1b40eee169f022b16a1c0bd", 1521398, Common::SE_SWE, 600),

	// Original Mac filename is 妖怪図鑑2
	MACGAME1_l("yokai400", "", "xn--2-we0by4fq4jlr4e", "d14bf1f7a413df29a04b8fbc7a0fe81f", 1033551, Common::JA_JPN, 601),
	WINGAME1_l("yokai400", "", "YOUKAI2.EXE", "3703e9ea28aed0c647b73a1b49a51d65", 1512615, Common::JA_JPN, 601),

//////////////////////////////////////////////////
//
// Macromedia Director v7
//
//////////////////////////////////////////////////

	MACGAME2_l("affaires1", "", "Start Me", "0944b962ebb00f4b5d5149d220f8449b", 125495,
								"Main - 7.dxr", "4fa7c071ea2e934eaf9d6f4ef3205ecf", 13068189, Common::FR_FRA, 702),
	WINGAME2_l("affaires1", "", "StartMe.exe", "7c18c9a6af2694156bf09ed195c1ab09", 1819926,
								"Main - 7.dxr", "ad34b9d4987fc84c238f0e88b174fbc9", 13068061, Common::FR_FRA, 702),

	// Windows installer, install.exe, also uses Director
	MACGAME1_l("allthelunar", "Gallery", "xn--2bkwb2jyaf2iv50xg56c", "91723348f6414e84d024183554385275", 110811, Common::JA_JPN, 701),
	WINGAME1t_l("allthelunar", "Gallery", "gallery.exe", "dc43ed7868f092e8f59a640766438b38", 13403016, Common::JA_JPN, 701),
	MACGAME1_l("allthelunar", "Daifugo", "xn--pss84d253e", "d2404d3c2d1df0ca4125e85b1ca97e96", 22329996, Common::JA_JPN, 701),
	WINGAME1t_l("allthelunar", "Daifugo", "DAIFUGO.exe", "d2404d3c2d1df0ca4125e85b1ca97e96", 22329996, Common::JA_JPN, 701),
	// Japanese name 'ルーナの着信メロディメーカー'
	// Japanese filename '着信メロディメーカー'
	MACGAME1_l("allthelunar", "Luna no Chakushin Melody Maker", "xn--2bkuay9hyfd4f3fb5910fxrwe", "f670d62dfbf3f42c475b4f09c68f1888", 5839096, Common::JA_JPN, 701),
	WINGAME1t_l("allthelunar", "Luna no Chakushin Melody Maker", "melody.exe", "f670d62dfbf3f42c475b4f09c68f1888", 5839096, Common::JA_JPN, 701),

	MACGAME1_l("abcpacovska", "", "30Mo", "0944b962ebb00f4b5d5149d220f8449b", 115966, Common::FR_FRA, 702),
	WINGAME1t_l("abcpacovska", "", "Alphabet.exe", "c14f54671c5274accf32d2558510cdbb", 1812440, Common::FR_FRA, 702),

	WINDEMO1("artus1", "Demo", "artus.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2595828, 702),

	MACGAME1("atvrally", "", "atvmac", "0944b962ebb00f4b5d5149d220f8449b", 111450, 702),
	WINGAME1("atvrally", "", "ATVwin.exe", "7c18c9a6af2694156bf09ed195c1ab09", 1815336, 702),

	MACGAME1("badmilk", "", "badmilk", "0944b962ebb00f4b5d5149d220f8449b", 111478, 702),
	WINGAME1("badmilk", "", "badmilk.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2682776, 702),

	WINGAME1("bbbighelpers", "", "BigHelpers.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2843894, 702),

	// Later releases are D8
	WINGAME1_l("beautyorbeast", "", "Beauty or the Beast.exe", "02b0d114c93b598c737b1c627178195c", 2190754, Common::RU_RUS, 702),

	MACGAME1_l("bellini3", "", "Bellinis bikini",	   "0944b962ebb00f4b5d5149d220f8449b", 114321, Common::DA_DNK, 702),
	MACGAME1_l("bellini3", "", "Bellinin bikinit",	   "0944b962ebb00f4b5d5149d220f8449b", 114321, Common::FI_FIN, 702),
	WINGAME1_l("bellini3", "", "Bellinis bikini.exe",  "7c18c9a6af2694156bf09ed195c1ab09", 2596204, Common::DA_DNK, 702),
	WINGAME1_l("bellini3", "", "Bellinin bikinit.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2596204, Common::FI_FIN, 702),

	MACGAME1_l("bibi2", "", "Spielstart",  "0944b962ebb00f4b5d5149d220f8449b", 117347, Common::DE_DEU, 702),
	WINGAME2_l("bibi2", "", "Start.exe",   "7c18c9a6af2694156bf09ed195c1ab09", 1820386,
							"SPIELST.DXR", "24139a522420d2c6e3f4d0aa502f5936", 2250124, Common::DE_DEU, 702),

	// Finnish title is Ville & Lilli: Mielikuvitus vauhdissa
	// Developer website calls this Double Trouble: Crazy Cool Kindergarten,
	// although we don't know if it was actually released in English
	// https://web.archive.org/web/20060208235831/http://billetrille.savannah.dk/dtpages.php3?page_id=8&lang=english
	MACGAME1_l("billetrille1", "",	   "VilleLilli",		 "0944b962ebb00f4b5d5149d220f8449b", 112758, Common::FI_FIN, 702),
	WINDEMO1_l("billetrille1", "Demo", "VilleLilliDemo.exe", "18e31b6357c42300bb6947a6af7b8a69", 5150588, Common::FI_FIN, 702),

	// Bonus content on retail CD releases. No text or dialogue is used.
	WINGAME1("billetrille1ss", "", "screensaverDT1.exe", "18e31b6357c42300bb6947a6af7b8a69", 3261985, 702),

	// Blinky Bill Peuter
	WINGAME1_l("blinkyps", "", "PS.exe", "7c18c9a6af2694156bf09ed195c1ab09", 173560, Common::NL_NLD, 702),

	WINGAME2("blinkyk1", "", "K1.exe", "7c18c9a6af2694156bf09ed195c1ab09", 173598,
							 "home.dxr", "a5bf0926474b9d6100d5eb0a02c59e7c", 2414060, 702),
	// Blinky Bill Kleuter
	WINGAME2_l("blinkyk1", "", "K1.exe", "7c18c9a6af2694156bf09ed195c1ab09", 173598,
							   "home.dxr", "dd7f95732848801b0d5a7e784db68962", 2381576, Common::NL_NLD, 702),

	// Blinky Bill Lezertje
	WINGAME1_l("blinkyy1", "", "Y1.exe", "7c18c9a6af2694156bf09ed195c1ab09", 173554, Common::NL_NLD, 702),

	// Found on Windows Spielehits für Kinder by Compedia / Xtend New Media of Scheidegg, Bavaria
	WINGAME1_l("braingames", "", "invent.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2648430, Common::DE_DEU, 702),

	WINGAME1("buzz1", "", "DBLY1.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2201114, 702),

	WINGAME1_l("cookie", "", "CB1W.EXE",	 "91823501d9b3f9b9ced814101312fd11", 1977478, Common::JA_JPN, 700),
	// Original filename was 'RODIK クッキーズ・バッスル'
	MACGAME1_l("cookie", "", "xn--RODIK -1q4epa5gj1hc2o4o0hoa",	 "8932d51c63e4aa8509a33accffb5eb63", 116990, Common::JA_JPN, 700),

	// Bilingual English and French
	MACGAME1("cpnre", "", "ASI-SEI",	 "0944b962ebb00f4b5d5149d220f8449b", 111450, 702),
	WINGAME1("cpnre", "", "ASI-SEI.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2595714, 702),

	// Mac version calls installers as D7 apps to copy demos to HDD
	// Win version calls D7 apps to open links to Disney web pages
	MACGAME1("disneylearning", "", "SAMPLER.MAC", "0944b962ebb00f4b5d5149d220f8449b", 111450, 702),
	WINGAME2("disneylearning", "", "SAMPLER.EXE", "7c18c9a6af2694156bf09ed195c1ab09", 1816154,
								   "projectorstub.dir", "99a203b9af88e6d3aaf125d906d17249", 123498, 702),

	// Covermount for Revista Divertire (Brazil)
	// Launches installer for non-Director game (Nanico)
	WINGAME1_l("divertire", "Número 5", "divertire.exe", "c1a2e8b7e41fa204009324a9c7db1030", 4653626, Common::PT_BRA, 702),

	// Found as Enhanced CD content on WOW 2000 Christian Rock compilation
	WINDEMO1("dotsafe", "Demo", "DOTSAFE.EXE", "c1a2e8b7e41fa204009324a9c7db1030", 19795672, 700),

	WINGAME2("easports2000", "", "PC.EXE",	  "c1a2e8b7e41fa204009324a9c7db1030", 2212134,
								 "INTRO.DXR", "209cd844f714140413eb58c3a69db454", 5179191, 700),

	WINGAME1t("elfascd", "", "Inledning.exe", "f8b837454677411e751f7a774f1bec14", 2427558, 700),

	// Shockwave movie found on the CD Especial from Pc Pro magazine Nº1 (2000) published by Larpress, Madrid
	SHKGAME1_l("encartaatlas2000", "Demo", "PT_EWIA.dcr", "659daa595626c56635519af2c18e2ad1", 2612035, Common::ES_ESP, 700),

	MACGAME1("erdisaster", "", "ER Disaster Strikes Start", "0944b962ebb00f4b5d5149d220f8449b", 114890, 702),
	WINGAME1("erdisaster", "", "ER Disaster Strikes.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2682526, 702),

	MACGAME1_l("fg25ans", "", "FG25Ans", "dec72b4b6f8e97f1ea24361794bf0bdf", 114301, Common::FR_FRA, 702),
	WINGAME1_l("fg25ans", "", "FG25Ans.exe", "88d4c24f6d4b78a73ce5b07693eddbc8", 2412706, Common::FR_FRA, 702),

	// Found on デスクトップマスコット ファービー (Desktop Mascot Furby)
	WINGAME1_l("furbydentaku", "", "xn--.exe-fk4colma72ab4209fos3h", "1799677b9d869c8dc577d931e229ee3b", 3002842, Common::JA_JPN, 702),

	WINGAME1t_l("fuzzyfloppy3", "", "ff3.exe", "7b602367611d4b0422c6c86c2832c4b6", 1815664, Common::IT_ITA, 700),

	// Miel Monteur - Miel Bouwt Auto's!
	WINGAME2_l("garygadget1", "", "Start.exe", "c1a2e8b7e41fa204009324a9c7db1030", 2933829,
								  "Monteur.cnt", "7038be89eb5c49b51927bf76d8fd0b8a", 2490, Common::NL_NLD, 700),

	// Most of the disc is D6, but a few parts are D7
	MACGAME1("gasbook6", "AGES5&UP", "flab", "91723348f6414e84d024183554385275", 110742, 701),
	WINGAME1t("gasbook6", "AGES5&UP", "flab.exe", "9d04c94c59da09cdf547c54341f6b49f", 2492508, 701),
	MACGAME1("gasbook6", "Buro Destruct", "xn--bdd-fd7s", "fa52f0136cde568a46249ce74f01a324", 110409, 700),
	WINGAME1t("gasbook6", "Buro Destruct", "bdd.exe", "fedba028dff371f6b1436be3dddbfb41", 2142260, 700),
	MACGAME1("gasbook6", "Daniel Jenett - type", "type", "91723348f6414e84d024183554385275", 108519, 701),
	WINGAME1t("gasbook6", "Daniel Jenett - type", "TYPE.exe", "3ea133d61c9e3e6b4cfb220acebb93fa", 3869340, 701),

	// Unlike previous entries, Gasbook 7 has a single entry point
	// Original filename is a single space
	MACGAME1("gasbook7", "", "xn-- -", "91723348f6414e84d024183554385275", 114547, 701),
	WINGAME1t("gasbook7", "", "gasbook7.exe", "27fe7bf1c767294750b1a858c6d87e9c", 3061158, 702),

	MACGAME1_l("gasbook8", "Intro", "gasb8k", "fa52f0136cde568a46249ce74f01a324", 128168, Common::JA_JPN, 700),
	WINGAME2t_l("gasbook8", "Intro", "Intro.EXE",			 "b364adb2ef39400c0b55236e45e41aa9", 2277870,
									 "XMOVS/Gasb8k_win.Dxr", "8000d7a8b3b19d75d8caf4079babff18", 99327, Common::JA_JPN, 702),
	MACGAME1_l("gasbook8", "C404 - #28", "#28.PRJ", "0944b962ebb00f4b5d5149d220f8449b", 133058, Common::JA_JPN, 700),
	WINGAME1t_l("gasbook8", "C404 - #28", "%2328.exe", "27fe7bf1c767294750b1a858c6d87e9c", 3061158, Common::JA_JPN, 702),
	MACGAME1_l("gasbook8", "tomato - tokyo-ga", "tokyo-ga", "0944b962ebb00f4b5d5149d220f8449b", 134437, Common::JA_JPN, 700),
	WINGAME1t_l("gasbook8", "tomato - tokyo-ga", "tokyo_ga.exe", "d4091717fbc138a4c6f59caef23f8509", 2594480, Common::JA_JPN, 702),
	MACGAME1_l("gasbook8", "Yutanpo Shirane - Drive to the beyond", "Drive to the beyond", "01dfc7ba135015463fa7637aa46290e1", 721936, Common::JA_JPN, 700),
	WINGAME1t_l("gasbook8", "Yutanpo Shirane - Drive to the beyond", "Drive to the beyond.exe", "825397d786e0dd51bbce874558f92a59", 2594506, Common::JA_JPN, 702),
	MACGAME1_l("gasbook8", "Yutanpo Shirane - B.G.Yurerunder", "B.G.Yurerunder", "01dfc7ba135015463fa7637aa46290e1", 721936, Common::JA_JPN, 700),
	WINGAME1t_l("gasbook8", "Yutanpo Shirane - B.G.Yurerunder", "B.G.Yurerunder.exe", "cb04f3c80a698fe4e6ab79a12ca9ccd8", 2594644, Common::JA_JPN, 702),
	MACGAME1_l("gasbook8", "Yutanpo Shirane - Super peeper 31", "Super Peeper 31", "01dfc7ba135015463fa7637aa46290e1", 721936, Common::JA_JPN, 700),
	// Real name involves a non-printing 0x81 between words
	WINGAME1t_l("gasbook8", "Yutanpo Shirane - Super peeper 31", "xn--SuperyQPeeperyQ31.exe-1ai", "3d23c86681f6badff5d4187a5b99bb89", 2594498, Common::JA_JPN, 702),

	// Found on アクティブマスコット・ハイジ (Heidi Desktop Mascot) software from Inner Brain, Shinjuku, Tokyo
	// Installers for the screen savers and other applications also use Director
	// Original calculator filenames are ハイジ電卓１.exe, ハイジ電卓２.exe, ハイジ電卓３.exe
	WINGAME1_l("heididentaku1", "", "xn--.exe-uk4cqevgp14zyi5ggs7i", "1799677b9d869c8dc577d931e229ee3b", 3232268, Common::JA_JPN, 702),
	WINGAME1_l("heididentaku2", "", "xn--.exe-uk4cqevgp14zyi5gqs7i", "1799677b9d869c8dc577d931e229ee3b", 2947676, Common::JA_JPN, 702),
	WINGAME1_l("heididentaku3", "", "xn--.exe-uk4cqevgp14zyi5g0s7i", "1799677b9d869c8dc577d931e229ee3b", 2988876, Common::JA_JPN, 702),
	WINGAME1_l("heidimail", "",  "HeidiML.exe", "1799677b9d869c8dc577d931e229ee3b", 2662490, Common::JA_JPN, 702),
	WINGAME1_l("heidislide", "", "Slide.exe",   "1799677b9d869c8dc577d931e229ee3b", 7934640, Common::JA_JPN, 702),

	MACGAME1_l("ironmask", "", "THE IRON MASK", "0944b962ebb00f4b5d5149d220f8449b", 112786, Common::IT_ITA, 702),
	WINGAME1_l("ironmask", "", "TIM.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2916546, Common::IT_ITA, 702),

	// Polish demo is found on magazine covermount of CyberMycha - Oct 2000
	// Zobacz i Znajdź: Tajemnice Domu Strachów (Polish title), localized by Optimus Pascal Multimedia of Bielsko-Biała
	WINDEMO2_l("ispyspooky", "Demo", "start.exe", "c1a2e8b7e41fa204009324a9c7db1030", 2211414,
									 "salon.dxr", "28600924c9b6c087004a1adc39ca2254", 663694, Common::PL_POL, 700),

	MACGAME1("isscommerce", "", "Mac-Start", "fa52f0136cde568a46249ce74f01a324", 107126, 700),
	WINGAME1("isscommerce", "", "PC-Start.exe", "c1a2e8b7e41fa204009324a9c7db1030", 6878037, 700),

	MACGAME1("jewels1", "", "Jewels of the Oracle", "fa52f0136cde568a46249ce74f01a324", -1, 700),
	WINGAME1("jewels1", "", "Jewels.exe", "c1a2e8b7e41fa204009324a9c7db1030", -1, 700),

	// All of the installers also use Director
	// Mac filename is Starta Jönssonligan
	MACGAME1_l("jonssonligan1", "", "Starta Jonssonligan", "0944b962ebb00f4b5d5149d220f8449b", 113750, Common::SE_SWE, 702),
	WINGAME1_l("jonssonligan1", "", "xn--Jnssonligan.exe-8sb", "7c18c9a6af2694156bf09ed195c1ab09", 2432602, Common::SE_SWE, 702),
	WINGAME1_l("jonssonligan2", "", "xn--Jnssonligan gr p djupet.exe-glcd70c", "6213518ca81bb9e7397b408a8f38703d", 3374107, Common::SE_SWE, 702),

	// Plays QuickTime movie then opens webpage (still works in 2021)
	WINGAME2("jsa", "Demo", "Projector.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2289485,
							"jslogo.jpg",    "fd78f0ab06eb3894d38c11a75e13d008", 25016, 702),

	// Extra activities on Little Bear Thinking Adventures
	MACGAME1("lbfamfun", "", "Little Bear Family Fun", "0944b962ebb00f4b5d5149d220f8449b", 112758, 702),
	WINGAME1("lbfamfun", "", "Little Bear Family Fun.exe", "7c18c9a6af2694156bf09ed195c1ab09", 4214763, 702),

	WINDEMO1("lbkinder", "Demo", "LBKinder.exe", "7c18c9a6af2694156bf09ed195c1ab09", 6486618, 702),
	WINDEMO1("lbpre", "Demo", "LBPre.exe", "7c18c9a6af2694156bf09ed195c1ab09", 5944146, 702),

	MACGAME1("lbtpreschool", "", "LBT Preschool Adv", "fa52f0136cde568a46249ce74f01a324", 111391, 700),
	WINGAME1("lbtpreschool", "", "Lbt.exe", "c1a2e8b7e41fa204009324a9c7db1030", 2450962, 700),

	MACGAME2("leepipes", "", "Press Kit",	  "0944b962ebb00f4b5d5149d220f8449b", 111450,
							 "ss_fs.dxr",	  "deddb2749bdfde8648e51fc9e18ae3db", 6451729, 702),
	WINGAME2("leepipes", "", "Press Kit.exe", "c1a2e8b7e41fa204009324a9c7db1030", 7448796,
							 "ss_fs.dxr",	  "b5f34c9b5222b64bda16b9c71bc14d62", 6451601, 700),

	// Mia Muis Op Zoek naar Oma Mimi's Medicijn (CD1)
	WINGAME1("miareading1", "", "Mia.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2595806, 702),

	// Mac demo is from Disney Interactive Learning Sampler CD
	// Installer also uses Director 7.0.2
	WINDEMO1("mickeyp", "D7 Demo", "MickeyP.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2044554, 702),
	MACDEMO1("mickeyt", "D7 Demo", "MickeyT.mac", "0944b962ebb00f4b5d5149d220f8449b", 111478, 702),
	WINDEMO1("mickeyt", "D7 Demo", "MickeyT.exe", "7c18c9a6af2694156bf09ed195c1ab09", 1880445, 702),

	// Mac version requires installation, Install Milo, uses Vise
	MACGAME2("milomagical",  "", "MILO",	  "dec72b4b6f8e97f1ea24361794bf0bdf", 115801,
								 "first.dxr", "59cf3048c42c969967fde265d5992006", 12622, 702),
	WINGAME2t("milomagical", "", "Milo.exe",  "a45b0c0bd15e2af164343954ef3ffbff", 1818248,
								 "first.dxr", "2bd33031549c9a0c7ac79c50b5e70499", 12622, 700),

	// Launcher for third party products included in MSA bundle from Softkey
	// Also includes single page ads with links to defunct sales pages for other Advantage bundles
	// Encore Software's budget release is v2.0
	WINGAME1("msa2001", "v2.0", "Middle School Advantage.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2691484, 702),

	MACGAME1("myfirstwords", "", "My First Reading Words Start", "0944b962ebb00f4b5d5149d220f8449b", 111450, 702),
	WINGAME1("myfirstwords", "", "MFRWORDS.EXE", "7c18c9a6af2694156bf09ed195c1ab09", 3918368, 702),

	WINGAME2("nyknicks2000", "", "KNICKS.exe", "c1a2e8b7e41fa204009324a9c7db1030", 2834311,
								 "Garden.dxr", "fe309424e95c3f0435c8f8a6e9a7883f", 322042, 700),

	// Found on German Silly Noisy House CD
	WINGAME1_l("otelo", "Demo", "PEARL.EXE", "c1a2e8b7e41fa204009324a9c7db1030", 8036549, Common::DE_DEU, 702),

	MACGAME1("oztma", "", "Start Oz", "0944b962ebb00f4b5d5149d220f8449b", 115200, 702),
	WINGAME1("oztma", "", "Oz - TMA.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2621536, 702),

	// Cover disc from Spanish PC Plus magazine. May simply load HTML pages from disc.
	WINGAME1_l("pcplus64", "Cover Disc", "cd.exe", "7c18c9a6af2694156bf09ed195c1ab09", 5014518, Common::ES_ESP, 702),

	MACGAME1_l("pettsonjk", "", "Findus3", "0944b962ebb00f4b5d5149d220f8449b", 115401, Common::DE_DEU, 702),
	WINGAME1_l("pettsonjk", "", "FINDUS3.EXE", "7c18c9a6af2694156bf09ed195c1ab09", 6268578, Common::DE_DEU, 702),

	MACGAME1_l("pettsonjs", "", "Julpettson", "0944b962ebb00f4b5d5149d220f8449b", 115004, Common::SE_SWE, 702),
	WINGAME1_l("pettsonjs", "", "Julstart.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2610931, Common::SE_SWE, 702),

	MACGAME1_l("physicus", "", "Physikus", "5d3f89e052320f8ce140451c730e232b", 114645, Common::FR_FRA, 702),

	WINGAME1t_l("physicus", "", "Physikus.exe", "89be052460986358d7e4724ebc940af6", 1816828, Common::DE_DEU, 702),

	WINDEMO1("planetstrass", "Demo", "Planet.exe", "88d4c24f6d4b78a73ce5b07693eddbc8", 15434606, 702),

	MACGAME1_l("polis2", "", "POLIS 2", "fa52f0136cde568a46249ce74f01a324", 110730, Common::SE_SWE, 700),
	MACGAME1_l("polis2", "", "Kripos 2", "fa52f0136cde568a46249ce74f01a324", 111690, Common::NB_NOR, 700),
	WINGAME1_l("polis2", "", "Polis 2.exe", "c1a2e8b7e41fa204009324a9c7db1030", 2678147, Common::SE_SWE, 700),
	WINGAME1_l("polis2", "", "Kripos2m.exe", "f790bb1816a6f89567d6f5671b751bf5", 3461770, Common::NB_NOR, 700),

	MACGAME1("poohac", "", "Pooh Activity Center", "0944b962ebb00f4b5d5149d220f8449b", 122576, 702),
	WINGAME1("poohac", "", "PoohAC.exe", "e40161ef4d2dceb372ee7113adf821aa", 1818138, 702),

	WINGAME1("princerave", "", "The_Artist.exe", "7c18c9a6af2694156bf09ed195c1ab09", 2596022, 702),

	WINGAME1_l("princessfashion", "", "Disney.exe", "7c18c9a6af2694156bf09ed195c1ab09", 172782, Common::ES_ESP, 702),

	// From Russian "Pyatachok Anthology" DVD, game is Eng/Rus
	WINGAME1t("pyatachok5", "", "Pong5.exe", "ca0e3da7559ca50807ad3c9eec9afdf2", 2365442, 702),

	MACGAME1_l("rainbowfish1", "", "REGENBOOG", "dec72b4b6f8e97f1ea24361794bf0bdf", 116715, Common::NL_NLD, 702),
	WINGAME1_l("rainbowfish1", "", "Regenboog.exe", "88d4c24f6d4b78a73ce5b07693eddbc8", 1820762, Common::NL_NLD, 702),

	MACGAME1("rainbowfish2", "", "Rainbow Fish and the Whale", "dec72b4b6f8e97f1ea24361794bf0bdf", 116715, 702),
	MACGAME1_l("rainbowfish2", "", "Wal", "dec72b4b6f8e97f1ea24361794bf0bdf", 116715, Common::DE_DEU, 702),
	WINGAME1("rainbowfish2", "", "Rainbow2.exe", "06f5ec786e7f2e94e36571f651810fb4", 1817774, 702),
	WINGAME1_l("rainbowfish2", "", "Arcobaleno.exe", "06f5ec786e7f2e94e36571f651810fb4", 1817774, Common::IT_ITA, 702),
	WINGAME1_l("rainbowfish2", "", "wal.exe", "06f5ec786e7f2e94e36571f651810fb4", 1817774, Common::DE_DEU, 702),

	WINGAME1t_l("ravecard2001", "", "RAVECARD2001.exe", "1f74104a44a6d8b1decfdc8f16c22639", 3010820, Common::DE_DEU, 702),

	WINGAME1("relaxation", "ECD",  "solitude.exe", "7a4164849d026c0f2aa8ea4c7d5447ba", 1807680, 702),
	MACGAME1("relaxplayer", "ECD", "Relax",		   "0944b962ebb00f4b5d5149d220f8449b", 112738, 702),

	WINGAME2t_l("ritterrost", "",  "start.exe",			"9bc3d64be0fe3caa612f070b27c943b8", 2595758,
								   "data/Rostburg.DXR", "6bf95a48f366bdf8af3a198c7b723c77", 38107269, Common::DE_DEU, 702),

	// original filename is a single space
	MACGAME1("sentence", "", "xn-- -", "0944b962ebb00f4b5d5149d220f8449b", 113458, 702),
	WINGAME1t("sentence", "", "_.exe", "85a448c736ada6c5d2c456b72cdd28b8", 2212402, 700),

	MACGAME1("smartsteps3rd", "", "Smart Steps 3rd Grade", "0944b962ebb00f4b5d5149d220f8449b", 116042, 702),
	WINGAME1("smartsteps3rd", "", "Smart Steps 3rd Grade.exe", "7c18c9a6af2694156bf09ed195c1ab09", 1820192, 702),

	// Found on Solitudes Enhanced CDs
	// 1999 version is on Natural Relaxation
	// 2001 version is on Songbird Symphony, Stress Relief 2 and others
	MACGAME1("solmahjong", "1999 version", "Mahjong",	  "0944b962ebb00f4b5d5149d220f8449b", 113714, 702),
	WINGAME1("solmahjong", "1999 version", "Mahjong.exe", "7a4164849d026c0f2aa8ea4c7d5447ba", 2757472, 702),
	MACGAME1("solmahjong", "2001 version", "Mahjong",	  "0944b962ebb00f4b5d5149d220f8449b", 112758, 702),
	WINGAME1("solmahjong", "2001 version", "Mahjong.exe", "7a4164849d026c0f2aa8ea4c7d5447ba", 2832712, 702),

	// https://web.archive.org/web/1id_/www.budweiser.com/screensaver/pc/screen99.exe
	WINGAME1("ssbudfranklouie", "", "Screen99.exe", "c1a2e8b7e41fa204009324a9c7db1030", 3397601, 700),

	WINGAME1("ssheidi1", "", "_heidi01.exe", "91823501d9b3f9b9ced814101312fd11", 5985066, 701),
	WINGAME1("ssheidi2", "", "_heidi02.exe", "91823501d9b3f9b9ced814101312fd11", 7783641, 701),

	// Produced by Davis-Panzer Merchandising; developed by Unis Multimedia, Hollywood, California (1999)
	MACGAME1("sshercules", "", "Hercules Screen Saver", "fa52f0136cde568a46249ce74f01a324", 259047, 700),
	WINGAME1("sshercules", "", "Herc Screen Saver.exe", "7c18c9a6af2694156bf09ed195c1ab09", 47066937, 702),

	// http://web.archive.org/web/20080412010505/http://www.beachware.com/download/
	MACGAME1("ssmorphclock", "v1.5", "MorphClock", "fa52f0136cde568a46249ce74f01a324", 188978, 700),
	WINGAME1("ssmorphclock", "", "Morph Clock.exe", "c1a2e8b7e41fa204009324a9c7db1030", 3800619, 700),

	// Screen Saver found on Solitudes Natural Relaxation ECD
	MACGAME1("ssnatureasart", "", "Nature As Art", "0944b962ebb00f4b5d5149d220f8449b", 199990, 702),
	WINGAME1("ssnatureasart", "", "Nature As Art.exe", "7a4164849d026c0f2aa8ea4c7d5447ba", 3246939, 702),

	// Copies provided in The Daily Mirror
	WINGAME2("thematrix", "", "Presentation.exe", "c1a2e8b7e41fa204009324a9c7db1030", 2212124,
							  "intro.dir",        "ebe2cac80218c4933ecc609cd8ef27cc", 10368479, 700),

	// ein Fall für TKKG: Wer stoppt den Feuerteufel? (bilingual DE/EN)
	MACGAME2("tkkg7", "", "TKKG-Start", "0944b962ebb00f4b5d5149d220f8449b", 113458,
						  "Score.dxr", "c1a18f5a5a71148ef469841ccb253771", 16804, 702),
	WINGAME1t("tkkg7", "", "TKKG 7.exe", "96593e22c401be8551764b51f6f68c62", 1892382, 702),

	// Windows installer is also Director
	MACGAME1_l("tkkgkit", "", "Phantombild Start", "0944b962ebb00f4b5d5149d220f8449b", 115498, Common::DE_DEU, 702),
	WINGAME1t_l("tkkgkit", "", "Phantombild Start.exe", "7cc7736d429df5cbe8adaca170ab5fa0", 1820554, Common::DE_DEU, 702),

	MACGAME1_l("tomlisaindiens", "", "Tom en Lisa", "19f92df0c7cb7a17b02ed5c73b1ee4c1", 33105, Common::NL_NLD, 702),
	WINGAME1_l("tomlisaindiens", "", "TOM ET LISA.EXE", "7c18c9a6af2694156bf09ed195c1ab09", 783498, Common::NL_NLD, 702),

	// Full game was never released
	WINDEMO2("veniceglass", "Preview", "Start.exe",	  "c1a2e8b7e41fa204009324a9c7db1030", 2615108,
									  "Mission1.dxr", "ddf7a5d922d1d99c9debc72f7ab3f247", 1979501, 700),
	WINDEMO2t("veniceglass", "Demo", "Start.exe", "6c1f4b9fddf094e240f759596b335479", 2615108,
									 "Book1.dxr", "f9a656b9f31f44f195161e932ada634b", 16795693, 700),
	// Found on a promotional screensaver CD for the game
	WINDEMO2t("veniceglass", "Demo", "Start.exe", "6c1f4b9fddf094e240f759596b335479", 2615108,
									 "Book1.dxr", "5af1a02fe8fb811e2a5a638011435108", 16796595, 700),

	// Original filename is DreamLight® Verttice™ 3.0
	MACGAME1("verttice", "v3.0", "DreamLight Verttice 3.0", "0944b962ebb00f4b5d5149d220f8449b", 123353, 702),
	WINGAME1("verttice", "v3.0", "DreamLight Verttice 30.EXE", "7c18c9a6af2694156bf09ed195c1ab09", 3010200, 702),

	// Runs in 800x600, includes "VJG (640 x 480)" or VJGIAW.EXE for 640x480 monitors
	MACGAME1("vjg", "", "Vegas Jackpot Gold", "0944b962ebb00f4b5d5149d220f8449b", 113484, 700),
	WINGAME1t("vjg", "", "VJG.EXE", "f45023765b63cdb1b0343eefd4353939", 2732994, 700),
	MACGAME1("vjg", "Cards screensaver", "Data/scrnsave/mac/Cards (800x600)", "0944b962ebb00f4b5d5149d220f8449b", 228716, 700),
	WINGAME1t("vjg", "Cards screensaver", "Data/scrnsave/pc/Cards.exe", "d0a2429140f838b2448d350db45c13bc", 2774344, 700),
	MACGAME1("vjg", "Chips screensaver", "Data/scrnsave/mac/Chips (800x600)", "0944b962ebb00f4b5d5149d220f8449b", 228716, 700),
	WINGAME1t("vjg", "Chips screensaver", "Data/scrnsave/pc/Chips.exe", "ec3725cad6f7f6a5b977e309ea2d0522", 3044936, 700),
	MACGAME1("vjg", "Dice screensaver", "Data/scrnsave/mac/Dice (800x600)", "0944b962ebb00f4b5d5149d220f8449b", 228715, 700),
	WINGAME1t("vjg", "Dice screensaver", "Data/scrnsave/pc/Dice.exe", "b61e97ab776436f1c4cdf2b96cf1d4d1", 3151605, 700),
	MACGAME1("vjg", "Gold screensaver", "Data/scrnsave/mac/Gold (800x600)", "0944b962ebb00f4b5d5149d220f8449b", 228715, 700),
	WINGAME1t("vjg", "Gold screensaver", "Data/scrnsave/pc/Gold.exe", "63ab65806ca8ee2c45826a8cb386dadc", 2676467, 700),
	MACGAME1("vjg", "Quarters screensaver", "Data/scrnsave/mac/Quarters (800x600)", "0944b962ebb00f4b5d5149d220f8449b", 228719, 700),
	WINGAME1t("vjg", "Quarters screensaver", "Data/scrnsave/pc/Quarters.exe", "fb759c6bf4b009ddf9f7fe74c2dbdac4", 2696814, 700),

	MACGAME1("webmaster", "", "Webmaster", "0944b962ebb00f4b5d5149d220f8449b", 128297, 702),
	WINGAME1("webmaster", "", "Webmaster.exe", "7c18c9a6af2694156bf09ed195c1ab09", 1820594, 702),

	MACGAME1_l("xtown2", "", "xn--CROSSTOWN NGELN-n5a/xn--ngeln-xla", "0944b962ebb00f4b5d5149d220f8449b", 116140, Common::SE_SWE, 702),
	WINGAME2t_l("xtown2", "", "ANGEL.EXE", 		  "ea43a06fe305ceaa2ca2ba16feaee320", 2212330,
							  "DATA_S/START.DXR", "9e83bf4d2b1606bd0d26ea8949f0e21e", 72799, Common::SE_SWE, 700),

	// Found on アクティブマスコット・ハイジ (Heidi Desktop Mascot)
	// Create cards using ZUIYO's new characters Popee and Beast
	WINGAME1_l("zuiyomail", "", "MAIL2.exe", "1799677b9d869c8dc577d931e229ee3b", 2662488, Common::JA_JPN, 702),

//////////////////////////////////////////////////
//
// Macromedia Director v8
//
//////////////////////////////////////////////////

	// Original filenames are 1·2·3 Hablo Inglés.exe
	WINGAME2_l("123habloingles", "#1 El Viaje",		   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "f396a24506e44c07f301fc371a194890", 5183390, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#2 Las Profesiones", "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "b2cbc3d929eabf2104092c9085e3f799", 2033834, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#3 La Ciudad",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "aa90009810ae0f8dc6c18127e43ee653", 2636966, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#4 La Familia",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "fc150a2006ce5a275c91a973a9bb0620", 3023360, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#5 El Colegio",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "4068c7be2497cbfe5c817079f07f6448", 2850986, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#6 La Casa",		   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "f353c62bcec28a4fc46111186bd87d75", 5346849, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#7 Los Animales",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "ee91ed26714dff37f12338fe7f335c10", 3657617, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#8 La Granja",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "72fd0dd40798d7441908024509708e38", 2657540, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#9 Al Aire Libre",   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "073d9db7afc78e771c5f326a1005bb16", 4816002, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#10 El Parque",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "8cfaf779033cc9e2d894c4d79359c5f6", 4180556, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#11 Los Alimentos",  "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "4bafa0401749466dff3d6125d9161844", 2677780, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#12 Las Vacaciones", "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "9196f3ea7eac1b7f35c29977cbe2ab6e", 2522054, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#13 Diccionario",	   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "282a153f108019fc8cdd19c9d973db1f", 2389614, Common::ES_ESP, 851),
	WINGAME2_l("123habloingles", "#14 Karaoke",		   "123 Hablo Ingles.exe", "0c81c84ca4966313ad27d47daba44537", 2660381,
													   "Intro.dxr",			   "d9c5fa53e38e683465174740bd1a771d", 2789550, Common::ES_ESP, 851),

	WINGAME2t("aaha2007", "Management 1",  "StartCD.exe", "f5e1f52dc03126d4a906f78247b190da", 3437769,
										   "Select.dxr", "3c766fe5aff43e8eae440d13468cd48a", 1398164, 850),
	WINGAME2t("aaha2007", "Management 2",  "StartCD.exe", "f5e1f52dc03126d4a906f78247b190da", 3437769,
										   "Select.dxr", "3c766fe5aff43e8eae440d13468cd48a", 1396946, 850),
	WINGAME2t("aaha2007", "Scientific 1",  "StartCD.exe", "f5e1f52dc03126d4a906f78247b190da", 3437769,
										   "Select.dxr", "3c766fe5aff43e8eae440d13468cd48a", 1396870, 850),
	WINGAME2t("aaha2007", "Scientific 2",  "StartCD.exe", "f5e1f52dc03126d4a906f78247b190da", 3437769,
										   "Select.dxr", "3c766fe5aff43e8eae440d13468cd48a", 1396398, 850),
	WINGAME2t("aaha2007", "Scientific 3",  "StartCD.exe", "f5e1f52dc03126d4a906f78247b190da", 3437769,
										   "Select.dxr", "3c766fe5aff43e8eae440d13468cd48a", 1396722, 850),
	WINGAME2t("aaha2007", "Scientific 4",  "StartCD.exe", "f5e1f52dc03126d4a906f78247b190da", 3437769,
										   "Select.dxr", "3c766fe5aff43e8eae440d13468cd48a", 1395756, 850),
	WINGAME2t("aaha2007", "Scientific 5",  "StartCD.exe", "f5e1f52dc03126d4a906f78247b190da", 3437769,
										   "Select.dxr", "3c766fe5aff43e8eae440d13468cd48a", 1395738, 850),
	WINGAME2t("aaha2007", "Technician 1", "StartCD.exe", "f5e1f52dc03126d4a906f78247b190da", 3437769,
										  "Select.dxr", "3c766fe5aff43e8eae440d13468cd48a", 1395390, 850),
	WINGAME2t("aaha2007", "Technician 2", "StartCD.exe", "f5e1f52dc03126d4a906f78247b190da", 3437769,
										  "Select.dxr", "3c766fe5aff43e8eae440d13468cd48a", 1395314, 850),

	MACGAME1_l("alfons", "", "Alfons", "08c9ea94f6469e71ae0c71987bbf6323", 199733, Common::SE_SWE, 851),
	WINGAME1_l("alfons", "", "Alfons.exe", "02913e7deeab4ece4ae44ad521082d4e", 2166668, Common::SE_SWE, 851),

	// Developed by Almajarra المجرة
	WINGAME2_l("alhisab", "", "Start.exe",	  "c163f36141579ee374f7b4b2bddee95a", 2117096,
							  "Preintro.dxr", "5fb6543cc57d53fac26d975922c18e48", 11170, Common::AR_ARB, 850),

	// Published by Future Soft of Nasr City, Cairo
	WINGAME1_l("anasheed", "", "Anasheed.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 3595486, Common::AR_ARB, 800),

	MACGAME2("artintact", "", "Start_Mac", "4ea5fc09f79eee6dded94dc40f303779", 214865,
							  "DATA/intro.dxr", "e2ae1092a0bbe433cdc33d82bcc8adb7", 997164, 800),
	WINGAME2t("artintact", "", "start.exe", "e35fd9cafa74db33dca37e7e7cd63e43", 146931,
							   "DATA/intro.dxr", "a8fe1c32a4c4d40ed00393d8602b979e", 997164, 800),

	// From bugreport #13438
	// Mac version is D10
	WINGAME1t("artmarcopatrito", "", "The_Art.exe", "5b1dc5ceba980c61ff9f6c82f187f106", 2158556, 851),

	MACGAME1("astroblast", "v1.1", "AstroBlast", "b669b6ace5f203cf7dbdee5277d0c908", 218617, 800),

	MACGAME2("avrilletgo", "ECD", "Projector",	   "4ea5fc09f79eee6dded94dc40f303779", 194863,
								  "movie.dxr",	   "6d0c0712fdd32cf1de489b4c152b2460", 50908119, 800),
	WINGAME2("avrilletgo", "ECD", "Projector.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 56830,
								  "movie.dxr",	   "b8dc39b080e4892913c2d302fec39567", 50907991, 800),

	MACGAME1_l("balticmission",  "", 		"Baltic Mission", 	  "4ea5fc09f79eee6dded94dc40f303779", 219073, Common::SE_SWE, 800),
	WINGAME2t_l("balticmission", "Autorun", "autorun.exe",		  "60a23965ff21326edf26fbb9e8f268ca", 2461710,
								     		"baltic/main.dxr",	  "024047676242d7d277d39a6abd57c7fb", 58099778, Common::SE_SWE, 800),
	WINGAME2t_l("balticmission", "",		"Baltic Mission.exe", "06575527a84aa9e0dca4a756855e3935", 2563068,
								     		"baltic/main.dxr",	  "024047676242d7d277d39a6abd57c7fb", 58099778, Common::SE_SWE, 800),

	MACDEMO1("balto2", "Trailer", "MacBolto", "08c9ea94f6469e71ae0c71987bbf6323", 155737, 850),
	WINDEMO1("balto2", "Trailer", "Balto.exe", "c163f36141579ee374f7b4b2bddee95a", 2309044, 850),

	MACGAME1_l("bamse1", "", "Spillerom", "a44511b8ff0e46b4f9c85dd1cb58d458", 199093, Common::DA_DNK, 851),
	MACGAME1_l("bamse2", "", "Bamses egen", "a44511b8ff0e46b4f9c85dd1cb58d458", 157079, Common::DA_DNK, 851),
	WINGAME1_l("bamse1", "", "spillerom.exe", "0c81c84ca4966313ad27d47daba44537", 2158320, Common::DA_DNK, 851),
	WINGAME1_l("bamse2", "", "Bamsesegen.exe", "0c81c84ca4966313ad27d47daba44537", 2158340, Common::DA_DNK, 851),

	MACGAME1("barbrapunzel", "", "Rapunzel", "08c9ea94f6469e71ae0c71987bbf6323", 213604, 850),
	MACDEMO1("barbrapunzel", "Trailer", "Trailer", "08c9ea94f6469e71ae0c71987bbf6323", 155737, 850),
	WINGAME1("barbrapunzel", "", "Rapunzel.exe", "c163f36141579ee374f7b4b2bddee95a", 2116696, 850),
	WINDEMO2("barbrapunzel", "Trailer", "Trailer.exe", "c163f36141579ee374f7b4b2bddee95a", 2303378,
										"Trailer.mov", "c23add499f206fb3f8e088cf315c2783", 17393683, 850),

	MACGAME1_l("bibifilm", "", "Filmstudio", "3ba983d2dd8c94d882c0de01ab920c43", 1249397, Common::DE_DEU, 850),
	WINGAME1_l("bibifilm", "", "Filmstudio_start.exe", "c163f36141579ee374f7b4b2bddee95a", 148898, Common::DE_DEU, 850),

	// Finnish title is Ville & Lilli: Ihan Pihalla
	// Developer website calls this Double Trouble: Wacky Woods,
	// although we don't know if it was actually released in English
	// https://web.archive.org/web/20060208235824/http://billetrille.savannah.dk/dtpages.php3?page_id=208&lang=english
	MACDEMO1_l("billetrille2", "Demo", "VilleLilli2Demo", "4ea5fc09f79eee6dded94dc40f303779", 196171, Common::FI_FIN, 800),

	WINGAME2("bobmambo5", "ECD", "START.EXE", "e24d4bab978b1a5c2326d2c56cf4d781", 6980680,
								 "MAMBO.MOV", "990db0c7187621250dfca0a55996538e", 39868175, 800),

	WINGAME1_l("boeboekshaboe", "", "Arcade.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2389026, Common::NL_NLD, 800),

	MACDEMO1_l("boeboekstocht", "Demo", "Boeboeks",		"4ea5fc09f79eee6dded94dc40f303779", 194635, Common::NL_NLD, 808),
	WINDEMO1_l("boeboekstocht", "Demo", "Boeboeks.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 58054,  Common::NL_NLD, 800),

	MACGAME1("broadwayyb", "", "Startmac",	   "4ea5fc09f79eee6dded94dc40f303779", 196199, 800),
	WINGAME1("broadwayyb", "", "YEARBOOK.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2256212, 800),

	// Mac OS 9 and OS X versions are D9
	WINGAME2t("casino5p", "", "Casino.exe", 			"fb46241e501df6a96d5a3109f13d61b6", 3335762,
							  "data/casino/Casino.DIR", "414d899657b09f133f0146af2a2aae3c", 3062219, 850), // Disc 1
	WINGAME1t("casino5p", "", "Slots200.exe", "0f04a70712597a6bd001232b0913d514", 3011024, 850), // Disc 2

	MACGAME1("cmi", "CM38/10/01", "CMi_38_Mac", "f065c75691d28120e9f630448c3b1b71", 1225735, 800),
	WINGAME1("cmi", "CM38/10/01", "CMi_38_Win.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2514361, 800),

	// Distributed by Océano Multimedia (Colombia) of Cota, Cundinamarca (2000)
	WINGAME2_l("deportes", "", "start.exe",    "c163f36141579ee374f7b4b2bddee95a", 2383840,
							   "Deportes.dxr", "2330cc03f17c2aa4a4a10e76bc774fe8", 3985672, Common::ES_ESP, 850),

	MACGAME1("dispix2and3", "", "2nd and 3rd Grade", "a44511b8ff0e46b4f9c85dd1cb58d458", 220552, 851),
	WINGAME1("dispix2and3", "", "2nd and 3rd Grade.exe", "68835b24dd317fbc96e4a8c53892a361", 2630239, 851),

	WINGAME1("eureka", "", "Promo.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 17971868, 800),

	WINGAME2_l("fcdk", "", "Start.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 511933,
						   "boma.dir", "484a5f57cde0ce4f035be6be933ede34", 10561442, Common::NL_NLD, 800),

	// De drie werelden van Flipper & Lopaka published by Transposia of Ghent, Flanders
	MACGAME2("flipper1", "",   "Flipper",	  "305030a32728843d9e953b8e0f53a149", 6129,
							   "Splash.dxr",  "e2e9db4d52497b66d30b67257ac0b9f3", 3227343, 800),
	MACGAME2_l("flipper1", "", "Flipper",	  "305030a32728843d9e953b8e0f53a149", 6129,
							   "Splash.dxr",  "690080bb870fa4f9dd92665dd05a6e75", 3403943, Common::FR_FRA, 800),
	MACGAME2_l("flipper1", "", "Flipper",	  "26342893ab4fceffc6c6efaa81718780", 6165,
							   "Splash.dxr",  "5430500b5660bd30ec9fd72784233560", 3521553, Common::NL_NLD, 800),
	WINGAME2_l("flipper1", "", "Flipper.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 57196,
							   "Splash.dxr",  "2cb70c1101fc967f6b134fd1237d40a7", 3403815, Common::FR_FRA, 800),
	WINGAME2_l("flipper1", "", "Flipper.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 57196,
							   "Splash.dxr",  "34027bf8975bced3a92ea6a1d41ccf21", 3521425, Common::NL_NLD, 800),

	MACGAME1_l("flipper2", "", "Secrets", "039fd480c0ba5b06a88c233f79bbabbe", 8429, Common::NL_NLD, 850),
	WINGAME1_l("flipper2", "", "Secrets.exe", "c163f36141579ee374f7b4b2bddee95a", 57184, Common::NL_NLD, 850),

	MACGAME1_l("forestiajr", "", "Forestia Aufstand im Zoo", "75e71e2abbe6cf6e79a62be76cc05d06", 157104, Common::DE_DEU, 850),
	WINGAME1_l("forestiajr", "", "Forestia Aufstand im Zoo.exe", "14a1ca568d9188926eb70827f42ac856", 2166796, Common::DE_DEU, 851),

	MACGAME1("fplpairport", "", "Discovery Airport", "08c9ea94f6469e71ae0c71987bbf6323", 206619, 851),
	WINGAME1("fplpairport", "", "Discovery Airport.exe", "0c81c84ca4966313ad27d47daba44537", 2156986, 851),

	WINGAME1("fractiondecimal", "", "Fd.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4775506, 800),

	// Found as mini-game on Chillin Out ECD from Smash Hits magazine
	WINGAME1("freeallangels", "", "FREE ALL ANGELS.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2248678, 800),

	MACGAME1("garfieldmadcats", "", "Mad About Cats", "4ea5fc09f79eee6dded94dc40f303779", 194891, 800),
	WINGAME1("garfieldmadcats", "", "Garfield Start.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2695719, 800),

	// Mac version on same disc is D6
	WINGAME1_l("garygadget2", "", "okki.exe", "0c81c84ca4966313ad27d47daba44537", 2513593, Common::NL_NLD, 851),

	// Flugzeuge bauen mit Willy Werkel localized by Terzio Verlag, Munich (2001)
	WINGAME1_l("garygadget3", "", "WillyFlug.exe", "70a7b053c1a60617d3baace061fcba54", 9158814, Common::DE_DEU, 800),

	WINGAME1t_l("garygadget3", "", "Start_Mulle.exe", "f0f897006aa8930c52a7aa329a7a2344", 5133106, Common::NB_NOR, 800),

	// Mac installers also use Director
	MACGAME2_l("garygadget4", "", "MulleHus",	  "a44511b8ff0e46b4f9c85dd1cb58d458", 157051,
								  "01.dxr",		  "a443d3493ad279d26ce08814d8636d97", 44658, Common::FI_FIN, 851),
	MACGAME2_l("garygadget4", "", "MulleHus",	  "a44511b8ff0e46b4f9c85dd1cb58d458", 157051,
								  "01.dxr",		  "bc776ee31fa7e4426d128ef8bceb4cc1", 44846, Common::SE_SWE, 851),
	WINGAME1_l("garygadget4", "", "MulleHus.exe", "0c81c84ca4966313ad27d47daba44537", 3760882, Common::SE_SWE, 851),
	WINGAME1_l("garygadget4", "", "MulleHus.exe", "0c81c84ca4966313ad27d47daba44537", 3793560, Common::FI_FIN, 851),

	// Mac OS X and Windows versions are D9
	MACGAME1_l("garygadget5", "Classic OS", "Miel5 OS9", "789536da81694518f494945bb161ace9", 234210, Common::NL_NLD, 851),

	// Mac version on CD02 is D10
	WINGAME1("girlsaloudbox", "CD02 No Good Advice",		"Clickme.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2911148, 800),
	MACGAME1("girlsaloudbox", "CD03 Life Got Cold",			"Enhanced",	   "08c9ea94f6469e71ae0c71987bbf6323", 190678, 850),
	WINGAME2("girlsaloudbox", "CD03 Life Got Cold",			"Start.exe",   "c163f36141579ee374f7b4b2bddee95a", 2117284,
															"ECD.dxr",	   "7d8cb42d6784efca5dda28e879423f84", 14581925, 850),
	MACGAME1("girlsaloudbox", "CD05 The Show",				"Enhanced",	   "08c9ea94f6469e71ae0c71987bbf6323", 186904, 850),
	WINGAME2("girlsaloudbox", "CD05 The Show",				"Start.exe",   "c163f36141579ee374f7b4b2bddee95a", 2117284,
															"ECD.dxr",	   "4517e9e28fcec6762e8155765221d9e8", 3446870, 850),
	WINGAME2("girlsaloudbox", "CD13 Something Kinda Ooooh", "Start.exe",   "c163f36141579ee374f7b4b2bddee95a", 2117284,
															"ECD.dxr",	   "27e4760a954f90285f80331ed5036426", 4236916, 850),

	MACGAME1_l("girlspack", "", "Das Girl's Pack", "4ea5fc09f79eee6dded94dc40f303779", 214488, Common::DE_DEU, 800),
	WINGAME2_l("girlspack", "", "Projector.exe",   "e24d4bab978b1a5c2326d2c56cf4d781", 2251176,
								"picture.cxt",	   "e69c284d644c4f446b2ec4d876f94f17", 568440, Common::DE_DEU, 800),

	// Early Education Series from Ariss Computer Inc. of Beirut
	WINGAME1_l("hamamalachkal", "", "SHAPE.EXE",  "c163f36141579ee374f7b4b2bddee95a", 3784670, Common::AR_ARB, 850),
	WINGAME1_l("hamamalalwan", "",  "COLOR.EXE",  "c163f36141579ee374f7b4b2bddee95a", 3786748, Common::AR_ARB, 850),
	WINGAME1_l("hamamalhuruf", "",	"LETTER.EXE", "c163f36141579ee374f7b4b2bddee95a", 3797680, Common::AR_ARB, 850),

	// Mac OS X executable is D9
	MACGAME1("heuther", "Classic OS", "HuetherOS9", "789536da81694518f494945bb161ace9", 178551, 851),

	WINGAME1_l("irpf2002", "", "Tutorial do IRPF2002.exe", "c163f36141579ee374f7b4b2bddee95a", 3197116, Common::PT_BRA, 850),

	MACGAME1("kellyparade", "", "Kelly Club Pet Parade", "08c9ea94f6469e71ae0c71987bbf6323", 155765, 851),
	WINGAME1("kellyparade", "", "Kelly Club Pet Parade.exe", "c163f36141579ee374f7b4b2bddee95a", 2116952, 851),

	WINGAME1("kidsmathsquest", "", "Ekmquest.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4775408, 800),

	// Vlaams Centrum voor Agro- en Visserijmarketing is a government agency that promotes agricultural products
	// The CD-ROM offers the opportunity to work on healthy food, more specifically on fruit and vegetables
	// Additional activities are offered for parents, teachers and management
	MACGAME1_l("kjoeties", "", "Kjoeties",	   "3df301ad7614245a6ab1fb5d9ae6e474", 213295, Common::NL_NLD, 800),
	WINGAME1_l("kjoeties", "", "Kjoeties.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2281118, Common::NL_NLD, 800),

	// Developed by CircumStance Design
	MACGAME1("kothhoot", "v2.0", "Hoot", "90597a84a08b06e07af8bc5ab427676b", 5909, 800),
	WINGAME1t("kothhoot", "v2.0", "HootPC.exe", "12021662e10c3a53d784dacf215c0111", 2242603, 800),

	// Developed by CircumStance Design
	MACGAME1("koththunt", "v2.0", "T-Hunt-mac", "41d09ba569da51ac5c075bfde0f8e10b", 25216, 800),
	WINGAME1t("koththunt", "v2.0", "ThuntPC.exe", "775b80653a1daa36dc82257ac2b83fda", 2103339, 800),

	// From Dutch Pettson 1 v3.0 disc
	// Static screen with 2 http links (one to local html files) and a mailto link
	// Original Mac and Win filenames are Méér speel-en leerplezier!
	MACGAME1_l("lannoo", "", "Meer speel-en leerplezier!", "08c9ea94f6469e71ae0c71987bbf6323", 155737, Common::NL_NLD, 850),
	WINGAME1_l("lannoo", "", "Meer speel-en leerplezier!.exe", "c163f36141579ee374f7b4b2bddee95a", 2564520, Common::NL_NLD, 850),

	// Movie preview. Mac file system simply links to QuickTime movie.
	WINDEMO1("lbt8", "Preview", "lbt.exe", "c163f36141579ee374f7b4b2bddee95a", 2210752, 850),

	MACGAME2("lewisclark", "", "Begin",		   "08c9ea94f6469e71ae0c71987bbf6323", 155737,
							   "mainmenu.dxr", "31bd20f92460376a62f3b652dd9a5ec8", 3828023, 850),
	WINGAME2("lewisclark", "", "Begin.exe",	   "c163f36141579ee374f7b4b2bddee95a", 2837534,
							   "mainmenu.dxr", "744f296ef21e07252253bf499e6e5e68", 3831200, 850),

	MACGAME1("lewisclarkss", "", "Lewis and Clark Screen Saver", "b1bf6ceb4afd79814f93ee1d866f9a29", 243455, 850),
	WINGAME1("lewisclarkss", "", "Lewis and Clark Screen Saver.exe", "c163f36141579ee374f7b4b2bddee95a", 29172512, 850),

	// Plays school instructional videos, loads PDF documents, installs D10 game
	WINGAME1_l("limit0inici", "", "limit0_inici.exe", "0c81c84ca4966313ad27d47daba44537", 723194, Common::CA_ESP, 851),

	WINGAME1t("listen7up", "Volume 1", "rock.exe", "25a71af5e9a5b2dbfe70eecb3152c44a", 4556166, 800),

	// Original Win executable name is Löwenzahn5.exe
	WINGAME1t_l("loewe5", "", "xn--lwenzahn5.exe-imb", "9c59833b332f0b9f8ecc97f0aa47ec99", 2386566, Common::DE_DEU, 800),

	WINGAME1_l("lunes", "", "Lunes.exe", "9482a4a5f6ae02470ce1863808120f6e", 2258509, Common::IT_ITA, 851),

	// Advertainment film from Ferrero (chocolates)
	WINGAME1_l("magicanti", "", "Magicanti.exe", "0c81c84ca4966313ad27d47daba44537", 2158202, Common::IT_ITA, 851),

	WINGAME1t_l("maus2", "", "Maus2.exe", "7b470c720b74aba9d7ac5d0706141a33", 1779882, Common::DE_DEU, 800),

	MACDEMO1("mickeyk", "D8 Demo",	 "MickeyK",		 "4ea5fc09f79eee6dded94dc40f303779", 197114, 800),
	WINDEMO1("mickeyk", "D8 Demo",	 "MickeyK.exe",	 "e24d4bab978b1a5c2326d2c56cf4d781", 2532440, 800),
	MACDEMO1("mickeyp", "D8 Demo",	 "MickeyP",		 "4ea5fc09f79eee6dded94dc40f303779", 198055, 800),
	WINDEMO1("mickeyp", "D8 Demo",	 "MICKEYP.exe",	 "e24d4bab978b1a5c2326d2c56cf4d781", 2542920, 800),
	MACDEMO1("mickeyt", "D8 Demo",	 "MickeyT",		 "4ea5fc09f79eee6dded94dc40f303779", 197788, 800),
	WINDEMO1("mickeyt", "D8 Demo",	 "MickeyT.exe",	 "e24d4bab978b1a5c2326d2c56cf4d781", 2277079, 800),
	MACDEMO1("mickeyk", "Slideshow", "sMickeyK.mac", "4ea5fc09f79eee6dded94dc40f303779", 197086, 800),
	WINDEMO1("mickeyk", "Slideshow", "sMickeyK.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4847376, 800),
	MACDEMO1("mickeyp", "Slideshow", "sMickeyP.mac", "4ea5fc09f79eee6dded94dc40f303779", 198027, 800),
	WINDEMO1("mickeyp", "Slideshow", "sMickeyP.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4518947, 800),
	WINDEMO1("mickeyt", "Slideshow", "sMickeyT.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4290004, 800),

	WINGAME1t("mightymachines", "DVD rerelease", "PROJECTO.EXE", "3159e82225dc0d21f91c0afbecba84e5", 4693198, 850),

	// Published by Fujitsu BSC, Minato City, Tokyo
	MACGAME1_l("momotaro", "", "MOMOTARO", "2e860522900a5342e52e5ce51bcad9dd", 194842, Common::JA_JPN, 800),
	WINGAME1_l("momotaro", "", "MOMOTARO.EXE", "a60f99447824a8ef70799dd7596b8945", 4011752, Common::JA_JPN, 800),

	// Produced and developed by New Tier Inc., Scottsdale, Arizona
	WINGAME1("njdevils2001", "", "NJDevils.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 45455403, 800),

	// OS X version is D9
	MACGAME1("nobel100", "Classic OS", "data/MacOSClassic/Mac Classic Start", "789536da81694518f494945bb161ace9", 206460, 851),
	WINGAME2t("nobel100", "", "Start.exe", "5d4d87f2ffcb3c111eeb06ba1879e62d", 151979,
							  "data/Home.dxr", "3d1ced8f1f20940f79f161cf27c6a07a", 413135, 850),

	WINGAME1("noddyfair", "", "Noddy PC.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 2197822, 850),

	MACGAME2_l("okay2000", "", "Start",	   "8c1b4ddb1adff89deaba119f7cf8df7b", 195159,
							   "TITEL.DXR",  "6190d0e21cb88e9f37afce89b41aa8ff", 1187527, Common::DE_DEU, 800),
	WINGAME1_l("okay2000", "", "Ok0032.exe", "70a7b053c1a60617d3baace061fcba54", 3565692, Common::DE_DEU, 800),

	MACGAME1_l("operafatal", "Classic OS", "Opera Classic", "78e78f91a6e42ece5a585c3a3dc81de3", 172200, Common::DE_DEU, 800),

	// Mac version requires installation, Install Sampler, Installer VISE 3.5 LITE installer
	MACGAME2("optimumrsrc", "", "SAMPLER", "64cc6d7654b62973f8b72099eb0ea934", 196851,
								"esl_bil.dxr", "70e5dd0d083af6f150eec9f2587c91ec", 9763420, 800),
	WINGAME2t("optimumrsrc", "", "sampler.exe", "1269bfae9866db2000a012ad4107efe4", 2323650,
								 "esl_bil.dxr", "fa0a09ae0b5ecb47148708a30f28fd66", 9763420, 800),

	WINGAME1t_l("janoschpanama", "", "panama.exe", "25d1a9fb6c8067953888719e07dc29bd", 2384444, Common::DE_DEU, 800),
	WINGAME1t_l("janoschverkehr", "", "verkehr.exe", "fa749c7798f69f4aa615d35b2b991348", 2294886, Common::DE_DEU, 851),

	WINGAME1("pcformat", "PCF132 CD 02/02", "PCF132.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4722596, 800),

	WINGAME1t("pennyhorse", "", "PennyHorse.exe", "3aa62f6efd4616c3cc6b935411c1f8a7", 4780197, 851),

	// Mac OS X installer runs the game in Classic environment
	MACGAME1_l("pettson1", "v3.0", "Spelen",	   "a44511b8ff0e46b4f9c85dd1cb58d458", 158043, Common::NL_NLD, 851),
	WINGAME1_l("pettson1", "v3.0", "Spelen.exe",   "568c6f849ff7f2104636a99f151a6cd6", 3249822, Common::NL_NLD, 851),

	// Pettson & Findus in de tuin (Libelle)
	WINGAME1_l("pettson2", "", "pettstart.exe",   "518a98696fe1122e08410b0f157f21bf", 1534912, Common::NL_NLD, 851),
	MACGAME1_l("pettson2", "", "Spelen",	   "124ee629902a66fe1fb20b18ae4a1788", 3924112, Common::NL_NLD, 851),

	MACGAME1_l("pettson3", "",	   "Pettson3",	   "4ea5fc09f79eee6dded94dc40f303779", 211841, Common::SE_SWE, 800),
	WINGAME1_l("pettson3", "",	   "Pettson3.exe", "1c753fb8361ba617ae6142fcdd12d3d5", 2443868, Common::SE_SWE, 800),

	WINGAME1t_l("pettson4", "", "Findus4.exe", "34a951dd3b5e4e9aad58798d3eee8a69", 2253756, Common::DE_DEU, 800),

	WINDEMO1("phonicsquest", "Demo", "Phonics Quest Demo.exe", "0c81c84ca4966313ad27d47daba44537", 2202074, 851),

	// Original name is "Syng, lær og leg"
	MACGAME1_l("pixeline1", "", "xn--syng, lr og leg-3lb",		"a44511b8ff0e46b4f9c85dd1cb58d458", 157815, Common::DA_DNK, 851),
	WINGAME1_l("pixeline1", "", "xn--syng, lr og leg.exe-rxb", 	"0c81c84ca4966313ad27d47daba44537", 3797528, Common::DA_DNK, 851),

	// Original name is "Hulen i træet"
	MACGAME1_l("pixeline2", "", "xn--hulen i tret-gdb",	 	"08c9ea94f6469e71ae0c71987bbf6323", 157809, Common::DA_DNK, 850),
	WINGAME1_l("pixeline2", "", "xn--hulen i tret.exe-3ob", "c163f36141579ee374f7b4b2bddee95a", 2747781, Common::DA_DNK, 850),

	// Original name is "På bedstemors loft"
	MACGAME1_l("pixeline3", "", "xn--p bedstemors loft-8qb",	 "08c9ea94f6469e71ae0c71987bbf6323", 157809, Common::DA_DNK, 850),
	WINGAME1_l("pixeline3", "", "xn--p bedstemors loft.exe-s2b", "c163f36141579ee374f7b4b2bddee95a", 2772479, Common::DA_DNK, 850),

	MACGAME1_l("pixeline4", "", "I eventyrskoven",		"a44511b8ff0e46b4f9c85dd1cb58d458", 157815, Common::DA_DNK, 851),
	WINGAME1_l("pixeline4", "", "I eventyrskoven.exe",	"0c81c84ca4966313ad27d47daba44537", 2814073, Common::DA_DNK, 851),

	MACGAME1_l("pixeline5", "", "I sommerhuset",		"08c9ea94f6469e71ae0c71987bbf6323", 157809, Common::DA_DNK, 850),
	WINGAME1_l("pixeline5", "", "I sommerhuset.exe",	"c163f36141579ee374f7b4b2bddee95a", 2712537, Common::DA_DNK, 850),

	MACGAME1_l("pixeline6", "", "For fulde sejl",		"a44511b8ff0e46b4f9c85dd1cb58d458", 157815, Common::DA_DNK, 851),
	WINGAME1_l("pixeline6", "", "For fulde sejl.exe",	"0c81c84ca4966313ad27d47daba44537", 2739895, Common::DA_DNK, 851),

	MACGAME1_l("pixeline7", "", "Pixeline-fuld af fis og ballade",  "7d4c726f1ddb1b7c3c2828717a4b80b5", 160038, Common::DA_DNK, 850),
	WINGAME1_l("pixeline7", "", "Pixeline 7.exe", 					"c163f36141579ee374f7b4b2bddee95a", 2485646, Common::DA_DNK, 850),

	WINGAME2_l("plcd", "Nº4 2001", "Start.exe",		  "e24d4bab978b1a5c2326d2c56cf4d781", 2247370,
								   "PL_2001_#04.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 3842928, Common::RU_RUS, 800),

	//Requires installation
	WINGAME2_l("polis3", "",		 "polis3.exe",				 "e24d4bab978b1a5c2326d2c56cf4d781", 3901334,
									 "polis3.dxr",				 "3dea9440d719e76e1be194554580751a", 365957, Common::SE_SWE, 800),
	WINGAME2_l("polis3", "Launcher", "launcher.exe",			 "402a7987696daf894708bd448b4d66ae", 946176,
									 "data/video/introfilm.bin", "767f5ad8cdf8cb021b03eb881b879e22", 4425728, Common::SE_SWE, 800),
	// unconfirmed version (spanish?)
	WINGAME2_l("polis3", "", "launcher.exe", "0c81c84ca4966313ad27d47daba44537", 2860282,
							 "polis3.dxr",	 "1a391250c502a1f55da5a4d0438b493d", 3533782, Common::ES_ESP, 851),

	WINGAME1("poohb", "", "POOHBABY.EXE",		 "e24d4bab978b1a5c2326d2c56cf4d781", 2290422, 800),

	MACGAME1("poohp", "", "PoohP.Mac",			 "4ea5fc09f79eee6dded94dc40f303779", 197191,  800),
	WINGAME1("poohp", "", "PoohP.exe",			 "e24d4bab978b1a5c2326d2c56cf4d781", 2692574, 800),
	MACDEMO1("poohp", "D8 Demo", "PoohP",		 "4ea5fc09f79eee6dded94dc40f303779", 197191,  800),
	WINDEMO1("poohp", "D8 Demo", "PoohP.exe",	 "e24d4bab978b1a5c2326d2c56cf4d781", 2692738, 800),
	WINDEMO1("poohp", "Slideshow", "sPoohP.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 4080558, 800),
	WINDEMO1("poohp", "Slideshow", "PoohPD.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 6362184, 800),

	WINGAME1("pooht", "", "PoohT.exe",			 "e24d4bab978b1a5c2326d2c56cf4d781", 2690898, 800),
	MACDEMO1("pooht", "D8 Demo", "PoohT",		 "4ea5fc09f79eee6dded94dc40f303779", 197191,  800),
	WINDEMO1("pooht", "D8 Demo", "PoohT.exe",	 "e24d4bab978b1a5c2326d2c56cf4d781", 2691062, 800),
	WINDEMO1("pooht", "Slideshow", "PoohTD.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 5596394, 800),

	MACDEMO1("poohk", "D8 Demo", "PoohK",		 "4ea5fc09f79eee6dded94dc40f303779", 196535,  800),
	WINDEMO1("poohk", "D8 Demo", "PoohK.exe",	 "e24d4bab978b1a5c2326d2c56cf4d781", 2688206, 800),
	MACDEMO1("poohk", "Slideshow", "sPoohK.mac", "4ea5fc09f79eee6dded94dc40f303779", 196507,  800),
	WINDEMO1("poohk", "Slideshow", "sPoohK.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 3933055, 800),
	WINDEMO1("poohk", "Slideshow", "PoohKD.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 5985988, 800),

	MACGAME1_l("pukapukarei", "すくいゲーム", "SCOOP.x", "6731d833cdbb8ee2a2d28071ce2797ad", 197106, Common::JA_JPN, 800),
	WINGAME1t_l("pukapukarei", "すくいゲーム", "SCOOP.EXE", "7a97c8c574bd2d8349e9cfe6f8a40c1f", 3425154, Common::JA_JPN, 800),
	MACGAME1_l("pukapukarei", "旗揚げゲーム", "FLAG.x", "6731d833cdbb8ee2a2d28071ce2797ad", 197106, Common::JA_JPN, 800),
	WINGAME1t_l("pukapukarei", "旗揚げゲーム", "FLAG.EXE", "93e0e69d958632547304f002ccbe6d91", 3280159, Common::JA_JPN, 800),
	MACGAME1_l("pukapukarei", "着せ替えスロットゲーム", "SLOT.x", "6731d833cdbb8ee2a2d28071ce2797ad", 197106, Common::JA_JPN, 800),
	WINGAME1t_l("pukapukarei", "着せ替えスロットゲーム", "SLOT.EXE", "6827304c94902bc1df1c648eed6a930a", 4056344, Common::JA_JPN, 800),
	MACGAME1_l("pukapukarei", "観察日誌", "KANSATU.x", "6731d833cdbb8ee2a2d28071ce2797ad", 197106, Common::JA_JPN, 800),
	WINGAME1t_l("pukapukarei", "観察日誌", "KANSATU.EXE", "8a5a18cc63e4b167593bf59370c0bc1d", 2927302, Common::JA_JPN, 800),
	MACGAME1_l("pukapukarei", "神経衰弱", "SINKEI.x", "6731d833cdbb8ee2a2d28071ce2797ad", 197106, Common::JA_JPN, 800),
	WINGAME1t_l("pukapukarei", "神経衰弱", "SINKEI.EXE", "b2f08d3cb8df1caea6ecccd0e9f814a1", 3128624, Common::JA_JPN, 800),
	MACGAME1_l("pukapukarei", "着せ替えゲーム", "CHGCLOTH.x", "6731d833cdbb8ee2a2d28071ce2797ad", 197106, Common::JA_JPN, 800),
	WINGAME1t_l("pukapukarei", "着せ替えゲーム", "CHGCLOTH.EXE", "c0f95d96a74492bf1130f5f561cf7952", 3192966, Common::JA_JPN, 800),

	WINGAME1_l("ratinho", "", "ratinho.exe", "c163f36141579ee374f7b4b2bddee95a", 2119876, Common::PT_BRA, 850),

	// Speeltijd met spookjes
	WINGAME2_l("recfantome", "", "Speel.exe", "2942c9272bb0f41e53f5d103af16195c", 3443389,
								 "fantome.ico", "d357185c51154ed60bb05aea3689dc60", 2238, Common::NL_NLD, 800),

	// Playable demo for Meteor Madness and Tremor Trouble
	MACGAME1("rh", "", "RHDemo", "08c9ea94f6469e71ae0c71987bbf6323", 155737, 850),
	WINGAME1("rh", "", "RHDemo.exe", "c163f36141579ee374f7b4b2bddee95a", 2250046, 850),

	WINDEMO1("rhem1", "Demo", "RhemDemo.exe", "70a7b053c1a60617d3baace061fcba54", 3061118, 800),

	MACGAME1("rhlava", "", "RH Lava Landslide", "08c9ea94f6469e71ae0c71987bbf6323", 161151, 850),
	WINGAME1("rhlava", "", "RH Lava Landslide.exe", "c163f36141579ee374f7b4b2bddee95a", 2116280, 850),
	MACGAME1("rhmeteor", "", "RH Meteor Madness", "4ea5fc09f79eee6dded94dc40f303779", 199688, 800),
	WINGAME1("rhmeteor", "", "RescueHeroes.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2248192, 800),

	MACGAME2("royksoppam", "Bonus disc", "Projector", "a44511b8ff0e46b4f9c85dd1cb58d458", 155743,
										 "MAIN.dxr",  "b03dfbaac4bf75198d724048e4fdad80", 3236242, 851),

	// Produced and developed by New Tier Inc., Scottsdale, Arizona
	WINGAME1("saspurs2001", "", "Spurs.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 5924396, 800),
	WINGAME1("saspurs2005", "", "Spurs.exe", "98e75b2c5561f9be40aa745f35f22244", 5508840, 800),

	MACDEMO1("secretkeys", "Demo", "Secret Keys Demo", "a44511b8ff0e46b4f9c85dd1cb58d458", 155771, 851),
	WINDEMO1("secretkeys", "Demo", "Secret Keys Demo.exe", "0c81c84ca4966313ad27d47daba44537", 2200706, 851),

	// Mac OS X executables are D9
	MACGAME1_l("sethi2", "Classic OS", "Sethi Incas",     "41e7d3bf50e4085c35eba322aa63b238", 161027,  Common::FR_FRA, 851),
	WINGAME1_l("sethi2", "",		   "Sethi_Incas.exe", "0c81c84ca4966313ad27d47daba44537", 2158774, Common::FR_FRA, 851),
	MACGAME1_l("sethi3", "Classic OS", "Start Me OS9",    "789536da81694518f494945bb161ace9", 179887,  Common::DE_DEU, 851),

	// Published by Virtual Views, Turin (2003) in English, French, Italian
	// Players were posted online throughout the decade for compatibility with later OS versions
	// FIXME: Needs confirmation
	MACGAME1("sinkha1", "", "HYLEYN",	  "08c9ea94f6469e71ae0c71987bbf6323", 157809, 850),
	WINGAME1("sinkha1", "", "HYLEYN.exe", "c163f36141579ee374f7b4b2bddee95a", 2117678, 850),

	// Players for Classic Mac OS / Win9x, available here:
	// http://www.sinkha.com/dfiles/players/HY_MOSC.sit.bin
	// http://www.sinkha.com/dfiles/players/HY_WIN1.zip
	MACGAME2("sinkha1", "Classic", "START",		 "12f06b96b6e1e721d22a4e60e938effc", 157815,
								   "ME/MAA.cxt", "3f79a60e8f8a884f67855a5c1f0e66b5", 835098, 850),
	WINGAME2("sinkha1", "98 - XP SP1", "START_(Win_98-ME-2000-XP_sp1).exe", "c163f36141579ee374f7b4b2bddee95a", 2117678,
									   "ME/MAA.cxt",						"3f79a60e8f8a884f67855a5c1f0e66b5", 835098, 850),

	// Published in 2007 (see notes for episode 1)
	// Episodes 2 and 3 were sold together on one CD
	// Episode selection is available after starting game
	// FIXME: Needs confirmation
	WINGAME2("sinkha2", "", "START.exe", "c163f36141579ee374f7b4b2bddee95a", 2117422,
							"Init.dxr",  "40ef7beccb79c1a17a54752d833fc672", 769420, 850),

	// Players for Classic Mac OS / Win9x, available here:
	// http://www.sinkha.com/dfiles/players/ATM_MOSC.sit.bin
	// http://www.sinkha.com/dfiles/players/ATM_WIN1.zip
	MACGAME2("sinkha2", "Classic", "START",		 "12f06b96b6e1e721d22a4e60e938effc", 238342,
								   "ME/MAA.cxt", "26f7dcd7a5690910f2116205f54cb44b", 759494, 850),
	WINGAME2("sinkha2", "98 - XP SP1", "START_(Win_98-ME-2000-XP_sp1).exe", "c163f36141579ee374f7b4b2bddee95a", 2117678,
									   "ME/MAA.cxt",						"26f7dcd7a5690910f2116205f54cb44b", 759494, 850),

	WINGAME1_l("skeeto10", "", "mm7main.exe", "0c81c84ca4966313ad27d47daba44537", 12051446, Common::DA_DNK, 851),

	// Dutch demos found on Flipper & Lopaka compilation
	MACGAME1_l("skippy", "",     "Skippy",      "4ea5fc09f79eee6dded94dc40f303779", 197127, Common::NL_NLD, 800),
	MACDEMO1_l("skippy", "Demo", "Skippy Demo", "4ea5fc09f79eee6dded94dc40f303779", 196871, Common::NL_NLD, 808),
	WINDEMO1t_l("skippy", "Demo", "Skippy.exe", "e6dea6cfeca3d59e6074959b68ce6131", 56112,  Common::NL_NLD, 800),

	// Loads two external Flash games and one external Director game
	WINGAME1("smashchillin", "ECD", "Smash.exe", "c163f36141579ee374f7b4b2bddee95a", 2152147, 850),

	MACGAME2("songbird", "ECD", "Solitudes",			 "08c9ea94f6469e71ae0c71987bbf6323", 157045,
								"Songbird Symphony.CDQ", "8383a2142c38600d464847409b76db5a", 5925, 850),
	WINGAME1("songbird", "ECD", "solitudes.exe",		 "c163f36141579ee374f7b4b2bddee95a", 2118995, 850),

	MACGAME2("stressrelief2", "ECD", "Solitudes",					 "08c9ea94f6469e71ae0c71987bbf6323", 157045,
									 "Natural Stress Relief II.CDQ", "18256d220db28ca68c8907d5ac590190", 12912, 850),

	WINGAME1("spykids3d", "", "Spy Kids 3D.exe", "c163f36141579ee374f7b4b2bddee95a", 1314722, 850),

	// Found on JCPenney Unwrap the Magic (2000)
	MACGAME1("ss102dalmations", "", "102 Dalmations",	 "7bcc1b0cae920a784384bfcf7de895bf", 327494, 800),
	WINGAME1("ss102dalmations", "",	"102dalmatians.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2918994, 800),
	MACGAME1("sspeekaboo", "",		"Peek-a-boo Pooh",	 "7bcc1b0cae920a784384bfcf7de895bf", 327735, 800),
	WINGAME1("sspeekaboo", "",		"pooh.exe",			 "e24d4bab978b1a5c2326d2c56cf4d781", 2485973, 800),
	MACGAME1("ssholidaymickey", "",	"Holiday Mickey",	 "7bcc1b0cae920a784384bfcf7de895bf", 327494, 800),
	WINGAME1("ssholidaymickey", "",	"mickey.exe",		 "e24d4bab978b1a5c2326d2c56cf4d781", 3200102, 800),

	// ein Fall für TKKG: Das geheimnisvolle Testament (bilingual DE/EN)
	MACGAME2("tkkg8", "", "TKKG-Start", "8c1b4ddb1adff89deaba119f7cf8df7b", 197195,
						  "Score.dxr", "d7300d214a30ec129cb4939aeddc3392", 17770, 800),
	WINGAME1t("tkkg8", "", "TKKG 8.exe", "3284e5212dee57129a32ba86367ce816", 2324424, 800),

	// ein Fall für TKKG: Voodoozauber (bilingual DE/EN)
	MACGAME2("tkkg9", "", "TKKG-Start", "2c64a568bd26944452957a53af85b067", 197167,
						  "Score.dxr", "d7300d214a30ec129cb4939aeddc3392", 17770, 800),
	WINGAME1t("tkkg9", "", "TKKG 9.exe", "3284e5212dee57129a32ba86367ce816", 2329244, 800),

	// ein Fall für TKKG: Panik im Internat (bilingual DE/EN)
	MACGAME1("tkkg10", "", "TKKG10", "4ea5fc09f79eee6dded94dc40f303779", 197107, 800),
	WINGAME1t("tkkg10", "", "TKKG10.exe", "d34aacfc572a9f82867aa88be20d32c2", 70628, 800),

	// Mac OS X versions of these TKKG games are D9
	// ein Fall für TKKG: Film ab! (bilingual DE/EN)
	MACGAME1("tkkg11", "Classic", "TKKG11", "789536da81694518f494945bb161ace9", 182599, 909),

	// ein Fall für TKKG: Alarm in der Geisterbahn (bilingual DE/EN)
	MACGAME1("tkkg12", "Classic", "TKKG12", "789536da81694518f494945bb161ace9", 182599, 909),

	// ein Fall für TKKG: Zelle 13 (bilingual DE/EN)
	MACGAME1("tkkg13", "Classic", "TKKG13", "789536da81694518f494945bb161ace9", 180795, 909),

	// ein Fall für TKKG: Gefährliche Ferien (bilingual DE/EN)
	MACGAME1("tkkg14", "Classic", "TKKG14", "789536da81694518f494945bb161ace9", 182599, 909),

	// Original Mac filename is ときメモタイピング
	MACGAME1_l("tokimemotype1", "", "Tokimemo Typing", "80b8d1697b18f6f2d8a2813a594cead2", 255114, Common::JA_JPN, 851),
	WINGAME1_l("tokimemotype1", "", "tkmktype.exe",	"d5069f2a24854aa78f8fbd01462ba37c", 2160344, Common::JA_JPN, 851),

	MACGAME1_l("trans", "", "Trans", "2e860522900a5342e52e5ce51bcad9dd", 219919, Common::JA_JPN, 850),
	WINGAME1t_l("trans", "", "Trans.exe", "de336a369a0fa4aab1b3d9dc07b1624d", 2117070, Common::JA_JPN, 850),

	MACGAME1_l("trazanbanarne", "",	 "Trazan & Banarne",	 "4ea5fc09f79eee6dded94dc40f303779", 196935, Common::SE_SWE, 800),
	WINGAME1t_l("trazanbanarne", "", "Trazan & Banarne.exe", "00a3e2aecf8a07a5dd532bf8fdce390c", 2895014, Common::SE_SWE, 800),

	WINGAME1("tweeniesrtp", "", "BBC Tweenies Tour.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 5435024, 800),

	WINGAME1_l("unlimitedcl", "", "CD-ROMs Educativos.exe", "0c81c84ca4966313ad27d47daba44537", 2366839, Common::ES_ESP, 851),

	MACGAME2("unwrap", "", "Start Here", "4ea5fc09f79eee6dded94dc40f303779", 194863,
						   "unwrap.dxr", "4016e7c9c9782eb8533d68aa96898066", 50599511, 800),
	WINGAME2("unwrap", "", "Start.exe",	 "e24d4bab978b1a5c2326d2c56cf4d781", 3631198,
						   "unwrap.dxr", "69dd7f79e76af5b0eab89d5ae589f836", 50599487, 800),

	MACGAME1("vug2005", "", "VUGames.osx", "a171b7a952d1ac68ae3cd419d6dfc674", 262042, 850),
	WINGAME1("vug2005", "", "VUG_2005.exe", "c163f36141579ee374f7b4b2bddee95a", 2823410, 850),

	MACGAME1("westwood", "", "WW DPK", "4ea5fc09f79eee6dded94dc40f303779", 194863, 800),
	WINGAME1("westwood", "", "WW_DPK.exe", "e24d4bab978b1a5c2326d2c56cf4d781", 2351418, 800),

	// These only differ by the included wallpaper and comic
	MACGAME2("xmen-burgerking", "Cyclops", "XMEN", "4ea5fc09f79eee6dded94dc40f303779", 196871,
										   "Comic/issues/cyclops.swf", "cbf9e69d550e4eea19697e8259ff9bfc", 1528559, 800),
	WINGAME2t("xmen-burgerking", "Cyclops", "xmen.exe", "c9a4619a36fd555966cb3d903ae8887f", 2250798,
											"Comic/issues/cyclops.swf", "f79f4cb0ce3bf3f65f14936449be2005", 1528559, 800),
	MACGAME2("xmen-burgerking", "Magneto", "XMEN", "4ea5fc09f79eee6dded94dc40f303779", 196871,
										   "Comic/issues/magneto.swf", "18eaad40c806b052b188c225582749f5", 1663916, 800),
	WINGAME2t("xmen-burgerking", "Magneto", "xmen.exe", "c9a4619a36fd555966cb3d903ae8887f", 2250798,
											"Comic/issues/magneto.swf", "2eb262c96caa6c5d3228633914c0188b", 1663916, 800),
	MACGAME2("xmen-burgerking", "Mystique", "XMEN", "4ea5fc09f79eee6dded94dc40f303779", 196871,
											"Comic/issues/mystique.swf", "5001426be4d06d8f41ba9b568b4106e0", 1408296, 800),
	WINGAME2t("xmen-burgerking", "Mystique", "xmen.exe", "c9a4619a36fd555966cb3d903ae8887f", 2250798,
											 "Comic/issues/mystique.swf", "661fcb999537ac12cfc9d5021c3e7ef8", 1408296, 800),
	MACGAME2("xmen-burgerking", "Nightcrawler", "XMEN", "4ea5fc09f79eee6dded94dc40f303779", 196871,
												"Comic/issues/nightcrawler.swf", "0a88f3394ece9ae256533ebc0153e6a6", 3260798, 800),
	WINGAME2t("xmen-burgerking", "Nightcrawler", "xmen.exe", "c9a4619a36fd555966cb3d903ae8887f", 2250798,
												 "Comic/issues/nightcrawler.swf", "ad17845d6e684bf698b5dc47266489e8", 3260798, 800),
	MACGAME2("xmen-burgerking", "Quicksilver", "XMEN", "4ea5fc09f79eee6dded94dc40f303779", 196871,
											   "Comic/issues/quicksilver.swf", "b2e591d0b0b201e118f5dae8158fd9d2", 2204025, 800),
	WINGAME2t("xmen-burgerking", "Quicksilver", "xmen.exe", "c9a4619a36fd555966cb3d903ae8887f", 2250798,
												"Comic/issues/quicksilver.swf", "e7eb73b13f585f18a4a145680c5b02ac", 2204025, 800),
	MACGAME2("xmen-burgerking", "Rogue", "XMEN", "4ea5fc09f79eee6dded94dc40f303779", 196871,
										 "Comic/issues/rogue.swf", "2f53877359763c3c1df76038778ee729", 1330923, 800),
	WINGAME2t("xmen-burgerking", "Rogue", "xmen.exe", "c9a4619a36fd555966cb3d903ae8887f", 2250798,
										  "Comic/issues/rogue.swf", "2faca8b96e595be822d4d893092a06a8", 1330923, 800),
	MACGAME2("xmen-burgerking", "Toad", "XMEN", "4ea5fc09f79eee6dded94dc40f303779", 196871,
										"Comic/issues/toad.swf", "b48563852c989803d96467ce7fed4109", 1429068, 800),
	WINGAME2t("xmen-burgerking", "Toad", "xmen.exe", "c9a4619a36fd555966cb3d903ae8887f", 2250798,
										 "Comic/issues/toad.swf", "dcc3a9eec85460e29a146c3a14bf6c38", 1429068, 800),
	MACGAME2("xmen-burgerking", "Wolverine", "XMEN", "4ea5fc09f79eee6dded94dc40f303779", 196871,
											 "Comic/issues/wolverine.swf", "dbc67fe22aab4ce9a59ca220c2287588", 1282980, 800),
	WINGAME2t("xmen-burgerking", "Wolverine", "xmen.exe", "c9a4619a36fd555966cb3d903ae8887f", 2250798,
											  "Comic/issues/wolverine.swf", "61220a36d2e79f62c4e7350cf9b25659", 1282980, 800),

	// Original Mac filename is 妖精妖怪図鑑
	MACGAME1_l("yokaizukan", "", "xn--lcs34da058ddt2bxt3a", "dd3c8aeb1d2847c77db701ad49ad8186", 163060, Common::JA_JPN, 850),
	WINGAME1_l("yokaizukan", "", "xn--.exe-ul4gs3la685khv6dnj8b", "b541b4e21a7284bef5180907f72d5702", 2118234, Common::JA_JPN, 850),

	MACGAME1_l("zwergnase", "", "Zwergnase", "afc6a14573e21d1de9d0c7fbb1ceb874", 181398, Common::DE_DEU, 851),
	WINGAME1_l("zwergnase", "", "ZWERGNASE.EXE", "0c81c84ca4966313ad27d47daba44537", 2383258, Common::DE_DEU, 851),

//////////////////////////////////////////////////
//
// Macromedia Director MX (v9)
//
//////////////////////////////////////////////////

	WINDEMO1("barbpauper", "Demo", "PPDemo.exe", "dde8ac96c47b16cb802a38feb1f1df19", 2519617, 900),

	WINGAME1_l("barbswanlake", "", "SwanLake.exe", "310659620631c126edb6943af1f83e38", 4096651, Common::FR_FRA, 900),
	WINDEMO1("barbswanlake", "Demo", "SwanLake.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 2385166, 900),

	WINGAME1_l("bpapao", "", "bpapao.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 4829907, Common::PT_BRA, 900),

	WINGAME1("bobcastle", "", "Bob's Castle Adventure.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 887534, 900),
	WINDEMO2("bobteam", "Trailer", "trailer.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 142794,
								   "trailer.mov", "798658eb3bdb3bb967384350f428854b", 4141897, 900),

	// There is an OS X installer, but the game itself runs in Classic environment (up to OS 10.4)
	MACGAME1_l("boulebill", "", "Boule et Bill Au voleur !!!", "9ba96b315646d5f62be9ab5597d2e0d7", 176370, Common::FR_FRA, 901),
	WINGAME1_l("boulebill", "", "Au voleur!.exe", "4b89dba499aefda5201eef3d27963d01", 2186312, Common::FR_FRA, 900),

	// Windows versions are D8
	// Disc 1
	MACGAME1("casino5p" ,"", "Casino!/Casino (OSX)", "d483e955df901222145267d2ad729ea2", 230404, 900),
	MACGAME1("casino5p" ,"", "Keno/Keno Master (OSX)", "d483e955df901222145267d2ad729ea2", 246990, 900),
	MACGAME1("casino5p" ,"", "Lottery/Lottery Advantage (OSX)", "d483e955df901222145267d2ad729ea2", 289036, 900),
	MACGAME1("casino5p" ,"", "Slot City/Slot City (OSX)", "d483e955df901222145267d2ad729ea2", 230407, 900),
	// Disc 2
	MACGAME1("casino5p" ,"", "Slots 200 Plus (OSX)", "d483e955df901222145267d2ad729ea2", 291178, 900),

	WINGAME1t("csimiami", "", "CSI-Miami.exe", "18c375549db93a8b7a09ee94ff24b891", 3521217, 900),

	WINGAME2_l("eso", "", "START.EXE",	"c612aa43e7ef55aa4fd2e1085fb1ef7a", 3752491,
						  "ESO_D1.DXR", "6d39a8ef9a8060e21616f23872c581b6", 2075636, Common::ES_ESP, 900),

	// Häuser bauen mit Willy Werkel localized by Terzio Verlag, Munich (2003)
	WINGAME1_l("garygadget4", "", "WILLYHAU.EXE", "e1cb27c285fc19a989f152b785b0f375", 137056, Common::DE_DEU, 900),

	// Mac Classic OS version is D8
	// German Mac OS X version is D10. Classic OS is not supported.
	// Raumschiffe bauen mit Willy Werkel published by Terzio, Munich (2005)
	MACGAME1_l("garygadget5", "OS X", "Miel5 OSX",           "d483e955df901222145267d2ad729ea2", 284016, Common::NL_NLD, 900),
	WINGAME1_l("garygadget5", "",     "WillyRaumschiff.exe", "6b9dc16e1d307150bfec28729b59a523", 2185322, Common::DE_DEU, 900),
	WINGAME1_l("garygadget5", "",     "Miel5.exe",           "7202313e2b177197b62e84dcf24d1292", 4253422, Common::NL_NLD, 900),

	MACGAME2("gp2006", "", "CLICK ME",	"d483e955df901222145267d2ad729ea2", 233800,
						   "Intro.cxt", "c7d1f703b3cfa4d134f601d17f8563a1", 673544, 900),
	WINGAME1("gp2006", "", "CLICK_ME.EXE", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 2182372, 900),

	// Language selection in German, English, French
	// Use Mac OS X executable in osx folder on disc
	MACGAME1("heidi", "", "Heidi", "d483e955df901222145267d2ad729ea2", 267460, 900),
	WINGAME1("heidi", "", "Heidi.exe", "25d73085a5735a3badecf8cf1945ffc3", 95418, 900),

	// Classic OS executable is D8
	MACGAME1("heuther", "OS X", "HuetherOSX", "d483e955df901222145267d2ad729ea2", 228355, 900),
	WINGAME1("heuther", "", "Huether.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 3353374, 900),

	WINGAME1t_l("loewe2", "", "Loewenzahn 2.exe", "861c0ac98a672fc3e537a26b8cc543be", 95970, Common::DE_DEU, 900),
	WINGAME1t_l("loewe3", "", "Loewenzahn 3.exe", "46243628b1d79872340993bdc4a156d8", 87791, Common::DE_DEU, 900),
	WINGAME1t_l("loewe4", "", "Loewenzahn 4.exe", "fcd7e3e7b9b1080f848c518b6e66d860", 87795, Common::DE_DEU, 900),
	WINGAME1t_l("loewe6", "", "Loewenzahn 6.exe", "c4135f262abdbf3f2dc660e341b8a192", 87820, Common::DE_DEU, 900),

	// Original Mac filename is Mats und das rätselhafte Tier
	// Mac version must be installed. Additional OS X installer runs the game Classic environment.
	MACGAME1_l("mats3", "", "Mats und das ratselhafte Tier", "9ba96b315646d5f62be9ab5597d2e0d7", 176978, Common::DE_DEU, 901),
	WINGAME1_l("mats3", "", "Mats3.exe", "4b89dba499aefda5201eef3d27963d01", 2187308, Common::DE_DEU, 900),

	// Classic Mac OS and Windows executables are D8
	MACGAME1("nobel100", "OS X", "data/MacOSX/Mac OSX Start", "332aaddc1bc68a89277ef016466a7140", 1295390, 900),

	MACGAME1_l("operafatal", "OS X", "Opera OSX", "3ab7133c17cd4f175e5cb14c6750766e", 222001, Common::DE_DEU, 900),
	WINGAME1_l("operafatal", "", "Opera.exe", "05e89a3d53d270cac3b53e0a6f9352f5", 2747652, Common::DE_DEU, 900),

	WINGAME1t_l("pettson2", "", "Gubben2.exe", "b50358ea0422c4b903ed261fa995b71f", 2187128, Common::NB_NOR, 900),
	MACGAME1t_l("pettson2", "MacOS", "Gubben2", "1768526c25ae041638f02312852dbe2b", 215165, Common::NB_NOR, 900),
	MACGAME1t_l("pettson2", "MacOSX", "Gubben2 (OS X)", "1768526c25ae041638f02312852dbe2b", 287790, Common::NB_NOR, 900),

	// Original filenames are Spökmaskinen (OS X) and Spökmaskinen.exe
	MACGAME1_l("pettson4", "", "Spokmaskinen (OS X)", "d483e955df901222145267d2ad729ea2", 284153, Common::SE_SWE, 900),
	WINGAME1_l("pettson4", "", "Spokmaskinen.exe", "627d23c658a36a3b6d0053a6dcda1a37", 2330628, Common::SE_SWE, 900),

	MACGAME1_l("pixeline9", "", "Pixeline - I Det Vilde Westen", "bb6be483050bd1524c5440229b595f7a", 236019, Common::DA_DNK, 900),
	MACGAME1_l("pixeline9", "OS X", "Pixeline - Mac OS X", 		 "4a522e1da5d5b8570e3ab625945b19cf", 234733, Common::DA_DNK, 900),
	WINGAME1_l("pixeline9", "", "Pixeline 9 DK.exe",			 "c612aa43e7ef55aa4fd2e1085fb1ef7a", 2816536, Common::DA_DNK, 900),

	WINGAME1("sajaklucky", "Deluxe", "LuckyLettersDeluxe.exe", "001d65a360a61861118f3cfa92c68ef3", 14018695, 900),

	// Classic Mac OS and Windows executables are D8
	MACGAME1_l("sethi2", "OS X", "Sethi Incas",	 "d483e955df901222145267d2ad729ea2", 233556, Common::FR_FRA, 900),
	MACGAME1_l("sethi3", "OS X", "Start Me OSX", "d483e955df901222145267d2ad729ea2", 229696, Common::DE_DEU, 900),
	WINGAME2_l("sethi3", "", "StartMe.exe",		 "c612aa43e7ef55aa4fd2e1085fb1ef7a", 2186964,
							 "StartMe.dxr",		 "55248d9db7aa326eb740b2532ba83252", 15584, Common::DE_DEU, 900),

	WINGAME1("stalker", "Press Kit", "Stalker.exe", "c612aa43e7ef55aa4fd2e1085fb1ef7a", 55314588, 900),

	// Most likely this is ES_MEX. Find more examples to justify a new language code.
	WINGAME2_l("timmysafari", "", "safari.exe", 		"c612aa43e7ef55aa4fd2e1085fb1ef7a", 2891613,
								  "menus/mainmenu.dxr", "61c019c326dae90c3ff7f53edf9c21b5", 95556, Common::ES_ESP, 900),

	// Classic Mac OS versions of these TKKG games are D8
	// ein Fall für TKKG: Film ab! (bilingual DE/EN)
	MACGAME1("tkkg11", "", "TKKG11", "d483e955df901222145267d2ad729ea2", 232402, 909),
	WINGAME1t("tkkg11", "", "TKKG11.exe", "96863b7ac45787b41881ab7bc7a39e06", 107935, 900),

	// ein Fall für TKKG: Alarm in der Geisterbahn (bilingual DE/EN)
	MACGAME1("tkkg12", "", "TKKG12", "d483e955df901222145267d2ad729ea2", 232402, 909),
	WINGAME1t("tkkg12", "", "TKKG12.exe", "bc9668350bf745cfc843e9cc4ae08e13", 110780, 909),

	// ein Fall für TKKG: Zelle 13 (bilingual DE/EN)
	MACGAME1("tkkg13", "", "TKKG13", "d483e955df901222145267d2ad729ea2", 230598, 909),
	WINGAME1t("tkkg13", "", "TKKG13.exe", "c4f4d41f3260223edbc6e0df93649189", 152784, 900),

	// ein Fall für TKKG: Gefährliche Ferien (bilingual DE/EN)
	MACGAME1("tkkg14", "", "TKKG14", "d483e955df901222145267d2ad729ea2", 298739, 909),
	WINGAME1t("tkkg14", "", "TKKG14.exe", "cf8679b4408b4a079e498cc42961ab43", 107813, 900),

//////////////////////////////////////////////////
//
// Macromedia Director MX 2004 (v10)
//
//////////////////////////////////////////////////

	WINGAME2_l("1contre100", "", "start.exe", "00541c08177b6d55a3df893bcfccc843", 2764454,
								 "main.dxr",  "c2bf555f6209e51a1c8cce29c8e6534f", 43315121, Common::FR_FRA, 1010),

	// Found on AOL 9.0 promo CD
	// Game description is based on desktop shortcut after installation
	WINGAME2("aolstarwars", "", "STARWARS.EXE", 		"bcf64185ce848b7b70858d62945f48a8", 25472412,
								"VID/TEASER_LARGE.WMV", "11b13d01a656d34a19d01247747478a4", 16763648, 1010),

	// Windows version is D8.5
	// External movies in the 'ME' folder are aliased to ':Cassic OS:ME' (sic)
	MACGAME1("artmarcopatrito", "", "The Art.osx", "2dbd6c69e359896c0291101c93b0dc03", 303895, 1000),

	MACGAME1("babarcoins", "", "Mac.osx",		"a171b7a952d1ac68ae3cd419d6dfc674", 309249, 1010),
	WINGAME2("babarcoins", "", "Start.exe",		"b198e9bf56c679747e4fd0972d5ba7b7", 2659300,
							   "ba-01_A01.dxr", "cb38821091082aeb097e88551b791e05", 9946435, 1010),

	// See notes in D6 entry
	MACGAME1("checkersvillage", "OS X", "village.osx", "f991fbe24bc002a215fda2c58fbb572f", 5880680, 1010),

	// Fine Gardening Propagation
	// Fine Gardening How-To-DVD-ROM series. Propagation Product#041036 FGDVDROM7-2'*
	// Bugreport #13324
	WINGAME1("finegardening", "", "FG_Propagation.exe",  "f9d19112c3af1093bd291a535b1c6883", 126422, 1010),

	// German Win version is D9
	// Installer & uninstaller also use Director
	MACGAME1_l("garygadget5", "", "WillyRaumschiff OSX", "b7181d7af306a3d336e5cc70cc77c641", 318788, Common::DE_DEU, 1010),

	// CDs 03-05 are D8 for Mac and Windows
	// CD02 and CD13 are D8 for Windows and D10 for Mac
	// Several discs contain mini-games using Flash Player (v6,v7,v8)
	MACGAME1("girlsaloudbox", "CD02 No Good Advice",					"OSX",				   "666bfa2ee1ae12443ce06f5dd142502b", 331558, 1000),
	MACGAME1("girlsaloudbox", "CD06 Love Machine (Classic)",			"ECD.classic",		   "670b37815e4e3f61b7af77cc676a791c", 259405, 1000),
	MACGAME1("girlsaloudbox", "CD06 Love Machine (OS X)",				"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 309243, 1000),
	WINGAME2("girlsaloudbox", "CD06 Love Machine",						"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 8376442,
																		"GirlsAloud.mov",	   "1b689c2002aa2397fde706f197aa11d1", 47282498, 1000),
	MACGAME1("girlsaloudbox", "CD07 I'll Stand By You (Classic)",		"ECD.classic",		   "670b37815e4e3f61b7af77cc676a791c", 260404, 1000),
	MACGAME1("girlsaloudbox", "CD07 I'll Stand By You (OS X)",			"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 310246, 1000),
	WINGAME2("girlsaloudbox", "CD07 I'll Stand By You",					"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 8830599,
																		"Stand Final.mov",	   "823208f98b99ba3a4987e3085dfd624f", 44262711, 1000),
	MACGAME1("girlsaloudbox", "CD08 Wake Me Up (Classic)",				"ECD.classic",		   "670b37815e4e3f61b7af77cc676a791c", 258001, 1000),
	MACGAME1("girlsaloudbox", "CD08 Wake Me Up (OS X)",					"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 307842, 1000),
	WINGAME2("girlsaloudbox", "CD08 Wake Me Up",						"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 7455567,
																		"Girls AloudWake.mov", "a70ba1e1e16cbf213a6155485533495e", 52371605, 1000),
	MACGAME1("girlsaloudbox", "CD09 Long Hot Summer (Classic)",			"Click Me os9",		   "08c9ea94f6469e71ae0c71987bbf6323", 205687, 1000),
	MACGAME1("girlsaloudbox", "CD09 Long Hot Summer (OS X)",			"Click Me.osx",		   "666bfa2ee1ae12443ce06f5dd142502b", 311946, 1000),
	WINGAME2("girlsaloudbox", "CD09 Long Hot Summer",					"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 9316487,
																		"SUMMER.DAT",		   "a56b212624c0a1742f6b579581c8384e", 118528, 1000),
	MACGAME1("girlsaloudbox", "CD10 Biology (Classic)",					"Click Me os9",		   "08c9ea94f6469e71ae0c71987bbf6323", 205856, 1000),
	MACGAME1("girlsaloudbox", "CD10 Biology (OS X)",					"Click Me.osx",		   "666bfa2ee1ae12443ce06f5dd142502b", 312115, 1000),
	WINGAME2("girlsaloudbox", "CD10 Biology",							"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 9348193,
																		"Biology.mp3",		   "3039a3d35b819e15c806b8e1c8d108f3", 904581, 1000),
	MACGAME1("girlsaloudbox", "CD11 See the Day (Classic)",				"Click Me os9",		   "08c9ea94f6469e71ae0c71987bbf6323", 189904, 1000),
	MACGAME1("girlsaloudbox", "CD11 See the Day (OS X)",				"Click Me.osx",		   "666bfa2ee1ae12443ce06f5dd142502b", 296163, 1000),
	WINGAME2("girlsaloudbox", "CD11 See the Day",						"START.EXE",		   "827e5af88f4c096652a1523dc28c9bf4", 7006606,
																		"TRACK.MP3",		   "7cc9e0f7e9257442490650f4cb747339", 4881282, 1000),
	MACGAME1("girlsaloudbox", "CD12 Whole Lotta History (Classic)",		"Click Me os9",		   "08c9ea94f6469e71ae0c71987bbf6323", 190669, 1000),
	MACGAME1("girlsaloudbox", "CD12 Whole Lotta History (OS X)",		"Click Me.osx",		   "666bfa2ee1ae12443ce06f5dd142502b", 296928, 1000),
	WINGAME2("girlsaloudbox", "CD12 Whole Lotta History",				"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 8680437,
																		"GIRLS ALOUD.mov",	   "0897d41deb1a044243238bb692933226", 58160086, 1000),
	MACGAME1("girlsaloudbox", "CD13 Something Kinda Ooooh (Classic)",	"Click Me os9",		   "08c9ea94f6469e71ae0c71987bbf6323", 191649, 1000),
	MACGAME1("girlsaloudbox", "CD13 Something Kinda Ooooh (OS X)",		"Click Me.osx",		   "666bfa2ee1ae12443ce06f5dd142502b", 297908, 1000),
	MACGAME1("girlsaloudbox", "CD14 I Think We're Alone Now (Classic)",	"ECD.classic",		   "670b37815e4e3f61b7af77cc676a791c", 248015, 1000),
	MACGAME1("girlsaloudbox", "CD14 I Think We're Alone Now (OS X)",	"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 297853, 1000),
	WINGAME2("girlsaloudbox", "CD14 I Think We're Alone Now",			"START.EXE",		   "827e5af88f4c096652a1523dc28c9bf4", 5480254,
																		"girls.mov",		   "055c7cdf5708c24861e8e9d856e7a4b3", 58248141, 1000),
	MACGAME1("girlsaloudbox", "CD15 Walk This Way (Classic)",			"ECD.classic",		   "670b37815e4e3f61b7af77cc676a791c", 242326, 1000),
	MACGAME1("girlsaloudbox", "CD15 Walk This Way (OS X)",				"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 292174, 1000),
	WINGAME2("girlsaloudbox", "CD15 Walk This Way",						"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 5405872,
																		"walk.mov",			   "546eb2b6de937674e47d20ad406e4ad3", 49937425, 1000),
	MACGAME1("girlsaloudbox", "CD16 Sexy! No No No ... (Classic)",		"ECD.classic",		   "670b37815e4e3f61b7af77cc676a791c", 257648, 1000),
	MACGAME1("girlsaloudbox", "CD16 Sexy! No No No ... (OS X)",			"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 307486, 1000),
	WINGAME2("girlsaloudbox", "CD16 Sexy! No No No ...",				"start.exe",		   "827e5af88f4c096652a1523dc28c9bf4", 7730270,
																		"Girls.mov",		   "9148a343290835d87dc297bb10d13c78", 52424731, 1000),
	MACGAME1("girlsaloudbox", "CD17 Call the Shots (Classic)",			"ECD.classic",		   "670b37815e4e3f61b7af77cc676a791c", 256127, 1000),
	MACGAME1("girlsaloudbox", "CD17 Call the Shots (OS X)",				"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 305965, 1000),
	WINGAME2("girlsaloudbox", "CD17 Call the Shots",					"START.EXE",		   "827e5af88f4c096652a1523dc28c9bf4", 6006160,
																		"Girls.mov",		   "b16ea946f4e3096eb2485345fe8899c9", 59580337, 1000),
	MACGAME1("girlsaloudbox", "CD18 Can't Speak French (Classic)",		"ECD.classic",		   "670b37815e4e3f61b7af77cc676a791c", 258680, 1000),
	MACGAME1("girlsaloudbox", "CD18 Can't Speak French (OS X)",			"ECD.osx",			   "666bfa2ee1ae12443ce06f5dd142502b", 308520, 1000),
	WINGAME2("girlsaloudbox", "CD18 Can't Speak French",				"START.EXE",		   "827e5af88f4c096652a1523dc28c9bf4", 8080898,
																		"french.mov",		   "b64f3b5aaa44dcd3037f01d4f687e072", 53929555, 1000),

	WINGAME2("jsworldp", "",		 "LearnGameLaunch.exe", "7c71b8b5f156d1ee56ca0f9624dec827", 4627915,
									 "LevelData.utd",		"093b8127750b4762ede83231b3085a46", 81284, 1000),
	WINGAME2("jsworldk", "",		 "LearnGameLaunch.exe", "7c71b8b5f156d1ee56ca0f9624dec827", 4627885,
									 "LevelData.utd",		"961040b538e8e70affbc54d152de9207", 756700, 1000),
	WINGAME2("jsworld1", "v1.0.4.0", "LearnGameLaunch.exe", "7c71b8b5f156d1ee56ca0f9624dec827", 4627885,
									 "LevelData.utd",		"b87a40b62d5f239f6424203bbb35cc4c", 767880, 1000),
	WINGAME2("jsworld1", "v1.0.7.0", "LearnGameLaunch.exe", "7c71b8b5f156d1ee56ca0f9624dec827", 4627885,
									 "LevelData.utd",		"04e96ad6119b400c861c188a50d846df", 767904, 1000),
	WINGAME2("jsworld1t", "",		 "TeacherPanel.exe",	"bcf64185ce848b7b70858d62945f48a8", 3142911,
									 "TeacherHub.dcr",		"d6b0f959196e656d50c1f6cbf16e1041", 270405, 1000),
	WINGAME2("jsworld2", "",		 "LearnGameLaunch.exe", "7c71b8b5f156d1ee56ca0f9624dec827", 4627885,
									 "LevelData.utd",		"5b504423963c8c6a09713f8ba96e100f", 976888, 1000),
	WINGAME2("jsworld2t", "",		 "TeacherPanel.exe",	"bcf64185ce848b7b70858d62945f48a8", 3142911,
									 "TeacherHub.dcr",		"95a9c2e05fac3181cafc22da932dae2a", 270371, 1000),

	// Original filename is Límit 0.exe
	// Requires installation from D8 app limit0inici
	// Selection of Spanish, Catalan, English at start
	WINGAME1("limit0", "", "Limit 0.exe", "827e5af88f4c096652a1523dc28c9bf4", 4664824, 1000),

	WINGAME1t_l("loewe1", "", "Loewe1.exe", "854989b2e1f7b9d55988ca1387859da2", 96316, Common::DE_DEU, 1010),

	// Found on Bonjour تعليم الفرنسية
	// Software catalogue for Middle East Software Company of Giza, Egypt
	WINGAME1_l("mesoftware", "", "MES.exe", "bcf64185ce848b7b70858d62945f48a8", 3560318, Common::AR_ARB, 1010),

	MACGAME1("miamath", "OS X", "MiaOSX", "666bfa2ee1ae12443ce06f5dd142502b", 53741, 1000),
	WINGAME1("miamath", "", "MiaMath.exe", "0c25e89b5084b272f0eab7827b6e411a", 2671820, 1000),

	// Requires installation
	// Pingu 2: Pret op de zuidpool
	//  {"data1.hdr", "868d25f9dc920d792bf982a5ddec4995", 13555},
	//  {"data1.cab", "1dc04d85f0450a9bc3c287c4872f05e5", 480005},
	//  {"data2.cab", "123bd61e8e5ddcc18a1c9893a064ccd2", 2849027},
	WINGAME1t_l("pingu2", "", "Pingu.exe", "363d974c5fb230311628ea3f36fbdead", 2765844, Common::NL_NLD, 1010),

	MACGAME1_l("pixeline8", "Classic", "Pixeline (Classic)",	"9f46cf3fafcf6bfe5ec9a04303cabf3c", 211958, Common::DA_DNK, 1010),
	MACGAME1_l("pixeline8", "", "Pixeline og Kong Gulerod", 	"b5d3018832a36c7314a8daeebc5f16b0", 281297, Common::DA_DNK, 1010),
	WINGAME1_l("pixeline8", "", "Pixeline og Kong Gulerod.exe",	"2f4cf44dd0b636a83c93997a620069b7", 3062430, Common::DA_DNK, 1010),

	// Found on AOL 9.0 trial CD
	WINGAME1("seinfeldondvd", "", "SEINFELD.EXE", "827e5af88f4c096652a1523dc28c9bf4", 3572626, 1000),

	// Time-limited shareware release from BeachWare Inc. Unlock full game with registration code.
	// http://web.archive.org/web/20140629224457/http://www.beachware.com/download/ShellWhirl/ShellWhirl.dmg
	// http://web.archive.org/web/20070207233900/http://www.beachware.com/download/ShellWhirl/ShellWhirlSetup.exe
	MACGAME1("shellwhirl", "", "Shell Whirl", "a171b7a952d1ac68ae3cd419d6dfc674", 313545, 1010),
	WINGAME1("shellwhirl", "", "Shell Whirl.exe", "bcf64185ce848b7b70858d62945f48a8", 3779090, 1010),

	// Players for newer OSes, available here:
	// http://www.sinkha.com/dfiles/players/HY_MOSX1.zip
	// http://www.sinkha.com/dfiles/players/ATM_MOSX1.zip
	MACGAME2("sinkha1", "OS X 10.1-10.4", "START.osx",	"5af79c7672a0db0bc2ddacb9dee4d86c", 3121400,
										  "ME/MAA.cxt", "3f79a60e8f8a884f67855a5c1f0e66b5", 835098, 1000),
	MACGAME2("sinkha2", "OS X 10.1-10.4", "START.osx",	"5af79c7672a0db0bc2ddacb9dee4d86c", 3121400,
										  "ME/MAA.cxt", "26f7dcd7a5690910f2116205f54cb44b", 759494, 1000),

	// 2006 remaster originally released on GameTap, also released on Steam
	WINGAME1t("spelunx", "", "Spelunx.exe", "965e31ec421fa6dfe8ea157ef38ebd42", 2800981, 1010),

	WINDEMO1_l("tokimemotypegs", "Demo", "tkmkgstype.exe", "1d1646000633ab994404ac38fb350553", 2716404, Common::JA_JPN, 1000),

//////////////////////////////////////////////////
//
// Adobe Director v11
//
//////////////////////////////////////////////////

	WINGAME1("mentalmaths", "", "Mental Maths.exe", "b162d633891f0ab2e2fc6ba6164df337", 5017068, 1100),

	WINGAME1_l("pixelineskolevik", "", "Pixeline - Vikingerne.exe",	"5a8596277cab40345b3266dce3b54c1a", 2816536, Common::DA_DNK, 1100),
	WINGAME1_l("pixelineskolevik", "", "Pixeline - Vikingerne.exe",	"b162d633891f0ab2e2fc6ba6164df337", 5909524, Common::DA_DNK, 1100),
	// Win executable on Mac partition
	WINGAME1t_l("pixelineskolevik", "", "Pixeline - Vikingerne.exe", "52d593de1aae5db1f2ef1c503af20833", 7568472, Common::DA_DNK, 1100),

	// Players for newer OSes, available here:
	// http://www.sinkha.com/dfiles/players/HY_MOSX2.zip
	// http://www.sinkha.com/dfiles/players/HY_WIN2.zip
	MACGAME2("sinkha1", "OS X 10.4-10.5", "START.app/Contents/MacOS/start", "f74a89f3d1d3d7fe55df0fa3c8c125a3", 68550,
										  "ME/MAA.cxt",						"3f79a60e8f8a884f67855a5c1f0e66b5", 835098, 1100),
	WINGAME2("sinkha1", "XP SP2 - Vista", "START_(Win_XP_sp2-Vista).exe",   "3d6ccc7532d94fa518988e9685e45ba9", 4355622,
										  "ME/MAA.cxt",						"3f79a60e8f8a884f67855a5c1f0e66b5", 835098, 1100),

	// http://www.sinkha.com/dfiles/players/ATM_MOSX2.zip
	// http://www.sinkha.com/dfiles/players/ATM_WIN2.zip
	MACGAME2("sinkha2", "OS X 10.4-10.5", "START.app/Contents/MacOS/start", "f74a89f3d1d3d7fe55df0fa3c8c125a3", 68550,
										  "ME/MAA.cxt",						"26f7dcd7a5690910f2116205f54cb44b", 759494, 1100),
	WINGAME2("sinkha2", "XP SP2 - Vista", "START_(Win_XP_sp2-Vista).exe",   "3d6ccc7532d94fa518988e9685e45ba9", 4355622,
										  "ME/MAA.cxt",						"26f7dcd7a5690910f2116205f54cb44b", 759494, 1100),

	{ AD_TABLE_END_MARKER, GID_GENERIC, 0 }

};

} // End of namespace Director

#endif
