/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.forkjoin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.concurrent.forkjoin.ForkJoinWorkerThread;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ForkJoinTask<V>
implements Future<V>,
Serializable {
    volatile int status;
    static final Map<ForkJoinTask<?>, Throwable> exceptionMap = Collections.synchronizedMap(new WeakHashMap());
    private static final long serialVersionUID = -7721805057305804111L;
    static final Unsafe _unsafe;
    static final long statusOffset;

    static ForkJoinWorkerThread getWorker() {
        Thread t = Thread.currentThread();
        return t instanceof ForkJoinWorkerThread ? (ForkJoinWorkerThread)t : null;
    }

    final boolean casStatus(int cmp, int val) {
        return _unsafe.compareAndSwapInt(this, statusOffset, cmp, val);
    }

    static void rethrowException(Throwable ex) {
        if (ex != null) {
            _unsafe.throwException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCompletion(int completion) {
        ForkJoinPool pool = ForkJoinTask.getPool();
        if (pool != null) {
            int s;
            while ((s = this.status) >= 0 && !this.casStatus(s, completion)) {
            }
            if ((s & 0xFFFF) != 0) {
                if ((s &= Short.MAX_VALUE) != 0) {
                    pool.updateRunningCount(s);
                }
                ForkJoinTask forkJoinTask = this;
                synchronized (forkJoinTask) {
                    this.notifyAll();
                }
            }
        } else {
            this.externallySetCompletion(completion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void externallySetCompletion(int completion) {
        int s;
        while ((s = this.status) >= 0 && !this.casStatus(s, s & 0xFFFF | completion)) {
        }
        ForkJoinTask forkJoinTask = this;
        synchronized (forkJoinTask) {
            this.notifyAll();
        }
    }

    final void setNormalCompletion() {
        if (!_unsafe.compareAndSwapInt(this, statusOffset, 0, -536870912)) {
            this.setCompletion(-536870912);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doAwaitDone() {
        try {
            while (this.status >= 0) {
                ForkJoinTask forkJoinTask = this;
                synchronized (forkJoinTask) {
                    if (this.status >= 0) {
                        this.wait();
                    }
                }
            }
            return;
        }
        catch (InterruptedException ie) {
            this.onInterruptedWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAwaitDone(long startTime, long nanos) {
        ForkJoinTask forkJoinTask = this;
        synchronized (forkJoinTask) {
            try {
                long nt;
                while (this.status >= 0 && (nt = nanos - System.nanoTime() - startTime) > 0L) {
                    this.wait(nt / 1000000L, (int)(nt % 1000000L));
                }
            }
            catch (InterruptedException ie) {
                this.onInterruptedWait();
            }
        }
    }

    private int awaitDone(ForkJoinWorkerThread w, boolean maintainParallelism) {
        int s;
        ForkJoinPool pool;
        ForkJoinPool forkJoinPool = pool = w == null ? null : w.pool;
        while ((s = this.status) >= 0) {
            if (!this.casStatus(s, pool == null ? s | 0x8000 : s + 1)) continue;
            if (pool == null || !pool.preJoin(this, maintainParallelism)) {
                this.doAwaitDone();
            }
            if (((s = this.status) & Short.MAX_VALUE) == 0) break;
            this.adjustPoolCountsOnUnblock(pool);
            break;
        }
        return s;
    }

    private int awaitDone(ForkJoinWorkerThread w, long nanos) {
        int s;
        ForkJoinPool pool;
        ForkJoinPool forkJoinPool = pool = w == null ? null : w.pool;
        while ((s = this.status) >= 0) {
            if (!this.casStatus(s, pool == null ? s | 0x8000 : s + 1)) continue;
            long startTime = System.nanoTime();
            if (pool == null || !pool.preJoin(this, false)) {
                this.doAwaitDone(startTime, nanos);
            }
            if ((s = this.status) >= 0) {
                this.adjustPoolCountsOnCancelledWait(pool);
                s = this.status;
            }
            if (s >= 0 || (s & Short.MAX_VALUE) == 0) break;
            this.adjustPoolCountsOnUnblock(pool);
            break;
        }
        return s;
    }

    private void adjustPoolCountsOnUnblock(ForkJoinPool pool) {
        int s;
        while ((s = this.status) < 0 && !this.casStatus(s, s & 0xE0000000)) {
        }
        if (pool != null && (s &= Short.MAX_VALUE) != 0) {
            pool.updateRunningCount(s);
        }
    }

    private void adjustPoolCountsOnCancelledWait(ForkJoinPool pool) {
        if (pool != null) {
            int s;
            while ((s = this.status) >= 0 && (s & Short.MAX_VALUE) != 0) {
                if (!this.casStatus(s, s - 1)) continue;
                pool.updateRunningCount(1);
                break;
            }
        }
    }

    private void onInterruptedWait() {
        ForkJoinWorkerThread w = ForkJoinTask.getWorker();
        if (w == null) {
            Thread.currentThread().interrupt();
        } else if (w.isTerminating()) {
            this.cancelIgnoringExceptions();
        }
    }

    private void setDoneExceptionally(Throwable rex) {
        exceptionMap.put(this, rex);
        this.setCompletion(-1610612736);
    }

    private void reportException(int s) {
        if ((s &= 0xE0000000) < -536870912) {
            if (s == -1073741824) {
                throw new CancellationException();
            }
            ForkJoinTask.rethrowException(exceptionMap.get(this));
        }
    }

    private V reportFutureResult() throws ExecutionException, InterruptedException {
        int s = this.status & 0xE0000000;
        if (s < -536870912) {
            Throwable ex;
            if (s == -1073741824) {
                throw new CancellationException();
            }
            if (s == -1610612736 && (ex = exceptionMap.get(this)) != null) {
                throw new ExecutionException(ex);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }
        return this.getRawResult();
    }

    private V reportTimedFutureResult() throws InterruptedException, ExecutionException, TimeoutException {
        Throwable ex;
        int s = this.status & 0xE0000000;
        if (s == -536870912) {
            return this.getRawResult();
        }
        if (s == -1073741824) {
            throw new CancellationException();
        }
        if (s == -1610612736 && (ex = exceptionMap.get(this)) != null) {
            throw new ExecutionException(ex);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        throw new TimeoutException();
    }

    private boolean tryExec() {
        try {
            if (!this.exec()) {
                return false;
            }
        }
        catch (Throwable rex) {
            this.setDoneExceptionally(rex);
            ForkJoinTask.rethrowException(rex);
            return false;
        }
        this.setNormalCompletion();
        return true;
    }

    final void quietlyExec() {
        if (this.status >= 0) {
            try {
                if (!this.exec()) {
                    return;
                }
            }
            catch (Throwable rex) {
                this.setDoneExceptionally(rex);
                return;
            }
            this.setNormalCompletion();
        }
    }

    private boolean tryQuietlyInvoke() {
        try {
            if (!this.exec()) {
                return false;
            }
        }
        catch (Throwable rex) {
            this.setDoneExceptionally(rex);
            return false;
        }
        this.setNormalCompletion();
        return true;
    }

    final void cancelIgnoringExceptions() {
        try {
            this.cancel(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void fork() {
        ((ForkJoinWorkerThread)Thread.currentThread()).pushTask(this);
    }

    public final V join() {
        ForkJoinWorkerThread w = ForkJoinTask.getWorker();
        if (w == null || this.status < 0 || !w.unpushTask(this) || !this.tryExec()) {
            this.reportException(this.awaitDone(w, true));
        }
        return this.getRawResult();
    }

    public final V invoke() {
        if (this.status >= 0 && this.tryExec()) {
            return this.getRawResult();
        }
        return this.join();
    }

    @Override
    public final boolean isDone() {
        return this.status < 0;
    }

    @Override
    public final boolean isCancelled() {
        return (this.status & 0xE0000000) == -1073741824;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.setCompletion(-1073741824);
        return (this.status & 0xE0000000) == -1073741824;
    }

    public final Throwable getException() {
        int s = this.status & 0xE0000000;
        if (s >= -536870912) {
            return null;
        }
        if (s == -1073741824) {
            return new CancellationException();
        }
        return exceptionMap.get(this);
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        ForkJoinWorkerThread w = ForkJoinTask.getWorker();
        if (w == null || this.status < 0 || !w.unpushTask(this) || !this.tryQuietlyInvoke()) {
            this.awaitDone(w, true);
        }
        return this.reportFutureResult();
    }

    @Override
    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ForkJoinWorkerThread w = ForkJoinTask.getWorker();
        if (w == null || this.status < 0 || !w.unpushTask(this) || !this.tryQuietlyInvoke()) {
            this.awaitDone(w, unit.toNanos(timeout));
        }
        return this.reportTimedFutureResult();
    }

    public static ForkJoinPool getPool() {
        Thread t = Thread.currentThread();
        return t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).pool : null;
    }

    public abstract V getRawResult();

    protected abstract boolean exec();

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.getException());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.status &= Short.MIN_VALUE;
        this.status |= 0x8000;
        Object ex = s.readObject();
        if (ex != null) {
            this.setDoneExceptionally((Throwable)ex);
        }
    }

    private static Unsafe getUnsafe() throws Throwable {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        return ForkJoinTask.getUnsafePrivileged();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getCause();
            }
        }
    }

    private static Unsafe getUnsafePrivileged() throws NoSuchFieldException, IllegalAccessException {
        Field field = Unsafe.class.getDeclaredField("theUnsafe");
        field.setAccessible(true);
        return (Unsafe)field.get(null);
    }

    private static long fieldOffset(String string) throws NoSuchFieldException {
        return _unsafe.objectFieldOffset(ForkJoinTask.class.getDeclaredField(string));
    }

    static {
        try {
            _unsafe = ForkJoinTask.getUnsafe();
            statusOffset = ForkJoinTask.fieldOffset("status");
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not initialize intrinsics", e);
        }
    }
}

