/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.Iterator;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.HashEntry;
import scala.collection.mutable.HashTable;
import scala.collection.mutable.HashTable$;
import scala.runtime.BoxesRunTime;

public abstract class HashTable$class {
    public static void $init$(HashTable $this) {
        $this.table_$eq($this.initialSize() == 0 ? null : new HashEntry[$this.initialSize()]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq($this.initialThreshold());
    }

    public static final int index(HashTable $this, int hcode) {
        return $this.improve(hcode) & $this.table().length - 1;
    }

    public static final int improve(HashTable $this, int hcode) {
        int h = hcode + ~(hcode << 9);
        h ^= h >>> 14;
        h += h << 4;
        return h ^ h >>> 10;
    }

    public static int elemHashCode(HashTable $this, Object key) {
        return key.hashCode();
    }

    public static boolean elemEquals(HashTable $this, Object key1, Object key2) {
        return BoxesRunTime.equals(key1, key2);
    }

    private static void resize(HashTable $this, int newSize) {
        HashEntry<A, HashEntry<A, E>>[] oldTable = $this.table();
        $this.table_$eq(new HashEntry[newSize]);
        block0: for (int i = oldTable.length - 1; i >= 0; --i) {
            HashEntry e = oldTable[i];
            while (true) {
                HashEntry hashEntry;
                if ((hashEntry = e) == null || hashEntry.equals(null)) {
                    continue block0;
                }
                int h = $this.index($this.elemHashCode(e.key()));
                HashEntry e1 = e.next();
                e.next_$eq($this.table()[h]);
                $this.table()[h] = e;
                e = e1;
            }
        }
        $this.threshold_$eq(HashTable$class.newThreshold($this, newSize));
    }

    private static int newThreshold(HashTable $this, int size2) {
        return (int)((long)size2 * (long)$this.loadFactor() / 1000L);
    }

    public static void clear(HashTable $this) {
        for (int i = $this.table().length - 1; i >= 0; --i) {
            $this.table()[i] = null;
        }
        $this.tableSize_$eq(0);
    }

    public static Iterator entries(HashTable $this) {
        return new HashTable$.anon.1($this);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Option removeEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry hashEntry = $this.table()[h];
        HashEntry hashEntry2 = hashEntry;
        if (hashEntry2 == null || hashEntry2.equals(null)) return None$.MODULE$;
        if ($this.elemEquals(hashEntry.key(), key)) {
            $this.table()[h] = hashEntry.next();
            $this.tableSize_$eq($this.tableSize() - 1);
            return new Some(hashEntry);
        }
        HashEntry e1 = hashEntry.next();
        while (true) {
            HashEntry hashEntry3;
            if ((hashEntry3 = e1) == null || hashEntry3.equals(null) || $this.elemEquals(e1.key(), key)) {
                void var3_4;
                HashEntry hashEntry4 = e1;
                if (hashEntry4 == null || hashEntry4.equals(null)) {
                    return None$.MODULE$;
                }
                var3_4.next_$eq(e1.next());
                $this.tableSize_$eq($this.tableSize() - 1);
                return new Some<HashEntry>(e1);
            }
            HashEntry hashEntry5 = e1;
            e1 = (HashEntry)e1.next();
        }
    }

    public static void addEntry(HashTable $this, HashEntry e) {
        int h = $this.index($this.elemHashCode(e.key()));
        e.next_$eq($this.table()[h]);
        $this.table()[h] = e;
        $this.tableSize_$eq($this.tableSize() + 1);
        if ($this.tableSize() > $this.threshold()) {
            HashTable$class.resize($this, 2 * $this.table().length);
        }
    }

    public static HashEntry findEntry(HashTable $this, Object key) {
        int h = $this.index($this.elemHashCode(key));
        HashEntry e = $this.table()[h];
        HashEntry hashEntry;
        while ((hashEntry = e) != null && !hashEntry.equals(null) && !$this.elemEquals(e.key(), key)) {
            e = e.next();
        }
        return e;
    }

    public static int size(HashTable $this) {
        return $this.tableSize();
    }

    public static int initialThreshold(HashTable $this) {
        return HashTable$class.newThreshold($this, $this.initialSize());
    }

    public static int initialSize(HashTable $this) {
        return 16;
    }

    public static int loadFactor(HashTable $this) {
        return 750;
    }
}

