/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import jline.Completor;

public class SimpleCompletor
implements Completor,
Cloneable {
    SortedSet candidates;
    String delimiter;
    final SimpleCompletorFilter filter;

    public SimpleCompletor(String candidateString) {
        this(new String[]{candidateString});
    }

    public SimpleCompletor(String[] candidateStrings) {
        this(candidateStrings, null);
    }

    public SimpleCompletor(String[] strings, SimpleCompletorFilter filter) {
        this.filter = filter;
        this.setCandidateStrings(strings);
    }

    public SimpleCompletor(Reader reader) throws IOException {
        this(SimpleCompletor.getStrings(reader));
    }

    public SimpleCompletor(InputStream in) throws IOException {
        this(SimpleCompletor.getStrings(new InputStreamReader(in)));
    }

    private static String[] getStrings(Reader in) throws IOException {
        String line;
        Reader reader = in instanceof BufferedReader ? in : new BufferedReader(in);
        LinkedList<String> words = new LinkedList<String>();
        while ((line = ((BufferedReader)reader).readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line);
            while (tok.hasMoreTokens()) {
                words.add(tok.nextToken());
            }
        }
        return words.toArray(new String[words.size()]);
    }

    public int complete(String buffer, int cursor, List clist) {
        String can;
        String start = buffer == null ? "" : buffer;
        SortedSet<String> matches2 = this.candidates.tailSet(start);
        Iterator i = matches2.iterator();
        while (i.hasNext() && (can = (String)i.next()).startsWith(start)) {
            int index;
            if (this.delimiter != null && (index = can.indexOf(this.delimiter, cursor)) != -1) {
                can = can.substring(0, index + 1);
            }
            clist.add(can);
        }
        if (clist.size() == 1) {
            clist.set(0, (String)clist.get(0) + " ");
        }
        return clist.size() == 0 ? -1 : 0;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setCandidates(SortedSet candidates2) {
        if (this.filter != null) {
            TreeSet<String> filtered = new TreeSet<String>();
            Iterator i = candidates2.iterator();
            while (i.hasNext()) {
                String element = (String)i.next();
                if ((element = this.filter.filter(element)) == null) continue;
                filtered.add(element);
            }
            this.candidates = filtered;
        } else {
            this.candidates = candidates2;
        }
    }

    public SortedSet getCandidates() {
        return Collections.unmodifiableSortedSet(this.candidates);
    }

    public void setCandidateStrings(String[] strings) {
        this.setCandidates(new TreeSet<String>(Arrays.asList(strings)));
    }

    public void addCandidateString(String candidateString) {
        String string;
        String string2 = string = this.filter == null ? candidateString : this.filter.filter(candidateString);
        if (string != null) {
            this.candidates.add(string);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class NoOpFilter
    implements SimpleCompletorFilter {
        public String filter(String element) {
            return element;
        }
    }

    public static interface SimpleCompletorFilter {
        public String filter(String var1);
    }
}

