/******************************************************************************/
/* This file is generated by the bin/template script and should not be        */
/* modified manually. See                                                     */
/* templates/src/node.c.erb                                                   */
/* if you are looking to modify the                                           */
/* template                                                                   */
/******************************************************************************/
#line 2 "node.c.erb"
#include "yarp/node.h"

// Clear the node but preserves the location.
void yp_node_clear(yp_node_t *node) {
    yp_location_t location = node->location;
    memset(node, 0, sizeof(yp_node_t));
    node->location = location;
}

// Calculate the size of the token list in bytes.
static size_t
yp_location_list_memsize(yp_location_list_t *list) {
    return sizeof(yp_location_list_t) + (list->capacity * sizeof(yp_location_t));
}

// Append a token to the given list.
void
yp_location_list_append(yp_location_list_t *list, const yp_token_t *token) {
    if (list->size == list->capacity) {
        list->capacity = list->capacity == 0 ? 2 : list->capacity * 2;
        list->locations = (yp_location_t *) realloc(list->locations, sizeof(yp_location_t) * list->capacity);
    }
    list->locations[list->size++] = (yp_location_t) { .start = token->start, .end = token->end };
}

// Free the memory associated with the token list.
static void
yp_location_list_free(yp_location_list_t *list) {
    if (list->locations != NULL) {
        free(list->locations);
    }
}

static void
yp_node_memsize_node(yp_node_t *node, yp_memsize_t *memsize);

// Calculate the size of the node list in bytes.
static size_t
yp_node_list_memsize(yp_node_list_t *node_list, yp_memsize_t *memsize) {
    size_t size = sizeof(yp_node_list_t) + (node_list->capacity * sizeof(yp_node_t *));
    for (size_t index = 0; index < node_list->size; index++) {
        yp_node_memsize_node(node_list->nodes[index], memsize);
    }
    return size;
}

// Append a new node onto the end of the node list.
void
yp_node_list_append(yp_node_list_t *list, yp_node_t *node) {
    if (list->size == list->capacity) {
        list->capacity = list->capacity == 0 ? 4 : list->capacity * 2;
        list->nodes = (yp_node_t **) realloc(list->nodes, sizeof(yp_node_t *) * list->capacity);
    }
    list->nodes[list->size++] = node;
}

YP_EXPORTED_FUNCTION void
yp_node_destroy(yp_parser_t *parser, yp_node_t *node);

// Deallocate the inner memory of a list of nodes. The parser argument is not
// used, but is here for the future possibility of pre-allocating memory pools.
static void
yp_node_list_free(yp_parser_t *parser, yp_node_list_t *list) {
    if (list->capacity > 0) {
        for (size_t index = 0; index < list->size; index++) {
            yp_node_destroy(parser, list->nodes[index]);
        }
        free(list->nodes);
    }
}

// Deallocate the space for a yp_node_t. Similarly to yp_node_alloc, we're not
// using the parser argument, but it's there to allow for the future possibility
// of pre-allocating larger memory pools.
YP_EXPORTED_FUNCTION void
yp_node_destroy(yp_parser_t *parser, yp_node_t *node) {
    switch (node->type) {
#line 81 "node.c.erb"
        case YP_NODE_ALIAS_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_alias_node_t *)node)->new_name);
            yp_node_destroy(parser, (yp_node_t *)((yp_alias_node_t *)node)->old_name);
            break;
#line 81 "node.c.erb"
        case YP_NODE_ALTERNATION_PATTERN_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_alternation_pattern_node_t *)node)->left);
            yp_node_destroy(parser, (yp_node_t *)((yp_alternation_pattern_node_t *)node)->right);
            break;
#line 81 "node.c.erb"
        case YP_NODE_AND_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_and_node_t *)node)->left);
            yp_node_destroy(parser, (yp_node_t *)((yp_and_node_t *)node)->right);
            break;
#line 81 "node.c.erb"
        case YP_NODE_ARGUMENTS_NODE:
            yp_node_list_free(parser, &((yp_arguments_node_t *)node)->arguments);
            break;
#line 81 "node.c.erb"
        case YP_NODE_ARRAY_NODE:
            yp_node_list_free(parser, &((yp_array_node_t *)node)->elements);
            break;
#line 81 "node.c.erb"
        case YP_NODE_ARRAY_PATTERN_NODE:
            if (((yp_array_pattern_node_t *)node)->constant != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_array_pattern_node_t *)node)->constant);
            }
            yp_node_list_free(parser, &((yp_array_pattern_node_t *)node)->requireds);
            if (((yp_array_pattern_node_t *)node)->rest != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_array_pattern_node_t *)node)->rest);
            }
            yp_node_list_free(parser, &((yp_array_pattern_node_t *)node)->posts);
            break;
#line 81 "node.c.erb"
        case YP_NODE_ASSOC_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_assoc_node_t *)node)->key);
            if (((yp_assoc_node_t *)node)->value != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_assoc_node_t *)node)->value);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_ASSOC_SPLAT_NODE:
            if (((yp_assoc_splat_node_t *)node)->value != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_assoc_splat_node_t *)node)->value);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_BACK_REFERENCE_READ_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_BEGIN_NODE:
            if (((yp_begin_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_begin_node_t *)node)->statements);
            }
            if (((yp_begin_node_t *)node)->rescue_clause != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_begin_node_t *)node)->rescue_clause);
            }
            if (((yp_begin_node_t *)node)->else_clause != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_begin_node_t *)node)->else_clause);
            }
            if (((yp_begin_node_t *)node)->ensure_clause != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_begin_node_t *)node)->ensure_clause);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_BLOCK_ARGUMENT_NODE:
            if (((yp_block_argument_node_t *)node)->expression != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_block_argument_node_t *)node)->expression);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_BLOCK_NODE:
            yp_constant_id_list_free(&((yp_block_node_t *)node)->locals);
            if (((yp_block_node_t *)node)->parameters != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_block_node_t *)node)->parameters);
            }
            if (((yp_block_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_block_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_BLOCK_PARAMETER_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_BLOCK_PARAMETERS_NODE:
            if (((yp_block_parameters_node_t *)node)->parameters != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_block_parameters_node_t *)node)->parameters);
            }
            yp_location_list_free(&((yp_block_parameters_node_t *)node)->locals);
            break;
#line 81 "node.c.erb"
        case YP_NODE_BREAK_NODE:
            if (((yp_break_node_t *)node)->arguments != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_break_node_t *)node)->arguments);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_CALL_NODE:
            if (((yp_call_node_t *)node)->receiver != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_call_node_t *)node)->receiver);
            }
            if (((yp_call_node_t *)node)->arguments != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_call_node_t *)node)->arguments);
            }
            if (((yp_call_node_t *)node)->block != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_call_node_t *)node)->block);
            }
            yp_string_free(&((yp_call_node_t *)node)->name);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CALL_OPERATOR_AND_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_call_operator_and_write_node_t *)node)->target);
            yp_node_destroy(parser, (yp_node_t *)((yp_call_operator_and_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CALL_OPERATOR_OR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_call_operator_or_write_node_t *)node)->target);
            yp_node_destroy(parser, (yp_node_t *)((yp_call_operator_or_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CALL_OPERATOR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_call_operator_write_node_t *)node)->target);
            yp_node_destroy(parser, (yp_node_t *)((yp_call_operator_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CAPTURE_PATTERN_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_capture_pattern_node_t *)node)->value);
            yp_node_destroy(parser, (yp_node_t *)((yp_capture_pattern_node_t *)node)->target);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CASE_NODE:
            if (((yp_case_node_t *)node)->predicate != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_case_node_t *)node)->predicate);
            }
            yp_node_list_free(parser, &((yp_case_node_t *)node)->conditions);
            if (((yp_case_node_t *)node)->consequent != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_case_node_t *)node)->consequent);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_CLASS_NODE:
            yp_constant_id_list_free(&((yp_class_node_t *)node)->locals);
            yp_node_destroy(parser, (yp_node_t *)((yp_class_node_t *)node)->constant_path);
            if (((yp_class_node_t *)node)->superclass != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_class_node_t *)node)->superclass);
            }
            if (((yp_class_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_class_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_CLASS_VARIABLE_OPERATOR_AND_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_class_variable_operator_and_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CLASS_VARIABLE_OPERATOR_OR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_class_variable_operator_or_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CLASS_VARIABLE_OPERATOR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_class_variable_operator_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CLASS_VARIABLE_READ_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_CLASS_VARIABLE_WRITE_NODE:
            if (((yp_class_variable_write_node_t *)node)->value != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_class_variable_write_node_t *)node)->value);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_CONSTANT_OPERATOR_AND_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_constant_operator_and_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CONSTANT_OPERATOR_OR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_constant_operator_or_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CONSTANT_OPERATOR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_constant_operator_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CONSTANT_PATH_NODE:
            if (((yp_constant_path_node_t *)node)->parent != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_constant_path_node_t *)node)->parent);
            }
            yp_node_destroy(parser, (yp_node_t *)((yp_constant_path_node_t *)node)->child);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CONSTANT_PATH_OPERATOR_AND_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_constant_path_operator_and_write_node_t *)node)->target);
            yp_node_destroy(parser, (yp_node_t *)((yp_constant_path_operator_and_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CONSTANT_PATH_OPERATOR_OR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_constant_path_operator_or_write_node_t *)node)->target);
            yp_node_destroy(parser, (yp_node_t *)((yp_constant_path_operator_or_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CONSTANT_PATH_OPERATOR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_constant_path_operator_write_node_t *)node)->target);
            yp_node_destroy(parser, (yp_node_t *)((yp_constant_path_operator_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_CONSTANT_PATH_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_constant_path_write_node_t *)node)->target);
            if (((yp_constant_path_write_node_t *)node)->value != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_constant_path_write_node_t *)node)->value);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_CONSTANT_READ_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_DEF_NODE:
            if (((yp_def_node_t *)node)->receiver != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_def_node_t *)node)->receiver);
            }
            if (((yp_def_node_t *)node)->parameters != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_def_node_t *)node)->parameters);
            }
            if (((yp_def_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_def_node_t *)node)->statements);
            }
            yp_constant_id_list_free(&((yp_def_node_t *)node)->locals);
            break;
#line 81 "node.c.erb"
        case YP_NODE_DEFINED_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_defined_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_ELSE_NODE:
            if (((yp_else_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_else_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_EMBEDDED_STATEMENTS_NODE:
            if (((yp_embedded_statements_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_embedded_statements_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_EMBEDDED_VARIABLE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_embedded_variable_node_t *)node)->variable);
            break;
#line 81 "node.c.erb"
        case YP_NODE_ENSURE_NODE:
            if (((yp_ensure_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_ensure_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_FALSE_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_FIND_PATTERN_NODE:
            if (((yp_find_pattern_node_t *)node)->constant != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_find_pattern_node_t *)node)->constant);
            }
            yp_node_destroy(parser, (yp_node_t *)((yp_find_pattern_node_t *)node)->left);
            yp_node_list_free(parser, &((yp_find_pattern_node_t *)node)->requireds);
            yp_node_destroy(parser, (yp_node_t *)((yp_find_pattern_node_t *)node)->right);
            break;
#line 81 "node.c.erb"
        case YP_NODE_FLOAT_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_FOR_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_for_node_t *)node)->index);
            yp_node_destroy(parser, (yp_node_t *)((yp_for_node_t *)node)->collection);
            if (((yp_for_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_for_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_FORWARDING_ARGUMENTS_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_FORWARDING_PARAMETER_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_FORWARDING_SUPER_NODE:
            if (((yp_forwarding_super_node_t *)node)->block != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_forwarding_super_node_t *)node)->block);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_GLOBAL_VARIABLE_OPERATOR_AND_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_global_variable_operator_and_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_GLOBAL_VARIABLE_OPERATOR_OR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_global_variable_operator_or_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_GLOBAL_VARIABLE_OPERATOR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_global_variable_operator_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_GLOBAL_VARIABLE_READ_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_GLOBAL_VARIABLE_WRITE_NODE:
            if (((yp_global_variable_write_node_t *)node)->value != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_global_variable_write_node_t *)node)->value);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_HASH_NODE:
            yp_node_list_free(parser, &((yp_hash_node_t *)node)->elements);
            break;
#line 81 "node.c.erb"
        case YP_NODE_HASH_PATTERN_NODE:
            if (((yp_hash_pattern_node_t *)node)->constant != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_hash_pattern_node_t *)node)->constant);
            }
            yp_node_list_free(parser, &((yp_hash_pattern_node_t *)node)->assocs);
            if (((yp_hash_pattern_node_t *)node)->kwrest != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_hash_pattern_node_t *)node)->kwrest);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_IF_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_if_node_t *)node)->predicate);
            if (((yp_if_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_if_node_t *)node)->statements);
            }
            if (((yp_if_node_t *)node)->consequent != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_if_node_t *)node)->consequent);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_IMAGINARY_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_imaginary_node_t *)node)->numeric);
            break;
#line 81 "node.c.erb"
        case YP_NODE_IN_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_in_node_t *)node)->pattern);
            if (((yp_in_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_in_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_INSTANCE_VARIABLE_OPERATOR_AND_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_instance_variable_operator_and_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_INSTANCE_VARIABLE_OPERATOR_OR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_instance_variable_operator_or_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_INSTANCE_VARIABLE_OPERATOR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_instance_variable_operator_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_INSTANCE_VARIABLE_READ_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_INSTANCE_VARIABLE_WRITE_NODE:
            if (((yp_instance_variable_write_node_t *)node)->value != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_instance_variable_write_node_t *)node)->value);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_INTEGER_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_INTERPOLATED_REGULAR_EXPRESSION_NODE:
            yp_node_list_free(parser, &((yp_interpolated_regular_expression_node_t *)node)->parts);
            break;
#line 81 "node.c.erb"
        case YP_NODE_INTERPOLATED_STRING_NODE:
            yp_node_list_free(parser, &((yp_interpolated_string_node_t *)node)->parts);
            break;
#line 81 "node.c.erb"
        case YP_NODE_INTERPOLATED_SYMBOL_NODE:
            yp_node_list_free(parser, &((yp_interpolated_symbol_node_t *)node)->parts);
            break;
#line 81 "node.c.erb"
        case YP_NODE_INTERPOLATED_X_STRING_NODE:
            yp_node_list_free(parser, &((yp_interpolated_x_string_node_t *)node)->parts);
            break;
#line 81 "node.c.erb"
        case YP_NODE_KEYWORD_HASH_NODE:
            yp_node_list_free(parser, &((yp_keyword_hash_node_t *)node)->elements);
            break;
#line 81 "node.c.erb"
        case YP_NODE_KEYWORD_PARAMETER_NODE:
            if (((yp_keyword_parameter_node_t *)node)->value != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_keyword_parameter_node_t *)node)->value);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_KEYWORD_REST_PARAMETER_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_LAMBDA_NODE:
            yp_constant_id_list_free(&((yp_lambda_node_t *)node)->locals);
            if (((yp_lambda_node_t *)node)->parameters != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_lambda_node_t *)node)->parameters);
            }
            if (((yp_lambda_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_lambda_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_LOCAL_VARIABLE_OPERATOR_AND_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_local_variable_operator_and_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_LOCAL_VARIABLE_OPERATOR_OR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_local_variable_operator_or_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_LOCAL_VARIABLE_OPERATOR_WRITE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_local_variable_operator_write_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_LOCAL_VARIABLE_READ_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_LOCAL_VARIABLE_WRITE_NODE:
            if (((yp_local_variable_write_node_t *)node)->value != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_local_variable_write_node_t *)node)->value);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_MATCH_PREDICATE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_match_predicate_node_t *)node)->value);
            yp_node_destroy(parser, (yp_node_t *)((yp_match_predicate_node_t *)node)->pattern);
            break;
#line 81 "node.c.erb"
        case YP_NODE_MATCH_REQUIRED_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_match_required_node_t *)node)->value);
            yp_node_destroy(parser, (yp_node_t *)((yp_match_required_node_t *)node)->pattern);
            break;
#line 81 "node.c.erb"
        case YP_NODE_MISSING_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_MODULE_NODE:
            yp_constant_id_list_free(&((yp_module_node_t *)node)->locals);
            yp_node_destroy(parser, (yp_node_t *)((yp_module_node_t *)node)->constant_path);
            if (((yp_module_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_module_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_MULTI_WRITE_NODE:
            yp_node_list_free(parser, &((yp_multi_write_node_t *)node)->targets);
            if (((yp_multi_write_node_t *)node)->value != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_multi_write_node_t *)node)->value);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_NEXT_NODE:
            if (((yp_next_node_t *)node)->arguments != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_next_node_t *)node)->arguments);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_NIL_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_NO_KEYWORDS_PARAMETER_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_NUMBERED_REFERENCE_READ_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_OPTIONAL_PARAMETER_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_optional_parameter_node_t *)node)->value);
            break;
#line 81 "node.c.erb"
        case YP_NODE_OR_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_or_node_t *)node)->left);
            yp_node_destroy(parser, (yp_node_t *)((yp_or_node_t *)node)->right);
            break;
#line 81 "node.c.erb"
        case YP_NODE_PARAMETERS_NODE:
            yp_node_list_free(parser, &((yp_parameters_node_t *)node)->requireds);
            yp_node_list_free(parser, &((yp_parameters_node_t *)node)->optionals);
            yp_node_list_free(parser, &((yp_parameters_node_t *)node)->posts);
            if (((yp_parameters_node_t *)node)->rest != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_parameters_node_t *)node)->rest);
            }
            yp_node_list_free(parser, &((yp_parameters_node_t *)node)->keywords);
            if (((yp_parameters_node_t *)node)->keyword_rest != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_parameters_node_t *)node)->keyword_rest);
            }
            if (((yp_parameters_node_t *)node)->block != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_parameters_node_t *)node)->block);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_PARENTHESES_NODE:
            if (((yp_parentheses_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_parentheses_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_PINNED_EXPRESSION_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_pinned_expression_node_t *)node)->expression);
            break;
#line 81 "node.c.erb"
        case YP_NODE_PINNED_VARIABLE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_pinned_variable_node_t *)node)->variable);
            break;
#line 81 "node.c.erb"
        case YP_NODE_POST_EXECUTION_NODE:
            if (((yp_post_execution_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_post_execution_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_PRE_EXECUTION_NODE:
            if (((yp_pre_execution_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_pre_execution_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_PROGRAM_NODE:
            yp_constant_id_list_free(&((yp_program_node_t *)node)->locals);
            yp_node_destroy(parser, (yp_node_t *)((yp_program_node_t *)node)->statements);
            break;
#line 81 "node.c.erb"
        case YP_NODE_RANGE_NODE:
            if (((yp_range_node_t *)node)->left != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_range_node_t *)node)->left);
            }
            if (((yp_range_node_t *)node)->right != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_range_node_t *)node)->right);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_RATIONAL_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_rational_node_t *)node)->numeric);
            break;
#line 81 "node.c.erb"
        case YP_NODE_REDO_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_REGULAR_EXPRESSION_NODE:
            yp_string_free(&((yp_regular_expression_node_t *)node)->unescaped);
            break;
#line 81 "node.c.erb"
        case YP_NODE_REQUIRED_DESTRUCTURED_PARAMETER_NODE:
            yp_node_list_free(parser, &((yp_required_destructured_parameter_node_t *)node)->parameters);
            break;
#line 81 "node.c.erb"
        case YP_NODE_REQUIRED_PARAMETER_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_RESCUE_MODIFIER_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_rescue_modifier_node_t *)node)->expression);
            yp_node_destroy(parser, (yp_node_t *)((yp_rescue_modifier_node_t *)node)->rescue_expression);
            break;
#line 81 "node.c.erb"
        case YP_NODE_RESCUE_NODE:
            yp_node_list_free(parser, &((yp_rescue_node_t *)node)->exceptions);
            if (((yp_rescue_node_t *)node)->exception != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_rescue_node_t *)node)->exception);
            }
            if (((yp_rescue_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_rescue_node_t *)node)->statements);
            }
            if (((yp_rescue_node_t *)node)->consequent != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_rescue_node_t *)node)->consequent);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_REST_PARAMETER_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_RETRY_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_RETURN_NODE:
            if (((yp_return_node_t *)node)->arguments != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_return_node_t *)node)->arguments);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_SELF_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_SINGLETON_CLASS_NODE:
            yp_constant_id_list_free(&((yp_singleton_class_node_t *)node)->locals);
            yp_node_destroy(parser, (yp_node_t *)((yp_singleton_class_node_t *)node)->expression);
            if (((yp_singleton_class_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_singleton_class_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_SOURCE_ENCODING_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_SOURCE_FILE_NODE:
            yp_string_free(&((yp_source_file_node_t *)node)->filepath);
            break;
#line 81 "node.c.erb"
        case YP_NODE_SOURCE_LINE_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_SPLAT_NODE:
            if (((yp_splat_node_t *)node)->expression != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_splat_node_t *)node)->expression);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_STATEMENTS_NODE:
            yp_node_list_free(parser, &((yp_statements_node_t *)node)->body);
            break;
#line 81 "node.c.erb"
        case YP_NODE_STRING_CONCAT_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_string_concat_node_t *)node)->left);
            yp_node_destroy(parser, (yp_node_t *)((yp_string_concat_node_t *)node)->right);
            break;
#line 81 "node.c.erb"
        case YP_NODE_STRING_NODE:
            yp_string_free(&((yp_string_node_t *)node)->unescaped);
            break;
#line 81 "node.c.erb"
        case YP_NODE_SUPER_NODE:
            if (((yp_super_node_t *)node)->arguments != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_super_node_t *)node)->arguments);
            }
            if (((yp_super_node_t *)node)->block != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_super_node_t *)node)->block);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_SYMBOL_NODE:
            yp_string_free(&((yp_symbol_node_t *)node)->unescaped);
            break;
#line 81 "node.c.erb"
        case YP_NODE_TRUE_NODE:
            break;
#line 81 "node.c.erb"
        case YP_NODE_UNDEF_NODE:
            yp_node_list_free(parser, &((yp_undef_node_t *)node)->names);
            break;
#line 81 "node.c.erb"
        case YP_NODE_UNLESS_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_unless_node_t *)node)->predicate);
            if (((yp_unless_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_unless_node_t *)node)->statements);
            }
            if (((yp_unless_node_t *)node)->consequent != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_unless_node_t *)node)->consequent);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_UNTIL_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_until_node_t *)node)->predicate);
            if (((yp_until_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_until_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_WHEN_NODE:
            yp_node_list_free(parser, &((yp_when_node_t *)node)->conditions);
            if (((yp_when_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_when_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_WHILE_NODE:
            yp_node_destroy(parser, (yp_node_t *)((yp_while_node_t *)node)->predicate);
            if (((yp_while_node_t *)node)->statements != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_while_node_t *)node)->statements);
            }
            break;
#line 81 "node.c.erb"
        case YP_NODE_X_STRING_NODE:
            yp_string_free(&((yp_x_string_node_t *)node)->unescaped);
            break;
#line 81 "node.c.erb"
        case YP_NODE_YIELD_NODE:
            if (((yp_yield_node_t *)node)->arguments != NULL) {
                yp_node_destroy(parser, (yp_node_t *)((yp_yield_node_t *)node)->arguments);
            }
            break;
#line 106 "node.c.erb"
        default:
            assert(false && "unreachable");
            break;
    }
    free(node);
}

static void
yp_node_memsize_node(yp_node_t *node, yp_memsize_t *memsize) {
    memsize->node_count++;

    switch (node->type) {
#line 120 "node.c.erb"
        case YP_NODE_ALIAS_NODE: {
            memsize->memsize += sizeof(yp_alias_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_alias_node_t *)node)->new_name, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_alias_node_t *)node)->old_name, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_ALTERNATION_PATTERN_NODE: {
            memsize->memsize += sizeof(yp_alternation_pattern_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_alternation_pattern_node_t *)node)->left, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_alternation_pattern_node_t *)node)->right, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_AND_NODE: {
            memsize->memsize += sizeof(yp_and_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_and_node_t *)node)->left, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_and_node_t *)node)->right, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_ARGUMENTS_NODE: {
            memsize->memsize += sizeof(yp_arguments_node_t);
            yp_node_list_memsize(&((yp_arguments_node_t *)node)->arguments, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_ARRAY_NODE: {
            memsize->memsize += sizeof(yp_array_node_t);
            yp_node_list_memsize(&((yp_array_node_t *)node)->elements, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_ARRAY_PATTERN_NODE: {
            memsize->memsize += sizeof(yp_array_pattern_node_t);
            if (((yp_array_pattern_node_t *)node)->constant != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_array_pattern_node_t *)node)->constant, memsize);
            }
            yp_node_list_memsize(&((yp_array_pattern_node_t *)node)->requireds, memsize);
            if (((yp_array_pattern_node_t *)node)->rest != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_array_pattern_node_t *)node)->rest, memsize);
            }
            yp_node_list_memsize(&((yp_array_pattern_node_t *)node)->posts, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_ASSOC_NODE: {
            memsize->memsize += sizeof(yp_assoc_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_assoc_node_t *)node)->key, memsize);
            if (((yp_assoc_node_t *)node)->value != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_assoc_node_t *)node)->value, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_ASSOC_SPLAT_NODE: {
            memsize->memsize += sizeof(yp_assoc_splat_node_t);
            if (((yp_assoc_splat_node_t *)node)->value != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_assoc_splat_node_t *)node)->value, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_BACK_REFERENCE_READ_NODE: {
            memsize->memsize += sizeof(yp_back_reference_read_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_BEGIN_NODE: {
            memsize->memsize += sizeof(yp_begin_node_t);
            if (((yp_begin_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_begin_node_t *)node)->statements, memsize);
            }
            if (((yp_begin_node_t *)node)->rescue_clause != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_begin_node_t *)node)->rescue_clause, memsize);
            }
            if (((yp_begin_node_t *)node)->else_clause != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_begin_node_t *)node)->else_clause, memsize);
            }
            if (((yp_begin_node_t *)node)->ensure_clause != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_begin_node_t *)node)->ensure_clause, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_BLOCK_ARGUMENT_NODE: {
            memsize->memsize += sizeof(yp_block_argument_node_t);
            if (((yp_block_argument_node_t *)node)->expression != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_block_argument_node_t *)node)->expression, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_BLOCK_NODE: {
            memsize->memsize += sizeof(yp_block_node_t);
            memsize->memsize += yp_constant_id_list_memsize(&((yp_block_node_t *)node)->locals);
            if (((yp_block_node_t *)node)->parameters != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_block_node_t *)node)->parameters, memsize);
            }
            if (((yp_block_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_block_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_BLOCK_PARAMETER_NODE: {
            memsize->memsize += sizeof(yp_block_parameter_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_BLOCK_PARAMETERS_NODE: {
            memsize->memsize += sizeof(yp_block_parameters_node_t);
            if (((yp_block_parameters_node_t *)node)->parameters != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_block_parameters_node_t *)node)->parameters, memsize);
            }
            memsize->memsize += yp_location_list_memsize(&((yp_block_parameters_node_t *)node)->locals);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_BREAK_NODE: {
            memsize->memsize += sizeof(yp_break_node_t);
            if (((yp_break_node_t *)node)->arguments != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_break_node_t *)node)->arguments, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CALL_NODE: {
            memsize->memsize += sizeof(yp_call_node_t);
            if (((yp_call_node_t *)node)->receiver != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_call_node_t *)node)->receiver, memsize);
            }
            if (((yp_call_node_t *)node)->arguments != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_call_node_t *)node)->arguments, memsize);
            }
            if (((yp_call_node_t *)node)->block != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_call_node_t *)node)->block, memsize);
            }
            memsize->memsize += yp_string_memsize(&((yp_call_node_t *)node)->name);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CALL_OPERATOR_AND_WRITE_NODE: {
            memsize->memsize += sizeof(yp_call_operator_and_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_call_operator_and_write_node_t *)node)->target, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_call_operator_and_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CALL_OPERATOR_OR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_call_operator_or_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_call_operator_or_write_node_t *)node)->target, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_call_operator_or_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CALL_OPERATOR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_call_operator_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_call_operator_write_node_t *)node)->target, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_call_operator_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CAPTURE_PATTERN_NODE: {
            memsize->memsize += sizeof(yp_capture_pattern_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_capture_pattern_node_t *)node)->value, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_capture_pattern_node_t *)node)->target, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CASE_NODE: {
            memsize->memsize += sizeof(yp_case_node_t);
            if (((yp_case_node_t *)node)->predicate != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_case_node_t *)node)->predicate, memsize);
            }
            yp_node_list_memsize(&((yp_case_node_t *)node)->conditions, memsize);
            if (((yp_case_node_t *)node)->consequent != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_case_node_t *)node)->consequent, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CLASS_NODE: {
            memsize->memsize += sizeof(yp_class_node_t);
            memsize->memsize += yp_constant_id_list_memsize(&((yp_class_node_t *)node)->locals);
            yp_node_memsize_node((yp_node_t *)((yp_class_node_t *)node)->constant_path, memsize);
            if (((yp_class_node_t *)node)->superclass != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_class_node_t *)node)->superclass, memsize);
            }
            if (((yp_class_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_class_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CLASS_VARIABLE_OPERATOR_AND_WRITE_NODE: {
            memsize->memsize += sizeof(yp_class_variable_operator_and_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_class_variable_operator_and_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CLASS_VARIABLE_OPERATOR_OR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_class_variable_operator_or_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_class_variable_operator_or_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CLASS_VARIABLE_OPERATOR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_class_variable_operator_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_class_variable_operator_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CLASS_VARIABLE_READ_NODE: {
            memsize->memsize += sizeof(yp_class_variable_read_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CLASS_VARIABLE_WRITE_NODE: {
            memsize->memsize += sizeof(yp_class_variable_write_node_t);
            if (((yp_class_variable_write_node_t *)node)->value != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_class_variable_write_node_t *)node)->value, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CONSTANT_OPERATOR_AND_WRITE_NODE: {
            memsize->memsize += sizeof(yp_constant_operator_and_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_constant_operator_and_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CONSTANT_OPERATOR_OR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_constant_operator_or_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_constant_operator_or_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CONSTANT_OPERATOR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_constant_operator_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_constant_operator_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CONSTANT_PATH_NODE: {
            memsize->memsize += sizeof(yp_constant_path_node_t);
            if (((yp_constant_path_node_t *)node)->parent != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_constant_path_node_t *)node)->parent, memsize);
            }
            yp_node_memsize_node((yp_node_t *)((yp_constant_path_node_t *)node)->child, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CONSTANT_PATH_OPERATOR_AND_WRITE_NODE: {
            memsize->memsize += sizeof(yp_constant_path_operator_and_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_constant_path_operator_and_write_node_t *)node)->target, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_constant_path_operator_and_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CONSTANT_PATH_OPERATOR_OR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_constant_path_operator_or_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_constant_path_operator_or_write_node_t *)node)->target, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_constant_path_operator_or_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CONSTANT_PATH_OPERATOR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_constant_path_operator_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_constant_path_operator_write_node_t *)node)->target, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_constant_path_operator_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CONSTANT_PATH_WRITE_NODE: {
            memsize->memsize += sizeof(yp_constant_path_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_constant_path_write_node_t *)node)->target, memsize);
            if (((yp_constant_path_write_node_t *)node)->value != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_constant_path_write_node_t *)node)->value, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_CONSTANT_READ_NODE: {
            memsize->memsize += sizeof(yp_constant_read_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_DEF_NODE: {
            memsize->memsize += sizeof(yp_def_node_t);
            if (((yp_def_node_t *)node)->receiver != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_def_node_t *)node)->receiver, memsize);
            }
            if (((yp_def_node_t *)node)->parameters != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_def_node_t *)node)->parameters, memsize);
            }
            if (((yp_def_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_def_node_t *)node)->statements, memsize);
            }
            memsize->memsize += yp_constant_id_list_memsize(&((yp_def_node_t *)node)->locals);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_DEFINED_NODE: {
            memsize->memsize += sizeof(yp_defined_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_defined_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_ELSE_NODE: {
            memsize->memsize += sizeof(yp_else_node_t);
            if (((yp_else_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_else_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_EMBEDDED_STATEMENTS_NODE: {
            memsize->memsize += sizeof(yp_embedded_statements_node_t);
            if (((yp_embedded_statements_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_embedded_statements_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_EMBEDDED_VARIABLE_NODE: {
            memsize->memsize += sizeof(yp_embedded_variable_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_embedded_variable_node_t *)node)->variable, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_ENSURE_NODE: {
            memsize->memsize += sizeof(yp_ensure_node_t);
            if (((yp_ensure_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_ensure_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_FALSE_NODE: {
            memsize->memsize += sizeof(yp_false_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_FIND_PATTERN_NODE: {
            memsize->memsize += sizeof(yp_find_pattern_node_t);
            if (((yp_find_pattern_node_t *)node)->constant != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_find_pattern_node_t *)node)->constant, memsize);
            }
            yp_node_memsize_node((yp_node_t *)((yp_find_pattern_node_t *)node)->left, memsize);
            yp_node_list_memsize(&((yp_find_pattern_node_t *)node)->requireds, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_find_pattern_node_t *)node)->right, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_FLOAT_NODE: {
            memsize->memsize += sizeof(yp_float_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_FOR_NODE: {
            memsize->memsize += sizeof(yp_for_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_for_node_t *)node)->index, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_for_node_t *)node)->collection, memsize);
            if (((yp_for_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_for_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_FORWARDING_ARGUMENTS_NODE: {
            memsize->memsize += sizeof(yp_forwarding_arguments_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_FORWARDING_PARAMETER_NODE: {
            memsize->memsize += sizeof(yp_forwarding_parameter_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_FORWARDING_SUPER_NODE: {
            memsize->memsize += sizeof(yp_forwarding_super_node_t);
            if (((yp_forwarding_super_node_t *)node)->block != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_forwarding_super_node_t *)node)->block, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_GLOBAL_VARIABLE_OPERATOR_AND_WRITE_NODE: {
            memsize->memsize += sizeof(yp_global_variable_operator_and_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_global_variable_operator_and_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_GLOBAL_VARIABLE_OPERATOR_OR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_global_variable_operator_or_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_global_variable_operator_or_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_GLOBAL_VARIABLE_OPERATOR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_global_variable_operator_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_global_variable_operator_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_GLOBAL_VARIABLE_READ_NODE: {
            memsize->memsize += sizeof(yp_global_variable_read_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_GLOBAL_VARIABLE_WRITE_NODE: {
            memsize->memsize += sizeof(yp_global_variable_write_node_t);
            if (((yp_global_variable_write_node_t *)node)->value != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_global_variable_write_node_t *)node)->value, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_HASH_NODE: {
            memsize->memsize += sizeof(yp_hash_node_t);
            yp_node_list_memsize(&((yp_hash_node_t *)node)->elements, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_HASH_PATTERN_NODE: {
            memsize->memsize += sizeof(yp_hash_pattern_node_t);
            if (((yp_hash_pattern_node_t *)node)->constant != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_hash_pattern_node_t *)node)->constant, memsize);
            }
            yp_node_list_memsize(&((yp_hash_pattern_node_t *)node)->assocs, memsize);
            if (((yp_hash_pattern_node_t *)node)->kwrest != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_hash_pattern_node_t *)node)->kwrest, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_IF_NODE: {
            memsize->memsize += sizeof(yp_if_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_if_node_t *)node)->predicate, memsize);
            if (((yp_if_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_if_node_t *)node)->statements, memsize);
            }
            if (((yp_if_node_t *)node)->consequent != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_if_node_t *)node)->consequent, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_IMAGINARY_NODE: {
            memsize->memsize += sizeof(yp_imaginary_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_imaginary_node_t *)node)->numeric, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_IN_NODE: {
            memsize->memsize += sizeof(yp_in_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_in_node_t *)node)->pattern, memsize);
            if (((yp_in_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_in_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_INSTANCE_VARIABLE_OPERATOR_AND_WRITE_NODE: {
            memsize->memsize += sizeof(yp_instance_variable_operator_and_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_instance_variable_operator_and_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_INSTANCE_VARIABLE_OPERATOR_OR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_instance_variable_operator_or_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_instance_variable_operator_or_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_INSTANCE_VARIABLE_OPERATOR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_instance_variable_operator_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_instance_variable_operator_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_INSTANCE_VARIABLE_READ_NODE: {
            memsize->memsize += sizeof(yp_instance_variable_read_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_INSTANCE_VARIABLE_WRITE_NODE: {
            memsize->memsize += sizeof(yp_instance_variable_write_node_t);
            if (((yp_instance_variable_write_node_t *)node)->value != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_instance_variable_write_node_t *)node)->value, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_INTEGER_NODE: {
            memsize->memsize += sizeof(yp_integer_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_INTERPOLATED_REGULAR_EXPRESSION_NODE: {
            memsize->memsize += sizeof(yp_interpolated_regular_expression_node_t);
            yp_node_list_memsize(&((yp_interpolated_regular_expression_node_t *)node)->parts, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_INTERPOLATED_STRING_NODE: {
            memsize->memsize += sizeof(yp_interpolated_string_node_t);
            yp_node_list_memsize(&((yp_interpolated_string_node_t *)node)->parts, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_INTERPOLATED_SYMBOL_NODE: {
            memsize->memsize += sizeof(yp_interpolated_symbol_node_t);
            yp_node_list_memsize(&((yp_interpolated_symbol_node_t *)node)->parts, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_INTERPOLATED_X_STRING_NODE: {
            memsize->memsize += sizeof(yp_interpolated_x_string_node_t);
            yp_node_list_memsize(&((yp_interpolated_x_string_node_t *)node)->parts, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_KEYWORD_HASH_NODE: {
            memsize->memsize += sizeof(yp_keyword_hash_node_t);
            yp_node_list_memsize(&((yp_keyword_hash_node_t *)node)->elements, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_KEYWORD_PARAMETER_NODE: {
            memsize->memsize += sizeof(yp_keyword_parameter_node_t);
            if (((yp_keyword_parameter_node_t *)node)->value != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_keyword_parameter_node_t *)node)->value, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_KEYWORD_REST_PARAMETER_NODE: {
            memsize->memsize += sizeof(yp_keyword_rest_parameter_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_LAMBDA_NODE: {
            memsize->memsize += sizeof(yp_lambda_node_t);
            memsize->memsize += yp_constant_id_list_memsize(&((yp_lambda_node_t *)node)->locals);
            if (((yp_lambda_node_t *)node)->parameters != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_lambda_node_t *)node)->parameters, memsize);
            }
            if (((yp_lambda_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_lambda_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_LOCAL_VARIABLE_OPERATOR_AND_WRITE_NODE: {
            memsize->memsize += sizeof(yp_local_variable_operator_and_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_local_variable_operator_and_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_LOCAL_VARIABLE_OPERATOR_OR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_local_variable_operator_or_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_local_variable_operator_or_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_LOCAL_VARIABLE_OPERATOR_WRITE_NODE: {
            memsize->memsize += sizeof(yp_local_variable_operator_write_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_local_variable_operator_write_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_LOCAL_VARIABLE_READ_NODE: {
            memsize->memsize += sizeof(yp_local_variable_read_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_LOCAL_VARIABLE_WRITE_NODE: {
            memsize->memsize += sizeof(yp_local_variable_write_node_t);
            if (((yp_local_variable_write_node_t *)node)->value != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_local_variable_write_node_t *)node)->value, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_MATCH_PREDICATE_NODE: {
            memsize->memsize += sizeof(yp_match_predicate_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_match_predicate_node_t *)node)->value, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_match_predicate_node_t *)node)->pattern, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_MATCH_REQUIRED_NODE: {
            memsize->memsize += sizeof(yp_match_required_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_match_required_node_t *)node)->value, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_match_required_node_t *)node)->pattern, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_MISSING_NODE: {
            memsize->memsize += sizeof(yp_missing_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_MODULE_NODE: {
            memsize->memsize += sizeof(yp_module_node_t);
            memsize->memsize += yp_constant_id_list_memsize(&((yp_module_node_t *)node)->locals);
            yp_node_memsize_node((yp_node_t *)((yp_module_node_t *)node)->constant_path, memsize);
            if (((yp_module_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_module_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_MULTI_WRITE_NODE: {
            memsize->memsize += sizeof(yp_multi_write_node_t);
            yp_node_list_memsize(&((yp_multi_write_node_t *)node)->targets, memsize);
            if (((yp_multi_write_node_t *)node)->value != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_multi_write_node_t *)node)->value, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_NEXT_NODE: {
            memsize->memsize += sizeof(yp_next_node_t);
            if (((yp_next_node_t *)node)->arguments != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_next_node_t *)node)->arguments, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_NIL_NODE: {
            memsize->memsize += sizeof(yp_nil_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_NO_KEYWORDS_PARAMETER_NODE: {
            memsize->memsize += sizeof(yp_no_keywords_parameter_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_NUMBERED_REFERENCE_READ_NODE: {
            memsize->memsize += sizeof(yp_numbered_reference_read_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_OPTIONAL_PARAMETER_NODE: {
            memsize->memsize += sizeof(yp_optional_parameter_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_optional_parameter_node_t *)node)->value, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_OR_NODE: {
            memsize->memsize += sizeof(yp_or_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_or_node_t *)node)->left, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_or_node_t *)node)->right, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_PARAMETERS_NODE: {
            memsize->memsize += sizeof(yp_parameters_node_t);
            yp_node_list_memsize(&((yp_parameters_node_t *)node)->requireds, memsize);
            yp_node_list_memsize(&((yp_parameters_node_t *)node)->optionals, memsize);
            yp_node_list_memsize(&((yp_parameters_node_t *)node)->posts, memsize);
            if (((yp_parameters_node_t *)node)->rest != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_parameters_node_t *)node)->rest, memsize);
            }
            yp_node_list_memsize(&((yp_parameters_node_t *)node)->keywords, memsize);
            if (((yp_parameters_node_t *)node)->keyword_rest != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_parameters_node_t *)node)->keyword_rest, memsize);
            }
            if (((yp_parameters_node_t *)node)->block != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_parameters_node_t *)node)->block, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_PARENTHESES_NODE: {
            memsize->memsize += sizeof(yp_parentheses_node_t);
            if (((yp_parentheses_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_parentheses_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_PINNED_EXPRESSION_NODE: {
            memsize->memsize += sizeof(yp_pinned_expression_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_pinned_expression_node_t *)node)->expression, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_PINNED_VARIABLE_NODE: {
            memsize->memsize += sizeof(yp_pinned_variable_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_pinned_variable_node_t *)node)->variable, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_POST_EXECUTION_NODE: {
            memsize->memsize += sizeof(yp_post_execution_node_t);
            if (((yp_post_execution_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_post_execution_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_PRE_EXECUTION_NODE: {
            memsize->memsize += sizeof(yp_pre_execution_node_t);
            if (((yp_pre_execution_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_pre_execution_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_PROGRAM_NODE: {
            memsize->memsize += sizeof(yp_program_node_t);
            memsize->memsize += yp_constant_id_list_memsize(&((yp_program_node_t *)node)->locals);
            yp_node_memsize_node((yp_node_t *)((yp_program_node_t *)node)->statements, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_RANGE_NODE: {
            memsize->memsize += sizeof(yp_range_node_t);
            if (((yp_range_node_t *)node)->left != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_range_node_t *)node)->left, memsize);
            }
            if (((yp_range_node_t *)node)->right != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_range_node_t *)node)->right, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_RATIONAL_NODE: {
            memsize->memsize += sizeof(yp_rational_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_rational_node_t *)node)->numeric, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_REDO_NODE: {
            memsize->memsize += sizeof(yp_redo_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_REGULAR_EXPRESSION_NODE: {
            memsize->memsize += sizeof(yp_regular_expression_node_t);
            memsize->memsize += yp_string_memsize(&((yp_regular_expression_node_t *)node)->unescaped);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_REQUIRED_DESTRUCTURED_PARAMETER_NODE: {
            memsize->memsize += sizeof(yp_required_destructured_parameter_node_t);
            yp_node_list_memsize(&((yp_required_destructured_parameter_node_t *)node)->parameters, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_REQUIRED_PARAMETER_NODE: {
            memsize->memsize += sizeof(yp_required_parameter_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_RESCUE_MODIFIER_NODE: {
            memsize->memsize += sizeof(yp_rescue_modifier_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_rescue_modifier_node_t *)node)->expression, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_rescue_modifier_node_t *)node)->rescue_expression, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_RESCUE_NODE: {
            memsize->memsize += sizeof(yp_rescue_node_t);
            yp_node_list_memsize(&((yp_rescue_node_t *)node)->exceptions, memsize);
            if (((yp_rescue_node_t *)node)->exception != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_rescue_node_t *)node)->exception, memsize);
            }
            if (((yp_rescue_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_rescue_node_t *)node)->statements, memsize);
            }
            if (((yp_rescue_node_t *)node)->consequent != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_rescue_node_t *)node)->consequent, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_REST_PARAMETER_NODE: {
            memsize->memsize += sizeof(yp_rest_parameter_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_RETRY_NODE: {
            memsize->memsize += sizeof(yp_retry_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_RETURN_NODE: {
            memsize->memsize += sizeof(yp_return_node_t);
            if (((yp_return_node_t *)node)->arguments != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_return_node_t *)node)->arguments, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_SELF_NODE: {
            memsize->memsize += sizeof(yp_self_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_SINGLETON_CLASS_NODE: {
            memsize->memsize += sizeof(yp_singleton_class_node_t);
            memsize->memsize += yp_constant_id_list_memsize(&((yp_singleton_class_node_t *)node)->locals);
            yp_node_memsize_node((yp_node_t *)((yp_singleton_class_node_t *)node)->expression, memsize);
            if (((yp_singleton_class_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_singleton_class_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_SOURCE_ENCODING_NODE: {
            memsize->memsize += sizeof(yp_source_encoding_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_SOURCE_FILE_NODE: {
            memsize->memsize += sizeof(yp_source_file_node_t);
            memsize->memsize += yp_string_memsize(&((yp_source_file_node_t *)node)->filepath);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_SOURCE_LINE_NODE: {
            memsize->memsize += sizeof(yp_source_line_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_SPLAT_NODE: {
            memsize->memsize += sizeof(yp_splat_node_t);
            if (((yp_splat_node_t *)node)->expression != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_splat_node_t *)node)->expression, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_STATEMENTS_NODE: {
            memsize->memsize += sizeof(yp_statements_node_t);
            yp_node_list_memsize(&((yp_statements_node_t *)node)->body, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_STRING_CONCAT_NODE: {
            memsize->memsize += sizeof(yp_string_concat_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_string_concat_node_t *)node)->left, memsize);
            yp_node_memsize_node((yp_node_t *)((yp_string_concat_node_t *)node)->right, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_STRING_NODE: {
            memsize->memsize += sizeof(yp_string_node_t);
            memsize->memsize += yp_string_memsize(&((yp_string_node_t *)node)->unescaped);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_SUPER_NODE: {
            memsize->memsize += sizeof(yp_super_node_t);
            if (((yp_super_node_t *)node)->arguments != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_super_node_t *)node)->arguments, memsize);
            }
            if (((yp_super_node_t *)node)->block != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_super_node_t *)node)->block, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_SYMBOL_NODE: {
            memsize->memsize += sizeof(yp_symbol_node_t);
            memsize->memsize += yp_string_memsize(&((yp_symbol_node_t *)node)->unescaped);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_TRUE_NODE: {
            memsize->memsize += sizeof(yp_true_node_t);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_UNDEF_NODE: {
            memsize->memsize += sizeof(yp_undef_node_t);
            yp_node_list_memsize(&((yp_undef_node_t *)node)->names, memsize);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_UNLESS_NODE: {
            memsize->memsize += sizeof(yp_unless_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_unless_node_t *)node)->predicate, memsize);
            if (((yp_unless_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_unless_node_t *)node)->statements, memsize);
            }
            if (((yp_unless_node_t *)node)->consequent != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_unless_node_t *)node)->consequent, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_UNTIL_NODE: {
            memsize->memsize += sizeof(yp_until_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_until_node_t *)node)->predicate, memsize);
            if (((yp_until_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_until_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_WHEN_NODE: {
            memsize->memsize += sizeof(yp_when_node_t);
            yp_node_list_memsize(&((yp_when_node_t *)node)->conditions, memsize);
            if (((yp_when_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_when_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_WHILE_NODE: {
            memsize->memsize += sizeof(yp_while_node_t);
            yp_node_memsize_node((yp_node_t *)((yp_while_node_t *)node)->predicate, memsize);
            if (((yp_while_node_t *)node)->statements != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_while_node_t *)node)->statements, memsize);
            }
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_X_STRING_NODE: {
            memsize->memsize += sizeof(yp_x_string_node_t);
            memsize->memsize += yp_string_memsize(&((yp_x_string_node_t *)node)->unescaped);
            break;
        }
#line 120 "node.c.erb"
        case YP_NODE_YIELD_NODE: {
            memsize->memsize += sizeof(yp_yield_node_t);
            if (((yp_yield_node_t *)node)->arguments != NULL) {
                yp_node_memsize_node((yp_node_t *)((yp_yield_node_t *)node)->arguments, memsize);
            }
            break;
        }
#line 147 "node.c.erb"
    }
}

// Calculates the memory footprint of a given node.
YP_EXPORTED_FUNCTION void
yp_node_memsize(yp_node_t *node, yp_memsize_t *memsize) {
    *memsize = (yp_memsize_t) { .memsize = 0, .node_count = 0 };
    yp_node_memsize_node(node, memsize);
}

// Returns a string representation of the given node type.
YP_EXPORTED_FUNCTION const char *
yp_node_type_to_str(yp_node_type_t node_type)
{
    switch (node_type) {
        case YP_NODE_ALIAS_NODE:
            return "YP_NODE_ALIAS_NODE";
        case YP_NODE_ALTERNATION_PATTERN_NODE:
            return "YP_NODE_ALTERNATION_PATTERN_NODE";
        case YP_NODE_AND_NODE:
            return "YP_NODE_AND_NODE";
        case YP_NODE_ARGUMENTS_NODE:
            return "YP_NODE_ARGUMENTS_NODE";
        case YP_NODE_ARRAY_NODE:
            return "YP_NODE_ARRAY_NODE";
        case YP_NODE_ARRAY_PATTERN_NODE:
            return "YP_NODE_ARRAY_PATTERN_NODE";
        case YP_NODE_ASSOC_NODE:
            return "YP_NODE_ASSOC_NODE";
        case YP_NODE_ASSOC_SPLAT_NODE:
            return "YP_NODE_ASSOC_SPLAT_NODE";
        case YP_NODE_BACK_REFERENCE_READ_NODE:
            return "YP_NODE_BACK_REFERENCE_READ_NODE";
        case YP_NODE_BEGIN_NODE:
            return "YP_NODE_BEGIN_NODE";
        case YP_NODE_BLOCK_ARGUMENT_NODE:
            return "YP_NODE_BLOCK_ARGUMENT_NODE";
        case YP_NODE_BLOCK_NODE:
            return "YP_NODE_BLOCK_NODE";
        case YP_NODE_BLOCK_PARAMETER_NODE:
            return "YP_NODE_BLOCK_PARAMETER_NODE";
        case YP_NODE_BLOCK_PARAMETERS_NODE:
            return "YP_NODE_BLOCK_PARAMETERS_NODE";
        case YP_NODE_BREAK_NODE:
            return "YP_NODE_BREAK_NODE";
        case YP_NODE_CALL_NODE:
            return "YP_NODE_CALL_NODE";
        case YP_NODE_CALL_OPERATOR_AND_WRITE_NODE:
            return "YP_NODE_CALL_OPERATOR_AND_WRITE_NODE";
        case YP_NODE_CALL_OPERATOR_OR_WRITE_NODE:
            return "YP_NODE_CALL_OPERATOR_OR_WRITE_NODE";
        case YP_NODE_CALL_OPERATOR_WRITE_NODE:
            return "YP_NODE_CALL_OPERATOR_WRITE_NODE";
        case YP_NODE_CAPTURE_PATTERN_NODE:
            return "YP_NODE_CAPTURE_PATTERN_NODE";
        case YP_NODE_CASE_NODE:
            return "YP_NODE_CASE_NODE";
        case YP_NODE_CLASS_NODE:
            return "YP_NODE_CLASS_NODE";
        case YP_NODE_CLASS_VARIABLE_OPERATOR_AND_WRITE_NODE:
            return "YP_NODE_CLASS_VARIABLE_OPERATOR_AND_WRITE_NODE";
        case YP_NODE_CLASS_VARIABLE_OPERATOR_OR_WRITE_NODE:
            return "YP_NODE_CLASS_VARIABLE_OPERATOR_OR_WRITE_NODE";
        case YP_NODE_CLASS_VARIABLE_OPERATOR_WRITE_NODE:
            return "YP_NODE_CLASS_VARIABLE_OPERATOR_WRITE_NODE";
        case YP_NODE_CLASS_VARIABLE_READ_NODE:
            return "YP_NODE_CLASS_VARIABLE_READ_NODE";
        case YP_NODE_CLASS_VARIABLE_WRITE_NODE:
            return "YP_NODE_CLASS_VARIABLE_WRITE_NODE";
        case YP_NODE_CONSTANT_OPERATOR_AND_WRITE_NODE:
            return "YP_NODE_CONSTANT_OPERATOR_AND_WRITE_NODE";
        case YP_NODE_CONSTANT_OPERATOR_OR_WRITE_NODE:
            return "YP_NODE_CONSTANT_OPERATOR_OR_WRITE_NODE";
        case YP_NODE_CONSTANT_OPERATOR_WRITE_NODE:
            return "YP_NODE_CONSTANT_OPERATOR_WRITE_NODE";
        case YP_NODE_CONSTANT_PATH_NODE:
            return "YP_NODE_CONSTANT_PATH_NODE";
        case YP_NODE_CONSTANT_PATH_OPERATOR_AND_WRITE_NODE:
            return "YP_NODE_CONSTANT_PATH_OPERATOR_AND_WRITE_NODE";
        case YP_NODE_CONSTANT_PATH_OPERATOR_OR_WRITE_NODE:
            return "YP_NODE_CONSTANT_PATH_OPERATOR_OR_WRITE_NODE";
        case YP_NODE_CONSTANT_PATH_OPERATOR_WRITE_NODE:
            return "YP_NODE_CONSTANT_PATH_OPERATOR_WRITE_NODE";
        case YP_NODE_CONSTANT_PATH_WRITE_NODE:
            return "YP_NODE_CONSTANT_PATH_WRITE_NODE";
        case YP_NODE_CONSTANT_READ_NODE:
            return "YP_NODE_CONSTANT_READ_NODE";
        case YP_NODE_DEF_NODE:
            return "YP_NODE_DEF_NODE";
        case YP_NODE_DEFINED_NODE:
            return "YP_NODE_DEFINED_NODE";
        case YP_NODE_ELSE_NODE:
            return "YP_NODE_ELSE_NODE";
        case YP_NODE_EMBEDDED_STATEMENTS_NODE:
            return "YP_NODE_EMBEDDED_STATEMENTS_NODE";
        case YP_NODE_EMBEDDED_VARIABLE_NODE:
            return "YP_NODE_EMBEDDED_VARIABLE_NODE";
        case YP_NODE_ENSURE_NODE:
            return "YP_NODE_ENSURE_NODE";
        case YP_NODE_FALSE_NODE:
            return "YP_NODE_FALSE_NODE";
        case YP_NODE_FIND_PATTERN_NODE:
            return "YP_NODE_FIND_PATTERN_NODE";
        case YP_NODE_FLOAT_NODE:
            return "YP_NODE_FLOAT_NODE";
        case YP_NODE_FOR_NODE:
            return "YP_NODE_FOR_NODE";
        case YP_NODE_FORWARDING_ARGUMENTS_NODE:
            return "YP_NODE_FORWARDING_ARGUMENTS_NODE";
        case YP_NODE_FORWARDING_PARAMETER_NODE:
            return "YP_NODE_FORWARDING_PARAMETER_NODE";
        case YP_NODE_FORWARDING_SUPER_NODE:
            return "YP_NODE_FORWARDING_SUPER_NODE";
        case YP_NODE_GLOBAL_VARIABLE_OPERATOR_AND_WRITE_NODE:
            return "YP_NODE_GLOBAL_VARIABLE_OPERATOR_AND_WRITE_NODE";
        case YP_NODE_GLOBAL_VARIABLE_OPERATOR_OR_WRITE_NODE:
            return "YP_NODE_GLOBAL_VARIABLE_OPERATOR_OR_WRITE_NODE";
        case YP_NODE_GLOBAL_VARIABLE_OPERATOR_WRITE_NODE:
            return "YP_NODE_GLOBAL_VARIABLE_OPERATOR_WRITE_NODE";
        case YP_NODE_GLOBAL_VARIABLE_READ_NODE:
            return "YP_NODE_GLOBAL_VARIABLE_READ_NODE";
        case YP_NODE_GLOBAL_VARIABLE_WRITE_NODE:
            return "YP_NODE_GLOBAL_VARIABLE_WRITE_NODE";
        case YP_NODE_HASH_NODE:
            return "YP_NODE_HASH_NODE";
        case YP_NODE_HASH_PATTERN_NODE:
            return "YP_NODE_HASH_PATTERN_NODE";
        case YP_NODE_IF_NODE:
            return "YP_NODE_IF_NODE";
        case YP_NODE_IMAGINARY_NODE:
            return "YP_NODE_IMAGINARY_NODE";
        case YP_NODE_IN_NODE:
            return "YP_NODE_IN_NODE";
        case YP_NODE_INSTANCE_VARIABLE_OPERATOR_AND_WRITE_NODE:
            return "YP_NODE_INSTANCE_VARIABLE_OPERATOR_AND_WRITE_NODE";
        case YP_NODE_INSTANCE_VARIABLE_OPERATOR_OR_WRITE_NODE:
            return "YP_NODE_INSTANCE_VARIABLE_OPERATOR_OR_WRITE_NODE";
        case YP_NODE_INSTANCE_VARIABLE_OPERATOR_WRITE_NODE:
            return "YP_NODE_INSTANCE_VARIABLE_OPERATOR_WRITE_NODE";
        case YP_NODE_INSTANCE_VARIABLE_READ_NODE:
            return "YP_NODE_INSTANCE_VARIABLE_READ_NODE";
        case YP_NODE_INSTANCE_VARIABLE_WRITE_NODE:
            return "YP_NODE_INSTANCE_VARIABLE_WRITE_NODE";
        case YP_NODE_INTEGER_NODE:
            return "YP_NODE_INTEGER_NODE";
        case YP_NODE_INTERPOLATED_REGULAR_EXPRESSION_NODE:
            return "YP_NODE_INTERPOLATED_REGULAR_EXPRESSION_NODE";
        case YP_NODE_INTERPOLATED_STRING_NODE:
            return "YP_NODE_INTERPOLATED_STRING_NODE";
        case YP_NODE_INTERPOLATED_SYMBOL_NODE:
            return "YP_NODE_INTERPOLATED_SYMBOL_NODE";
        case YP_NODE_INTERPOLATED_X_STRING_NODE:
            return "YP_NODE_INTERPOLATED_X_STRING_NODE";
        case YP_NODE_KEYWORD_HASH_NODE:
            return "YP_NODE_KEYWORD_HASH_NODE";
        case YP_NODE_KEYWORD_PARAMETER_NODE:
            return "YP_NODE_KEYWORD_PARAMETER_NODE";
        case YP_NODE_KEYWORD_REST_PARAMETER_NODE:
            return "YP_NODE_KEYWORD_REST_PARAMETER_NODE";
        case YP_NODE_LAMBDA_NODE:
            return "YP_NODE_LAMBDA_NODE";
        case YP_NODE_LOCAL_VARIABLE_OPERATOR_AND_WRITE_NODE:
            return "YP_NODE_LOCAL_VARIABLE_OPERATOR_AND_WRITE_NODE";
        case YP_NODE_LOCAL_VARIABLE_OPERATOR_OR_WRITE_NODE:
            return "YP_NODE_LOCAL_VARIABLE_OPERATOR_OR_WRITE_NODE";
        case YP_NODE_LOCAL_VARIABLE_OPERATOR_WRITE_NODE:
            return "YP_NODE_LOCAL_VARIABLE_OPERATOR_WRITE_NODE";
        case YP_NODE_LOCAL_VARIABLE_READ_NODE:
            return "YP_NODE_LOCAL_VARIABLE_READ_NODE";
        case YP_NODE_LOCAL_VARIABLE_WRITE_NODE:
            return "YP_NODE_LOCAL_VARIABLE_WRITE_NODE";
        case YP_NODE_MATCH_PREDICATE_NODE:
            return "YP_NODE_MATCH_PREDICATE_NODE";
        case YP_NODE_MATCH_REQUIRED_NODE:
            return "YP_NODE_MATCH_REQUIRED_NODE";
        case YP_NODE_MISSING_NODE:
            return "YP_NODE_MISSING_NODE";
        case YP_NODE_MODULE_NODE:
            return "YP_NODE_MODULE_NODE";
        case YP_NODE_MULTI_WRITE_NODE:
            return "YP_NODE_MULTI_WRITE_NODE";
        case YP_NODE_NEXT_NODE:
            return "YP_NODE_NEXT_NODE";
        case YP_NODE_NIL_NODE:
            return "YP_NODE_NIL_NODE";
        case YP_NODE_NO_KEYWORDS_PARAMETER_NODE:
            return "YP_NODE_NO_KEYWORDS_PARAMETER_NODE";
        case YP_NODE_NUMBERED_REFERENCE_READ_NODE:
            return "YP_NODE_NUMBERED_REFERENCE_READ_NODE";
        case YP_NODE_OPTIONAL_PARAMETER_NODE:
            return "YP_NODE_OPTIONAL_PARAMETER_NODE";
        case YP_NODE_OR_NODE:
            return "YP_NODE_OR_NODE";
        case YP_NODE_PARAMETERS_NODE:
            return "YP_NODE_PARAMETERS_NODE";
        case YP_NODE_PARENTHESES_NODE:
            return "YP_NODE_PARENTHESES_NODE";
        case YP_NODE_PINNED_EXPRESSION_NODE:
            return "YP_NODE_PINNED_EXPRESSION_NODE";
        case YP_NODE_PINNED_VARIABLE_NODE:
            return "YP_NODE_PINNED_VARIABLE_NODE";
        case YP_NODE_POST_EXECUTION_NODE:
            return "YP_NODE_POST_EXECUTION_NODE";
        case YP_NODE_PRE_EXECUTION_NODE:
            return "YP_NODE_PRE_EXECUTION_NODE";
        case YP_NODE_PROGRAM_NODE:
            return "YP_NODE_PROGRAM_NODE";
        case YP_NODE_RANGE_NODE:
            return "YP_NODE_RANGE_NODE";
        case YP_NODE_RATIONAL_NODE:
            return "YP_NODE_RATIONAL_NODE";
        case YP_NODE_REDO_NODE:
            return "YP_NODE_REDO_NODE";
        case YP_NODE_REGULAR_EXPRESSION_NODE:
            return "YP_NODE_REGULAR_EXPRESSION_NODE";
        case YP_NODE_REQUIRED_DESTRUCTURED_PARAMETER_NODE:
            return "YP_NODE_REQUIRED_DESTRUCTURED_PARAMETER_NODE";
        case YP_NODE_REQUIRED_PARAMETER_NODE:
            return "YP_NODE_REQUIRED_PARAMETER_NODE";
        case YP_NODE_RESCUE_MODIFIER_NODE:
            return "YP_NODE_RESCUE_MODIFIER_NODE";
        case YP_NODE_RESCUE_NODE:
            return "YP_NODE_RESCUE_NODE";
        case YP_NODE_REST_PARAMETER_NODE:
            return "YP_NODE_REST_PARAMETER_NODE";
        case YP_NODE_RETRY_NODE:
            return "YP_NODE_RETRY_NODE";
        case YP_NODE_RETURN_NODE:
            return "YP_NODE_RETURN_NODE";
        case YP_NODE_SELF_NODE:
            return "YP_NODE_SELF_NODE";
        case YP_NODE_SINGLETON_CLASS_NODE:
            return "YP_NODE_SINGLETON_CLASS_NODE";
        case YP_NODE_SOURCE_ENCODING_NODE:
            return "YP_NODE_SOURCE_ENCODING_NODE";
        case YP_NODE_SOURCE_FILE_NODE:
            return "YP_NODE_SOURCE_FILE_NODE";
        case YP_NODE_SOURCE_LINE_NODE:
            return "YP_NODE_SOURCE_LINE_NODE";
        case YP_NODE_SPLAT_NODE:
            return "YP_NODE_SPLAT_NODE";
        case YP_NODE_STATEMENTS_NODE:
            return "YP_NODE_STATEMENTS_NODE";
        case YP_NODE_STRING_CONCAT_NODE:
            return "YP_NODE_STRING_CONCAT_NODE";
        case YP_NODE_STRING_NODE:
            return "YP_NODE_STRING_NODE";
        case YP_NODE_SUPER_NODE:
            return "YP_NODE_SUPER_NODE";
        case YP_NODE_SYMBOL_NODE:
            return "YP_NODE_SYMBOL_NODE";
        case YP_NODE_TRUE_NODE:
            return "YP_NODE_TRUE_NODE";
        case YP_NODE_UNDEF_NODE:
            return "YP_NODE_UNDEF_NODE";
        case YP_NODE_UNLESS_NODE:
            return "YP_NODE_UNLESS_NODE";
        case YP_NODE_UNTIL_NODE:
            return "YP_NODE_UNTIL_NODE";
        case YP_NODE_WHEN_NODE:
            return "YP_NODE_WHEN_NODE";
        case YP_NODE_WHILE_NODE:
            return "YP_NODE_WHILE_NODE";
        case YP_NODE_X_STRING_NODE:
            return "YP_NODE_X_STRING_NODE";
        case YP_NODE_YIELD_NODE:
            return "YP_NODE_YIELD_NODE";
    }
    return "\0";
}
