/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;

public class DbSpace {
    private static final String USAGE = "usage: " + CmdUtil.getJavaCommand(DbSpace.class) + "\n" + "       -h <dir> # environment home directory\n" + "       [-q]     # quiet, print grand totals only\n" + "       [-u]     # sort by utilization\n" + "       [-d]     # dump file summary details\n" + "       [-V]     # print JE version number";
    private File envHome = null;
    private EnvironmentImpl envImpl;
    private boolean quiet = false;
    private boolean sorted = false;
    private boolean details = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws DatabaseException {
        DbSpace space = new DbSpace();
        space.parseArgs(argv);
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setReadOnly(true);
        Environment env = new Environment(space.envHome, envConfig);
        space.envImpl = DbInternal.envGetEnvironmentImpl(env);
        try {
            space.print(System.out);
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
        finally {
            try {
                env.close();
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    private DbSpace() {
    }

    public DbSpace(Environment env, boolean quiet, boolean details, boolean sorted) {
        this(DbInternal.envGetEnvironmentImpl(env), quiet, details, sorted);
    }

    public DbSpace(EnvironmentImpl envImpl, boolean quiet, boolean details, boolean sorted) {
        this.envImpl = envImpl;
        this.quiet = quiet;
        this.details = details;
        this.sorted = sorted;
    }

    private void printUsage(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println(USAGE);
        System.exit(-1);
    }

    private void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        if (nArgs == 0) {
            this.printUsage(null);
            System.exit(0);
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-q")) {
                this.quiet = true;
                continue;
            }
            if (thisArg.equals("-u")) {
                this.sorted = true;
                continue;
            }
            if (thisArg.equals("-d")) {
                this.details = true;
                continue;
            }
            if (thisArg.equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (!thisArg.equals("-h")) continue;
            if (argc < nArgs) {
                this.envHome = new File(argv[argc++]);
                continue;
            }
            this.printUsage("-h requires an argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
    }

    public void print(PrintStream out) throws DatabaseException {
        UtilizationProfile profile = this.envImpl.getUtilizationProfile();
        SortedMap map = profile.getFileSummaryMap(false);
        int fileIndex = 0;
        Summary totals = new Summary();
        Object[] summaries = null;
        if (!this.quiet) {
            summaries = new Summary[map.size()];
        }
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Long fileNum = (Long)entry.getKey();
            FileSummary fs = (FileSummary)entry.getValue();
            Summary summary = new Summary(fileNum, fs);
            if (summaries != null) {
                summaries[fileIndex] = summary;
            }
            if (this.details) {
                out.println("File 0x" + Long.toHexString(fileNum) + ": " + fs);
            }
            totals.add(summary);
            ++fileIndex;
        }
        if (this.details) {
            out.println();
        }
        out.println("  File    Size (KB)  % Used\n--------  ---------  ------");
        if (summaries != null) {
            if (this.sorted) {
                Arrays.sort(summaries);
            }
            for (int i = 0; i < summaries.length; ++i) {
                ((Summary)summaries[i]).print(out);
            }
        }
        totals.print(out);
    }

    private static class Summary
    implements Comparable {
        static final String HEADER = "  File    Size (KB)  % Used\n--------  ---------  ------";
        Long fileNum;
        long totalSize;
        long obsoleteSize;

        Summary() {
        }

        Summary(Long fileNum, FileSummary summary) throws DatabaseException {
            this.fileNum = fileNum;
            this.totalSize = summary.totalSize;
            this.obsoleteSize = summary.getObsoleteSize();
        }

        public int compareTo(Object other) {
            Summary o = (Summary)other;
            return this.utilization() - o.utilization();
        }

        void add(Summary o) {
            this.totalSize += o.totalSize;
            this.obsoleteSize += o.obsoleteSize;
        }

        void print(PrintStream out) {
            if (this.fileNum != null) {
                this.pad(out, Long.toHexString(this.fileNum), 8, '0');
            } else {
                out.print(" TOTALS ");
            }
            int kb = (int)(this.totalSize / 1024L);
            int util = this.utilization();
            out.print("  ");
            this.pad(out, Integer.toString(kb), 9, ' ');
            out.print("     ");
            this.pad(out, Integer.toString(util), 3, ' ');
            out.println();
        }

        int utilization() {
            return UtilizationProfile.utilization(this.obsoleteSize, this.totalSize);
        }

        private void pad(PrintStream out, String val, int digits, char padChar) {
            int padSize = digits - val.length();
            for (int i = 0; i < padSize; ++i) {
                out.print(padChar);
            }
            out.print(val);
        }
    }
}

