var searchData=
[
  ['a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_0',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_1',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_2',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_3',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20connection_20object_20to_20an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_4',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20connection_20to_20an_20smtp_20server_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20_3a_20provides_20a_20connection_20object_20to_20an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_5',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_6',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_7',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_8',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_9',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_10',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_11',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_12',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_13',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_14',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_15',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_16',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_17',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_18',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_19',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_20',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_21',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_22',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_23',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_24',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_25',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_26',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_27',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20set_20of_20classes_20that_20can_20be_20used_20for_20easy_20communication_20with_20smtp_20servers_20for_20sending_20emails_20with_20or_20without_20tls_20ssl_20encryption_20to_20use_20this_20module_20use_20c_20requires_20smtpclient_20in_20your_20code_20see_20examples_20email_20q_20for_20an_20example_20program_20using_20this_20module_20all_20the_20symbols_20in_20the_20module_20are_20defined_20in_20the_20smtpclient_20namespace_20classes_20provided_3a_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20_3a_20manages_20a_20connection_20to_20an_20smtp_20server_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20_3a_20provides_20a_20connection_20object_20to_20an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_28',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_29',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_30',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_31',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_32',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_33',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_34',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_35',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_36',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_37',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_38',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_39',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_40',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_41',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['abort_42',['abort',['../../../../lang/html/class_qore_1_1_abstract_poll_operation.html#a134144cef4e82263ddb591ff43d22158',1,'Qore::AbstractPollOperation::abort()'],['../../../../lang/html/class_qore_1_1_socket_poll_operation_base.html#a2577a9a1d4bc02d5605ebc4116d9ed92',1,'Qore::SocketPollOperationBase::abort()'],['../../../../lang/html/group__library__functions.html#ga4a51c4086a24e58fdeafe467d8188fbf',1,'Qore::abort()'],['../../../../lang/html/group__library__functions.html#ga4a51c4086a24e58fdeafe467d8188fbf',1,'Qore::abort()']]],
  ['above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_43',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['abs_44',['abs',['../../../../lang/html/class_qore_1_1zzz8floatzzz9.html#a2adeb1fcae50106e1a3ed4506d5b12ea',1,'Qore::&lt;float&gt;::abs()'],['../../../../lang/html/class_qore_1_1zzz8intzzz9.html#a2853596aba431a8e4ad3e3e7e2417c37',1,'Qore::&lt;int&gt;::abs()'],['../../../../lang/html/class_qore_1_1zzz8numberzzz9.html#a638c34b8465f9a9ce773c25e4a263cd9',1,'Qore::&lt;number&gt;::abs()'],['../../../../lang/html/group__math__functions.html#ga38089899d2c160b300a0ae1864d62420',1,'Qore::abs(int i)'],['../../../../lang/html/group__math__functions.html#gaa7733d4d308dbec2beace333f09c3ef7',1,'Qore::abs(number n)'],['../../../../lang/html/group__math__functions.html#ga5e9a214488ce1f4ba5cc9d26f6978935',1,'Qore::abs(softfloat f)'],['../../../../lang/html/group__math__functions.html#ga71481aee49d627dc81be04218403f9c3',1,'Qore::abs()'],['../../../../lang/html/group__math__functions.html#ga38089899d2c160b300a0ae1864d62420',1,'Qore::abs(int i)'],['../../../../lang/html/group__math__functions.html#gaa7733d4d308dbec2beace333f09c3ef7',1,'Qore::abs(number n)'],['../../../../lang/html/group__math__functions.html#ga5e9a214488ce1f4ba5cc9d26f6978935',1,'Qore::abs(softfloat f)'],['../../../../lang/html/group__math__functions.html#ga71481aee49d627dc81be04218403f9c3',1,'Qore::abs()']]],
  ['absolute_45',['absolute',['../../../../lang/html/class_qore_1_1zzz8datezzz9.html#a4489e87e23f140760686d0ed1c66eff4',1,'&lt;date&gt;']]],
  ['absolute_5fpath_46',['absolute_path',['../../../../lang/html/group__filesystem__functions.html#ga59a85037788f39c5269f0aadbb499f90',1,'Qore::absolute_path(string path)'],['../../../../lang/html/group__filesystem__functions.html#ga59a85037788f39c5269f0aadbb499f90',1,'Qore::absolute_path(string path)'],['../../../Util/html/namespace_util.html#affd15aecc26fae09efd9b35bbde09169',1,'Util::absolute_path()']]],
  ['absolute_5fpath_5funix_47',['absolute_path_unix',['../../../../lang/html/group__filesystem__functions.html#gac13e5f3c1a03fbb5e6c60213a595795f',1,'Qore::absolute_path_unix(string path)'],['../../../../lang/html/group__filesystem__functions.html#gac13e5f3c1a03fbb5e6c60213a595795f',1,'Qore::absolute_path_unix(string path)'],['../../../Util/html/namespace_util.html#ae5a7560331661397b803867684f2adaa',1,'Util::absolute_path_unix()']]],
  ['absolute_5fpath_5fwindows_48',['absolute_path_windows',['../../../../lang/html/group__filesystem__functions.html#ga77456f40ff1734bb6d5692e6dbb9e8eb',1,'Qore::absolute_path_windows(string path)'],['../../../../lang/html/group__filesystem__functions.html#ga77456f40ff1734bb6d5692e6dbb9e8eb',1,'Qore::absolute_path_windows(string path)'],['../../../Util/html/namespace_util.html#a8b50134b467caf17df72d2ba26991243',1,'Util::absolute_path_windows()']]],
  ['abstractauthenticator_49',['AbstractAuthenticator',['../../../HttpServerUtil/html/class_http_server_1_1_abstract_authenticator.html',1,'HttpServer']]],
  ['abstractbidirectionaliterator_50',['AbstractBidirectionalIterator',['../../../../lang/html/class_qore_1_1_abstract_bidirectional_iterator.html',1,'Qore']]],
  ['abstractdatasource_51',['AbstractDatasource',['../../../../lang/html/class_qore_1_1_s_q_l_1_1_abstract_datasource.html',1,'Qore::SQL']]],
  ['abstractdebugcontrol_52',['AbstractDebugControl',['../../../DebugUtil/html/class_debug_util_1_1_abstract_debug_control.html',1,'DebugUtil']]],
  ['abstracthttprequesthandler_53',['AbstractHttpRequestHandler',['../../../HttpServerUtil/html/class_http_server_1_1_abstract_http_request_handler.html',1,'HttpServer']]],
  ['abstracthttpsockethandler_54',['AbstractHttpSocketHandler',['../../../HttpServerUtil/html/class_http_server_1_1_abstract_http_socket_handler.html',1,'HttpServer']]],
  ['abstracthttpsockethandlerinterface_55',['AbstractHttpSocketHandlerInterface',['../../../HttpServerUtil/html/class_http_server_1_1_abstract_http_socket_handler_interface.html',1,'HttpServer']]],
  ['abstractiterator_56',['AbstractIterator',['../../../../lang/html/class_qore_1_1_abstract_iterator.html',1,'Qore']]],
  ['abstractlineiterator_57',['AbstractLineIterator',['../../../../lang/html/class_qore_1_1_abstract_line_iterator.html',1,'Qore']]],
  ['abstractlogger_58',['AbstractLogger',['../../../HttpServerUtil/html/class_http_server_1_1_abstract_logger.html',1,'HttpServer']]],
  ['abstractloggerappenderfilerotate_59',['AbstractLoggerAppenderFileRotate',['../../../Logger/html/class_logger_1_1_abstract_logger_appender_file_rotate.html',1,'Logger']]],
  ['abstractparameterobject_60',['AbstractParameterObject',['../../../Swagger/html/class_swagger_1_1_abstract_parameter_object.html',1,'Swagger']]],
  ['abstractpollableioobject_61',['AbstractPollableIoObject',['../../../../lang/html/class_qore_1_1_abstract_pollable_io_object.html',1,'Qore']]],
  ['abstractpollableioobjectbase_62',['AbstractPollableIoObjectBase',['../../../../lang/html/class_qore_1_1_abstract_pollable_io_object_base.html',1,'Qore']]],
  ['abstractpolloperation_63',['AbstractPollOperation',['../../../../lang/html/class_qore_1_1_abstract_poll_operation.html',1,'Qore']]],
  ['abstractquantifiedbidirectionaliterator_64',['AbstractQuantifiedBidirectionalIterator',['../../../../lang/html/class_qore_1_1_abstract_quantified_bidirectional_iterator.html',1,'Qore']]],
  ['abstractquantifiediterator_65',['AbstractQuantifiedIterator',['../../../../lang/html/class_qore_1_1_abstract_quantified_iterator.html',1,'Qore']]],
  ['abstractrestschemavalidator_66',['AbstractRestSchemaValidator',['../../../RestSchemaValidator/html/class_rest_schema_validator_1_1_abstract_rest_schema_validator.html',1,'RestSchemaValidator']]],
  ['abstractsmartlock_67',['AbstractSmartLock',['../../../../lang/html/class_qore_1_1_thread_1_1_abstract_smart_lock.html',1,'Qore::Thread']]],
  ['abstractsqlstatement_68',['AbstractSQLStatement',['../../../../lang/html/class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement.html',1,'Qore::SQL']]],
  ['abstractstreamrequest_69',['AbstractStreamRequest',['../../../HttpServerUtil/html/class_http_server_1_1_abstract_stream_request.html',1,'HttpServer']]],
  ['abstractthreadresource_70',['AbstractThreadResource',['../../../../lang/html/class_qore_1_1_thread_1_1_abstract_thread_resource.html',1,'Qore::Thread']]],
  ['abstracturlhandler_71',['AbstractUrlHandler',['../../../HttpServerUtil/html/class_http_server_1_1_abstract_url_handler.html',1,'HttpServer']]],
  ['accept_72',['Accept',['../../../RestClient/html/class_rest_client_1_1_rest_client.html#aaa72b508595d67df8068cab7d2fe4029',1,'RestClient::RestClient']]],
  ['accept_73',['accept',['../../../../lang/html/class_qore_1_1_socket.html#a39eb3993cde9b9e0096412d1edbc3a57',1,'Qore::Socket::accept()'],['../../../../lang/html/class_qore_1_1_socket.html#a44c6610f3e6ed41cccd4a69450298acf',1,'Qore::Socket::accept(timeout timeout_ms)']]],
  ['acceptallcertificates_74',['acceptAllCertificates',['../../../../lang/html/class_qore_1_1_socket.html#aa530d889c522a410e7e5e5163204d1db',1,'Qore::Socket']]],
  ['acceptlist_75',['AcceptList',['../../../RestClient/html/class_rest_client_1_1_rest_client.html#ac790f697abc961cd5f72ce3309afe368',1,'RestClient::RestClient']]],
  ['acceptmap_76',['AcceptMap',['../../../RestClient/html/class_rest_client_1_1_rest_client.html#a2f456c25748f5472e44fc3f7bc060521',1,'RestClient::RestClient']]],
  ['accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_77',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['acceptssl_78',['acceptSSL',['../../../../lang/html/class_qore_1_1_socket.html#adb234af8e02eee33b15a55f0ad37f690',1,'Qore::Socket::acceptSSL()'],['../../../../lang/html/class_qore_1_1_socket.html#a6955fcbdc09f8e24636ae0f6103e2eb7',1,'Qore::Socket::acceptSSL(timeout timeout_ms)']]],
  ['acos_79',['acos',['../../../../lang/html/group__math__functions.html#ga5a93ca5d985c1ec389dc2e8155c50945',1,'Qore::acos(number n)'],['../../../../lang/html/group__math__functions.html#ga0838a098432c8e4c32193d7e0b5e2ec7',1,'Qore::acos(softfloat f)'],['../../../../lang/html/group__math__functions.html#ga5a93ca5d985c1ec389dc2e8155c50945',1,'Qore::acos(number n)'],['../../../../lang/html/group__math__functions.html#ga0838a098432c8e4c32193d7e0b5e2ec7',1,'Qore::acos(softfloat f)']]],
  ['action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_80',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['active_81',['active',['../../../../lang/html/class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement.html#aa6e9c12936aca9c1c6b4eb151cd3d0a7',1,'Qore::SQL::AbstractSQLStatement::active()'],['../../../../lang/html/class_qore_1_1_s_q_l_1_1_s_q_l_statement.html#ab2435b87ba94bcd5b064084c0930d92c',1,'Qore::SQL::SQLStatement::active()']]],
  ['active_5fexception_82',['active_exception',['../../../../lang/html/group__threading__functions.html#ga6bbd8315a329d9c5cbd04c8fe6f287a8',1,'Qore::active_exception()'],['../../../../lang/html/group__threading__functions.html#ga6bbd8315a329d9c5cbd04c8fe6f287a8',1,'Qore::active_exception()']]],
  ['add_83',['add',['../../../MailMessage/html/class_mail_message_1_1_attachment.html#ab08c581e3989408b19d4204481af4425',1,'MailMessage::Attachment::add()'],['../../../MailMessage/html/class_mail_message_1_1_part.html#a6ec91f951cc42e56575caf9db42f2746',1,'MailMessage::Part::add()'],['../../../Swagger/html/class_swagger_1_1_path_component.html#a41070f210acfb2bba0ba9be292e52ba2',1,'Swagger::PathComponent::add()']]],
  ['addbcc_84',['addBCC',['../../../MailMessage/html/class_mail_message_1_1_message.html#a44c00d5fd7fe11de94548d4d950378f7',1,'MailMessage::Message']]],
  ['addbody_85',['addBody',['../../../MailMessage/html/class_mail_message_1_1_message.html#afff991bbe17cfec044b5b5da9c3589b8',1,'MailMessage::Message::addBody(binary bin)'],['../../../MailMessage/html/class_mail_message_1_1_message.html#ac3ef5cc03fb369b2f0b0a02a43ef5ed2',1,'MailMessage::Message::addBody(string str)']]],
  ['addcc_86',['addCC',['../../../MailMessage/html/class_mail_message_1_1_message.html#a7350edb6095bbe6401865931cd988421',1,'MailMessage::Message']]],
  ['adddefaultheaders_87',['addDefaultHeaders',['../../../../lang/html/class_qore_1_1_h_t_t_p_client.html#acfc588c5d6f57c8a04a0f14819c90128',1,'Qore::HTTPClient::addDefaultHeaders()'],['../../../RestClient/html/class_rest_client_1_1_rest_client.html#acee6ff2685bf26df90e62da13b4602fd',1,'RestClient::RestClient::addDefaultHeaders()']]],
  ['added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_88',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_89',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_90',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_91',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_92',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_93',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_94',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_95',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_96',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_97',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['addencodepart_98',['addEncodePart',['../../../Mime/html/class_mime_1_1_multi_part_alternative_message.html#a9b6278f2b00790e496deab292f701d53',1,'Mime::MultiPartAlternativeMessage::addEncodePart()'],['../../../Mime/html/class_mime_1_1_multi_part_mixed_message.html#aa7347d46e22292b35089e4f2ca71ba45',1,'Mime::MultiPartMixedMessage::addEncodePart()']]],
  ['addfieldsfromparameters_99',['addFieldsFromParameters',['../../../Swagger/html/class_swagger_1_1_swagger_schema.html#a1a357be67112f170da30fc0d00267335',1,'Swagger::SwaggerSchema']]],
  ['addfieldsfromparametersintern_100',['addFieldsFromParametersIntern',['../../../Swagger/html/class_swagger_1_1_swagger_schema.html#a58ed33cfe059024a2afeaadb53eddf66',1,'Swagger::SwaggerSchema']]],
  ['addhandlers_101',['addHandlers',['../../../HttpServer/html/class_http_server_1_1_http_listener.html#a8f2d6238763a93561c8247b2a0486f60',1,'HttpServer::HttpListener']]],
  ['addhandlertolistener_102',['addHandlerToListener',['../../../HttpServer/html/class_http_server_1_1_http_server.html#a26031d0a71f532524c7d842ea33bba4a',1,'HttpServer::HttpServer::addHandlerToListener(softstring bind, string name, hash&lt; HttpHandlerConfigInfo &gt; info)'],['../../../HttpServer/html/class_http_server_1_1_http_server.html#aa8bdf6a555af7c7612d4a6643d6b3d22',1,'HttpServer::HttpServer::addHandlerToListener(softstring bind, string name, HttpServer::AbstractUrlHandler obj)']]],
  ['addhandlertolistenerid_103',['addHandlerToListenerID',['../../../HttpServer/html/class_http_server_1_1_http_server.html#a8d37e9d1489a38f6ba33d2dbb9bf82f6',1,'HttpServer::HttpServer::addHandlerToListenerID(softint id, string name, hash&lt; HttpHandlerConfigInfo &gt; info)'],['../../../HttpServer/html/class_http_server_1_1_http_server.html#aa4d7809c6d518b0707783e91ac08aacf',1,'HttpServer::HttpServer::addHandlerToListenerID(softint id, string name, HttpServer::AbstractUrlHandler obj)'],['../../../HttpServer/html/class_http_server_1_1_http_server.html#ac87269408ff20ed2851e02fab6441b83',1,'HttpServer::HttpServer::addHandlerToListenerID(softint id, string name, string path, *softlist content_type, HttpServer::AbstractHttpRequestHandler obj, *softlist special_headers, bool isregex=True)']]],
  ['addheader_104',['addHeader',['../../../MailMessage/html/class_mail_message_1_1_message.html#ad5f0c16d8cfb78393b227ebeba842fdb',1,'MailMessage::Message::addHeader(hash&lt; auto &gt; hdrs)'],['../../../MailMessage/html/class_mail_message_1_1_message.html#a42d5ea13829d17f562f49aa02b6a918f',1,'MailMessage::Message::addHeader(list&lt; auto &gt; hdrs)'],['../../../MailMessage/html/class_mail_message_1_1_message.html#a1f7421da54d4cea71a95ed8f7d5bf62a',1,'MailMessage::Message::addHeader(string hdr)']]],
  ['addhttpmethod_105',['addHttpMethod',['../../../HttpServer/html/class_http_server_1_1_http_server.html#aa1433b7474be6b9f71cf1f4963e23f4d',1,'HttpServer::HttpServer']]],
  ['additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_106',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['additionalproperties_107',['additionalProperties',['../../../Swagger/html/class_swagger_1_1_schema_object.html#a0cae1a696fa8ac0e1279c60d39d9efb6',1,'Swagger::SchemaObject']]],
  ['addlistener_108',['addListener',['../../../HttpServer/html/class_http_server_1_1_http_server.html#a3cd935412d6a2ed9720322b5f48e269a',1,'HttpServer::HttpServer::addListener(hash&lt; HttpListenerOptionInfo &gt; opts)'],['../../../HttpServer/html/class_http_server_1_1_http_server.html#ab75187a7168dec84f4eeb2b3984e3c92',1,'HttpServer::HttpServer::addListener(int port)']]],
  ['addlisteners_109',['addListeners',['../../../HttpServer/html/class_http_server_1_1_http_server.html#aa21230433102aa44f929c1f81cdb2100',1,'HttpServer::HttpServer::addListeners(hash&lt; HttpListenerOptionInfo &gt; info, *reference&lt; hash&lt; string, string &gt; &gt; errmap)'],['../../../HttpServer/html/class_http_server_1_1_http_server.html#a1c58db4934dca135cefc3b2b1e150473',1,'HttpServer::HttpServer::addListeners(string bind, hash&lt; HttpListenerOptionInfo &gt; info, *reference&lt; hash&lt; string, string &gt; &gt; errmap)']]],
  ['addparameter_110',['addParameter',['../../../Swagger/html/class_swagger_1_1_parameter_group.html#a54fca032d9fe447d21d2ce9fadc2fff8',1,'Swagger::ParameterGroup::addParameter(AbstractParameterObject p)'],['../../../Swagger/html/class_swagger_1_1_parameter_group.html#aa07da21a55e2141d121c2682cc38148c',1,'Swagger::ParameterGroup::addParameter(string key, AbstractParameterObject p)']]],
  ['addpart_111',['addPart',['../../../Mime/html/class_mime_1_1_multi_part_alternative_message.html#a395ec8647de864471bd6a7ac6cc4faf4',1,'Mime::MultiPartAlternativeMessage::addPart()'],['../../../Mime/html/class_mime_1_1_multi_part_form_data_message.html#a2e0a8b32ee90bd1539e76528cf23100d',1,'Mime::MultiPartFormDataMessage::addPart(data mime_data, string name, *hash hdr)'],['../../../Mime/html/class_mime_1_1_multi_part_form_data_message.html#af27e94747f99a8dee69c0f2b13f08b50',1,'Mime::MultiPartFormDataMessage::addPart(data mime_data, string name, string filename, string content_type, *hash hdr)'],['../../../Mime/html/class_mime_1_1_multi_part_form_data_message.html#a24ab8d66b49208b198ed68bfce2fd6a9',1,'Mime::MultiPartFormDataMessage::addPart(hash&lt; FormDataMessageInfo &gt; h)'],['../../../Mime/html/class_mime_1_1_multi_part_mixed_message.html#a8d51880082816e40f87a7cdb9e9239d1',1,'Mime::MultiPartMixedMessage::addPart()'],['../../../Mime/html/class_mime_1_1_multi_part_related_message.html#a24a83d3bfa7b7999331009fc931565f3',1,'Mime::MultiPartRelatedMessage::addPart()']]],
  ['addprogram_112',['addProgram',['../../../../lang/html/class_qore_1_1_debug_program.html#af00ca169aed35d3533833ed6c9537875',1,'Qore::DebugProgram']]],
  ['address_113',['address',['../../../../lang/html/struct_qore_1_1_net_if_info.html#a4fc12d195f938157631353016b9bfc8a',1,'Qore::NetIfInfo']]],
  ['address_20family_20constants_114',['Network Address Family Constants',['../../../../lang/html/group__network__address__family__constants.html',1,'']]],
  ['address_20information_20constants_115',['Network Address Information Constants',['../../../../lang/html/group__network__address__information__constants.html',1,'']]],
  ['address_5fdesc_116',['address_desc',['../../../../lang/html/struct_qore_1_1_net_if_info.html#aadcd8cc7a39cfea1de4a4330d642cb0f',1,'Qore::NetIfInfo']]],
  ['addthreadid_117',['addThreadId',['../../../../lang/html/class_qore_1_1_breakpoint.html#a7550bb9d25be0943578dc1e1d52a3691',1,'Qore::Breakpoint']]],
  ['addto_118',['addTO',['../../../MailMessage/html/class_mail_message_1_1_message.html#a1e42111648631f83c02537cfd9a8bc6a',1,'MailMessage::Message']]],
  ['addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_119',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['adduserthreadcontext_120',['addUserThreadContext',['../../../HttpServerUtil/html/class_http_server_1_1_http_listener_interface.html#a25a3d493787b4410f2d40faf73afa3d7',1,'HttpServer::HttpListenerInterface']]],
  ['af_5finet_121',['AF_INET',['../../../../lang/html/group__network__address__family__constants.html#gad33bf2a0a393d1100099acfb6ca644e2',1,'Qore::AF_INET'],['../../../../lang/html/group__network__address__family__constants.html#gad33bf2a0a393d1100099acfb6ca644e2',1,'Qore::AF_INET']]],
  ['af_5finet6_122',['AF_INET6',['../../../../lang/html/group__network__address__family__constants.html#ga4b71df64cd838d8f5c0c1974d3011dab',1,'Qore::AF_INET6'],['../../../../lang/html/group__network__address__family__constants.html#ga4b71df64cd838d8f5c0c1974d3011dab',1,'Qore::AF_INET6']]],
  ['af_5flocal_123',['AF_LOCAL',['../../../../lang/html/group__network__address__family__constants.html#ga059e4258e2fa6cb44c1ed5c614698545',1,'Qore::AF_LOCAL'],['../../../../lang/html/group__network__address__family__constants.html#ga059e4258e2fa6cb44c1ed5c614698545',1,'Qore::AF_LOCAL']]],
  ['af_5funix_124',['AF_UNIX',['../../../../lang/html/group__network__address__family__constants.html#ga6d1177c9edd5e022ab3b9b1fcadfa3f3',1,'Qore::AF_UNIX'],['../../../../lang/html/group__network__address__family__constants.html#ga6d1177c9edd5e022ab3b9b1fcadfa3f3',1,'Qore::AF_UNIX']]],
  ['af_5funspec_125',['AF_UNSPEC',['../../../../lang/html/group__network__address__family__constants.html#gac4f81abe9d374562b41117c51950fb80',1,'Qore::AF_UNSPEC'],['../../../../lang/html/group__network__address__family__constants.html#gac4f81abe9d374562b41117c51950fb80',1,'Qore::AF_UNSPEC']]],
  ['affectedrows_126',['affectedRows',['../../../../lang/html/class_qore_1_1_s_q_l_1_1_abstract_s_q_l_statement.html#af32268f269fc8e29cb4966ec70d40b26',1,'Qore::SQL::AbstractSQLStatement::affectedRows()'],['../../../../lang/html/class_qore_1_1_s_q_l_1_1_s_q_l_statement.html#a62e2cbca10b9b848b26fd7ebfa5dd753',1,'Qore::SQL::SQLStatement::affectedRows()']]],
  ['afmap_127',['AFMap',['../../../../lang/html/group__network__address__family__constants.html#ga70894a206b70fd3973f0d4dad1322a02',1,'Qore::AFMap'],['../../../../lang/html/group__network__address__family__constants.html#ga70894a206b70fd3973f0d4dad1322a02',1,'Qore::AFMap']]],
  ['afstrmap_128',['AFStrMap',['../../../../lang/html/group__network__address__family__constants.html#gafda5d0bb6a1cac9536eb682ae75c4b5c',1,'Qore::AFStrMap'],['../../../../lang/html/group__network__address__family__constants.html#gafda5d0bb6a1cac9536eb682ae75c4b5c',1,'Qore::AFStrMap']]],
  ['after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_129',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_130',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ai_5faddrconfig_131',['AI_ADDRCONFIG',['../../../../lang/html/group__network__address__information__constants.html#ga4758a93032a616834593a3172740b973',1,'Qore::AI_ADDRCONFIG'],['../../../../lang/html/group__network__address__information__constants.html#ga4758a93032a616834593a3172740b973',1,'Qore::AI_ADDRCONFIG']]],
  ['ai_5fall_132',['AI_ALL',['../../../../lang/html/group__network__address__information__constants.html#ga6b06ba8ece0c3d06c2eaead5a0b3735b',1,'Qore::AI_ALL'],['../../../../lang/html/group__network__address__information__constants.html#ga6b06ba8ece0c3d06c2eaead5a0b3735b',1,'Qore::AI_ALL']]],
  ['ai_5fcanonname_133',['AI_CANONNAME',['../../../../lang/html/group__network__address__information__constants.html#ga4f24f51906ead287cd6e6cac80b344cb',1,'Qore::AI_CANONNAME'],['../../../../lang/html/group__network__address__information__constants.html#ga4f24f51906ead287cd6e6cac80b344cb',1,'Qore::AI_CANONNAME']]],
  ['ai_5fnumerichost_134',['AI_NUMERICHOST',['../../../../lang/html/group__network__address__information__constants.html#ga41a7aa51148c443dcab4262b6d5eed56',1,'Qore::AI_NUMERICHOST'],['../../../../lang/html/group__network__address__information__constants.html#ga41a7aa51148c443dcab4262b6d5eed56',1,'Qore::AI_NUMERICHOST']]],
  ['ai_5fnumericserv_135',['AI_NUMERICSERV',['../../../../lang/html/group__network__address__information__constants.html#gac31474a7abb330fc937a0f501875755c',1,'Qore::AI_NUMERICSERV'],['../../../../lang/html/group__network__address__information__constants.html#gac31474a7abb330fc937a0f501875755c',1,'Qore::AI_NUMERICSERV']]],
  ['ai_5fpassive_136',['AI_PASSIVE',['../../../../lang/html/group__network__address__information__constants.html#gaf18e12f435604a899f9f5fa8fee83a8d',1,'Qore::AI_PASSIVE'],['../../../../lang/html/group__network__address__information__constants.html#gaf18e12f435604a899f9f5fa8fee83a8d',1,'Qore::AI_PASSIVE']]],
  ['ai_5fv4mapped_137',['AI_V4MAPPED',['../../../../lang/html/group__network__address__information__constants.html#gad17072ef3c5d0a9081cd239ff7e15a4e',1,'Qore::AI_V4MAPPED'],['../../../../lang/html/group__network__address__information__constants.html#gad17072ef3c5d0a9081cd239ff7e15a4e',1,'Qore::AI_V4MAPPED']]],
  ['aiflags_138',['AIFlags',['../../../HttpServer/html/class_http_server_1_1_http_server.html#a6bcc31598b396e196200e51bb6489884',1,'HttpServer::HttpServer']]],
  ['algorithms_139',['Crytographic Digest Algorithms',['../../../../lang/html/group__digest__algorithms.html',1,'']]],
  ['all_20the_20symbols_20in_20the_20module_20are_20defined_20in_20the_20smtpclient_20namespace_20classes_20provided_3a_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20_3a_20manages_20a_20connection_20to_20an_20smtp_20server_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20_3a_20provides_20a_20connection_20object_20to_20an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_140',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['allof_141',['allOf',['../../../Swagger/html/class_swagger_1_1_schema_object.html#a64d79107ec67f16ada5cff789536181f',1,'Swagger::SchemaObject']]],
  ['allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_142',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['allow_5fany_5fresponse_143',['allow_any_response',['../../../RestClient/html/class_rest_client_1_1_rest_client.html#a5a56f733ae54960679aded51f8587705',1,'RestClient::RestClient']]],
  ['allowedvalueinfo_144',['AllowedValueInfo',['../../../Util/html/struct_util_1_1_allowed_value_info.html',1,'Util']]],
  ['allowemptyvalue_145',['allowEmptyValue',['../../../Swagger/html/class_swagger_1_1_typed_parameter.html#af63ea0040e4dfba6969701edeb432de0',1,'Swagger::TypedParameter']]],
  ['allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_146',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_147',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_148',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_149',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_150',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['alt_5ftoken_5fsigner_151',['alt_token_signer',['../../../RestClient/html/class_rest_client_1_1_rest_client.html#a466058cad108525b7b1b8595acef51d0',1,'RestClient::RestClient::alt_token_signer'],['../../../RestClient/html/class_rest_client_1_1_rest_connection.html#a9bb4d355a19b0b930a097a73733b991b',1,'RestClient::RestConnection::alt_token_signer']]],
  ['alt_5ftoken_5fsigner_5fheader_152',['alt_token_signer_header',['../../../RestClient/html/class_rest_client_1_1_rest_client.html#a4d28cc4171458980f92e8972274fdfb7',1,'RestClient::RestClient::alt_token_signer_header'],['../../../RestClient/html/class_rest_client_1_1_rest_connection.html#a1d7ec44048a06f272c467d433ab54d79',1,'RestClient::RestConnection::alt_token_signer_header']]],
  ['altwerase_153',['ALTWERASE',['../../../../lang/html/group__tattr__local__mode__constants.html#ga3b8b9271f15453c12ce3860e6138830e',1,'Qore::ALTWERASE'],['../../../../lang/html/group__tattr__local__mode__constants.html#ga3b8b9271f15453c12ce3860e6138830e',1,'Qore::ALTWERASE']]],
  ['an_20example_20program_20using_20this_20module_20all_20the_20symbols_20in_20the_20module_20are_20defined_20in_20the_20smtpclient_20namespace_20classes_20provided_3a_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20_3a_20manages_20a_20connection_20to_20an_20smtp_20server_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20_3a_20provides_20a_20connection_20object_20to_20an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_154',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_155',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_156',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['an_20smtp_20server_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20_3a_20provides_20a_20connection_20object_20to_20an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_157',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_158',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_159',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_160',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_161',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol suppor