if(CMAKE_HOST_WIN32)
    set(program_name python)
    set(program_version 3.11.5)
    if(VCPKG_TARGET_ARCHITECTURE STREQUAL "x86")
        set(tool_subdirectory "python-${program_version}-x86")
        set(download_urls "https://www.python.org/ftp/python/${program_version}/python-${program_version}-embed-win32.zip")
        set(download_filename "python-${program_version}-embed-win32.zip")
        set(download_sha512 d5412c5bc2a0664f86e504a536c201789c8fd8b97c641bbb7b254c87c2f13504d25fa9d0b74e27a1c54c2d9fb592f9546d8c1e82c506dc9c76a21774c4c3ea75)
    else()
        set(tool_subdirectory "python-${program_version}-x64")
        set(download_urls "https://www.python.org/ftp/python/${program_version}/python-${program_version}-embed-amd64.zip")
        set(download_filename "python-${program_version}-embed-amd64.zip")
        set(download_sha512 29a526da7624423b09ea1c8f94d83e5ad2d7ba7553c5651d8fcbe1b2483c62f27f9db105d1fdcfca3357b44d456fe1141274725bc97ad5166edfec14f251eb36)
    endif()

    set(paths_to_search "${DOWNLOADS}/tools/python/${tool_subdirectory}")
    vcpkg_list(SET post_install_command "${CMAKE_COMMAND}" -E rm python311._pth)
else()
    set(program_name python3)
    set(brew_package_name "python")
    set(apt_package_name "python3")
endif()
