from PyObjCTools.TestSupport import TestCase
import WebKit


class TestWebView(TestCase):
    def testConstants(self):
        self.assertIsInstance(WebKit.WebElementDOMNodeKey, str)
        self.assertIsInstance(WebKit.WebElementFrameKey, str)
        self.assertIsInstance(WebKit.WebElementImageAltStringKey, str)
        self.assertIsInstance(WebKit.WebElementImageKey, str)
        self.assertIsInstance(WebKit.WebElementImageRectKey, str)
        self.assertIsInstance(WebKit.WebElementImageURLKey, str)
        self.assertIsInstance(WebKit.WebElementIsSelectedKey, str)
        self.assertIsInstance(WebKit.WebElementLinkURLKey, str)
        self.assertIsInstance(WebKit.WebElementLinkTargetFrameKey, str)
        self.assertIsInstance(WebKit.WebElementLinkTitleKey, str)
        self.assertIsInstance(WebKit.WebElementLinkLabelKey, str)
        self.assertIsInstance(WebKit.WebViewProgressStartedNotification, str)
        self.assertIsInstance(WebKit.WebViewProgressEstimateChangedNotification, str)
        self.assertIsInstance(WebKit.WebViewProgressFinishedNotification, str)
        self.assertIsInstance(WebKit.WebViewDidBeginEditingNotification, str)
        self.assertIsInstance(WebKit.WebViewDidChangeNotification, str)
        self.assertIsInstance(WebKit.WebViewDidEndEditingNotification, str)
        self.assertIsInstance(WebKit.WebViewDidChangeTypingStyleNotification, str)
        self.assertIsInstance(WebKit.WebViewDidChangeSelectionNotification, str)

    def testMethods(self):
        self.assertResultIsBOOL(WebKit.WebView.canShowMIMEType_)
        self.assertResultIsBOOL(WebKit.WebView.canShowMIMETypeAsHTML_)
        self.assertResultIsBOOL(WebKit.WebView.shouldCloseWithWindow)
        self.assertArgIsBOOL(WebKit.WebView.setShouldCloseWithWindow_, 0)
        self.assertArgIsBOOL(WebKit.WebView.setMaintainsBackForwardList_, 0)
        self.assertResultIsBOOL(WebKit.WebView.goBack)
        self.assertResultIsBOOL(WebKit.WebView.goForward)
        self.assertResultIsBOOL(WebKit.WebView.goToBackForwardItem_)
        self.assertResultIsBOOL(WebKit.WebView.supportsTextEncoding)
        self.assertResultIsBOOL(WebKit.WebView.searchFor_direction_caseSensitive_wrap_)
        self.assertArgIsBOOL(WebKit.WebView.searchFor_direction_caseSensitive_wrap_, 1)
        self.assertArgIsBOOL(WebKit.WebView.searchFor_direction_caseSensitive_wrap_, 2)
        self.assertArgIsBOOL(WebKit.WebView.searchFor_direction_caseSensitive_wrap_, 3)
        self.assertResultIsBOOL(WebKit.WebView.isLoading)
        self.assertResultIsBOOL(WebKit.WebView.drawsBackground)
        self.assertArgIsBOOL(WebKit.WebView.setDrawsBackground_, 0)
        self.assertResultIsBOOL(WebKit.WebView.canGoBack)
        self.assertResultIsBOOL(WebKit.WebView.canGoForward)
        self.assertResultIsBOOL(WebKit.WebView.canMakeTextLarger)
        self.assertResultIsBOOL(WebKit.WebView.canMakeTextSmaller)
        self.assertResultIsBOOL(WebKit.WebView.canMakeTextStandardSize)
        self.assertResultIsBOOL(WebKit.WebView.maintainsInactiveSelection)
        self.assertResultIsBOOL(WebKit.WebView.isEditable)
        self.assertArgIsBOOL(WebKit.WebView.setEditable_, 0)
        self.assertResultIsBOOL(WebKit.WebView.smartInsertDeleteEnabled)
        self.assertArgIsBOOL(WebKit.WebView.setSmartInsertDeleteEnabled_, 0)
        self.assertResultIsBOOL(WebKit.WebView.isContinuousSpellCheckingEnabled)
        self.assertArgIsBOOL(WebKit.WebView.setContinuousSpellCheckingEnabled_, 0)

        self.assertArgIsBOOL(WebKit.WebView.setShouldUpdateWhileOffscreen_, 0)
        self.assertResultIsBOOL(WebKit.WebView.shouldUpdateWhileOffscreen)
