# -*- coding: utf-8 -*-
#
# msoAutoShapeType.py
#
# original source for msoAutoShapeType constants and spec definitions
#


def msdn_msoAutoShapeTypes():
    """
    Return sequence of tuples representing the msoAutoShapeType enumeration
    as defined in the MS Office API.

    Access with::

        for ms_name, id_, desc in msdn_msoAutoShapeTypes():
            ...

    This is structured as a function simply so code folding will work on it.
    """
    return (
        ('msoShape10PointStar', 149, '10-Point Star'),
        ('msoShape12PointStar', 150, '12-Point Star'),
        ('msoShape16pointStar', 94, '16-point star.'),
        ('msoShape24pointStar', 95, '24-point star.'),
        ('msoShape32pointStar', 96, '32-point star.'),
        ('msoShape4pointStar', 91, '4-point star.'),
        ('msoShape5pointStar', 92, '5-point star.'),
        ('msoShape6PointStar', 147, '6-Point Star'),
        ('msoShape7PointStar', 148, '7-Point Star'),
        ('msoShape8pointStar', 93, '8-point star.'),
        ('msoShapeActionButtonBackorPrevious', 129,
         'Back or Previous button. Supports mouse-click and mouse-over actio'
         'ns.'),
        ('msoShapeActionButtonBeginning', 131,
         'Beginning button. Supports mouse-click and mouse-over actions.'),
        ('msoShapeActionButtonCustom', 125,
         'Button with no default picture or text. Supports mouse-click and m'
         'ouse-over actions.'),
        ('msoShapeActionButtonDocument', 134,
         'Document button. Supports mouse-click and mouse-over actions.'),
        ('msoShapeActionButtonEnd', 132,
         'End button. Supports mouse-click and mouse-over actions.'),
        ('msoShapeActionButtonForwardorNext', 130,
         'Forward or Next button. Supports mouse-click and mouse-over action'
         's.'),
        ('msoShapeActionButtonHelp', 127,
         'Help button. Supports mouse-click and mouse-over actions.'),
        ('msoShapeActionButtonHome', 126,
         'Home button. Supports mouse-click and mouse-over actions.'),
        ('msoShapeActionButtonInformation', 128,
         'Information button. Supports mouse-click and mouse-over actions.'),
        ('msoShapeActionButtonMovie', 136,
         'Movie button. Supports mouse-click and mouse-over actions.'),
        ('msoShapeActionButtonReturn', 133,
         'Return button. Supports mouse-click and mouse-over actions.'),
        ('msoShapeActionButtonSound', 135,
         'Sound button. Supports mouse-click and mouse-over actions.'),
        ('msoShapeArc', 25, 'Arc.'),
        ('msoShapeBalloon', 137, 'Balloon.'),
        ('msoShapeBentArrow', 41,
         'Block arrow that follows a curved 90-degree angle.'),
        ('msoShapeBentUpArrow', 44,
         'Block arrow that follows a sharp 90-degree angle. Points up by def'
         'ault.'),
        ('msoShapeBevel', 15, 'Bevel.'),
        ('msoShapeBlockArc', 20, 'Block arc.'),
        ('msoShapeCan', 13, 'Can.'),
        ('msoShapeChartPlus', 182, 'Chart Plus'),
        ('msoShapeChartStar', 181, 'Chart Star'),
        ('msoShapeChartX', 180, 'Chart X'),
        ('msoShapeChevron', 52, 'Chevron.'),
        ('msoShapeChord', 161, 'Geometric chord shape'),
        ('msoShapeCircularArrow', 60,
         'Block arrow that follows a curved 180-degree angle.'),
        ('msoShapeCloud', 179, 'Cloud'),
        ('msoShapeCloudCallout', 108, 'Cloud callout.'),
        ('msoShapeCorner', 162, 'Corner'),
        ('msoShapeCornerTabs', 169, 'Corner Tabs'),
        ('msoShapeCross', 11, 'Cross.'),
        ('msoShapeCube', 14, 'Cube.'),
        ('msoShapeCurvedDownArrow', 48, 'Block arrow that curves down.'),
        ('msoShapeCurvedDownRibbon', 100, 'Ribbon banner that curves down.'),
        ('msoShapeCurvedLeftArrow', 46, 'Block arrow that curves left.'),
        ('msoShapeCurvedRightArrow', 45, 'Block arrow that curves right.'),
        ('msoShapeCurvedUpArrow', 47, 'Block arrow that curves up.'),
        ('msoShapeCurvedUpRibbon', 99, 'Ribbon banner that curves up.'),
        ('msoShapeDecagon', 144, 'Decagon'),
        ('msoShapeDiagonalStripe', 141, 'Diagonal Stripe'),
        ('msoShapeDiamond', 4, 'Diamond'),
        ('msoShapeDodecagon', 146, 'Dodecagon'),
        ('msoShapeDonut', 18, 'Donut.'),
        ('msoShapeDoubleBrace', 27, 'Double brace.'),
        ('msoShapeDoubleBracket', 26, 'Double bracket.'),
        ('msoShapeDoubleWave', 104, 'Double wave.'),
        ('msoShapeDownArrow', 36, 'Block arrow that points down.'),
        ('msoShapeDownArrowCallout', 56,
         'Callout with arrow that points down.'),
        ('msoShapeDownRibbon', 98,
         'Ribbon banner with center area below ribbon ends.'),
        ('msoShapeExplosion1', 89, 'Explosion.'),
        ('msoShapeExplosion2', 90, 'Explosion.'),
        ('msoShapeFlowchartAlternateProcess', 62,
         'Alternate process flowchart symbol.'),
        ('msoShapeFlowchartCard', 75, 'Card flowchart symbol.'),
        ('msoShapeFlowchartCollate', 79, 'Collate flowchart symbol.'),
        ('msoShapeFlowchartConnector', 73, 'Connector flowchart symbol.'),
        ('msoShapeFlowchartData', 64, 'Data flowchart symbol.'),
        ('msoShapeFlowchartDecision', 63, 'Decision flowchart symbol.'),
        ('msoShapeFlowchartDelay', 84, 'Delay flowchart symbol.'),
        ('msoShapeFlowchartDirectAccessStorage', 87,
         'Direct access storage flowchart symbol.'),
        ('msoShapeFlowchartDisplay', 88, 'Display flowchart symbol.'),
        ('msoShapeFlowchartDocument', 67, 'Document flowchart symbol.'),
        ('msoShapeFlowchartExtract', 81, 'Extract flowchart symbol.'),
        ('msoShapeFlowchartInternalStorage', 66,
         'Internal storage flowchart symbol.'),
        ('msoShapeFlowchartMagneticDisk', 86,
         'Magnetic disk flowchart symbol.'),
        ('msoShapeFlowchartManualInput', 71,
         'Manual input flowchart symbol.'),
        ('msoShapeFlowchartManualOperation', 72,
         'Manual operation flowchart symbol.'),
        ('msoShapeFlowchartMerge', 82, 'Merge flowchart symbol.'),
        ('msoShapeFlowchartMultidocument', 68,
         'Multi-document flowchart symbol.'),
        ('msoShapeFlowchartOfflineStorage', 139, 'Offline Storage'),
        ('msoShapeFlowchartOffpageConnector', 74,
         'Off-page connector flowchart symbol.'),
        ('msoShapeFlowchartOr', 78, '"Or" flowchart symbol.'),
        ('msoShapeFlowchartPredefinedProcess', 65,
         'Predefined process flowchart symbol.'),
        ('msoShapeFlowchartPreparation', 70,
         'Preparation flowchart symbol.'),
        ('msoShapeFlowchartProcess', 61, 'Process flowchart symbol.'),
        ('msoShapeFlowchartPunchedTape', 76,
         'Punched tape flowchart symbol.'),
        ('msoShapeFlowchartSequentialAccessStorage', 85,
         'Sequential access storage flowchart symbol.'),
        ('msoShapeFlowchartSort', 80, 'Sort flowchart symbol.'),
        ('msoShapeFlowchartStoredData', 83, 'Stored data flowchart symbol.'),
        ('msoShapeFlowchartSummingJunction', 77,
         'Summing junction flowchart symbol.'),
        ('msoShapeFlowchartTerminator', 69, 'Terminator flowchart symbol.'),
        ('msoShapeFoldedCorner', 16, 'Folded corner.'),
        ('msoShapeFrame', 158, 'Frame'),
        ('msoShapeFunnel', 174, 'Funnel'),
        ('msoShapeGear6', 172, 'Gear 6'),
        ('msoShapeGear9', 173, 'Gear 9'),
        ('msoShapeHalfFrame', 159, 'Half Frame'),
        ('msoShapeHeart', 21, 'Heart.'),
        ('msoShapeHeptagon', 145, 'Heptagon'),
        ('msoShapeHexagon', 10, 'Hexagon.'),
        ('msoShapeHorizontalScroll', 102, 'Horizontal scroll.'),
        ('msoShapeIsoscelesTriangle', 7, 'Isosceles triangle.'),
        ('msoShapeLeftArrow', 34, 'Block arrow that points left.'),
        ('msoShapeLeftArrowCallout', 54,
         'Callout with arrow that points left.'),
        ('msoShapeLeftBrace', 31, 'Left brace.'),
        ('msoShapeLeftBracket', 29, 'Left bracket.'),
        ('msoShapeLeftCircularArrow', 176, 'Left Circular Arrow'),
        ('msoShapeLeftRightArrow', 37,
         'Block arrow with arrowheads that point both left and right.'),
        ('msoShapeLeftRightArrowCallout', 57,
         'Callout with arrowheads that point both left and right.'),
        ('msoShapeLeftRightCircularArrow', 177, 'Left Right Circular Arrow'),
        ('msoShapeLeftRightRibbon', 140, 'Left Right Ribbon'),
        ('msoShapeLeftRightUpArrow', 40,
         'Block arrow with arrowheads that point left, right, and up.'),
        ('msoShapeLeftUpArrow', 43,
         'Block arrow with arrowheads that point left and up.'),
        ('msoShapeLightningBolt', 22, 'Lightning bolt.'),
        ('msoShapeLineCallout1', 109,
         'Callout with border and horizontal callout line.'),
        ('msoShapeLineCallout1AccentBar', 113,
         'Callout with horizontal accent bar.'),
        ('msoShapeLineCallout1BorderandAccentBar', 121,
         'Callout with border and horizontal accent bar.'),
        ('msoShapeLineCallout1NoBorder', 117,
         'Callout with horizontal line.'),
        ('msoShapeLineCallout2', 110,
         'Callout with diagonal straight line.'),
        ('msoShapeLineCallout2AccentBar', 114,
         'Callout with diagonal callout line and accent bar.'),
        ('msoShapeLineCallout2BorderandAccentBar', 122,
         'Callout with border, diagonal straight line, and accent bar.'),
        ('msoShapeLineCallout2NoBorder', 118,
         'Callout with no border and diagonal callout line.'),
        ('msoShapeLineCallout3', 111, 'Callout with angled line.'),
        ('msoShapeLineCallout3AccentBar', 115,
         'Callout with angled callout line and accent bar.'),
        ('msoShapeLineCallout3BorderandAccentBar', 123,
         'Callout with border, angled callout line, and accent bar.'),
        ('msoShapeLineCallout3NoBorder', 119,
         'Callout with no border and angled callout line.'),
        ('msoShapeLineCallout4', 112,
         'Callout with callout line segments forming a U-shape.'),
        ('msoShapeLineCallout4AccentBar', 116,
         'Callout with accent bar and callout line segments forming a U-shap'
         'e.'),
        ('msoShapeLineCallout4BorderandAccentBar', 124,
         'Callout with border, accent bar, and callout line segments forming'
         'a U-shape.'),
        ('msoShapeLineCallout4NoBorder', 120,
         'Callout with no border and callout line segments forming a U-shape'
         '.'),
        ('msoShapeLineInverse', 183, 'Straight Connector'),
        ('msoShapeMathDivide', 166, 'Division'),
        ('msoShapeMathEqual', 167, 'Equal'),
        ('msoShapeMathMinus', 164, 'Minus'),
        ('msoShapeMathMultiply', 165, 'Multiply'),
        ('msoShapeMathNotEqual', 168, 'Not Equal'),
        ('msoShapeMathPlus', 163, 'Plus'),
        ('msoShapeMoon', 24, 'Moon.'),
        ('msoShapeNoSymbol', 19, '"No" symbol.'),
        ('msoShapeNonIsoscelesTrapezoid', 143, 'Non-isosceles Trapezoid'),
        ('msoShapeNotPrimitive', 138, 'Not supported.'),
        ('msoShapeNotchedRightArrow', 50,
         'Notched block arrow that points right.'),
        ('msoShapeOctagon', 6, 'Octagon'),
        ('msoShapeOval', 9, 'Oval'),
        ('msoShapeOvalCallout', 107, 'Oval-shaped callout.'),
        ('msoShapeParallelogram', 2, 'Parallelogram'),
        ('msoShapePentagon', 51, 'Pentagon.'),
        ('msoShapePie', 142, 'Pie'),
        ('msoShapePieWedge', 175, 'Pie'),
        ('msoShapePlaque', 28, 'Plaque.'),
        ('msoShapePlaqueTabs', 171, 'Plaque Tabs'),
        ('msoShapeQuadArrow', 39,
         'Block arrows that point up, down, left, and right.'),
        ('msoShapeQuadArrowCallout', 59,
         'Callout with arrows that point up, down, left, and right.'),
        ('msoShapeRectangle', 1, 'Rectangle'),
        ('msoShapeRectangularCallout', 105, 'Rectangular callout.'),
        ('msoShapeRegularPentagon', 12, 'Pentagon.'),
        ('msoShapeRightArrow', 33, 'Block arrow that points right.'),
        ('msoShapeRightArrowCallout', 53,
         'Callout with arrow that points right.'),
        ('msoShapeRightBrace', 32, 'Right brace.'),
        ('msoShapeRightBracket', 30, 'Right bracket.'),
        ('msoShapeRightTriangle', 8, 'Right triangle.'),
        ('msoShapeRound1Rectangle', 151, 'Round Single Corner Rectangle'),
        ('msoShapeRound2DiagRectangle', 153,
         'Round Diagonal Corner Rectangle'),
        ('msoShapeRound2SameRectangle', 152,
         'Round Same Side Corner Rectangle'),
        ('msoShapeRoundedRectangle', 5, 'Rounded rectangle.'),
        ('msoShapeRoundedRectangularCallout', 106,
         'Rounded rectangle-shaped callout.'),
        ('msoShapeSmileyFace', 17, 'Smiley face.'),
        ('msoShapeSnip1Rectangle', 155, 'Snip Single Corner Rectangle'),
        ('msoShapeSnip2DiagRectangle', 157,
         'Snip Diagonal Corner Rectangle'),
        ('msoShapeSnip2SameRectangle', 156,
         'Snip Same Side Corner Rectangle'),
        ('msoShapeSnipRoundRectangle', 154,
         'Snip and Round Single Corner Rectangle'),
        ('msoShapeSquareTabs', 170, 'Square Tabs'),
        ('msoShapeStripedRightArrow', 49,
         'Block arrow that points right with stripes at the tail.'),
        ('msoShapeSun', 23, 'Sun.'),
        ('msoShapeSwooshArrow', 178, 'Swoosh Arrow'),
        ('msoShapeTear', 160, 'Teardrop'),
        ('msoShapeTrapezoid', 3, 'Trapezoid'),
        ('msoShapeUTurnArrow', 42, 'Block arrow forming a U shape.'),
        ('msoShapeUpArrow', 35, 'Block arrow that points up.'),
        ('msoShapeUpArrowCallout', 55, 'Callout with arrow that points up.'),
        ('msoShapeUpDownArrow', 38, 'Block arrow that points up and down.'),
        ('msoShapeUpDownArrowCallout', 58,
         'Callout with arrows that point up and down.'),
        ('msoShapeUpRibbon', 97,
         'Ribbon banner with center area above ribbon ends.'),
        ('msoShapeVerticalScroll', 101, 'Vertical scroll.'),
        ('msoShapeWave', 103, 'Wave.')
    )


def prst_map():
    """
    Sequence of tuples representing the mapping of names in the
    msoAutoShapeType enumeration to the 'prst' and 'name' values used in the
    XML to specify and identify that auto shape type. These were discovered
    using the VBA editor in PowerPoint for Windows.

    Access with::

        for ms_name, prst, base_name in prst_map():
            ...

    """
    return (
        ('msoShape10PointStar', 'star10', '10-Point Star'),
        ('msoShape12PointStar', 'star12', '12-Point Star'),
        ('msoShape16pointStar', 'star16', '16-Point Star'),
        ('msoShape24pointStar', 'star24', '24-Point Star'),
        ('msoShape32pointStar', 'star32', '32-Point Star'),
        ('msoShape4pointStar', 'star4', '4-Point Star'),
        ('msoShape5pointStar', 'star5', '5-Point Star'),
        ('msoShape6PointStar', 'star6', '6-Point Star'),
        ('msoShape7PointStar', 'star7', '7-Point Star'),
        ('msoShape8pointStar', 'star8', '8-Point Star'),
        ('msoShapeActionButtonBackorPrevious', 'actionButtonBackPrevious',
         'Action Button: Back or Previous'),
        ('msoShapeActionButtonBeginning', 'actionButtonBeginning',
         'Action Button: Beginning'),
        ('msoShapeActionButtonCustom', 'actionButtonBlank',
         'Action Button: Custom'),
        ('msoShapeActionButtonDocument', 'actionButtonDocument',
         'Action Button: Document'),
        ('msoShapeActionButtonEnd', 'actionButtonEnd', 'Action Button: End'),
        ('msoShapeActionButtonForwardorNext', 'actionButtonForwardNext',
         'Action Button: Forward or Next'),
        ('msoShapeActionButtonHelp', 'actionButtonHelp',
         'Action Button: Help'),
        ('msoShapeActionButtonHome', 'actionButtonHome',
         'Action Button: Home'),
        ('msoShapeActionButtonInformation', 'actionButtonInformation',
         'Action Button: Information'),
        ('msoShapeActionButtonMovie', 'actionButtonMovie',
         'Action Button: Movie'),
        ('msoShapeActionButtonReturn', 'actionButtonReturn',
         'Action Button: Return'),
        ('msoShapeActionButtonSound', 'actionButtonSound',
         'Action Button: Sound'),
        ('msoShapeArc', 'arc', 'Arc'),
        ('msoShapeBalloon', 'wedgeRoundRectCallout',
         'Rounded Rectangular Callout'),
        ('msoShapeBentArrow', 'bentArrow', 'Bent Arrow'),
        ('msoShapeBentUpArrow', 'bentUpArrow', 'Bent-Up Arrow'),
        ('msoShapeBevel', 'bevel', 'Bevel'),
        ('msoShapeBlockArc', 'blockArc', 'Block Arc'),
        ('msoShapeCan', 'can', 'Can'),
        ('msoShapeChartPlus', 'chartPlus', 'Chart Plus'),
        ('msoShapeChartStar', 'chartStar', 'Chart Star'),
        ('msoShapeChartX', 'chartX', 'Chart X'),
        ('msoShapeChevron', 'chevron', 'Chevron'),
        ('msoShapeChord', 'chord', 'Chord'),
        ('msoShapeCircularArrow', 'circularArrow', 'Circular Arrow'),
        ('msoShapeCloud', 'cloud', 'Cloud'),
        ('msoShapeCloudCallout', 'cloudCallout', 'Cloud Callout'),
        ('msoShapeCorner', 'corner', 'Corner'),
        ('msoShapeCornerTabs', 'cornerTabs', 'Corner Tabs'),
        ('msoShapeCross', 'plus', 'Cross'),
        ('msoShapeCube', 'cube', 'Cube'),
        ('msoShapeCurvedDownArrow', 'curvedDownArrow', 'Curved Down Arrow'),
        ('msoShapeCurvedDownRibbon', 'ellipseRibbon', 'Curved Down Ribbon'),
        ('msoShapeCurvedLeftArrow', 'curvedLeftArrow', 'Curved Left Arrow'),
        ('msoShapeCurvedRightArrow', 'curvedRightArrow',
         'Curved Right Arrow'),
        ('msoShapeCurvedUpArrow', 'curvedUpArrow', 'Curved Up Arrow'),
        ('msoShapeCurvedUpRibbon', 'ellipseRibbon2', 'Curved Up Ribbon'),
        ('msoShapeDecagon', 'decagon', 'Decagon'),
        ('msoShapeDiagonalStripe', 'diagStripe', 'Diagonal Stripe'),
        ('msoShapeDiamond', 'diamond', 'Diamond'),
        ('msoShapeDodecagon', 'dodecagon', 'Dodecagon'),
        ('msoShapeDonut', 'donut', 'Donut'),
        ('msoShapeDoubleBrace', 'bracePair', 'Double Brace'),
        ('msoShapeDoubleBracket', 'bracketPair', 'Double Bracket'),
        ('msoShapeDoubleWave', 'doubleWave', 'Double Wave'),
        ('msoShapeDownArrow', 'downArrow', 'Down Arrow'),
        ('msoShapeDownArrowCallout', 'downArrowCallout', 'Down Arrow Callout'),
        ('msoShapeDownRibbon', 'ribbon', 'Down Ribbon'),
        ('msoShapeExplosion1', 'irregularSeal1', 'Explosion'),
        ('msoShapeExplosion2', 'irregularSeal2', 'Explosion'),
        ('msoShapeFlowchartAlternateProcess', 'flowChartAlternateProcess',
         'Alternate process'),
        ('msoShapeFlowchartCard', 'flowChartPunchedCard', 'Card'),
        ('msoShapeFlowchartCollate', 'flowChartCollate', 'Collate'),
        ('msoShapeFlowchartConnector', 'flowChartConnector', 'Connector'),
        ('msoShapeFlowchartData', 'flowChartInputOutput', 'Data'),
        ('msoShapeFlowchartDecision', 'flowChartDecision', 'Decision'),
        ('msoShapeFlowchartDelay', 'flowChartDelay', 'Delay'),
        ('msoShapeFlowchartDirectAccessStorage', 'flowChartMagneticDrum',
         'Direct Access Storage'),
        ('msoShapeFlowchartDisplay', 'flowChartDisplay', 'Display'),
        ('msoShapeFlowchartDocument', 'flowChartDocument', 'Document'),
        ('msoShapeFlowchartExtract', 'flowChartExtract', 'Extract'),
        ('msoShapeFlowchartInternalStorage', 'flowChartInternalStorage',
         'Internal Storage'),
        ('msoShapeFlowchartMagneticDisk', 'flowChartMagneticDisk',
         'Magnetic Disk'),
        ('msoShapeFlowchartManualInput', 'flowChartManualInput',
         'Manual Input'),
        ('msoShapeFlowchartManualOperation', 'flowChartManualOperation',
         'Manual Operation'),
        ('msoShapeFlowchartMerge', 'flowChartMerge', 'Merge'),
        ('msoShapeFlowchartMultidocument', 'flowChartMultidocument',
         'Multidocument'),
        ('msoShapeFlowchartOfflineStorage', 'flowChartOfflineStorage',
         'Offline Storage'),
        ('msoShapeFlowchartOffpageConnector', 'flowChartOffpageConnector',
         'Off-page Connector'),
        ('msoShapeFlowchartOr', 'flowChartOr', 'Or'),
        ('msoShapeFlowchartPredefinedProcess', 'flowChartPredefinedProcess',
         'Predefined Process'),
        ('msoShapeFlowchartPreparation', 'flowChartPreparation',
         'Preparation'),
        ('msoShapeFlowchartProcess', 'flowChartProcess', 'Process'),
        ('msoShapeFlowchartPunchedTape', 'flowChartPunchedTape',
         'Punched Tape'),
        ('msoShapeFlowchartSequentialAccessStorage',
         'flowChartMagneticTape', 'Sequential Access Storage'),
        ('msoShapeFlowchartSort', 'flowChartSort', 'Sort'),
        ('msoShapeFlowchartStoredData', 'flowChartOnlineStorage',
         'Stored Data'),
        ('msoShapeFlowchartSummingJunction', 'flowChartSummingJunction',
         'Summing Junction'),
        ('msoShapeFlowchartTerminator', 'flowChartTerminator', 'Terminator'),
        ('msoShapeFoldedCorner', 'folderCorner', 'Folded Corner'),
        ('msoShapeFrame', 'frame', 'Frame'),
        ('msoShapeFunnel', 'funnel', 'Funnel'),
        ('msoShapeGear6', 'gear6', 'Gear 6'),
        ('msoShapeGear9', 'gear9', 'Gear 9'),
        ('msoShapeHalfFrame', 'halfFrame', 'Half Frame'),
        ('msoShapeHeart', 'heart', 'Heart'),
        ('msoShapeHeptagon', 'heptagon', 'Heptagon'),
        ('msoShapeHexagon', 'hexagon', 'Hexagon'),
        ('msoShapeHorizontalScroll', 'horizontalScroll',
         'Horizontal Scroll'),
        ('msoShapeIsoscelesTriangle', 'triangle', 'Isosceles Triangle'),
        ('msoShapeLeftArrow', 'leftArrow', 'Left Arrow'),
        ('msoShapeLeftArrowCallout', 'leftArrowCallout',
         'Left Arrow Callout'),
        ('msoShapeLeftBrace', 'leftBrace', 'Left Brace'),
        ('msoShapeLeftBracket', 'leftBracket', 'Left Bracket'),
        ('msoShapeLeftCircularArrow', 'leftCircularArrow',
         'Left Circular Arrow'),
        ('msoShapeLeftRightArrow', 'leftRightArrow', 'Left-Right Arrow'),
        ('msoShapeLeftRightArrowCallout', 'leftRightArrowCallout',
         'Left-Right Arrow Callout'),
        ('msoShapeLeftRightCircularArrow', 'leftRightCircularArrow',
         'Left Right Circular Arrow'),
        ('msoShapeLeftRightRibbon', 'leftRightRibbon', 'Left Right Ribbon'),
        ('msoShapeLeftRightUpArrow', 'leftRightUpArrow',
         'Left-Right-Up Arrow'),
        ('msoShapeLeftUpArrow', 'leftUpArrow', 'Left-Up Arrow'),
        ('msoShapeLightningBolt', 'lightningBolt', 'Lightning Bolt'),
        ('msoShapeLineCallout1', 'borderCallout1', 'Line Callout 1'),
        ('msoShapeLineCallout1AccentBar', 'accentCallout1',
         'Line Callout 1 (Accent Bar)'),
        ('msoShapeLineCallout1BorderandAccentBar', 'accentBorderCallout1',
         'Line Callout 1 (Border and Accent Bar)'),
        ('msoShapeLineCallout1NoBorder', 'callout1',
         'Line Callout 1 (No Border)'),
        ('msoShapeLineCallout2', 'borderCallout2', 'Line Callout 2'),
        ('msoShapeLineCallout2AccentBar', 'accentCallout2',
         'Line Callout 2 (Accent Bar)'),
        ('msoShapeLineCallout2BorderandAccentBar', 'accentBorderCallout2',
         'Line Callout 2 (Border and Accent Bar)'),
        ('msoShapeLineCallout2NoBorder', 'callout2',
         'Line Callout 2 (No Border)'),
        ('msoShapeLineCallout3', 'borderCallout3', 'Line Callout 3'),
        ('msoShapeLineCallout3AccentBar', 'accentCallout3',
         'Line Callout 3 (Accent Bar)'),
        ('msoShapeLineCallout3BorderandAccentBar', 'accentBorderCallout3',
         'Line Callout 3 (Border and Accent Bar)'),
        ('msoShapeLineCallout3NoBorder', 'callout3',
         'Line Callout 3 (No Border)'),
        ('msoShapeLineCallout4', 'borderCallout3', 'Line Callout 3'),
        ('msoShapeLineCallout4AccentBar', 'accentCallout3',
         'Line Callout 3 (Accent Bar)'),
        ('msoShapeLineCallout4BorderandAccentBar', 'accentBorderCallout3',
         'Line Callout 3 (Border and Accent Bar)'),
        ('msoShapeLineCallout4NoBorder', 'callout3',
         'Line Callout 3 (No Border)'),
        ('msoShapeLineInverse', 'lineInv', 'Straight Connector'),
        ('msoShapeMathDivide', 'mathDivide', 'Division'),
        ('msoShapeMathEqual', 'mathEqual', 'Equal'),
        ('msoShapeMathMinus', 'mathMinus', 'Minus'),
        ('msoShapeMathMultiply', 'mathMultiply', 'Multiply'),
        ('msoShapeMathNotEqual', 'mathNotEqual', 'Not Equal'),
        ('msoShapeMathPlus', 'mathPlus', 'Plus'),
        ('msoShapeMoon', 'moon', 'Moon'),
        ('msoShapeNoSymbol', 'noSmoking', '"No" symbol'),
        ('msoShapeNonIsoscelesTrapezoid', 'nonIsoscelesTrapezoid',
         'Non-isosceles Trapezoid'),
        ('msoShapeNotchedRightArrow', 'notchedRightArrow',
         'Notched Right Arrow'),
        ('msoShapeOctagon', 'octagon', 'Octagon'),
        ('msoShapeOval', 'ellipse', 'Oval'),
        ('msoShapeOvalCallout', 'wedgeEllipseCallout', 'Oval Callout'),
        ('msoShapeParallelogram', 'parallelogram', 'Parallelogram'),
        ('msoShapePentagon', 'homePlate', 'Pentagon'),
        ('msoShapePie', 'pie', 'Pie'),
        ('msoShapePieWedge', 'pieWedge', 'Pie'),
        ('msoShapePlaque', 'plaque', 'Plaque'),
        ('msoShapePlaqueTabs', 'plaqueTabs', 'Plaque Tabs'),
        ('msoShapeQuadArrow', 'quadArrow', 'Quad Arrow'),
        ('msoShapeQuadArrowCallout', 'quadArrowCallout',
         'Quad Arrow Callout'),
        ('msoShapeRectangle', 'rect', 'Rectangle'),
        ('msoShapeRectangularCallout', 'wedgeRectCallout',
         'Rectangular Callout'),
        ('msoShapeRegularPentagon', 'pentagon', 'Regular Pentagon'),
        ('msoShapeRightArrow', 'rightArrow', 'Right Arrow'),
        ('msoShapeRightArrowCallout', 'rightArrowCallout',
         'Right Arrow Callout'),
        ('msoShapeRightBrace', 'rightBrace', 'Right Brace'),
        ('msoShapeRightBracket', 'rightBracket', 'Right Bracket'),
        ('msoShapeRightTriangle', 'rtTriangle', 'Right Triangle'),
        ('msoShapeRound1Rectangle', 'round1Rect',
         'Round Single Corner Rectangle'),
        ('msoShapeRound2DiagRectangle', 'round2DiagRect',
         'Round Diagonal Corner Rectangle'),
        ('msoShapeRound2SameRectangle', 'round2SameRect',
         'Round Same Side Corner Rectangle'),
        ('msoShapeRoundedRectangle', 'roundRect', 'Rounded Rectangle'),
        ('msoShapeRoundedRectangularCallout', 'wedgeRoundRectCallout',
         'Rounded Rectangular Callout'),
        ('msoShapeSmileyFace', 'smileyFace', 'Smiley Face'),
        ('msoShapeSnip1Rectangle', 'snip1Rect',
         'Snip Single Corner Rectangle'),
        ('msoShapeSnip2DiagRectangle', 'snip2DiagRect',
         'Snip Diagonal Corner Rectangle'),
        ('msoShapeSnip2SameRectangle', 'snip2SameRect',
         'Snip Same Side Corner Rectangle'),
        ('msoShapeSnipRoundRectangle', 'snipRoundRect',
         'Snip and Round Single Corner Rectangle'),
        ('msoShapeSquareTabs', 'squareTabs', 'Square Tabs'),
        ('msoShapeStripedRightArrow', 'stripedRightArrow',
         'Striped Right Arrow'),
        ('msoShapeSun', 'sun', 'Sun'),
        ('msoShapeSwooshArrow', 'swooshArrow', 'Swoosh Arrow'),
        ('msoShapeTear', 'teardrop', 'Teardrop'),
        ('msoShapeTrapezoid', 'trapezoid', 'Trapezoid'),
        ('msoShapeUTurnArrow', 'uturnArrow', 'U-Turn Arrow'),
        ('msoShapeUpArrow', 'upArrow', 'Up Arrow'),
        ('msoShapeUpArrowCallout', 'upArrowCallout', 'Up Arrow Callout'),
        ('msoShapeUpDownArrow', 'upDownArrow', 'Up-Down Arrow'),
        ('msoShapeUpDownArrowCallout', 'upDownArrowCallout',
         'Up-Down Arrow Callout'),
        ('msoShapeUpRibbon', 'ribbon2', 'Up Ribbon'),
        ('msoShapeVerticalScroll', 'verticalScroll', 'Vertical Scroll'),
        ('msoShapeWave', 'wave', 'Wave')
    )


def const_name_map():
    """
    Sequence of tuples representing the mapping of msoAutoShapeType
    enumeration names to the constant names used in python-pptx to identify
    an auto shape type. The mapping is largely coercing the camel case to
    upper snake case, but some names produced by that transformation require
    transformation to be suitable.

    Access with::

        for ms_name, const_name in const_name_map():
            ...

    """
    return (
        ('msoShape10PointStar', 'STAR_10_POINT'),
        ('msoShape12PointStar', 'STAR_12_POINT'),
        ('msoShape16pointStar', 'STAR_16_POINT'),
        ('msoShape24pointStar', 'STAR_24_POINT'),
        ('msoShape32pointStar', 'STAR_32_POINT'),
        ('msoShape4pointStar', 'STAR_4_POINT'),
        ('msoShape5pointStar', 'STAR_5_POINT'),
        ('msoShape6PointStar', 'STAR_6_POINT'),
        ('msoShape7PointStar', 'STAR_7_POINT'),
        ('msoShape8pointStar', 'STAR_8_POINT'),
        ('msoShapeActionButtonBackorPrevious',
         'ACTION_BUTTON_BACK_OR_PREVIOUS'),
        ('msoShapeActionButtonBeginning', 'ACTION_BUTTON_BEGINNING'),
        ('msoShapeActionButtonCustom', 'ACTION_BUTTON_CUSTOM'),
        ('msoShapeActionButtonDocument', 'ACTION_BUTTON_DOCUMENT'),
        ('msoShapeActionButtonEnd', 'ACTION_BUTTON_END'),
        ('msoShapeActionButtonForwardorNext',
         'ACTION_BUTTON_FORWARD_OR_NEXT'),
        ('msoShapeActionButtonHelp', 'ACTION_BUTTON_HELP'),
        ('msoShapeActionButtonHome', 'ACTION_BUTTON_HOME'),
        ('msoShapeActionButtonInformation', 'ACTION_BUTTON_INFORMATION'),
        ('msoShapeActionButtonMovie', 'ACTION_BUTTON_MOVIE'),
        ('msoShapeActionButtonReturn', 'ACTION_BUTTON_RETURN'),
        ('msoShapeActionButtonSound', 'ACTION_BUTTON_SOUND'),
        ('msoShapeArc', 'ARC'),
        ('msoShapeBalloon', 'BALLOON'),
        ('msoShapeBentArrow', 'BENT_ARROW'),
        ('msoShapeBentUpArrow', 'BENT_UP_ARROW'),
        ('msoShapeBevel', 'BEVEL'),
        ('msoShapeBlockArc', 'BLOCK_ARC'),
        ('msoShapeCan', 'CAN'),
        ('msoShapeChartPlus', 'CHART_PLUS'),
        ('msoShapeChartStar', 'CHART_STAR'),
        ('msoShapeChartX', 'CHART_X'),
        ('msoShapeChevron', 'CHEVRON'),
        ('msoShapeChord', 'CHORD'),
        ('msoShapeCircularArrow', 'CIRCULAR_ARROW'),
        ('msoShapeCloud', 'CLOUD'),
        ('msoShapeCloudCallout', 'CLOUD_CALLOUT'),
        ('msoShapeCorner', 'CORNER'),
        ('msoShapeCornerTabs', 'CORNER_TABS'),
        ('msoShapeCross', 'CROSS'),
        ('msoShapeCube', 'CUBE'),
        ('msoShapeCurvedDownArrow', 'CURVED_DOWN_ARROW'),
        ('msoShapeCurvedDownRibbon', 'CURVED_DOWN_RIBBON'),
        ('msoShapeCurvedLeftArrow', 'CURVED_LEFT_ARROW'),
        ('msoShapeCurvedRightArrow', 'CURVED_RIGHT_ARROW'),
        ('msoShapeCurvedUpArrow', 'CURVED_UP_ARROW'),
        ('msoShapeCurvedUpRibbon', 'CURVED_UP_RIBBON'),
        ('msoShapeDecagon', 'DECAGON'),
        ('msoShapeDiagonalStripe', 'DIAGONAL_STRIPE'),
        ('msoShapeDiamond', 'DIAMOND'),
        ('msoShapeDodecagon', 'DODECAGON'),
        ('msoShapeDonut', 'DONUT'),
        ('msoShapeDoubleBrace', 'DOUBLE_BRACE'),
        ('msoShapeDoubleBracket', 'DOUBLE_BRACKET'),
        ('msoShapeDoubleWave', 'DOUBLE_WAVE'),
        ('msoShapeDownArrow', 'DOWN_ARROW'),
        ('msoShapeDownArrowCallout', 'DOWN_ARROW_CALLOUT'),
        ('msoShapeDownRibbon', 'DOWN_RIBBON'),
        ('msoShapeExplosion1', 'EXPLOSION1'),
        ('msoShapeExplosion2', 'EXPLOSION2'),
        ('msoShapeFlowchartAlternateProcess', 'FLOWCHART_ALTERNATE_PROCESS'),
        ('msoShapeFlowchartCard', 'FLOWCHART_CARD'),
        ('msoShapeFlowchartCollate', 'FLOWCHART_COLLATE'),
        ('msoShapeFlowchartConnector', 'FLOWCHART_CONNECTOR'),
        ('msoShapeFlowchartData', 'FLOWCHART_DATA'),
        ('msoShapeFlowchartDecision', 'FLOWCHART_DECISION'),
        ('msoShapeFlowchartDelay', 'FLOWCHART_DELAY'),
        ('msoShapeFlowchartDirectAccessStorage',
         'FLOWCHART_DIRECT_ACCESS_STORAGE'),
        ('msoShapeFlowchartDisplay', 'FLOWCHART_DISPLAY'),
        ('msoShapeFlowchartDocument', 'FLOWCHART_DOCUMENT'),
        ('msoShapeFlowchartExtract', 'FLOWCHART_EXTRACT'),
        ('msoShapeFlowchartInternalStorage', 'FLOWCHART_INTERNAL_STORAGE'),
        ('msoShapeFlowchartMagneticDisk', 'FLOWCHART_MAGNETIC_DISK'),
        ('msoShapeFlowchartManualInput', 'FLOWCHART_MANUAL_INPUT'),
        ('msoShapeFlowchartManualOperation', 'FLOWCHART_MANUAL_OPERATION'),
        ('msoShapeFlowchartMerge', 'FLOWCHART_MERGE'),
        ('msoShapeFlowchartMultidocument', 'FLOWCHART_MULTIDOCUMENT'),
        ('msoShapeFlowchartOfflineStorage', 'FLOWCHART_OFFLINE_STORAGE'),
        ('msoShapeFlowchartOffpageConnector', 'FLOWCHART_OFFPAGE_CONNECTOR'),
        ('msoShapeFlowchartOr', 'FLOWCHART_OR'),
        ('msoShapeFlowchartPredefinedProcess',
         'FLOWCHART_PREDEFINED_PROCESS'),
        ('msoShapeFlowchartPreparation', 'FLOWCHART_PREPARATION'),
        ('msoShapeFlowchartProcess', 'FLOWCHART_PROCESS'),
        ('msoShapeFlowchartPunchedTape', 'FLOWCHART_PUNCHED_TAPE'),
        ('msoShapeFlowchartSequentialAccessStorage',
         'FLOWCHART_SEQUENTIAL_ACCESS_STORAGE'),
        ('msoShapeFlowchartSort', 'FLOWCHART_SORT'),
        ('msoShapeFlowchartStoredData', 'FLOWCHART_STORED_DATA'),
        ('msoShapeFlowchartSummingJunction', 'FLOWCHART_SUMMING_JUNCTION'),
        ('msoShapeFlowchartTerminator', 'FLOWCHART_TERMINATOR'),
        ('msoShapeFoldedCorner', 'FOLDED_CORNER'),
        ('msoShapeFrame', 'FRAME'),
        ('msoShapeFunnel', 'FUNNEL'),
        ('msoShapeGear6', 'GEAR_6'),
        ('msoShapeGear9', 'GEAR_9'),
        ('msoShapeHalfFrame', 'HALF_FRAME'),
        ('msoShapeHeart', 'HEART'),
        ('msoShapeHeptagon', 'HEPTAGON'),
        ('msoShapeHexagon', 'HEXAGON'),
        ('msoShapeHorizontalScroll', 'HORIZONTAL_SCROLL'),
        ('msoShapeIsoscelesTriangle', 'ISOSCELES_TRIANGLE'),
        ('msoShapeLeftArrow', 'LEFT_ARROW'),
        ('msoShapeLeftArrowCallout', 'LEFT_ARROW_CALLOUT'),
        ('msoShapeLeftBrace', 'LEFT_BRACE'),
        ('msoShapeLeftBracket', 'LEFT_BRACKET'),
        ('msoShapeLeftCircularArrow', 'LEFT_CIRCULAR_ARROW'),
        ('msoShapeLeftRightArrow', 'LEFT_RIGHT_ARROW'),
        ('msoShapeLeftRightArrowCallout', 'LEFT_RIGHT_ARROW_CALLOUT'),
        ('msoShapeLeftRightCircularArrow', 'LEFT_RIGHT_CIRCULAR_ARROW'),
        ('msoShapeLeftRightRibbon', 'LEFT_RIGHT_RIBBON'),
        ('msoShapeLeftRightUpArrow', 'LEFT_RIGHT_UP_ARROW'),
        ('msoShapeLeftUpArrow', 'LEFT_UP_ARROW'),
        ('msoShapeLightningBolt', 'LIGHTNING_BOLT'),
        ('msoShapeLineCallout1', 'LINE_CALLOUT_1'),
        ('msoShapeLineCallout1AccentBar', 'LINE_CALLOUT_1_ACCENT_BAR'),
        ('msoShapeLineCallout1BorderandAccentBar',
         'LINE_CALLOUT_1_BORDER_AND_ACCENT_BAR'),
        ('msoShapeLineCallout1NoBorder', 'LINE_CALLOUT_1_NO_BORDER'),
        ('msoShapeLineCallout2', 'LINE_CALLOUT_2'),
        ('msoShapeLineCallout2AccentBar', 'LINE_CALLOUT_2_ACCENT_BAR'),
        ('msoShapeLineCallout2BorderandAccentBar',
         'LINE_CALLOUT_2_BORDER_AND_ACCENT_BAR'),
        ('msoShapeLineCallout2NoBorder', 'LINE_CALLOUT_2_NO_BORDER'),
        ('msoShapeLineCallout3', 'LINE_CALLOUT_3'),
        ('msoShapeLineCallout3AccentBar', 'LINE_CALLOUT_3_ACCENT_BAR'),
        ('msoShapeLineCallout3BorderandAccentBar',
         'LINE_CALLOUT_3_BORDER_AND_ACCENT_BAR'),
        ('msoShapeLineCallout3NoBorder', 'LINE_CALLOUT_3_NO_BORDER'),
        ('msoShapeLineCallout4', 'LINE_CALLOUT_4'),
        ('msoShapeLineCallout4AccentBar', 'LINE_CALLOUT_4_ACCENT_BAR'),
        ('msoShapeLineCallout4BorderandAccentBar',
         'LINE_CALLOUT_4_BORDER_AND_ACCENT_BAR'),
        ('msoShapeLineCallout4NoBorder', 'LINE_CALLOUT_4_NO_BORDER'),
        ('msoShapeLineInverse', 'LINE_INVERSE'),
        ('msoShapeMathDivide', 'MATH_DIVIDE'),
        ('msoShapeMathEqual', 'MATH_EQUAL'),
        ('msoShapeMathMinus', 'MATH_MINUS'),
        ('msoShapeMathMultiply', 'MATH_MULTIPLY'),
        ('msoShapeMathNotEqual', 'MATH_NOT_EQUAL'),
        ('msoShapeMathPlus', 'MATH_PLUS'),
        ('msoShapeMoon', 'MOON'),
        ('msoShapeNoSymbol', 'NO_SYMBOL'),
        ('msoShapeNonIsoscelesTrapezoid', 'NON_ISOSCELES_TRAPEZOID'),
        ('msoShapeNotchedRightArrow', 'NOTCHED_RIGHT_ARROW'),
        ('msoShapeOctagon', 'OCTAGON'),
        ('msoShapeOval', 'OVAL'),
        ('msoShapeOvalCallout', 'OVAL_CALLOUT'),
        ('msoShapeParallelogram', 'PARALLELOGRAM'),
        ('msoShapePentagon', 'PENTAGON'),
        ('msoShapePie', 'PIE'),
        ('msoShapePieWedge', 'PIE_WEDGE'),
        ('msoShapePlaque', 'PLAQUE'),
        ('msoShapePlaqueTabs', 'PLAQUE_TABS'),
        ('msoShapeQuadArrow', 'QUAD_ARROW'),
        ('msoShapeQuadArrowCallout', 'QUAD_ARROW_CALLOUT'),
        ('msoShapeRectangle', 'RECTANGLE'),
        ('msoShapeRectangularCallout', 'RECTANGULAR_CALLOUT'),
        ('msoShapeRegularPentagon', 'REGULAR_PENTAGON'),
        ('msoShapeRightArrow', 'RIGHT_ARROW'),
        ('msoShapeRightArrowCallout', 'RIGHT_ARROW_CALLOUT'),
        ('msoShapeRightBrace', 'RIGHT_BRACE'),
        ('msoShapeRightBracket', 'RIGHT_BRACKET'),
        ('msoShapeRightTriangle', 'RIGHT_TRIANGLE'),
        ('msoShapeRound1Rectangle', 'ROUND_1_RECTANGLE'),
        ('msoShapeRound2DiagRectangle', 'ROUND_2_DIAG_RECTANGLE'),
        ('msoShapeRound2SameRectangle', 'ROUND_2_SAME_RECTANGLE'),
        ('msoShapeRoundedRectangle', 'ROUNDED_RECTANGLE'),
        ('msoShapeRoundedRectangularCallout', 'ROUNDED_RECTANGULAR_CALLOUT'),
        ('msoShapeSmileyFace', 'SMILEY_FACE'),
        ('msoShapeSnip1Rectangle', 'SNIP_1_RECTANGLE'),
        ('msoShapeSnip2DiagRectangle', 'SNIP_2_DIAG_RECTANGLE'),
        ('msoShapeSnip2SameRectangle', 'SNIP_2_SAME_RECTANGLE'),
        ('msoShapeSnipRoundRectangle', 'SNIP_ROUND_RECTANGLE'),
        ('msoShapeSquareTabs', 'SQUARE_TABS'),
        ('msoShapeStripedRightArrow', 'STRIPED_RIGHT_ARROW'),
        ('msoShapeSun', 'SUN'),
        ('msoShapeSwooshArrow', 'SWOOSH_ARROW'),
        ('msoShapeTear', 'TEAR'),
        ('msoShapeTrapezoid', 'TRAPEZOID'),
        ('msoShapeUTurnArrow', 'U_TURN_ARROW'),
        ('msoShapeUpArrow', 'UP_ARROW'),
        ('msoShapeUpArrowCallout', 'UP_ARROW_CALLOUT'),
        ('msoShapeUpDownArrow', 'UP_DOWN_ARROW'),
        ('msoShapeUpDownArrowCallout', 'UP_DOWN_ARROW_CALLOUT'),
        ('msoShapeUpRibbon', 'UP_RIBBON'),
        ('msoShapeVerticalScroll', 'VERTICAL_SCROLL'),
        ('msoShapeWave', 'WAVE')
    )
