# Style Components

Panel provides a comprehensive system for applying designs, themes and custom styling for components.
This section will take you through these concepts.

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} {octicon}`pencil;2.5em;sd-mr-1 sd-animate-grow50` Apply a Design
:link: design
:link-type: doc

How to switch between different design systems.
:::

:::{grid-item-card} {octicon}`sun;2.5em;sd-mr-1 sd-animate-grow50` Toggle themes
:link: themes
:link-type: doc

How to toggle between themes (e.g. 'light' and 'dark').
:::

:::{grid-item-card} {octicon}`gift;2.5em;sd-mr-1 sd-animate-grow50` Apply CSS
:link: apply_css
:link-type: doc

How to apply custom CSS styling.
:::

:::{grid-item-card} {octicon}`paintbrush;2.5em;sd-mr-1 sd-animate-grow50` Customize a Design
:link: design_variables
:link-type: doc

How to customize designs and themes with CSS variables.
:::

:::{grid-item-card} {octicon}`hourglass;2.5em;sd-mr-1 sd-animate-grow50` Customize Loading Icon
:link: load_icon
:link-type: doc

How to customize the loading icon.
:::

:::{grid-item-card} {octicon}`eye;2.5em;sd-mr-1 sd-animate-grow50` Control Visibility
:link: visibility
:link-type: doc

How to control the visibility of a component.
:::

::::

This section will show you how to style the most common plotting libraries for use with Panel.

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} Altair
:link: altair
:link-type: doc

```{image} ../../_static/logos/altair-logo.png
:width: 125px
:align: center
:name: Altair
```

How to style an Altair plot
:::

:::{grid-item-card} ECharts
:link: echarts
:link-type: doc

```{image} ../../_static/logos/echarts-logo.png
:width: 125px
:align: center
:name: ECharts
```

How to style an ECharts plot
:::

:::{grid-item-card} Matplotlib
:link: matplotlib
:link-type: doc

```{image} ../../_static/logos/matplotlib-logo.png
:width: 125px
:align: center
:name: Matplotlib
```

How to style a Matplotlib plot
:::

:::{grid-item-card} Plotly
:link: plotly
:link-type: doc

```{image} ../../_static/logos/plotly-logo.png
:width: 125px
:align: center
:name: Plotly
```

How to style a Plotly plot
:::

:::{grid-item-card} Vega Lite
:link: vega
:link-type: doc

```{image} ../../_static/logos/vegalite-logo.png
:width: 125px
:align: center
:name: Vega
```

How to style a Vega Lite plot
:::

::::

```{toctree}
:titlesonly:
:hidden:
:maxdepth: 1

design
themes
apply_css
design_variables
load_icon
visibility
altair
echarts
matplotlib
plotly
vega
```
