# Getting Started

Welcome to Panel!

The getting started guides are for those who would like to **quickly try out Panel** and **explore the features and strengths of Panel**.

---

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} {octicon}`desktop-download;2.5em;sd-mr-1` Installation
:link: installation
:link-type: doc

Walks you through setting up your Python environment, installing Panel into it and how to configure your editor, IDE or notebook environment appropriately.

+++
[Learn more »](installation)
:::

:::{grid-item-card} {octicon}`mortar-board;2.5em;sd-mr-1` Build an app
:link: build_app
:link-type: doc

Before we dig into some of the core concepts behind Panel this guide gives you a quick tour taking you through the process of loading some data, displaying it and then building an application around it with some of the rich features that Panel supports.

+++
[Learn more »](build_app)
:::

:::{grid-item-card} {octicon}`telescope;2.5em;sd-mr-1` Core Concepts
:link: core_concepts
:link-type: doc

Introduces you to some of the core concepts behind Panel, how to develop Panel applications effectively both in your Editor and in the notebook and some of the core features that make Panel such a powerful library.

+++
[Learn more »](core_concepts)
:::

::::

As the next step after this Getting Started guide, we recommend learning the basics of Panel systematically via the *in depth* [Basic Tutorials](../tutorials/basic/index.md).

## Additional Resources

- The [original announcement of Panel from 2019](https://blog.holoviz.org/panel_announcement.html).

```{toctree}
:titlesonly:
:hidden:
:maxdepth: 2

installation
build_app
core_concepts
```
