# Arrange Components

Arranging components on the page and controlling their size is a major part of building an application. In this section we will go over different ways of achieving fixed and responsive layouts and otherwise arrange components on the page.

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} {octicon}`mirror;2.5em;sd-mr-1 sd-animate-grow50` Customize Spacing
:link: spacing
:link-type: doc

How to customize the spacing between elements.
:::

:::{grid-item-card} {octicon}`project;2.5em;sd-mr-1 sd-animate-grow50` Align Components
:link: align
:link-type: doc

How to customize the alignment between components.
:::

:::{grid-item-card} {octicon}`filter;2.5em;sd-mr-1 sd-animate-grow50` Control Size
:link: size
:link-type: doc

How to control the size of components.
:::

::::


## Examples

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card}
:img-top: https://assets.holoviz.org/panel/how_to/layout/dynamic_tabs.png
:link: examples/dynamic_tabs
:link-type: doc

Use the `dynamic` parameter of `Tabs` to defer rendering until a tab is selected.
:::

::::

```{toctree}
:titlesonly:
:hidden:
:maxdepth: 1

spacing
align
size
```
