info = {
    "name": "ro",
    "date_order": "DMY",
    "january": [
        "ian",
        "ianuarie"
    ],
    "february": [
        "feb",
        "februarie",
        "Febr"
    ],
    "march": [
        "mar",
        "martie",
        "Mart"
    ],
    "april": [
        "apr",
        "aprilie"
    ],
    "may": [
        "mai"
    ],
    "june": [
        "iun",
        "iunie"
    ],
    "july": [
        "iul",
        "iulie"
    ],
    "august": [
        "aug",
        "august"
    ],
    "september": [
        "sept",
        "septembrie",
        "Sep"
    ],
    "october": [
        "oct",
        "octombrie"
    ],
    "november": [
        "noiembrie",
        "nov",
        "Noiem"
    ],
    "december": [
        "dec",
        "decembrie"
    ],
    "monday": [
        "lun",
        "luni"
    ],
    "tuesday": [
        "mar",
        "marți"
    ],
    "wednesday": [
        "mie",
        "miercuri",
        "Mi"
    ],
    "thursday": [
        "joi"
    ],
    "friday": [
        "vin",
        "vineri"
    ],
    "saturday": [
        "sâm",
        "sâmbătă"
    ],
    "sunday": [
        "dum",
        "duminică"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "an",
        "ani"
    ],
    "month": [
        "lună",
        "luna",
        "luni"
    ],
    "week": [
        "săpt",
        "săptămână",
        "săptămâni"
    ],
    "day": [
        "zi",
        "zile"
    ],
    "hour": [
        "h",
        "oră",
        "ore"
    ],
    "minute": [
        "m",
        "min",
        "minut",
        "minute"
    ],
    "second": [
        "s",
        "sec",
        "secundă",
        "secunde"
    ],
    "relative-type": {
        "0 day ago": [
            "azi"
        ],
        "0 hour ago": [
            "ora aceasta"
        ],
        "0 minute ago": [
            "minutul acesta"
        ],
        "0 month ago": [
            "luna aceasta"
        ],
        "0 second ago": [
            "acum"
        ],
        "0 week ago": [
            "săptămâna aceasta"
        ],
        "0 year ago": [
            "anul acesta"
        ],
        "1 day ago": [
            "ieri"
        ],
        "1 month ago": [
            "luna trecută"
        ],
        "1 week ago": [
            "săptămâna trecută"
        ],
        "1 year ago": [
            "anul trecut"
        ],
        "in 1 day": [
            "mâine"
        ],
        "in 1 month": [
            "luna viitoare"
        ],
        "in 1 week": [
            "săptămâna viitoare"
        ],
        "in 1 year": [
            "anul viitor"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "acum (\\d+) de zile",
            "acum (\\d+) zi",
            "acum (\\d+) zile"
        ],
        "\\1 hour ago": [
            "acum (\\d+) de ore",
            "acum (\\d+) h",
            "acum (\\d+) oră"
        ],
        "\\1 minute ago": [
            "acum (\\d+) de minute",
            "acum (\\d+) min",
            "acum (\\d+) minut"
        ],
        "\\1 month ago": [
            "acum (\\d+) de luni",
            "acum (\\d+) luni",
            "acum (\\d+) lună"
        ],
        "\\1 second ago": [
            "acum (\\d+) de secunde",
            "acum (\\d+) sec",
            "acum (\\d+) secundă"
        ],
        "\\1 week ago": [
            "acum (\\d+) de săptămâni",
            "acum (\\d+) săpt",
            "acum (\\d+) săptămână"
        ],
        "\\1 year ago": [
            "acum (\\d+) an",
            "acum (\\d+) de ani"
        ],
        "in \\1 day": [
            "peste (\\d+) de zile",
            "peste (\\d+) zi",
            "peste (\\d+) zile"
        ],
        "in \\1 hour": [
            "peste (\\d+) de ore",
            "peste (\\d+) h",
            "peste (\\d+) oră"
        ],
        "in \\1 minute": [
            "peste (\\d+) de minute",
            "peste (\\d+) min",
            "peste (\\d+) minut"
        ],
        "in \\1 month": [
            "peste (\\d+) de luni",
            "peste (\\d+) luni",
            "peste (\\d+) lună"
        ],
        "in \\1 second": [
            "peste (\\d+) de secunde",
            "peste (\\d+) sec",
            "peste (\\d+) secundă"
        ],
        "in \\1 week": [
            "peste (\\d+) de săptămâni",
            "peste (\\d+) săpt",
            "peste (\\d+) săptămână"
        ],
        "in \\1 year": [
            "peste (\\d+) an",
            "peste (\\d+) ani",
            "peste (\\d+) de ani"
        ]
    },
    "locale_specific": {
        "ro-MD": {
            "name": "ro-MD"
        }
    },
    "skip": [
        "de",
        "la",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "în urmă"
    ],
    "in": [
        "în"
    ]
}
