# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from cloudflare import Cloudflare, AsyncCloudflare
from tests.utils import assert_matches_type
from cloudflare.types.logs.control import RetentionGetResponse, RetentionCreateResponse

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestRetention:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    def test_method_create(self, client: Cloudflare) -> None:
        retention = client.logs.control.retention.create(
            zone_identifier="023e105f4ecef8ad9ca31a8372d0c353",
            flag=True,
        )
        assert_matches_type(RetentionCreateResponse, retention, path=["response"])

    @parametrize
    def test_raw_response_create(self, client: Cloudflare) -> None:
        response = client.logs.control.retention.with_raw_response.create(
            zone_identifier="023e105f4ecef8ad9ca31a8372d0c353",
            flag=True,
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        retention = response.parse()
        assert_matches_type(RetentionCreateResponse, retention, path=["response"])

    @parametrize
    def test_streaming_response_create(self, client: Cloudflare) -> None:
        with client.logs.control.retention.with_streaming_response.create(
            zone_identifier="023e105f4ecef8ad9ca31a8372d0c353",
            flag=True,
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            retention = response.parse()
            assert_matches_type(RetentionCreateResponse, retention, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    def test_path_params_create(self, client: Cloudflare) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `zone_identifier` but received ''"):
            client.logs.control.retention.with_raw_response.create(
                zone_identifier="",
                flag=True,
            )

    @parametrize
    def test_method_get(self, client: Cloudflare) -> None:
        retention = client.logs.control.retention.get(
            "023e105f4ecef8ad9ca31a8372d0c353",
        )
        assert_matches_type(RetentionGetResponse, retention, path=["response"])

    @parametrize
    def test_raw_response_get(self, client: Cloudflare) -> None:
        response = client.logs.control.retention.with_raw_response.get(
            "023e105f4ecef8ad9ca31a8372d0c353",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        retention = response.parse()
        assert_matches_type(RetentionGetResponse, retention, path=["response"])

    @parametrize
    def test_streaming_response_get(self, client: Cloudflare) -> None:
        with client.logs.control.retention.with_streaming_response.get(
            "023e105f4ecef8ad9ca31a8372d0c353",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            retention = response.parse()
            assert_matches_type(RetentionGetResponse, retention, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    def test_path_params_get(self, client: Cloudflare) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `zone_identifier` but received ''"):
            client.logs.control.retention.with_raw_response.get(
                "",
            )


class TestAsyncRetention:
    parametrize = pytest.mark.parametrize("async_client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    async def test_method_create(self, async_client: AsyncCloudflare) -> None:
        retention = await async_client.logs.control.retention.create(
            zone_identifier="023e105f4ecef8ad9ca31a8372d0c353",
            flag=True,
        )
        assert_matches_type(RetentionCreateResponse, retention, path=["response"])

    @parametrize
    async def test_raw_response_create(self, async_client: AsyncCloudflare) -> None:
        response = await async_client.logs.control.retention.with_raw_response.create(
            zone_identifier="023e105f4ecef8ad9ca31a8372d0c353",
            flag=True,
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        retention = await response.parse()
        assert_matches_type(RetentionCreateResponse, retention, path=["response"])

    @parametrize
    async def test_streaming_response_create(self, async_client: AsyncCloudflare) -> None:
        async with async_client.logs.control.retention.with_streaming_response.create(
            zone_identifier="023e105f4ecef8ad9ca31a8372d0c353",
            flag=True,
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            retention = await response.parse()
            assert_matches_type(RetentionCreateResponse, retention, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    async def test_path_params_create(self, async_client: AsyncCloudflare) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `zone_identifier` but received ''"):
            await async_client.logs.control.retention.with_raw_response.create(
                zone_identifier="",
                flag=True,
            )

    @parametrize
    async def test_method_get(self, async_client: AsyncCloudflare) -> None:
        retention = await async_client.logs.control.retention.get(
            "023e105f4ecef8ad9ca31a8372d0c353",
        )
        assert_matches_type(RetentionGetResponse, retention, path=["response"])

    @parametrize
    async def test_raw_response_get(self, async_client: AsyncCloudflare) -> None:
        response = await async_client.logs.control.retention.with_raw_response.get(
            "023e105f4ecef8ad9ca31a8372d0c353",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        retention = await response.parse()
        assert_matches_type(RetentionGetResponse, retention, path=["response"])

    @parametrize
    async def test_streaming_response_get(self, async_client: AsyncCloudflare) -> None:
        async with async_client.logs.control.retention.with_streaming_response.get(
            "023e105f4ecef8ad9ca31a8372d0c353",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            retention = await response.parse()
            assert_matches_type(RetentionGetResponse, retention, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    async def test_path_params_get(self, async_client: AsyncCloudflare) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `zone_identifier` but received ''"):
            await async_client.logs.control.retention.with_raw_response.get(
                "",
            )
