/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "LICENSE" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

// ----------------------------------------------------------------------------
// Convert from Montgomery form z := (x / 2^576) mod p_521, assuming x reduced
// Input x[9]; output z[9]
//
//    extern void bignum_demont_p521
//     (uint64_t z[static 9], uint64_t x[static 9]);
//
// This assumes the input is < p_521 for correctness. If this is not the case,
// use the variant "bignum_deamont_p521" instead.
//
// Standard x86-64 ABI: RDI = z, RSI = x
// ----------------------------------------------------------------------------


        .globl  bignum_demont_p521
        .globl  _bignum_demont_p521
        .text

#define z %rdi
#define x %rsi

// Rotating (aliased) registers for the digits

#define c %rax
#define d0 %rdx
#define d1 %rcx

#define d2 %rdx
#define d3 %rcx
#define d4 %rdx
#define d5 %rcx
#define d6 %rdx
#define d7 %rcx
#define d8 %rdx

bignum_demont_p521:
_bignum_demont_p521:

// Rotate, as a 521-bit quantity, by 9*64 - 521 = 55 bits right.

        movq    (x), d0
        movq    d0, c
        movq    8(x), d1
        shrdq   $55, d1, d0
        movq    d0, (z)
        movq    16(x), d2
        shrdq   $55, d2, d1
        movq    d1, 8(z)
        movq    24(x), d3
        shrdq   $55, d3, d2
        shlq    $9, c
        movq    d2, 16(z)
        movq    32(x), d4
        shrdq   $55, d4, d3
        movq    d3, 24(z)
        movq    40(x), d5
        shrdq   $55, d5, d4
        movq    d4, 32(z)
        movq    48(x), d6
        shrdq   $55, d6, d5
        movq    d5, 40(z)
        movq    56(x), d7
        shrdq   $55, d7, d6
        movq    d6, 48(z)
        movq    64(x), d8
        orq     c, d8
        shrdq   $55, d8, d7
        movq    d7, 56(z)
        shrq    $55, d8
        movq    d8, 64(z)
        ret

#if defined(__linux__) && defined(__ELF__)
.section .note.GNU-stack,"",%progbits
#endif
