Processing
==========

This is the official source code for the [Processing](http://processing.org) Development Environment (PDE),
the “core” and the libraries that are included with the [download](http://processing.org/download).

__I've found a bug!__
Let us know [here](https://github.com/processing/processing/issues) (after first checking if someone has already posted a similar problem).
If it's a reference, web site, or examples issue, take that up with folks [here](https://github.com/processing/processing-docs/issues).
There are also separate locations for [Android Mode](https://github.com/processing/processing-android/issues), or the [Video](https://github.com/processing/processing-video/issues) and [Sound](https://github.com/processing/processing-sound/issues) libraries.
The [processing.js](http://processingjs.org) project is not affiliated with us, but you can find their issue tracker [here](https://github.com/processing-js/processing-js/issues).

__Locked Issues__
Where possible, I've started locking issues once resolved. This helps reduce the amount of noise from folks adding to an issue that's been closed for years. Because this project has existed for a long time and we have thousands of closed issues, lots of them may sound similar to an issue you're having. But if there's a new problem, it'll be missed if it's lost in a comment added to an already closed issue. I don't like to lock issues because it cuts off conversation, but it's better than legitimate problems being missed.

__That [processing-bugs](https://github.com/processing-bugs) fella is suspicious.__
The issues list has been imported from Google Code, so there are many spurious references
amongst them since the numbering changed. Basically, any time you see references to
changes made by [processing-bugs](https://github.com/processing-bugs), it may be somewhat suspect.
Over time this will clean itself up as bugs are fixed and new issues are added from within Github.
Help speed this process along by helping us!

__Please help.__
The instructions for building the source [are here](https://github.com/processing/processing/wiki/Build-Instructions).
Please help us fix problems, and if you're submitting code, following the [style guidelines](https://github.com/processing/processing/wiki/Style-Guidelines) helps save me a lot of time.

__And finally...__
Someday we'll also fix all these bugs, throw together hundreds of unit tests, and get rich off all this stuff that we're giving away for free. But not today.

So in the meantime, I ask for your patience,
[participation](https://github.com/processing/processing/wiki/Project-List),
and [patches](https://github.com/processing/processing/pulls).

Ben Fry, 20 January 2019
