/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.CompositeContext;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.ext.awt.image.CompositeRule;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.SVGComposite;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;

public class CompositeRed
extends AbstractRed {
    CompositeRule rule;
    CompositeContext[] contexts;

    public CompositeRed(List arrayList, CompositeRule compositeRule) {
        ArrayList<Object> arrayList2;
        CachableRed cachableRed = (CachableRed)arrayList.get(0);
        ColorModel colorModel = CompositeRed.fixColorModel(cachableRed);
        this.rule = compositeRule;
        SVGComposite sVGComposite = new SVGComposite(compositeRule);
        this.contexts = new CompositeContext[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        Object object = null;
        block4: while (iterator.hasNext()) {
            arrayList2 = (CachableRed)iterator.next();
            this.contexts[n++] = sVGComposite.createContext(arrayList2.getColorModel(), colorModel, null);
            Object object2 = arrayList2.getBounds();
            if (object == null) {
                object = object2;
                continue;
            }
            switch (compositeRule.getRule()) {
                case 2: {
                    if (((Rectangle)object).intersects((Rectangle)object2)) {
                        object = ((Rectangle)object).intersection((Rectangle)object2);
                        continue block4;
                    }
                    ((Rectangle)object).width = 0;
                    ((Rectangle)object).height = 0;
                    continue block4;
                }
                case 3: {
                    object = object2;
                    continue block4;
                }
            }
            ((Rectangle)object).add((Rectangle)object2);
        }
        if (object == null) {
            throw new IllegalArgumentException("Composite Operation Must have some source!");
        }
        if (compositeRule.getRule() == 6) {
            arrayList2 = new ArrayList<Object>(arrayList.size());
            for (Object object2 : arrayList) {
                Rectangle rectangle = object2.getBounds();
                if (rectangle.x != ((Rectangle)object).x || rectangle.y != ((Rectangle)object).y || rectangle.width != ((Rectangle)object).width || rectangle.height != ((Rectangle)object).height) {
                    object2 = new PadRed((CachableRed)object2, (Rectangle)object, PadMode.ZERO_PAD, null);
                }
                arrayList2.add(object2);
            }
            arrayList = arrayList2;
        }
        arrayList2 = CompositeRed.fixSampleModel(cachableRed, colorModel, object);
        int n2 = AbstractTiledRed.getDefaultTileSize();
        int n3 = n2 * (int)Math.floor(((Rectangle)object).x / n2);
        int n4 = n2 * (int)Math.floor(((Rectangle)object).y / n2);
        this.init(arrayList, (Rectangle)object, colorModel, (SampleModel)((Object)arrayList2), n3, n4, null);
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        this.genRect(writableRaster);
        return writableRaster;
    }

    @Override
    public Raster getTile(int n, int n2) {
        int n3 = this.tileGridXOff + n * this.tileWidth;
        int n4 = this.tileGridYOff + n2 * this.tileHeight;
        Point point = new Point(n3, n4);
        WritableRaster writableRaster = Raster.createWritableRaster(this.sm, point);
        this.genRect(writableRaster);
        return writableRaster;
    }

    public void emptyRect(WritableRaster writableRaster) {
        PadRed.ZeroRecter zeroRecter = PadRed.ZeroRecter.getZeroRecter(writableRaster);
        zeroRecter.zeroRect(new Rectangle(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight()));
    }

    public void genRect(WritableRaster writableRaster) {
        Rectangle rectangle = writableRaster.getBounds();
        int n = 0;
        Iterator iterator = this.srcs.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Rectangle rectangle2;
            CachableRed cachableRed = (CachableRed)iterator.next();
            if (bl) {
                rectangle2 = cachableRed.getBounds();
                if (rectangle.x < rectangle2.x || rectangle.y < rectangle2.y || rectangle.x + rectangle.width > rectangle2.x + rectangle2.width || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
                    this.emptyRect(writableRaster);
                }
                cachableRed.copyData(writableRaster);
                if (!cachableRed.getColorModel().isAlphaPremultiplied()) {
                    GraphicsUtil.coerceData(writableRaster, cachableRed.getColorModel(), true);
                }
                bl = false;
            } else {
                rectangle2 = cachableRed.getBounds();
                if (rectangle2.intersects(rectangle)) {
                    Rectangle rectangle3 = rectangle2.intersection(rectangle);
                    Raster raster = cachableRed.getData(rectangle3);
                    WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                    this.contexts[n].compose(raster, writableRaster2, writableRaster2);
                }
            }
            ++n;
        }
    }

    public void genRect_OVER(WritableRaster writableRaster) {
        Rectangle rectangle = writableRaster.getBounds();
        ColorModel colorModel = this.getColorModel();
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster.createWritableTranslatedChild(0, 0), colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        Iterator iterator = this.srcs.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            CachableRed cachableRed = (CachableRed)iterator.next();
            if (bl) {
                Rectangle rectangle2 = cachableRed.getBounds();
                if (rectangle.x < rectangle2.x || rectangle.y < rectangle2.y || rectangle.x + rectangle.width > rectangle2.x + rectangle2.width || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
                    this.emptyRect(writableRaster);
                }
                cachableRed.copyData(writableRaster);
                GraphicsUtil.coerceData(writableRaster, cachableRed.getColorModel(), colorModel.isAlphaPremultiplied());
                bl = false;
                continue;
            }
            GraphicsUtil.drawImage(graphics2D, cachableRed);
        }
    }

    protected static SampleModel fixSampleModel(CachableRed cachableRed, ColorModel colorModel, Rectangle rectangle) {
        int n;
        int n2 = AbstractTiledRed.getDefaultTileSize();
        int n3 = n2 * (int)Math.floor(rectangle.x / n2);
        int n4 = n2 * (int)Math.floor(rectangle.y / n2);
        int n5 = rectangle.x + rectangle.width - n3;
        int n6 = rectangle.y + rectangle.height - n4;
        SampleModel sampleModel = cachableRed.getSampleModel();
        int n7 = sampleModel.getWidth();
        if (n7 < n2) {
            n7 = n2;
        }
        if (n7 > n5) {
            n7 = n5;
        }
        if ((n = sampleModel.getHeight()) < n2) {
            n = n2;
        }
        if (n > n6) {
            n = n6;
        }
        if (n7 <= 0 || n <= 0) {
            n7 = 1;
            n = 1;
        }
        return colorModel.createCompatibleSampleModel(n7, n);
    }

    protected static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel.hasAlpha()) {
            if (!colorModel.isAlphaPremultiplied()) {
                colorModel = GraphicsUtil.coerceColorModel(colorModel, true);
            }
            return colorModel;
        }
        int n = cachableRed.getSampleModel().getNumBands() + 1;
        if (n > 4) {
            throw new IllegalArgumentException("CompositeRed can only handle up to three band images");
        }
        int[] nArray = new int[4];
        for (int i = 0; i < n - 1; ++i) {
            nArray[i] = 0xFF0000 >> 8 * i;
        }
        nArray[3] = 255 << 8 * (n - 1);
        ColorSpace colorSpace = colorModel.getColorSpace();
        return new DirectColorModel(colorSpace, 8 * n, nArray[0], nArray[1], nArray[2], nArray[3], true, 3);
    }
}

