/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.formimpl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JRadioButton;
import net.sf.launch4j.binding.Binding;
import net.sf.launch4j.binding.Bindings;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.ConfigPersister;
import net.sf.launch4j.form.HeaderForm;

public class HeaderFormImpl
extends HeaderForm {
    private final Bindings _bindings;

    public HeaderFormImpl(Bindings bindings) {
        this._bindings = bindings;
        this._bindings.add("headerTypeIndex", new JRadioButton[]{this._guiHeaderRadio, this._consoleHeaderRadio, this._jniGuiHeaderRadio, this._jniConsoleHeaderRadio}).add("headerObjects", "customHeaderObjects", this._headerObjectsCheck, this._headerObjectsTextArea).add("libs", "customLibs", this._libsCheck, this._libsTextArea);
        this._guiHeaderRadio.setActionCommand("gui");
        this._consoleHeaderRadio.setActionCommand("console");
        this._jniGuiHeaderRadio.setActionCommand("jniGui32");
        this._jniConsoleHeaderRadio.setActionCommand("jniConsole32");
        HeaderTypeActionListener headerTypeActionListener = new HeaderTypeActionListener();
        this._guiHeaderRadio.addActionListener(headerTypeActionListener);
        this._consoleHeaderRadio.addActionListener(headerTypeActionListener);
        this._jniGuiHeaderRadio.addActionListener(headerTypeActionListener);
        this._jniConsoleHeaderRadio.addActionListener(headerTypeActionListener);
        this._headerObjectsCheck.addActionListener(new HeaderObjectsActionListener());
        this._libsCheck.addActionListener(new LibsActionListener());
    }

    private void updateLibs() {
        if (!this._libsCheck.isSelected()) {
            ConfigPersister.getInstance().getConfig().setLibs(null);
            Binding b = this._bindings.getBinding("libs");
            b.put(ConfigPersister.getInstance().getConfig());
        }
    }

    private class LibsActionListener
    implements ActionListener {
        private LibsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeaderFormImpl.this.updateLibs();
        }
    }

    private class HeaderObjectsActionListener
    implements ActionListener {
        private HeaderObjectsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!HeaderFormImpl.this._headerObjectsCheck.isSelected()) {
                ConfigPersister.getInstance().getConfig().setHeaderObjects(null);
                Binding b = HeaderFormImpl.this._bindings.getBinding("headerObjects");
                b.put(ConfigPersister.getInstance().getConfig());
            }
        }
    }

    private class HeaderTypeActionListener
    implements ActionListener {
        private HeaderTypeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Config c = ConfigPersister.getInstance().getConfig();
            c.setHeaderType(e.getActionCommand());
            if (!HeaderFormImpl.this._headerObjectsCheck.isSelected()) {
                Binding b = HeaderFormImpl.this._bindings.getBinding("headerObjects");
                b.put(c);
                HeaderFormImpl.this.updateLibs();
            }
        }
    }
}

