/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom.rewrite.imports;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportComment;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportEntry;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportName;
import org.eclipse.jdt.internal.core.dom.rewrite.imports.OriginalImportEntry;

final class RemovedImportCommentReassigner {
    private final Collection<OriginalImportEntry> originalImportsWithComments;

    private static Collection<OriginalImportEntry> retainImportsWithComments(Collection<OriginalImportEntry> imports) {
        ArrayList<OriginalImportEntry> importsWithComments = new ArrayList<OriginalImportEntry>(imports.size());
        for (OriginalImportEntry currentImport : imports) {
            if (currentImport.comments.isEmpty()) continue;
            importsWithComments.add(currentImport);
        }
        return importsWithComments;
    }

    private static boolean hasFloatingComment(OriginalImportEntry nextAssignedImport) {
        for (ImportComment importComment : nextAssignedImport.comments) {
            if (importComment.succeedingLineDelimiters <= 1) continue;
            return true;
        }
        return false;
    }

    RemovedImportCommentReassigner(List<OriginalImportEntry> originalImports) {
        this.originalImportsWithComments = RemovedImportCommentReassigner.retainImportsWithComments(originalImports);
    }

    Map<ImportEntry, Collection<ImportComment>> reassignComments(Collection<ImportEntry> resultantImports) {
        Map<ImportEntry, Collection<OriginalImportEntry>> importAssignments = this.assignRemovedImports(resultantImports);
        HashMap<ImportEntry, Collection<ImportComment>> commentAssignments = new HashMap<ImportEntry, Collection<ImportComment>>();
        for (Map.Entry<ImportEntry, Collection<OriginalImportEntry>> importAssignment : importAssignments.entrySet()) {
            ImportEntry targetImport = importAssignment.getKey();
            if (targetImport == null) continue;
            ArrayDeque<ImportComment> assignedComments = new ArrayDeque<ImportComment>();
            Collection<OriginalImportEntry> assignedImports = importAssignment.getValue();
            Iterator<OriginalImportEntry> nextAssignedImportIterator = assignedImports.iterator();
            if (nextAssignedImportIterator.hasNext()) {
                nextAssignedImportIterator.next();
            }
            for (OriginalImportEntry currentAssignedImport : assignedImports) {
                OriginalImportEntry nextAssignedImport = nextAssignedImportIterator.hasNext() ? nextAssignedImportIterator.next() : null;
                assignedComments.addAll(currentAssignedImport.comments);
                if (nextAssignedImport == null || !RemovedImportCommentReassigner.hasFloatingComment(nextAssignedImport)) continue;
                ImportComment lastComment = (ImportComment)assignedComments.removeLast();
                ImportComment lastCommentWithTrailingBlankLine = new ImportComment(lastComment.region, 2);
                assignedComments.add(lastCommentWithTrailingBlankLine);
            }
            commentAssignments.put(targetImport, assignedComments);
        }
        return commentAssignments;
    }

    private Map<ImportEntry, Collection<OriginalImportEntry>> assignRemovedImports(Collection<ImportEntry> imports) {
        Collection<OriginalImportEntry> removedImportsWithComments = this.identifyRemovedImportsWithComments(imports);
        if (removedImportsWithComments.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<ImportName, ImportEntry> firstSingleForOnDemand = this.identifyFirstSingleForEachOnDemand(imports);
        Map<ImportName, ImportEntry> firstOccurrences = this.identifyFirstOccurrenceOfEachImportName(imports);
        HashMap<ImportEntry, Collection<OriginalImportEntry>> removedImportsForRetainedImport = new HashMap<ImportEntry, Collection<OriginalImportEntry>>();
        for (ImportEntry retainedImport : imports) {
            removedImportsForRetainedImport.put(retainedImport, new ArrayList());
        }
        removedImportsForRetainedImport.put(null, new ArrayList());
        for (OriginalImportEntry removedImport : removedImportsWithComments) {
            ImportName removedImportName = removedImport.importName;
            ImportEntry retainedImport = removedImportName.isOnDemand() ? firstSingleForOnDemand.get(removedImportName) : firstOccurrences.get(removedImportName.getContainerOnDemand());
            ((Collection)removedImportsForRetainedImport.get(retainedImport)).add(removedImport);
        }
        return removedImportsForRetainedImport;
    }

    private Collection<OriginalImportEntry> identifyRemovedImportsWithComments(Collection<ImportEntry> imports) {
        ArrayList<OriginalImportEntry> removedImports = new ArrayList<OriginalImportEntry>(this.originalImportsWithComments);
        removedImports.removeAll(imports);
        return removedImports;
    }

    private Map<ImportName, ImportEntry> identifyFirstSingleForEachOnDemand(Iterable<ImportEntry> imports) {
        HashMap<ImportName, ImportEntry> firstSingleImportForContainer = new HashMap<ImportName, ImportEntry>();
        for (ImportEntry currentImport : imports) {
            ImportName containerOnDemand;
            if (currentImport.importName.isOnDemand() || firstSingleImportForContainer.containsKey(containerOnDemand = currentImport.importName.getContainerOnDemand())) continue;
            firstSingleImportForContainer.put(containerOnDemand, currentImport);
        }
        return firstSingleImportForContainer;
    }

    private Map<ImportName, ImportEntry> identifyFirstOccurrenceOfEachImportName(Iterable<ImportEntry> imports) {
        HashMap<ImportName, ImportEntry> firstOccurrenceOfImport = new HashMap<ImportName, ImportEntry>();
        for (ImportEntry resultantImport : imports) {
            if (firstOccurrenceOfImport.containsKey(resultantImport.importName)) continue;
            firstOccurrenceOfImport.put(resultantImport.importName, resultantImport);
        }
        return firstOccurrenceOfImport;
    }
}

