/*
 * Decompiled with CFR 0.152.
 */
package com.google.classpath;

import com.google.classpath.ClassPath;
import com.google.classpath.ResourceFilter;
import com.google.classpath.ResourceFinder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class JARClassPath
implements ClassPath {
    private final File file;
    private final Package root = new Package();
    private JarFile jarFile;
    private static final Logger logger = Logger.getLogger(JARClassPath.class.getCanonicalName());

    public JARClassPath(File jarFile) {
        this.file = jarFile;
    }

    public ClassPath loadEntries() throws IOException {
        try {
            this.jarFile = new JarFile(this.file);
        }
        catch (ZipException e) {
            logger.warning("Failed to read Jar file " + this.file.getAbsolutePath());
            throw e;
        }
        Enumeration<JarEntry> enumeration = this.jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            String path = entry.getName();
            if (entry.isDirectory()) {
                this.addPackage(path);
                continue;
            }
            this.addResource(path);
        }
        return this;
    }

    private Package addPackage(String path) {
        String[] parts = path.split("/");
        Package pkg = this.root;
        for (int i = 0; i < parts.length; ++i) {
            String name = parts[i];
            if (pkg.packages.containsKey(name)) {
                pkg = (Package)pkg.packages.get(name);
                continue;
            }
            Package newPkg = new Package();
            pkg.packages.put(name, newPkg);
            pkg = newPkg;
        }
        return pkg;
    }

    private void addResource(String resource) {
        int index = resource.lastIndexOf("/");
        String path = index == -1 ? "" : resource.substring(0, index);
        String name = index == -1 ? resource : resource.substring(index + 1);
        Package pkg = this.addPackage(path);
        pkg.resources.add(name);
    }

    public boolean isResource(String resource) {
        int index = resource.lastIndexOf("/");
        String path = index == -1 ? "" : resource.substring(0, index);
        String name = index == -1 ? resource : resource.substring(index + 1);
        Package pkg = this.getPackage(path);
        return pkg != null && pkg.resources.contains(name);
    }

    public boolean isPackage(String packageName) {
        return this.getPackage(packageName) != null;
    }

    private Package getPackage(String packageName) {
        String[] parts = packageName.split("/");
        Package pkg = this.root;
        for (int i = 0; i < parts.length; ++i) {
            String name = parts[i];
            if (name.equals("") || (pkg = (Package)pkg.packages.get(name)) != null) continue;
            return null;
        }
        return pkg;
    }

    public String[] listPackages(String packageName) {
        Package pkg = this.getPackage(packageName);
        if (pkg == null) {
            return new String[0];
        }
        Set packages = pkg.packages.keySet();
        return packages.toArray(new String[packages.size()]);
    }

    public String[] listResources(String packageName) {
        Package pkg = this.getPackage(packageName);
        if (pkg == null) {
            return new String[0];
        }
        SortedSet resources = pkg.resources;
        return resources.toArray(new String[resources.size()]);
    }

    public InputStream getResourceAsStream(String resource) {
        while (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        ZipEntry entry = this.jarFile.getEntry(resource);
        if (entry == null) {
            return null;
        }
        try {
            return this.jarFile.getInputStream(entry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] findResources(String rootPackageName, ResourceFilter resourceFilter) {
        return new ResourceFinder(this).findResources(rootPackageName, resourceFilter);
    }

    private static class Package {
        private final Map<String, Package> packages = new TreeMap<String, Package>();
        private final SortedSet<String> resources = new TreeSet<String>();

        private Package() {
        }
    }
}

