/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.dialogs;

import de.escape.quincunx.dxf.TemporaryPainter;
import de.escape.quincunx.gimmicks.BasicPaperFormat;
import de.escape.quincunx.gimmicks.LengthUnit;
import de.escape.quincunx.gimmicks.PaperFormat;
import de.escape.quincunx.gimmicks.PhysicalLength;
import de.escape.quincunx.gimmicks.PostScriptJobInfo;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class PostScriptOutputInfo
implements PostScriptJobInfo,
Serializable {
    public static final String PROPERTY_FILE = "FILE";
    public static final String PROPERTY_COMMAND = "COMMAND";
    public static final String PROPERTY_FILE_COMMAND_SELECT = "FILE/COMMAND";
    public static final String PROPERTY_PAPER = "PAPER";
    public static final String PROPERTY_VIEWPORT_ASPECT_RATIO = "VIEWPORT.ASPECT_RATIO";
    public static final String PROPERTY_VIEWPORT_HALIGN = "VIEWPORT.HORIZONTAL_ALIGNMENT";
    public static final String PROPERTY_VIEWPORT_VALIGN = "VIEWPORT.VERTICAL_ALIGNMENT";
    public static final String PROPERTY_VIEWPORT_ROTATION = "VIEWPORT.ROTATION";
    public static final String PROPERTY_TEMPORARY_PAINTER = "TEMPORARY_PAINTER";
    public static final String PROPERTY_LENGTH_UNIT = "LENGTH_UNIT";
    public static final String PROPERTY_WRITING_EPS = "EPS_OUTPUT";
    private String outputPath = "";
    private String commandPath = "";
    private boolean runCommand;
    private PaperFormat paper;
    private int horizontalAlignment = 0;
    private int verticalAlignment = 0;
    private boolean rotated;
    private boolean monochrome = true;
    private LengthUnit measurementUnit = LengthUnit.MILLIMETER;
    private boolean writingEPS;
    private transient TemporaryPainter painter;
    private transient double aspectRatio;
    private transient PropertyChangeSupport changeSupport;

    public PostScriptOutputInfo() {
    }

    public PostScriptOutputInfo(PostScriptOutputInfo info) {
        this.outputPath = info.outputPath;
        this.commandPath = info.commandPath;
        this.runCommand = info.runCommand;
        this.paper = info.paper;
        this.horizontalAlignment = info.horizontalAlignment;
        this.verticalAlignment = info.verticalAlignment;
        this.rotated = info.rotated;
        this.monochrome = info.monochrome;
        this.measurementUnit = info.measurementUnit;
        this.aspectRatio = info.aspectRatio;
        this.painter = info.painter;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("null path not allowed");
        }
        if (!path.equals(this.outputPath)) {
            String old = this.outputPath;
            this.outputPath = path;
            this.firePropertyChange(PROPERTY_FILE, old, path);
        }
    }

    public String getCommandPath() {
        return this.commandPath;
    }

    public void setCommandPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("null path not allowed");
        }
        if (!path.equals(this.commandPath)) {
            String old = this.commandPath;
            this.commandPath = path;
            this.firePropertyChange(PROPERTY_COMMAND, old, path);
        }
    }

    public boolean isRunningCommand() {
        return this.runCommand;
    }

    public void setRunningCommand(boolean runCmd) {
        if (runCmd != this.runCommand) {
            this.runCommand = runCmd;
            this.firePropertyChange(PROPERTY_FILE_COMMAND_SELECT, !runCmd, runCmd);
        }
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(double ratio) {
        if (this.aspectRatio != ratio) {
            double old = this.aspectRatio;
            this.aspectRatio = ratio;
            this.firePropertyChange(PROPERTY_VIEWPORT_ASPECT_RATIO, old, ratio);
        }
    }

    public TemporaryPainter getTemporaryPainter() {
        return this.painter;
    }

    public void setTemporaryPainter(TemporaryPainter painter) {
        if (this.painter != painter) {
            TemporaryPainter old = this.painter;
            this.painter = painter;
            this.firePropertyChange(PROPERTY_TEMPORARY_PAINTER, old, painter);
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int align) {
        if (align != this.horizontalAlignment) {
            switch (align) {
                case -1: 
                case 0: 
                case 1: {
                    int old = this.horizontalAlignment;
                    this.horizontalAlignment = align;
                    this.firePropertyChange(PROPERTY_VIEWPORT_HALIGN, old, align);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("align=" + align);
                }
            }
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int align) {
        if (align != this.verticalAlignment) {
            switch (align) {
                case -1: 
                case 0: 
                case 1: {
                    int old = this.verticalAlignment;
                    this.verticalAlignment = align;
                    this.firePropertyChange(PROPERTY_VIEWPORT_VALIGN, old, align);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("align=" + align);
                }
            }
        }
    }

    public PaperFormat getPaperFormat() {
        return this.paper;
    }

    public void setPaperFormat(PaperFormat pf) {
        if (pf == null) {
            throw new IllegalArgumentException("pf may not be null!");
        }
        if (!pf.equals(this.paper)) {
            PaperFormat old = this.paper;
            this.paper = pf;
            this.firePropertyChange(PROPERTY_PAPER, old, pf);
        }
    }

    public PhysicalLength getLeftMargin() {
        return this.paper.getLeftMargin();
    }

    public void setLeftMargin(PhysicalLength margin) {
        if (margin == null) {
            throw new IllegalArgumentException("null margin not allowed!");
        }
        PhysicalLength oldMargin = this.paper.getLeftMargin();
        if (!oldMargin.equals(margin)) {
            this.setPaperFormat(new BasicPaperFormat(this.paper, margin, this.paper.getRightMargin(), this.paper.getTopMargin(), this.paper.getBottomMargin()));
        }
    }

    public PhysicalLength getRightMargin() {
        return this.paper.getRightMargin();
    }

    public void setRightMargin(PhysicalLength margin) {
        if (margin == null) {
            throw new IllegalArgumentException("null margin not allowed!");
        }
        PhysicalLength oldMargin = this.paper.getRightMargin();
        if (!oldMargin.equals(margin)) {
            this.setPaperFormat(new BasicPaperFormat(this.paper, this.paper.getLeftMargin(), margin, this.paper.getTopMargin(), this.paper.getBottomMargin()));
        }
    }

    public PhysicalLength getTopMargin() {
        return this.paper.getTopMargin();
    }

    public void setTopMargin(PhysicalLength margin) {
        if (margin == null) {
            throw new IllegalArgumentException("null margin not allowed!");
        }
        PhysicalLength oldMargin = this.paper.getTopMargin();
        if (!oldMargin.equals(margin)) {
            this.setPaperFormat(new BasicPaperFormat(this.paper, this.paper.getLeftMargin(), this.paper.getRightMargin(), margin, this.paper.getBottomMargin()));
        }
    }

    public PhysicalLength getBottomMargin() {
        return this.paper.getBottomMargin();
    }

    public void setBottomMargin(PhysicalLength margin) {
        if (margin == null) {
            throw new IllegalArgumentException("null margin not allowed!");
        }
        PhysicalLength oldMargin = this.paper.getBottomMargin();
        if (!oldMargin.equals(margin)) {
            this.setPaperFormat(new BasicPaperFormat(this.paper, this.paper.getLeftMargin(), this.paper.getRightMargin(), this.paper.getTopMargin(), margin));
        }
    }

    public boolean isRotated() {
        return this.rotated;
    }

    public void setRotated(boolean rotate) {
        if (rotate != this.rotated) {
            this.rotated = rotate;
            this.firePropertyChange(PROPERTY_VIEWPORT_ROTATION, !rotate, rotate);
        }
    }

    public boolean isMonochrome() {
        return this.monochrome;
    }

    public void setMonochrome(boolean mono) {
        if (mono != this.monochrome) {
            this.monochrome = mono;
            this.firePropertyChange(PROPERTY_VIEWPORT_ROTATION, !mono, mono);
        }
    }

    public boolean isWritingEPS() {
        return this.writingEPS;
    }

    public void setWritingEPS(boolean state) {
        if (state != this.writingEPS) {
            this.writingEPS = state;
            this.firePropertyChange(PROPERTY_WRITING_EPS, !state, state);
        }
    }

    public LengthUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    public void setMeasurementUnit(LengthUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("unit may not be null!");
        }
        if (!unit.equals(this.measurementUnit)) {
            LengthUnit old = this.measurementUnit;
            this.measurementUnit = unit;
            this.firePropertyChange(PROPERTY_LENGTH_UNIT, old, unit);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String name, boolean oldValue, boolean newValue) {
        this.firePropertyChange(name, oldValue ? Boolean.TRUE : Boolean.FALSE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void firePropertyChange(String name, int oldValue, int newValue) {
        this.firePropertyChange(name, new Integer(oldValue), new Integer(newValue));
    }

    protected void firePropertyChange(String name, double oldValue, double newValue) {
        this.firePropertyChange(name, new Double(oldValue), new Double(newValue));
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        PropertyChangeSupport changeSupport = this.changeSupport;
        if (changeSupport == null) {
            return;
        }
        changeSupport.firePropertyChange(name, oldValue, newValue);
    }
}

