/**
This file is part of a jTEM project.
All jTEM projects are licensed under the FreeBSD license 
or 2-clause BSD license (see http://www.opensource.org/licenses/bsd-license.php). 

Copyright (c) 2002-2009, Technische Universität Berlin, jTEM
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

-	Redistributions of source code must retain the above copyright notice, 
	this list of conditions and the following disclaimer.

-	Redistributions in binary form must reproduce the above copyright notice, 
	this list of conditions and the following disclaimer in the documentation 
	and/or other materials provided with the distribution.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS 
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
**/

package de.jtem.jterm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;

import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

/**
 * Swing component intended as a terminal window for communication with
 * various Java interpreters.
 */
public class JTerm extends JTextPane {
    static {
        JEditorPane.registerEditorKitForContentType(
            "application/x-jterm",
            "jterm.JTermKit");
    }
    public static JScrollPane createScrollingTerminal(Session s) {
        JScrollPane scroll=new JScrollPane(new JTerm(s));
        scroll.setVerticalScrollBarPolicy(
            JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        return scroll;
    }
    private Session session;
    private JTermKit kit;

    public JTerm(Session s) {
        this(new JTermKit(), s);
    }

    JTerm(JTermKit editorKit, Session s) {
        super(s);
        session=s;
        kit=editorKit;
        setCaretPosition(session.getLength());
        setCaretColor(Color.black);
        getCaret().setBlinkRate(0);
        setMargin(new Insets(5, 5, 5, 5));
        setPreferredSize(new Dimension(500, 400));
        //addKeymapBindings();
    }
    public void updateUI(){
        super.updateUI();
        Keymap k=getKeymap();
        JTextComponent.loadKeymap(k, JTermKit.defaultBindings, getActions());        
    }

    /** Returns this session <em>by Reference</em>. */
    public Session getSession() {
        return session;
    }

    /** Sets this session <em>by Reference</em>. */
    public void setSession(Session session) {
        super.setDocument(session);
        this.session=session;
    }

    public EditorKit getEditorKit()
    {
      return kit!=null? kit: new JTermKit();
    }

}
