/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import vrpn.VRPNDevice;

public class ForceDeviceRemote
extends VRPNDevice
implements Runnable {
    public static final int NO_CONSTRAINT = 0;
    public static final int POINT_CONSTRAINT = 1;
    public static final int LINE_CONSTRAINT = 2;
    public static final int PLANE_CONSTRAINT = 3;
    protected Vector forceListeners = new Vector();
    protected Vector scpListeners = new Vector();
    protected Vector errorListeners = new Vector();
    protected static final Object notifyingForceListenersLock = new Object();
    protected static final Object notifyingSCPListenersLock = new Object();
    protected static final Object notifyingErrorListenersLock = new Object();

    public ForceDeviceRemote(String name, String localInLogfileName, String localOutLogfileName, String remoteInLogfileName, String remoteOutLogfileName) throws InstantiationException {
        super(name, localInLogfileName, localOutLogfileName, remoteInLogfileName, remoteOutLogfileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSurface() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.sendSurface_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSurface() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.startSurface_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSurface() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.stopSurface_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVertex(int number, float x, float y, float z) {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.setVertex_native(number, x, y, z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNormal(int number, float x, float y, float z) {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.setNormal_native(number, x, y, z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriangle(int number, int vertex1, int vertex2, int vertex3, int normal1, int normal2, int normal3) {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.setTriangle_native(number, vertex1, vertex2, vertex3, normal1, normal2, normal3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTriangle(int number) {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.removeTriangle_native(number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTrimeshChanges() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.updateTrimeshChanges_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrimeshTransform(float[] transform) {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.setTrimeshTransform_native(transform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTrimesh() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.clearTrimesh_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useHcollide() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.useHcollide_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useGhost() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.useGhost_native();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enableConstraint(int enable) {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.enableConstraint_native(enable);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintMode(int mode) {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.setConstraintMode_native(mode);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintPoint(float[] point) {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.setConstraintPoint_native(point);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintLinePoint(float[] point) {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.setConstraintLinePoint_native(point);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintLineDirection(float[] direction) {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.setConstraintLineDirection_native(direction);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintPlanePoint(float[] point) {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.setConstraintPlanePoint_native(point);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintPlaneNormal(float[] normal) {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.setConstraintPlaneNormal_native(normal);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConstraintKSpring(float k) {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.setConstraintKSpring_native(k);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendForceField(float[] origin, float[] force, float[][] jacobian, float radius) {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.sendForceField_native(origin, force, jacobian, radius);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendForceField() {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.sendForceField_native();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopForceField() {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.stopForceField_native();
        }
        return retval;
    }

    public synchronized void addForceChangeListener(ForceChangeListener listener) {
        this.forceListeners.addElement(listener);
    }

    public synchronized boolean removeForceChangeListener(ForceChangeListener listener) {
        return this.forceListeners.removeElement(listener);
    }

    public synchronized void addSCPChangeListener(SCPChangeListener listener) {
        this.scpListeners.addElement(listener);
    }

    public synchronized boolean removeSCPChangeListener(SCPChangeListener listener) {
        return this.scpListeners.removeElement(listener);
    }

    public synchronized void addForceErrorListener(ForceErrorListener listener) {
        this.errorListeners.addElement(listener);
    }

    public synchronized boolean removeForceErrorListener(ForceErrorListener listener) {
        return this.errorListeners.removeElement(listener);
    }

    protected native void sendSurface_native();

    protected native void startSurface_native();

    protected native void stopSurface_native();

    protected native void setVertex_native(int var1, float var2, float var3, float var4);

    protected native void setNormal_native(int var1, float var2, float var3, float var4);

    protected native void setTriangle_native(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected native void removeTriangle_native(int var1);

    protected native void updateTrimeshChanges_native();

    protected native void setTrimeshTransform_native(float[] var1);

    protected native void clearTrimesh_native();

    protected native void useHcollide_native();

    protected native void useGhost_native();

    protected native boolean enableConstraint_native(int var1);

    protected native boolean setConstraintMode_native(int var1);

    protected native boolean setConstraintPoint_native(float[] var1);

    protected native boolean setConstraintLinePoint_native(float[] var1);

    protected native boolean setConstraintLineDirection_native(float[] var1);

    protected native boolean setConstraintPlanePoint_native(float[] var1);

    protected native boolean setConstraintPlaneNormal_native(float[] var1);

    protected native boolean setConstraintKSpring_native(float var1);

    protected native boolean sendForceField_native(float[] var1, float[] var2, float[][] var3, float var4);

    protected native boolean sendForceField_native();

    protected native boolean stopForceField_native();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stoppedRunning() {
        this.forceListeners.removeAllElements();
        this.scpListeners.removeAllElements();
        this.errorListeners.removeAllElements();
        Object object = downInVrpnLock;
        synchronized (object) {
            this.shutdownForceDevice();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleForceChange(long tv_sec, long tv_usec, double x, double y, double z) {
        Object object = notifyingForceListenersLock;
        synchronized (object) {
            ForceChange f = new ForceChange();
            f.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            f.force[0] = x;
            f.force[1] = y;
            f.force[2] = z;
            Enumeration e = this.forceListeners.elements();
            while (e.hasMoreElements()) {
                ForceChangeListener l = (ForceChangeListener)e.nextElement();
                l.forceUpdate(f, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSCPChange(long tv_sec, long tv_usec, double x, double y, double z, double quat0, double quat1, double quat2, double quat3) {
        Object object = notifyingSCPListenersLock;
        synchronized (object) {
            SCPChange s = new SCPChange();
            s.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            s.pos[0] = x;
            s.pos[1] = y;
            s.pos[2] = z;
            s.quat[0] = quat0;
            s.quat[1] = quat1;
            s.quat[2] = quat2;
            s.quat[3] = quat3;
            Enumeration e = this.scpListeners.elements();
            while (e.hasMoreElements()) {
                SCPChangeListener l = (SCPChangeListener)e.nextElement();
                l.scpUpdate(s, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleForceError(long tv_sec, long tv_usec, int errorCode) {
        Object object = notifyingErrorListenersLock;
        synchronized (object) {
            ForceError u = new ForceError();
            u.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            u.errorCode = errorCode;
            Enumeration e = this.errorListeners.elements();
            while (e.hasMoreElements()) {
                ForceErrorListener l = (ForceErrorListener)e.nextElement();
                l.forceError(u, this);
            }
        }
    }

    @Override
    protected native boolean init(String var1, String var2, String var3, String var4, String var5);

    protected native void shutdownForceDevice();

    @Override
    protected native void mainloop();

    public class ForceChange {
        public Date msg_time = new Date();
        public double[] force = new double[3];
    }

    public static interface ForceChangeListener {
        public void forceUpdate(ForceChange var1, ForceDeviceRemote var2);
    }

    public class ForceError {
        public Date msg_time = new Date();
        int errorCode;
    }

    public static interface ForceErrorListener {
        public void forceError(ForceError var1, ForceDeviceRemote var2);
    }

    public class SCPChange {
        public Date msg_time = new Date();
        public double[] pos = new double[3];
        public double[] quat = new double[4];
    }

    public static interface SCPChangeListener {
        public void scpUpdate(SCPChange var1, ForceDeviceRemote var2);
    }
}

