/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.awt.peer.ComponentPeer;
import java.security.AccessControlContext;
import sun.awt.AppContext;
import sun.awt.RequestFocusController;
import sun.misc.Unsafe;

public final class AWTAccessor {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static WindowAccessor windowAccessor;
    private static ComponentAccessor componentAccessor;
    private static FrameAccessor frameAccessor;
    private static AWTEventAccessor awtEventAccessor;
    private static MenuComponentAccessor menuComponentAccessor;
    private static TrayIconAccessor trayIconAccessor;

    private AWTAccessor() {
    }

    public static void setWindowAccessor(WindowAccessor windowAccessor) {
        AWTAccessor.windowAccessor = windowAccessor;
    }

    public static WindowAccessor getWindowAccessor() {
        if (windowAccessor == null) {
            unsafe.ensureClassInitialized(Window.class);
        }
        return windowAccessor;
    }

    public static void setComponentAccessor(ComponentAccessor componentAccessor) {
        AWTAccessor.componentAccessor = componentAccessor;
    }

    public static ComponentAccessor getComponentAccessor() {
        if (componentAccessor == null) {
            unsafe.ensureClassInitialized(Component.class);
        }
        return componentAccessor;
    }

    public static void setFrameAccessor(FrameAccessor frameAccessor) {
        AWTAccessor.frameAccessor = frameAccessor;
    }

    public static FrameAccessor getFrameAccessor() {
        if (frameAccessor == null) {
            unsafe.ensureClassInitialized(Frame.class);
        }
        return frameAccessor;
    }

    public static void setAWTEventAccessor(AWTEventAccessor aWTEventAccessor) {
        awtEventAccessor = aWTEventAccessor;
    }

    public static AWTEventAccessor getAWTEventAccessor() {
        if (awtEventAccessor == null) {
            unsafe.ensureClassInitialized(AWTEvent.class);
        }
        return awtEventAccessor;
    }

    public static void setMenuComponentAccessor(MenuComponentAccessor menuComponentAccessor) {
        AWTAccessor.menuComponentAccessor = menuComponentAccessor;
    }

    public static MenuComponentAccessor getMenuComponentAccessor() {
        if (menuComponentAccessor == null) {
            unsafe.ensureClassInitialized(MenuComponent.class);
        }
        return menuComponentAccessor;
    }

    public static void setTrayIconAccessor(TrayIconAccessor trayIconAccessor) {
        AWTAccessor.trayIconAccessor = trayIconAccessor;
    }

    public static TrayIconAccessor getTrayIconAccessor() {
        if (trayIconAccessor == null) {
            unsafe.ensureClassInitialized(TrayIcon.class);
        }
        return trayIconAccessor;
    }

    public static interface AWTEventAccessor {
        public void setSystemGenerated(AWTEvent var1);

        public boolean isSystemGenerated(AWTEvent var1);

        public void setPosted(AWTEvent var1);

        public AccessControlContext getAccessControlContext(AWTEvent var1);
    }

    public static interface ComponentAccessor {
        public void setBackgroundEraseDisabled(Component var1, boolean var2);

        public boolean getBackgroundEraseDisabled(Component var1);

        public void setMixingCutoutShape(Component var1, Shape var2);

        public Rectangle getBounds(Component var1);

        public void resetGC(Component var1);

        public void setRequestFocusController(RequestFocusController var1);

        public Object getPrivateKey(Component var1);

        public AppContext getAppContext(Component var1);

        public void setAppContext(Component var1, AppContext var2);

        public ComponentPeer getPeer(Component var1);

        public AccessControlContext getAccessControlContext(Component var1);
    }

    public static interface FrameAccessor {
        public void setExtendedState(Frame var1, int var2);

        public int getExtendedState(Frame var1);
    }

    public static interface MenuComponentAccessor {
        public Object getPrivateKey(MenuComponent var1);

        public AppContext getAppContext(MenuComponent var1);

        public void setAppContext(MenuComponent var1, AppContext var2);
    }

    public static interface TrayIconAccessor {
        public Object getPrivateKey(TrayIcon var1);
    }

    public static interface WindowAccessor {
        public float getOpacity(Window var1);

        public void setOpacity(Window var1, float var2);

        public Shape getShape(Window var1);

        public void setShape(Window var1, Shape var2);

        public boolean isOpaque(Window var1);

        public void setOpaque(Window var1, boolean var2);

        public void updateWindow(Window var1);

        public Dimension getSecurityWarningSize(Window var1);

        public void setSecurityWarningSize(Window var1, int var2, int var3);

        public void setSecurityWarningPosition(Window var1, Point2D var2, float var3, float var4);

        public Point2D calculateSecurityWarningPosition(Window var1, double var2, double var4, double var6, double var8);

        public void setLWRequestStatus(Window var1, boolean var2);
    }
}

