/* Copyright (c) 1997-2022
   Ewgenij Gawrilow, Michael Joswig, and the polymake team
   Technische Universität Berlin, Germany
   https://polymake.org

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version: http://www.gnu.org/licenses/gpl.txt.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
--------------------------------------------------------------------------------
*/

package de.tuberlin.polymake.graph.jreality;

import java.util.Properties;

import javax.swing.JFrame;

import de.jreality.tools.PointDragEvent;
import de.jreality.tools.PointDragListener;
import de.tuberlin.polymake.common.PolymakeControl;
import de.tuberlin.polymake.common.geometry.EmbeddedGeometries;
import de.tuberlin.polymake.common.jreality.HelpFrame;
import de.tuberlin.polymake.common.jreality.Viewer;

/**
 * @author wotzlaw
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class SpringEmbedderFrame extends de.tuberlin.polymake.graph.PolymakeSpringEmbedderFrame
		implements PointDragListener {

	/** autogenerated ID for serialization */
	private static final long serialVersionUID = -8107882223199172362L;

	public SpringEmbedderFrame(EmbeddedGeometries geom, String title,
			Properties params, Properties iparams, PolymakeControl parent) {

		super(geom, title, params, iparams, parent);

		Viewer jrv = new Viewer(geometry);
		southBox.add(jrv.getViewerAppearancePanel());
		jrv.addPointDragListener(this);
		pViewer = jrv;
		setupSpringEmbedderGUI();
	}

	// ------------------------ PointDragListener
	// -------------------------------
	public void pointDragEnd(PointDragEvent pde) {
	}

	public void pointDragStart(PointDragEvent pde) {
	}

	public void pointDragged(PointDragEvent pde) {
		double[] coords = new double[3];
		System.arraycopy(pde.getPosition(), 0, coords, 0, 3);
		geometry.moveVertex(pde.getPointSet().getName(), pde.getIndex(), coords);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.tuberlin.polymake.common.PolymakeFrame#createHelpFrame()
	 */
	// @Override
	public JFrame createHelpFrame() {
		// FIXME: Write a JRealitySpringEmbedderHelpFrame!
		return new HelpFrame();
	}

}
