/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.bounding;

public class BoundingBox {
    static final double EPS = 1.0E-14;

    protected BoundingBox() {
    }

    private static void resultIsPoint(double[] point, int dim, double[][] transform, double[] min, double[] max) {
        System.arraycopy(point, 0, min, 0, dim);
        System.arraycopy(point, 0, max, 0, dim);
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim) {
                transform[i][j] = i == j ? 1 : 0;
                ++j;
            }
            ++i;
        }
    }

    private static void gramSchmitt(double[][] basis, int k) {
        int l;
        int dim = basis.length;
        double[] n = basis[k];
        int l2 = 0;
        while (l2 < dim) {
            n[l2] = 1.0 + Math.random();
            ++l2;
        }
        int j = 0;
        while (j < k) {
            double[] m = basis[j];
            double product = 0.0;
            l = 0;
            while (l < dim) {
                product += m[l] * n[l];
                ++l;
            }
            l = 0;
            while (l < dim) {
                int n2 = l;
                n[n2] = n[n2] - product * m[l];
                ++l;
            }
            ++j;
        }
        double lengthSqr = 0.0;
        int l3 = 0;
        while (l3 < dim) {
            lengthSqr += n[l3] * n[l3];
            ++l3;
        }
        double length = Math.sqrt(lengthSqr);
        if (length < 1.0E-14) {
            throw new RuntimeException("gram schmitt failed");
        }
        l = 0;
        while (l < dim) {
            int n3 = l++;
            n[n3] = n[n3] / length;
        }
    }

    public static void compute(double[] point, int dim, double[][] transform, double[] min, double[] max) {
        if (point.length % dim != 0) {
            throw new IllegalArgumentException("length of point array is not multiple of dim");
        }
        int numOfPoints = point.length / dim;
        int k = 0;
        while (k < dim) {
            double maxProduct = 0.0;
            int maxI = 0;
            int maxJ = 1;
            int i = 0;
            while (i < numOfPoints - 1) {
                int I = dim * i;
                int j = i + 1;
                int J = j * dim;
                while (j < numOfPoints) {
                    double product = 0.0;
                    int l = 0;
                    while (l < dim) {
                        product += (point[I + l] - point[J + l]) * (point[I + l] - point[J + l]);
                        ++l;
                    }
                    if (maxProduct < product) {
                        maxProduct = product;
                        maxI = I;
                        maxJ = J;
                    }
                    ++j;
                    J += dim;
                }
                ++i;
            }
            double[] n = transform[k];
            if (maxProduct < 1.0E-14) {
                if (k == 0) {
                    BoundingBox.resultIsPoint(point, dim, transform, min, max);
                    return;
                }
                BoundingBox.gramSchmitt(transform, k);
                double maxProjection = -1.7976931348623157E308;
                double minProjection = Double.MAX_VALUE;
                int i2 = 0;
                int I = 0;
                while (i2 < numOfPoints) {
                    double product = 0.0;
                    int l = 0;
                    while (l < dim) {
                        product += point[I + l] * n[l];
                        ++l;
                    }
                    if (product < minProjection) {
                        minProjection = product;
                    }
                    if (product > maxProjection) {
                        maxProjection = product;
                    }
                    ++i2;
                    I += dim;
                }
                min[k] = minProjection;
                max[k] = maxProjection;
            } else {
                double length = Math.sqrt(maxProduct);
                int l = 0;
                while (l < dim) {
                    n[l] = (point[maxI + l] - point[maxJ + l]) / length;
                    ++l;
                }
                min[k] = 0.0;
                max[k] = 0.0;
                l = 0;
                while (l < dim) {
                    int n2 = k;
                    min[n2] = min[n2] + point[maxJ + l] * n[l];
                    int n3 = k;
                    max[n3] = max[n3] + point[maxI + l] * n[l];
                    ++l;
                }
            }
            int i3 = 0;
            int I = 0;
            while (i3 < numOfPoints) {
                double product = 0.0;
                int l = 0;
                while (l < dim) {
                    product += point[I + l] * n[l];
                    ++l;
                }
                l = 0;
                while (l < dim) {
                    int n4 = I++;
                    point[n4] = point[n4] - product * n[l];
                    ++l;
                }
                ++i3;
            }
            ++k;
        }
    }
}

