/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.rootFinding;

import de.jtem.numericalMethods.calculus.rootFinding.NewtonRaphson;

public class ExampleNewtonRaphson {
    public static void main(String[] argv) {
        NewtonRaphson.RealFunctionWithDerivative rf = new NewtonRaphson.RealFunctionWithDerivative(){

            @Override
            public void eval(double x, double[] f, int offsetF, double[] df, int offsetDF) {
                f[offsetF] = Math.sin(x);
                df[offsetDF] = Math.cos(x);
            }
        };
        double[] rootValues = new double[6];
        NewtonRaphson.search(rf, 0.6, rootValues);
        System.out.println(" root at x = " + rootValues[0]);
        System.out.println(" sin ( x ) = " + rootValues[1]);
        System.out.println(" sin'( x ) = " + rootValues[2]);
        NewtonRaphson.ComplexFunctionWithDerivative cf = new NewtonRaphson.ComplexFunctionWithDerivative(){

            @Override
            public void eval(double x, double y, double[] f, int offsetF, double[] df, int offsetDF) {
                double expY = Math.exp(y);
                double cosX = Math.cos(x);
                double sinX = Math.sin(x);
                f[offsetF] = sinX * (expY + 1.0 / expY) / 2.0;
                f[offsetF + 1] = cosX * (expY - 1.0 / expY) / 2.0;
                df[offsetDF] = cosX * (expY + 1.0 / expY) / 2.0;
                df[offsetDF + 1] = sinX * (expY - 1.0 / expY) / 2.0;
            }
        };
        NewtonRaphson.search(cf, 0.5, 0.3, rootValues);
        System.out.println(" root at z = " + rootValues[0] + " + i " + rootValues[1]);
        System.out.println(" sin ( z ) = " + rootValues[2] + " + i " + rootValues[3]);
        System.out.println(" sin'( z ) = " + rootValues[4] + " + i " + rootValues[5]);
    }
}

