/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.minimizing.Info;

public final class NelderMead {
    private static final long serialVersionUID = 1L;
    static int ITMAX = 200;
    static double rho = 1.0;
    static double chi = 2.0;
    static double gamma = 0.5;
    static double sigma = 0.5;

    public static int getITMAX() {
        return ITMAX;
    }

    public static void setITMAX(int v) {
        ITMAX = v;
    }

    public static double[][] getStandardBasis(int dim) {
        double[][] basis = new double[dim][dim];
        int i = 0;
        while (i < dim) {
            basis[i][i] = 1.0;
            ++i;
        }
        return basis;
    }

    public static final double search(double[] p, double ftol, RealFunctionOfSeveralVariables f) {
        return NelderMead.search(p, NelderMead.getStandardBasis(p.length), ftol, f, ITMAX, null);
    }

    public static final double search(double[] p, double ftol, int maxIteration, RealFunctionOfSeveralVariables f) {
        return NelderMead.search(p, NelderMead.getStandardBasis(p.length), ftol, f, maxIteration, null);
    }

    public static final double search(double[] p, double ftol, int maxIteration, RealFunctionOfSeveralVariables f, Info info) {
        return NelderMead.search(p, NelderMead.getStandardBasis(p.length), ftol, f, maxIteration, info);
    }

    public static double search(double[] p, double[][] xi, double ftol, RealFunctionOfSeveralVariables f, int itMax, Info info) {
        String action = "";
        int numberOfVariables = f.getNumberOfVariables();
        if (p.length == numberOfVariables) {
            int i;
            int iteration = 0;
            double[][] vertices = new double[numberOfVariables + 1][numberOfVariables];
            double[] evaluation = new double[numberOfVariables + 1];
            double[] meanVertex = new double[numberOfVariables];
            double[] reflected = new double[numberOfVariables];
            double[] expanded = new double[numberOfVariables];
            double[] contracted = new double[numberOfVariables];
            double evReflected = 0.0;
            double evExpanded = 0.0;
            double evContracted = 0.0;
            int j = 0;
            while (j < numberOfVariables) {
                vertices[0][j] = p[j];
                ++j;
            }
            int i2 = 0;
            while (i2 < numberOfVariables) {
                int j2 = 0;
                while (j2 < numberOfVariables) {
                    vertices[i2 + 1][j2] = p[j2];
                    ++j2;
                }
                if (vertices[i2 + 1][i2] == 0.0) {
                    double[] dArray = vertices[i2 + 1];
                    int n = i2;
                    dArray[n] = dArray[n] + 2.5E-4 * xi[i2][i2];
                } else {
                    double[] dArray = vertices[i2 + 1];
                    int n = i2;
                    dArray[n] = dArray[n] * (1.0 + 0.05 * xi[i2][i2]);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < numberOfVariables + 1) {
                evaluation[i2] = f.eval(vertices[i2]);
                ++i2;
            }
            if (info != null) {
                String s = new String(" f(p) = " + evaluation[0] + " , p = ");
                i = 0;
                while (i < vertices[0].length) {
                    s = String.valueOf(s) + vertices[0][i] + " ";
                    ++i;
                }
                info.setMessage(s);
                info.setMaxIter(itMax);
            }
            NelderMead.order(vertices, evaluation);
            while (Math.abs(evaluation[numberOfVariables] - evaluation[0]) > ftol && iteration++ < itMax && NelderMead.sizeMax(vertices) > ftol * ftol) {
                NelderMead.updateMeanVertex(meanVertex, vertices, numberOfVariables);
                i = 0;
                while (i < numberOfVariables) {
                    reflected[i] = (1.0 + rho) * meanVertex[i] - rho * vertices[numberOfVariables][i];
                    ++i;
                }
                evReflected = f.eval(reflected);
                if (evReflected < evaluation[0]) {
                    i = 0;
                    while (i < numberOfVariables) {
                        expanded[i] = (1.0 + rho * chi) * meanVertex[i] - rho * chi * vertices[numberOfVariables][i];
                        ++i;
                    }
                    evExpanded = f.eval(expanded);
                    if (evExpanded < evReflected) {
                        i = 0;
                        while (i < numberOfVariables) {
                            vertices[numberOfVariables][i] = expanded[i];
                            ++i;
                        }
                        evaluation[numberOfVariables] = evExpanded;
                        action = "Expand";
                    } else {
                        i = 0;
                        while (i < numberOfVariables) {
                            vertices[numberOfVariables][i] = reflected[i];
                            ++i;
                        }
                        evaluation[numberOfVariables] = evReflected;
                        action = "Reflection";
                    }
                } else if (evReflected >= evaluation[numberOfVariables - 1]) {
                    if (evReflected < evaluation[numberOfVariables]) {
                        i = 0;
                        while (i < numberOfVariables) {
                            contracted[i] = (1.0 + rho * gamma) * meanVertex[i] - rho * gamma * vertices[numberOfVariables][i];
                            ++i;
                        }
                        evContracted = f.eval(contracted);
                        if (evContracted <= evReflected) {
                            i = 0;
                            while (i < numberOfVariables) {
                                vertices[numberOfVariables][i] = contracted[i];
                                ++i;
                            }
                            evaluation[numberOfVariables] = evContracted;
                            action = "Outside Contraction";
                        } else {
                            NelderMead.shrink(vertices, evaluation, f);
                            action = "Shrink";
                        }
                    } else {
                        i = 0;
                        while (i < numberOfVariables) {
                            contracted[i] = (1.0 - gamma) * meanVertex[i] + gamma * vertices[numberOfVariables][i];
                            ++i;
                        }
                        evContracted = f.eval(contracted);
                        if (evContracted < evReflected) {
                            i = 0;
                            while (i < numberOfVariables) {
                                vertices[numberOfVariables][i] = contracted[i];
                                ++i;
                            }
                            evaluation[numberOfVariables] = evContracted;
                            action = "Inside contraction";
                        } else {
                            NelderMead.shrink(vertices, evaluation, f);
                            action = "Shrink";
                        }
                    }
                } else {
                    i = 0;
                    while (i < numberOfVariables) {
                        vertices[numberOfVariables][i] = reflected[i];
                        ++i;
                    }
                    evaluation[numberOfVariables] = evReflected;
                    action = "Reflection";
                }
                if (info != null) {
                    String s = new String("iter = " + iteration + ", action = " + action + ", fp = " + evaluation[0] + ", p = ");
                    i = 0;
                    while (i < vertices[0].length) {
                        s = String.valueOf(s) + vertices[0][i] + " ";
                        ++i;
                    }
                    info.addMessage(s);
                }
                NelderMead.order(vertices, evaluation);
            }
            if (Math.abs(evaluation[numberOfVariables] - evaluation[0]) <= ftol && info != null) {
                info.setCurrentIter(iteration);
                info.printDebug();
            }
            if (info != null && iteration >= itMax) {
                info.setCurrentIter(iteration);
                info.setMessage("Too many iterations in routine Nelder-Mead simplex");
                info.printDebug();
            }
            i = 0;
            while (i < p.length) {
                p[i] = vertices[0][i];
                ++i;
            }
            return evaluation[0];
        }
        System.out.println("Uncompatible number of parameters and initial point");
        return Double.NaN;
    }

    private static void order(double[][] x, double[] y) {
        double tmp = 0.0;
        int i = 1;
        while (i < y.length) {
            int j = i;
            while (j > 0) {
                if (y[j] < y[j - 1]) {
                    tmp = y[j];
                    y[j] = y[j - 1];
                    y[j - 1] = tmp;
                    int k = 0;
                    while (k < x[0].length) {
                        tmp = x[j][k];
                        x[j][k] = x[j - 1][k];
                        x[j - 1][k] = tmp;
                        ++k;
                    }
                    --j;
                    continue;
                }
                j = 0;
            }
            ++i;
        }
    }

    private static void updateMeanVertex(double[] mean, double[][] samples, int variables) {
        int i = 0;
        while (i < variables) {
            mean[i] = 0.0;
            int j = 0;
            while (j < variables) {
                int n = i;
                mean[n] = mean[n] + samples[j][i];
                ++j;
            }
            int n = i++;
            mean[n] = mean[n] / (double)variables;
        }
    }

    private static void shrink(double[][] samples, double[] functions, RealFunctionOfSeveralVariables f) {
        NelderMead.order(samples, functions);
        int i = 1;
        while (i < samples.length) {
            int j = 0;
            while (j < samples[0].length) {
                samples[i][j] = (1.0 - sigma) * samples[0][j] + sigma * samples[i][j];
                ++j;
            }
            functions[i] = f.eval(samples[i]);
            ++i;
        }
        NelderMead.order(samples, functions);
    }

    private static double sizeMax(double[][] vertices) {
        double size = 0.0;
        int i = 0;
        while (i < vertices[0].length) {
            size += (vertices[0][i] - vertices[vertices.length - 1][i]) * (vertices[0][i] - vertices[vertices.length - 1][i]);
            ++i;
        }
        return size;
    }

    private static double norm2(double[] vector) {
        double norm = 0.0;
        int i = 0;
        while (i < vector.length) {
            norm += vector[i] * vector[i];
            ++i;
        }
        return norm;
    }
}

