/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.integration;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.integration.RealVectorValuedFunctionIntegrator;
import de.jtem.numericalMethods.calculus.odeSolving.ODE;
import de.jtem.numericalMethods.calculus.odeSolving.OdeSolver;
import java.io.Serializable;

abstract class OdeSolverBasedIntegrator
implements Serializable,
RealVectorValuedFunctionIntegrator {
    private static final long serialVersionUID = 1L;
    private int numberOfFunctions;
    OdeSolver odeSolver;
    WraperFunction wf;
    double[] I;
    double startX;

    OdeSolverBasedIntegrator(OdeSolver odeSolver) {
        this.odeSolver = odeSolver;
    }

    public OdeSolver getOdeSolver() {
        return this.odeSolver;
    }

    private void changeNumberOfFunctions(int numberOfFunctions) {
        this.I = new double[numberOfFunctions];
        this.numberOfFunctions = numberOfFunctions;
    }

    public void setFunction(RealFunctionOfOneVariable f) {
        this.wf = new WraperFunction.RealFunction(f);
        this.changeNumberOfFunctions(1);
    }

    @Override
    public void setFunction(RealVectorValuedFunctionOfOneVariable f) {
        this.wf = new WraperFunction.RealFunctionSet(f);
        this.changeNumberOfFunctions(f.getDimensionOfTargetSpace());
    }

    @Override
    public void startAt(double a) {
        this.startX = a;
        int i = 0;
        while (i < this.I.length) {
            this.I[i] = 0.0;
            ++i;
        }
    }

    @Override
    public void integrateTo(double b) {
        if (this.wf == null) {
            throw new RuntimeException("no function to integrate");
        }
        this.odeSolver.setNumOfEquations(this.numberOfFunctions);
        this.odeSolver.odex(this.wf, this.I, this.startX, b);
        this.startX = b;
    }

    @Override
    public void getIntegral(double[] integral, int offset) {
        int i = 0;
        int j = offset;
        while (i < this.I.length) {
            integral[j] = this.I[i];
            ++i;
            ++j;
        }
    }

    public void integrate(double start, double end, double[] integral) {
        this.integrate(start, end, integral, 0);
    }

    public void integrate(double start, double end, double[] integral, int offset) {
        this.startAt(start);
        this.integrateTo(end);
        this.getIntegral(integral, offset);
    }

    public double integrate(double start, double end) {
        this.startAt(start);
        this.integrateTo(end);
        return this.I[0];
    }

    static abstract class WraperFunction
    implements ODE,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;

        WraperFunction() {
        }

        static class RealFunction
        extends WraperFunction {
            final RealFunctionOfOneVariable realFunctionOfOneVariable;

            RealFunction(RealFunctionOfOneVariable f) {
                this.realFunctionOfOneVariable = f;
            }

            @Override
            public int getNumberOfEquations() {
                return 1;
            }

            @Override
            public void eval(double t, double[] x, double[] y) {
                y[0] = this.realFunctionOfOneVariable.eval(t);
            }
        }

        static class RealFunctionSet
        extends WraperFunction {
            final RealVectorValuedFunctionOfOneVariable realFunctionSetOfOneVariable;

            RealFunctionSet(RealVectorValuedFunctionOfOneVariable f) {
                this.realFunctionSetOfOneVariable = f;
            }

            @Override
            public int getNumberOfEquations() {
                return this.realFunctionSetOfOneVariable.getDimensionOfTargetSpace();
            }

            @Override
            public void eval(double t, double[] x, double[] y) {
                this.realFunctionSetOfOneVariable.eval(t, y);
            }
        }
    }
}

