/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import vrpn.VRPNDevice;

public class TextReceiver
extends VRPNDevice
implements Runnable {
    protected Vector textListeners = new Vector();
    protected static final Object notifyingListenersLock = new Object();

    public TextReceiver(String name, String localInLogfileName, String localOutLogfileName, String remoteInLogfileName, String remoteOutLogfileName) throws InstantiationException {
        super(name, localInLogfileName, localOutLogfileName, remoteInLogfileName, remoteOutLogfileName);
    }

    public synchronized void addTextListener(TextMessageListener listener) {
        this.textListeners.addElement(listener);
    }

    public synchronized boolean removeTextListener(TextMessageListener listener) {
        return this.textListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stoppedRunning() {
        this.textListeners.removeAllElements();
        Object object = downInVrpnLock;
        synchronized (object) {
            this.shutdownTextReceiver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTextMessage(long tv_sec, long tv_usec, int type, int level, String msg) {
        Object object = notifyingListenersLock;
        synchronized (object) {
            TextMessage t = new TextMessage();
            t.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            t.type = type;
            t.level = level;
            t.msg = msg;
            Enumeration e = this.textListeners.elements();
            while (e.hasMoreElements()) {
                TextMessageListener l = (TextMessageListener)e.nextElement();
                l.receiveTextMessage(t, this);
            }
        }
    }

    protected native void shutdownTextReceiver();

    @Override
    protected native void mainloop();

    @Override
    protected native boolean init(String var1, String var2, String var3, String var4, String var5);

    public class TextMessage {
        public Date msg_time = new Date();
        public String msg = "";
        public int type = 0;
        public int level = 0;
    }

    public static interface TextMessageListener {
        public void receiveTextMessage(TextMessage var1, TextReceiver var2);
    }
}

