/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import vrpn.VRPNDevice;

public class AnalogRemote
extends VRPNDevice
implements Runnable {
    public static final int MAX_CHANNELS = 128;
    protected static final Object notifyingChangeListenersLock = new Object();
    protected Vector changeListeners = new Vector();

    public AnalogRemote(String name, String localInLogfileName, String localOutLogfileName, String remoteInLogfileName, String remoteOutLogfileName) throws InstantiationException {
        super(name, localInLogfileName, localOutLogfileName, remoteInLogfileName, remoteOutLogfileName);
    }

    public synchronized native int getNumActiveChannels();

    public int getMaxActiveChannels() {
        return 128;
    }

    public synchronized void addAnalogChangeListener(AnalogChangeListener listener) {
        this.changeListeners.addElement(listener);
    }

    public synchronized boolean removeAnalogChangeListener(AnalogChangeListener listener) {
        return this.changeListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAnalogChange(long tv_sec, long tv_usec, double[] channel) {
        Object object = notifyingChangeListenersLock;
        synchronized (object) {
            AnalogUpdate a = new AnalogUpdate();
            a.msg_time.setTime(tv_sec * 1000L + (long)((int)((double)tv_usec / 1000.0)));
            a.channel = (double[])channel.clone();
            Enumeration e = this.changeListeners.elements();
            while (e.hasMoreElements()) {
                AnalogChangeListener l = (AnalogChangeListener)e.nextElement();
                l.analogUpdate(a, this);
            }
        }
    }

    @Override
    protected native boolean init(String var1, String var2, String var3, String var4, String var5);

    protected native void shutdownAnalog();

    @Override
    protected native void mainloop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stoppedRunning() {
        this.changeListeners.removeAllElements();
        Object object = downInVrpnLock;
        synchronized (object) {
            this.shutdownAnalog();
        }
    }

    public static interface AnalogChangeListener {
        public void analogUpdate(AnalogUpdate var1, AnalogRemote var2);
    }

    public class AnalogUpdate {
        public Date msg_time = new Date();
        public double[] channel;
    }
}

