/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.simplecontroller.help;

import de.jtem.jrworkspace.plugin.flavor.HelpFlavor;
import de.jtem.jrworkspace.plugin.simplecontroller.help.HelpBrowser;
import de.jtem.jrworkspace.plugin.simplecontroller.image.ImageHook;
import de.jtem.jrworkspace.plugin.simplecontroller.widget.AbstractTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class HelpWindow
extends JDialog
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private Image dialogIcon = ImageHook.getImage("helpblue.png");
    private LinkedList<HelpFlavor> plugins = new LinkedList();
    private NavTreeModel navTreeModel = new NavTreeModel();
    private JTree navTree = new JTree(this.navTreeModel);
    private HelpBrowser helpBrowser = new HelpBrowser();
    private JScrollPane navScroller = new JScrollPane(this.navTree);
    private JSplitPane splitter = new JSplitPane(1, this.navScroller, this.helpBrowser);
    private Icon defaultIcon = ImageHook.getIcon("helpblue.png");

    public HelpWindow(Frame parent) {
        super(parent);
        ImageHook.setIconImage(this, this.dialogIcon);
        this.setTitle("Plugin Help Center");
        this.makeLayout();
        this.navTree.setCellRenderer(this.navTreeModel);
        this.navTree.getSelectionModel().addTreeSelectionListener(this);
    }

    private void makeLayout() {
        this.setLayout(new BorderLayout());
        this.splitter.setContinuousLayout(true);
        this.splitter.setDividerLocation(200);
        this.add((Component)this.splitter, "Center");
        this.navTree.setShowsRootHandles(true);
        this.navTree.setExpandsSelectedPaths(false);
        this.navTree.setRootVisible(false);
    }

    public void updateData() {
        this.navTreeModel.update();
        int count = this.navTree.getRowCount();
        while (count-- > 0) {
            this.navTree.expandRow(count);
        }
    }

    public boolean addHelpPlugin(HelpFlavor plugin) {
        boolean result = this.plugins.add(plugin);
        Collections.sort(this.plugins, new PageComparator());
        this.navTree.updateUI();
        return result;
    }

    public boolean removeHelpPlugin(HelpFlavor plugin) {
        boolean result = this.plugins.remove(plugin);
        this.navTree.updateUI();
        return result;
    }

    public void activateHelpPage(HelpFlavor plugin) {
        int pluginIndex = this.plugins.indexOf(plugin);
        this.navTree.setSelectionRow(pluginIndex);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        HelpFlavor plugin = (HelpFlavor)path.getLastPathComponent();
        this.helpBrowser.setDocument(plugin);
        SwingUtilities.updateComponentTreeUI(this.helpBrowser);
    }

    private class NavTreeModel
    extends AbstractTreeModel
    implements TreeCellRenderer {
        private DefaultTreeCellRenderer defaultTreeCellRenderer;

        public NavTreeModel() {
            super("Root Node");
            this.defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent == this.getRoot()) {
                return HelpWindow.this.plugins.get(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == this.getRoot()) {
                return HelpWindow.this.plugins.size();
            }
            return 0;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel l = null;
            if (value instanceof HelpFlavor) {
                HelpFlavor hf = (HelpFlavor)value;
                l = (JLabel)this.defaultTreeCellRenderer.getTreeCellRendererComponent(tree, hf.getHelpTitle(), selected, expanded, leaf, row, hasFocus);
                Icon icon = hf.getHelpIcon();
                if (icon != null) {
                    Icon i = ImageHook.scaleIcon(icon, 16, 16);
                    l.setIcon(i);
                } else {
                    l.setIcon(HelpWindow.this.defaultIcon);
                }
            } else {
                l = (JLabel)this.defaultTreeCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
            return l;
        }

        public void update() {
            this.fireTreeStructureChanged(this.getRoot());
        }

        @Override
        public Object getParent(Object o) {
            return null;
        }
    }

    private class PageComparator
    implements Comparator<HelpFlavor> {
        private PageComparator() {
        }

        @Override
        public int compare(HelpFlavor o1, HelpFlavor o2) {
            return o1.getHelpTitle().compareTo(o2.getHelpTitle());
        }
    }
}

