/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.lnfswitch.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageHook {
    public static Image getImage(String filename) {
        InputStream in = ImageHook.class.getResourceAsStream(filename);
        if (in == null) {
            return null;
        }
        BufferedImage result = null;
        try {
            result = ImageIO.read(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static Image getImage(String filename, int width, int height) {
        Image image = ImageHook.getImage(filename);
        if (image == null) {
            return null;
        }
        return image.getScaledInstance(width, height, 4);
    }

    public static Icon getIcon(String filename) {
        Image image = ImageHook.getImage(filename);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public static Icon getIcon(String filename, int width, int height) {
        Image image = ImageHook.getImage(filename, width, height);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public static Icon scaleIcon(Icon icon, int width, int height) {
        Image imageNewSize = null;
        if (icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            imageNewSize = imageIcon.getImage().getScaledInstance(width, height, 4);
        } else {
            BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconWidth(), 2);
            Graphics2D g = image.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            imageNewSize = ImageHook.scaleImage(image, width, height);
        }
        return new ImageIcon(imageNewSize);
    }

    public static Image scaleImage(Image image, int width, int height) {
        return image.getScaledInstance(4, width, height);
    }
}

