/*
 * Decompiled with CFR 0.152.
 */
package de.smrj;

import de.smrj.Broadcaster;
import de.smrj.RemoteCall;
import de.smrj.RemoteKey;
import de.smrj.RemoteObject;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Proxy;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFactory {
    Broadcaster bc;
    private static final IdentityHashMap<WeakReference<Object>, RemoteKey> refToKey = new IdentityHashMap();
    private static final WeakHashMap<Object, RemoteKey> proxyToKey = new WeakHashMap();
    private static final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private static final boolean REMOTE_GC = true;
    private int keyResolveModel;
    private static final int REMOTE_RESOLVE_WEAK = 0;
    private static final int REMOTE_RESOLVE_INSPECTION = 1;
    public static final boolean RESOLVE_KEYS = false;
    private static Logger log = Logger.getLogger("SMRJ");
    private static final Class[] NO_ARG = new Class[0];
    private final LinkedList<RemoteKey> tempKeys = new LinkedList();

    RemoteFactory(Broadcaster bc) {
        this.bc = bc;
    }

    void dispose() {
        try {
            this.disposeClients();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        refToKey.clear();
        proxyToKey.clear();
    }

    private void disposeClients() throws IOException {
        RemoteCall rc = RemoteCall.method(RemoteKey.CLIENT_FACTORY, RemoteObject.clientsDispose, null);
        this.bc.getRemoteFactory().executeRemoteCall(rc);
    }

    public <T> T createRemote(Class type) throws IOException {
        return this.createRemote(type, null, null);
    }

    public <T> T createRemote(Class type, Class[] signature, Object[] params) throws IOException {
        RemoteObject handler = new RemoteObject(this, type, signature, params);
        return (T)handler.getProxy();
    }

    public <T> T createRemoteViaStaticMethod(Class type, Class factory, String name) throws IOException {
        return this.createRemoteViaStaticMethod(type, factory, name, null, null);
    }

    public <T> T createRemoteViaStaticMethod(Class type, Class factory, String name, Class[] signature, Object[] params) throws IOException {
        RemoteObject handler = new RemoteObject(this, type, factory, name, signature, params);
        return (T)handler.getProxy();
    }

    public final Object executeRemote(Object inst, String name, Object[] param) {
        return this.executeRemote(inst.getClass(), inst, name, this.type(param), param);
    }

    public final Object executeRemote(Class cl, String name, Object[] param) {
        return this.executeRemote(cl, null, name, this.type(param), param);
    }

    public final Object executeRemote(Class cl, String name, Class[] declParam, Object[] param) {
        return this.executeRemote(cl, null, name, declParam, param);
    }

    public final Object executeRemote(Class cl, Object inst, String name, Class[] declParam, Object[] param) {
        try {
            RemoteCall rc = RemoteCall.method(null, cl.getMethod(name, declParam), param);
            return this.executeRemoteCall(rc);
        }
        catch (Exception ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    private Class[] type(Object[] param) {
        if (param == null || param.length == 0) {
            return NO_ARG;
        }
        int num = param.length;
        Class[] result = new Class[num];
        for (int ix = 0; ix < num; ++ix) {
            result[ix] = param[ix].getClass();
        }
        return result;
    }

    public final Object executeRemoteCall(RemoteCall rc) throws IOException {
        return this.bc.executeRemoteCall(rc);
    }

    public Object[] pollReleasedKeys() {
        Reference<Object> deref = refQueue.poll();
        if (deref == null) {
            return null;
        }
        this.tempKeys.clear();
        this.tempKeys.add(refToKey.get(deref));
        while ((deref = refQueue.poll()) != null) {
            this.tempKeys.add(refToKey.get(deref));
        }
        return this.tempKeys.toArray();
    }

    void registerProxy(RemoteKey key, Object proxy) {
        if (this.keyResolveModel == 0) {
            proxyToKey.put(proxy, key);
        }
        WeakReference<Object> ref = new WeakReference<Object>(proxy, refQueue);
        refToKey.put(ref, key);
    }

    Object resolveKey(Object proxy) {
        RemoteKey key;
        switch (this.keyResolveModel) {
            case 0: {
                key = proxyToKey.get(proxy);
                if (key != null) break;
                if (!(Proxy.getInvocationHandler(proxy) instanceof RemoteObject)) {
                    log.log(Level.WARNING, "Proxy Class in remote call {0}", proxy);
                    return proxy;
                }
                log.log(Level.SEVERE, "unknown SMRJProxy instance: {0}", proxy);
                throw new IllegalStateException("unknown Proxy");
            }
            case 1: {
                try {
                    RemoteObject ro = (RemoteObject)Proxy.getInvocationHandler(proxy);
                    key = ro.getKey();
                    break;
                }
                catch (ClassCastException ce) {
                    log.log(Level.WARNING, "Proxy Class in remote call {0}", proxy);
                    return proxy;
                }
            }
            default: {
                throw new IllegalStateException("unknown remote GC model");
            }
        }
        return key;
    }

    public RemoteKey getProxyKey(Object proxy) {
        return (RemoteKey)this.resolveKey(proxy);
    }
}

