/*
 * Decompiled with CFR 0.152.
 */
package de.smrj;

import de.smrj.ClientFactory;
import de.smrj.RemoteCall;
import de.smrj.RemoteObjectInputStream;
import de.smrj.RemoteThrowable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public abstract class Receiver {
    private ClientFactory clientFactory;
    private final int responseType;

    public Receiver(ClientFactory clientFactory) {
        this(1, clientFactory);
    }

    public Receiver(int responseType, ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        this.responseType = responseType;
        clientFactory.setReceiver(this);
    }

    public abstract void stop();

    protected Object executeRemoteCall(RemoteCall rc) throws RemoteThrowable {
        return this.clientFactory.executeRemoteCall(rc);
    }

    public ClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        return new RemoteObjectInputStream(is, this.clientFactory);
    }

    public final int getResponseType() {
        return this.responseType;
    }
}

